/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso.processor;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.sso.SaSsoManager;
import cn.dev33.satoken.sso.config.SaSsoServerConfig;
import cn.dev33.satoken.sso.exception.SaSsoException;
import cn.dev33.satoken.sso.message.SaSsoMessage;
import cn.dev33.satoken.sso.name.ApiName;
import cn.dev33.satoken.sso.name.ParamName;
import cn.dev33.satoken.sso.processor.SaSsoProcessorHelper;
import cn.dev33.satoken.sso.template.SaSsoServerTemplate;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.parameter.SaLogoutParameter;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;
import cn.dev33.satoken.util.SaSugar;
import java.util.Map;

public class SaSsoServerProcessor {
    public static SaSsoServerProcessor instance = new SaSsoServerProcessor();
    public SaSsoServerTemplate ssoServerTemplate = new SaSsoServerTemplate();

    public Object dister() {
        SaRequest req = SaHolder.getRequest();
        ApiName apiName = this.ssoServerTemplate.apiName;
        if (req.isPath(apiName.ssoAuth)) {
            return this.ssoAuth();
        }
        if (req.isPath(apiName.ssoDoLogin)) {
            return this.ssoDoLogin();
        }
        if (req.isPath(apiName.ssoSignout)) {
            return this.ssoSignout();
        }
        if (req.isPath(apiName.ssoPushS)) {
            return this.ssoPushS();
        }
        return "{\"msg\": \"not handle\"}";
    }

    public Object ssoAuth() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        SaSsoServerConfig cfg = this.ssoServerTemplate.getServerConfig();
        StpLogic stpLogic = this.ssoServerTemplate.getStpLogicOrGlobal();
        ParamName paramName = this.ssoServerTemplate.paramName;
        if (!stpLogic.isLogin()) {
            return this.ssoServerTemplate.strategy.notLoginView.get();
        }
        String mode = req.getParam(paramName.mode, "ticket");
        String redirect = req.getParam(paramName.redirect);
        String client = req.getParam(paramName.client);
        String redirectUrl = (String)SaSugar.get(() -> {
            if (SaFoxUtil.isEmpty((Object)redirect)) {
                if (SaFoxUtil.isEmpty((Object)cfg.getHomeRoute())) {
                    throw new SaSsoException("\u672a\u6307\u5b9a redirect \u53c2\u6570\uff0c\u4e5f\u672a\u914d\u7f6e homeRoute \u8def\u7531\uff0c\u65e0\u6cd5\u5b8c\u6210\u91cd\u5b9a\u5411\u64cd\u4f5c").setCode(30014);
                }
                return cfg.getHomeRoute();
            }
            if (mode.equals("simple")) {
                this.ssoServerTemplate.checkRedirectUrl(client, redirect);
                return redirect;
            }
            String _redirectUrl = this.ssoServerTemplate.buildRedirectUrl(client, redirect, stpLogic.getLoginId(), stpLogic.getTokenValue());
            if (cfg.getAutoRenewTimeout().booleanValue()) {
                stpLogic.renewTimeout(stpLogic.getConfigOrGlobal().getTimeout());
            }
            return _redirectUrl;
        });
        this.ssoServerTemplate.strategy.jumpToRedirectUrlNotice.run((Object)redirectUrl);
        return res.redirect(redirectUrl);
    }

    public Object ssoDoLogin() {
        SaRequest req = SaHolder.getRequest();
        ParamName paramName = this.ssoServerTemplate.paramName;
        String name = req.getParam(paramName.name);
        String pwd = req.getParam(paramName.pwd);
        return this.ssoServerTemplate.strategy.doLoginHandle.apply(name, pwd);
    }

    public Object ssoSignout() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        StpLogic stpLogic = this.ssoServerTemplate.getStpLogicOrGlobal();
        Object loginId = stpLogic.getLoginIdDefaultNull();
        boolean singleDeviceIdLogout = req.isParam(this.ssoServerTemplate.paramName.singleDeviceIdLogout, "true");
        if (SaFoxUtil.isNotEmpty((Object)loginId)) {
            SaLogoutParameter logoutParameter = stpLogic.createSaLogoutParameter();
            if (singleDeviceIdLogout) {
                logoutParameter.setDeviceId(stpLogic.getLoginDeviceId());
            }
            this.ssoServerTemplate.ssoLogout(loginId, logoutParameter, null);
        }
        return this._ssoLogoutBack(req, res);
    }

    public Object ssoPushS() {
        ParamName paramName = this.ssoServerTemplate.paramName;
        SaSsoServerConfig ssoServerConfig = this.ssoServerTemplate.getServerConfig();
        SaRequest req = SaHolder.getRequest();
        String client = req.getParam(paramName.client);
        if ("*".equals(client)) {
            return SaResult.error((String)("\u65e0\u6548 client \u6807\u8bc6\uff1a" + client));
        }
        Map paramMap = req.getParamMap();
        if (ssoServerConfig.getIsCheckSign().booleanValue()) {
            this.ssoServerTemplate.getSignTemplate(client).checkParamMap(paramMap);
        } else {
            SaSsoManager.printNoCheckSignWarningByRuntime();
        }
        SaSsoMessage message = new SaSsoMessage(paramMap);
        if (!this.ssoServerTemplate.messageHolder.hasHandle(message.getType())) {
            return SaResult.error((String)("\u672a\u80fd\u627e\u5230\u6d88\u606f\u5904\u7406\u5668\uff1a" + message.getType()));
        }
        return this.ssoServerTemplate.handleMessage(message);
    }

    public Object _ssoLogoutBack(SaRequest req, SaResponse res) {
        return SaSsoProcessorHelper.ssoLogoutBack(req, res, this.ssoServerTemplate.paramName);
    }
}

