/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso.config;

import cn.dev33.satoken.sso.config.SaSsoClientModel;
import cn.dev33.satoken.sso.template.SaSsoServerTemplate;
import cn.dev33.satoken.util.SaFoxUtil;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SaSsoServerConfig
implements Serializable {
    private static final long serialVersionUID = -6541180061782004705L;
    public String mode = "";
    public long ticketTimeout = 300L;
    public String homeRoute;
    public Boolean isSlo = true;
    public Boolean autoRenewTimeout = false;
    public int maxRegClient = 32;
    public Boolean isCheckSign = true;
    public Map<String, SaSsoClientModel> clients = new LinkedHashMap<String, SaSsoClientModel>();
    public Boolean allowAnonClient = false;
    public String allowUrl = "";
    public String secretKey;

    public SaSsoServerConfig setAllow(String ... url) {
        this.setAllowUrl(SaFoxUtil.arrayJoin((String[])url));
        return this;
    }

    public SaSsoServerConfig addClient(SaSsoClientModel client) {
        this.clients.put(client.getClient(), client);
        return this;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public long getTicketTimeout() {
        return this.ticketTimeout;
    }

    public SaSsoServerConfig setTicketTimeout(long ticketTimeout) {
        this.ticketTimeout = ticketTimeout;
        return this;
    }

    public String getAllowUrl() {
        return this.allowUrl;
    }

    public SaSsoServerConfig setAllowUrl(String allowUrl) {
        if (SaFoxUtil.isNotEmpty((Object)allowUrl)) {
            List allowUrlList = SaFoxUtil.convertStringToList((String)allowUrl);
            SaSsoServerTemplate.checkAllowUrlListStaticMethod(allowUrlList);
        }
        this.allowUrl = allowUrl;
        return this;
    }

    public String getHomeRoute() {
        return this.homeRoute;
    }

    public SaSsoServerConfig setHomeRoute(String homeRoute) {
        this.homeRoute = homeRoute;
        return this;
    }

    public Boolean getIsSlo() {
        return this.isSlo;
    }

    public SaSsoServerConfig setIsSlo(Boolean isSlo) {
        this.isSlo = isSlo;
        return this;
    }

    public Boolean getAutoRenewTimeout() {
        return this.autoRenewTimeout;
    }

    public SaSsoServerConfig setAutoRenewTimeout(Boolean autoRenewTimeout) {
        this.autoRenewTimeout = autoRenewTimeout;
        return this;
    }

    public int getMaxRegClient() {
        return this.maxRegClient;
    }

    public SaSsoServerConfig setMaxRegClient(int maxRegClient) {
        this.maxRegClient = maxRegClient;
        return this;
    }

    public Boolean getIsCheckSign() {
        return this.isCheckSign;
    }

    public SaSsoServerConfig setIsCheckSign(Boolean isCheckSign) {
        this.isCheckSign = isCheckSign;
        return this;
    }

    public Boolean getAllowAnonClient() {
        return this.allowAnonClient;
    }

    public SaSsoServerConfig setAllowAnonClient(Boolean allowAnonClient) {
        this.allowAnonClient = allowAnonClient;
        return this;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public SaSsoServerConfig setSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public Map<String, SaSsoClientModel> getClients() {
        return this.clients;
    }

    public SaSsoServerConfig setClients(Map<String, SaSsoClientModel> clients) {
        this.clients = clients;
        return this;
    }

    public String toString() {
        return "SaSsoServerConfig [mode=" + this.mode + ", ticketTimeout=" + this.ticketTimeout + ", allowUrl=" + this.allowUrl + ", homeRoute=" + this.homeRoute + ", isSlo=" + this.isSlo + ", autoRenewTimeout=" + this.autoRenewTimeout + ", maxRegClient=" + this.maxRegClient + ", isCheckSign=" + this.isCheckSign + ", allowAnonClient=" + this.allowAnonClient + ", secretKey=" + this.secretKey + ", clients=" + this.clients + "]";
    }
}

