/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.classic.model.LevelModel;
import ch.qos.logback.classic.util.LevelUtil;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;
import ch.qos.logback.tyler.base.spi.StaticImportData;
import ch.qos.logback.tyler.base.util.StringToVariableStament;
import ch.qos.logback.tyler.base.util.VariableNameUtil;

public class LevelModelHandler
extends ModelHandlerBase {
    boolean inError = false;

    public LevelModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        return new LevelModelHandler(context);
    }

    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        LevelModel levelModel = (LevelModel)model;
        TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
        Object o = mic.peekObject();
        if (!(o instanceof String)) {
            this.inError = true;
            this.addError("For element <level>, could not find a AppenderAttachableData at the top of execution stack.");
            return;
        }
        String loggerName = (String)o;
        String levelStr = levelModel.getValue();
        this.addJavaStatement(tmic, loggerName, levelStr);
    }

    void addJavaStatement(TylerModelInterpretationContext tmic, String loggerName, String levelStr) {
        String loggerVariableName = VariableNameUtil.loggerNameToVariableName(loggerName);
        boolean containsVariable = StringToVariableStament.containsVariable(levelStr);
        String levelStrPart = containsVariable ? "subst($S)" : "$S";
        tmic.addStaticImport(new StaticImportData(LevelUtil.class, "levelStringToLevel"));
        tmic.configureMethodSpecBuilder.addStatement("$N.setLevel(levelStringToLevel(" + levelStrPart + "))", new Object[]{loggerVariableName, levelStr});
    }
}

