/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.testUtil;

public class VersionUtil {
    static final int DEFAULT_GUESS = 6;

    public static int getJavaMajorVersion() {
        String javaVersionString = System.getProperty("java.version");
        int result = VersionUtil.getJavaMajorVersion(javaVersionString);
        return result;
    }

    public static int getJavaMajorVersion(String versionString) {
        if (versionString == null) {
            return 6;
        }
        if (versionString.startsWith("1.")) {
            return versionString.charAt(2) - 48;
        }
        String firstDigits = VersionUtil.extractFirstDigits(versionString);
        try {
            return Integer.parseInt(firstDigits);
        }
        catch (NumberFormatException e) {
            return 6;
        }
    }

    private static String extractFirstDigits(String versionString) {
        StringBuffer buf = new StringBuffer();
        for (char c : versionString.toCharArray()) {
            if (!Character.isDigit(c)) break;
            buf.append(c);
        }
        return buf.toString();
    }
}

