/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.spi.CyclicBufferTracker;
import ch.qos.logback.core.spi.CyclicBufferTrackerSimulator;
import ch.qos.logback.core.spi.CyclicBufferTrackerT;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScenarioBasedCyclicBufferTrackerTest {
    CyclicBufferTrackerSimulator simulator;
    CyclicBufferTrackerSimulator.Parameters parameters = new CyclicBufferTrackerSimulator.Parameters();

    void verify() {
        CyclicBufferTracker<Object> at = this.simulator.realCBTracker;
        CyclicBufferTrackerT<Object> t_at = this.simulator.t_CBTracker;
        Assert.assertEquals(t_at.liveKeysAsOrderedList(), (Object)at.liveKeysAsOrderedList());
        Assert.assertEquals(t_at.lingererKeysAsOrderedList(), (Object)at.lingererKeysAsOrderedList());
    }

    @Before
    public void setUp() {
        this.parameters.keySpaceLen = 128;
        this.parameters.maxTimestampInc = 900000;
    }

    @Test
    public void shortTest() {
        this.parameters.keySpaceLen = 64;
        this.parameters.maxTimestampInc = 500;
        this.parameters.simulationLength = 70;
        this.simulator = new CyclicBufferTrackerSimulator(this.parameters);
        this.simulator.buildScenario();
        this.simulator.simulate();
        this.verify();
    }

    @Test
    public void mediumTest() {
        this.parameters.simulationLength = 20000;
        this.simulator = new CyclicBufferTrackerSimulator(this.parameters);
        this.simulator.buildScenario();
        this.simulator.simulate();
        this.verify();
    }

    @Test
    public void longTest() {
        this.parameters.simulationLength = 100000;
        this.simulator = new CyclicBufferTrackerSimulator(this.parameters);
        this.simulator.buildScenario();
        this.simulator.simulate();
        this.verify();
    }
}

