/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.server;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.net.mock.MockContext;
import ch.qos.logback.core.net.server.MockEventQueue;
import ch.qos.logback.core.net.server.RemoteReceiverStreamClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RemoteReceiverStreamClientTest {
    private static final String TEST_EVENT = "test event";
    private MockContext context = new MockContext();
    private MockEventQueue queue = new MockEventQueue();
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private RemoteReceiverStreamClient client = new RemoteReceiverStreamClient("someId", (OutputStream)this.outputStream);

    @Before
    public void setUp() throws Exception {
        this.client.setContext((Context)this.context);
        this.client.setQueue((BlockingQueue)this.queue);
    }

    @Test
    public void testOfferEventAndRun() throws Exception {
        this.client.offer((Serializable)((Object)TEST_EVENT));
        Thread thread = new Thread((Runnable)this.client);
        thread.start();
        thread.join(1000L);
        Assert.assertFalse((boolean)thread.isAlive());
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(this.outputStream.toByteArray()));
        Assert.assertEquals((Object)TEST_EVENT, (Object)ois.readObject());
    }

    @Test
    public void testOfferEventSequenceAndRun() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.client.offer((Serializable)((Object)(TEST_EVENT + i)));
        }
        Thread thread = new Thread((Runnable)this.client);
        thread.start();
        thread.join(1000L);
        Assert.assertFalse((boolean)thread.isAlive());
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(this.outputStream.toByteArray()));
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)(TEST_EVENT + i), (Object)ois.readObject());
        }
    }
}

