/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.boolex;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.boolex.Matcher;
import junit.framework.TestCase;

public class MatcherTest
extends TestCase {
    Context context;
    Matcher matcher;

    public void setUp() throws Exception {
        this.context = new ContextBase();
        this.matcher = new Matcher();
        this.matcher.setContext(this.context);
        this.matcher.setName("testMatcher");
        super.setUp();
    }

    public void tearDown() throws Exception {
        this.matcher = null;
        super.tearDown();
    }

    public void testFullRegion() throws Exception {
        this.matcher.setRegex(".*test.*");
        this.matcher.start();
        MatcherTest.assertTrue((boolean)this.matcher.matches("test"));
        MatcherTest.assertTrue((boolean)this.matcher.matches("xxxxtest"));
        MatcherTest.assertTrue((boolean)this.matcher.matches("testxxxx"));
        MatcherTest.assertTrue((boolean)this.matcher.matches("xxxxtestxxxx"));
    }

    public void testPartRegion() throws Exception {
        this.matcher.setRegex("test");
        this.matcher.start();
        MatcherTest.assertTrue((boolean)this.matcher.matches("test"));
        MatcherTest.assertTrue((boolean)this.matcher.matches("xxxxtest"));
        MatcherTest.assertTrue((boolean)this.matcher.matches("testxxxx"));
        MatcherTest.assertTrue((boolean)this.matcher.matches("xxxxtestxxxx"));
    }

    public void testCaseInsensitive() throws Exception {
        this.matcher.setRegex("test");
        this.matcher.setCaseSensitive(false);
        this.matcher.start();
        MatcherTest.assertTrue((boolean)this.matcher.matches("TEST"));
        MatcherTest.assertTrue((boolean)this.matcher.matches("tEst"));
        MatcherTest.assertTrue((boolean)this.matcher.matches("tESt"));
        MatcherTest.assertTrue((boolean)this.matcher.matches("TesT"));
    }

    public void testCaseSensitive() throws Exception {
        this.matcher.setRegex("test");
        this.matcher.setCaseSensitive(true);
        this.matcher.start();
        MatcherTest.assertFalse((boolean)this.matcher.matches("TEST"));
        MatcherTest.assertFalse((boolean)this.matcher.matches("tEst"));
        MatcherTest.assertFalse((boolean)this.matcher.matches("tESt"));
        MatcherTest.assertFalse((boolean)this.matcher.matches("TesT"));
    }
}

