/*
 * Decompiled with CFR 0.152.
 */
package io.provis.action.artifact.alter;

import io.provis.MavenProvisioner;
import io.provis.action.artifact.alter.Delete;
import io.provis.action.artifact.alter.Insert;
import io.provis.model.ProvisioArtifact;
import io.provis.model.ProvisioningAction;
import io.provis.model.ProvisioningContext;
import io.provis.perms.PosixModes;
import io.tesla.proviso.archive.Archiver;
import io.tesla.proviso.archive.UnArchiver;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import javax.inject.Named;
import org.codehaus.plexus.util.FileUtils;

@Named(value="insert")
public class AlterAction
implements ProvisioningAction {
    private List<Insert> inserts;
    private List<Delete> deletes;
    private ProvisioArtifact artifact;
    private File outputDirectory;
    private MavenProvisioner provisioner;

    public void execute(ProvisioningContext context) {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        File archive = this.artifact.getFile();
        try {
            UnArchiver unarchiver = UnArchiver.builder().build();
            File unpackDirectory = new File(this.outputDirectory, "unpack");
            unarchiver.unarchive(archive, unpackDirectory);
            if (this.inserts != null) {
                for (Insert insert : this.inserts) {
                    for (ProvisioArtifact insertArtifact : insert.getArtifacts()) {
                        this.provisioner.resolveArtifact(context, insertArtifact);
                        File source = insertArtifact.getFile();
                        File target = new File(unpackDirectory, insertArtifact.getName());
                        com.google.common.io.Files.copy((File)source, (File)target);
                    }
                }
            }
            if (this.deletes != null) {
                for (Delete delete : this.deletes) {
                    for (io.provis.model.File fileModel : delete.getFiles()) {
                        File target = new File(unpackDirectory, fileModel.getPath());
                        FileUtils.forceDelete((File)target);
                    }
                }
            }
            this.setFilesReadable(unpackDirectory);
            Archiver archiver = Archiver.builder().useRoot(false).build();
            File alteredArtifact = new File(this.outputDirectory, this.artifact.getName());
            archiver.archive(alteredArtifact, new File[]{unpackDirectory});
            FileUtils.deleteDirectory((File)unpackDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void setFilesReadable(File directory) throws IOException {
        Files.walkFileTree(directory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                AlterAction.this.setPermissionsOn(path, 493);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException exc) throws IOException {
                AlterAction.this.setPermissionsOn(path, 493);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    void setPermissionsOn(Path p, int intMode) throws IOException {
        if (File.pathSeparatorChar == ';') {
            return;
        }
        Files.setPosixFilePermissions(p, PosixModes.intModeToPosix(intMode));
    }

    public List<Insert> getInserts() {
        return this.inserts;
    }

    public void setInserts(List<Insert> inserts) {
        this.inserts = inserts;
    }

    public List<Delete> getDeletes() {
        return this.deletes;
    }

    public void setDeletes(List<Delete> deletes) {
        this.deletes = deletes;
    }

    public ProvisioArtifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(ProvisioArtifact artifact) {
        this.artifact = artifact;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public MavenProvisioner getProvisioner() {
        return this.provisioner;
    }

    public void setProvisioner(MavenProvisioner provisioner) {
        this.provisioner = provisioner;
    }
}

