/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.CNE;
import ca.uhn.hl7v2.model.v25.datatype.CWE;
import ca.uhn.hl7v2.model.v25.datatype.EI;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.PL;
import ca.uhn.hl7v2.model.v25.datatype.SI;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.datatype.XAD;
import ca.uhn.hl7v2.model.v25.datatype.XCN;
import ca.uhn.hl7v2.model.v25.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class BPX
extends AbstractSegment {
    public BPX(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID _ BPX");
            this.add(CWE.class, true, 1, 250, new Object[]{this.getMessage()}, "BP Dispense Status");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(511)}, "BP Status");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "BP Date/Time of Status");
            this.add(EI.class, false, 1, 22, new Object[]{this.getMessage()}, "BC Donation ID");
            this.add(CNE.class, false, 1, 250, new Object[]{this.getMessage()}, "BC Component");
            this.add(CNE.class, false, 1, 250, new Object[]{this.getMessage()}, "BC Donation Type / Intended Use");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "CP Commercial Product");
            this.add(XON.class, false, 1, 250, new Object[]{this.getMessage()}, "CP Manufacturer");
            this.add(EI.class, false, 1, 22, new Object[]{this.getMessage()}, "CP Lot Number");
            this.add(CNE.class, false, 1, 250, new Object[]{this.getMessage()}, "BP Blood Group");
            this.add(CNE.class, false, 0, 250, new Object[]{this.getMessage()}, "BC Special Testing");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "BP Expiration Date/Time");
            this.add(NM.class, true, 1, 5, new Object[]{this.getMessage()}, "BP Quantity");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "BP Amount");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "BP Units");
            this.add(EI.class, false, 1, 22, new Object[]{this.getMessage()}, "BP Unique ID");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "BP Actual Dispensed To Location");
            this.add(XAD.class, false, 1, 250, new Object[]{this.getMessage()}, "BP Actual Dispensed To Address");
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage()}, "BP Dispensed to Receiver");
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage()}, "BP Dispensing Individual");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating BPX - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDBPX() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getBpx1_SetIDBPX() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getBPDispenseStatus() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getBpx2_BPDispenseStatus() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getBPStatus() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getBpx3_BPStatus() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getBPDateTimeOfStatus() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getBpx4_BPDateTimeOfStatus() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getBCDonationID() {
        EI retVal = (EI)this.getTypedField(5, 0);
        return retVal;
    }

    public EI getBpx5_BCDonationID() {
        EI retVal = (EI)this.getTypedField(5, 0);
        return retVal;
    }

    public CNE getBCComponent() {
        CNE retVal = (CNE)this.getTypedField(6, 0);
        return retVal;
    }

    public CNE getBpx6_BCComponent() {
        CNE retVal = (CNE)this.getTypedField(6, 0);
        return retVal;
    }

    public CNE getBCDonationTypeIntendedUse() {
        CNE retVal = (CNE)this.getTypedField(7, 0);
        return retVal;
    }

    public CNE getBpx7_BCDonationTypeIntendedUse() {
        CNE retVal = (CNE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getCPCommercialProduct() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getBpx8_CPCommercialProduct() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public XON getCPManufacturer() {
        XON retVal = (XON)this.getTypedField(9, 0);
        return retVal;
    }

    public XON getBpx9_CPManufacturer() {
        XON retVal = (XON)this.getTypedField(9, 0);
        return retVal;
    }

    public EI getCPLotNumber() {
        EI retVal = (EI)this.getTypedField(10, 0);
        return retVal;
    }

    public EI getBpx10_CPLotNumber() {
        EI retVal = (EI)this.getTypedField(10, 0);
        return retVal;
    }

    public CNE getBPBloodGroup() {
        CNE retVal = (CNE)this.getTypedField(11, 0);
        return retVal;
    }

    public CNE getBpx11_BPBloodGroup() {
        CNE retVal = (CNE)this.getTypedField(11, 0);
        return retVal;
    }

    public CNE[] getBCSpecialTesting() {
        CNE[] retVal = (CNE[])this.getTypedField(12, (Type[])new CNE[0]);
        return retVal;
    }

    public CNE[] getBpx12_BCSpecialTesting() {
        CNE[] retVal = (CNE[])this.getTypedField(12, (Type[])new CNE[0]);
        return retVal;
    }

    public int getBCSpecialTestingReps() {
        return this.getReps(12);
    }

    public CNE getBCSpecialTesting(int rep) {
        CNE retVal = (CNE)this.getTypedField(12, rep);
        return retVal;
    }

    public CNE getBpx12_BCSpecialTesting(int rep) {
        CNE retVal = (CNE)this.getTypedField(12, rep);
        return retVal;
    }

    public int getBpx12_BCSpecialTestingReps() {
        return this.getReps(12);
    }

    public CNE insertBCSpecialTesting(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(12, rep);
    }

    public CNE insertBpx12_BCSpecialTesting(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(12, rep);
    }

    public CNE removeBCSpecialTesting(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(12, rep);
    }

    public CNE removeBpx12_BCSpecialTesting(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(12, rep);
    }

    public TS getBPExpirationDateTime() {
        TS retVal = (TS)this.getTypedField(13, 0);
        return retVal;
    }

    public TS getBpx13_BPExpirationDateTime() {
        TS retVal = (TS)this.getTypedField(13, 0);
        return retVal;
    }

    public NM getBPQuantity() {
        NM retVal = (NM)this.getTypedField(14, 0);
        return retVal;
    }

    public NM getBpx14_BPQuantity() {
        NM retVal = (NM)this.getTypedField(14, 0);
        return retVal;
    }

    public NM getBPAmount() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public NM getBpx15_BPAmount() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getBPUnits() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getBpx16_BPUnits() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public EI getBPUniqueID() {
        EI retVal = (EI)this.getTypedField(17, 0);
        return retVal;
    }

    public EI getBpx17_BPUniqueID() {
        EI retVal = (EI)this.getTypedField(17, 0);
        return retVal;
    }

    public PL getBPActualDispensedToLocation() {
        PL retVal = (PL)this.getTypedField(18, 0);
        return retVal;
    }

    public PL getBpx18_BPActualDispensedToLocation() {
        PL retVal = (PL)this.getTypedField(18, 0);
        return retVal;
    }

    public XAD getBPActualDispensedToAddress() {
        XAD retVal = (XAD)this.getTypedField(19, 0);
        return retVal;
    }

    public XAD getBpx19_BPActualDispensedToAddress() {
        XAD retVal = (XAD)this.getTypedField(19, 0);
        return retVal;
    }

    public XCN getBPDispensedToReceiver() {
        XCN retVal = (XCN)this.getTypedField(20, 0);
        return retVal;
    }

    public XCN getBpx20_BPDispensedToReceiver() {
        XCN retVal = (XCN)this.getTypedField(20, 0);
        return retVal;
    }

    public XCN getBPDispensingIndividual() {
        XCN retVal = (XCN)this.getTypedField(21, 0);
        return retVal;
    }

    public XCN getBpx21_BPDispensingIndividual() {
        XCN retVal = (XCN)this.getTypedField(21, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(511));
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new EI(this.getMessage());
            }
            case 5: {
                return new CNE(this.getMessage());
            }
            case 6: {
                return new CNE(this.getMessage());
            }
            case 7: {
                return new CWE(this.getMessage());
            }
            case 8: {
                return new XON(this.getMessage());
            }
            case 9: {
                return new EI(this.getMessage());
            }
            case 10: {
                return new CNE(this.getMessage());
            }
            case 11: {
                return new CNE(this.getMessage());
            }
            case 12: {
                return new TS(this.getMessage());
            }
            case 13: {
                return new NM(this.getMessage());
            }
            case 14: {
                return new NM(this.getMessage());
            }
            case 15: {
                return new CE(this.getMessage());
            }
            case 16: {
                return new EI(this.getMessage());
            }
            case 17: {
                return new PL(this.getMessage());
            }
            case 18: {
                return new XAD(this.getMessage());
            }
            case 19: {
                return new XCN(this.getMessage());
            }
            case 20: {
                return new XCN(this.getMessage());
            }
        }
        return null;
    }
}

