/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.PPT_PCL_PATHWAY;
import ca.uhn.hl7v2.model.v25.group.PPT_PCL_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v25.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class PPT_PCL_PATIENT
extends AbstractGroup {
    public PPT_PCL_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(PPT_PCL_PATIENT_VISIT.class, false, false, false);
            this.add(PPT_PCL_PATHWAY.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PPT_PCL_PATIENT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public PID getPID() {
        PID retVal = (PID)this.getTyped("PID", PID.class);
        return retVal;
    }

    public PPT_PCL_PATIENT_VISIT getPATIENT_VISIT() {
        PPT_PCL_PATIENT_VISIT retVal = (PPT_PCL_PATIENT_VISIT)this.getTyped("PATIENT_VISIT", PPT_PCL_PATIENT_VISIT.class);
        return retVal;
    }

    public PPT_PCL_PATHWAY getPATHWAY() {
        PPT_PCL_PATHWAY retVal = (PPT_PCL_PATHWAY)this.getTyped("PATHWAY", PPT_PCL_PATHWAY.class);
        return retVal;
    }

    public PPT_PCL_PATHWAY getPATHWAY(int rep) {
        PPT_PCL_PATHWAY retVal = (PPT_PCL_PATHWAY)this.getTyped("PATHWAY", rep, PPT_PCL_PATHWAY.class);
        return retVal;
    }

    public int getPATHWAYReps() {
        return this.getReps("PATHWAY");
    }

    public List<PPT_PCL_PATHWAY> getPATHWAYAll() throws HL7Exception {
        return this.getAllAsList("PATHWAY", PPT_PCL_PATHWAY.class);
    }

    public void insertPATHWAY(PPT_PCL_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY", (Structure)structure, rep);
    }

    public PPT_PCL_PATHWAY insertPATHWAY(int rep) throws HL7Exception {
        return (PPT_PCL_PATHWAY)super.insertRepetition("PATHWAY", rep);
    }

    public PPT_PCL_PATHWAY removePATHWAY(int rep) throws HL7Exception {
        return (PPT_PCL_PATHWAY)super.removeRepetition("PATHWAY", rep);
    }
}

