/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 * 
 * The contents of this file are subject to the Mozilla Public License Version 1.1 
 * (the "License"); you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.mozilla.org/MPL/ 
 * Software distributed under the License is distributed on an "AS IS" basis, 
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the 
 * specific language governing rights and limitations under the License. 
 * 
 * The Original Code is "[file_name]".  Description: 
 * "[one_line_description]" 
 * 
 * The Initial Developer of the Original Code is University Health Network. Copyright (C) 
 * 2012.  All Rights Reserved. 
 * 
 * Contributor(s): ______________________________________. 
 * 
 * Alternatively, the contents of this file may be used under the terms of the 
 * GNU General Public License (the  "GPL"), in which case the provisions of the GPL are 
 * applicable instead of those above.  If you wish to allow use of your version of this 
 * file only under the terms of the GPL and not to allow others to use your version 
 * of this file under the MPL, indicate your decision by deleting  the provisions above 
 * and replace  them with the notice and other provisions required by the GPL License.  
 * If you do not delete the provisions above, a recipient may use your version of 
 * this file under either the MPL or the GPL. 
 * 
 */


package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.model.v24.group.*;
import ca.uhn.hl7v2.model.v24.segment.*;

import java.util.List;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a EAN_U09 message structure (see chapter 13). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message Header) <b> </b></li>
                 * <li>2: EQU (Equipment Detail) <b> </b></li>
                 * <li>3: EAN_U09_NOTIFICATION (a Group object) <b> repeating</b></li>
                 * <li>4: ROL (Role) <b>optional </b></li>
 * </ul>
 */
@SuppressWarnings("unused")
public class EAN_U09 extends AbstractMessage  {

    /**
     * Creates a new EAN_U09 message with DefaultModelClassFactory. 
     */ 
    public EAN_U09() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new EAN_U09 message with custom ModelClassFactory.
     */
    public EAN_U09(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(EQU.class, true, false);
                          this.add(EAN_U09_NOTIFICATION.class, true, true);
                          this.add(ROL.class, false, false);
       } catch(HL7Exception e) {
          log.error("Unexpected error creating EAN_U09 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.4"
     */
    public String getVersion() {
       return "2.4";
    }



    /**
     * Returns
     * MSH (Message Header) - creates it if necessary
     */
    public MSH getMSH() { 
       return getTyped("MSH", MSH.class);
    }




    /**
     * Returns
     * EQU (Equipment Detail) - creates it if necessary
     */
    public EQU getEQU() { 
       return getTyped("EQU", EQU.class);
    }




    /**
     * Returns
     * the first repetition of 
     * NOTIFICATION (a Group object) - creates it if necessary
     */
    public EAN_U09_NOTIFICATION getNOTIFICATION() { 
       return getTyped("NOTIFICATION", EAN_U09_NOTIFICATION.class);
    }


    /**
     * Returns a specific repetition of
     * NOTIFICATION (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public EAN_U09_NOTIFICATION getNOTIFICATION(int rep) { 
       return getTyped("NOTIFICATION", rep, EAN_U09_NOTIFICATION.class);
    }

    /** 
     * Returns the number of existing repetitions of NOTIFICATION 
     */ 
    public int getNOTIFICATIONReps() { 
    	return getReps("NOTIFICATION");
    } 

    /** 
     * <p>
     * Returns a non-modifiable List containing all current existing repetitions of NOTIFICATION.
     * <p>
     * <p>
     * Note that unlike {@link #getNOTIFICATION()}, this method will not create any reps
     * if none are already present, so an empty list may be returned.
     * </p>
     */ 
    public List<EAN_U09_NOTIFICATION> getNOTIFICATIONAll() throws HL7Exception {
    	return getAllAsList("NOTIFICATION", EAN_U09_NOTIFICATION.class);
    } 

    /**
     * Inserts a specific repetition of NOTIFICATION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertNOTIFICATION(EAN_U09_NOTIFICATION structure, int rep) throws HL7Exception { 
       super.insertRepetition( "NOTIFICATION", structure, rep);
    }


    /**
     * Inserts a specific repetition of NOTIFICATION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public EAN_U09_NOTIFICATION insertNOTIFICATION(int rep) throws HL7Exception { 
       return (EAN_U09_NOTIFICATION)super.insertRepetition("NOTIFICATION", rep);
    }


    /**
     * Removes a specific repetition of NOTIFICATION (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public EAN_U09_NOTIFICATION removeNOTIFICATION(int rep) throws HL7Exception { 
       return (EAN_U09_NOTIFICATION)super.removeRepetition("NOTIFICATION", rep);
    }



    /**
     * Returns
     * ROL (Role) - creates it if necessary
     */
    public ROL getROL() { 
       return getTyped("ROL", ROL.class);
    }




}

