/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.npm.IPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.npm.PackageClient;
import org.hl7.fhir.utilities.npm.PackageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePackageCacheManager
implements IPackageCacheManager {
    private static final Logger ourLog = LoggerFactory.getLogger(BasePackageCacheManager.class);
    private List<String> myPackageServers = new ArrayList<String>();
    private Function<String, PackageClient> myClientFactory = address -> new PackageClient((String)address);
    protected boolean silent;

    public void setClientFactory(Function<String, PackageClient> theClientFactory) {
        Validate.notNull(theClientFactory, (String)"theClientFactory must not be null", (Object[])new Object[0]);
        this.myClientFactory = theClientFactory;
    }

    public List<String> getPackageServers() {
        return this.myPackageServers;
    }

    public void addPackageServer(@Nonnull String thePackageServer) {
        Validate.notBlank((CharSequence)thePackageServer, (String)"thePackageServer must not be null or empty", (Object[])new Object[0]);
        if (!this.myPackageServers.contains(thePackageServer)) {
            this.myPackageServers.add(thePackageServer);
        }
    }

    public NpmPackage loadPackageFromCacheOnly(String id) throws IOException {
        return this.loadPackageFromCacheOnly(id, null);
    }

    @Nullable
    protected InputStreamWithSrc loadFromPackageServer(String id, String version) {
        for (String nextPackageServer : this.getPackageServers()) {
            if (!this.okToUsePackageServer(nextPackageServer, id)) continue;
            PackageClient packageClient = this.myClientFactory.apply(nextPackageServer);
            try {
                if (Utilities.noString(version)) {
                    version = packageClient.getLatestVersion(id);
                }
                if (version.endsWith(".x")) {
                    version = packageClient.getLatestVersion(id, version);
                }
                InputStream stream = packageClient.fetch(id, version);
                String url = packageClient.url(id, version);
                return new InputStreamWithSrc(stream, url, version);
            }
            catch (IOException e) {
                if (this.silent) continue;
                ourLog.info("Failed to resolve package {}#{} from server: {} ({})", new Object[]{id, version, nextPackageServer, e.getMessage()});
            }
        }
        return null;
    }

    private boolean okToUsePackageServer(String server, String id) {
        return !"http://packages.fhir.org".equals(server) || !"hl7.fhir.r2b.core".equals(id);
    }

    public abstract NpmPackage loadPackageFromCacheOnly(String var1, @Nullable String var2) throws IOException;

    @Override
    public String getPackageUrl(String packageId) throws IOException {
        String result = null;
        NpmPackage npm = this.loadPackageFromCacheOnly(packageId);
        if (npm != null) {
            return npm.canonical();
        }
        for (String nextPackageServer : this.getPackageServers()) {
            result = this.getPackageUrl(packageId, nextPackageServer);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    private String getPackageUrl(String packageId, String server) throws IOException {
        PackageClient pc = this.myClientFactory.apply(server);
        List<PackageInfo> res = pc.search(packageId, null, null, false);
        if (res.size() == 0) {
            return null;
        }
        return res.get(0).getUrl();
    }

    @Override
    public String getPackageId(String canonicalUrl) throws IOException {
        String nextPackageServer;
        String result = null;
        Iterator<String> iterator = this.getPackageServers().iterator();
        while (iterator.hasNext() && (result = this.getPackageId(canonicalUrl, nextPackageServer = iterator.next())) == null) {
        }
        return result;
    }

    private String getPackageId(String canonical, String server) throws IOException {
        if (canonical == null) {
            return null;
        }
        PackageClient pc = this.myClientFactory.apply(server);
        List<PackageInfo> res = pc.search(null, canonical, null, false);
        if (res.size() == 0) {
            return null;
        }
        for (PackageInfo pi : res) {
            if (!canonical.equals(pi.getCanonical())) continue;
            return pi.getId();
        }
        return res.get(0).getId();
    }

    @Override
    public NpmPackage loadPackage(String idAndVer) throws FHIRException, IOException {
        return this.loadPackage(idAndVer, null);
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public class InputStreamWithSrc {
        public InputStream stream;
        public String url;
        public String version;

        public InputStreamWithSrc(InputStream stream, String url, String version) {
            this.stream = stream;
            this.url = url;
            this.version = version;
        }
    }
}

