/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import com.github.rjeschke.txtmark.Processor;
import java.util.Collections;
import java.util.Set;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;

public class MarkDownProcessor {
    private Dialect dialect;

    public MarkDownProcessor(Dialect dialect) {
        this.dialect = dialect;
    }

    public String process(String source, String context) {
        if (source == null) {
            return null;
        }
        if ("".equals(source)) {
            return "";
        }
        switch (this.dialect) {
            case DARING_FIREBALL: {
                return Processor.process((String)source);
            }
            case COMMON_MARK: {
                return this.processCommonMark(MarkDownProcessor.preProcess(source));
            }
        }
        throw new Error("Unknown Markdown Dialect: " + this.dialect.toString() + " at " + context);
    }

    public static String preProcess(String source) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            char next;
            char last = i > 0 ? source.charAt(i - 1) : (char)'\u0000';
            char current = source.charAt(i);
            char c = next = i < source.length() - 1 ? source.charAt(i + 1) : (char)'\u0000';
            if (current == '<' && Character.isAlphabetic(next) && last != '\\') {
                b.append('\\');
                b.append(current);
                continue;
            }
            b.append(current);
        }
        return b.toString();
    }

    private String processCommonMark(String source) {
        Set<Extension> extensions = Collections.singleton(TablesExtension.create());
        Parser parser = Parser.builder().extensions(extensions).build();
        Node document = parser.parse(source);
        HtmlRenderer renderer = HtmlRenderer.builder().escapeHtml(true).extensions(extensions).build();
        String html = renderer.render(document);
        html = html.replace("<table>", "<table class=\"grid\">");
        return html;
    }

    public static boolean isSimpleMarkdown(String description) {
        return !description.contains("\n");
    }

    public static enum Dialect {
        DARING_FIREBALL,
        COMMON_MARK;

    }
}

