/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;

public interface ValueSetChecker {
    public Boolean codeInValueSet(String var1, String var2, String var3, ValidationProcessInfo var4) throws ValueSetExpander.ETooCostly, EOperationOutcome, Exception;

    public static class ValidationProcessInfo {
        private ValueSetExpander.TerminologyServiceErrorClass err;
        private List<OperationOutcome.OperationOutcomeIssueComponent> issues = new ArrayList<OperationOutcome.OperationOutcomeIssueComponent>();

        public ValueSetExpander.TerminologyServiceErrorClass getErr() {
            return this.err;
        }

        public void setErr(ValueSetExpander.TerminologyServiceErrorClass err) {
            this.err = err;
        }

        public List<OperationOutcome.OperationOutcomeIssueComponent> getIssues() {
            return this.issues;
        }

        public void addIssue(List<OperationOutcome.OperationOutcomeIssueComponent> issues) {
            issues.addAll(issues);
        }

        public boolean hasErrors() {
            for (OperationOutcome.OperationOutcomeIssueComponent issue : this.issues) {
                if (issue.getSeverity() != OperationOutcome.IssueSeverity.FATAL && issue.getSeverity() != OperationOutcome.IssueSeverity.ERROR) continue;
                return true;
            }
            return false;
        }

        public String summary() {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder("; ");
            for (OperationOutcome.OperationOutcomeIssueComponent issue : this.issues) {
                b.append(issue.getDetails().getText());
            }
            return b.toString();
        }
    }
}

