/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.utils;

import java.io.IOException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.profile.ProfileKnowledgeProvider;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public class RenderingContext {
    private IWorkerContext worker;
    private MarkDownProcessor markdown;
    private ResourceRendererMode mode;
    private GenerationRules rules;
    private Resolver.IReferenceResolver resolver;
    private ILiquidTemplateProvider templateProvider;
    private FHIRPathEngine.IEvaluationContext services;
    private ITypeParser parser;
    private String lang;
    private String localPrefix;
    private int headerLevelContext;
    private boolean canonicalUrlsAsLinks;
    private boolean pretty;
    private boolean header;
    private boolean contained;
    private ValidationOptions terminologyServiceOptions = new ValidationOptions(new String[0]);
    private boolean noSlowLookup;
    private String tooCostlyNoteEmpty;
    private String tooCostlyNoteNotEmpty;
    private String tooCostlyNoteEmptyDependent;
    private String tooCostlyNoteNotEmptyDependent;
    private List<String> codeSystemPropList = new ArrayList<String>();
    private ProfileUtilities profileUtilitiesR;
    private String definitionsTarget;
    private String destDir;
    private boolean inlineGraphics;
    private StandardsStatus defaultStandardsStatus;
    private QuestionnaireRendererMode questionnaireMode = QuestionnaireRendererMode.FORM;
    private StructureDefinitionRendererMode structureMode = StructureDefinitionRendererMode.SUMMARY;
    private boolean addGeneratedNarrativeHeader = true;
    private boolean showComments = false;
    private FhirPublication targetVersion;
    private Locale locale;
    private ZoneId timeZoneId;
    private DateTimeFormatter dateTimeFormat;
    private DateTimeFormatter dateFormat;
    private DateTimeFormatter dateYearFormat;
    private DateTimeFormatter dateYearMonthFormat;
    private boolean copyButton;
    private ProfileKnowledgeProvider pkp;
    private Map<KnownLinkType, String> links = new HashMap<KnownLinkType, String>();

    public RenderingContext(IWorkerContext worker, MarkDownProcessor markdown, ValidationOptions terminologyServiceOptions, String specLink, String localPrefix, String lang, ResourceRendererMode mode, GenerationRules rules) {
        this.worker = worker;
        this.markdown = markdown;
        this.lang = lang;
        this.links.put(KnownLinkType.SPEC, specLink);
        this.localPrefix = localPrefix;
        this.mode = mode;
        this.rules = rules;
        if (terminologyServiceOptions != null) {
            this.terminologyServiceOptions = terminologyServiceOptions;
        }
        this.locale = new Locale.Builder().setLanguageTag("en-US").build();
    }

    public RenderingContext copy() {
        RenderingContext res = new RenderingContext(this.worker, this.markdown, this.terminologyServiceOptions, this.getLink(KnownLinkType.SPEC), this.localPrefix, this.lang, this.mode, this.rules);
        res.resolver = this.resolver;
        res.templateProvider = this.templateProvider;
        res.services = this.services;
        res.parser = this.parser;
        res.headerLevelContext = this.headerLevelContext;
        res.canonicalUrlsAsLinks = this.canonicalUrlsAsLinks;
        res.pretty = this.pretty;
        res.contained = this.contained;
        res.noSlowLookup = this.noSlowLookup;
        res.tooCostlyNoteEmpty = this.tooCostlyNoteEmpty;
        res.tooCostlyNoteNotEmpty = this.tooCostlyNoteNotEmpty;
        res.tooCostlyNoteEmptyDependent = this.tooCostlyNoteEmptyDependent;
        res.tooCostlyNoteNotEmptyDependent = this.tooCostlyNoteNotEmptyDependent;
        res.codeSystemPropList.addAll(this.codeSystemPropList);
        res.profileUtilitiesR = this.profileUtilitiesR;
        res.definitionsTarget = this.definitionsTarget;
        res.destDir = this.destDir;
        res.addGeneratedNarrativeHeader = this.addGeneratedNarrativeHeader;
        res.questionnaireMode = this.questionnaireMode;
        res.structureMode = this.structureMode;
        res.header = this.header;
        res.links.putAll(this.links);
        res.inlineGraphics = this.inlineGraphics;
        res.timeZoneId = this.timeZoneId;
        res.dateTimeFormat = this.dateTimeFormat;
        res.dateFormat = this.dateFormat;
        res.dateYearFormat = this.dateYearFormat;
        res.dateYearMonthFormat = this.dateYearMonthFormat;
        res.targetVersion = this.targetVersion;
        res.locale = this.locale;
        res.showComments = this.showComments;
        res.copyButton = this.copyButton;
        res.pkp = this.pkp;
        res.defaultStandardsStatus = this.defaultStandardsStatus;
        res.terminologyServiceOptions = this.terminologyServiceOptions.copy();
        return res;
    }

    public IWorkerContext getContext() {
        return this.worker;
    }

    public ProfileUtilities getProfileUtilities() {
        if (this.profileUtilitiesR == null) {
            this.profileUtilitiesR = new ProfileUtilities(this.worker, null, this.pkp);
        }
        return this.profileUtilitiesR;
    }

    public IWorkerContext getWorker() {
        return this.worker;
    }

    public boolean isCanonicalUrlsAsLinks() {
        return this.canonicalUrlsAsLinks;
    }

    public RenderingContext setCanonicalUrlsAsLinks(boolean canonicalUrlsAsLinks) {
        this.canonicalUrlsAsLinks = canonicalUrlsAsLinks;
        return this;
    }

    public MarkDownProcessor getMarkdown() {
        if (this.markdown == null) {
            this.markdown = new MarkDownProcessor(MarkDownProcessor.Dialect.COMMON_MARK);
        }
        return this.markdown;
    }

    public String getLang() {
        return this.lang;
    }

    public String getLocalPrefix() {
        return this.localPrefix;
    }

    public ValidationOptions getTerminologyServiceOptions() {
        return this.terminologyServiceOptions;
    }

    public String getTooCostlyNoteEmpty() {
        return this.tooCostlyNoteEmpty;
    }

    public RenderingContext setTooCostlyNoteEmpty(String tooCostlyNoteEmpty) {
        this.tooCostlyNoteEmpty = tooCostlyNoteEmpty;
        return this;
    }

    public String getTooCostlyNoteNotEmpty() {
        return this.tooCostlyNoteNotEmpty;
    }

    public RenderingContext setTooCostlyNoteNotEmpty(String tooCostlyNoteNotEmpty) {
        this.tooCostlyNoteNotEmpty = tooCostlyNoteNotEmpty;
        return this;
    }

    public String getTooCostlyNoteEmptyDependent() {
        return this.tooCostlyNoteEmptyDependent;
    }

    public RenderingContext setTooCostlyNoteEmptyDependent(String tooCostlyNoteEmptyDependent) {
        this.tooCostlyNoteEmptyDependent = tooCostlyNoteEmptyDependent;
        return this;
    }

    public String getTooCostlyNoteNotEmptyDependent() {
        return this.tooCostlyNoteNotEmptyDependent;
    }

    public RenderingContext setTooCostlyNoteNotEmptyDependent(String tooCostlyNoteNotEmptyDependent) {
        this.tooCostlyNoteNotEmptyDependent = tooCostlyNoteNotEmptyDependent;
        return this;
    }

    public int getHeaderLevelContext() {
        return this.headerLevelContext;
    }

    public RenderingContext setHeaderLevelContext(int headerLevelContext) {
        this.headerLevelContext = headerLevelContext;
        return this;
    }

    public Resolver.IReferenceResolver getResolver() {
        return this.resolver;
    }

    public RenderingContext setResolver(Resolver.IReferenceResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public RenderingContext setTerminologyServiceOptions(ValidationOptions terminologyServiceOptions) {
        this.terminologyServiceOptions = terminologyServiceOptions;
        return this;
    }

    public boolean isNoSlowLookup() {
        return this.noSlowLookup;
    }

    public RenderingContext setNoSlowLookup(boolean noSlowLookup) {
        this.noSlowLookup = noSlowLookup;
        return this;
    }

    public String getDefinitionsTarget() {
        return this.definitionsTarget;
    }

    public RenderingContext setDefinitionsTarget(String definitionsTarget) {
        this.definitionsTarget = definitionsTarget;
        return this;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public RenderingContext setDestDir(String destDir) {
        this.destDir = destDir;
        return this;
    }

    public RenderingContext setProfileUtilities(ProfileUtilities profileUtilities) {
        this.profileUtilitiesR = profileUtilities;
        if (this.pkp == null && profileUtilities.getPkp() != null) {
            this.pkp = profileUtilities.getPkp();
        }
        return this;
    }

    public ILiquidTemplateProvider getTemplateProvider() {
        return this.templateProvider;
    }

    public RenderingContext setTemplateProvider(ILiquidTemplateProvider templateProvider) {
        this.templateProvider = templateProvider;
        return this;
    }

    public FHIRPathEngine.IEvaluationContext getServices() {
        return this.services;
    }

    public RenderingContext setServices(FHIRPathEngine.IEvaluationContext services) {
        this.services = services;
        return this;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public RenderingContext setPretty(boolean pretty) {
        this.pretty = pretty;
        return this;
    }

    public ITypeParser getParser() {
        return this.parser;
    }

    public RenderingContext setParser(ITypeParser parser) {
        this.parser = parser;
        return this;
    }

    public List<String> getCodeSystemPropList() {
        return this.codeSystemPropList;
    }

    public RenderingContext setCodeSystemPropList(List<String> codeSystemPropList) {
        this.codeSystemPropList = codeSystemPropList;
        return this;
    }

    public boolean isInlineGraphics() {
        return this.inlineGraphics;
    }

    public RenderingContext setInlineGraphics(boolean inlineGraphics) {
        this.inlineGraphics = inlineGraphics;
        return this;
    }

    public boolean isHeader() {
        return this.header;
    }

    public RenderingContext setHeader(boolean header) {
        this.header = header;
        return this;
    }

    public QuestionnaireRendererMode getQuestionnaireMode() {
        return this.questionnaireMode;
    }

    public RenderingContext setQuestionnaireMode(QuestionnaireRendererMode questionnaireMode) {
        this.questionnaireMode = questionnaireMode;
        return this;
    }

    public StructureDefinitionRendererMode getStructureMode() {
        return this.structureMode;
    }

    public RenderingContext setStructureMode(StructureDefinitionRendererMode structureMode) {
        this.structureMode = structureMode;
        return this;
    }

    public String fixReference(String ref) {
        if (!Utilities.isAbsoluteUrl((String)ref)) {
            return (this.localPrefix == null ? "" : this.localPrefix) + ref;
        }
        if (ref.startsWith("http://hl7.org/fhir") && !ref.substring(20).contains("/")) {
            return this.getLink(KnownLinkType.SPEC) + ref.substring(20);
        }
        return ref;
    }

    public RenderingContext setLang(String lang) {
        this.lang = lang;
        return this;
    }

    public RenderingContext setLocalPrefix(String localPrefix) {
        this.localPrefix = localPrefix;
        return this;
    }

    public boolean isAddGeneratedNarrativeHeader() {
        return this.addGeneratedNarrativeHeader;
    }

    public RenderingContext setAddGeneratedNarrativeHeader(boolean addGeneratedNarrativeHeader) {
        this.addGeneratedNarrativeHeader = addGeneratedNarrativeHeader;
        return this;
    }

    public FhirPublication getTargetVersion() {
        return this.targetVersion;
    }

    public RenderingContext setTargetVersion(FhirPublication targetVersion) {
        this.targetVersion = targetVersion;
        return this;
    }

    public boolean isTechnicalMode() {
        return this.mode == ResourceRendererMode.TECHNICAL;
    }

    public boolean hasLocale() {
        return this.locale != null;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public RenderingContext setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public ZoneId getTimeZoneId() {
        return this.timeZoneId;
    }

    public RenderingContext setTimeZoneId(ZoneId timeZoneId) {
        this.timeZoneId = timeZoneId;
        return this;
    }

    public DateTimeFormatter getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public RenderingContext setDateTimeFormat(DateTimeFormatter dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
        return this;
    }

    public RenderingContext setDateTimeFormatString(String dateTimeFormat) {
        this.dateTimeFormat = DateTimeFormatter.ofPattern(dateTimeFormat);
        return this;
    }

    public DateTimeFormatter getDateFormat() {
        return this.dateFormat;
    }

    public RenderingContext setDateFormat(DateTimeFormatter dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public RenderingContext setDateFormatString(String dateFormat) {
        this.dateFormat = DateTimeFormatter.ofPattern(dateFormat);
        return this;
    }

    public DateTimeFormatter getDateYearFormat() {
        return this.dateYearFormat;
    }

    public RenderingContext setDateYearFormat(DateTimeFormatter dateYearFormat) {
        this.dateYearFormat = dateYearFormat;
        return this;
    }

    public RenderingContext setDateYearFormatString(String dateYearFormat) {
        this.dateYearFormat = DateTimeFormatter.ofPattern(dateYearFormat);
        return this;
    }

    public DateTimeFormatter getDateYearMonthFormat() {
        return this.dateYearMonthFormat;
    }

    public RenderingContext setDateYearMonthFormat(DateTimeFormatter dateYearMonthFormat) {
        this.dateYearMonthFormat = dateYearMonthFormat;
        return this;
    }

    public RenderingContext setDateYearMonthFormatString(String dateYearMonthFormat) {
        this.dateYearMonthFormat = DateTimeFormatter.ofPattern(dateYearMonthFormat);
        return this;
    }

    public ResourceRendererMode getMode() {
        return this.mode;
    }

    public RenderingContext setMode(ResourceRendererMode mode) {
        this.mode = mode;
        return this;
    }

    public boolean isContained() {
        return this.contained;
    }

    public RenderingContext setContained(boolean contained) {
        this.contained = contained;
        return this;
    }

    public boolean isShowComments() {
        return this.showComments;
    }

    public RenderingContext setShowComments(boolean showComments) {
        this.showComments = showComments;
        return this;
    }

    public boolean isCopyButton() {
        return this.copyButton;
    }

    public RenderingContext setCopyButton(boolean copyButton) {
        this.copyButton = copyButton;
        return this;
    }

    public RenderingContext setPkp(ProfileKnowledgeProvider pkp) {
        this.pkp = pkp;
        return this;
    }

    public ProfileKnowledgeProvider getPkp() {
        return this.pkp;
    }

    public boolean hasLink(KnownLinkType link) {
        return this.links.containsKey((Object)link);
    }

    public String getLink(KnownLinkType link) {
        return this.links.get((Object)link);
    }

    public void addLink(KnownLinkType type, String link) {
        this.links.put(type, link);
    }

    public GenerationRules getRules() {
        return this.rules;
    }

    public void setRules(GenerationRules rules) {
        this.rules = rules;
    }

    public StandardsStatus getDefaultStandardsStatus() {
        return this.defaultStandardsStatus;
    }

    public RenderingContext setDefaultStandardsStatus(StandardsStatus defaultStandardsStatus) {
        this.defaultStandardsStatus = defaultStandardsStatus;
        return this;
    }

    public static enum KnownLinkType {
        SELF,
        SPEC,
        JSON_NAMES;

    }

    public static enum QuestionnaireRendererMode {
        FORM,
        TREE,
        LOGIC,
        DEFNS,
        LINKS;

    }

    public static enum StructureDefinitionRendererMode {
        SUMMARY,
        BINDINGS,
        OBLIGATIONS;

    }

    public static enum GenerationRules {
        VALID_RESOURCE,
        IG_PUBLISHER;

    }

    public static enum ResourceRendererMode {
        END_USER,
        TECHNICAL;

    }

    public static interface ITypeParser {
        public Base parseType(String var1, String var2) throws FHIRFormatError, IOException, FHIRException;

        public Base parseType(Element var1) throws FHIRFormatError, IOException, FHIRException;
    }

    public static interface ILiquidTemplateProvider {
        public String findTemplate(RenderingContext var1, DomainResource var2);

        public String findTemplate(RenderingContext var1, String var2);
    }
}

