/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Specimen", profile="http://hl7.org/fhir/StructureDefinition/Specimen")
public class Specimen
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Identifier", formalDefinition="Id for specimen.")
    protected List<Identifier> identifier;
    @Child(name="accessionIdentifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier assigned by the lab", formalDefinition="The identifier assigned by the lab when accessioning specimen(s). This is not necessarily the same as the specimen identifier, depending on local lab procedures.")
    protected Identifier accessionIdentifier;
    @Child(name="status", type={CodeType.class}, order=2, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="available | unavailable | unsatisfactory | entered-in-error", formalDefinition="The availability of the specimen.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/specimen-status")
    protected Enumeration<SpecimenStatus> status;
    @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of material that forms the specimen", formalDefinition="The kind of material that forms the specimen.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0487")
    protected CodeableConcept type;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, BiologicallyDerivedProduct.class, Substance.class, Location.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where the specimen came from. This may be from patient(s), from a location (e.g., the source of an environmental sample), or a sampling of a substance, a biologically-derived product, or a device", formalDefinition="Where the specimen came from. This may be from patient(s), from a location (e.g., the source of an environmental sample), or a sampling of a substance, a biologically-derived product, or a device.")
    protected Reference subject;
    @Child(name="receivedTime", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The time when specimen is received by the testing laboratory", formalDefinition="Time when specimen is received by the testing laboratory for processing or testing.")
    protected DateTimeType receivedTime;
    @Child(name="parent", type={Specimen.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Specimen from which this specimen originated", formalDefinition="Reference to the parent (source) specimen which is used when the specimen was either derived from or a component of another specimen.")
    protected List<Reference> parent;
    @Child(name="request", type={ServiceRequest.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Why the specimen was collected", formalDefinition="Details concerning a service request that required a specimen to be collected.")
    protected List<Reference> request;
    @Child(name="combined", type={CodeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="grouped | pooled", formalDefinition="This element signifies if the specimen is part of a group or pooled.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/specimen-combined")
    protected Enumeration<SpecimenCombined> combined;
    @Child(name="role", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The role the specimen serves", formalDefinition="The role or reason for the specimen in the testing workflow.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/specimen-role")
    protected List<CodeableConcept> role;
    @Child(name="feature", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The physical feature of a specimen", formalDefinition="A physical feature or landmark on a specimen, highlighted for context by the collector of the specimen (e.g. surgeon), that identifies the type of feature as well as its meaning (e.g. the red ink indicating the resection margin of the right lobe of the excised prostate tissue or wire loop at radiologically suspected tumor location).")
    protected List<SpecimenFeatureComponent> feature;
    @Child(name="collection", type={}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Collection details", formalDefinition="Details concerning the specimen collection.")
    protected SpecimenCollectionComponent collection;
    @Child(name="processing", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Processing and processing step details", formalDefinition="Details concerning processing and processing steps for the specimen.")
    protected List<SpecimenProcessingComponent> processing;
    @Child(name="container", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Direct container of specimen (tube/slide, etc.)", formalDefinition="The container holding the specimen.  The recursive nature of containers; i.e. blood in tube in tray in rack is not addressed here.")
    protected List<SpecimenContainerComponent> container;
    @Child(name="condition", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="State of the specimen", formalDefinition="A mode or state of being that describes the nature of the specimen.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0493")
    protected List<CodeableConcept> condition;
    @Child(name="note", type={Annotation.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments", formalDefinition="To communicate any details or issues about the specimen or during the specimen collection. (for example: broken vial, sent with patient, frozen).")
    protected List<Annotation> note;
    private static final long serialVersionUID = -445425000L;
    @SearchParamDefinition(name="accession", path="Specimen.accessionIdentifier", description="The accession number associated with the specimen", type="token")
    public static final String SP_ACCESSION = "accession";
    public static final TokenClientParam ACCESSION = new TokenClientParam("accession");
    @SearchParamDefinition(name="bodysite", path="Specimen.collection.bodySite.reference", description="Reference to a resource (by instance)", type="reference", target={BodyStructure.class})
    public static final String SP_BODYSITE = "bodysite";
    public static final ReferenceClientParam BODYSITE = new ReferenceClientParam("bodysite");
    public static final Include INCLUDE_BODYSITE = new Include("Specimen:bodysite").toLocked();
    @SearchParamDefinition(name="collected", path="Specimen.collection.collected.ofType(dateTime) | Specimen.collection.collected.ofType(Period)", description="The date the specimen was collected", type="date")
    public static final String SP_COLLECTED = "collected";
    public static final DateClientParam COLLECTED = new DateClientParam("collected");
    @SearchParamDefinition(name="collector", path="Specimen.collection.collector", description="Who collected the specimen", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_COLLECTOR = "collector";
    public static final ReferenceClientParam COLLECTOR = new ReferenceClientParam("collector");
    public static final Include INCLUDE_COLLECTOR = new Include("Specimen:collector").toLocked();
    @SearchParamDefinition(name="container-device", path="Specimen.container.device.where(resolve() is Device)", description="The unique identifier associated with the specimen container", type="reference", target={Device.class})
    public static final String SP_CONTAINER_DEVICE = "container-device";
    public static final ReferenceClientParam CONTAINER_DEVICE = new ReferenceClientParam("container-device");
    public static final Include INCLUDE_CONTAINER_DEVICE = new Include("Specimen:container-device").toLocked();
    @SearchParamDefinition(name="parent", path="Specimen.parent", description="The parent of the specimen", type="reference", target={Specimen.class})
    public static final String SP_PARENT = "parent";
    public static final ReferenceClientParam PARENT = new ReferenceClientParam("parent");
    public static final Include INCLUDE_PARENT = new Include("Specimen:parent").toLocked();
    @SearchParamDefinition(name="procedure", path="Specimen.collection.procedure", description="The procedure that collected the specimen", type="reference", target={Procedure.class})
    public static final String SP_PROCEDURE = "procedure";
    public static final ReferenceClientParam PROCEDURE = new ReferenceClientParam("procedure");
    public static final Include INCLUDE_PROCEDURE = new Include("Specimen:procedure").toLocked();
    @SearchParamDefinition(name="status", path="Specimen.status", description="available | unavailable | unsatisfactory | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="Specimen.subject", description="The subject of the specimen", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient")}, target={BiologicallyDerivedProduct.class, Device.class, Group.class, Location.class, Patient.class, Substance.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Specimen:subject").toLocked();
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Specimen:patient").toLocked();
    @SearchParamDefinition(name="type", path="Account.type | AllergyIntolerance.type | Composition.type | Coverage.type | DocumentReference.type | Encounter.type | EpisodeOfCare.type | Invoice.type | MedicationDispense.type | MolecularSequence.type | Specimen.type", description="Multiple Resources: \r\n\r\n* [Account](account.html): E.g. patient, expense, depreciation\r\n* [AllergyIntolerance](allergyintolerance.html): allergy | intolerance - Underlying mechanism (if known)\r\n* [Composition](composition.html): Kind of composition (LOINC if possible)\r\n* [Coverage](coverage.html): The kind of coverage (health plan, auto, Workers Compensation)\r\n* [DocumentReference](documentreference.html): Kind of document (LOINC if possible)\r\n* [Encounter](encounter.html): Specific type of encounter\r\n* [EpisodeOfCare](episodeofcare.html): Type/class  - e.g. specialist referral, disease management\r\n* [Invoice](invoice.html): Type of Invoice\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of a specific type\r\n* [MolecularSequence](molecularsequence.html): Amino Acid Sequence/ DNA Sequence / RNA Sequence\r\n* [Specimen](specimen.html): The specimen type\r\n", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Specimen setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Specimen addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Identifier getAccessionIdentifier() {
        if (this.accessionIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.accessionIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.accessionIdentifier = new Identifier();
            }
        }
        return this.accessionIdentifier;
    }

    public boolean hasAccessionIdentifier() {
        return this.accessionIdentifier != null && !this.accessionIdentifier.isEmpty();
    }

    public Specimen setAccessionIdentifier(Identifier value) {
        this.accessionIdentifier = value;
        return this;
    }

    public Enumeration<SpecimenStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<SpecimenStatus>(new SpecimenStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Specimen setStatusElement(Enumeration<SpecimenStatus> value) {
        this.status = value;
        return this;
    }

    public SpecimenStatus getStatus() {
        return this.status == null ? null : (SpecimenStatus)((Object)this.status.getValue());
    }

    public Specimen setStatus(SpecimenStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<SpecimenStatus>(new SpecimenStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Specimen setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Specimen setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public DateTimeType getReceivedTimeElement() {
        if (this.receivedTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.receivedTime");
            }
            if (Configuration.doAutoCreate()) {
                this.receivedTime = new DateTimeType();
            }
        }
        return this.receivedTime;
    }

    public boolean hasReceivedTimeElement() {
        return this.receivedTime != null && !this.receivedTime.isEmpty();
    }

    public boolean hasReceivedTime() {
        return this.receivedTime != null && !this.receivedTime.isEmpty();
    }

    public Specimen setReceivedTimeElement(DateTimeType value) {
        this.receivedTime = value;
        return this;
    }

    public Date getReceivedTime() {
        return this.receivedTime == null ? null : (Date)this.receivedTime.getValue();
    }

    public Specimen setReceivedTime(Date value) {
        if (value == null) {
            this.receivedTime = null;
        } else {
            if (this.receivedTime == null) {
                this.receivedTime = new DateTimeType();
            }
            this.receivedTime.setValue(value);
        }
        return this;
    }

    public List<Reference> getParent() {
        if (this.parent == null) {
            this.parent = new ArrayList<Reference>();
        }
        return this.parent;
    }

    public Specimen setParent(List<Reference> theParent) {
        this.parent = theParent;
        return this;
    }

    public boolean hasParent() {
        if (this.parent == null) {
            return false;
        }
        for (Reference item : this.parent) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addParent() {
        Reference t = new Reference();
        if (this.parent == null) {
            this.parent = new ArrayList<Reference>();
        }
        this.parent.add(t);
        return t;
    }

    public Specimen addParent(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.parent == null) {
            this.parent = new ArrayList<Reference>();
        }
        this.parent.add(t);
        return this;
    }

    public Reference getParentFirstRep() {
        if (this.getParent().isEmpty()) {
            this.addParent();
        }
        return this.getParent().get(0);
    }

    public List<Reference> getRequest() {
        if (this.request == null) {
            this.request = new ArrayList<Reference>();
        }
        return this.request;
    }

    public Specimen setRequest(List<Reference> theRequest) {
        this.request = theRequest;
        return this;
    }

    public boolean hasRequest() {
        if (this.request == null) {
            return false;
        }
        for (Reference item : this.request) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRequest() {
        Reference t = new Reference();
        if (this.request == null) {
            this.request = new ArrayList<Reference>();
        }
        this.request.add(t);
        return t;
    }

    public Specimen addRequest(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.request == null) {
            this.request = new ArrayList<Reference>();
        }
        this.request.add(t);
        return this;
    }

    public Reference getRequestFirstRep() {
        if (this.getRequest().isEmpty()) {
            this.addRequest();
        }
        return this.getRequest().get(0);
    }

    public Enumeration<SpecimenCombined> getCombinedElement() {
        if (this.combined == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.combined");
            }
            if (Configuration.doAutoCreate()) {
                this.combined = new Enumeration<SpecimenCombined>(new SpecimenCombinedEnumFactory());
            }
        }
        return this.combined;
    }

    public boolean hasCombinedElement() {
        return this.combined != null && !this.combined.isEmpty();
    }

    public boolean hasCombined() {
        return this.combined != null && !this.combined.isEmpty();
    }

    public Specimen setCombinedElement(Enumeration<SpecimenCombined> value) {
        this.combined = value;
        return this;
    }

    public SpecimenCombined getCombined() {
        return this.combined == null ? null : (SpecimenCombined)((Object)this.combined.getValue());
    }

    public Specimen setCombined(SpecimenCombined value) {
        if (value == null) {
            this.combined = null;
        } else {
            if (this.combined == null) {
                this.combined = new Enumeration<SpecimenCombined>(new SpecimenCombinedEnumFactory());
            }
            this.combined.setValue((Object)value);
        }
        return this;
    }

    public List<CodeableConcept> getRole() {
        if (this.role == null) {
            this.role = new ArrayList<CodeableConcept>();
        }
        return this.role;
    }

    public Specimen setRole(List<CodeableConcept> theRole) {
        this.role = theRole;
        return this;
    }

    public boolean hasRole() {
        if (this.role == null) {
            return false;
        }
        for (CodeableConcept item : this.role) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addRole() {
        CodeableConcept t = new CodeableConcept();
        if (this.role == null) {
            this.role = new ArrayList<CodeableConcept>();
        }
        this.role.add(t);
        return t;
    }

    public Specimen addRole(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.role == null) {
            this.role = new ArrayList<CodeableConcept>();
        }
        this.role.add(t);
        return this;
    }

    public CodeableConcept getRoleFirstRep() {
        if (this.getRole().isEmpty()) {
            this.addRole();
        }
        return this.getRole().get(0);
    }

    public List<SpecimenFeatureComponent> getFeature() {
        if (this.feature == null) {
            this.feature = new ArrayList<SpecimenFeatureComponent>();
        }
        return this.feature;
    }

    public Specimen setFeature(List<SpecimenFeatureComponent> theFeature) {
        this.feature = theFeature;
        return this;
    }

    public boolean hasFeature() {
        if (this.feature == null) {
            return false;
        }
        for (SpecimenFeatureComponent item : this.feature) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SpecimenFeatureComponent addFeature() {
        SpecimenFeatureComponent t = new SpecimenFeatureComponent();
        if (this.feature == null) {
            this.feature = new ArrayList<SpecimenFeatureComponent>();
        }
        this.feature.add(t);
        return t;
    }

    public Specimen addFeature(SpecimenFeatureComponent t) {
        if (t == null) {
            return this;
        }
        if (this.feature == null) {
            this.feature = new ArrayList<SpecimenFeatureComponent>();
        }
        this.feature.add(t);
        return this;
    }

    public SpecimenFeatureComponent getFeatureFirstRep() {
        if (this.getFeature().isEmpty()) {
            this.addFeature();
        }
        return this.getFeature().get(0);
    }

    public SpecimenCollectionComponent getCollection() {
        if (this.collection == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.collection");
            }
            if (Configuration.doAutoCreate()) {
                this.collection = new SpecimenCollectionComponent();
            }
        }
        return this.collection;
    }

    public boolean hasCollection() {
        return this.collection != null && !this.collection.isEmpty();
    }

    public Specimen setCollection(SpecimenCollectionComponent value) {
        this.collection = value;
        return this;
    }

    public List<SpecimenProcessingComponent> getProcessing() {
        if (this.processing == null) {
            this.processing = new ArrayList<SpecimenProcessingComponent>();
        }
        return this.processing;
    }

    public Specimen setProcessing(List<SpecimenProcessingComponent> theProcessing) {
        this.processing = theProcessing;
        return this;
    }

    public boolean hasProcessing() {
        if (this.processing == null) {
            return false;
        }
        for (SpecimenProcessingComponent item : this.processing) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SpecimenProcessingComponent addProcessing() {
        SpecimenProcessingComponent t = new SpecimenProcessingComponent();
        if (this.processing == null) {
            this.processing = new ArrayList<SpecimenProcessingComponent>();
        }
        this.processing.add(t);
        return t;
    }

    public Specimen addProcessing(SpecimenProcessingComponent t) {
        if (t == null) {
            return this;
        }
        if (this.processing == null) {
            this.processing = new ArrayList<SpecimenProcessingComponent>();
        }
        this.processing.add(t);
        return this;
    }

    public SpecimenProcessingComponent getProcessingFirstRep() {
        if (this.getProcessing().isEmpty()) {
            this.addProcessing();
        }
        return this.getProcessing().get(0);
    }

    public List<SpecimenContainerComponent> getContainer() {
        if (this.container == null) {
            this.container = new ArrayList<SpecimenContainerComponent>();
        }
        return this.container;
    }

    public Specimen setContainer(List<SpecimenContainerComponent> theContainer) {
        this.container = theContainer;
        return this;
    }

    public boolean hasContainer() {
        if (this.container == null) {
            return false;
        }
        for (SpecimenContainerComponent item : this.container) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SpecimenContainerComponent addContainer() {
        SpecimenContainerComponent t = new SpecimenContainerComponent();
        if (this.container == null) {
            this.container = new ArrayList<SpecimenContainerComponent>();
        }
        this.container.add(t);
        return t;
    }

    public Specimen addContainer(SpecimenContainerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.container == null) {
            this.container = new ArrayList<SpecimenContainerComponent>();
        }
        this.container.add(t);
        return this;
    }

    public SpecimenContainerComponent getContainerFirstRep() {
        if (this.getContainer().isEmpty()) {
            this.addContainer();
        }
        return this.getContainer().get(0);
    }

    public List<CodeableConcept> getCondition() {
        if (this.condition == null) {
            this.condition = new ArrayList<CodeableConcept>();
        }
        return this.condition;
    }

    public Specimen setCondition(List<CodeableConcept> theCondition) {
        this.condition = theCondition;
        return this;
    }

    public boolean hasCondition() {
        if (this.condition == null) {
            return false;
        }
        for (CodeableConcept item : this.condition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCondition() {
        CodeableConcept t = new CodeableConcept();
        if (this.condition == null) {
            this.condition = new ArrayList<CodeableConcept>();
        }
        this.condition.add(t);
        return t;
    }

    public Specimen addCondition(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.condition == null) {
            this.condition = new ArrayList<CodeableConcept>();
        }
        this.condition.add(t);
        return this;
    }

    public CodeableConcept getConditionFirstRep() {
        if (this.getCondition().isEmpty()) {
            this.addCondition();
        }
        return this.getCondition().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Specimen setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Specimen addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Id for specimen.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("accessionIdentifier", "Identifier", "The identifier assigned by the lab when accessioning specimen(s). This is not necessarily the same as the specimen identifier, depending on local lab procedures.", 0, 1, this.accessionIdentifier));
        children.add(new Property(SP_STATUS, "code", "The availability of the specimen.", 0, 1, this.status));
        children.add(new Property(SP_TYPE, "CodeableConcept", "The kind of material that forms the specimen.", 0, 1, this.type));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|BiologicallyDerivedProduct|Substance|Location)", "Where the specimen came from. This may be from patient(s), from a location (e.g., the source of an environmental sample), or a sampling of a substance, a biologically-derived product, or a device.", 0, 1, this.subject));
        children.add(new Property("receivedTime", "dateTime", "Time when specimen is received by the testing laboratory for processing or testing.", 0, 1, this.receivedTime));
        children.add(new Property(SP_PARENT, "Reference(Specimen)", "Reference to the parent (source) specimen which is used when the specimen was either derived from or a component of another specimen.", 0, Integer.MAX_VALUE, this.parent));
        children.add(new Property("request", "Reference(ServiceRequest)", "Details concerning a service request that required a specimen to be collected.", 0, Integer.MAX_VALUE, this.request));
        children.add(new Property("combined", "code", "This element signifies if the specimen is part of a group or pooled.", 0, 1, this.combined));
        children.add(new Property("role", "CodeableConcept", "The role or reason for the specimen in the testing workflow.", 0, Integer.MAX_VALUE, this.role));
        children.add(new Property("feature", "", "A physical feature or landmark on a specimen, highlighted for context by the collector of the specimen (e.g. surgeon), that identifies the type of feature as well as its meaning (e.g. the red ink indicating the resection margin of the right lobe of the excised prostate tissue or wire loop at radiologically suspected tumor location).", 0, Integer.MAX_VALUE, this.feature));
        children.add(new Property("collection", "", "Details concerning the specimen collection.", 0, 1, this.collection));
        children.add(new Property("processing", "", "Details concerning processing and processing steps for the specimen.", 0, Integer.MAX_VALUE, this.processing));
        children.add(new Property("container", "", "The container holding the specimen.  The recursive nature of containers; i.e. blood in tube in tray in rack is not addressed here.", 0, Integer.MAX_VALUE, this.container));
        children.add(new Property("condition", "CodeableConcept", "A mode or state of being that describes the nature of the specimen.", 0, Integer.MAX_VALUE, this.condition));
        children.add(new Property("note", "Annotation", "To communicate any details or issues about the specimen or during the specimen collection. (for example: broken vial, sent with patient, frozen).", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Id for specimen.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 818734061: {
                return new Property("accessionIdentifier", "Identifier", "The identifier assigned by the lab when accessioning specimen(s). This is not necessarily the same as the specimen identifier, depending on local lab procedures.", 0, 1, this.accessionIdentifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The availability of the specimen.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "The kind of material that forms the specimen.", 0, 1, this.type);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Device|BiologicallyDerivedProduct|Substance|Location)", "Where the specimen came from. This may be from patient(s), from a location (e.g., the source of an environmental sample), or a sampling of a substance, a biologically-derived product, or a device.", 0, 1, this.subject);
            }
            case -767961010: {
                return new Property("receivedTime", "dateTime", "Time when specimen is received by the testing laboratory for processing or testing.", 0, 1, this.receivedTime);
            }
            case -995424086: {
                return new Property(SP_PARENT, "Reference(Specimen)", "Reference to the parent (source) specimen which is used when the specimen was either derived from or a component of another specimen.", 0, Integer.MAX_VALUE, this.parent);
            }
            case 1095692943: {
                return new Property("request", "Reference(ServiceRequest)", "Details concerning a service request that required a specimen to be collected.", 0, Integer.MAX_VALUE, this.request);
            }
            case -612455675: {
                return new Property("combined", "code", "This element signifies if the specimen is part of a group or pooled.", 0, 1, this.combined);
            }
            case 3506294: {
                return new Property("role", "CodeableConcept", "The role or reason for the specimen in the testing workflow.", 0, Integer.MAX_VALUE, this.role);
            }
            case -979207434: {
                return new Property("feature", "", "A physical feature or landmark on a specimen, highlighted for context by the collector of the specimen (e.g. surgeon), that identifies the type of feature as well as its meaning (e.g. the red ink indicating the resection margin of the right lobe of the excised prostate tissue or wire loop at radiologically suspected tumor location).", 0, Integer.MAX_VALUE, this.feature);
            }
            case -1741312354: {
                return new Property("collection", "", "Details concerning the specimen collection.", 0, 1, this.collection);
            }
            case 422194963: {
                return new Property("processing", "", "Details concerning processing and processing steps for the specimen.", 0, Integer.MAX_VALUE, this.processing);
            }
            case -410956671: {
                return new Property("container", "", "The container holding the specimen.  The recursive nature of containers; i.e. blood in tube in tray in rack is not addressed here.", 0, Integer.MAX_VALUE, this.container);
            }
            case -861311717: {
                return new Property("condition", "CodeableConcept", "A mode or state of being that describes the nature of the specimen.", 0, Integer.MAX_VALUE, this.condition);
            }
            case 3387378: {
                return new Property("note", "Annotation", "To communicate any details or issues about the specimen or during the specimen collection. (for example: broken vial, sent with patient, frozen).", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 818734061: {
                Base[] baseArray;
                if (this.accessionIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.accessionIdentifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.type;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case -767961010: {
                Base[] baseArray;
                if (this.receivedTime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.receivedTime;
                }
                return baseArray;
            }
            case -995424086: {
                return this.parent == null ? new Base[]{} : this.parent.toArray(new Base[this.parent.size()]);
            }
            case 1095692943: {
                return this.request == null ? new Base[]{} : this.request.toArray(new Base[this.request.size()]);
            }
            case -612455675: {
                Base[] baseArray;
                if (this.combined == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.combined;
                }
                return baseArray;
            }
            case 3506294: {
                return this.role == null ? new Base[]{} : this.role.toArray(new Base[this.role.size()]);
            }
            case -979207434: {
                return this.feature == null ? new Base[]{} : this.feature.toArray(new Base[this.feature.size()]);
            }
            case -1741312354: {
                Base[] baseArray;
                if (this.collection == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.collection;
                }
                return baseArray;
            }
            case 422194963: {
                return this.processing == null ? new Base[]{} : this.processing.toArray(new Base[this.processing.size()]);
            }
            case -410956671: {
                return this.container == null ? new Base[]{} : this.container.toArray(new Base[this.container.size()]);
            }
            case -861311717: {
                return this.condition == null ? new Base[]{} : this.condition.toArray(new Base[this.condition.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 818734061: {
                this.accessionIdentifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case -892481550: {
                value = new SpecimenStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case -767961010: {
                this.receivedTime = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -995424086: {
                this.getParent().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1095692943: {
                this.getRequest().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -612455675: {
                value = new SpecimenCombinedEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.combined = value;
                return value;
            }
            case 3506294: {
                this.getRole().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -979207434: {
                this.getFeature().add((SpecimenFeatureComponent)((Object)value));
                return value;
            }
            case -1741312354: {
                this.collection = (SpecimenCollectionComponent)((Object)value);
                return value;
            }
            case 422194963: {
                this.getProcessing().add((SpecimenProcessingComponent)((Object)value));
                return value;
            }
            case -410956671: {
                this.getContainer().add((SpecimenContainerComponent)((Object)value));
                return value;
            }
            case -861311717: {
                this.getCondition().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("accessionIdentifier")) {
            this.accessionIdentifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            value = new SpecimenStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_TYPE)) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("receivedTime")) {
            this.receivedTime = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PARENT)) {
            this.getParent().add(TypeConvertor.castToReference(value));
        } else if (name.equals("request")) {
            this.getRequest().add(TypeConvertor.castToReference(value));
        } else if (name.equals("combined")) {
            value = new SpecimenCombinedEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.combined = value;
        } else if (name.equals("role")) {
            this.getRole().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("feature")) {
            this.getFeature().add((SpecimenFeatureComponent)((Object)value));
        } else if (name.equals("collection")) {
            this.collection = (SpecimenCollectionComponent)((Object)value);
        } else if (name.equals("processing")) {
            this.getProcessing().add((SpecimenProcessingComponent)((Object)value));
        } else if (name.equals("container")) {
            this.getContainer().add((SpecimenContainerComponent)((Object)value));
        } else if (name.equals("condition")) {
            this.getCondition().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 818734061: {
                return this.getAccessionIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3575610: {
                return this.getType();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case -767961010: {
                return this.getReceivedTimeElement();
            }
            case -995424086: {
                return this.addParent();
            }
            case 1095692943: {
                return this.addRequest();
            }
            case -612455675: {
                return this.getCombinedElement();
            }
            case 3506294: {
                return this.addRole();
            }
            case -979207434: {
                return this.addFeature();
            }
            case -1741312354: {
                return this.getCollection();
            }
            case 422194963: {
                return this.addProcessing();
            }
            case -410956671: {
                return this.addContainer();
            }
            case -861311717: {
                return this.addCondition();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 818734061: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case -767961010: {
                return new String[]{"dateTime"};
            }
            case -995424086: {
                return new String[]{"Reference"};
            }
            case 1095692943: {
                return new String[]{"Reference"};
            }
            case -612455675: {
                return new String[]{"code"};
            }
            case 3506294: {
                return new String[]{"CodeableConcept"};
            }
            case -979207434: {
                return new String[0];
            }
            case -1741312354: {
                return new String[0];
            }
            case 422194963: {
                return new String[0];
            }
            case -410956671: {
                return new String[0];
            }
            case -861311717: {
                return new String[]{"CodeableConcept"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("accessionIdentifier")) {
            this.accessionIdentifier = new Identifier();
            return this.accessionIdentifier;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Specimen.status");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("receivedTime")) {
            throw new FHIRException("Cannot call addChild on a primitive type Specimen.receivedTime");
        }
        if (name.equals(SP_PARENT)) {
            return this.addParent();
        }
        if (name.equals("request")) {
            return this.addRequest();
        }
        if (name.equals("combined")) {
            throw new FHIRException("Cannot call addChild on a primitive type Specimen.combined");
        }
        if (name.equals("role")) {
            return this.addRole();
        }
        if (name.equals("feature")) {
            return this.addFeature();
        }
        if (name.equals("collection")) {
            this.collection = new SpecimenCollectionComponent();
            return this.collection;
        }
        if (name.equals("processing")) {
            return this.addProcessing();
        }
        if (name.equals("container")) {
            return this.addContainer();
        }
        if (name.equals("condition")) {
            return this.addCondition();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Specimen";
    }

    @Override
    public Specimen copy() {
        Specimen dst = new Specimen();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Specimen dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.accessionIdentifier = this.accessionIdentifier == null ? null : this.accessionIdentifier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        DateTimeType dateTimeType = dst.receivedTime = this.receivedTime == null ? null : this.receivedTime.copy();
        if (this.parent != null) {
            dst.parent = new ArrayList<Reference>();
            for (Reference reference : this.parent) {
                dst.parent.add(reference.copy());
            }
        }
        if (this.request != null) {
            dst.request = new ArrayList<Reference>();
            for (Reference reference : this.request) {
                dst.request.add(reference.copy());
            }
        }
        Enumeration<SpecimenCombined> enumeration = dst.combined = this.combined == null ? null : this.combined.copy();
        if (this.role != null) {
            dst.role = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.role) {
                dst.role.add(codeableConcept.copy());
            }
        }
        if (this.feature != null) {
            dst.feature = new ArrayList<SpecimenFeatureComponent>();
            for (SpecimenFeatureComponent specimenFeatureComponent : this.feature) {
                dst.feature.add(specimenFeatureComponent.copy());
            }
        }
        SpecimenCollectionComponent specimenCollectionComponent = dst.collection = this.collection == null ? null : this.collection.copy();
        if (this.processing != null) {
            dst.processing = new ArrayList<SpecimenProcessingComponent>();
            for (SpecimenProcessingComponent specimenProcessingComponent : this.processing) {
                dst.processing.add(specimenProcessingComponent.copy());
            }
        }
        if (this.container != null) {
            dst.container = new ArrayList<SpecimenContainerComponent>();
            for (SpecimenContainerComponent specimenContainerComponent : this.container) {
                dst.container.add(specimenContainerComponent.copy());
            }
        }
        if (this.condition != null) {
            dst.condition = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.condition) {
                dst.condition.add(codeableConcept.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected Specimen typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Specimen)) {
            return false;
        }
        Specimen o = (Specimen)other_;
        return Specimen.compareDeep(this.identifier, o.identifier, true) && Specimen.compareDeep(this.accessionIdentifier, o.accessionIdentifier, true) && Specimen.compareDeep(this.status, o.status, true) && Specimen.compareDeep(this.type, o.type, true) && Specimen.compareDeep(this.subject, o.subject, true) && Specimen.compareDeep(this.receivedTime, o.receivedTime, true) && Specimen.compareDeep(this.parent, o.parent, true) && Specimen.compareDeep(this.request, o.request, true) && Specimen.compareDeep(this.combined, o.combined, true) && Specimen.compareDeep(this.role, o.role, true) && Specimen.compareDeep(this.feature, o.feature, true) && Specimen.compareDeep(this.collection, o.collection, true) && Specimen.compareDeep(this.processing, o.processing, true) && Specimen.compareDeep(this.container, o.container, true) && Specimen.compareDeep(this.condition, o.condition, true) && Specimen.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Specimen)) {
            return false;
        }
        Specimen o = (Specimen)other_;
        return Specimen.compareValues(this.status, o.status, true) && Specimen.compareValues(this.receivedTime, o.receivedTime, true) && Specimen.compareValues(this.combined, o.combined, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.accessionIdentifier, this.status, this.type, this.subject, this.receivedTime, this.parent, this.request, this.combined, this.role, this.feature, this.collection, this.processing, this.container, this.condition, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Specimen;
    }

    @Block
    public static class SpecimenContainerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="device", type={Device.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Device resource for the container", formalDefinition="The device resource for the the container holding the specimen. If the container is in a holder then the referenced device will point to a parent device.")
        protected Reference device;
        @Child(name="location", type={Location.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Where the container is", formalDefinition="The location of the container holding the specimen.")
        protected Reference location;
        @Child(name="specimenQuantity", type={Quantity.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Quantity of specimen within container", formalDefinition="The quantity of specimen in the container; may be volume, dimensions, or other appropriate measurements, depending on the specimen type.")
        protected Quantity specimenQuantity;
        private static final long serialVersionUID = 1973387427L;

        public SpecimenContainerComponent() {
        }

        public SpecimenContainerComponent(Reference device) {
            this.setDevice(device);
        }

        public Reference getDevice() {
            if (this.device == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenContainerComponent.device");
                }
                if (Configuration.doAutoCreate()) {
                    this.device = new Reference();
                }
            }
            return this.device;
        }

        public boolean hasDevice() {
            return this.device != null && !this.device.isEmpty();
        }

        public SpecimenContainerComponent setDevice(Reference value) {
            this.device = value;
            return this;
        }

        public Reference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenContainerComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new Reference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public SpecimenContainerComponent setLocation(Reference value) {
            this.location = value;
            return this;
        }

        public Quantity getSpecimenQuantity() {
            if (this.specimenQuantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenContainerComponent.specimenQuantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.specimenQuantity = new Quantity();
                }
            }
            return this.specimenQuantity;
        }

        public boolean hasSpecimenQuantity() {
            return this.specimenQuantity != null && !this.specimenQuantity.isEmpty();
        }

        public SpecimenContainerComponent setSpecimenQuantity(Quantity value) {
            this.specimenQuantity = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("device", "Reference(Device)", "The device resource for the the container holding the specimen. If the container is in a holder then the referenced device will point to a parent device.", 0, 1, this.device));
            children.add(new Property("location", "Reference(Location)", "The location of the container holding the specimen.", 0, 1, this.location));
            children.add(new Property("specimenQuantity", "Quantity", "The quantity of specimen in the container; may be volume, dimensions, or other appropriate measurements, depending on the specimen type.", 0, 1, this.specimenQuantity));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1335157162: {
                    return new Property("device", "Reference(Device)", "The device resource for the the container holding the specimen. If the container is in a holder then the referenced device will point to a parent device.", 0, 1, this.device);
                }
                case 1901043637: {
                    return new Property("location", "Reference(Location)", "The location of the container holding the specimen.", 0, 1, this.location);
                }
                case 1485980595: {
                    return new Property("specimenQuantity", "Quantity", "The quantity of specimen in the container; may be volume, dimensions, or other appropriate measurements, depending on the specimen type.", 0, 1, this.specimenQuantity);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1335157162: {
                    Base[] baseArray;
                    if (this.device == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.device;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.location;
                    }
                    return baseArray;
                }
                case 1485980595: {
                    Base[] baseArray;
                    if (this.specimenQuantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.specimenQuantity;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1335157162: {
                    this.device = TypeConvertor.castToReference(value);
                    return value;
                }
                case 1901043637: {
                    this.location = TypeConvertor.castToReference(value);
                    return value;
                }
                case 1485980595: {
                    this.specimenQuantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("device")) {
                this.device = TypeConvertor.castToReference(value);
            } else if (name.equals("location")) {
                this.location = TypeConvertor.castToReference(value);
            } else if (name.equals("specimenQuantity")) {
                this.specimenQuantity = TypeConvertor.castToQuantity(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1335157162: {
                    return this.getDevice();
                }
                case 1901043637: {
                    return this.getLocation();
                }
                case 1485980595: {
                    return this.getSpecimenQuantity();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1335157162: {
                    return new String[]{"Reference"};
                }
                case 1901043637: {
                    return new String[]{"Reference"};
                }
                case 1485980595: {
                    return new String[]{"Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("device")) {
                this.device = new Reference();
                return this.device;
            }
            if (name.equals("location")) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals("specimenQuantity")) {
                this.specimenQuantity = new Quantity();
                return this.specimenQuantity;
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenContainerComponent copy() {
            SpecimenContainerComponent dst = new SpecimenContainerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SpecimenContainerComponent dst) {
            super.copyValues(dst);
            dst.device = this.device == null ? null : this.device.copy();
            dst.location = this.location == null ? null : this.location.copy();
            dst.specimenQuantity = this.specimenQuantity == null ? null : this.specimenQuantity.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenContainerComponent)) {
                return false;
            }
            SpecimenContainerComponent o = (SpecimenContainerComponent)other_;
            return SpecimenContainerComponent.compareDeep(this.device, o.device, true) && SpecimenContainerComponent.compareDeep(this.location, o.location, true) && SpecimenContainerComponent.compareDeep(this.specimenQuantity, o.specimenQuantity, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenContainerComponent)) {
                return false;
            }
            SpecimenContainerComponent o = (SpecimenContainerComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.device, this.location, this.specimenQuantity});
        }

        @Override
        public String fhirType() {
            return "Specimen.container";
        }
    }

    @Block
    public static class SpecimenProcessingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Textual description of procedure", formalDefinition="Textual description of procedure.")
        protected StringType description;
        @Child(name="method", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates the treatment step  applied to the specimen", formalDefinition="A coded value specifying the method used to process the specimen.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/specimen-processing-method")
        protected CodeableConcept method;
        @Child(name="additive", type={Substance.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Material used in the processing step", formalDefinition="Material used in the processing step.")
        protected List<Reference> additive;
        @Child(name="time", type={DateTimeType.class, Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date and time of specimen processing", formalDefinition="A record of the time or period when the specimen processing occurred.  For example the time of sample fixation or the period of time the sample was in formalin.")
        protected DataType time;
        private static final long serialVersionUID = -329044827L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenProcessingComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SpecimenProcessingComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SpecimenProcessingComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public CodeableConcept getMethod() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenProcessingComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new CodeableConcept();
                }
            }
            return this.method;
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public SpecimenProcessingComponent setMethod(CodeableConcept value) {
            this.method = value;
            return this;
        }

        public List<Reference> getAdditive() {
            if (this.additive == null) {
                this.additive = new ArrayList<Reference>();
            }
            return this.additive;
        }

        public SpecimenProcessingComponent setAdditive(List<Reference> theAdditive) {
            this.additive = theAdditive;
            return this;
        }

        public boolean hasAdditive() {
            if (this.additive == null) {
                return false;
            }
            for (Reference item : this.additive) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addAdditive() {
            Reference t = new Reference();
            if (this.additive == null) {
                this.additive = new ArrayList<Reference>();
            }
            this.additive.add(t);
            return t;
        }

        public SpecimenProcessingComponent addAdditive(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.additive == null) {
                this.additive = new ArrayList<Reference>();
            }
            this.additive.add(t);
            return this;
        }

        public Reference getAdditiveFirstRep() {
            if (this.getAdditive().isEmpty()) {
                this.addAdditive();
            }
            return this.getAdditive().get(0);
        }

        public DataType getTime() {
            return this.time;
        }

        public DateTimeType getTimeDateTimeType() throws FHIRException {
            if (this.time == null) {
                this.time = new DateTimeType();
            }
            if (!(this.time instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.time.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.time;
        }

        public boolean hasTimeDateTimeType() {
            return this != null && this.time instanceof DateTimeType;
        }

        public Period getTimePeriod() throws FHIRException {
            if (this.time == null) {
                this.time = new Period();
            }
            if (!(this.time instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.time.getClass().getName() + " was encountered");
            }
            return (Period)this.time;
        }

        public boolean hasTimePeriod() {
            return this != null && this.time instanceof Period;
        }

        public boolean hasTime() {
            return this.time != null && !this.time.isEmpty();
        }

        public SpecimenProcessingComponent setTime(DataType value) {
            if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
                throw new FHIRException("Not the right type for Specimen.processing.time[x]: " + value.fhirType());
            }
            this.time = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "string", "Textual description of procedure.", 0, 1, this.description));
            children.add(new Property("method", "CodeableConcept", "A coded value specifying the method used to process the specimen.", 0, 1, this.method));
            children.add(new Property("additive", "Reference(Substance)", "Material used in the processing step.", 0, Integer.MAX_VALUE, this.additive));
            children.add(new Property("time[x]", "dateTime|Period", "A record of the time or period when the specimen processing occurred.  For example the time of sample fixation or the period of time the sample was in formalin.", 0, 1, this.time));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "string", "Textual description of procedure.", 0, 1, this.description);
                }
                case -1077554975: {
                    return new Property("method", "CodeableConcept", "A coded value specifying the method used to process the specimen.", 0, 1, this.method);
                }
                case -1226589236: {
                    return new Property("additive", "Reference(Substance)", "Material used in the processing step.", 0, Integer.MAX_VALUE, this.additive);
                }
                case -1313930605: {
                    return new Property("time[x]", "dateTime|Period", "A record of the time or period when the specimen processing occurred.  For example the time of sample fixation or the period of time the sample was in formalin.", 0, 1, this.time);
                }
                case 3560141: {
                    return new Property("time[x]", "dateTime|Period", "A record of the time or period when the specimen processing occurred.  For example the time of sample fixation or the period of time the sample was in formalin.", 0, 1, this.time);
                }
                case 2135345544: {
                    return new Property("time[x]", "dateTime", "A record of the time or period when the specimen processing occurred.  For example the time of sample fixation or the period of time the sample was in formalin.", 0, 1, this.time);
                }
                case 693544686: {
                    return new Property("time[x]", "Period", "A record of the time or period when the specimen processing occurred.  For example the time of sample fixation or the period of time the sample was in formalin.", 0, 1, this.time);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -1077554975: {
                    Base[] baseArray;
                    if (this.method == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.method;
                    }
                    return baseArray;
                }
                case -1226589236: {
                    return this.additive == null ? new Base[]{} : this.additive.toArray(new Base[this.additive.size()]);
                }
                case 3560141: {
                    Base[] baseArray;
                    if (this.time == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.time;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -1077554975: {
                    this.method = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1226589236: {
                    this.getAdditive().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case 3560141: {
                    this.time = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("method")) {
                this.method = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("additive")) {
                this.getAdditive().add(TypeConvertor.castToReference(value));
            } else if (name.equals("time[x]")) {
                this.time = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1077554975: {
                    return this.getMethod();
                }
                case -1226589236: {
                    return this.addAdditive();
                }
                case -1313930605: {
                    return this.getTime();
                }
                case 3560141: {
                    return this.getTime();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1077554975: {
                    return new String[]{"CodeableConcept"};
                }
                case -1226589236: {
                    return new String[]{"Reference"};
                }
                case 3560141: {
                    return new String[]{"dateTime", "Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type Specimen.processing.description");
            }
            if (name.equals("method")) {
                this.method = new CodeableConcept();
                return this.method;
            }
            if (name.equals("additive")) {
                return this.addAdditive();
            }
            if (name.equals("timeDateTime")) {
                this.time = new DateTimeType();
                return this.time;
            }
            if (name.equals("timePeriod")) {
                this.time = new Period();
                return this.time;
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenProcessingComponent copy() {
            SpecimenProcessingComponent dst = new SpecimenProcessingComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SpecimenProcessingComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            CodeableConcept codeableConcept = dst.method = this.method == null ? null : this.method.copy();
            if (this.additive != null) {
                dst.additive = new ArrayList<Reference>();
                for (Reference i : this.additive) {
                    dst.additive.add(i.copy());
                }
            }
            dst.time = this.time == null ? null : this.time.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenProcessingComponent)) {
                return false;
            }
            SpecimenProcessingComponent o = (SpecimenProcessingComponent)other_;
            return SpecimenProcessingComponent.compareDeep(this.description, o.description, true) && SpecimenProcessingComponent.compareDeep(this.method, o.method, true) && SpecimenProcessingComponent.compareDeep(this.additive, o.additive, true) && SpecimenProcessingComponent.compareDeep(this.time, o.time, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenProcessingComponent)) {
                return false;
            }
            SpecimenProcessingComponent o = (SpecimenProcessingComponent)other_;
            return SpecimenProcessingComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.method, this.additive, this.time});
        }

        @Override
        public String fhirType() {
            return "Specimen.processing";
        }
    }

    @Block
    public static class SpecimenCollectionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="collector", type={Practitioner.class, PractitionerRole.class, Patient.class, RelatedPerson.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Who collected the specimen", formalDefinition="Person who collected the specimen.")
        protected Reference collector;
        @Child(name="collected", type={DateTimeType.class, Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Collection time", formalDefinition="Time when specimen was collected from subject - the physiologically relevant time.")
        protected DataType collected;
        @Child(name="duration", type={Duration.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How long it took to collect specimen", formalDefinition="The span of time over which the collection of a specimen occurred.")
        protected Duration duration;
        @Child(name="quantity", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The quantity of specimen collected", formalDefinition="The quantity of specimen collected; for instance the volume of a blood sample, or the physical measurement of an anatomic pathology sample.")
        protected Quantity quantity;
        @Child(name="method", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Technique used to perform collection", formalDefinition="A coded value specifying the technique that is used to perform the procedure.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/specimen-collection-method")
        protected CodeableConcept method;
        @Child(name="device", type={CodeableReference.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Device used to perform collection", formalDefinition="A coded value specifying the technique that is used to perform the procedure.")
        protected CodeableReference device;
        @Child(name="procedure", type={Procedure.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The procedure that collects the specimen", formalDefinition="The procedure event during which the specimen was collected (e.g. the surgery leading to the collection of a pathology sample).")
        protected Reference procedure;
        @Child(name="bodySite", type={CodeableReference.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Anatomical collection site", formalDefinition="Anatomical location from which the specimen was collected (if subject is a patient). This is the target site.  This element is not used for environmental specimens.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
        protected CodeableReference bodySite;
        @Child(name="fastingStatus", type={CodeableConcept.class, Duration.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Whether or how long patient abstained from food and/or drink", formalDefinition="Abstinence or reduction from some or all food, drink, or both, for a period of time prior to sample collection.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0916")
        protected DataType fastingStatus;
        private static final long serialVersionUID = 953983070L;

        public Reference getCollector() {
            if (this.collector == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenCollectionComponent.collector");
                }
                if (Configuration.doAutoCreate()) {
                    this.collector = new Reference();
                }
            }
            return this.collector;
        }

        public boolean hasCollector() {
            return this.collector != null && !this.collector.isEmpty();
        }

        public SpecimenCollectionComponent setCollector(Reference value) {
            this.collector = value;
            return this;
        }

        public DataType getCollected() {
            return this.collected;
        }

        public DateTimeType getCollectedDateTimeType() throws FHIRException {
            if (this.collected == null) {
                this.collected = new DateTimeType();
            }
            if (!(this.collected instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.collected.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.collected;
        }

        public boolean hasCollectedDateTimeType() {
            return this != null && this.collected instanceof DateTimeType;
        }

        public Period getCollectedPeriod() throws FHIRException {
            if (this.collected == null) {
                this.collected = new Period();
            }
            if (!(this.collected instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.collected.getClass().getName() + " was encountered");
            }
            return (Period)this.collected;
        }

        public boolean hasCollectedPeriod() {
            return this != null && this.collected instanceof Period;
        }

        public boolean hasCollected() {
            return this.collected != null && !this.collected.isEmpty();
        }

        public SpecimenCollectionComponent setCollected(DataType value) {
            if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
                throw new FHIRException("Not the right type for Specimen.collection.collected[x]: " + value.fhirType());
            }
            this.collected = value;
            return this;
        }

        public Duration getDuration() {
            if (this.duration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenCollectionComponent.duration");
                }
                if (Configuration.doAutoCreate()) {
                    this.duration = new Duration();
                }
            }
            return this.duration;
        }

        public boolean hasDuration() {
            return this.duration != null && !this.duration.isEmpty();
        }

        public SpecimenCollectionComponent setDuration(Duration value) {
            this.duration = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenCollectionComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public SpecimenCollectionComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public CodeableConcept getMethod() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenCollectionComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new CodeableConcept();
                }
            }
            return this.method;
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public SpecimenCollectionComponent setMethod(CodeableConcept value) {
            this.method = value;
            return this;
        }

        public CodeableReference getDevice() {
            if (this.device == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenCollectionComponent.device");
                }
                if (Configuration.doAutoCreate()) {
                    this.device = new CodeableReference();
                }
            }
            return this.device;
        }

        public boolean hasDevice() {
            return this.device != null && !this.device.isEmpty();
        }

        public SpecimenCollectionComponent setDevice(CodeableReference value) {
            this.device = value;
            return this;
        }

        public Reference getProcedure() {
            if (this.procedure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenCollectionComponent.procedure");
                }
                if (Configuration.doAutoCreate()) {
                    this.procedure = new Reference();
                }
            }
            return this.procedure;
        }

        public boolean hasProcedure() {
            return this.procedure != null && !this.procedure.isEmpty();
        }

        public SpecimenCollectionComponent setProcedure(Reference value) {
            this.procedure = value;
            return this;
        }

        public CodeableReference getBodySite() {
            if (this.bodySite == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenCollectionComponent.bodySite");
                }
                if (Configuration.doAutoCreate()) {
                    this.bodySite = new CodeableReference();
                }
            }
            return this.bodySite;
        }

        public boolean hasBodySite() {
            return this.bodySite != null && !this.bodySite.isEmpty();
        }

        public SpecimenCollectionComponent setBodySite(CodeableReference value) {
            this.bodySite = value;
            return this;
        }

        public DataType getFastingStatus() {
            return this.fastingStatus;
        }

        public CodeableConcept getFastingStatusCodeableConcept() throws FHIRException {
            if (this.fastingStatus == null) {
                this.fastingStatus = new CodeableConcept();
            }
            if (!(this.fastingStatus instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.fastingStatus.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.fastingStatus;
        }

        public boolean hasFastingStatusCodeableConcept() {
            return this != null && this.fastingStatus instanceof CodeableConcept;
        }

        public Duration getFastingStatusDuration() throws FHIRException {
            if (this.fastingStatus == null) {
                this.fastingStatus = new Duration();
            }
            if (!(this.fastingStatus instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.fastingStatus.getClass().getName() + " was encountered");
            }
            return (Duration)this.fastingStatus;
        }

        public boolean hasFastingStatusDuration() {
            return this != null && this.fastingStatus instanceof Duration;
        }

        public boolean hasFastingStatus() {
            return this.fastingStatus != null && !this.fastingStatus.isEmpty();
        }

        public SpecimenCollectionComponent setFastingStatus(DataType value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Duration)) {
                throw new FHIRException("Not the right type for Specimen.collection.fastingStatus[x]: " + value.fhirType());
            }
            this.fastingStatus = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Specimen.SP_COLLECTOR, "Reference(Practitioner|PractitionerRole|Patient|RelatedPerson)", "Person who collected the specimen.", 0, 1, this.collector));
            children.add(new Property("collected[x]", "dateTime|Period", "Time when specimen was collected from subject - the physiologically relevant time.", 0, 1, this.collected));
            children.add(new Property("duration", "Duration", "The span of time over which the collection of a specimen occurred.", 0, 1, this.duration));
            children.add(new Property("quantity", "Quantity", "The quantity of specimen collected; for instance the volume of a blood sample, or the physical measurement of an anatomic pathology sample.", 0, 1, this.quantity));
            children.add(new Property("method", "CodeableConcept", "A coded value specifying the technique that is used to perform the procedure.", 0, 1, this.method));
            children.add(new Property("device", "CodeableReference(Device)", "A coded value specifying the technique that is used to perform the procedure.", 0, 1, this.device));
            children.add(new Property(Specimen.SP_PROCEDURE, "Reference(Procedure)", "The procedure event during which the specimen was collected (e.g. the surgery leading to the collection of a pathology sample).", 0, 1, this.procedure));
            children.add(new Property("bodySite", "CodeableReference(BodyStructure)", "Anatomical location from which the specimen was collected (if subject is a patient). This is the target site.  This element is not used for environmental specimens.", 0, 1, this.bodySite));
            children.add(new Property("fastingStatus[x]", "CodeableConcept|Duration", "Abstinence or reduction from some or all food, drink, or both, for a period of time prior to sample collection.", 0, 1, this.fastingStatus));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1883491469: {
                    return new Property(Specimen.SP_COLLECTOR, "Reference(Practitioner|PractitionerRole|Patient|RelatedPerson)", "Person who collected the specimen.", 0, 1, this.collector);
                }
                case 1632037015: {
                    return new Property("collected[x]", "dateTime|Period", "Time when specimen was collected from subject - the physiologically relevant time.", 0, 1, this.collected);
                }
                case 1883491145: {
                    return new Property("collected[x]", "dateTime|Period", "Time when specimen was collected from subject - the physiologically relevant time.", 0, 1, this.collected);
                }
                case 2005009924: {
                    return new Property("collected[x]", "dateTime", "Time when specimen was collected from subject - the physiologically relevant time.", 0, 1, this.collected);
                }
                case 653185642: {
                    return new Property("collected[x]", "Period", "Time when specimen was collected from subject - the physiologically relevant time.", 0, 1, this.collected);
                }
                case -1992012396: {
                    return new Property("duration", "Duration", "The span of time over which the collection of a specimen occurred.", 0, 1, this.duration);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The quantity of specimen collected; for instance the volume of a blood sample, or the physical measurement of an anatomic pathology sample.", 0, 1, this.quantity);
                }
                case -1077554975: {
                    return new Property("method", "CodeableConcept", "A coded value specifying the technique that is used to perform the procedure.", 0, 1, this.method);
                }
                case -1335157162: {
                    return new Property("device", "CodeableReference(Device)", "A coded value specifying the technique that is used to perform the procedure.", 0, 1, this.device);
                }
                case -1095204141: {
                    return new Property(Specimen.SP_PROCEDURE, "Reference(Procedure)", "The procedure event during which the specimen was collected (e.g. the surgery leading to the collection of a pathology sample).", 0, 1, this.procedure);
                }
                case 1702620169: {
                    return new Property("bodySite", "CodeableReference(BodyStructure)", "Anatomical location from which the specimen was collected (if subject is a patient). This is the target site.  This element is not used for environmental specimens.", 0, 1, this.bodySite);
                }
                case -570577944: {
                    return new Property("fastingStatus[x]", "CodeableConcept|Duration", "Abstinence or reduction from some or all food, drink, or both, for a period of time prior to sample collection.", 0, 1, this.fastingStatus);
                }
                case -701550184: {
                    return new Property("fastingStatus[x]", "CodeableConcept|Duration", "Abstinence or reduction from some or all food, drink, or both, for a period of time prior to sample collection.", 0, 1, this.fastingStatus);
                }
                case -1153232151: {
                    return new Property("fastingStatus[x]", "CodeableConcept", "Abstinence or reduction from some or all food, drink, or both, for a period of time prior to sample collection.", 0, 1, this.fastingStatus);
                }
                case -433140916: {
                    return new Property("fastingStatus[x]", "Duration", "Abstinence or reduction from some or all food, drink, or both, for a period of time prior to sample collection.", 0, 1, this.fastingStatus);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1883491469: {
                    Base[] baseArray;
                    if (this.collector == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.collector;
                    }
                    return baseArray;
                }
                case 1883491145: {
                    Base[] baseArray;
                    if (this.collected == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.collected;
                    }
                    return baseArray;
                }
                case -1992012396: {
                    Base[] baseArray;
                    if (this.duration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.duration;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -1077554975: {
                    Base[] baseArray;
                    if (this.method == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.method;
                    }
                    return baseArray;
                }
                case -1335157162: {
                    Base[] baseArray;
                    if (this.device == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.device;
                    }
                    return baseArray;
                }
                case -1095204141: {
                    Base[] baseArray;
                    if (this.procedure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.procedure;
                    }
                    return baseArray;
                }
                case 1702620169: {
                    Base[] baseArray;
                    if (this.bodySite == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.bodySite;
                    }
                    return baseArray;
                }
                case -701550184: {
                    Base[] baseArray;
                    if (this.fastingStatus == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.fastingStatus;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1883491469: {
                    this.collector = TypeConvertor.castToReference(value);
                    return value;
                }
                case 1883491145: {
                    this.collected = TypeConvertor.castToType(value);
                    return value;
                }
                case -1992012396: {
                    this.duration = TypeConvertor.castToDuration(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -1077554975: {
                    this.method = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1335157162: {
                    this.device = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -1095204141: {
                    this.procedure = TypeConvertor.castToReference(value);
                    return value;
                }
                case 1702620169: {
                    this.bodySite = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -701550184: {
                    this.fastingStatus = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Specimen.SP_COLLECTOR)) {
                this.collector = TypeConvertor.castToReference(value);
            } else if (name.equals("collected[x]")) {
                this.collected = TypeConvertor.castToType(value);
            } else if (name.equals("duration")) {
                this.duration = TypeConvertor.castToDuration(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("method")) {
                this.method = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("device")) {
                this.device = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals(Specimen.SP_PROCEDURE)) {
                this.procedure = TypeConvertor.castToReference(value);
            } else if (name.equals("bodySite")) {
                this.bodySite = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("fastingStatus[x]")) {
                this.fastingStatus = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1883491469: {
                    return this.getCollector();
                }
                case 1632037015: {
                    return this.getCollected();
                }
                case 1883491145: {
                    return this.getCollected();
                }
                case -1992012396: {
                    return this.getDuration();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -1077554975: {
                    return this.getMethod();
                }
                case -1335157162: {
                    return this.getDevice();
                }
                case -1095204141: {
                    return this.getProcedure();
                }
                case 1702620169: {
                    return this.getBodySite();
                }
                case -570577944: {
                    return this.getFastingStatus();
                }
                case -701550184: {
                    return this.getFastingStatus();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1883491469: {
                    return new String[]{"Reference"};
                }
                case 1883491145: {
                    return new String[]{"dateTime", "Period"};
                }
                case -1992012396: {
                    return new String[]{"Duration"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case -1077554975: {
                    return new String[]{"CodeableConcept"};
                }
                case -1335157162: {
                    return new String[]{"CodeableReference"};
                }
                case -1095204141: {
                    return new String[]{"Reference"};
                }
                case 1702620169: {
                    return new String[]{"CodeableReference"};
                }
                case -701550184: {
                    return new String[]{"CodeableConcept", "Duration"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Specimen.SP_COLLECTOR)) {
                this.collector = new Reference();
                return this.collector;
            }
            if (name.equals("collectedDateTime")) {
                this.collected = new DateTimeType();
                return this.collected;
            }
            if (name.equals("collectedPeriod")) {
                this.collected = new Period();
                return this.collected;
            }
            if (name.equals("duration")) {
                this.duration = new Duration();
                return this.duration;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("method")) {
                this.method = new CodeableConcept();
                return this.method;
            }
            if (name.equals("device")) {
                this.device = new CodeableReference();
                return this.device;
            }
            if (name.equals(Specimen.SP_PROCEDURE)) {
                this.procedure = new Reference();
                return this.procedure;
            }
            if (name.equals("bodySite")) {
                this.bodySite = new CodeableReference();
                return this.bodySite;
            }
            if (name.equals("fastingStatusCodeableConcept")) {
                this.fastingStatus = new CodeableConcept();
                return this.fastingStatus;
            }
            if (name.equals("fastingStatusDuration")) {
                this.fastingStatus = new Duration();
                return this.fastingStatus;
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenCollectionComponent copy() {
            SpecimenCollectionComponent dst = new SpecimenCollectionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SpecimenCollectionComponent dst) {
            super.copyValues(dst);
            dst.collector = this.collector == null ? null : this.collector.copy();
            dst.collected = this.collected == null ? null : this.collected.copy();
            dst.duration = this.duration == null ? null : this.duration.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.method = this.method == null ? null : this.method.copy();
            dst.device = this.device == null ? null : this.device.copy();
            dst.procedure = this.procedure == null ? null : this.procedure.copy();
            dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
            dst.fastingStatus = this.fastingStatus == null ? null : this.fastingStatus.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenCollectionComponent)) {
                return false;
            }
            SpecimenCollectionComponent o = (SpecimenCollectionComponent)other_;
            return SpecimenCollectionComponent.compareDeep(this.collector, o.collector, true) && SpecimenCollectionComponent.compareDeep(this.collected, o.collected, true) && SpecimenCollectionComponent.compareDeep(this.duration, o.duration, true) && SpecimenCollectionComponent.compareDeep(this.quantity, o.quantity, true) && SpecimenCollectionComponent.compareDeep(this.method, o.method, true) && SpecimenCollectionComponent.compareDeep(this.device, o.device, true) && SpecimenCollectionComponent.compareDeep(this.procedure, o.procedure, true) && SpecimenCollectionComponent.compareDeep(this.bodySite, o.bodySite, true) && SpecimenCollectionComponent.compareDeep(this.fastingStatus, o.fastingStatus, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenCollectionComponent)) {
                return false;
            }
            SpecimenCollectionComponent o = (SpecimenCollectionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.collector, this.collected, this.duration, this.quantity, this.method, this.device, this.procedure, this.bodySite, this.fastingStatus});
        }

        @Override
        public String fhirType() {
            return "Specimen.collection";
        }
    }

    @Block
    public static class SpecimenFeatureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Highlighted feature", formalDefinition="The landmark or feature being highlighted.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
        protected CodeableConcept type;
        @Child(name="description", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Information about the feature", formalDefinition="Description of the feature of the specimen.")
        protected StringType description;
        private static final long serialVersionUID = 1762224562L;

        public SpecimenFeatureComponent() {
        }

        public SpecimenFeatureComponent(CodeableConcept type, String description) {
            this.setType(type);
            this.setDescription(description);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenFeatureComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SpecimenFeatureComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenFeatureComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SpecimenFeatureComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SpecimenFeatureComponent setDescription(String value) {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Specimen.SP_TYPE, "CodeableConcept", "The landmark or feature being highlighted.", 0, 1, this.type));
            children.add(new Property("description", "string", "Description of the feature of the specimen.", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(Specimen.SP_TYPE, "CodeableConcept", "The landmark or feature being highlighted.", 0, 1, this.type);
                }
                case -1724546052: {
                    return new Property("description", "string", "Description of the feature of the specimen.", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Specimen.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Specimen.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type Specimen.feature.description");
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenFeatureComponent copy() {
            SpecimenFeatureComponent dst = new SpecimenFeatureComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SpecimenFeatureComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.description = this.description == null ? null : this.description.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenFeatureComponent)) {
                return false;
            }
            SpecimenFeatureComponent o = (SpecimenFeatureComponent)other_;
            return SpecimenFeatureComponent.compareDeep(this.type, o.type, true) && SpecimenFeatureComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenFeatureComponent)) {
                return false;
            }
            SpecimenFeatureComponent o = (SpecimenFeatureComponent)other_;
            return SpecimenFeatureComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.description});
        }

        @Override
        public String fhirType() {
            return "Specimen.feature";
        }
    }

    public static class SpecimenStatusEnumFactory
    implements EnumFactory<SpecimenStatus> {
        @Override
        public SpecimenStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("available".equals(codeString)) {
                return SpecimenStatus.AVAILABLE;
            }
            if ("unavailable".equals(codeString)) {
                return SpecimenStatus.UNAVAILABLE;
            }
            if ("unsatisfactory".equals(codeString)) {
                return SpecimenStatus.UNSATISFACTORY;
            }
            if ("entered-in-error".equals(codeString)) {
                return SpecimenStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown SpecimenStatus code '" + codeString + "'");
        }

        public Enumeration<SpecimenStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SpecimenStatus>(this, SpecimenStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<SpecimenStatus>(this, SpecimenStatus.NULL, code);
            }
            if ("available".equals(codeString)) {
                return new Enumeration<SpecimenStatus>(this, SpecimenStatus.AVAILABLE, code);
            }
            if ("unavailable".equals(codeString)) {
                return new Enumeration<SpecimenStatus>(this, SpecimenStatus.UNAVAILABLE, code);
            }
            if ("unsatisfactory".equals(codeString)) {
                return new Enumeration<SpecimenStatus>(this, SpecimenStatus.UNSATISFACTORY, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<SpecimenStatus>(this, SpecimenStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown SpecimenStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(SpecimenStatus code) {
            if (code == SpecimenStatus.AVAILABLE) {
                return "available";
            }
            if (code == SpecimenStatus.UNAVAILABLE) {
                return "unavailable";
            }
            if (code == SpecimenStatus.UNSATISFACTORY) {
                return "unsatisfactory";
            }
            if (code == SpecimenStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(SpecimenStatus code) {
            return code.getSystem();
        }
    }

    public static enum SpecimenStatus {
        AVAILABLE,
        UNAVAILABLE,
        UNSATISFACTORY,
        ENTEREDINERROR,
        NULL;


        public static SpecimenStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("available".equals(codeString)) {
                return AVAILABLE;
            }
            if ("unavailable".equals(codeString)) {
                return UNAVAILABLE;
            }
            if ("unsatisfactory".equals(codeString)) {
                return UNSATISFACTORY;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SpecimenStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case AVAILABLE: {
                    return "available";
                }
                case UNAVAILABLE: {
                    return "unavailable";
                }
                case UNSATISFACTORY: {
                    return "unsatisfactory";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case AVAILABLE: {
                    return "http://hl7.org/fhir/specimen-status";
                }
                case UNAVAILABLE: {
                    return "http://hl7.org/fhir/specimen-status";
                }
                case UNSATISFACTORY: {
                    return "http://hl7.org/fhir/specimen-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/specimen-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case AVAILABLE: {
                    return "The physical specimen is present and in good condition.";
                }
                case UNAVAILABLE: {
                    return "There is no physical specimen because it is either lost, destroyed or consumed.";
                }
                case UNSATISFACTORY: {
                    return "The specimen cannot be used because of a quality issue such as a broken container, contamination, or too old.";
                }
                case ENTEREDINERROR: {
                    return "The specimen was entered in error and therefore nullified.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case AVAILABLE: {
                    return "Available";
                }
                case UNAVAILABLE: {
                    return "Unavailable";
                }
                case UNSATISFACTORY: {
                    return "Unsatisfactory";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class SpecimenCombinedEnumFactory
    implements EnumFactory<SpecimenCombined> {
        @Override
        public SpecimenCombined fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("grouped".equals(codeString)) {
                return SpecimenCombined.GROUPED;
            }
            if ("pooled".equals(codeString)) {
                return SpecimenCombined.POOLED;
            }
            throw new IllegalArgumentException("Unknown SpecimenCombined code '" + codeString + "'");
        }

        public Enumeration<SpecimenCombined> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SpecimenCombined>(this, SpecimenCombined.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<SpecimenCombined>(this, SpecimenCombined.NULL, code);
            }
            if ("grouped".equals(codeString)) {
                return new Enumeration<SpecimenCombined>(this, SpecimenCombined.GROUPED, code);
            }
            if ("pooled".equals(codeString)) {
                return new Enumeration<SpecimenCombined>(this, SpecimenCombined.POOLED, code);
            }
            throw new FHIRException("Unknown SpecimenCombined code '" + codeString + "'");
        }

        @Override
        public String toCode(SpecimenCombined code) {
            if (code == SpecimenCombined.GROUPED) {
                return "grouped";
            }
            if (code == SpecimenCombined.POOLED) {
                return "pooled";
            }
            return "?";
        }

        @Override
        public String toSystem(SpecimenCombined code) {
            return code.getSystem();
        }
    }

    public static enum SpecimenCombined {
        GROUPED,
        POOLED,
        NULL;


        public static SpecimenCombined fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("grouped".equals(codeString)) {
                return GROUPED;
            }
            if ("pooled".equals(codeString)) {
                return POOLED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SpecimenCombined code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case GROUPED: {
                    return "grouped";
                }
                case POOLED: {
                    return "pooled";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case GROUPED: {
                    return "http://hl7.org/fhir/specimen-combined";
                }
                case POOLED: {
                    return "http://hl7.org/fhir/specimen-combined";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case GROUPED: {
                    return "The specimen is in a group.";
                }
                case POOLED: {
                    return "The specimen is pooled.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case GROUPED: {
                    return "Grouped";
                }
                case POOLED: {
                    return "Pooled";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

