/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BiologicallyDerivedProductDispense;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceAssociation;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EncounterHistory;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.FormularyItem;
import org.hl7.fhir.r5.model.GenomicStudy;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.InventoryItem;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationStatement;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Signature;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestPlan;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.Transport;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;

@ResourceDef(name="Provenance", profile="http://hl7.org/fhir/StructureDefinition/Provenance")
public class Provenance
extends DomainResource {
    @Child(name="target", type={Reference.class}, order=0, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Target Reference(s) (usually version specific)", formalDefinition="The Reference(s) that were generated or updated by  the activity described in this resource. A provenance can point to more than one target if multiple resources were created/updated by the same activity.")
    protected List<Reference> target;
    @Child(name="occurred", type={Period.class, DateTimeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the activity occurred", formalDefinition="The period during which the activity occurred.")
    protected DataType occurred;
    @Child(name="recorded", type={InstantType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the activity was recorded / updated", formalDefinition="The instant of time at which the activity was recorded.")
    protected InstantType recorded;
    @Child(name="policy", type={UriType.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Policy or plan the activity was defined by", formalDefinition="Policy or plan the activity was defined by. Typically, a single activity may have multiple applicable policy documents, such as patient consent, guarantor funding, etc.")
    protected List<UriType> policy;
    @Child(name="location", type={Location.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where the activity occurred, if relevant", formalDefinition="Where the activity occurred, if relevant.")
    protected Reference location;
    @Child(name="authorization", type={CodeableReference.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Authorization (purposeOfUse) related to the event", formalDefinition="The authorization (e.g., PurposeOfUse) that was used during the event being recorded.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-PurposeOfUse")
    protected List<CodeableReference> authorization;
    @Child(name="activity", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Activity that occurred", formalDefinition="An activity is something that occurs over a period of time and acts upon or with entities; it may include consuming, processing, transforming, modifying, relocating, using, or generating entities.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/provenance-activity-type")
    protected CodeableConcept activity;
    @Child(name="basedOn", type={CarePlan.class, DeviceRequest.class, ImmunizationRecommendation.class, MedicationRequest.class, NutritionOrder.class, ServiceRequest.class, Task.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Workflow authorization within which this event occurred", formalDefinition="Allows tracing of authorizatino for the events and tracking whether proposals/recommendations were acted upon.")
    protected List<Reference> basedOn;
    @Child(name="patient", type={Patient.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The patient is the subject of the data created/updated (.target) by the activity", formalDefinition="The patient element is available to enable deterministic tracking of activities that involve the patient as the subject of the data used in an activity.")
    protected Reference patient;
    @Child(name="encounter", type={Encounter.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Encounter within which this event occurred or which the event is tightly associated", formalDefinition="This will typically be the encounter the event occurred, but some events may be initiated prior to or after the official completion of an encounter but still be tied to the context of the encounter (e.g. pre-admission lab tests).")
    protected Reference encounter;
    @Child(name="agent", type={}, order=10, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Actor involved", formalDefinition="An actor taking a role in an activity  for which it can be assigned some degree of responsibility for the activity taking place.")
    protected List<ProvenanceAgentComponent> agent;
    @Child(name="entity", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="An entity used in this activity", formalDefinition="An entity used in this activity.")
    protected List<ProvenanceEntityComponent> entity;
    @Child(name="signature", type={Signature.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Signature on target", formalDefinition="A digital signature on the target Reference(s). The signer should match a Provenance.agent. The purpose of the signature is indicated.")
    protected List<Signature> signature;
    private static final long serialVersionUID = 2001521682L;
    @SearchParamDefinition(name="activity", path="Provenance.activity", description="Activity that occurred", type="token")
    public static final String SP_ACTIVITY = "activity";
    public static final TokenClientParam ACTIVITY = new TokenClientParam("activity");
    @SearchParamDefinition(name="agent-role", path="Provenance.agent.role", description="What the agents role was", type="token")
    public static final String SP_AGENT_ROLE = "agent-role";
    public static final TokenClientParam AGENT_ROLE = new TokenClientParam("agent-role");
    @SearchParamDefinition(name="agent-type", path="Provenance.agent.type", description="How the agent participated", type="token")
    public static final String SP_AGENT_TYPE = "agent-type";
    public static final TokenClientParam AGENT_TYPE = new TokenClientParam("agent-type");
    @SearchParamDefinition(name="agent", path="Provenance.agent.who", description="Who participated", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={CareTeam.class, Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_AGENT = "agent";
    public static final ReferenceClientParam AGENT = new ReferenceClientParam("agent");
    public static final Include INCLUDE_AGENT = new Include("Provenance:agent").toLocked();
    @SearchParamDefinition(name="based-on", path="Provenance.basedOn", description="Reference to the service request.", type="reference", target={CarePlan.class, DeviceRequest.class, ImmunizationRecommendation.class, MedicationRequest.class, NutritionOrder.class, ServiceRequest.class, Task.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("Provenance:based-on").toLocked();
    @SearchParamDefinition(name="entity", path="Provenance.entity.what", description="Identity of entity", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BiologicallyDerivedProductDispense.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceAssociation.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentReference.class, Encounter.class, EncounterHistory.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryItem.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Parameters.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestPlan.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_ENTITY = "entity";
    public static final ReferenceClientParam ENTITY = new ReferenceClientParam("entity");
    public static final Include INCLUDE_ENTITY = new Include("Provenance:entity").toLocked();
    @SearchParamDefinition(name="location", path="Provenance.location", description="Where the activity occurred, if relevant", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Provenance:location").toLocked();
    @SearchParamDefinition(name="recorded", path="Provenance.recorded", description="When the activity was recorded / updated", type="date")
    public static final String SP_RECORDED = "recorded";
    public static final DateClientParam RECORDED = new DateClientParam("recorded");
    @SearchParamDefinition(name="signature-type", path="Provenance.signature.type", description="Indication of the reason the entity signed the object(s)", type="token")
    public static final String SP_SIGNATURE_TYPE = "signature-type";
    public static final TokenClientParam SIGNATURE_TYPE = new TokenClientParam("signature-type");
    @SearchParamDefinition(name="target", path="Provenance.target", description="Target Reference(s) (usually version specific)", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BiologicallyDerivedProductDispense.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceAssociation.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentReference.class, Encounter.class, EncounterHistory.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryItem.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Parameters.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestPlan.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_TARGET = "target";
    public static final ReferenceClientParam TARGET = new ReferenceClientParam("target");
    public static final Include INCLUDE_TARGET = new Include("Provenance:target").toLocked();
    @SearchParamDefinition(name="when", path="(Provenance.occurred.ofType(dateTime))", description="When the activity occurred", type="date")
    public static final String SP_WHEN = "when";
    public static final DateClientParam WHEN = new DateClientParam("when");
    @SearchParamDefinition(name="encounter", path="AuditEvent.encounter | CarePlan.encounter | ChargeItem.encounter | Claim.item.encounter | ClinicalImpression.encounter | Communication.encounter | CommunicationRequest.encounter | Composition.encounter | Condition.encounter | DeviceRequest.encounter | DiagnosticReport.encounter | EncounterHistory.encounter | ExplanationOfBenefit.item.encounter | Flag.encounter | ImagingStudy.encounter | List.encounter | MedicationDispense.encounter | MedicationStatement.encounter | NutritionIntake.encounter | NutritionOrder.encounter | Observation.encounter | Procedure.encounter | Provenance.encounter | QuestionnaireResponse.encounter | RequestOrchestration.encounter | RiskAssessment.encounter | ServiceRequest.encounter | Task.encounter | VisionPrescription.encounter", description="Multiple Resources: \r\n\r\n* [AuditEvent](auditevent.html): Encounter related to the activity recorded in the AuditEvent\r\n* [CarePlan](careplan.html): The Encounter during which this CarePlan was created\r\n* [ChargeItem](chargeitem.html): Encounter associated with event\r\n* [Claim](claim.html): Encounters associated with a billed line item\r\n* [ClinicalImpression](clinicalimpression.html): The Encounter during which this ClinicalImpression was created\r\n* [Communication](communication.html): The Encounter during which this Communication was created\r\n* [CommunicationRequest](communicationrequest.html): The Encounter during which this CommunicationRequest was created\r\n* [Composition](composition.html): Context of the Composition\r\n* [Condition](condition.html): The Encounter during which this Condition was created\r\n* [DeviceRequest](devicerequest.html): Encounter during which request was created\r\n* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made\r\n* [EncounterHistory](encounterhistory.html): The Encounter associated with this set of history values\r\n* [ExplanationOfBenefit](explanationofbenefit.html): Encounters associated with a billed line item\r\n* [Flag](flag.html): Alert relevant during encounter\r\n* [ImagingStudy](imagingstudy.html): The context of the study\r\n* [List](list.html): Context in which list created\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with a specific encounter\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific encounter\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific encounter\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier\r\n* [Observation](observation.html): Encounter related to the observation\r\n* [Procedure](procedure.html): The Encounter during which this Procedure was created\r\n* [Provenance](provenance.html): Encounter related to the Provenance\r\n* [QuestionnaireResponse](questionnaireresponse.html): Encounter associated with the questionnaire response\r\n* [RequestOrchestration](requestorchestration.html): The encounter the request orchestration applies to\r\n* [RiskAssessment](riskassessment.html): Where was assessment performed?\r\n* [ServiceRequest](servicerequest.html): An encounter in which this request is made\r\n* [Task](task.html): Search by encounter\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier\r\n", type="reference", target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Provenance:encounter").toLocked();
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Provenance:patient").toLocked();

    public Provenance() {
    }

    public Provenance(Reference target, ProvenanceAgentComponent agent) {
        this.addTarget(target);
        this.addAgent(agent);
    }

    public List<Reference> getTarget() {
        if (this.target == null) {
            this.target = new ArrayList<Reference>();
        }
        return this.target;
    }

    public Provenance setTarget(List<Reference> theTarget) {
        this.target = theTarget;
        return this;
    }

    public boolean hasTarget() {
        if (this.target == null) {
            return false;
        }
        for (Reference item : this.target) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addTarget() {
        Reference t = new Reference();
        if (this.target == null) {
            this.target = new ArrayList<Reference>();
        }
        this.target.add(t);
        return t;
    }

    public Provenance addTarget(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.target == null) {
            this.target = new ArrayList<Reference>();
        }
        this.target.add(t);
        return this;
    }

    public Reference getTargetFirstRep() {
        if (this.getTarget().isEmpty()) {
            this.addTarget();
        }
        return this.getTarget().get(0);
    }

    public DataType getOccurred() {
        return this.occurred;
    }

    public Period getOccurredPeriod() throws FHIRException {
        if (this.occurred == null) {
            this.occurred = new Period();
        }
        if (!(this.occurred instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurred.getClass().getName() + " was encountered");
        }
        return (Period)this.occurred;
    }

    public boolean hasOccurredPeriod() {
        return this != null && this.occurred instanceof Period;
    }

    public DateTimeType getOccurredDateTimeType() throws FHIRException {
        if (this.occurred == null) {
            this.occurred = new DateTimeType();
        }
        if (!(this.occurred instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurred.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurred;
    }

    public boolean hasOccurredDateTimeType() {
        return this != null && this.occurred instanceof DateTimeType;
    }

    public boolean hasOccurred() {
        return this.occurred != null && !this.occurred.isEmpty();
    }

    public Provenance setOccurred(DataType value) {
        if (value != null && !(value instanceof Period) && !(value instanceof DateTimeType)) {
            throw new FHIRException("Not the right type for Provenance.occurred[x]: " + value.fhirType());
        }
        this.occurred = value;
        return this;
    }

    public InstantType getRecordedElement() {
        if (this.recorded == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Provenance.recorded");
            }
            if (Configuration.doAutoCreate()) {
                this.recorded = new InstantType();
            }
        }
        return this.recorded;
    }

    public boolean hasRecordedElement() {
        return this.recorded != null && !this.recorded.isEmpty();
    }

    public boolean hasRecorded() {
        return this.recorded != null && !this.recorded.isEmpty();
    }

    public Provenance setRecordedElement(InstantType value) {
        this.recorded = value;
        return this;
    }

    public Date getRecorded() {
        return this.recorded == null ? null : (Date)this.recorded.getValue();
    }

    public Provenance setRecorded(Date value) {
        if (value == null) {
            this.recorded = null;
        } else {
            if (this.recorded == null) {
                this.recorded = new InstantType();
            }
            this.recorded.setValue(value);
        }
        return this;
    }

    public List<UriType> getPolicy() {
        if (this.policy == null) {
            this.policy = new ArrayList<UriType>();
        }
        return this.policy;
    }

    public Provenance setPolicy(List<UriType> thePolicy) {
        this.policy = thePolicy;
        return this;
    }

    public boolean hasPolicy() {
        if (this.policy == null) {
            return false;
        }
        for (UriType item : this.policy) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addPolicyElement() {
        UriType t = new UriType();
        if (this.policy == null) {
            this.policy = new ArrayList<UriType>();
        }
        this.policy.add(t);
        return t;
    }

    public Provenance addPolicy(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.policy == null) {
            this.policy = new ArrayList<UriType>();
        }
        this.policy.add(t);
        return this;
    }

    public boolean hasPolicy(String value) {
        if (this.policy == null) {
            return false;
        }
        for (UriType v : this.policy) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Provenance.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public Provenance setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public List<CodeableReference> getAuthorization() {
        if (this.authorization == null) {
            this.authorization = new ArrayList<CodeableReference>();
        }
        return this.authorization;
    }

    public Provenance setAuthorization(List<CodeableReference> theAuthorization) {
        this.authorization = theAuthorization;
        return this;
    }

    public boolean hasAuthorization() {
        if (this.authorization == null) {
            return false;
        }
        for (CodeableReference item : this.authorization) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addAuthorization() {
        CodeableReference t = new CodeableReference();
        if (this.authorization == null) {
            this.authorization = new ArrayList<CodeableReference>();
        }
        this.authorization.add(t);
        return t;
    }

    public Provenance addAuthorization(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.authorization == null) {
            this.authorization = new ArrayList<CodeableReference>();
        }
        this.authorization.add(t);
        return this;
    }

    public CodeableReference getAuthorizationFirstRep() {
        if (this.getAuthorization().isEmpty()) {
            this.addAuthorization();
        }
        return this.getAuthorization().get(0);
    }

    public CodeableConcept getActivity() {
        if (this.activity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Provenance.activity");
            }
            if (Configuration.doAutoCreate()) {
                this.activity = new CodeableConcept();
            }
        }
        return this.activity;
    }

    public boolean hasActivity() {
        return this.activity != null && !this.activity.isEmpty();
    }

    public Provenance setActivity(CodeableConcept value) {
        this.activity = value;
        return this;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public Provenance setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public Provenance addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Provenance.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public Provenance setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Provenance.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public Provenance setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public List<ProvenanceAgentComponent> getAgent() {
        if (this.agent == null) {
            this.agent = new ArrayList<ProvenanceAgentComponent>();
        }
        return this.agent;
    }

    public Provenance setAgent(List<ProvenanceAgentComponent> theAgent) {
        this.agent = theAgent;
        return this;
    }

    public boolean hasAgent() {
        if (this.agent == null) {
            return false;
        }
        for (ProvenanceAgentComponent item : this.agent) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProvenanceAgentComponent addAgent() {
        ProvenanceAgentComponent t = new ProvenanceAgentComponent();
        if (this.agent == null) {
            this.agent = new ArrayList<ProvenanceAgentComponent>();
        }
        this.agent.add(t);
        return t;
    }

    public Provenance addAgent(ProvenanceAgentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.agent == null) {
            this.agent = new ArrayList<ProvenanceAgentComponent>();
        }
        this.agent.add(t);
        return this;
    }

    public ProvenanceAgentComponent getAgentFirstRep() {
        if (this.getAgent().isEmpty()) {
            this.addAgent();
        }
        return this.getAgent().get(0);
    }

    public List<ProvenanceEntityComponent> getEntity() {
        if (this.entity == null) {
            this.entity = new ArrayList<ProvenanceEntityComponent>();
        }
        return this.entity;
    }

    public Provenance setEntity(List<ProvenanceEntityComponent> theEntity) {
        this.entity = theEntity;
        return this;
    }

    public boolean hasEntity() {
        if (this.entity == null) {
            return false;
        }
        for (ProvenanceEntityComponent item : this.entity) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProvenanceEntityComponent addEntity() {
        ProvenanceEntityComponent t = new ProvenanceEntityComponent();
        if (this.entity == null) {
            this.entity = new ArrayList<ProvenanceEntityComponent>();
        }
        this.entity.add(t);
        return t;
    }

    public Provenance addEntity(ProvenanceEntityComponent t) {
        if (t == null) {
            return this;
        }
        if (this.entity == null) {
            this.entity = new ArrayList<ProvenanceEntityComponent>();
        }
        this.entity.add(t);
        return this;
    }

    public ProvenanceEntityComponent getEntityFirstRep() {
        if (this.getEntity().isEmpty()) {
            this.addEntity();
        }
        return this.getEntity().get(0);
    }

    public List<Signature> getSignature() {
        if (this.signature == null) {
            this.signature = new ArrayList<Signature>();
        }
        return this.signature;
    }

    public Provenance setSignature(List<Signature> theSignature) {
        this.signature = theSignature;
        return this;
    }

    public boolean hasSignature() {
        if (this.signature == null) {
            return false;
        }
        for (Signature item : this.signature) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Signature addSignature() {
        Signature t = new Signature();
        if (this.signature == null) {
            this.signature = new ArrayList<Signature>();
        }
        this.signature.add(t);
        return t;
    }

    public Provenance addSignature(Signature t) {
        if (t == null) {
            return this;
        }
        if (this.signature == null) {
            this.signature = new ArrayList<Signature>();
        }
        this.signature.add(t);
        return this;
    }

    public Signature getSignatureFirstRep() {
        if (this.getSignature().isEmpty()) {
            this.addSignature();
        }
        return this.getSignature().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_TARGET, "Reference(Any)", "The Reference(s) that were generated or updated by  the activity described in this resource. A provenance can point to more than one target if multiple resources were created/updated by the same activity.", 0, Integer.MAX_VALUE, this.target));
        children.add(new Property("occurred[x]", "Period|dateTime", "The period during which the activity occurred.", 0, 1, this.occurred));
        children.add(new Property(SP_RECORDED, "instant", "The instant of time at which the activity was recorded.", 0, 1, this.recorded));
        children.add(new Property("policy", "uri", "Policy or plan the activity was defined by. Typically, a single activity may have multiple applicable policy documents, such as patient consent, guarantor funding, etc.", 0, Integer.MAX_VALUE, this.policy));
        children.add(new Property(SP_LOCATION, "Reference(Location)", "Where the activity occurred, if relevant.", 0, 1, this.location));
        children.add(new Property("authorization", "CodeableReference", "The authorization (e.g., PurposeOfUse) that was used during the event being recorded.", 0, Integer.MAX_VALUE, this.authorization));
        children.add(new Property(SP_ACTIVITY, "CodeableConcept", "An activity is something that occurs over a period of time and acts upon or with entities; it may include consuming, processing, transforming, modifying, relocating, using, or generating entities.", 0, 1, this.activity));
        children.add(new Property("basedOn", "Reference(CarePlan|DeviceRequest|ImmunizationRecommendation|MedicationRequest|NutritionOrder|ServiceRequest|Task)", "Allows tracing of authorizatino for the events and tracking whether proposals/recommendations were acted upon.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient element is available to enable deterministic tracking of activities that involve the patient as the subject of the data used in an activity.", 0, 1, this.patient));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "This will typically be the encounter the event occurred, but some events may be initiated prior to or after the official completion of an encounter but still be tied to the context of the encounter (e.g. pre-admission lab tests).", 0, 1, this.encounter));
        children.add(new Property(SP_AGENT, "", "An actor taking a role in an activity  for which it can be assigned some degree of responsibility for the activity taking place.", 0, Integer.MAX_VALUE, this.agent));
        children.add(new Property(SP_ENTITY, "", "An entity used in this activity.", 0, Integer.MAX_VALUE, this.entity));
        children.add(new Property("signature", "Signature", "A digital signature on the target Reference(s). The signer should match a Provenance.agent. The purpose of the signature is indicated.", 0, Integer.MAX_VALUE, this.signature));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -880905839: {
                return new Property(SP_TARGET, "Reference(Any)", "The Reference(s) that were generated or updated by  the activity described in this resource. A provenance can point to more than one target if multiple resources were created/updated by the same activity.", 0, Integer.MAX_VALUE, this.target);
            }
            case 784181563: {
                return new Property("occurred[x]", "Period|dateTime", "The period during which the activity occurred.", 0, 1, this.occurred);
            }
            case 792816933: {
                return new Property("occurred[x]", "Period|dateTime", "The period during which the activity occurred.", 0, 1, this.occurred);
            }
            case 894082886: {
                return new Property("occurred[x]", "Period", "The period during which the activity occurred.", 0, 1, this.occurred);
            }
            case 1579027424: {
                return new Property("occurred[x]", "dateTime", "The period during which the activity occurred.", 0, 1, this.occurred);
            }
            case -799233872: {
                return new Property(SP_RECORDED, "instant", "The instant of time at which the activity was recorded.", 0, 1, this.recorded);
            }
            case -982670030: {
                return new Property("policy", "uri", "Policy or plan the activity was defined by. Typically, a single activity may have multiple applicable policy documents, such as patient consent, guarantor funding, etc.", 0, Integer.MAX_VALUE, this.policy);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "Reference(Location)", "Where the activity occurred, if relevant.", 0, 1, this.location);
            }
            case -1385570183: {
                return new Property("authorization", "CodeableReference", "The authorization (e.g., PurposeOfUse) that was used during the event being recorded.", 0, Integer.MAX_VALUE, this.authorization);
            }
            case -1655966961: {
                return new Property(SP_ACTIVITY, "CodeableConcept", "An activity is something that occurs over a period of time and acts upon or with entities; it may include consuming, processing, transforming, modifying, relocating, using, or generating entities.", 0, 1, this.activity);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan|DeviceRequest|ImmunizationRecommendation|MedicationRequest|NutritionOrder|ServiceRequest|Task)", "Allows tracing of authorizatino for the events and tracking whether proposals/recommendations were acted upon.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The patient element is available to enable deterministic tracking of activities that involve the patient as the subject of the data used in an activity.", 0, 1, this.patient);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "This will typically be the encounter the event occurred, but some events may be initiated prior to or after the official completion of an encounter but still be tied to the context of the encounter (e.g. pre-admission lab tests).", 0, 1, this.encounter);
            }
            case 92750597: {
                return new Property(SP_AGENT, "", "An actor taking a role in an activity  for which it can be assigned some degree of responsibility for the activity taking place.", 0, Integer.MAX_VALUE, this.agent);
            }
            case -1298275357: {
                return new Property(SP_ENTITY, "", "An entity used in this activity.", 0, Integer.MAX_VALUE, this.entity);
            }
            case 1073584312: {
                return new Property("signature", "Signature", "A digital signature on the target Reference(s). The signer should match a Provenance.agent. The purpose of the signature is indicated.", 0, Integer.MAX_VALUE, this.signature);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -880905839: {
                return this.target == null ? new Base[]{} : this.target.toArray(new Base[this.target.size()]);
            }
            case 792816933: {
                Base[] baseArray;
                if (this.occurred == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.occurred;
                }
                return baseArray;
            }
            case -799233872: {
                Base[] baseArray;
                if (this.recorded == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.recorded;
                }
                return baseArray;
            }
            case -982670030: {
                return this.policy == null ? new Base[]{} : this.policy.toArray(new Base[this.policy.size()]);
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.location;
                }
                return baseArray;
            }
            case -1385570183: {
                return this.authorization == null ? new Base[]{} : this.authorization.toArray(new Base[this.authorization.size()]);
            }
            case -1655966961: {
                Base[] baseArray;
                if (this.activity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.activity;
                }
                return baseArray;
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.patient;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.encounter;
                }
                return baseArray;
            }
            case 92750597: {
                return this.agent == null ? new Base[]{} : this.agent.toArray(new Base[this.agent.size()]);
            }
            case -1298275357: {
                return this.entity == null ? new Base[]{} : this.entity.toArray(new Base[this.entity.size()]);
            }
            case 1073584312: {
                return this.signature == null ? new Base[]{} : this.signature.toArray(new Base[this.signature.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -880905839: {
                this.getTarget().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 792816933: {
                this.occurred = TypeConvertor.castToType(value);
                return value;
            }
            case -799233872: {
                this.recorded = TypeConvertor.castToInstant(value);
                return value;
            }
            case -982670030: {
                this.getPolicy().add(TypeConvertor.castToUri(value));
                return value;
            }
            case 1901043637: {
                this.location = TypeConvertor.castToReference(value);
                return value;
            }
            case -1385570183: {
                this.getAuthorization().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case -1655966961: {
                this.activity = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -791418107: {
                this.patient = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case 92750597: {
                this.getAgent().add((ProvenanceAgentComponent)value);
                return value;
            }
            case -1298275357: {
                this.getEntity().add((ProvenanceEntityComponent)value);
                return value;
            }
            case 1073584312: {
                this.getSignature().add(TypeConvertor.castToSignature(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_TARGET)) {
            this.getTarget().add(TypeConvertor.castToReference(value));
        } else if (name.equals("occurred[x]")) {
            this.occurred = TypeConvertor.castToType(value);
        } else if (name.equals(SP_RECORDED)) {
            this.recorded = TypeConvertor.castToInstant(value);
        } else if (name.equals("policy")) {
            this.getPolicy().add(TypeConvertor.castToUri(value));
        } else if (name.equals(SP_LOCATION)) {
            this.location = TypeConvertor.castToReference(value);
        } else if (name.equals("authorization")) {
            this.getAuthorization().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals(SP_ACTIVITY)) {
            this.activity = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_AGENT)) {
            this.getAgent().add((ProvenanceAgentComponent)value);
        } else if (name.equals(SP_ENTITY)) {
            this.getEntity().add((ProvenanceEntityComponent)value);
        } else if (name.equals("signature")) {
            this.getSignature().add(TypeConvertor.castToSignature(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -880905839: {
                return this.addTarget();
            }
            case 784181563: {
                return this.getOccurred();
            }
            case 792816933: {
                return this.getOccurred();
            }
            case -799233872: {
                return this.getRecordedElement();
            }
            case -982670030: {
                return this.addPolicyElement();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case -1385570183: {
                return this.addAuthorization();
            }
            case -1655966961: {
                return this.getActivity();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 92750597: {
                return this.addAgent();
            }
            case -1298275357: {
                return this.addEntity();
            }
            case 1073584312: {
                return this.addSignature();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -880905839: {
                return new String[]{"Reference"};
            }
            case 792816933: {
                return new String[]{"Period", "dateTime"};
            }
            case -799233872: {
                return new String[]{"instant"};
            }
            case -982670030: {
                return new String[]{"uri"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case -1385570183: {
                return new String[]{"CodeableReference"};
            }
            case -1655966961: {
                return new String[]{"CodeableConcept"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 92750597: {
                return new String[0];
            }
            case -1298275357: {
                return new String[0];
            }
            case 1073584312: {
                return new String[]{"Signature"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_TARGET)) {
            return this.addTarget();
        }
        if (name.equals("occurredPeriod")) {
            this.occurred = new Period();
            return this.occurred;
        }
        if (name.equals("occurredDateTime")) {
            this.occurred = new DateTimeType();
            return this.occurred;
        }
        if (name.equals(SP_RECORDED)) {
            throw new FHIRException("Cannot call addChild on a primitive type Provenance.recorded");
        }
        if (name.equals("policy")) {
            throw new FHIRException("Cannot call addChild on a primitive type Provenance.policy");
        }
        if (name.equals(SP_LOCATION)) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals("authorization")) {
            return this.addAuthorization();
        }
        if (name.equals(SP_ACTIVITY)) {
            this.activity = new CodeableConcept();
            return this.activity;
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_AGENT)) {
            return this.addAgent();
        }
        if (name.equals(SP_ENTITY)) {
            return this.addEntity();
        }
        if (name.equals("signature")) {
            return this.addSignature();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Provenance";
    }

    @Override
    public Provenance copy() {
        Provenance dst = new Provenance();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Provenance dst) {
        super.copyValues(dst);
        if (this.target != null) {
            dst.target = new ArrayList<Reference>();
            for (Reference reference : this.target) {
                dst.target.add(reference.copy());
            }
        }
        dst.occurred = this.occurred == null ? null : this.occurred.copy();
        InstantType instantType = dst.recorded = this.recorded == null ? null : this.recorded.copy();
        if (this.policy != null) {
            dst.policy = new ArrayList<UriType>();
            for (UriType uriType : this.policy) {
                dst.policy.add(uriType.copy());
            }
        }
        Reference reference = dst.location = this.location == null ? null : this.location.copy();
        if (this.authorization != null) {
            dst.authorization = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.authorization) {
                dst.authorization.add(codeableReference.copy());
            }
        }
        CodeableConcept codeableConcept = dst.activity = this.activity == null ? null : this.activity.copy();
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference2 : this.basedOn) {
                dst.basedOn.add(reference2.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        Reference reference3 = dst.encounter = this.encounter == null ? null : this.encounter.copy();
        if (this.agent != null) {
            dst.agent = new ArrayList<ProvenanceAgentComponent>();
            for (ProvenanceAgentComponent provenanceAgentComponent : this.agent) {
                dst.agent.add(provenanceAgentComponent.copy());
            }
        }
        if (this.entity != null) {
            dst.entity = new ArrayList<ProvenanceEntityComponent>();
            for (ProvenanceEntityComponent provenanceEntityComponent : this.entity) {
                dst.entity.add(provenanceEntityComponent.copy());
            }
        }
        if (this.signature != null) {
            dst.signature = new ArrayList<Signature>();
            for (Signature signature : this.signature) {
                dst.signature.add(signature.copy());
            }
        }
    }

    protected Provenance typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Provenance)) {
            return false;
        }
        Provenance o = (Provenance)other_;
        return Provenance.compareDeep(this.target, o.target, true) && Provenance.compareDeep(this.occurred, o.occurred, true) && Provenance.compareDeep(this.recorded, o.recorded, true) && Provenance.compareDeep(this.policy, o.policy, true) && Provenance.compareDeep(this.location, o.location, true) && Provenance.compareDeep(this.authorization, o.authorization, true) && Provenance.compareDeep(this.activity, o.activity, true) && Provenance.compareDeep(this.basedOn, o.basedOn, true) && Provenance.compareDeep(this.patient, o.patient, true) && Provenance.compareDeep(this.encounter, o.encounter, true) && Provenance.compareDeep(this.agent, o.agent, true) && Provenance.compareDeep(this.entity, o.entity, true) && Provenance.compareDeep(this.signature, o.signature, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Provenance)) {
            return false;
        }
        Provenance o = (Provenance)other_;
        return Provenance.compareValues(this.recorded, o.recorded, true) && Provenance.compareValues(this.policy, o.policy, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.target, this.occurred, this.recorded, this.policy, this.location, this.authorization, this.activity, this.basedOn, this.patient, this.encounter, this.agent, this.entity, this.signature});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Provenance;
    }

    @Block
    public static class ProvenanceEntityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="revision | quotation | source | instantiates | removal", formalDefinition="How the entity was used during the activity.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/provenance-entity-role")
        protected Enumeration<ProvenanceEntityRole> role;
        @Child(name="what", type={Reference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identity of entity", formalDefinition="Identity of the  Entity used. May be a logical or physical uri and maybe absolute or relative.")
        protected Reference what;
        @Child(name="agent", type={ProvenanceAgentComponent.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Entity is attributed to this agent", formalDefinition="The entity is attributed to an agent to express the agent's responsibility for that entity, possibly along with other agents. This description can be understood as shorthand for saying that the agent was responsible for the activity which used the entity.")
        protected List<ProvenanceAgentComponent> agent;
        private static final long serialVersionUID = 211110220L;

        public ProvenanceEntityComponent() {
        }

        public ProvenanceEntityComponent(ProvenanceEntityRole role, Reference what) {
            this.setRole(role);
            this.setWhat(what);
        }

        public Enumeration<ProvenanceEntityRole> getRoleElement() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceEntityComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new Enumeration<ProvenanceEntityRole>(new ProvenanceEntityRoleEnumFactory());
                }
            }
            return this.role;
        }

        public boolean hasRoleElement() {
            return this.role != null && !this.role.isEmpty();
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public ProvenanceEntityComponent setRoleElement(Enumeration<ProvenanceEntityRole> value) {
            this.role = value;
            return this;
        }

        public ProvenanceEntityRole getRole() {
            return this.role == null ? null : (ProvenanceEntityRole)((Object)this.role.getValue());
        }

        public ProvenanceEntityComponent setRole(ProvenanceEntityRole value) {
            if (this.role == null) {
                this.role = new Enumeration<ProvenanceEntityRole>(new ProvenanceEntityRoleEnumFactory());
            }
            this.role.setValue((Object)value);
            return this;
        }

        public Reference getWhat() {
            if (this.what == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceEntityComponent.what");
                }
                if (Configuration.doAutoCreate()) {
                    this.what = new Reference();
                }
            }
            return this.what;
        }

        public boolean hasWhat() {
            return this.what != null && !this.what.isEmpty();
        }

        public ProvenanceEntityComponent setWhat(Reference value) {
            this.what = value;
            return this;
        }

        public List<ProvenanceAgentComponent> getAgent() {
            if (this.agent == null) {
                this.agent = new ArrayList<ProvenanceAgentComponent>();
            }
            return this.agent;
        }

        public ProvenanceEntityComponent setAgent(List<ProvenanceAgentComponent> theAgent) {
            this.agent = theAgent;
            return this;
        }

        public boolean hasAgent() {
            if (this.agent == null) {
                return false;
            }
            for (ProvenanceAgentComponent item : this.agent) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProvenanceAgentComponent addAgent() {
            ProvenanceAgentComponent t = new ProvenanceAgentComponent();
            if (this.agent == null) {
                this.agent = new ArrayList<ProvenanceAgentComponent>();
            }
            this.agent.add(t);
            return t;
        }

        public ProvenanceEntityComponent addAgent(ProvenanceAgentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.agent == null) {
                this.agent = new ArrayList<ProvenanceAgentComponent>();
            }
            this.agent.add(t);
            return this;
        }

        public ProvenanceAgentComponent getAgentFirstRep() {
            if (this.getAgent().isEmpty()) {
                this.addAgent();
            }
            return this.getAgent().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("role", "code", "How the entity was used during the activity.", 0, 1, this.role));
            children.add(new Property("what", "Reference(Any)", "Identity of the  Entity used. May be a logical or physical uri and maybe absolute or relative.", 0, 1, this.what));
            children.add(new Property(Provenance.SP_AGENT, "@Provenance.agent", "The entity is attributed to an agent to express the agent's responsibility for that entity, possibly along with other agents. This description can be understood as shorthand for saying that the agent was responsible for the activity which used the entity.", 0, Integer.MAX_VALUE, this.agent));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property("role", "code", "How the entity was used during the activity.", 0, 1, this.role);
                }
                case 3648196: {
                    return new Property("what", "Reference(Any)", "Identity of the  Entity used. May be a logical or physical uri and maybe absolute or relative.", 0, 1, this.what);
                }
                case 92750597: {
                    return new Property(Provenance.SP_AGENT, "@Provenance.agent", "The entity is attributed to an agent to express the agent's responsibility for that entity, possibly along with other agents. This description can be understood as shorthand for saying that the agent was responsible for the activity which used the entity.", 0, Integer.MAX_VALUE, this.agent);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case 3648196: {
                    Base[] baseArray;
                    if (this.what == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.what;
                    }
                    return baseArray;
                }
                case 92750597: {
                    return this.agent == null ? new Base[]{} : this.agent.toArray(new Base[this.agent.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    value = new ProvenanceEntityRoleEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.role = value;
                    return value;
                }
                case 3648196: {
                    this.what = TypeConvertor.castToReference(value);
                    return value;
                }
                case 92750597: {
                    this.getAgent().add((ProvenanceAgentComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                value = new ProvenanceEntityRoleEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.role = value;
            } else if (name.equals("what")) {
                this.what = TypeConvertor.castToReference(value);
            } else if (name.equals(Provenance.SP_AGENT)) {
                this.getAgent().add((ProvenanceAgentComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRoleElement();
                }
                case 3648196: {
                    return this.getWhat();
                }
                case 92750597: {
                    return this.addAgent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"code"};
                }
                case 3648196: {
                    return new String[]{"Reference"};
                }
                case 92750597: {
                    return new String[]{"@Provenance.agent"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                throw new FHIRException("Cannot call addChild on a primitive type Provenance.entity.role");
            }
            if (name.equals("what")) {
                this.what = new Reference();
                return this.what;
            }
            if (name.equals(Provenance.SP_AGENT)) {
                return this.addAgent();
            }
            return super.addChild(name);
        }

        @Override
        public ProvenanceEntityComponent copy() {
            ProvenanceEntityComponent dst = new ProvenanceEntityComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ProvenanceEntityComponent dst) {
            super.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            Reference reference = dst.what = this.what == null ? null : this.what.copy();
            if (this.agent != null) {
                dst.agent = new ArrayList<ProvenanceAgentComponent>();
                for (ProvenanceAgentComponent i : this.agent) {
                    dst.agent.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvenanceEntityComponent)) {
                return false;
            }
            ProvenanceEntityComponent o = (ProvenanceEntityComponent)other_;
            return ProvenanceEntityComponent.compareDeep(this.role, o.role, true) && ProvenanceEntityComponent.compareDeep(this.what, o.what, true) && ProvenanceEntityComponent.compareDeep(this.agent, o.agent, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvenanceEntityComponent)) {
                return false;
            }
            ProvenanceEntityComponent o = (ProvenanceEntityComponent)other_;
            return ProvenanceEntityComponent.compareValues(this.role, o.role, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.role, this.what, this.agent});
        }

        @Override
        public String fhirType() {
            return "Provenance.entity";
        }
    }

    @Block
    public static class ProvenanceAgentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How the agent participated", formalDefinition="The Functional Role of the agent with respect to the activity.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/participation-role-type")
        protected CodeableConcept type;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What the agents role was", formalDefinition="The structural roles of the agent indicating the agent's competency. The security role enabling the agent with respect to the activity.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-role-type")
        protected List<CodeableConcept> role;
        @Child(name="who", type={Practitioner.class, PractitionerRole.class, Organization.class, CareTeam.class, Patient.class, Device.class, RelatedPerson.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The agent that participated in the event", formalDefinition="Indicates who or what performed in the event.")
        protected Reference who;
        @Child(name="onBehalfOf", type={Practitioner.class, PractitionerRole.class, Organization.class, CareTeam.class, Patient.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The agent that delegated", formalDefinition="The agent that delegated authority to perform the activity performed by the agent.who element.")
        protected Reference onBehalfOf;
        private static final long serialVersionUID = 642650054L;

        public ProvenanceAgentComponent() {
        }

        public ProvenanceAgentComponent(Reference who) {
            this.setWho(who);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceAgentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ProvenanceAgentComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getRole() {
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            return this.role;
        }

        public ProvenanceAgentComponent setRole(List<CodeableConcept> theRole) {
            this.role = theRole;
            return this;
        }

        public boolean hasRole() {
            if (this.role == null) {
                return false;
            }
            for (CodeableConcept item : this.role) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRole() {
            CodeableConcept t = new CodeableConcept();
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            this.role.add(t);
            return t;
        }

        public ProvenanceAgentComponent addRole(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            this.role.add(t);
            return this;
        }

        public CodeableConcept getRoleFirstRep() {
            if (this.getRole().isEmpty()) {
                this.addRole();
            }
            return this.getRole().get(0);
        }

        public Reference getWho() {
            if (this.who == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceAgentComponent.who");
                }
                if (Configuration.doAutoCreate()) {
                    this.who = new Reference();
                }
            }
            return this.who;
        }

        public boolean hasWho() {
            return this.who != null && !this.who.isEmpty();
        }

        public ProvenanceAgentComponent setWho(Reference value) {
            this.who = value;
            return this;
        }

        public Reference getOnBehalfOf() {
            if (this.onBehalfOf == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceAgentComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOf = new Reference();
                }
            }
            return this.onBehalfOf;
        }

        public boolean hasOnBehalfOf() {
            return this.onBehalfOf != null && !this.onBehalfOf.isEmpty();
        }

        public ProvenanceAgentComponent setOnBehalfOf(Reference value) {
            this.onBehalfOf = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The Functional Role of the agent with respect to the activity.", 0, 1, this.type));
            children.add(new Property("role", "CodeableConcept", "The structural roles of the agent indicating the agent's competency. The security role enabling the agent with respect to the activity.", 0, Integer.MAX_VALUE, this.role));
            children.add(new Property("who", "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient|Device|RelatedPerson)", "Indicates who or what performed in the event.", 0, 1, this.who));
            children.add(new Property("onBehalfOf", "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient)", "The agent that delegated authority to perform the activity performed by the agent.who element.", 0, 1, this.onBehalfOf));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The Functional Role of the agent with respect to the activity.", 0, 1, this.type);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "The structural roles of the agent indicating the agent's competency. The security role enabling the agent with respect to the activity.", 0, Integer.MAX_VALUE, this.role);
                }
                case 117694: {
                    return new Property("who", "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient|Device|RelatedPerson)", "Indicates who or what performed in the event.", 0, 1, this.who);
                }
                case -14402964: {
                    return new Property("onBehalfOf", "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient)", "The agent that delegated authority to perform the activity performed by the agent.who element.", 0, 1, this.onBehalfOf);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3506294: {
                    return this.role == null ? new Base[]{} : this.role.toArray(new Base[this.role.size()]);
                }
                case 117694: {
                    Base[] baseArray;
                    if (this.who == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.who;
                    }
                    return baseArray;
                }
                case -14402964: {
                    Base[] baseArray;
                    if (this.onBehalfOf == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.onBehalfOf;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3506294: {
                    this.getRole().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 117694: {
                    this.who = TypeConvertor.castToReference(value);
                    return value;
                }
                case -14402964: {
                    this.onBehalfOf = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("role")) {
                this.getRole().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("who")) {
                this.who = TypeConvertor.castToReference(value);
            } else if (name.equals("onBehalfOf")) {
                this.onBehalfOf = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 3506294: {
                    return this.addRole();
                }
                case 117694: {
                    return this.getWho();
                }
                case -14402964: {
                    return this.getOnBehalfOf();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case 117694: {
                    return new String[]{"Reference"};
                }
                case -14402964: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("role")) {
                return this.addRole();
            }
            if (name.equals("who")) {
                this.who = new Reference();
                return this.who;
            }
            if (name.equals("onBehalfOf")) {
                this.onBehalfOf = new Reference();
                return this.onBehalfOf;
            }
            return super.addChild(name);
        }

        @Override
        public ProvenanceAgentComponent copy() {
            ProvenanceAgentComponent dst = new ProvenanceAgentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ProvenanceAgentComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.role != null) {
                dst.role = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.role) {
                    dst.role.add(i.copy());
                }
            }
            dst.who = this.who == null ? null : this.who.copy();
            dst.onBehalfOf = this.onBehalfOf == null ? null : this.onBehalfOf.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvenanceAgentComponent)) {
                return false;
            }
            ProvenanceAgentComponent o = (ProvenanceAgentComponent)other_;
            return ProvenanceAgentComponent.compareDeep(this.type, o.type, true) && ProvenanceAgentComponent.compareDeep(this.role, o.role, true) && ProvenanceAgentComponent.compareDeep(this.who, o.who, true) && ProvenanceAgentComponent.compareDeep(this.onBehalfOf, o.onBehalfOf, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvenanceAgentComponent)) {
                return false;
            }
            ProvenanceAgentComponent o = (ProvenanceAgentComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.role, this.who, this.onBehalfOf});
        }

        @Override
        public String fhirType() {
            return "Provenance.agent";
        }
    }

    public static class ProvenanceEntityRoleEnumFactory
    implements EnumFactory<ProvenanceEntityRole> {
        @Override
        public ProvenanceEntityRole fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("revision".equals(codeString)) {
                return ProvenanceEntityRole.REVISION;
            }
            if ("quotation".equals(codeString)) {
                return ProvenanceEntityRole.QUOTATION;
            }
            if ("source".equals(codeString)) {
                return ProvenanceEntityRole.SOURCE;
            }
            if ("instantiates".equals(codeString)) {
                return ProvenanceEntityRole.INSTANTIATES;
            }
            if ("removal".equals(codeString)) {
                return ProvenanceEntityRole.REMOVAL;
            }
            throw new IllegalArgumentException("Unknown ProvenanceEntityRole code '" + codeString + "'");
        }

        public Enumeration<ProvenanceEntityRole> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.NULL, code);
            }
            if ("revision".equals(codeString)) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.REVISION, code);
            }
            if ("quotation".equals(codeString)) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.QUOTATION, code);
            }
            if ("source".equals(codeString)) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.SOURCE, code);
            }
            if ("instantiates".equals(codeString)) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.INSTANTIATES, code);
            }
            if ("removal".equals(codeString)) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.REMOVAL, code);
            }
            throw new FHIRException("Unknown ProvenanceEntityRole code '" + codeString + "'");
        }

        @Override
        public String toCode(ProvenanceEntityRole code) {
            if (code == ProvenanceEntityRole.REVISION) {
                return "revision";
            }
            if (code == ProvenanceEntityRole.QUOTATION) {
                return "quotation";
            }
            if (code == ProvenanceEntityRole.SOURCE) {
                return "source";
            }
            if (code == ProvenanceEntityRole.INSTANTIATES) {
                return "instantiates";
            }
            if (code == ProvenanceEntityRole.REMOVAL) {
                return "removal";
            }
            return "?";
        }

        @Override
        public String toSystem(ProvenanceEntityRole code) {
            return code.getSystem();
        }
    }

    public static enum ProvenanceEntityRole {
        REVISION,
        QUOTATION,
        SOURCE,
        INSTANTIATES,
        REMOVAL,
        NULL;


        public static ProvenanceEntityRole fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("revision".equals(codeString)) {
                return REVISION;
            }
            if ("quotation".equals(codeString)) {
                return QUOTATION;
            }
            if ("source".equals(codeString)) {
                return SOURCE;
            }
            if ("instantiates".equals(codeString)) {
                return INSTANTIATES;
            }
            if ("removal".equals(codeString)) {
                return REMOVAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ProvenanceEntityRole code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REVISION: {
                    return "revision";
                }
                case QUOTATION: {
                    return "quotation";
                }
                case SOURCE: {
                    return "source";
                }
                case INSTANTIATES: {
                    return "instantiates";
                }
                case REMOVAL: {
                    return "removal";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REVISION: {
                    return "http://hl7.org/fhir/provenance-entity-role";
                }
                case QUOTATION: {
                    return "http://hl7.org/fhir/provenance-entity-role";
                }
                case SOURCE: {
                    return "http://hl7.org/fhir/provenance-entity-role";
                }
                case INSTANTIATES: {
                    return "http://hl7.org/fhir/provenance-entity-role";
                }
                case REMOVAL: {
                    return "http://hl7.org/fhir/provenance-entity-role";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REVISION: {
                    return "An entity that is used by the activity to produce a new version of that entity.";
                }
                case QUOTATION: {
                    return "An entity that is copied in full or part by an agent that is not the author of the entity.";
                }
                case SOURCE: {
                    return "An entity that is used as input to the activity that produced the target.";
                }
                case INSTANTIATES: {
                    return "The record resulting from this event adheres to the protocol, guideline, order set or other definition represented by this entity.";
                }
                case REMOVAL: {
                    return "An entity that is removed from accessibility, usually through the DELETE operator.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REVISION: {
                    return "Revision";
                }
                case QUOTATION: {
                    return "Quotation";
                }
                case SOURCE: {
                    return "Source";
                }
                case INSTANTIATES: {
                    return "Instantiates";
                }
                case REMOVAL: {
                    return "Removal";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

