/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="ParameterDefinition")
public class ParameterDefinition
extends DataType
implements ICompositeType {
    @Child(name="name", type={CodeType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name used to access the parameter value", formalDefinition="The name of the parameter used to allow access to the value of the parameter in evaluation contexts.")
    protected CodeType name;
    @Child(name="use", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="in | out", formalDefinition="Whether the parameter is input or output for the module.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/operation-parameter-use")
    protected Enumeration<Enumerations.OperationParameterUse> use;
    @Child(name="min", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Minimum cardinality", formalDefinition="The minimum number of times this parameter SHALL appear in the request or response.")
    protected IntegerType min;
    @Child(name="max", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Maximum cardinality (a number of *)", formalDefinition="The maximum number of times this element is permitted to appear in the request or response.")
    protected StringType max;
    @Child(name="documentation", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A brief description of the parameter", formalDefinition="A brief discussion of what the parameter is for and how it is used by the module.")
    protected StringType documentation;
    @Child(name="type", type={CodeType.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What type of value", formalDefinition="The type of the parameter.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fhir-types")
    protected Enumeration<Enumerations.FHIRTypes> type;
    @Child(name="profile", type={CanonicalType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What profile the value is expected to be", formalDefinition="If specified, this indicates a profile that the input data must conform to, or that the output data will conform to.")
    protected CanonicalType profile;
    private static final long serialVersionUID = 2027429213L;

    public ParameterDefinition() {
    }

    public ParameterDefinition(Enumerations.OperationParameterUse use, Enumerations.FHIRTypes type) {
        this.setUse(use);
        this.setType(type);
    }

    public CodeType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ParameterDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new CodeType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public ParameterDefinition setNameElement(CodeType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public ParameterDefinition setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new CodeType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public Enumeration<Enumerations.OperationParameterUse> getUseElement() {
        if (this.use == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ParameterDefinition.use");
            }
            if (Configuration.doAutoCreate()) {
                this.use = new Enumeration<Enumerations.OperationParameterUse>(new Enumerations.OperationParameterUseEnumFactory());
            }
        }
        return this.use;
    }

    public boolean hasUseElement() {
        return this.use != null && !this.use.isEmpty();
    }

    public boolean hasUse() {
        return this.use != null && !this.use.isEmpty();
    }

    public ParameterDefinition setUseElement(Enumeration<Enumerations.OperationParameterUse> value) {
        this.use = value;
        return this;
    }

    public Enumerations.OperationParameterUse getUse() {
        return this.use == null ? null : (Enumerations.OperationParameterUse)((Object)this.use.getValue());
    }

    public ParameterDefinition setUse(Enumerations.OperationParameterUse value) {
        if (this.use == null) {
            this.use = new Enumeration<Enumerations.OperationParameterUse>(new Enumerations.OperationParameterUseEnumFactory());
        }
        this.use.setValue((Object)value);
        return this;
    }

    public IntegerType getMinElement() {
        if (this.min == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ParameterDefinition.min");
            }
            if (Configuration.doAutoCreate()) {
                this.min = new IntegerType();
            }
        }
        return this.min;
    }

    public boolean hasMinElement() {
        return this.min != null && !this.min.isEmpty();
    }

    public boolean hasMin() {
        return this.min != null && !this.min.isEmpty();
    }

    public ParameterDefinition setMinElement(IntegerType value) {
        this.min = value;
        return this;
    }

    public int getMin() {
        return this.min == null || this.min.isEmpty() ? 0 : (Integer)this.min.getValue();
    }

    public ParameterDefinition setMin(int value) {
        if (this.min == null) {
            this.min = new IntegerType();
        }
        this.min.setValue((Object)value);
        return this;
    }

    public StringType getMaxElement() {
        if (this.max == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ParameterDefinition.max");
            }
            if (Configuration.doAutoCreate()) {
                this.max = new StringType();
            }
        }
        return this.max;
    }

    public boolean hasMaxElement() {
        return this.max != null && !this.max.isEmpty();
    }

    public boolean hasMax() {
        return this.max != null && !this.max.isEmpty();
    }

    public ParameterDefinition setMaxElement(StringType value) {
        this.max = value;
        return this;
    }

    public String getMax() {
        return this.max == null ? null : (String)this.max.getValue();
    }

    public ParameterDefinition setMax(String value) {
        if (Utilities.noString((String)value)) {
            this.max = null;
        } else {
            if (this.max == null) {
                this.max = new StringType();
            }
            this.max.setValue(value);
        }
        return this;
    }

    public StringType getDocumentationElement() {
        if (this.documentation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ParameterDefinition.documentation");
            }
            if (Configuration.doAutoCreate()) {
                this.documentation = new StringType();
            }
        }
        return this.documentation;
    }

    public boolean hasDocumentationElement() {
        return this.documentation != null && !this.documentation.isEmpty();
    }

    public boolean hasDocumentation() {
        return this.documentation != null && !this.documentation.isEmpty();
    }

    public ParameterDefinition setDocumentationElement(StringType value) {
        this.documentation = value;
        return this;
    }

    public String getDocumentation() {
        return this.documentation == null ? null : (String)this.documentation.getValue();
    }

    public ParameterDefinition setDocumentation(String value) {
        if (Utilities.noString((String)value)) {
            this.documentation = null;
        } else {
            if (this.documentation == null) {
                this.documentation = new StringType();
            }
            this.documentation.setValue(value);
        }
        return this;
    }

    public Enumeration<Enumerations.FHIRTypes> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ParameterDefinition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<Enumerations.FHIRTypes>(new Enumerations.FHIRTypesEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public ParameterDefinition setTypeElement(Enumeration<Enumerations.FHIRTypes> value) {
        this.type = value;
        return this;
    }

    public Enumerations.FHIRTypes getType() {
        return this.type == null ? null : (Enumerations.FHIRTypes)((Object)this.type.getValue());
    }

    public ParameterDefinition setType(Enumerations.FHIRTypes value) {
        if (this.type == null) {
            this.type = new Enumeration<Enumerations.FHIRTypes>(new Enumerations.FHIRTypesEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public CanonicalType getProfileElement() {
        if (this.profile == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ParameterDefinition.profile");
            }
            if (Configuration.doAutoCreate()) {
                this.profile = new CanonicalType();
            }
        }
        return this.profile;
    }

    public boolean hasProfileElement() {
        return this.profile != null && !this.profile.isEmpty();
    }

    public boolean hasProfile() {
        return this.profile != null && !this.profile.isEmpty();
    }

    public ParameterDefinition setProfileElement(CanonicalType value) {
        this.profile = value;
        return this;
    }

    public String getProfile() {
        return this.profile == null ? null : (String)this.profile.getValue();
    }

    public ParameterDefinition setProfile(String value) {
        if (Utilities.noString((String)value)) {
            this.profile = null;
        } else {
            if (this.profile == null) {
                this.profile = new CanonicalType();
            }
            this.profile.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("name", "code", "The name of the parameter used to allow access to the value of the parameter in evaluation contexts.", 0, 1, this.name));
        children.add(new Property("use", "code", "Whether the parameter is input or output for the module.", 0, 1, this.use));
        children.add(new Property("min", "integer", "The minimum number of times this parameter SHALL appear in the request or response.", 0, 1, this.min));
        children.add(new Property("max", "string", "The maximum number of times this element is permitted to appear in the request or response.", 0, 1, this.max));
        children.add(new Property("documentation", "string", "A brief discussion of what the parameter is for and how it is used by the module.", 0, 1, this.documentation));
        children.add(new Property("type", "code", "The type of the parameter.", 0, 1, this.type));
        children.add(new Property("profile", "canonical(StructureDefinition)", "If specified, this indicates a profile that the input data must conform to, or that the output data will conform to.", 0, 1, this.profile));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3373707: {
                return new Property("name", "code", "The name of the parameter used to allow access to the value of the parameter in evaluation contexts.", 0, 1, this.name);
            }
            case 116103: {
                return new Property("use", "code", "Whether the parameter is input or output for the module.", 0, 1, this.use);
            }
            case 108114: {
                return new Property("min", "integer", "The minimum number of times this parameter SHALL appear in the request or response.", 0, 1, this.min);
            }
            case 107876: {
                return new Property("max", "string", "The maximum number of times this element is permitted to appear in the request or response.", 0, 1, this.max);
            }
            case 1587405498: {
                return new Property("documentation", "string", "A brief discussion of what the parameter is for and how it is used by the module.", 0, 1, this.documentation);
            }
            case 3575610: {
                return new Property("type", "code", "The type of the parameter.", 0, 1, this.type);
            }
            case -309425751: {
                return new Property("profile", "canonical(StructureDefinition)", "If specified, this indicates a profile that the input data must conform to, or that the output data will conform to.", 0, 1, this.profile);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.name;
                }
                return baseArray;
            }
            case 116103: {
                Base[] baseArray;
                if (this.use == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.use;
                }
                return baseArray;
            }
            case 108114: {
                Base[] baseArray;
                if (this.min == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.min;
                }
                return baseArray;
            }
            case 107876: {
                Base[] baseArray;
                if (this.max == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.max;
                }
                return baseArray;
            }
            case 1587405498: {
                Base[] baseArray;
                if (this.documentation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.documentation;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.type;
                }
                return baseArray;
            }
            case -309425751: {
                Base[] baseArray;
                if (this.profile == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.profile;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3373707: {
                this.name = TypeConvertor.castToCode(value);
                return value;
            }
            case 116103: {
                value = new Enumerations.OperationParameterUseEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.use = value;
                return value;
            }
            case 108114: {
                this.min = TypeConvertor.castToInteger(value);
                return value;
            }
            case 107876: {
                this.max = TypeConvertor.castToString(value);
                return value;
            }
            case 1587405498: {
                this.documentation = TypeConvertor.castToString(value);
                return value;
            }
            case 3575610: {
                value = new Enumerations.FHIRTypesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
                return value;
            }
            case -309425751: {
                this.profile = TypeConvertor.castToCanonical(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("name")) {
            this.name = TypeConvertor.castToCode(value);
        } else if (name.equals("use")) {
            value = new Enumerations.OperationParameterUseEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.use = value;
        } else if (name.equals("min")) {
            this.min = TypeConvertor.castToInteger(value);
        } else if (name.equals("max")) {
            this.max = TypeConvertor.castToString(value);
        } else if (name.equals("documentation")) {
            this.documentation = TypeConvertor.castToString(value);
        } else if (name.equals("type")) {
            value = new Enumerations.FHIRTypesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.type = value;
        } else if (name.equals("profile")) {
            this.profile = TypeConvertor.castToCanonical(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3373707: {
                return this.getNameElement();
            }
            case 116103: {
                return this.getUseElement();
            }
            case 108114: {
                return this.getMinElement();
            }
            case 107876: {
                return this.getMaxElement();
            }
            case 1587405498: {
                return this.getDocumentationElement();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case -309425751: {
                return this.getProfileElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3373707: {
                return new String[]{"code"};
            }
            case 116103: {
                return new String[]{"code"};
            }
            case 108114: {
                return new String[]{"integer"};
            }
            case 107876: {
                return new String[]{"string"};
            }
            case 1587405498: {
                return new String[]{"string"};
            }
            case 3575610: {
                return new String[]{"code"};
            }
            case -309425751: {
                return new String[]{"canonical"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a primitive type ParameterDefinition.name");
        }
        if (name.equals("use")) {
            throw new FHIRException("Cannot call addChild on a primitive type ParameterDefinition.use");
        }
        if (name.equals("min")) {
            throw new FHIRException("Cannot call addChild on a primitive type ParameterDefinition.min");
        }
        if (name.equals("max")) {
            throw new FHIRException("Cannot call addChild on a primitive type ParameterDefinition.max");
        }
        if (name.equals("documentation")) {
            throw new FHIRException("Cannot call addChild on a primitive type ParameterDefinition.documentation");
        }
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a primitive type ParameterDefinition.type");
        }
        if (name.equals("profile")) {
            throw new FHIRException("Cannot call addChild on a primitive type ParameterDefinition.profile");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ParameterDefinition";
    }

    @Override
    public ParameterDefinition copy() {
        ParameterDefinition dst = new ParameterDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ParameterDefinition dst) {
        super.copyValues(dst);
        dst.name = this.name == null ? null : this.name.copy();
        dst.use = this.use == null ? null : this.use.copy();
        dst.min = this.min == null ? null : this.min.copy();
        dst.max = this.max == null ? null : this.max.copy();
        dst.documentation = this.documentation == null ? null : this.documentation.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.profile = this.profile == null ? null : this.profile.copy();
    }

    protected ParameterDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ParameterDefinition)) {
            return false;
        }
        ParameterDefinition o = (ParameterDefinition)other_;
        return ParameterDefinition.compareDeep(this.name, o.name, true) && ParameterDefinition.compareDeep(this.use, o.use, true) && ParameterDefinition.compareDeep(this.min, o.min, true) && ParameterDefinition.compareDeep(this.max, o.max, true) && ParameterDefinition.compareDeep(this.documentation, o.documentation, true) && ParameterDefinition.compareDeep(this.type, o.type, true) && ParameterDefinition.compareDeep(this.profile, o.profile, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ParameterDefinition)) {
            return false;
        }
        ParameterDefinition o = (ParameterDefinition)other_;
        return ParameterDefinition.compareValues(this.name, o.name, true) && ParameterDefinition.compareValues(this.use, o.use, true) && ParameterDefinition.compareValues(this.min, o.min, true) && ParameterDefinition.compareValues(this.max, o.max, true) && ParameterDefinition.compareValues(this.documentation, o.documentation, true) && ParameterDefinition.compareValues(this.type, o.type, true) && ParameterDefinition.compareValues(this.profile, o.profile, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.use, this.min, this.max, this.documentation, this.type, this.profile});
    }
}

