/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.Availability;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.ExtendedContactDetail;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="HealthcareService", profile="http://hl7.org/fhir/StructureDefinition/HealthcareService")
public class HealthcareService
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External identifiers for this item", formalDefinition="External identifiers for this item.")
    protected List<Identifier> identifier;
    @Child(name="active", type={BooleanType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Whether this HealthcareService record is in active use", formalDefinition="This flag is used to mark the record to not be used. This is not used when a center is closed for maintenance, or for holidays, the notAvailable period is to be used for this.")
    protected BooleanType active;
    @Child(name="providedBy", type={Organization.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization that provides this service", formalDefinition="The organization that provides this healthcare service.")
    protected Reference providedBy;
    @Child(name="offeredIn", type={HealthcareService.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The service within which this service is offered", formalDefinition="When the HealthcareService is representing a specific, schedulable service, the availableIn property can refer to a generic service.")
    protected List<Reference> offeredIn;
    @Child(name="category", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Broad category of service being performed or delivered", formalDefinition="Identifies the broad category of service being performed or delivered.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-category")
    protected List<CodeableConcept> category;
    @Child(name="type", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Type of service that may be delivered or performed", formalDefinition="The specific type of service that may be delivered or performed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-type")
    protected List<CodeableConcept> type;
    @Child(name="specialty", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specialties handled by the HealthcareService", formalDefinition="Collection of specialties handled by the Healthcare service. This is more of a medical term.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
    protected List<CodeableConcept> specialty;
    @Child(name="location", type={Location.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Location(s) where service may be provided", formalDefinition="The location(s) where this healthcare service may be provided.")
    protected List<Reference> location;
    @Child(name="name", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description of service as presented to a consumer while searching", formalDefinition="Further description of the service as it would be presented to a consumer while searching.")
    protected StringType name;
    @Child(name="comment", type={MarkdownType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Additional description and/or any specific issues not covered elsewhere", formalDefinition="Any additional description of the service and/or any specific issues not covered by the other attributes, which can be displayed as further detail under the serviceName.")
    protected MarkdownType comment;
    @Child(name="extraDetails", type={MarkdownType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Extra details about the service that can't be placed in the other fields", formalDefinition="Extra details about the service that can't be placed in the other fields.")
    protected MarkdownType extraDetails;
    @Child(name="photo", type={Attachment.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Facilitates quick identification of the service", formalDefinition="If there is a photo/symbol associated with this HealthcareService, it may be included here to facilitate quick identification of the service in a list.")
    protected Attachment photo;
    @Child(name="contact", type={ExtendedContactDetail.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Official contact details for the HealthcareService", formalDefinition="The contact details of communication devices available relevant to the specific HealthcareService. This can include addresses, phone numbers, fax numbers, mobile numbers, email addresses and web sites.")
    protected List<ExtendedContactDetail> contact;
    @Child(name="coverageArea", type={Location.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Location(s) service is intended for/available to", formalDefinition="The location(s) that this service is available to (not where the service is provided).")
    protected List<Reference> coverageArea;
    @Child(name="serviceProvisionCode", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Conditions under which service is available/offered", formalDefinition="The code(s) that detail the conditions under which the healthcare service is available/offered.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-provision-conditions")
    protected List<CodeableConcept> serviceProvisionCode;
    @Child(name="eligibility", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Specific eligibility requirements required to use the service", formalDefinition="Does this service have specific eligibility requirements that need to be met in order to use the service?")
    protected List<HealthcareServiceEligibilityComponent> eligibility;
    @Child(name="program", type={CodeableConcept.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Programs that this service is applicable to", formalDefinition="Programs that this service is applicable to.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/program")
    protected List<CodeableConcept> program;
    @Child(name="characteristic", type={CodeableConcept.class}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Collection of characteristics (attributes)", formalDefinition="Collection of characteristics (attributes).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-mode")
    protected List<CodeableConcept> characteristic;
    @Child(name="communication", type={CodeableConcept.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The language that this service is offered in", formalDefinition="Some services are specifically made available in multiple languages, this property permits a directory to declare the languages this is offered in. Typically this is only provided where a service operates in communities with mixed languages used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/all-languages")
    protected List<CodeableConcept> communication;
    @Child(name="referralMethod", type={CodeableConcept.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Ways that the service accepts referrals", formalDefinition="Ways that the service accepts referrals, if this is not provided then it is implied that no referral is required.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-referral-method")
    protected List<CodeableConcept> referralMethod;
    @Child(name="appointmentRequired", type={BooleanType.class}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="If an appointment is required for access to this service", formalDefinition="Indicates whether or not a prospective consumer will require an appointment for a particular service at a site to be provided by the Organization. Indicates if an appointment is required for access to this service.")
    protected BooleanType appointmentRequired;
    @Child(name="availability", type={Availability.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Times the healthcare service is available (including exceptions)", formalDefinition="A collection of times that the healthcare service is available.")
    protected List<Availability> availability;
    @Child(name="endpoint", type={Endpoint.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Technical endpoints providing access to electronic services operated for the healthcare service", formalDefinition="Technical endpoints providing access to services operated for the specific healthcare services defined at this resource.")
    protected List<Reference> endpoint;
    private static final long serialVersionUID = -438716159L;
    @SearchParamDefinition(name="active", path="HealthcareService.active", description="The Healthcare Service is currently marked as active", type="token")
    public static final String SP_ACTIVE = "active";
    public static final TokenClientParam ACTIVE = new TokenClientParam("active");
    @SearchParamDefinition(name="characteristic", path="HealthcareService.characteristic", description="One of the HealthcareService's characteristics", type="token")
    public static final String SP_CHARACTERISTIC = "characteristic";
    public static final TokenClientParam CHARACTERISTIC = new TokenClientParam("characteristic");
    @SearchParamDefinition(name="communication", path="HealthcareService.communication", description="Languages that are available at this service", type="token")
    public static final String SP_COMMUNICATION = "communication";
    public static final TokenClientParam COMMUNICATION = new TokenClientParam("communication");
    @SearchParamDefinition(name="coverage-area", path="HealthcareService.coverageArea", description="Location(s) service is intended for/available to", type="reference", target={Location.class})
    public static final String SP_COVERAGE_AREA = "coverage-area";
    public static final ReferenceClientParam COVERAGE_AREA = new ReferenceClientParam("coverage-area");
    public static final Include INCLUDE_COVERAGE_AREA = new Include("HealthcareService:coverage-area").toLocked();
    @SearchParamDefinition(name="eligibility", path="HealthcareService.eligibility.code", description="One of the HealthcareService's eligibility requirements", type="token")
    public static final String SP_ELIGIBILITY = "eligibility";
    public static final TokenClientParam ELIGIBILITY = new TokenClientParam("eligibility");
    @SearchParamDefinition(name="endpoint", path="HealthcareService.endpoint", description="Technical endpoints providing access to electronic services operated for the healthcare service", type="reference", target={Endpoint.class})
    public static final String SP_ENDPOINT = "endpoint";
    public static final ReferenceClientParam ENDPOINT = new ReferenceClientParam("endpoint");
    public static final Include INCLUDE_ENDPOINT = new Include("HealthcareService:endpoint").toLocked();
    @SearchParamDefinition(name="identifier", path="HealthcareService.identifier", description="External identifiers for this item", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="location", path="HealthcareService.location", description="The location of the Healthcare Service", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("HealthcareService:location").toLocked();
    @SearchParamDefinition(name="name", path="HealthcareService.name", description="A portion of the Healthcare service name", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="offered-in", path="HealthcareService.offeredIn", description="The service within which this service is offered", type="reference", target={HealthcareService.class})
    public static final String SP_OFFERED_IN = "offered-in";
    public static final ReferenceClientParam OFFERED_IN = new ReferenceClientParam("offered-in");
    public static final Include INCLUDE_OFFERED_IN = new Include("HealthcareService:offered-in").toLocked();
    @SearchParamDefinition(name="organization", path="HealthcareService.providedBy", description="The organization that provides this Healthcare Service", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("HealthcareService:organization").toLocked();
    @SearchParamDefinition(name="program", path="HealthcareService.program", description="One of the Programs supported by this HealthcareService", type="token")
    public static final String SP_PROGRAM = "program";
    public static final TokenClientParam PROGRAM = new TokenClientParam("program");
    @SearchParamDefinition(name="service-category", path="HealthcareService.category", description="Service Category of the Healthcare Service", type="token")
    public static final String SP_SERVICE_CATEGORY = "service-category";
    public static final TokenClientParam SERVICE_CATEGORY = new TokenClientParam("service-category");
    @SearchParamDefinition(name="service-type", path="HealthcareService.type", description="The type of service provided by this healthcare service", type="token")
    public static final String SP_SERVICE_TYPE = "service-type";
    public static final TokenClientParam SERVICE_TYPE = new TokenClientParam("service-type");
    @SearchParamDefinition(name="specialty", path="HealthcareService.specialty", description="The specialty of the service provided by this healthcare service", type="token")
    public static final String SP_SPECIALTY = "specialty";
    public static final TokenClientParam SPECIALTY = new TokenClientParam("specialty");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public HealthcareService setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public HealthcareService addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public HealthcareService setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public HealthcareService setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public Reference getProvidedBy() {
        if (this.providedBy == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.providedBy");
            }
            if (Configuration.doAutoCreate()) {
                this.providedBy = new Reference();
            }
        }
        return this.providedBy;
    }

    public boolean hasProvidedBy() {
        return this.providedBy != null && !this.providedBy.isEmpty();
    }

    public HealthcareService setProvidedBy(Reference value) {
        this.providedBy = value;
        return this;
    }

    public List<Reference> getOfferedIn() {
        if (this.offeredIn == null) {
            this.offeredIn = new ArrayList<Reference>();
        }
        return this.offeredIn;
    }

    public HealthcareService setOfferedIn(List<Reference> theOfferedIn) {
        this.offeredIn = theOfferedIn;
        return this;
    }

    public boolean hasOfferedIn() {
        if (this.offeredIn == null) {
            return false;
        }
        for (Reference item : this.offeredIn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addOfferedIn() {
        Reference t = new Reference();
        if (this.offeredIn == null) {
            this.offeredIn = new ArrayList<Reference>();
        }
        this.offeredIn.add(t);
        return t;
    }

    public HealthcareService addOfferedIn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.offeredIn == null) {
            this.offeredIn = new ArrayList<Reference>();
        }
        this.offeredIn.add(t);
        return this;
    }

    public Reference getOfferedInFirstRep() {
        if (this.getOfferedIn().isEmpty()) {
            this.addOfferedIn();
        }
        return this.getOfferedIn().get(0);
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public HealthcareService setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public HealthcareService addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public HealthcareService setType(List<CodeableConcept> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public HealthcareService addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public CodeableConcept getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public List<CodeableConcept> getSpecialty() {
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        return this.specialty;
    }

    public HealthcareService setSpecialty(List<CodeableConcept> theSpecialty) {
        this.specialty = theSpecialty;
        return this;
    }

    public boolean hasSpecialty() {
        if (this.specialty == null) {
            return false;
        }
        for (CodeableConcept item : this.specialty) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSpecialty() {
        CodeableConcept t = new CodeableConcept();
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return t;
    }

    public HealthcareService addSpecialty(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return this;
    }

    public CodeableConcept getSpecialtyFirstRep() {
        if (this.getSpecialty().isEmpty()) {
            this.addSpecialty();
        }
        return this.getSpecialty().get(0);
    }

    public List<Reference> getLocation() {
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        return this.location;
    }

    public HealthcareService setLocation(List<Reference> theLocation) {
        this.location = theLocation;
        return this;
    }

    public boolean hasLocation() {
        if (this.location == null) {
            return false;
        }
        for (Reference item : this.location) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addLocation() {
        Reference t = new Reference();
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        this.location.add(t);
        return t;
    }

    public HealthcareService addLocation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        this.location.add(t);
        return this;
    }

    public Reference getLocationFirstRep() {
        if (this.getLocation().isEmpty()) {
            this.addLocation();
        }
        return this.getLocation().get(0);
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public HealthcareService setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public HealthcareService setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public MarkdownType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new MarkdownType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public HealthcareService setCommentElement(MarkdownType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public HealthcareService setComment(String value) {
        if (Utilities.noString((String)value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new MarkdownType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    public MarkdownType getExtraDetailsElement() {
        if (this.extraDetails == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.extraDetails");
            }
            if (Configuration.doAutoCreate()) {
                this.extraDetails = new MarkdownType();
            }
        }
        return this.extraDetails;
    }

    public boolean hasExtraDetailsElement() {
        return this.extraDetails != null && !this.extraDetails.isEmpty();
    }

    public boolean hasExtraDetails() {
        return this.extraDetails != null && !this.extraDetails.isEmpty();
    }

    public HealthcareService setExtraDetailsElement(MarkdownType value) {
        this.extraDetails = value;
        return this;
    }

    public String getExtraDetails() {
        return this.extraDetails == null ? null : (String)this.extraDetails.getValue();
    }

    public HealthcareService setExtraDetails(String value) {
        if (Utilities.noString((String)value)) {
            this.extraDetails = null;
        } else {
            if (this.extraDetails == null) {
                this.extraDetails = new MarkdownType();
            }
            this.extraDetails.setValue(value);
        }
        return this;
    }

    public Attachment getPhoto() {
        if (this.photo == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.photo");
            }
            if (Configuration.doAutoCreate()) {
                this.photo = new Attachment();
            }
        }
        return this.photo;
    }

    public boolean hasPhoto() {
        return this.photo != null && !this.photo.isEmpty();
    }

    public HealthcareService setPhoto(Attachment value) {
        this.photo = value;
        return this;
    }

    public List<ExtendedContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ExtendedContactDetail>();
        }
        return this.contact;
    }

    public HealthcareService setContact(List<ExtendedContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ExtendedContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ExtendedContactDetail addContact() {
        ExtendedContactDetail t = new ExtendedContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ExtendedContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    public HealthcareService addContact(ExtendedContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ExtendedContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    public ExtendedContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public List<Reference> getCoverageArea() {
        if (this.coverageArea == null) {
            this.coverageArea = new ArrayList<Reference>();
        }
        return this.coverageArea;
    }

    public HealthcareService setCoverageArea(List<Reference> theCoverageArea) {
        this.coverageArea = theCoverageArea;
        return this;
    }

    public boolean hasCoverageArea() {
        if (this.coverageArea == null) {
            return false;
        }
        for (Reference item : this.coverageArea) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addCoverageArea() {
        Reference t = new Reference();
        if (this.coverageArea == null) {
            this.coverageArea = new ArrayList<Reference>();
        }
        this.coverageArea.add(t);
        return t;
    }

    public HealthcareService addCoverageArea(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.coverageArea == null) {
            this.coverageArea = new ArrayList<Reference>();
        }
        this.coverageArea.add(t);
        return this;
    }

    public Reference getCoverageAreaFirstRep() {
        if (this.getCoverageArea().isEmpty()) {
            this.addCoverageArea();
        }
        return this.getCoverageArea().get(0);
    }

    public List<CodeableConcept> getServiceProvisionCode() {
        if (this.serviceProvisionCode == null) {
            this.serviceProvisionCode = new ArrayList<CodeableConcept>();
        }
        return this.serviceProvisionCode;
    }

    public HealthcareService setServiceProvisionCode(List<CodeableConcept> theServiceProvisionCode) {
        this.serviceProvisionCode = theServiceProvisionCode;
        return this;
    }

    public boolean hasServiceProvisionCode() {
        if (this.serviceProvisionCode == null) {
            return false;
        }
        for (CodeableConcept item : this.serviceProvisionCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addServiceProvisionCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.serviceProvisionCode == null) {
            this.serviceProvisionCode = new ArrayList<CodeableConcept>();
        }
        this.serviceProvisionCode.add(t);
        return t;
    }

    public HealthcareService addServiceProvisionCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.serviceProvisionCode == null) {
            this.serviceProvisionCode = new ArrayList<CodeableConcept>();
        }
        this.serviceProvisionCode.add(t);
        return this;
    }

    public CodeableConcept getServiceProvisionCodeFirstRep() {
        if (this.getServiceProvisionCode().isEmpty()) {
            this.addServiceProvisionCode();
        }
        return this.getServiceProvisionCode().get(0);
    }

    public List<HealthcareServiceEligibilityComponent> getEligibility() {
        if (this.eligibility == null) {
            this.eligibility = new ArrayList<HealthcareServiceEligibilityComponent>();
        }
        return this.eligibility;
    }

    public HealthcareService setEligibility(List<HealthcareServiceEligibilityComponent> theEligibility) {
        this.eligibility = theEligibility;
        return this;
    }

    public boolean hasEligibility() {
        if (this.eligibility == null) {
            return false;
        }
        for (HealthcareServiceEligibilityComponent item : this.eligibility) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public HealthcareServiceEligibilityComponent addEligibility() {
        HealthcareServiceEligibilityComponent t = new HealthcareServiceEligibilityComponent();
        if (this.eligibility == null) {
            this.eligibility = new ArrayList<HealthcareServiceEligibilityComponent>();
        }
        this.eligibility.add(t);
        return t;
    }

    public HealthcareService addEligibility(HealthcareServiceEligibilityComponent t) {
        if (t == null) {
            return this;
        }
        if (this.eligibility == null) {
            this.eligibility = new ArrayList<HealthcareServiceEligibilityComponent>();
        }
        this.eligibility.add(t);
        return this;
    }

    public HealthcareServiceEligibilityComponent getEligibilityFirstRep() {
        if (this.getEligibility().isEmpty()) {
            this.addEligibility();
        }
        return this.getEligibility().get(0);
    }

    public List<CodeableConcept> getProgram() {
        if (this.program == null) {
            this.program = new ArrayList<CodeableConcept>();
        }
        return this.program;
    }

    public HealthcareService setProgram(List<CodeableConcept> theProgram) {
        this.program = theProgram;
        return this;
    }

    public boolean hasProgram() {
        if (this.program == null) {
            return false;
        }
        for (CodeableConcept item : this.program) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addProgram() {
        CodeableConcept t = new CodeableConcept();
        if (this.program == null) {
            this.program = new ArrayList<CodeableConcept>();
        }
        this.program.add(t);
        return t;
    }

    public HealthcareService addProgram(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.program == null) {
            this.program = new ArrayList<CodeableConcept>();
        }
        this.program.add(t);
        return this;
    }

    public CodeableConcept getProgramFirstRep() {
        if (this.getProgram().isEmpty()) {
            this.addProgram();
        }
        return this.getProgram().get(0);
    }

    public List<CodeableConcept> getCharacteristic() {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CodeableConcept>();
        }
        return this.characteristic;
    }

    public HealthcareService setCharacteristic(List<CodeableConcept> theCharacteristic) {
        this.characteristic = theCharacteristic;
        return this;
    }

    public boolean hasCharacteristic() {
        if (this.characteristic == null) {
            return false;
        }
        for (CodeableConcept item : this.characteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCharacteristic() {
        CodeableConcept t = new CodeableConcept();
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CodeableConcept>();
        }
        this.characteristic.add(t);
        return t;
    }

    public HealthcareService addCharacteristic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CodeableConcept>();
        }
        this.characteristic.add(t);
        return this;
    }

    public CodeableConcept getCharacteristicFirstRep() {
        if (this.getCharacteristic().isEmpty()) {
            this.addCharacteristic();
        }
        return this.getCharacteristic().get(0);
    }

    public List<CodeableConcept> getCommunication() {
        if (this.communication == null) {
            this.communication = new ArrayList<CodeableConcept>();
        }
        return this.communication;
    }

    public HealthcareService setCommunication(List<CodeableConcept> theCommunication) {
        this.communication = theCommunication;
        return this;
    }

    public boolean hasCommunication() {
        if (this.communication == null) {
            return false;
        }
        for (CodeableConcept item : this.communication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCommunication() {
        CodeableConcept t = new CodeableConcept();
        if (this.communication == null) {
            this.communication = new ArrayList<CodeableConcept>();
        }
        this.communication.add(t);
        return t;
    }

    public HealthcareService addCommunication(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.communication == null) {
            this.communication = new ArrayList<CodeableConcept>();
        }
        this.communication.add(t);
        return this;
    }

    public CodeableConcept getCommunicationFirstRep() {
        if (this.getCommunication().isEmpty()) {
            this.addCommunication();
        }
        return this.getCommunication().get(0);
    }

    public List<CodeableConcept> getReferralMethod() {
        if (this.referralMethod == null) {
            this.referralMethod = new ArrayList<CodeableConcept>();
        }
        return this.referralMethod;
    }

    public HealthcareService setReferralMethod(List<CodeableConcept> theReferralMethod) {
        this.referralMethod = theReferralMethod;
        return this;
    }

    public boolean hasReferralMethod() {
        if (this.referralMethod == null) {
            return false;
        }
        for (CodeableConcept item : this.referralMethod) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReferralMethod() {
        CodeableConcept t = new CodeableConcept();
        if (this.referralMethod == null) {
            this.referralMethod = new ArrayList<CodeableConcept>();
        }
        this.referralMethod.add(t);
        return t;
    }

    public HealthcareService addReferralMethod(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.referralMethod == null) {
            this.referralMethod = new ArrayList<CodeableConcept>();
        }
        this.referralMethod.add(t);
        return this;
    }

    public CodeableConcept getReferralMethodFirstRep() {
        if (this.getReferralMethod().isEmpty()) {
            this.addReferralMethod();
        }
        return this.getReferralMethod().get(0);
    }

    public BooleanType getAppointmentRequiredElement() {
        if (this.appointmentRequired == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create HealthcareService.appointmentRequired");
            }
            if (Configuration.doAutoCreate()) {
                this.appointmentRequired = new BooleanType();
            }
        }
        return this.appointmentRequired;
    }

    public boolean hasAppointmentRequiredElement() {
        return this.appointmentRequired != null && !this.appointmentRequired.isEmpty();
    }

    public boolean hasAppointmentRequired() {
        return this.appointmentRequired != null && !this.appointmentRequired.isEmpty();
    }

    public HealthcareService setAppointmentRequiredElement(BooleanType value) {
        this.appointmentRequired = value;
        return this;
    }

    public boolean getAppointmentRequired() {
        return this.appointmentRequired == null || this.appointmentRequired.isEmpty() ? false : (Boolean)this.appointmentRequired.getValue();
    }

    public HealthcareService setAppointmentRequired(boolean value) {
        if (this.appointmentRequired == null) {
            this.appointmentRequired = new BooleanType();
        }
        this.appointmentRequired.setValue((Object)value);
        return this;
    }

    public List<Availability> getAvailability() {
        if (this.availability == null) {
            this.availability = new ArrayList<Availability>();
        }
        return this.availability;
    }

    public HealthcareService setAvailability(List<Availability> theAvailability) {
        this.availability = theAvailability;
        return this;
    }

    public boolean hasAvailability() {
        if (this.availability == null) {
            return false;
        }
        for (Availability item : this.availability) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Availability addAvailability() {
        Availability t = new Availability();
        if (this.availability == null) {
            this.availability = new ArrayList<Availability>();
        }
        this.availability.add(t);
        return t;
    }

    public HealthcareService addAvailability(Availability t) {
        if (t == null) {
            return this;
        }
        if (this.availability == null) {
            this.availability = new ArrayList<Availability>();
        }
        this.availability.add(t);
        return this;
    }

    public Availability getAvailabilityFirstRep() {
        if (this.getAvailability().isEmpty()) {
            this.addAvailability();
        }
        return this.getAvailability().get(0);
    }

    public List<Reference> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        return this.endpoint;
    }

    public HealthcareService setEndpoint(List<Reference> theEndpoint) {
        this.endpoint = theEndpoint;
        return this;
    }

    public boolean hasEndpoint() {
        if (this.endpoint == null) {
            return false;
        }
        for (Reference item : this.endpoint) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEndpoint() {
        Reference t = new Reference();
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return t;
    }

    public HealthcareService addEndpoint(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return this;
    }

    public Reference getEndpointFirstRep() {
        if (this.getEndpoint().isEmpty()) {
            this.addEndpoint();
        }
        return this.getEndpoint().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "External identifiers for this item.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_ACTIVE, "boolean", "This flag is used to mark the record to not be used. This is not used when a center is closed for maintenance, or for holidays, the notAvailable period is to be used for this.", 0, 1, this.active));
        children.add(new Property("providedBy", "Reference(Organization)", "The organization that provides this healthcare service.", 0, 1, this.providedBy));
        children.add(new Property("offeredIn", "Reference(HealthcareService)", "When the HealthcareService is representing a specific, schedulable service, the availableIn property can refer to a generic service.", 0, Integer.MAX_VALUE, this.offeredIn));
        children.add(new Property("category", "CodeableConcept", "Identifies the broad category of service being performed or delivered.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property("type", "CodeableConcept", "The specific type of service that may be delivered or performed.", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property(SP_SPECIALTY, "CodeableConcept", "Collection of specialties handled by the Healthcare service. This is more of a medical term.", 0, Integer.MAX_VALUE, this.specialty));
        children.add(new Property(SP_LOCATION, "Reference(Location)", "The location(s) where this healthcare service may be provided.", 0, Integer.MAX_VALUE, this.location));
        children.add(new Property(SP_NAME, "string", "Further description of the service as it would be presented to a consumer while searching.", 0, 1, this.name));
        children.add(new Property("comment", "markdown", "Any additional description of the service and/or any specific issues not covered by the other attributes, which can be displayed as further detail under the serviceName.", 0, 1, this.comment));
        children.add(new Property("extraDetails", "markdown", "Extra details about the service that can't be placed in the other fields.", 0, 1, this.extraDetails));
        children.add(new Property("photo", "Attachment", "If there is a photo/symbol associated with this HealthcareService, it may be included here to facilitate quick identification of the service in a list.", 0, 1, this.photo));
        children.add(new Property("contact", "ExtendedContactDetail", "The contact details of communication devices available relevant to the specific HealthcareService. This can include addresses, phone numbers, fax numbers, mobile numbers, email addresses and web sites.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("coverageArea", "Reference(Location)", "The location(s) that this service is available to (not where the service is provided).", 0, Integer.MAX_VALUE, this.coverageArea));
        children.add(new Property("serviceProvisionCode", "CodeableConcept", "The code(s) that detail the conditions under which the healthcare service is available/offered.", 0, Integer.MAX_VALUE, this.serviceProvisionCode));
        children.add(new Property(SP_ELIGIBILITY, "", "Does this service have specific eligibility requirements that need to be met in order to use the service?", 0, Integer.MAX_VALUE, this.eligibility));
        children.add(new Property(SP_PROGRAM, "CodeableConcept", "Programs that this service is applicable to.", 0, Integer.MAX_VALUE, this.program));
        children.add(new Property(SP_CHARACTERISTIC, "CodeableConcept", "Collection of characteristics (attributes).", 0, Integer.MAX_VALUE, this.characteristic));
        children.add(new Property(SP_COMMUNICATION, "CodeableConcept", "Some services are specifically made available in multiple languages, this property permits a directory to declare the languages this is offered in. Typically this is only provided where a service operates in communities with mixed languages used.", 0, Integer.MAX_VALUE, this.communication));
        children.add(new Property("referralMethod", "CodeableConcept", "Ways that the service accepts referrals, if this is not provided then it is implied that no referral is required.", 0, Integer.MAX_VALUE, this.referralMethod));
        children.add(new Property("appointmentRequired", "boolean", "Indicates whether or not a prospective consumer will require an appointment for a particular service at a site to be provided by the Organization. Indicates if an appointment is required for access to this service.", 0, 1, this.appointmentRequired));
        children.add(new Property("availability", "Availability", "A collection of times that the healthcare service is available.", 0, Integer.MAX_VALUE, this.availability));
        children.add(new Property(SP_ENDPOINT, "Reference(Endpoint)", "Technical endpoints providing access to services operated for the specific healthcare services defined at this resource.", 0, Integer.MAX_VALUE, this.endpoint));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "External identifiers for this item.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1422950650: {
                return new Property(SP_ACTIVE, "boolean", "This flag is used to mark the record to not be used. This is not used when a center is closed for maintenance, or for holidays, the notAvailable period is to be used for this.", 0, 1, this.active);
            }
            case 205136282: {
                return new Property("providedBy", "Reference(Organization)", "The organization that provides this healthcare service.", 0, 1, this.providedBy);
            }
            case 1945040512: {
                return new Property("offeredIn", "Reference(HealthcareService)", "When the HealthcareService is representing a specific, schedulable service, the availableIn property can refer to a generic service.", 0, Integer.MAX_VALUE, this.offeredIn);
            }
            case 50511102: {
                return new Property("category", "CodeableConcept", "Identifies the broad category of service being performed or delivered.", 0, Integer.MAX_VALUE, this.category);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "The specific type of service that may be delivered or performed.", 0, Integer.MAX_VALUE, this.type);
            }
            case -1694759682: {
                return new Property(SP_SPECIALTY, "CodeableConcept", "Collection of specialties handled by the Healthcare service. This is more of a medical term.", 0, Integer.MAX_VALUE, this.specialty);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "Reference(Location)", "The location(s) where this healthcare service may be provided.", 0, Integer.MAX_VALUE, this.location);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "Further description of the service as it would be presented to a consumer while searching.", 0, 1, this.name);
            }
            case 950398559: {
                return new Property("comment", "markdown", "Any additional description of the service and/or any specific issues not covered by the other attributes, which can be displayed as further detail under the serviceName.", 0, 1, this.comment);
            }
            case -1469168622: {
                return new Property("extraDetails", "markdown", "Extra details about the service that can't be placed in the other fields.", 0, 1, this.extraDetails);
            }
            case 106642994: {
                return new Property("photo", "Attachment", "If there is a photo/symbol associated with this HealthcareService, it may be included here to facilitate quick identification of the service in a list.", 0, 1, this.photo);
            }
            case 951526432: {
                return new Property("contact", "ExtendedContactDetail", "The contact details of communication devices available relevant to the specific HealthcareService. This can include addresses, phone numbers, fax numbers, mobile numbers, email addresses and web sites.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1532328299: {
                return new Property("coverageArea", "Reference(Location)", "The location(s) that this service is available to (not where the service is provided).", 0, Integer.MAX_VALUE, this.coverageArea);
            }
            case 1504575405: {
                return new Property("serviceProvisionCode", "CodeableConcept", "The code(s) that detail the conditions under which the healthcare service is available/offered.", 0, Integer.MAX_VALUE, this.serviceProvisionCode);
            }
            case -930847859: {
                return new Property(SP_ELIGIBILITY, "", "Does this service have specific eligibility requirements that need to be met in order to use the service?", 0, Integer.MAX_VALUE, this.eligibility);
            }
            case -309387644: {
                return new Property(SP_PROGRAM, "CodeableConcept", "Programs that this service is applicable to.", 0, Integer.MAX_VALUE, this.program);
            }
            case 366313883: {
                return new Property(SP_CHARACTERISTIC, "CodeableConcept", "Collection of characteristics (attributes).", 0, Integer.MAX_VALUE, this.characteristic);
            }
            case -1035284522: {
                return new Property(SP_COMMUNICATION, "CodeableConcept", "Some services are specifically made available in multiple languages, this property permits a directory to declare the languages this is offered in. Typically this is only provided where a service operates in communities with mixed languages used.", 0, Integer.MAX_VALUE, this.communication);
            }
            case -2092740898: {
                return new Property("referralMethod", "CodeableConcept", "Ways that the service accepts referrals, if this is not provided then it is implied that no referral is required.", 0, Integer.MAX_VALUE, this.referralMethod);
            }
            case 427220062: {
                return new Property("appointmentRequired", "boolean", "Indicates whether or not a prospective consumer will require an appointment for a particular service at a site to be provided by the Organization. Indicates if an appointment is required for access to this service.", 0, 1, this.appointmentRequired);
            }
            case 1997542747: {
                return new Property("availability", "Availability", "A collection of times that the healthcare service is available.", 0, Integer.MAX_VALUE, this.availability);
            }
            case 1741102485: {
                return new Property(SP_ENDPOINT, "Reference(Endpoint)", "Technical endpoints providing access to services operated for the specific healthcare services defined at this resource.", 0, Integer.MAX_VALUE, this.endpoint);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1422950650: {
                Base[] baseArray;
                if (this.active == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.active;
                }
                return baseArray;
            }
            case 205136282: {
                Base[] baseArray;
                if (this.providedBy == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.providedBy;
                }
                return baseArray;
            }
            case 1945040512: {
                return this.offeredIn == null ? new Base[]{} : this.offeredIn.toArray(new Base[this.offeredIn.size()]);
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case -1694759682: {
                return this.specialty == null ? new Base[]{} : this.specialty.toArray(new Base[this.specialty.size()]);
            }
            case 1901043637: {
                return this.location == null ? new Base[]{} : this.location.toArray(new Base[this.location.size()]);
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.comment;
                }
                return baseArray;
            }
            case -1469168622: {
                Base[] baseArray;
                if (this.extraDetails == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.extraDetails;
                }
                return baseArray;
            }
            case 106642994: {
                Base[] baseArray;
                if (this.photo == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.photo;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1532328299: {
                return this.coverageArea == null ? new Base[]{} : this.coverageArea.toArray(new Base[this.coverageArea.size()]);
            }
            case 1504575405: {
                return this.serviceProvisionCode == null ? new Base[]{} : this.serviceProvisionCode.toArray(new Base[this.serviceProvisionCode.size()]);
            }
            case -930847859: {
                return this.eligibility == null ? new Base[]{} : this.eligibility.toArray(new Base[this.eligibility.size()]);
            }
            case -309387644: {
                return this.program == null ? new Base[]{} : this.program.toArray(new Base[this.program.size()]);
            }
            case 366313883: {
                return this.characteristic == null ? new Base[]{} : this.characteristic.toArray(new Base[this.characteristic.size()]);
            }
            case -1035284522: {
                return this.communication == null ? new Base[]{} : this.communication.toArray(new Base[this.communication.size()]);
            }
            case -2092740898: {
                return this.referralMethod == null ? new Base[]{} : this.referralMethod.toArray(new Base[this.referralMethod.size()]);
            }
            case 427220062: {
                Base[] baseArray;
                if (this.appointmentRequired == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.appointmentRequired;
                }
                return baseArray;
            }
            case 1997542747: {
                return this.availability == null ? new Base[]{} : this.availability.toArray(new Base[this.availability.size()]);
            }
            case 1741102485: {
                return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -1422950650: {
                this.active = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 205136282: {
                this.providedBy = TypeConvertor.castToReference(value);
                return value;
            }
            case 1945040512: {
                this.getOfferedIn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3575610: {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1694759682: {
                this.getSpecialty().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 1901043637: {
                this.getLocation().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 950398559: {
                this.comment = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -1469168622: {
                this.extraDetails = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 106642994: {
                this.photo = TypeConvertor.castToAttachment(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToExtendedContactDetail(value));
                return value;
            }
            case -1532328299: {
                this.getCoverageArea().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1504575405: {
                this.getServiceProvisionCode().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -930847859: {
                this.getEligibility().add((HealthcareServiceEligibilityComponent)value);
                return value;
            }
            case -309387644: {
                this.getProgram().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 366313883: {
                this.getCharacteristic().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1035284522: {
                this.getCommunication().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -2092740898: {
                this.getReferralMethod().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 427220062: {
                this.appointmentRequired = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 1997542747: {
                this.getAvailability().add(TypeConvertor.castToAvailability(value));
                return value;
            }
            case 1741102485: {
                this.getEndpoint().add(TypeConvertor.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_ACTIVE)) {
            this.active = TypeConvertor.castToBoolean(value);
        } else if (name.equals("providedBy")) {
            this.providedBy = TypeConvertor.castToReference(value);
        } else if (name.equals("offeredIn")) {
            this.getOfferedIn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("category")) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("type")) {
            this.getType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SPECIALTY)) {
            this.getSpecialty().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_LOCATION)) {
            this.getLocation().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals("comment")) {
            this.comment = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("extraDetails")) {
            this.extraDetails = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("photo")) {
            this.photo = TypeConvertor.castToAttachment(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToExtendedContactDetail(value));
        } else if (name.equals("coverageArea")) {
            this.getCoverageArea().add(TypeConvertor.castToReference(value));
        } else if (name.equals("serviceProvisionCode")) {
            this.getServiceProvisionCode().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_ELIGIBILITY)) {
            this.getEligibility().add((HealthcareServiceEligibilityComponent)value);
        } else if (name.equals(SP_PROGRAM)) {
            this.getProgram().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_CHARACTERISTIC)) {
            this.getCharacteristic().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_COMMUNICATION)) {
            this.getCommunication().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("referralMethod")) {
            this.getReferralMethod().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("appointmentRequired")) {
            this.appointmentRequired = TypeConvertor.castToBoolean(value);
        } else if (name.equals("availability")) {
            this.getAvailability().add(TypeConvertor.castToAvailability(value));
        } else if (name.equals(SP_ENDPOINT)) {
            this.getEndpoint().add(TypeConvertor.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1422950650: {
                return this.getActiveElement();
            }
            case 205136282: {
                return this.getProvidedBy();
            }
            case 1945040512: {
                return this.addOfferedIn();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 3575610: {
                return this.addType();
            }
            case -1694759682: {
                return this.addSpecialty();
            }
            case 1901043637: {
                return this.addLocation();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 950398559: {
                return this.getCommentElement();
            }
            case -1469168622: {
                return this.getExtraDetailsElement();
            }
            case 106642994: {
                return this.getPhoto();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1532328299: {
                return this.addCoverageArea();
            }
            case 1504575405: {
                return this.addServiceProvisionCode();
            }
            case -930847859: {
                return this.addEligibility();
            }
            case -309387644: {
                return this.addProgram();
            }
            case 366313883: {
                return this.addCharacteristic();
            }
            case -1035284522: {
                return this.addCommunication();
            }
            case -2092740898: {
                return this.addReferralMethod();
            }
            case 427220062: {
                return this.getAppointmentRequiredElement();
            }
            case 1997542747: {
                return this.addAvailability();
            }
            case 1741102485: {
                return this.addEndpoint();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1422950650: {
                return new String[]{"boolean"};
            }
            case 205136282: {
                return new String[]{"Reference"};
            }
            case 1945040512: {
                return new String[]{"Reference"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1694759682: {
                return new String[]{"CodeableConcept"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 950398559: {
                return new String[]{"markdown"};
            }
            case -1469168622: {
                return new String[]{"markdown"};
            }
            case 106642994: {
                return new String[]{"Attachment"};
            }
            case 951526432: {
                return new String[]{"ExtendedContactDetail"};
            }
            case -1532328299: {
                return new String[]{"Reference"};
            }
            case 1504575405: {
                return new String[]{"CodeableConcept"};
            }
            case -930847859: {
                return new String[0];
            }
            case -309387644: {
                return new String[]{"CodeableConcept"};
            }
            case 366313883: {
                return new String[]{"CodeableConcept"};
            }
            case -1035284522: {
                return new String[]{"CodeableConcept"};
            }
            case -2092740898: {
                return new String[]{"CodeableConcept"};
            }
            case 427220062: {
                return new String[]{"boolean"};
            }
            case 1997542747: {
                return new String[]{"Availability"};
            }
            case 1741102485: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_ACTIVE)) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.active");
        }
        if (name.equals("providedBy")) {
            this.providedBy = new Reference();
            return this.providedBy;
        }
        if (name.equals("offeredIn")) {
            return this.addOfferedIn();
        }
        if (name.equals("category")) {
            return this.addCategory();
        }
        if (name.equals("type")) {
            return this.addType();
        }
        if (name.equals(SP_SPECIALTY)) {
            return this.addSpecialty();
        }
        if (name.equals(SP_LOCATION)) {
            return this.addLocation();
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.name");
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.comment");
        }
        if (name.equals("extraDetails")) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.extraDetails");
        }
        if (name.equals("photo")) {
            this.photo = new Attachment();
            return this.photo;
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("coverageArea")) {
            return this.addCoverageArea();
        }
        if (name.equals("serviceProvisionCode")) {
            return this.addServiceProvisionCode();
        }
        if (name.equals(SP_ELIGIBILITY)) {
            return this.addEligibility();
        }
        if (name.equals(SP_PROGRAM)) {
            return this.addProgram();
        }
        if (name.equals(SP_CHARACTERISTIC)) {
            return this.addCharacteristic();
        }
        if (name.equals(SP_COMMUNICATION)) {
            return this.addCommunication();
        }
        if (name.equals("referralMethod")) {
            return this.addReferralMethod();
        }
        if (name.equals("appointmentRequired")) {
            throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.appointmentRequired");
        }
        if (name.equals("availability")) {
            return this.addAvailability();
        }
        if (name.equals(SP_ENDPOINT)) {
            return this.addEndpoint();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "HealthcareService";
    }

    @Override
    public HealthcareService copy() {
        HealthcareService dst = new HealthcareService();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(HealthcareService dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.active = this.active == null ? null : this.active.copy();
        Reference reference = dst.providedBy = this.providedBy == null ? null : this.providedBy.copy();
        if (this.offeredIn != null) {
            dst.offeredIn = new ArrayList<Reference>();
            for (Reference reference2 : this.offeredIn) {
                dst.offeredIn.add(reference2.copy());
            }
        }
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.type) {
                dst.type.add(codeableConcept.copy());
            }
        }
        if (this.specialty != null) {
            dst.specialty = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.specialty) {
                dst.specialty.add(codeableConcept.copy());
            }
        }
        if (this.location != null) {
            dst.location = new ArrayList<Reference>();
            for (Reference reference3 : this.location) {
                dst.location.add(reference3.copy());
            }
        }
        dst.name = this.name == null ? null : this.name.copy();
        dst.comment = this.comment == null ? null : this.comment.copy();
        dst.extraDetails = this.extraDetails == null ? null : this.extraDetails.copy();
        Attachment attachment = dst.photo = this.photo == null ? null : this.photo.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ExtendedContactDetail>();
            for (ExtendedContactDetail extendedContactDetail : this.contact) {
                dst.contact.add(extendedContactDetail.copy());
            }
        }
        if (this.coverageArea != null) {
            dst.coverageArea = new ArrayList<Reference>();
            for (Reference reference4 : this.coverageArea) {
                dst.coverageArea.add(reference4.copy());
            }
        }
        if (this.serviceProvisionCode != null) {
            dst.serviceProvisionCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.serviceProvisionCode) {
                dst.serviceProvisionCode.add(codeableConcept.copy());
            }
        }
        if (this.eligibility != null) {
            dst.eligibility = new ArrayList<HealthcareServiceEligibilityComponent>();
            for (HealthcareServiceEligibilityComponent healthcareServiceEligibilityComponent : this.eligibility) {
                dst.eligibility.add(healthcareServiceEligibilityComponent.copy());
            }
        }
        if (this.program != null) {
            dst.program = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.program) {
                dst.program.add(codeableConcept.copy());
            }
        }
        if (this.characteristic != null) {
            dst.characteristic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.characteristic) {
                dst.characteristic.add(codeableConcept.copy());
            }
        }
        if (this.communication != null) {
            dst.communication = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.communication) {
                dst.communication.add(codeableConcept.copy());
            }
        }
        if (this.referralMethod != null) {
            dst.referralMethod = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.referralMethod) {
                dst.referralMethod.add(codeableConcept.copy());
            }
        }
        BooleanType booleanType = dst.appointmentRequired = this.appointmentRequired == null ? null : this.appointmentRequired.copy();
        if (this.availability != null) {
            dst.availability = new ArrayList<Availability>();
            for (Availability availability : this.availability) {
                dst.availability.add(availability.copy());
            }
        }
        if (this.endpoint != null) {
            dst.endpoint = new ArrayList<Reference>();
            for (Reference reference5 : this.endpoint) {
                dst.endpoint.add(reference5.copy());
            }
        }
    }

    protected HealthcareService typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof HealthcareService)) {
            return false;
        }
        HealthcareService o = (HealthcareService)other_;
        return HealthcareService.compareDeep(this.identifier, o.identifier, true) && HealthcareService.compareDeep(this.active, o.active, true) && HealthcareService.compareDeep(this.providedBy, o.providedBy, true) && HealthcareService.compareDeep(this.offeredIn, o.offeredIn, true) && HealthcareService.compareDeep(this.category, o.category, true) && HealthcareService.compareDeep(this.type, o.type, true) && HealthcareService.compareDeep(this.specialty, o.specialty, true) && HealthcareService.compareDeep(this.location, o.location, true) && HealthcareService.compareDeep(this.name, o.name, true) && HealthcareService.compareDeep(this.comment, o.comment, true) && HealthcareService.compareDeep(this.extraDetails, o.extraDetails, true) && HealthcareService.compareDeep(this.photo, o.photo, true) && HealthcareService.compareDeep(this.contact, o.contact, true) && HealthcareService.compareDeep(this.coverageArea, o.coverageArea, true) && HealthcareService.compareDeep(this.serviceProvisionCode, o.serviceProvisionCode, true) && HealthcareService.compareDeep(this.eligibility, o.eligibility, true) && HealthcareService.compareDeep(this.program, o.program, true) && HealthcareService.compareDeep(this.characteristic, o.characteristic, true) && HealthcareService.compareDeep(this.communication, o.communication, true) && HealthcareService.compareDeep(this.referralMethod, o.referralMethod, true) && HealthcareService.compareDeep(this.appointmentRequired, o.appointmentRequired, true) && HealthcareService.compareDeep(this.availability, o.availability, true) && HealthcareService.compareDeep(this.endpoint, o.endpoint, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof HealthcareService)) {
            return false;
        }
        HealthcareService o = (HealthcareService)other_;
        return HealthcareService.compareValues(this.active, o.active, true) && HealthcareService.compareValues(this.name, o.name, true) && HealthcareService.compareValues(this.comment, o.comment, true) && HealthcareService.compareValues(this.extraDetails, o.extraDetails, true) && HealthcareService.compareValues(this.appointmentRequired, o.appointmentRequired, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.active, this.providedBy, this.offeredIn, this.category, this.type, this.specialty, this.location, this.name, this.comment, this.extraDetails, this.photo, this.contact, this.coverageArea, this.serviceProvisionCode, this.eligibility, this.program, this.characteristic, this.communication, this.referralMethod, this.appointmentRequired, this.availability, this.endpoint});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.HealthcareService;
    }

    @Block
    public static class HealthcareServiceEligibilityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Coded value for the eligibility", formalDefinition="Coded value for the eligibility.")
        protected CodeableConcept code;
        @Child(name="comment", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Describes the eligibility conditions for the service", formalDefinition="Describes the eligibility conditions for the service.")
        protected MarkdownType comment;
        private static final long serialVersionUID = 1078065348L;

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create HealthcareServiceEligibilityComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public HealthcareServiceEligibilityComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public MarkdownType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create HealthcareServiceEligibilityComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new MarkdownType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public HealthcareServiceEligibilityComponent setCommentElement(MarkdownType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public HealthcareServiceEligibilityComponent setComment(String value) {
            if (Utilities.noString((String)value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new MarkdownType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "Coded value for the eligibility.", 0, 1, this.code));
            children.add(new Property("comment", "markdown", "Describes the eligibility conditions for the service.", 0, 1, this.comment));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Coded value for the eligibility.", 0, 1, this.code);
                }
                case 950398559: {
                    return new Property("comment", "markdown", "Describes the eligibility conditions for the service.", 0, 1, this.comment);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.comment;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 950398559: {
                    this.comment = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("comment")) {
                this.comment = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 950398559: {
                    return this.getCommentElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 950398559: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a primitive type HealthcareService.eligibility.comment");
            }
            return super.addChild(name);
        }

        @Override
        public HealthcareServiceEligibilityComponent copy() {
            HealthcareServiceEligibilityComponent dst = new HealthcareServiceEligibilityComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(HealthcareServiceEligibilityComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.comment = this.comment == null ? null : this.comment.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof HealthcareServiceEligibilityComponent)) {
                return false;
            }
            HealthcareServiceEligibilityComponent o = (HealthcareServiceEligibilityComponent)other_;
            return HealthcareServiceEligibilityComponent.compareDeep(this.code, o.code, true) && HealthcareServiceEligibilityComponent.compareDeep(this.comment, o.comment, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof HealthcareServiceEligibilityComponent)) {
                return false;
            }
            HealthcareServiceEligibilityComponent o = (HealthcareServiceEligibilityComponent)other_;
            return HealthcareServiceEligibilityComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.comment});
        }

        @Override
        public String fhirType() {
            return "HealthcareService.eligibility";
        }
    }
}

