/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.ExpressionNode;
import org.hl7.fhir.r5.utils.FHIRPathConstant;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.SourceLocation;
import org.hl7.fhir.utilities.Utilities;

public class FHIRLexer {
    private String source;
    private int cursor;
    private int currentStart;
    private String current;
    private List<String> comments = new ArrayList<String>();
    private SourceLocation currentLocation;
    private SourceLocation currentStartLocation;
    private int id;
    private String name;
    private boolean liquidMode;
    private SourceLocation commentLocation;

    public FHIRLexer(String source, String name) throws FHIRLexerException {
        this.source = source == null ? "" : source;
        this.name = name == null ? "??" : name;
        this.currentLocation = new SourceLocation(1, 1);
        this.next();
    }

    public FHIRLexer(String source, int i) throws FHIRLexerException {
        this.source = source;
        this.cursor = i;
        this.currentLocation = new SourceLocation(1, 1);
        this.next();
    }

    public String getCurrent() {
        return this.current;
    }

    public SourceLocation getCurrentLocation() {
        return this.currentLocation;
    }

    public boolean isConstant() {
        return FHIRPathConstant.isFHIRPathConstant(this.current);
    }

    public boolean isFixedName() {
        return FHIRPathConstant.isFHIRPathFixedName(this.current);
    }

    public boolean isStringConstant() {
        return FHIRPathConstant.isFHIRPathStringConstant(this.current);
    }

    public String take() throws FHIRLexerException {
        String s = this.current;
        this.next();
        return s;
    }

    public int takeInt() throws FHIRLexerException {
        String s = this.current;
        if (!Utilities.isInteger((String)s)) {
            throw this.error("Found " + this.current + " expecting an integer");
        }
        this.next();
        return Integer.parseInt(s);
    }

    public boolean isToken() {
        if (Utilities.noString((String)this.current)) {
            return false;
        }
        if (this.current.startsWith("$")) {
            return true;
        }
        if (this.current.equals("*") || this.current.equals("**")) {
            return true;
        }
        if (this.current.charAt(0) >= 'A' && this.current.charAt(0) <= 'Z' || this.current.charAt(0) >= 'a' && this.current.charAt(0) <= 'z') {
            for (int i = 1; i < this.current.length(); ++i) {
                if (this.current.charAt(1) >= 'A' && this.current.charAt(1) <= 'Z' || this.current.charAt(1) >= 'a' && this.current.charAt(1) <= 'z' || this.current.charAt(1) >= '0' && this.current.charAt(1) <= '9') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public FHIRLexerException error(String msg) {
        return this.error(msg, this.currentLocation.toString(), this.currentLocation);
    }

    public FHIRLexerException error(String msg, String location, SourceLocation loc) {
        return new FHIRLexerException("Error @" + location + ": " + msg, loc);
    }

    public void next() throws FHIRLexerException {
        this.skipWhitespaceAndComments();
        this.current = null;
        this.currentStart = this.cursor;
        this.currentStartLocation = this.currentLocation;
        if (this.cursor < this.source.length()) {
            char ch = this.source.charAt(this.cursor);
            if (ch == '!' || ch == '>' || ch == '<' || ch == ':' || ch == '-' || ch == '=') {
                ++this.cursor;
                if (this.cursor < this.source.length() && (this.source.charAt(this.cursor) == '=' || this.source.charAt(this.cursor) == '~' || this.source.charAt(this.cursor) == '-') || ch == '-' && this.source.charAt(this.cursor) == '>') {
                    ++this.cursor;
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else if (ch == '.') {
                ++this.cursor;
                if (this.cursor < this.source.length() && this.source.charAt(this.cursor) == '.') {
                    ++this.cursor;
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else if (ch >= '0' && ch <= '9') {
                ++this.cursor;
                boolean dotted = false;
                while (this.cursor < this.source.length() && (this.source.charAt(this.cursor) >= '0' && this.source.charAt(this.cursor) <= '9' || this.source.charAt(this.cursor) == '.' && !dotted)) {
                    if (this.source.charAt(this.cursor) == '.') {
                        dotted = true;
                    }
                    ++this.cursor;
                }
                if (this.source.charAt(this.cursor - 1) == '.') {
                    --this.cursor;
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                while (this.cursor < this.source.length() && (this.source.charAt(this.cursor) >= 'A' && this.source.charAt(this.cursor) <= 'Z' || this.source.charAt(this.cursor) >= 'a' && this.source.charAt(this.cursor) <= 'z' || this.source.charAt(this.cursor) >= '0' && this.source.charAt(this.cursor) <= '9' || this.source.charAt(this.cursor) == '_')) {
                    ++this.cursor;
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else if (ch == '%') {
                ++this.cursor;
                if (this.cursor < this.source.length() && this.source.charAt(this.cursor) == '`') {
                    ++this.cursor;
                    while (this.cursor < this.source.length() && this.source.charAt(this.cursor) != '`') {
                        ++this.cursor;
                    }
                    ++this.cursor;
                } else {
                    while (this.cursor < this.source.length() && (this.source.charAt(this.cursor) >= 'A' && this.source.charAt(this.cursor) <= 'Z' || this.source.charAt(this.cursor) >= 'a' && this.source.charAt(this.cursor) <= 'z' || this.source.charAt(this.cursor) >= '0' && this.source.charAt(this.cursor) <= '9' || this.source.charAt(this.cursor) == ':' || this.source.charAt(this.cursor) == '-')) {
                        ++this.cursor;
                    }
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else if (ch == '/') {
                ++this.cursor;
                if (this.cursor < this.source.length() && this.source.charAt(this.cursor) == '/') {
                    this.error("This shouldn't happen?");
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else if (ch == '$') {
                ++this.cursor;
                while (this.cursor < this.source.length() && this.source.charAt(this.cursor) >= 'a' && this.source.charAt(this.cursor) <= 'z') {
                    ++this.cursor;
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else if (ch == '{') {
                ++this.cursor;
                ch = this.source.charAt(this.cursor);
                if (ch == '}') {
                    ++this.cursor;
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else if (ch == '\"') {
                ++this.cursor;
                boolean escape = false;
                while (this.cursor < this.source.length() && (escape || this.source.charAt(this.cursor) != '\"')) {
                    escape = escape ? false : this.source.charAt(this.cursor) == '\\';
                    ++this.cursor;
                }
                if (this.cursor == this.source.length()) {
                    throw this.error("Unterminated string");
                }
                ++this.cursor;
                this.current = "\"" + this.source.substring(this.currentStart + 1, this.cursor - 1) + "\"";
            } else if (ch == '`') {
                ++this.cursor;
                boolean escape = false;
                while (this.cursor < this.source.length() && (escape || this.source.charAt(this.cursor) != '`')) {
                    escape = escape ? false : this.source.charAt(this.cursor) == '\\';
                    ++this.cursor;
                }
                if (this.cursor == this.source.length()) {
                    throw this.error("Unterminated string");
                }
                ++this.cursor;
                this.current = "`" + this.source.substring(this.currentStart + 1, this.cursor - 1) + "`";
            } else if (ch == '\'') {
                ++this.cursor;
                char ech = ch;
                boolean escape = false;
                while (this.cursor < this.source.length() && (escape || this.source.charAt(this.cursor) != ech)) {
                    escape = escape ? false : this.source.charAt(this.cursor) == '\\';
                    ++this.cursor;
                }
                if (this.cursor == this.source.length()) {
                    throw this.error("Unterminated string");
                }
                ++this.cursor;
                this.current = this.source.substring(this.currentStart, this.cursor);
                if (ech == '\'') {
                    this.current = "'" + this.current.substring(1, this.current.length() - 1) + "'";
                }
            } else if (ch == '`') {
                ++this.cursor;
                boolean escape = false;
                while (this.cursor < this.source.length() && (escape || this.source.charAt(this.cursor) != '`')) {
                    escape = escape ? false : this.source.charAt(this.cursor) == '\\';
                    ++this.cursor;
                }
                if (this.cursor == this.source.length()) {
                    throw this.error("Unterminated string");
                }
                ++this.cursor;
                this.current = "`" + this.source.substring(this.currentStart + 1, this.cursor - 1) + "`";
            } else if (ch == '|' && this.liquidMode) {
                ++this.cursor;
                ch = this.source.charAt(this.cursor);
                if (ch == '|') {
                    ++this.cursor;
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else if (ch == '@') {
                int start = this.cursor++;
                while (this.cursor < this.source.length() && this.isDateChar(this.source.charAt(this.cursor), start)) {
                    ++this.cursor;
                }
                this.current = this.source.substring(this.currentStart, this.cursor);
            } else {
                ++this.cursor;
                this.current = this.source.substring(this.currentStart, this.cursor);
            }
        }
    }

    private void skipWhitespaceAndComments() {
        this.comments.clear();
        boolean last13 = false;
        boolean done = false;
        while (this.cursor < this.source.length() && !done) {
            int start;
            if (this.cursor < this.source.length() - 1 && "//".equals(this.source.substring(this.cursor, this.cursor + 2))) {
                this.commentLocation = this.currentLocation;
                start = this.cursor + 2;
                while (this.cursor < this.source.length() && this.source.charAt(this.cursor) != '\r' && this.source.charAt(this.cursor) != '\n') {
                    ++this.cursor;
                }
                this.comments.add(this.source.substring(start, this.cursor).trim());
                continue;
            }
            if (this.cursor < this.source.length() - 1 && "/*".equals(this.source.substring(this.cursor, this.cursor + 2))) {
                this.commentLocation = this.currentLocation;
                start = this.cursor + 2;
                while (this.cursor < this.source.length() - 1 && !"*/".equals(this.source.substring(this.cursor, this.cursor + 2))) {
                    last13 = this.currentLocation.checkChar(this.source.charAt(this.cursor), last13);
                    ++this.cursor;
                }
                if (this.cursor >= this.source.length() - 1) {
                    this.error("Unfinished comment");
                    continue;
                }
                this.comments.add(this.source.substring(start, this.cursor).trim());
                this.cursor += 2;
                continue;
            }
            if (Character.isWhitespace(this.source.charAt(this.cursor))) {
                last13 = this.currentLocation.checkChar(this.source.charAt(this.cursor), last13);
                ++this.cursor;
                continue;
            }
            done = true;
        }
    }

    private boolean isDateChar(char ch, int start) {
        int eot = this.source.charAt(start + 1) == 'T' ? 10 : 20;
        return ch == '-' || ch == ':' || ch == 'T' || ch == '+' || ch == 'Z' || Character.isDigit(ch) || this.cursor - start == eot && ch == '.' && this.cursor < this.source.length() - 1 && Character.isDigit(this.source.charAt(this.cursor + 1));
    }

    public boolean isOp() {
        return ExpressionNode.Operation.fromCode(this.current) != null;
    }

    public boolean done() {
        return this.currentStart >= this.source.length();
    }

    public int nextId() {
        ++this.id;
        return this.id;
    }

    public SourceLocation getCurrentStartLocation() {
        return this.currentStartLocation;
    }

    public void setCurrent(String current) {
        this.current = current;
    }

    public boolean hasComments() {
        return this.comments.size() > 0;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public String getAllComments() {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder("\r\n");
        b.addAll(this.comments);
        this.comments.clear();
        return b.toString();
    }

    public String getFirstComment() {
        if (this.hasComments()) {
            String s = this.comments.get(0);
            this.comments.remove(0);
            return s;
        }
        return null;
    }

    public boolean hasToken(String kw) {
        return !this.done() && kw.equals(this.current);
    }

    public boolean hasToken(String ... names) {
        if (this.done()) {
            return false;
        }
        for (String s : names) {
            if (!s.equals(this.current)) continue;
            return true;
        }
        return false;
    }

    public void token(String kw) throws FHIRLexerException {
        if (!kw.equals(this.current)) {
            throw this.error("Found \"" + this.current + "\" expecting \"" + kw + "\"");
        }
        this.next();
    }

    public String readConstant(String desc) throws FHIRLexerException {
        if (!this.isStringConstant()) {
            throw this.error("Found " + this.current + " expecting \"[" + desc + "]\"");
        }
        return this.processConstant(this.take());
    }

    public String readFixedName(String desc) throws FHIRLexerException {
        if (!this.isFixedName()) {
            throw this.error("Found " + this.current + " expecting \"[" + desc + "]\"");
        }
        return this.processFixedName(this.take());
    }

    public String processConstant(String s) throws FHIRLexerException {
        StringBuilder b = new StringBuilder();
        int i = 1;
        block12: while (i < s.length() - 1) {
            char ch = s.charAt(i);
            if (ch == '\\') {
                switch (s.charAt(++i)) {
                    case 't': {
                        b.append('\t');
                        continue block12;
                    }
                    case 'r': {
                        b.append('\r');
                        continue block12;
                    }
                    case 'n': {
                        b.append('\n');
                        continue block12;
                    }
                    case 'f': {
                        b.append('\f');
                        continue block12;
                    }
                    case '\'': {
                        b.append('\'');
                        continue block12;
                    }
                    case '\"': {
                        b.append('\"');
                        continue block12;
                    }
                    case '`': {
                        b.append('`');
                        continue block12;
                    }
                    case '\\': {
                        b.append('\\');
                        continue block12;
                    }
                    case '/': {
                        b.append('/');
                        continue block12;
                    }
                    case 'u': {
                        int uc = Integer.parseInt(s.substring(++i, i + 4), 16);
                        b.append((char)uc);
                        i += 4;
                        continue block12;
                    }
                }
                throw new FHIRLexerException("Unknown character escape \\" + s.charAt(i), this.currentLocation);
            }
            b.append(ch);
            ++i;
        }
        return b.toString();
    }

    public String processFixedName(String s) throws FHIRLexerException {
        StringBuilder b = new StringBuilder();
        int i = 1;
        block11: while (i < s.length() - 1) {
            char ch = s.charAt(i);
            if (ch == '\\') {
                switch (s.charAt(++i)) {
                    case 't': {
                        b.append('\t');
                        continue block11;
                    }
                    case 'r': {
                        b.append('\r');
                        continue block11;
                    }
                    case 'n': {
                        b.append('\n');
                        continue block11;
                    }
                    case 'f': {
                        b.append('\f');
                        continue block11;
                    }
                    case '\'': {
                        b.append('\'');
                        continue block11;
                    }
                    case '\"': {
                        b.append('\"');
                        continue block11;
                    }
                    case '\\': {
                        b.append('\\');
                        continue block11;
                    }
                    case '/': {
                        b.append('/');
                        continue block11;
                    }
                    case 'u': {
                        int uc = Integer.parseInt(s.substring(++i, i + 4), 16);
                        b.append((char)uc);
                        i += 4;
                        continue block11;
                    }
                }
                throw new FHIRLexerException("Unknown character escape \\" + s.charAt(i), this.currentLocation);
            }
            b.append(ch);
            ++i;
        }
        return b.toString();
    }

    public void skipToken(String token) throws FHIRLexerException {
        if (this.getCurrent().equals(token)) {
            this.next();
        }
    }

    public String takeDottedToken() throws FHIRLexerException {
        StringBuilder b = new StringBuilder();
        b.append(this.take());
        while (!this.done() && this.getCurrent().equals(".")) {
            b.append(this.take());
            b.append(this.take());
        }
        return b.toString();
    }

    public int getCurrentStart() {
        return this.currentStart;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isLiquidMode() {
        return this.liquidMode;
    }

    public void setLiquidMode(boolean liquidMode) {
        this.liquidMode = liquidMode;
    }

    public SourceLocation getCommentLocation() {
        return this.commentLocation;
    }

    public class FHIRLexerException
    extends FHIRException {
        private SourceLocation location;

        public FHIRLexerException(String message, SourceLocation location) {
            super(message);
            this.location = location;
        }

        public SourceLocation getLocation() {
            return this.location;
        }
    }
}

