/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Identifier;

public class ConceptMapUtilities {
    public static boolean hasOID(ConceptMap cm) {
        return ConceptMapUtilities.getOID(cm) != null;
    }

    public static String getOID(ConceptMap cm) {
        for (Identifier id : cm.getIdentifier()) {
            if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !id.hasValue() || !id.getValue().startsWith("urn:oid:")) continue;
            return id.getValue().substring(8);
        }
        return null;
    }

    public static void setOID(ConceptMap cm, String oid) {
        if (!((String)oid).startsWith("urn:oid:")) {
            oid = "urn:oid:" + (String)oid;
        }
        for (Identifier id : cm.getIdentifier()) {
            if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !id.hasValue() || !id.getValue().startsWith("urn:oid:")) continue;
            id.setValue((String)oid);
            return;
        }
        cm.addIdentifier().setSystem("urn:ietf:rfc:3986").setValue((String)oid);
    }
}

