/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ConceptMapRenderer
extends TerminologyRenderer {
    public ConceptMapRenderer(RenderingContext context) {
        super(context);
    }

    public ConceptMapRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws FHIRFormatError, DefinitionException, IOException {
        return this.render(x, (ConceptMap)dr);
    }

    public boolean render(XhtmlNode x, ConceptMap cm) throws FHIRFormatError, DefinitionException, IOException {
        x.h2().addText(cm.getName() + " (" + cm.getUrl() + ")");
        XhtmlNode p = x.para();
        p.tx("Mapping from ");
        if (cm.hasSourceScope()) {
            this.AddVsRef(cm.getSourceScope().primitiveValue(), p, cm);
        } else {
            p.tx("(not specified)");
        }
        p.tx(" to ");
        if (cm.hasTargetScope()) {
            this.AddVsRef(cm.getTargetScope().primitiveValue(), p, cm);
        } else {
            p.tx("(not specified)");
        }
        p = x.para();
        if (cm.getExperimental()) {
            p.addText(Utilities.capitalize((String)cm.getStatus().toString()) + " (not intended for production usage). ");
        } else {
            p.addText(Utilities.capitalize((String)cm.getStatus().toString()) + ". ");
        }
        p.tx("Published on " + (cm.hasDate() ? this.display(cm.getDateElement()) : "?ngen-10?") + " by " + cm.getPublisher());
        if (!cm.getContact().isEmpty()) {
            p.tx(" (");
            boolean firsti = true;
            for (ContactDetail ci : cm.getContact()) {
                if (firsti) {
                    firsti = false;
                } else {
                    p.tx(", ");
                }
                if (ci.hasName()) {
                    p.addText(ci.getName() + ": ");
                }
                boolean first = true;
                for (ContactPoint c : ci.getTelecom()) {
                    if (first) {
                        first = false;
                    } else {
                        p.tx(", ");
                    }
                    this.addTelecom(p, c);
                }
            }
            p.tx(")");
        }
        p.tx(". ");
        p.addText(cm.getCopyright());
        if (!Utilities.noString((String)cm.getDescription())) {
            this.addMarkdown(x, cm.getDescription());
        }
        x.br();
        int gc = 0;
        CodeSystem cs = this.getContext().getWorker().fetchCodeSystem("http://hl7.org/fhir/concept-map-relationship");
        if (cs == null) {
            cs = this.getContext().getWorker().fetchCodeSystem("http://hl7.org/fhir/concept-map-equivalence");
        }
        String eqpath = cs == null ? null : cs.getUserString("path");
        for (ConceptMap.ConceptMapGroupComponent grp : cm.getGroup()) {
            String url;
            String display;
            String src = grp.getSource();
            boolean comment = false;
            boolean ok = true;
            HashMap sources = new HashMap();
            HashMap targets = new HashMap();
            sources.put("code", new HashSet());
            targets.put("code", new HashSet());
            ConceptMap.SourceElementComponent cc = grp.getElement().get(0);
            String dst = grp.getTarget();
            ((HashSet)sources.get("code")).add(grp.getSource());
            ((HashSet)targets.get("code")).add(grp.getTarget());
            for (ConceptMap.SourceElementComponent ccl : grp.getElement()) {
                ok = ok && (ccl.getNoMap() || ccl.getTarget().size() == 1 && ccl.getTarget().get(0).getDependsOn().isEmpty() && ccl.getTarget().get(0).getProduct().isEmpty());
                for (ConceptMap.TargetElementComponent ccm : ccl.getTarget()) {
                    comment = comment || !Utilities.noString((String)ccm.getComment());
                    for (ConceptMap.OtherElementComponent d : ccm.getDependsOn()) {
                        if (sources.containsKey(d.getProperty())) continue;
                        sources.put(d.getProperty(), new HashSet());
                    }
                    for (ConceptMap.OtherElementComponent d : ccm.getProduct()) {
                        if (targets.containsKey(d.getProperty())) continue;
                        targets.put(d.getProperty(), new HashSet());
                    }
                }
            }
            if (++gc > 1) {
                x.hr();
            }
            XhtmlNode pp = x.para();
            pp.b().tx("Group " + gc);
            pp.tx("Mapping from ");
            if (grp.hasSource()) {
                this.renderCanonical(cm, pp, grp.getSource());
            } else {
                pp.code("unspecified code system");
            }
            pp.tx(" to ");
            if (grp.hasTarget()) {
                this.renderCanonical(cm, pp, grp.getTarget());
            } else {
                pp.code("unspecified code system");
            }
            if (ok) {
                XhtmlNode tbl = x.table("grid");
                XhtmlNode tr = tbl.tr();
                tr.td().b().tx("Source Code");
                tr.td().b().tx("Relationship");
                tr.td().b().tx("Target Code");
                if (comment) {
                    tr.td().b().tx("Comment");
                }
                for (ConceptMap.SourceElementComponent ccl : grp.getElement()) {
                    tr = tbl.tr();
                    XhtmlNode td = tr.td();
                    td.addText(ccl.getCode());
                    String string = display = ccl.hasDisplay() ? ccl.getDisplay() : this.getDisplayForConcept(this.systemFromCanonical(grp.getSource()), this.versionFromCanonical(grp.getSource()), ccl.getCode());
                    if (display != null && !this.isSameCodeAndDisplay(ccl.getCode(), display)) {
                        td.tx(" (" + display + ")");
                    }
                    if (ccl.getNoMap()) {
                        tr.td().colspan(comment ? "3" : "2").style("background-color: #efefef").tx("(not mapped)");
                    } else {
                        ConceptMap.TargetElementComponent ccm = ccl.getTarget().get(0);
                        if (!ccm.hasRelationship()) {
                            tr.td().tx(":(" + Enumerations.ConceptMapRelationship.EQUIVALENT.toCode() + ")");
                        } else if (ccm.getRelationshipElement().hasExtension("http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence")) {
                            String code = ToolingExtensions.readStringExtension(ccm.getRelationshipElement(), "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence");
                            tr.td().ah(eqpath + "#" + code, code).tx(this.presentEquivalenceCode(code));
                        } else {
                            tr.td().ah(eqpath + "#" + ccm.getRelationship().toCode(), ccm.getRelationship().toCode()).tx(this.presentRelationshipCode(ccm.getRelationship().toCode()));
                        }
                        td = tr.td();
                        td.addText(ccm.getCode());
                        String string2 = display = ccm.hasDisplay() ? ccm.getDisplay() : this.getDisplayForConcept(this.systemFromCanonical(grp.getTarget()), this.versionFromCanonical(grp.getTarget()), ccm.getCode());
                        if (display != null && !this.isSameCodeAndDisplay(ccm.getCode(), display)) {
                            td.tx(" (" + display + ")");
                        }
                        if (comment) {
                            tr.td().addText(ccm.getComment());
                        }
                    }
                    this.addUnmapped(tbl, grp);
                }
                continue;
            }
            boolean hasRelationships = false;
            for (int si = 0; si < grp.getElement().size(); ++si) {
                ConceptMap.SourceElementComponent ccl = grp.getElement().get(si);
                for (int ti = 0; ti < ccl.getTarget().size(); ++ti) {
                    ConceptMap.TargetElementComponent ccm = ccl.getTarget().get(ti);
                    if (!ccm.hasRelationship()) continue;
                    hasRelationships = true;
                }
            }
            XhtmlNode tbl = x.table("grid");
            XhtmlNode tr = tbl.tr();
            tr.td().colspan(Integer.toString(1 + sources.size())).b().tx("Source Concept Details");
            if (hasRelationships) {
                tr.td().b().tx("Relationship");
            }
            tr.td().colspan(Integer.toString(1 + targets.size())).b().tx("Target Concept Details");
            if (comment) {
                tr.td().b().tx("Comment");
            }
            tr = tbl.tr();
            if (((HashSet)sources.get("code")).size() == 1) {
                String url2 = (String)((HashSet)sources.get("code")).iterator().next();
                this.renderCSDetailsLink(tr, url2, true);
            } else {
                tr.td().b().tx("Code");
            }
            for (String s : sources.keySet()) {
                if (s.equals("code")) continue;
                if (((HashSet)sources.get(s)).size() == 1) {
                    url = (String)((HashSet)sources.get(s)).iterator().next();
                    this.renderCSDetailsLink(tr, url, false);
                    continue;
                }
                tr.td().b().addText(this.getDescForConcept(s));
            }
            if (hasRelationships) {
                tr.td();
            }
            if (((HashSet)targets.get("code")).size() == 1) {
                Iterator url2 = (String)((HashSet)targets.get("code")).iterator().next();
                this.renderCSDetailsLink(tr, (String)((Object)url2), true);
            } else {
                tr.td().b().tx("Code");
            }
            for (String s : targets.keySet()) {
                if (s.equals("code")) continue;
                if (((HashSet)targets.get(s)).size() == 1) {
                    url = (String)((HashSet)targets.get(s)).iterator().next();
                    this.renderCSDetailsLink(tr, url, false);
                    continue;
                }
                tr.td().b().addText(this.getDescForConcept(s));
            }
            if (comment) {
                tr.td();
            }
            for (int si = 0; si < grp.getElement().size(); ++si) {
                XhtmlNode td;
                ConceptMap.SourceElementComponent ccl = grp.getElement().get(si);
                boolean slast = si == grp.getElement().size() - 1;
                boolean first = true;
                if (ccl.hasNoMap() && ccl.getNoMap()) {
                    tr = tbl.tr();
                    td = tr.td().style("border-right-width: 0px");
                    if (!first) {
                        td.style("border-top-style: none");
                    } else {
                        td.style("border-bottom-style: none");
                    }
                    if (((HashSet)sources.get("code")).size() == 1) {
                        td.addText(ccl.getCode());
                    } else {
                        td.addText(grp.getSource() + " / " + ccl.getCode());
                    }
                    display = ccl.hasDisplay() ? ccl.getDisplay() : this.getDisplayForConcept(this.systemFromCanonical(grp.getSource()), this.versionFromCanonical(grp.getSource()), ccl.getCode());
                    tr.td().style("border-left-width: 0px").tx(display == null ? "" : display);
                    tr.td().colspan("4").style("background-color: #efefef").tx("(not mapped)");
                } else {
                    for (int ti = 0; ti < ccl.getTarget().size(); ++ti) {
                        ConceptMap.TargetElementComponent ccm = ccl.getTarget().get(ti);
                        boolean last = ti == ccl.getTarget().size() - 1;
                        tr = tbl.tr();
                        td = tr.td().style("border-right-width: 0px");
                        if (!first && !last) {
                            td.style("border-top-style: none; border-bottom-style: none");
                        } else if (!first) {
                            td.style("border-top-style: none");
                        } else if (!last) {
                            td.style("border-bottom-style: none");
                        }
                        if (first) {
                            if (((HashSet)sources.get("code")).size() == 1) {
                                td.addText(ccl.getCode());
                            } else {
                                td.addText(grp.getSource() + " / " + ccl.getCode());
                            }
                            display = ccl.hasDisplay() ? ccl.getDisplay() : this.getDisplayForConcept(this.systemFromCanonical(grp.getSource()), this.versionFromCanonical(grp.getSource()), ccl.getCode());
                            td = tr.td();
                            if (!last) {
                                td.style("border-left-width: 0px; border-bottom-style: none");
                            } else {
                                td.style("border-left-width: 0px");
                            }
                            td.tx(display == null ? "" : display);
                        } else {
                            td = tr.td();
                            if (!last) {
                                td.style("border-left-width: 0px; border-top-style: none; border-bottom-style: none");
                            } else {
                                td.style("border-top-style: none; border-left-width: 0px");
                            }
                        }
                        for (String s : sources.keySet()) {
                            if (s.equals("code")) continue;
                            td = tr.td();
                            if (!first) continue;
                            td.addText(this.getValue(ccm.getDependsOn(), s, ((HashSet)sources.get(s)).size() != 1));
                            display = this.getDisplay(ccm.getDependsOn(), s);
                            if (display == null) continue;
                            td.tx(" (" + display + ")");
                        }
                        first = false;
                        if (hasRelationships) {
                            if (!ccm.hasRelationship()) {
                                tr.td();
                            } else if (ccm.getRelationshipElement().hasExtension("http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence")) {
                                String code = ToolingExtensions.readStringExtension(ccm.getRelationshipElement(), "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence");
                                tr.td().ah(eqpath + "#" + code, code).tx(this.presentEquivalenceCode(code));
                            } else {
                                tr.td().ah(eqpath + "#" + ccm.getRelationship().toCode(), ccm.getRelationship().toCode()).tx(this.presentRelationshipCode(ccm.getRelationship().toCode()));
                            }
                        }
                        td = tr.td().style("border-right-width: 0px");
                        if (((HashSet)targets.get("code")).size() == 1) {
                            td.addText(ccm.getCode());
                        } else {
                            td.addText(grp.getTarget() + " / " + ccm.getCode());
                        }
                        display = ccm.hasDisplay() ? ccm.getDisplay() : this.getDisplayForConcept(this.systemFromCanonical(grp.getTarget()), this.versionFromCanonical(grp.getTarget()), ccm.getCode());
                        tr.td().style("border-left-width: 0px").tx(display == null ? "" : display);
                        for (String s : targets.keySet()) {
                            if (s.equals("code")) continue;
                            td = tr.td();
                            td.addText(this.getValue(ccm.getProduct(), s, ((HashSet)targets.get(s)).size() != 1));
                            display = this.getDisplay(ccm.getProduct(), s);
                            if (display == null) continue;
                            td.tx(" (" + display + ")");
                        }
                        if (!comment) continue;
                        tr.td().addText(ccm.getComment());
                    }
                }
                this.addUnmapped(tbl, grp);
            }
        }
        return true;
    }

    public void describe(XhtmlNode x, ConceptMap cm) {
        x.tx(this.display(cm));
    }

    public String display(ConceptMap cm) {
        return cm.present();
    }

    private boolean isSameCodeAndDisplay(String code, String display) {
        String c = code.replace(" ", "").replace("-", "").toLowerCase();
        String d = display.replace(" ", "").replace("-", "").toLowerCase();
        return c.equals(d);
    }

    private String presentRelationshipCode(String code) {
        if ("related-to".equals(code)) {
            return "is related to";
        }
        if ("equivalent".equals(code)) {
            return "is equivalent to";
        }
        if ("source-is-narrower-than-target".equals(code)) {
            return "is narrower then";
        }
        if ("source-is-broader-than-target".equals(code)) {
            return "is broader than";
        }
        if ("not-related-to".equals(code)) {
            return "is not related to";
        }
        return code;
    }

    private String presentEquivalenceCode(String code) {
        if ("relatedto".equals(code)) {
            return "is related to";
        }
        if ("equivalent".equals(code)) {
            return "is equivalent to";
        }
        if ("equal".equals(code)) {
            return "is equal to";
        }
        if ("wider".equals(code)) {
            return "maps to wider concept";
        }
        if ("subsumes".equals(code)) {
            return "is subsumed by";
        }
        if ("source-is-broader-than-target".equals(code)) {
            return "maps to narrower concept";
        }
        if ("specializes".equals(code)) {
            return "has specialization";
        }
        if ("inexact".equals(code)) {
            return "maps loosely to";
        }
        if ("unmatched".equals(code)) {
            return "has no match";
        }
        if ("disjoint".equals(code)) {
            return "is not related to";
        }
        return code;
    }

    public void renderCSDetailsLink(XhtmlNode tr, String url, boolean span2) {
        CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(url);
        XhtmlNode td = tr.td();
        if (span2) {
            td.colspan("2");
        }
        td.b().tx("Codes");
        td.tx(" from ");
        if (cs == null) {
            td.tx(url);
        } else {
            td.ah(this.context.fixReference(cs.getUserString("path"))).attribute("title", url).tx(cs.present());
        }
    }

    private void addUnmapped(XhtmlNode tbl, ConceptMap.ConceptMapGroupComponent grp) {
        if (grp.hasUnmapped()) {
            // empty if block
        }
    }

    private String getDescForConcept(String s) {
        if (s.startsWith("http://hl7.org/fhir/v2/element/")) {
            return "v2 " + s.substring("http://hl7.org/fhir/v2/element/".length());
        }
        return s;
    }

    private String getValue(List<ConceptMap.OtherElementComponent> list, String s, boolean withSystem) {
        for (ConceptMap.OtherElementComponent c : list) {
            if (!s.equals(c.getProperty())) continue;
            if (withSystem) {
                return c.getValue().primitiveValue();
            }
            return c.getValue().primitiveValue();
        }
        return null;
    }

    private String getDisplay(List<ConceptMap.OtherElementComponent> list, String s) {
        for (ConceptMap.OtherElementComponent c : list) {
            if (!s.equals(c.getProperty())) continue;
        }
        return null;
    }
}

