/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ActorDefinitionRenderer
extends ResourceRenderer {
    public ActorDefinitionRenderer(RenderingContext context) {
        super(context);
    }

    public ActorDefinitionRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws FHIRFormatError, DefinitionException, IOException {
        return this.render(x, (ActorDefinition)dr);
    }

    public boolean render(XhtmlNode x, ActorDefinition acd) throws FHIRFormatError, DefinitionException, IOException {
        boolean first;
        XhtmlNode tbl = x.table("grid");
        XhtmlNode tr = tbl.tr();
        tr.td().b().tx("Actor: " + acd.getName());
        tr.td().tx(acd.getTitle());
        tr.td().tx("Type: " + acd.getType().toCode());
        XhtmlNode td = tbl.tr().td().colspan("3");
        this.addMarkdown(td, acd.getDocumentation());
        if (acd.hasReference()) {
            tbl.tr().td().tx("References:");
            td = tr.td().colspan("2");
            first = true;
            for (UrlType t : acd.getReference()) {
                if (first) {
                    first = false;
                } else {
                    x.br();
                }
                this.render(td, t);
            }
        }
        if (acd.hasCapabilities()) {
            tbl.tr().td().tx("Capabilities:");
            td = tr.td().colspan("2");
            CapabilityStatement cs = this.context.getWorker().fetchResource(CapabilityStatement.class, acd.getCapabilities(), acd);
            if (cs != null) {
                td.ah(cs.getUserString("path")).tx(cs.present());
            } else {
                this.render(td, acd.getCapabilitiesElement());
            }
        }
        if (acd.hasDerivedFrom()) {
            tbl.tr().td().tx("Derived from:");
            td = tr.td().colspan("2");
            first = true;
            for (UrlType t : acd.getReference()) {
                if (first) {
                    first = false;
                } else {
                    x.br();
                }
                ActorDefinition df = this.context.getWorker().fetchResource(ActorDefinition.class, (String)t.getValue(), acd);
                if (df != null) {
                    td.ah(df.getUserString("path")).tx(df.present());
                    continue;
                }
                this.render(td, t);
            }
        }
        return false;
    }

    public void describe(XhtmlNode x, Library lib) {
        x.tx(this.display(lib));
    }

    public String display(Library lib) {
        return lib.present();
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return ((Library)r).present();
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        if (r.has("title")) {
            return r.children("title").get(0).getBase().primitiveValue();
        }
        return "??";
    }
}

