/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class PackageInformation {
    private String id;
    private String version;
    private Date date;
    private String name;
    private String canonical;
    private String web;
    private List<String> dependencies = new ArrayList<String>();

    public PackageInformation(String id, String version, Date date, String name, String canonical, String web) {
        this.id = id;
        this.version = version;
        this.date = date;
        this.name = name;
        this.canonical = canonical;
        this.web = web;
    }

    public PackageInformation(String src, Date date) {
        this.id = src;
        this.date = date;
    }

    public PackageInformation(NpmPackage pi) {
        this.id = pi.name();
        this.version = pi.version();
        this.date = pi.dateAsDate();
        this.name = pi.title();
        this.canonical = pi.canonical();
        this.web = pi.getWebLocation();
        this.dependencies.addAll(pi.dependencies());
    }

    public PackageInformation(String id, String version, Date date) {
        this.id = id;
        this.version = version;
        this.date = date;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getDate() {
        return this.date;
    }

    public String getName() {
        return this.name;
    }

    public String getCanonical() {
        return this.canonical;
    }

    public String getWeb() {
        return this.web;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public boolean isExamplesPackage() {
        boolean b = this.id.startsWith("hl7.fhir.") && this.id.endsWith(".examples");
        return b;
    }

    public boolean isHTO() {
        boolean b = this.id.startsWith("hl7.terminology.r");
        return b;
    }

    public String getVID() {
        return this.id + "#" + this.version;
    }

    public String toString() {
        return this.getVID();
    }

    public String dense() {
        if (this.id.startsWith("hl7.fhir")) {
            return this.id.substring(9);
        }
        return this.id;
    }
}

