/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Age;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="Condition", profile="http://hl7.org/fhir/StructureDefinition/Condition")
public class Condition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Ids for this condition", formalDefinition="Business identifiers assigned to this condition by the performer or other systems which remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="clinicalStatus", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | recurrence | relapse | inactive | remission | resolved | unknown", formalDefinition="The clinical status of the condition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-clinical")
    protected CodeableConcept clinicalStatus;
    @Child(name="verificationStatus", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="unconfirmed | provisional | differential | confirmed | refuted | entered-in-error", formalDefinition="The verification status to support the clinical status of the condition.  The verification status pertains to the condition, itself, not to any specific condition attribute.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-ver-status")
    protected CodeableConcept verificationStatus;
    @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="problem-list-item | encounter-diagnosis", formalDefinition="A category assigned to the condition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-category")
    protected List<CodeableConcept> category;
    @Child(name="severity", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Subjective severity of condition", formalDefinition="A subjective assessment of the severity of the condition as evaluated by the clinician.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-severity")
    protected CodeableConcept severity;
    @Child(name="code", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identification of the condition, problem or diagnosis", formalDefinition="Identification of the condition, problem or diagnosis.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    protected CodeableConcept code;
    @Child(name="bodySite", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Anatomical location, if relevant", formalDefinition="The anatomical location where this condition manifests itself.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected List<CodeableConcept> bodySite;
    @Child(name="subject", type={Patient.class, Group.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who has the condition?", formalDefinition="Indicates the patient or group who the condition record is associated with.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The Encounter during which this Condition was created", formalDefinition="The Encounter during which this Condition was created or to which the creation of this record is tightly associated.")
    protected Reference encounter;
    @Child(name="onset", type={DateTimeType.class, Age.class, Period.class, Range.class, StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Estimated or actual date,  date-time, or age", formalDefinition="Estimated or actual date or date-time  the condition began, in the opinion of the clinician.")
    protected DataType onset;
    @Child(name="abatement", type={DateTimeType.class, Age.class, Period.class, Range.class, StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When in resolution/remission", formalDefinition="The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Some conditions, such as chronic conditions, are never really resolved, but they can abate.")
    protected DataType abatement;
    @Child(name="recordedDate", type={DateTimeType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date condition was first recorded", formalDefinition="The recordedDate represents when this particular Condition record was created in the system, which is often a system-generated date.")
    protected DateTimeType recordedDate;
    @Child(name="participant", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who or what participated in the activities related to the condition and how they were involved", formalDefinition="Indicates who or what participated in the activities related to the condition and how they were involved.")
    protected List<ConditionParticipantComponent> participant;
    @Child(name="stage", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Stage/grade, usually assessed formally", formalDefinition="A simple summary of the stage such as \"Stage 3\" or \"Early Onset\". The determination of the stage is disease-specific, such as cancer, retinopathy of prematurity, kidney diseases, Alzheimer's, or Parkinson disease.")
    protected List<ConditionStageComponent> stage;
    @Child(name="evidence", type={CodeableReference.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Supporting evidence for the verification status", formalDefinition="Supporting evidence / manifestations that are the basis of the Condition's verification status, such as evidence that confirmed or refuted the condition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
    protected List<CodeableReference> evidence;
    @Child(name="note", type={Annotation.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional information about the Condition", formalDefinition="Additional information about the Condition. This is a general notes/comments entry  for description of the Condition, its diagnosis and prognosis.")
    protected List<Annotation> note;
    private static final long serialVersionUID = -610903427L;
    @SearchParamDefinition(name="abatement-age", path="Condition.abatement.ofType(Age) | Condition.abatement.ofType(Range)", description="Abatement as age or age range", type="quantity")
    public static final String SP_ABATEMENT_AGE = "abatement-age";
    public static final QuantityClientParam ABATEMENT_AGE = new QuantityClientParam("abatement-age");
    @SearchParamDefinition(name="abatement-date", path="Condition.abatement.ofType(dateTime) | Condition.abatement.ofType(Period)", description="Date-related abatements (dateTime and period)", type="date")
    public static final String SP_ABATEMENT_DATE = "abatement-date";
    public static final DateClientParam ABATEMENT_DATE = new DateClientParam("abatement-date");
    @SearchParamDefinition(name="abatement-string", path="Condition.abatement.ofType(string)", description="Abatement as a string", type="string")
    public static final String SP_ABATEMENT_STRING = "abatement-string";
    public static final StringClientParam ABATEMENT_STRING = new StringClientParam("abatement-string");
    @SearchParamDefinition(name="body-site", path="Condition.bodySite", description="Anatomical location, if relevant", type="token")
    public static final String SP_BODY_SITE = "body-site";
    public static final TokenClientParam BODY_SITE = new TokenClientParam("body-site");
    @SearchParamDefinition(name="category", path="Condition.category", description="The category of the condition", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="clinical-status", path="Condition.clinicalStatus", description="The clinical status of the condition", type="token")
    public static final String SP_CLINICAL_STATUS = "clinical-status";
    public static final TokenClientParam CLINICAL_STATUS = new TokenClientParam("clinical-status");
    @SearchParamDefinition(name="encounter", path="Condition.encounter", description="The Encounter during which this Condition was created", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Condition:encounter").toLocked();
    @SearchParamDefinition(name="evidence-detail", path="Condition.evidence.reference", description="Supporting information found elsewhere", type="reference")
    public static final String SP_EVIDENCE_DETAIL = "evidence-detail";
    public static final ReferenceClientParam EVIDENCE_DETAIL = new ReferenceClientParam("evidence-detail");
    public static final Include INCLUDE_EVIDENCE_DETAIL = new Include("Condition:evidence-detail").toLocked();
    @SearchParamDefinition(name="evidence", path="Condition.evidence.concept", description="Manifestation/symptom", type="token")
    public static final String SP_EVIDENCE = "evidence";
    public static final TokenClientParam EVIDENCE = new TokenClientParam("evidence");
    @SearchParamDefinition(name="onset-age", path="Condition.onset.ofType(Age) | Condition.onset.ofType(Range)", description="Onsets as age or age range", type="quantity")
    public static final String SP_ONSET_AGE = "onset-age";
    public static final QuantityClientParam ONSET_AGE = new QuantityClientParam("onset-age");
    @SearchParamDefinition(name="onset-date", path="Condition.onset.ofType(dateTime) | Condition.onset.ofType(Period)", description="Date related onsets (dateTime and Period)", type="date")
    public static final String SP_ONSET_DATE = "onset-date";
    public static final DateClientParam ONSET_DATE = new DateClientParam("onset-date");
    @SearchParamDefinition(name="onset-info", path="Condition.onset.ofType(string)", description="Onsets as a string", type="string")
    public static final String SP_ONSET_INFO = "onset-info";
    public static final StringClientParam ONSET_INFO = new StringClientParam("onset-info");
    @SearchParamDefinition(name="participant-actor", path="Condition.participant.actor", description="Who or what participated in the activities related to the condition", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={CareTeam.class, Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PARTICIPANT_ACTOR = "participant-actor";
    public static final ReferenceClientParam PARTICIPANT_ACTOR = new ReferenceClientParam("participant-actor");
    public static final Include INCLUDE_PARTICIPANT_ACTOR = new Include("Condition:participant-actor").toLocked();
    @SearchParamDefinition(name="participant-function", path="Condition.participant.function", description="Type of involvement of the actor in the activities related to the condition", type="token")
    public static final String SP_PARTICIPANT_FUNCTION = "participant-function";
    public static final TokenClientParam PARTICIPANT_FUNCTION = new TokenClientParam("participant-function");
    @SearchParamDefinition(name="recorded-date", path="Condition.recordedDate", description="Date record was first recorded", type="date")
    public static final String SP_RECORDED_DATE = "recorded-date";
    public static final DateClientParam RECORDED_DATE = new DateClientParam("recorded-date");
    @SearchParamDefinition(name="severity", path="Condition.severity", description="The severity of the condition", type="token")
    public static final String SP_SEVERITY = "severity";
    public static final TokenClientParam SEVERITY = new TokenClientParam("severity");
    @SearchParamDefinition(name="stage", path="Condition.stage.summary", description="Simple summary (disease specific)", type="token")
    public static final String SP_STAGE = "stage";
    public static final TokenClientParam STAGE = new TokenClientParam("stage");
    @SearchParamDefinition(name="subject", path="Condition.subject", description="Who has the condition?", type="reference", target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Condition:subject").toLocked();
    @SearchParamDefinition(name="verification-status", path="Condition.verificationStatus", description="unconfirmed | provisional | differential | confirmed | refuted | entered-in-error", type="token")
    public static final String SP_VERIFICATION_STATUS = "verification-status";
    public static final TokenClientParam VERIFICATION_STATUS = new TokenClientParam("verification-status");
    @SearchParamDefinition(name="code", path="AllergyIntolerance.code | AllergyIntolerance.reaction.substance | Condition.code | DeviceRequest.code.concept | DiagnosticReport.code | FamilyMemberHistory.condition.code | List.code | Medication.code | MedicationAdministration.medication.concept | MedicationDispense.medication.concept | MedicationRequest.medication.concept | MedicationUsage.medication.concept | Observation.code | Procedure.code", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [Condition](condition.html): Code for the condition\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationUsage](medicationusage.html): Return statements of this medication code\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationUsage.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationUsage](medicationusage.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.subject | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={BiologicallyDerivedProduct.class, Device.class, Group.class, Location.class, Medication.class, NutritionProduct.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Substance.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Condition:patient").toLocked();

    public Condition() {
    }

    public Condition(CodeableConcept clinicalStatus, Reference subject) {
        this.setClinicalStatus(clinicalStatus);
        this.setSubject(subject);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Condition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Condition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConcept getClinicalStatus() {
        if (this.clinicalStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.clinicalStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.clinicalStatus = new CodeableConcept();
            }
        }
        return this.clinicalStatus;
    }

    public boolean hasClinicalStatus() {
        return this.clinicalStatus != null && !this.clinicalStatus.isEmpty();
    }

    public Condition setClinicalStatus(CodeableConcept value) {
        this.clinicalStatus = value;
        return this;
    }

    public CodeableConcept getVerificationStatus() {
        if (this.verificationStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.verificationStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.verificationStatus = new CodeableConcept();
            }
        }
        return this.verificationStatus;
    }

    public boolean hasVerificationStatus() {
        return this.verificationStatus != null && !this.verificationStatus.isEmpty();
    }

    public Condition setVerificationStatus(CodeableConcept value) {
        this.verificationStatus = value;
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public Condition setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public Condition addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableConcept getSeverity() {
        if (this.severity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.severity");
            }
            if (Configuration.doAutoCreate()) {
                this.severity = new CodeableConcept();
            }
        }
        return this.severity;
    }

    public boolean hasSeverity() {
        return this.severity != null && !this.severity.isEmpty();
    }

    public Condition setSeverity(CodeableConcept value) {
        this.severity = value;
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Condition setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public List<CodeableConcept> getBodySite() {
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        return this.bodySite;
    }

    public Condition setBodySite(List<CodeableConcept> theBodySite) {
        this.bodySite = theBodySite;
        return this;
    }

    public boolean hasBodySite() {
        if (this.bodySite == null) {
            return false;
        }
        for (CodeableConcept item : this.bodySite) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addBodySite() {
        CodeableConcept t = new CodeableConcept();
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return t;
    }

    public Condition addBodySite(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return this;
    }

    public CodeableConcept getBodySiteFirstRep() {
        if (this.getBodySite().isEmpty()) {
            this.addBodySite();
        }
        return this.getBodySite().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Condition setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public Condition setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DataType getOnset() {
        return this.onset;
    }

    public DateTimeType getOnsetDateTimeType() throws FHIRException {
        if (this.onset == null) {
            this.onset = new DateTimeType();
        }
        if (!(this.onset instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.onset;
    }

    public boolean hasOnsetDateTimeType() {
        return this != null && this.onset instanceof DateTimeType;
    }

    public Age getOnsetAge() throws FHIRException {
        if (this.onset == null) {
            this.onset = new Age();
        }
        if (!(this.onset instanceof Age)) {
            throw new FHIRException("Type mismatch: the type Age was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (Age)this.onset;
    }

    public boolean hasOnsetAge() {
        return this != null && this.onset instanceof Age;
    }

    public Period getOnsetPeriod() throws FHIRException {
        if (this.onset == null) {
            this.onset = new Period();
        }
        if (!(this.onset instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (Period)this.onset;
    }

    public boolean hasOnsetPeriod() {
        return this != null && this.onset instanceof Period;
    }

    public Range getOnsetRange() throws FHIRException {
        if (this.onset == null) {
            this.onset = new Range();
        }
        if (!(this.onset instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (Range)this.onset;
    }

    public boolean hasOnsetRange() {
        return this != null && this.onset instanceof Range;
    }

    public StringType getOnsetStringType() throws FHIRException {
        if (this.onset == null) {
            this.onset = new StringType();
        }
        if (!(this.onset instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (StringType)this.onset;
    }

    public boolean hasOnsetStringType() {
        return this != null && this.onset instanceof StringType;
    }

    public boolean hasOnset() {
        return this.onset != null && !this.onset.isEmpty();
    }

    public Condition setOnset(DataType value) {
        if (!(value == null || value instanceof DateTimeType || value instanceof Age || value instanceof Period || value instanceof Range || value instanceof StringType)) {
            throw new Error("Not the right type for Condition.onset[x]: " + value.fhirType());
        }
        this.onset = value;
        return this;
    }

    public DataType getAbatement() {
        return this.abatement;
    }

    public DateTimeType getAbatementDateTimeType() throws FHIRException {
        if (this.abatement == null) {
            this.abatement = new DateTimeType();
        }
        if (!(this.abatement instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.abatement.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.abatement;
    }

    public boolean hasAbatementDateTimeType() {
        return this != null && this.abatement instanceof DateTimeType;
    }

    public Age getAbatementAge() throws FHIRException {
        if (this.abatement == null) {
            this.abatement = new Age();
        }
        if (!(this.abatement instanceof Age)) {
            throw new FHIRException("Type mismatch: the type Age was expected, but " + this.abatement.getClass().getName() + " was encountered");
        }
        return (Age)this.abatement;
    }

    public boolean hasAbatementAge() {
        return this != null && this.abatement instanceof Age;
    }

    public Period getAbatementPeriod() throws FHIRException {
        if (this.abatement == null) {
            this.abatement = new Period();
        }
        if (!(this.abatement instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.abatement.getClass().getName() + " was encountered");
        }
        return (Period)this.abatement;
    }

    public boolean hasAbatementPeriod() {
        return this != null && this.abatement instanceof Period;
    }

    public Range getAbatementRange() throws FHIRException {
        if (this.abatement == null) {
            this.abatement = new Range();
        }
        if (!(this.abatement instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.abatement.getClass().getName() + " was encountered");
        }
        return (Range)this.abatement;
    }

    public boolean hasAbatementRange() {
        return this != null && this.abatement instanceof Range;
    }

    public StringType getAbatementStringType() throws FHIRException {
        if (this.abatement == null) {
            this.abatement = new StringType();
        }
        if (!(this.abatement instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.abatement.getClass().getName() + " was encountered");
        }
        return (StringType)this.abatement;
    }

    public boolean hasAbatementStringType() {
        return this != null && this.abatement instanceof StringType;
    }

    public boolean hasAbatement() {
        return this.abatement != null && !this.abatement.isEmpty();
    }

    public Condition setAbatement(DataType value) {
        if (!(value == null || value instanceof DateTimeType || value instanceof Age || value instanceof Period || value instanceof Range || value instanceof StringType)) {
            throw new Error("Not the right type for Condition.abatement[x]: " + value.fhirType());
        }
        this.abatement = value;
        return this;
    }

    public DateTimeType getRecordedDateElement() {
        if (this.recordedDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.recordedDate");
            }
            if (Configuration.doAutoCreate()) {
                this.recordedDate = new DateTimeType();
            }
        }
        return this.recordedDate;
    }

    public boolean hasRecordedDateElement() {
        return this.recordedDate != null && !this.recordedDate.isEmpty();
    }

    public boolean hasRecordedDate() {
        return this.recordedDate != null && !this.recordedDate.isEmpty();
    }

    public Condition setRecordedDateElement(DateTimeType value) {
        this.recordedDate = value;
        return this;
    }

    public Date getRecordedDate() {
        return this.recordedDate == null ? null : (Date)this.recordedDate.getValue();
    }

    public Condition setRecordedDate(Date value) {
        if (value == null) {
            this.recordedDate = null;
        } else {
            if (this.recordedDate == null) {
                this.recordedDate = new DateTimeType();
            }
            this.recordedDate.setValue(value);
        }
        return this;
    }

    public List<ConditionParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<ConditionParticipantComponent>();
        }
        return this.participant;
    }

    public Condition setParticipant(List<ConditionParticipantComponent> theParticipant) {
        this.participant = theParticipant;
        return this;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (ConditionParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConditionParticipantComponent addParticipant() {
        ConditionParticipantComponent t = new ConditionParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<ConditionParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public Condition addParticipant(ConditionParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<ConditionParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public ConditionParticipantComponent getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public List<ConditionStageComponent> getStage() {
        if (this.stage == null) {
            this.stage = new ArrayList<ConditionStageComponent>();
        }
        return this.stage;
    }

    public Condition setStage(List<ConditionStageComponent> theStage) {
        this.stage = theStage;
        return this;
    }

    public boolean hasStage() {
        if (this.stage == null) {
            return false;
        }
        for (ConditionStageComponent item : this.stage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConditionStageComponent addStage() {
        ConditionStageComponent t = new ConditionStageComponent();
        if (this.stage == null) {
            this.stage = new ArrayList<ConditionStageComponent>();
        }
        this.stage.add(t);
        return t;
    }

    public Condition addStage(ConditionStageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.stage == null) {
            this.stage = new ArrayList<ConditionStageComponent>();
        }
        this.stage.add(t);
        return this;
    }

    public ConditionStageComponent getStageFirstRep() {
        if (this.getStage().isEmpty()) {
            this.addStage();
        }
        return this.getStage().get(0);
    }

    public List<CodeableReference> getEvidence() {
        if (this.evidence == null) {
            this.evidence = new ArrayList<CodeableReference>();
        }
        return this.evidence;
    }

    public Condition setEvidence(List<CodeableReference> theEvidence) {
        this.evidence = theEvidence;
        return this;
    }

    public boolean hasEvidence() {
        if (this.evidence == null) {
            return false;
        }
        for (CodeableReference item : this.evidence) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addEvidence() {
        CodeableReference t = new CodeableReference();
        if (this.evidence == null) {
            this.evidence = new ArrayList<CodeableReference>();
        }
        this.evidence.add(t);
        return t;
    }

    public Condition addEvidence(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.evidence == null) {
            this.evidence = new ArrayList<CodeableReference>();
        }
        this.evidence.add(t);
        return this;
    }

    public CodeableReference getEvidenceFirstRep() {
        if (this.getEvidence().isEmpty()) {
            this.addEvidence();
        }
        return this.getEvidence().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Condition setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Condition addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this condition by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("clinicalStatus", "CodeableConcept", "The clinical status of the condition.", 0, 1, this.clinicalStatus));
        children.add(new Property("verificationStatus", "CodeableConcept", "The verification status to support the clinical status of the condition.  The verification status pertains to the condition, itself, not to any specific condition attribute.", 0, 1, this.verificationStatus));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "A category assigned to the condition.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_SEVERITY, "CodeableConcept", "A subjective assessment of the severity of the condition as evaluated by the clinician.", 0, 1, this.severity));
        children.add(new Property(SP_CODE, "CodeableConcept", "Identification of the condition, problem or diagnosis.", 0, 1, this.code));
        children.add(new Property("bodySite", "CodeableConcept", "The anatomical location where this condition manifests itself.", 0, Integer.MAX_VALUE, this.bodySite));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "Indicates the patient or group who the condition record is associated with.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The Encounter during which this Condition was created or to which the creation of this record is tightly associated.", 0, 1, this.encounter));
        children.add(new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date or date-time  the condition began, in the opinion of the clinician.", 0, 1, this.onset));
        children.add(new Property("abatement[x]", "dateTime|Age|Period|Range|string", "The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Some conditions, such as chronic conditions, are never really resolved, but they can abate.", 0, 1, this.abatement));
        children.add(new Property("recordedDate", "dateTime", "The recordedDate represents when this particular Condition record was created in the system, which is often a system-generated date.", 0, 1, this.recordedDate));
        children.add(new Property("participant", "", "Indicates who or what participated in the activities related to the condition and how they were involved.", 0, Integer.MAX_VALUE, this.participant));
        children.add(new Property(SP_STAGE, "", "A simple summary of the stage such as \"Stage 3\" or \"Early Onset\". The determination of the stage is disease-specific, such as cancer, retinopathy of prematurity, kidney diseases, Alzheimer's, or Parkinson disease.", 0, Integer.MAX_VALUE, this.stage));
        children.add(new Property(SP_EVIDENCE, "CodeableReference(Any)", "Supporting evidence / manifestations that are the basis of the Condition's verification status, such as evidence that confirmed or refuted the condition.", 0, Integer.MAX_VALUE, this.evidence));
        children.add(new Property("note", "Annotation", "Additional information about the Condition. This is a general notes/comments entry  for description of the Condition, its diagnosis and prognosis.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this condition by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -462853915: {
                return new Property("clinicalStatus", "CodeableConcept", "The clinical status of the condition.", 0, 1, this.clinicalStatus);
            }
            case -842509843: {
                return new Property("verificationStatus", "CodeableConcept", "The verification status to support the clinical status of the condition.  The verification status pertains to the condition, itself, not to any specific condition attribute.", 0, 1, this.verificationStatus);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "A category assigned to the condition.", 0, Integer.MAX_VALUE, this.category);
            }
            case 1478300413: {
                return new Property(SP_SEVERITY, "CodeableConcept", "A subjective assessment of the severity of the condition as evaluated by the clinician.", 0, 1, this.severity);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "Identification of the condition, problem or diagnosis.", 0, 1, this.code);
            }
            case 1702620169: {
                return new Property("bodySite", "CodeableConcept", "The anatomical location where this condition manifests itself.", 0, Integer.MAX_VALUE, this.bodySite);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "Indicates the patient or group who the condition record is associated with.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The Encounter during which this Condition was created or to which the creation of this record is tightly associated.", 0, 1, this.encounter);
            }
            case -1886216323: {
                return new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date or date-time  the condition began, in the opinion of the clinician.", 0, 1, this.onset);
            }
            case 105901603: {
                return new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date or date-time  the condition began, in the opinion of the clinician.", 0, 1, this.onset);
            }
            case -1701663010: {
                return new Property("onset[x]", "dateTime", "Estimated or actual date or date-time  the condition began, in the opinion of the clinician.", 0, 1, this.onset);
            }
            case -1886241828: {
                return new Property("onset[x]", "Age", "Estimated or actual date or date-time  the condition began, in the opinion of the clinician.", 0, 1, this.onset);
            }
            case -1545082428: {
                return new Property("onset[x]", "Period", "Estimated or actual date or date-time  the condition began, in the opinion of the clinician.", 0, 1, this.onset);
            }
            case -186664742: {
                return new Property("onset[x]", "Range", "Estimated or actual date or date-time  the condition began, in the opinion of the clinician.", 0, 1, this.onset);
            }
            case -1445342188: {
                return new Property("onset[x]", "string", "Estimated or actual date or date-time  the condition began, in the opinion of the clinician.", 0, 1, this.onset);
            }
            case -584196495: {
                return new Property("abatement[x]", "dateTime|Age|Period|Range|string", "The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Some conditions, such as chronic conditions, are never really resolved, but they can abate.", 0, 1, this.abatement);
            }
            case -921554001: {
                return new Property("abatement[x]", "dateTime|Age|Period|Range|string", "The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Some conditions, such as chronic conditions, are never really resolved, but they can abate.", 0, 1, this.abatement);
            }
            case 44869738: {
                return new Property("abatement[x]", "dateTime", "The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Some conditions, such as chronic conditions, are never really resolved, but they can abate.", 0, 1, this.abatement);
            }
            case -584222000: {
                return new Property("abatement[x]", "Age", "The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Some conditions, such as chronic conditions, are never really resolved, but they can abate.", 0, 1, this.abatement);
            }
            case -922036656: {
                return new Property("abatement[x]", "Period", "The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Some conditions, such as chronic conditions, are never really resolved, but they can abate.", 0, 1, this.abatement);
            }
            case 1218906830: {
                return new Property("abatement[x]", "Range", "The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Some conditions, such as chronic conditions, are never really resolved, but they can abate.", 0, 1, this.abatement);
            }
            case -822296416: {
                return new Property("abatement[x]", "string", "The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Some conditions, such as chronic conditions, are never really resolved, but they can abate.", 0, 1, this.abatement);
            }
            case -1952893826: {
                return new Property("recordedDate", "dateTime", "The recordedDate represents when this particular Condition record was created in the system, which is often a system-generated date.", 0, 1, this.recordedDate);
            }
            case 767422259: {
                return new Property("participant", "", "Indicates who or what participated in the activities related to the condition and how they were involved.", 0, Integer.MAX_VALUE, this.participant);
            }
            case 109757182: {
                return new Property(SP_STAGE, "", "A simple summary of the stage such as \"Stage 3\" or \"Early Onset\". The determination of the stage is disease-specific, such as cancer, retinopathy of prematurity, kidney diseases, Alzheimer's, or Parkinson disease.", 0, Integer.MAX_VALUE, this.stage);
            }
            case 382967383: {
                return new Property(SP_EVIDENCE, "CodeableReference(Any)", "Supporting evidence / manifestations that are the basis of the Condition's verification status, such as evidence that confirmed or refuted the condition.", 0, Integer.MAX_VALUE, this.evidence);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Additional information about the Condition. This is a general notes/comments entry  for description of the Condition, its diagnosis and prognosis.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -462853915: {
                Base[] baseArray;
                if (this.clinicalStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.clinicalStatus;
                }
                return baseArray;
            }
            case -842509843: {
                Base[] baseArray;
                if (this.verificationStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.verificationStatus;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 1478300413: {
                Base[] baseArray;
                if (this.severity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.severity;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.code;
                }
                return baseArray;
            }
            case 1702620169: {
                return this.bodySite == null ? new Base[]{} : this.bodySite.toArray(new Base[this.bodySite.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.encounter;
                }
                return baseArray;
            }
            case 105901603: {
                Base[] baseArray;
                if (this.onset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.onset;
                }
                return baseArray;
            }
            case -921554001: {
                Base[] baseArray;
                if (this.abatement == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.abatement;
                }
                return baseArray;
            }
            case -1952893826: {
                Base[] baseArray;
                if (this.recordedDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.recordedDate;
                }
                return baseArray;
            }
            case 767422259: {
                return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
            }
            case 109757182: {
                return this.stage == null ? new Base[]{} : this.stage.toArray(new Base[this.stage.size()]);
            }
            case 382967383: {
                return this.evidence == null ? new Base[]{} : this.evidence.toArray(new Base[this.evidence.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -462853915: {
                this.clinicalStatus = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -842509843: {
                this.verificationStatus = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 1478300413: {
                this.severity = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1702620169: {
                this.getBodySite().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case 105901603: {
                this.onset = TypeConvertor.castToType(value);
                return value;
            }
            case -921554001: {
                this.abatement = TypeConvertor.castToType(value);
                return value;
            }
            case -1952893826: {
                this.recordedDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 767422259: {
                this.getParticipant().add((ConditionParticipantComponent)value);
                return value;
            }
            case 109757182: {
                this.getStage().add((ConditionStageComponent)value);
                return value;
            }
            case 382967383: {
                this.getEvidence().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("clinicalStatus")) {
            this.clinicalStatus = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("verificationStatus")) {
            this.verificationStatus = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SEVERITY)) {
            this.severity = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("bodySite")) {
            this.getBodySite().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("onset[x]")) {
            this.onset = TypeConvertor.castToType(value);
        } else if (name.equals("abatement[x]")) {
            this.abatement = TypeConvertor.castToType(value);
        } else if (name.equals("recordedDate")) {
            this.recordedDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("participant")) {
            this.getParticipant().add((ConditionParticipantComponent)value);
        } else if (name.equals(SP_STAGE)) {
            this.getStage().add((ConditionStageComponent)value);
        } else if (name.equals(SP_EVIDENCE)) {
            this.getEvidence().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -462853915: {
                return this.getClinicalStatus();
            }
            case -842509843: {
                return this.getVerificationStatus();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 1478300413: {
                return this.getSeverity();
            }
            case 3059181: {
                return this.getCode();
            }
            case 1702620169: {
                return this.addBodySite();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -1886216323: {
                return this.getOnset();
            }
            case 105901603: {
                return this.getOnset();
            }
            case -584196495: {
                return this.getAbatement();
            }
            case -921554001: {
                return this.getAbatement();
            }
            case -1952893826: {
                return this.getRecordedDateElement();
            }
            case 767422259: {
                return this.addParticipant();
            }
            case 109757182: {
                return this.addStage();
            }
            case 382967383: {
                return this.addEvidence();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -462853915: {
                return new String[]{"CodeableConcept"};
            }
            case -842509843: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 1478300413: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case 1702620169: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 105901603: {
                return new String[]{"dateTime", "Age", "Period", "Range", "string"};
            }
            case -921554001: {
                return new String[]{"dateTime", "Age", "Period", "Range", "string"};
            }
            case -1952893826: {
                return new String[]{"dateTime"};
            }
            case 767422259: {
                return new String[0];
            }
            case 109757182: {
                return new String[0];
            }
            case 382967383: {
                return new String[]{"CodeableReference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("clinicalStatus")) {
            this.clinicalStatus = new CodeableConcept();
            return this.clinicalStatus;
        }
        if (name.equals("verificationStatus")) {
            this.verificationStatus = new CodeableConcept();
            return this.verificationStatus;
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_SEVERITY)) {
            this.severity = new CodeableConcept();
            return this.severity;
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("bodySite")) {
            return this.addBodySite();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("onsetDateTime")) {
            this.onset = new DateTimeType();
            return this.onset;
        }
        if (name.equals("onsetAge")) {
            this.onset = new Age();
            return this.onset;
        }
        if (name.equals("onsetPeriod")) {
            this.onset = new Period();
            return this.onset;
        }
        if (name.equals("onsetRange")) {
            this.onset = new Range();
            return this.onset;
        }
        if (name.equals("onsetString")) {
            this.onset = new StringType();
            return this.onset;
        }
        if (name.equals("abatementDateTime")) {
            this.abatement = new DateTimeType();
            return this.abatement;
        }
        if (name.equals("abatementAge")) {
            this.abatement = new Age();
            return this.abatement;
        }
        if (name.equals("abatementPeriod")) {
            this.abatement = new Period();
            return this.abatement;
        }
        if (name.equals("abatementRange")) {
            this.abatement = new Range();
            return this.abatement;
        }
        if (name.equals("abatementString")) {
            this.abatement = new StringType();
            return this.abatement;
        }
        if (name.equals("recordedDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Condition.recordedDate");
        }
        if (name.equals("participant")) {
            return this.addParticipant();
        }
        if (name.equals(SP_STAGE)) {
            return this.addStage();
        }
        if (name.equals(SP_EVIDENCE)) {
            return this.addEvidence();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Condition";
    }

    @Override
    public Condition copy() {
        Condition dst = new Condition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Condition dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.clinicalStatus = this.clinicalStatus == null ? null : this.clinicalStatus.copy();
        CodeableConcept codeableConcept = dst.verificationStatus = this.verificationStatus == null ? null : this.verificationStatus.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.category) {
                dst.category.add(codeableConcept2.copy());
            }
        }
        dst.severity = this.severity == null ? null : this.severity.copy();
        CodeableConcept codeableConcept3 = dst.code = this.code == null ? null : this.code.copy();
        if (this.bodySite != null) {
            dst.bodySite = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept4 : this.bodySite) {
                dst.bodySite.add(codeableConcept4.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.onset = this.onset == null ? null : this.onset.copy();
        dst.abatement = this.abatement == null ? null : this.abatement.copy();
        DateTimeType dateTimeType = dst.recordedDate = this.recordedDate == null ? null : this.recordedDate.copy();
        if (this.participant != null) {
            dst.participant = new ArrayList<ConditionParticipantComponent>();
            for (ConditionParticipantComponent conditionParticipantComponent : this.participant) {
                dst.participant.add(conditionParticipantComponent.copy());
            }
        }
        if (this.stage != null) {
            dst.stage = new ArrayList<ConditionStageComponent>();
            for (ConditionStageComponent conditionStageComponent : this.stage) {
                dst.stage.add(conditionStageComponent.copy());
            }
        }
        if (this.evidence != null) {
            dst.evidence = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.evidence) {
                dst.evidence.add(codeableReference.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected Condition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Condition)) {
            return false;
        }
        Condition o = (Condition)other_;
        return Condition.compareDeep(this.identifier, o.identifier, true) && Condition.compareDeep(this.clinicalStatus, o.clinicalStatus, true) && Condition.compareDeep(this.verificationStatus, o.verificationStatus, true) && Condition.compareDeep(this.category, o.category, true) && Condition.compareDeep(this.severity, o.severity, true) && Condition.compareDeep(this.code, o.code, true) && Condition.compareDeep(this.bodySite, o.bodySite, true) && Condition.compareDeep(this.subject, o.subject, true) && Condition.compareDeep(this.encounter, o.encounter, true) && Condition.compareDeep(this.onset, o.onset, true) && Condition.compareDeep(this.abatement, o.abatement, true) && Condition.compareDeep(this.recordedDate, o.recordedDate, true) && Condition.compareDeep(this.participant, o.participant, true) && Condition.compareDeep(this.stage, o.stage, true) && Condition.compareDeep(this.evidence, o.evidence, true) && Condition.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Condition)) {
            return false;
        }
        Condition o = (Condition)other_;
        return Condition.compareValues(this.recordedDate, o.recordedDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.clinicalStatus, this.verificationStatus, this.category, this.severity, this.code, this.bodySite, this.subject, this.encounter, this.onset, this.abatement, this.recordedDate, this.participant, this.stage, this.evidence, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Condition;
    }

    @Block
    public static class ConditionStageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="summary", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Simple summary (disease specific)", formalDefinition="A simple summary of the stage such as \"Stage 3\" or \"Early Onset\". The determination of the stage is disease-specific, such as cancer, retinopathy of prematurity, kidney diseases, Alzheimer's, or Parkinson disease.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-stage")
        protected CodeableConcept summary;
        @Child(name="assessment", type={ClinicalImpression.class, DiagnosticReport.class, Observation.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Formal record of assessment", formalDefinition="Reference to a formal record of the evidence on which the staging assessment is based.")
        protected List<Reference> assessment;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Kind of staging", formalDefinition="The kind of staging, such as pathological or clinical staging.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-stage-type")
        protected CodeableConcept type;
        private static final long serialVersionUID = -394541797L;

        public CodeableConcept getSummary() {
            if (this.summary == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionStageComponent.summary");
                }
                if (Configuration.doAutoCreate()) {
                    this.summary = new CodeableConcept();
                }
            }
            return this.summary;
        }

        public boolean hasSummary() {
            return this.summary != null && !this.summary.isEmpty();
        }

        public ConditionStageComponent setSummary(CodeableConcept value) {
            this.summary = value;
            return this;
        }

        public List<Reference> getAssessment() {
            if (this.assessment == null) {
                this.assessment = new ArrayList<Reference>();
            }
            return this.assessment;
        }

        public ConditionStageComponent setAssessment(List<Reference> theAssessment) {
            this.assessment = theAssessment;
            return this;
        }

        public boolean hasAssessment() {
            if (this.assessment == null) {
                return false;
            }
            for (Reference item : this.assessment) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addAssessment() {
            Reference t = new Reference();
            if (this.assessment == null) {
                this.assessment = new ArrayList<Reference>();
            }
            this.assessment.add(t);
            return t;
        }

        public ConditionStageComponent addAssessment(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.assessment == null) {
                this.assessment = new ArrayList<Reference>();
            }
            this.assessment.add(t);
            return this;
        }

        public Reference getAssessmentFirstRep() {
            if (this.getAssessment().isEmpty()) {
                this.addAssessment();
            }
            return this.getAssessment().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionStageComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ConditionStageComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("summary", "CodeableConcept", "A simple summary of the stage such as \"Stage 3\" or \"Early Onset\". The determination of the stage is disease-specific, such as cancer, retinopathy of prematurity, kidney diseases, Alzheimer's, or Parkinson disease.", 0, 1, this.summary));
            children.add(new Property("assessment", "Reference(ClinicalImpression|DiagnosticReport|Observation)", "Reference to a formal record of the evidence on which the staging assessment is based.", 0, Integer.MAX_VALUE, this.assessment));
            children.add(new Property("type", "CodeableConcept", "The kind of staging, such as pathological or clinical staging.", 0, 1, this.type));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1857640538: {
                    return new Property("summary", "CodeableConcept", "A simple summary of the stage such as \"Stage 3\" or \"Early Onset\". The determination of the stage is disease-specific, such as cancer, retinopathy of prematurity, kidney diseases, Alzheimer's, or Parkinson disease.", 0, 1, this.summary);
                }
                case 2119382722: {
                    return new Property("assessment", "Reference(ClinicalImpression|DiagnosticReport|Observation)", "Reference to a formal record of the evidence on which the staging assessment is based.", 0, Integer.MAX_VALUE, this.assessment);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The kind of staging, such as pathological or clinical staging.", 0, 1, this.type);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1857640538: {
                    Base[] baseArray;
                    if (this.summary == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.summary;
                    }
                    return baseArray;
                }
                case 2119382722: {
                    return this.assessment == null ? new Base[]{} : this.assessment.toArray(new Base[this.assessment.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1857640538: {
                    this.summary = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 2119382722: {
                    this.getAssessment().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("summary")) {
                this.summary = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("assessment")) {
                this.getAssessment().add(TypeConvertor.castToReference(value));
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1857640538: {
                    return this.getSummary();
                }
                case 2119382722: {
                    return this.addAssessment();
                }
                case 3575610: {
                    return this.getType();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1857640538: {
                    return new String[]{"CodeableConcept"};
                }
                case 2119382722: {
                    return new String[]{"Reference"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("summary")) {
                this.summary = new CodeableConcept();
                return this.summary;
            }
            if (name.equals("assessment")) {
                return this.addAssessment();
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            return super.addChild(name);
        }

        @Override
        public ConditionStageComponent copy() {
            ConditionStageComponent dst = new ConditionStageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConditionStageComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.summary = this.summary == null ? null : this.summary.copy();
            if (this.assessment != null) {
                dst.assessment = new ArrayList<Reference>();
                for (Reference i : this.assessment) {
                    dst.assessment.add(i.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionStageComponent)) {
                return false;
            }
            ConditionStageComponent o = (ConditionStageComponent)other_;
            return ConditionStageComponent.compareDeep(this.summary, o.summary, true) && ConditionStageComponent.compareDeep(this.assessment, o.assessment, true) && ConditionStageComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionStageComponent)) {
                return false;
            }
            ConditionStageComponent o = (ConditionStageComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.summary, this.assessment, this.type});
        }

        @Override
        public String fhirType() {
            return "Condition.stage";
        }
    }

    @Block
    public static class ConditionParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="function", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of involvement", formalDefinition="Distinguishes the type of involvement of the actor in the activities related to the condition.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/participation-role-type")
        protected CodeableConcept function;
        @Child(name="actor", type={Practitioner.class, PractitionerRole.class, Patient.class, RelatedPerson.class, Device.class, Organization.class, CareTeam.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Who or what participated in the activities related to the condition", formalDefinition="Indicates who or what participated in the activities related to the condition.")
        protected Reference actor;
        private static final long serialVersionUID = -576943815L;

        public ConditionParticipantComponent() {
        }

        public ConditionParticipantComponent(Reference actor) {
            this.setActor(actor);
        }

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionParticipantComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public ConditionParticipantComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionParticipantComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public ConditionParticipantComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the actor in the activities related to the condition.", 0, 1, this.function));
            children.add(new Property("actor", "Reference(Practitioner|PractitionerRole|Patient|RelatedPerson|Device|Organization|CareTeam)", "Indicates who or what participated in the activities related to the condition.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the actor in the activities related to the condition.", 0, 1, this.function);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|PractitionerRole|Patient|RelatedPerson|Device|Organization|CareTeam)", "Indicates who or what participated in the activities related to the condition.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.function;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return this.getFunction();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public ConditionParticipantComponent copy() {
            ConditionParticipantComponent dst = new ConditionParticipantComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConditionParticipantComponent dst) {
            super.copyValues(dst);
            dst.function = this.function == null ? null : this.function.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionParticipantComponent)) {
                return false;
            }
            ConditionParticipantComponent o = (ConditionParticipantComponent)other_;
            return ConditionParticipantComponent.compareDeep(this.function, o.function, true) && ConditionParticipantComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionParticipantComponent)) {
                return false;
            }
            ConditionParticipantComponent o = (ConditionParticipantComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.function, this.actor});
        }

        @Override
        public String fhirType() {
            return "Condition.participant";
        }
    }
}

