/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.ParserBase;
import org.hl7.fhir.r5.elementmodel.Property;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;

public class ResourceParser
extends ParserBase {
    public ResourceParser(IWorkerContext context) {
        super(context);
    }

    @Override
    public List<ParserBase.NamedElement> parse(InputStream stream) throws IOException, FHIRFormatError, DefinitionException, FHIRException {
        throw new NotImplementedException("parse(InputStream stream)");
    }

    @Override
    public void compose(Element e, OutputStream destination, IParser.OutputStyle style, String base) throws FHIRException, IOException {
        throw new NotImplementedException("compose(Element e, OutputStream destination, OutputStyle style, String base)");
    }

    public Element parse(Resource resource) {
        StructureDefinition sd = this.context.fetchTypeDefinition(resource.fhirType());
        if (sd == null) {
            throw new FHIRException("No definition exists for " + resource.fhirType());
        }
        Property p = new Property(this.context, sd.getSnapshot().getElement().get(0), sd, new ProfileUtilities(this.context, null, null));
        String path = resource.fhirType();
        Element e = new Element(resource.fhirType(), p);
        e.setPath(path);
        e.setType(resource.fhirType());
        this.parseChildren(path, resource, e);
        e.numberChildren();
        return e;
    }

    private void parseChildren(String path, Base src, Element dst) {
        dst.setSource(src);
        List<Property> properties = dst.getProperty().getChildProperties(dst.getName(), null);
        for (org.hl7.fhir.r5.model.Property c : src.children()) {
            if (!c.hasValues()) continue;
            Property p = this.getPropertyByName(properties, c.getName());
            if (p == null) {
                throw new FHIRException("Unable to find property for " + path + "." + c.getName());
            }
            int i = 0;
            for (Base v : c.getValues()) {
                String npath = path + "." + c.getName() + (String)(p.isList() ? "[" + i + "]" : "");
                ++i;
                Object name = c.getName();
                if (((String)name).endsWith("[x]")) {
                    name = ((String)name).substring(0, ((String)name).length() - 3) + Utilities.capitalize((String)v.fhirType());
                }
                Element n = new Element((String)name, p);
                dst.getChildren().add(n);
                if (v.isPrimitive()) {
                    if (v.fhirType().equals("xhtml")) {
                        n.setXhtml(v.getXhtml());
                        try {
                            n.setValue(new XhtmlComposer(true).compose(n.getXhtml()));
                        }
                        catch (Exception exception) {}
                    } else {
                        n.setValue(v.primitiveValue());
                    }
                }
                n.setPath(npath);
                if (p.isResource()) {
                    StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(v.fhirType(), null));
                    if (sd == null) {
                        throw new FHIRFormatError(this.context.formatMessage("Contained_resource_does_not_appear_to_be_a_FHIR_resource_unknown_name_", v.fhirType()));
                    }
                    n.updateProperty(new Property(this.context, sd.getSnapshot().getElement().get(0), sd), Element.SpecialElement.fromProperty(n.getProperty()), p);
                    n.setType(v.fhirType());
                    this.parseChildren(npath, v, n);
                    continue;
                }
                this.parseChildren(npath, v, n);
            }
        }
    }

    private Property getPropertyByName(List<Property> properties, String name) {
        for (Property p : properties) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }
}

