/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.ParserBase;
import org.hl7.fhir.r5.elementmodel.Property;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonCreator;
import org.hl7.fhir.r5.formats.JsonCreatorCanonical;
import org.hl7.fhir.r5.formats.JsonCreatorDirect;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.StringPair;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonComment;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonNull;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonPrimitive;
import org.hl7.fhir.utilities.json.model.JsonProperty;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public class JsonParser
extends ParserBase {
    private JsonCreator json;
    private boolean allowComments;
    private ProfileUtilities profileUtilities;
    private Element baseElement;

    public JsonParser(IWorkerContext context, ProfileUtilities utilities) {
        super(context);
        this.profileUtilities = utilities;
    }

    public JsonParser(IWorkerContext context) {
        super(context);
        this.profileUtilities = new ProfileUtilities(this.context, null, null, new FHIRPathEngine(context));
    }

    public Element parse(String source, String type) throws Exception {
        JsonObject obj = org.hl7.fhir.utilities.json.parser.JsonParser.parseObject((String)source, (boolean)true, (boolean)true);
        String path = "/" + type;
        StructureDefinition sd = this.getDefinition(-1, -1, type);
        if (sd == null) {
            return null;
        }
        Element result = new Element(type, new Property(this.context, sd.getSnapshot().getElement().get(0), sd, this.profileUtilities));
        result.setPath(type);
        this.checkObject(obj, result, path);
        result.setType(type);
        this.parseChildren(path, obj, result, true);
        result.numberChildren();
        return result;
    }

    @Override
    public List<ParserBase.NamedElement> parse(InputStream stream) throws IOException, FHIRException {
        ArrayList<ParserBase.NamedElement> res = new ArrayList<ParserBase.NamedElement>();
        String source = TextFile.streamToString((InputStream)stream);
        JsonObject obj = null;
        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
            try {
                obj = org.hl7.fhir.utilities.json.parser.JsonParser.parseObject((String)source, (boolean)true, (boolean)true);
            }
            catch (Exception e) {
                this.logError(ValidationMessage.NO_RULE_DATE, -1, -1, this.context.formatMessage("documentmsg", new Object[0]), ValidationMessage.IssueType.INVALID, this.context.formatMessage("Error_parsing_JSON_", e.getMessage()), ValidationMessage.IssueSeverity.FATAL);
                return null;
            }
        } else {
            obj = org.hl7.fhir.utilities.json.parser.JsonParser.parseObject((String)source, (boolean)true, (boolean)true);
        }
        Element e = this.parse(obj);
        if (e != null) {
            res.add(new ParserBase.NamedElement(this, null, e));
        }
        return res;
    }

    public Element parse(JsonObject object) throws FHIRException {
        String path;
        String name;
        StructureDefinition sd = this.getLogical();
        if (sd == null) {
            JsonElement rt = object.get("resourceType");
            if (rt == null) {
                this.logError(ValidationMessage.NO_RULE_DATE, this.line((JsonElement)object), this.col((JsonElement)object), "$", ValidationMessage.IssueType.INVALID, this.context.formatMessage("Unable_to_find_resourceType_property", new Object[0]), ValidationMessage.IssueSeverity.FATAL);
                return null;
            }
            if (!rt.isJsonString()) {
                this.logError("2022-11-26", this.line((JsonElement)object), this.col((JsonElement)object), "$", ValidationMessage.IssueType.INVALID, this.context.formatMessage("RESOURCETYPE_PROPERTY_WRONG_TYPE", rt.type().toName()), ValidationMessage.IssueSeverity.FATAL);
                return null;
            }
            name = rt.asString();
            sd = this.getDefinition(this.line((JsonElement)object), this.col((JsonElement)object), name);
            if (sd == null) {
                return null;
            }
            path = name;
        } else {
            name = sd.getType();
            path = sd.getTypeTail();
        }
        this.baseElement = new Element(name, new Property(this.context, sd.getSnapshot().getElement().get(0), sd, this.profileUtilities));
        this.checkObject(object, this.baseElement, path);
        this.baseElement.markLocation(this.line((JsonElement)object), this.col((JsonElement)object));
        this.baseElement.setType(name);
        this.baseElement.setPath(this.baseElement.fhirTypeRoot());
        this.parseChildren(path, object, this.baseElement, true);
        this.baseElement.numberChildren();
        return this.baseElement;
    }

    private void checkObject(JsonObject object, Element b, String path) {
        this.checkComments((JsonElement)object, b, path);
        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING && object.getProperties().size() == 0) {
            this.logError(ValidationMessage.NO_RULE_DATE, this.line((JsonElement)object), this.col((JsonElement)object), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Object_must_have_some_content", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
        }
    }

    private void checkComments(JsonElement element, Element b, String path) throws FHIRFormatError {
        block4: {
            if (element == null || !element.hasComments()) break block4;
            if (this.allowComments) {
                for (JsonComment c : element.getComments()) {
                    b.getComments().add(c.getContent());
                }
            } else {
                for (JsonComment c : element.getComments()) {
                    this.logError("2022-11-26", c.getStart().getLine(), c.getStart().getCol(), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_COMMENTS_NOT_ALLOWED", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
                }
            }
        }
    }

    private void parseChildren(String path, JsonObject object, Element element, boolean hasResourceType) throws FHIRException {
        this.reapComments(object, element);
        List<Property> properties = element.getProperty().getChildProperties(element.getName(), null);
        HashSet<String> processed = new HashSet<String>();
        if (hasResourceType) {
            processed.add("resourceType");
        }
        HashMap<String, JsonProperty> recognisedChildren = new HashMap<String, JsonProperty>();
        HashSet<String> unique = new HashSet<String>();
        for (JsonProperty jsonProperty : object.getProperties()) {
            if (jsonProperty.isUnquotedName()) {
                this.logError("2022-11-26", this.line(jsonProperty.getValue()), this.col(jsonProperty.getValue()), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_PROPERTY_NO_QUOTES", jsonProperty.getName()), ValidationMessage.IssueSeverity.ERROR);
            }
            if (jsonProperty.isNoComma()) {
                this.logError("2022-11-26", this.line(jsonProperty.getValue()), this.col(jsonProperty.getValue()), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_COMMA_MISSING", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
            }
            if (unique.contains(jsonProperty.getName())) {
                this.logError("2022-11-26", this.line(jsonProperty.getValue()), this.col(jsonProperty.getValue()), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("DUPLICATE_JSON_PROPERTY", jsonProperty.getName()), ValidationMessage.IssueSeverity.ERROR);
                continue;
            }
            unique.add(jsonProperty.getName());
            recognisedChildren.put(jsonProperty.getName(), jsonProperty);
        }
        for (Property property : properties) {
            this.parseChildItem(path, recognisedChildren, element, processed, property);
        }
        if (this.policy != ParserBase.ValidationPolicy.NONE) {
            for (Map.Entry entry : recognisedChildren.entrySet()) {
                StructureDefinition sd;
                if (processed.contains(entry.getKey())) continue;
                StructureDefinition structureDefinition = sd = element.getProperty().isLogical() ? new ContextUtilities(this.context).fetchByJsonName((String)entry.getKey()) : null;
                if (sd != null) {
                    Property property = new Property(this.context, sd.getSnapshot().getElementFirstRep(), sd, element.getProperty().getUtils());
                    this.parseChildItem(path, recognisedChildren, element, null, property);
                    continue;
                }
                if ("fhir_comments".equals(entry.getKey()) && (VersionUtilities.isR2BVer((String)this.context.getVersion()) || VersionUtilities.isR2Ver((String)this.context.getVersion()))) {
                    if (!((JsonProperty)entry.getValue()).getValue().isJsonArray()) {
                        this.logError("2022-12-17", this.line(((JsonProperty)entry.getValue()).getValue()), this.col(((JsonProperty)entry.getValue()).getValue()), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("ILLEGAL_COMMENT_TYPE", ((JsonProperty)entry.getValue()).getValue().type().toName()), ValidationMessage.IssueSeverity.ERROR);
                        continue;
                    }
                    for (JsonElement c : ((JsonProperty)entry.getValue()).getValue().asJsonArray()) {
                        if (!c.isJsonString()) {
                            this.logError("2022-12-17", this.line(((JsonProperty)entry.getValue()).getValue()), this.col(((JsonProperty)entry.getValue()).getValue()), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("ILLEGAL_COMMENT_TYPE", c.type().toName()), ValidationMessage.IssueSeverity.ERROR);
                            continue;
                        }
                        element.getComments().add(c.asString());
                    }
                    continue;
                }
                this.logError(ValidationMessage.NO_RULE_DATE, this.line(((JsonProperty)entry.getValue()).getValue()), this.col(((JsonProperty)entry.getValue()).getValue()), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("Unrecognised_property_", entry.getKey()), ValidationMessage.IssueSeverity.ERROR);
            }
        }
        if (object.isExtraComma()) {
            this.logError("2022-11-26", object.getEnd().getLine(), object.getEnd().getCol(), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_COMMA_EXTRA", "Object"), ValidationMessage.IssueSeverity.ERROR);
        }
    }

    public void parseChildItem(String path, Map<String, JsonProperty> children, Element context, Set<String> processed, Property property) {
        if (property.isChoice() || property.getDefinition().getPath().endsWith("data[x]")) {
            if (property.isJsonPrimitiveChoice()) {
                if (children.containsKey(property.getJsonName())) {
                    String type;
                    JsonElement je = children.get(property.getJsonName()).getValue();
                    if (processed != null) {
                        processed.add(property.getJsonName());
                    }
                    if ((type = this.getTypeFromJsonType(je)) == null) {
                        this.logError(ValidationMessage.NO_RULE_DATE, this.line(je), this.col(je), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("UNRECOGNISED_PROPERTY_TYPE", this.describeType(je), property.getName(), property.typeSummary()), ValidationMessage.IssueSeverity.ERROR);
                    } else if (property.hasType(type)) {
                        Property np = new Property(property.getContext(), property.getDefinition(), property.getStructure(), property.getUtils(), type);
                        this.parseChildPrimitive(children, context, processed, np, path, property.getName(), false);
                    } else {
                        this.logError(ValidationMessage.NO_RULE_DATE, this.line(je), this.col(je), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("UNRECOGNISED_PROPERTY_TYPE_WRONG", this.describeType(je), property.getName(), type, property.typeSummary()), ValidationMessage.IssueSeverity.ERROR);
                    }
                }
            } else {
                for (ElementDefinition.TypeRefComponent type : property.getDefinition().getType()) {
                    String eName = property.getJsonName().substring(0, property.getName().length() - 3) + Utilities.capitalize((String)type.getWorkingCode());
                    if (!this.isPrimitive(type.getWorkingCode()) && children.containsKey(eName)) {
                        this.parseChildComplex(path, children, context, processed, property, eName, false);
                    } else {
                        if (!this.isPrimitive(type.getWorkingCode()) || !children.containsKey(eName) && !children.containsKey("_" + eName)) continue;
                        this.parseChildPrimitive(children, context, processed, property, path, eName, false);
                    }
                    break;
                }
            }
        } else if (property.isPrimitive(property.getType(null))) {
            this.parseChildPrimitive(children, context, processed, property, path, property.getJsonName(), property.hasJsonName());
        } else if (children.containsKey(property.getJsonName())) {
            this.parseChildComplex(path, children, context, processed, property, property.getJsonName(), property.hasJsonName());
        }
    }

    private String getTypeFromJsonType(JsonElement je) {
        if (je.isJsonPrimitive()) {
            JsonPrimitive p = je.asJsonPrimitive();
            if (p.isJsonString()) {
                return "string";
            }
            if (p.isJsonBoolean()) {
                return "boolean";
            }
            String s = p.asString();
            if (Utilities.isInteger((String)s)) {
                return "integer";
            }
            return "decimal";
        }
        return null;
    }

    private void parseChildComplex(String path, Map<String, JsonProperty> children, Element element, Set<String> processed, Property property, String name, boolean isJsonName) throws FHIRException {
        JsonElement e;
        if (processed != null) {
            processed.add(name);
        }
        String npath = path + "." + property.getName();
        String fpath = element.getPath() + "." + property.getName();
        JsonProperty p = children.get(name);
        JsonElement jsonElement = e = p == null ? null : p.getValue();
        if (property.isList() && !property.isJsonKeyArray() && e instanceof JsonArray) {
            JsonArray arr = (JsonArray)e;
            if (arr.isExtraComma()) {
                this.logError("2022-11-26", arr.getEnd().getLine(), arr.getEnd().getCol(), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_COMMA_EXTRA", "Array"), ValidationMessage.IssueSeverity.ERROR);
            }
            if (arr.size() == 0 && !property.canBeEmpty()) {
                this.logError(ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("ARRAY_CANNOT_BE_EMPTY", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
            }
            int c = 0;
            for (JsonElement am : arr) {
                this.parseChildComplexInstance(npath + "[" + c + "]", fpath + "[" + c + "]", element, property, name, am, (JsonElement)(c == 0 ? arr : null), path);
                ++c;
            }
        } else if (property.isJsonKeyArray()) {
            String code = property.getJsonKeyProperty();
            List<Property> properties = property.getChildProperties(element.getName(), null);
            if (properties.size() != 2) {
                this.logError(ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("OBJECT_CANNOT_BE_KEYED_ARRAY_CHILD_COUNT", this.propNames(properties)), ValidationMessage.IssueSeverity.ERROR);
            } else {
                Property propK = properties.get(0);
                Property propV = properties.get(1);
                if (!propK.getName().equals(code)) {
                    this.logError(ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("OBJECT_CANNOT_BE_KEYED_ARRAY_PROP_NAME", this.propNames(properties)), ValidationMessage.IssueSeverity.ERROR);
                } else if (!propK.isPrimitive()) {
                    this.logError(ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("OBJECT_CANNOT_BE_KEYED_ARRAY_PROP_TYPE", this.propNames(properties), propK.typeSummary()), ValidationMessage.IssueSeverity.ERROR);
                } else if (propV.isList()) {
                    this.logError(ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("OBJECT_CANNOT_BE_KEYED_ARRAY_NO_LIST", propV.getName()), ValidationMessage.IssueSeverity.ERROR);
                } else if (propV.isChoice() && propV.getName().endsWith("[x]")) {
                    this.logError(ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("OBJECT_CANNOT_BE_KEYED_ARRAY_NO_CHOICE", propV.getName()), ValidationMessage.IssueSeverity.ERROR);
                } else if (!(e instanceof JsonObject)) {
                    this.logError(ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be_an_object_not_", this.describe(e)), ValidationMessage.IssueSeverity.ERROR);
                } else {
                    JsonObject o = (JsonObject)e;
                    if (o.isExtraComma()) {
                        this.logError("2022-11-26", o.getEnd().getLine(), o.getEnd().getCol(), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_COMMA_EXTRA", "Object"), ValidationMessage.IssueSeverity.ERROR);
                    }
                    int i = 0;
                    HashSet<String> names = new HashSet<String>();
                    for (JsonProperty pv : o.getProperties()) {
                        if (names.contains(pv.getName())) {
                            this.logError("2022-11-26", this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("DUPLICATE_JSON_PROPERTY_KEY", pv.getName()), ValidationMessage.IssueSeverity.ERROR);
                        } else {
                            names.add(pv.getName());
                        }
                        String npathArr = path + "." + property.getName() + "[" + i + "]";
                        String fpathArr = element.getPath() + "." + property.getName() + "[" + i + "]";
                        Element n = new Element(name, property).markLocation(this.line(pv.getValue()), this.col(pv.getValue()));
                        n.setPath(fpath);
                        element.getChildren().add(n);
                        String fpathKey = fpathArr + "." + propK.getName();
                        Element nKey = new Element(code, propK).markLocation(this.line(pv.getValue()), this.col(pv.getValue()));
                        this.checkComments(pv.getValue(), n, fpathArr);
                        nKey.setPath(fpathKey);
                        n.getChildren().add(nKey);
                        nKey.setValue(pv.getName());
                        boolean ok = true;
                        Property pvl = propV;
                        if (propV.isJsonPrimitiveChoice()) {
                            ok = false;
                            String type = this.getTypeFromJsonType(pv.getValue());
                            if (type == null) {
                                this.logError(ValidationMessage.NO_RULE_DATE, this.line(pv.getValue()), this.col(pv.getValue()), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("UNRECOGNISED_PROPERTY_TYPE", this.describeType(pv.getValue()), propV.getName(), propV.typeSummary()), ValidationMessage.IssueSeverity.ERROR);
                            } else if (propV.hasType(type)) {
                                pvl = new Property(propV.getContext(), propV.getDefinition(), propV.getStructure(), propV.getUtils(), type);
                                ok = true;
                            } else {
                                this.logError(ValidationMessage.NO_RULE_DATE, this.line(pv.getValue()), this.col(pv.getValue()), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("UNRECOGNISED_PROPERTY_TYPE_WRONG", this.describeType(pv.getValue()), propV.getName(), type, propV.typeSummary()), ValidationMessage.IssueSeverity.ERROR);
                            }
                        }
                        if (ok) {
                            String npathV = npathArr + "." + pvl.getName();
                            String fpathV = fpathArr + "." + pvl.getName();
                            if (propV.isPrimitive(pvl.getType(null))) {
                                this.parseChildPrimitiveInstance(n, pvl, pvl.getName(), false, npathV, fpathV, pv.getValue(), null);
                            } else if (pv.getValue() instanceof JsonObject || pv.getValue() instanceof JsonNull) {
                                this.parseChildComplexInstance(npathV, fpathV, n, pvl, pvl.getName(), pv.getValue(), null, null);
                            } else {
                                this.logError(ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be_an_object_not_", this.describe(pv.getValue())), ValidationMessage.IssueSeverity.ERROR);
                            }
                        }
                        ++i;
                    }
                }
            }
        } else {
            if (property.isList()) {
                this.logError(ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be_an_Array_not_", this.describe(e), name, path), ValidationMessage.IssueSeverity.ERROR);
            }
            this.parseChildComplexInstance(npath, fpath, element, property, name, e, null, null);
        }
    }

    private Object propNames(List<Property> properties) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (Property p : properties) {
            b.append(p.getName());
        }
        return b.toString();
    }

    private void parseChildComplexInstance(String npath, String fpath, Element element, Property property, String name, JsonElement e, JsonElement commentContext, String commentPath) throws FHIRException {
        Element n;
        JsonObject child;
        if (property.hasTypeSpecifier()) {
            StructureDefinition sd;
            FHIRPathEngine fpe = new FHIRPathEngine(this.context);
            String type = null;
            String cond = null;
            for (StringPair sp : property.getTypeSpecifiers()) {
                if (!fpe.evaluateToBoolean(null, this.baseElement, this.baseElement, (Base)element, fpe.parse(sp.getName()))) continue;
                type = sp.getValue();
                cond = sp.getName();
                break;
            }
            if (type != null) {
                sd = this.context.fetchResource(StructureDefinition.class, type);
                if (sd == null) {
                    this.logError(ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("TYPE_SPECIFIER_ILLEGAL_TYPE", type, cond), ValidationMessage.IssueSeverity.ERROR);
                } else {
                    if (sd.getAbstract()) {
                        this.logError(ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("TYPE_SPECIFIER_ABSTRACT_TYPE", type, cond), ValidationMessage.IssueSeverity.ERROR);
                    }
                    property = property.cloneToType(sd);
                }
            } else {
                sd = this.context.fetchTypeDefinition(property.getType());
                if (sd == null) {
                    this.logError(ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("TYPE_SPECIFIER_NM_ILLEGAL_TYPE", property.getType()), ValidationMessage.IssueSeverity.ERROR);
                } else if (sd.getAbstract()) {
                    this.logError(ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("TYPE_SPECIFIER_NM_ABSTRACT_TYPE", property.getType()), ValidationMessage.IssueSeverity.ERROR);
                }
            }
        }
        if (e instanceof JsonObject) {
            child = (JsonObject)e;
            n = new Element(name, property).markLocation(this.line((JsonElement)child), this.col((JsonElement)child));
            n.setPath(fpath);
            this.checkComments(commentContext, n, commentPath);
            this.checkObject(child, n, npath);
            element.getChildren().add(n);
            if (property.isResource()) {
                this.parseResource(npath, child, n, property);
            } else {
                this.parseChildren(npath, child, n, false);
            }
        } else if (property.isNullable() && e instanceof JsonNull) {
            child = (JsonNull)e;
            n = new Element(name, property).markLocation(this.line((JsonElement)child), this.col((JsonElement)child));
            this.checkComments(commentContext, n, commentPath);
            this.checkComments((JsonElement)child, n, fpath);
            n.setPath(fpath);
            element.getChildren().add(n);
            n.setNull(true);
        } else {
            this.logError(ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be__not_", property.isList() ? "an Array" : "an Object", this.describe(e), name, npath), ValidationMessage.IssueSeverity.ERROR);
        }
    }

    private String describe(JsonElement e) {
        if (e instanceof JsonArray) {
            return "an Array";
        }
        if (e instanceof JsonObject) {
            return "an Object";
        }
        if (e instanceof JsonNull) {
            return "a Null";
        }
        if (e instanceof JsonPrimitive) {
            return "a Primitive property";
        }
        return null;
    }

    private String describeType(JsonElement e) {
        return e.type().toName();
    }

    private void parseChildPrimitive(Map<String, JsonProperty> children, Element element, Set<String> processed, Property property, String path, String name, boolean isJsonName) throws FHIRException {
        JsonProperty fork;
        String npath = path + "." + property.getName();
        String fpath = element.getPath() + "." + property.getName();
        processed.add(name);
        processed.add("_" + name);
        JsonProperty main = children.containsKey(name) ? children.get(name) : null;
        JsonProperty jsonProperty = fork = children.containsKey("_" + name) ? children.get("_" + name) : null;
        if (main != null && main.getValue().isJsonString() && main.isUnquotedValue()) {
            this.logError("2022-11-26", this.line(main.getValue()), this.col(main.getValue()), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_PROPERTY_VALUE_NO_QUOTES", main.getName(), main.getValue().asString()), ValidationMessage.IssueSeverity.ERROR);
        }
        if (main != null || fork != null) {
            if (property.isList()) {
                boolean ok = true;
                if (main != null && !(main.getValue() instanceof JsonArray)) {
                    this.logError(ValidationMessage.NO_RULE_DATE, this.line(main.getValue()), this.col(main.getValue()), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be_an_Array_not_", this.describe(main.getValue()), name, path), ValidationMessage.IssueSeverity.ERROR);
                    ok = false;
                }
                if (fork != null && !(fork.getValue() instanceof JsonArray)) {
                    this.logError(ValidationMessage.NO_RULE_DATE, this.line(fork.getValue()), this.col(fork.getValue()), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_base_property_must_be_an_Array_not_", this.describe(main.getValue()), name, path), ValidationMessage.IssueSeverity.ERROR);
                    ok = false;
                }
                if (ok) {
                    JsonArray arr1 = (JsonArray)(main == null ? null : main.getValue());
                    JsonArray arr2 = (JsonArray)(fork == null ? null : fork.getValue());
                    if (arr1 != null && arr1.isExtraComma()) {
                        this.logError("2022-11-26", arr1.getEnd().getLine(), arr1.getEnd().getCol(), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_COMMA_EXTRA", "Array"), ValidationMessage.IssueSeverity.ERROR);
                    }
                    if (arr2 != null && arr2.isExtraComma()) {
                        this.logError("2022-11-26", arr2.getEnd().getLine(), arr2.getEnd().getCol(), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_COMMA_EXTRA", "Array"), ValidationMessage.IssueSeverity.ERROR);
                    }
                    for (int i = 0; i < Math.max(this.arrC(arr1), this.arrC(arr2)); ++i) {
                        JsonElement m = this.arrI(arr1, i);
                        JsonElement f = this.arrI(arr2, i);
                        if (m != null && m.isJsonString() && arr1.isUnquoted(i)) {
                            this.logError("2022-11-26", this.line(m), this.col(m), path + "." + name + "[" + i + "]", ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_PROPERTY_VALUE_NO_QUOTES", "item", m.asString()), ValidationMessage.IssueSeverity.ERROR);
                        }
                        this.parseChildPrimitiveInstance(element, property, name, isJsonName, npath, fpath, m, f);
                    }
                }
            } else {
                this.parseChildPrimitiveInstance(element, property, name, isJsonName, npath, fpath, main == null ? null : main.getValue(), fork == null ? null : fork.getValue());
            }
        }
    }

    private JsonElement arrI(JsonArray arr, int i) {
        return arr == null || i >= arr.size() || arr.get(i) instanceof JsonNull ? null : arr.get(i);
    }

    private int arrC(JsonArray arr) {
        return arr == null ? 0 : arr.size();
    }

    private void parseChildPrimitiveInstance(Element element, Property property, String name, boolean isJsonName, String npath, String fpath, JsonElement main, JsonElement fork) throws FHIRException {
        if (!(main == null || main.isJsonBoolean() || main.isJsonNumber() || main.isJsonString())) {
            this.logError(ValidationMessage.NO_RULE_DATE, this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be_an_simple_value_not_", this.describe(main), name, npath), ValidationMessage.IssueSeverity.ERROR);
        } else if (fork != null && !(fork instanceof JsonObject)) {
            this.logError(ValidationMessage.NO_RULE_DATE, this.line(fork), this.col(fork), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be_an_object_not_", this.describe(fork), name, npath), ValidationMessage.IssueSeverity.ERROR);
        } else {
            Element n = new Element(isJsonName ? property.getName() : name, property).markLocation(this.line(main != null ? main : fork), this.col(main != null ? main : fork));
            if (main != null) {
                this.checkComments(main, n, npath);
            }
            if (fork != null) {
                this.checkComments(fork, n, npath);
            }
            n.setPath(fpath);
            element.getChildren().add(n);
            if (main != null) {
                JsonPrimitive p = (JsonPrimitive)main;
                n.setValue((String)(property.hasImpliedPrefix() ? property.getImpliedPrefix() + p.asString() : p.asString()));
                if (!n.getProperty().isChoice() && n.getType().equals("xhtml")) {
                    try {
                        XhtmlParser xhtml = new XhtmlParser();
                        n.setXhtml(xhtml.setXmlMode(true).parse(n.getValue(), null).getDocumentElement());
                        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
                            for (StringPair s : xhtml.getValidationIssues()) {
                                this.logError("2022-11-17", this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage(s.getName(), s.getValue()), ValidationMessage.IssueSeverity.ERROR);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logError(ValidationMessage.NO_RULE_DATE, this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Error_parsing_XHTML_", e.getMessage()), ValidationMessage.IssueSeverity.ERROR);
                    }
                }
                if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
                    if (Utilities.existsInList((String)n.getType(), (String[])new String[]{"boolean"})) {
                        if (!p.isJsonBoolean()) {
                            this.logError(ValidationMessage.NO_RULE_DATE, this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Error_parsing_JSON_the_primitive_value_must_be_a_boolean", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
                        }
                    } else if (Utilities.existsInList((String)n.getType(), (String[])new String[]{"integer", "unsignedInt", "positiveInt", "decimal"})) {
                        if (!p.isJsonNumber()) {
                            this.logError(ValidationMessage.NO_RULE_DATE, this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Error_parsing_JSON_the_primitive_value_must_be_a_number", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
                        }
                    } else if (!p.isJsonString()) {
                        this.logError(ValidationMessage.NO_RULE_DATE, this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Error_parsing_JSON_the_primitive_value_must_be_a_string", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
                    }
                }
            }
            if (fork != null) {
                JsonObject child = (JsonObject)fork;
                this.checkObject(child, n, npath);
                this.parseChildren(npath, child, n, false);
            }
        }
    }

    private void parseResource(String npath, JsonObject res, Element parent, Property elementProperty) throws FHIRException {
        JsonElement rt = res.get("resourceType");
        if (rt == null) {
            this.logError(ValidationMessage.NO_RULE_DATE, this.line((JsonElement)res), this.col((JsonElement)res), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Unable_to_find_resourceType_property", new Object[0]), ValidationMessage.IssueSeverity.FATAL);
        } else if (!rt.isJsonString()) {
            this.logError("2022-11-26", this.line((JsonElement)res), this.col((JsonElement)res), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("RESOURCETYPE_PROPERTY_WRONG_TYPE", rt.type().toName()), ValidationMessage.IssueSeverity.FATAL);
        } else {
            String name = rt.asString();
            StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(name, null));
            if (sd == null) {
                this.logError(ValidationMessage.NO_RULE_DATE, this.line((JsonElement)res), this.col((JsonElement)res), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Contained_resource_does_not_appear_to_be_a_FHIR_resource_unknown_name_", name), ValidationMessage.IssueSeverity.FATAL);
            } else {
                parent.updateProperty(new Property(this.context, sd.getSnapshot().getElement().get(0), sd, this.profileUtilities), Element.SpecialElement.fromProperty(parent.getProperty()), elementProperty);
                parent.setType(name);
                this.parseChildren(npath, res, parent, true);
            }
        }
        if (res.isExtraComma()) {
            this.logError("2022-11-26", res.getEnd().getLine(), res.getEnd().getCol(), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_COMMA_EXTRA", "Object"), ValidationMessage.IssueSeverity.ERROR);
        }
    }

    private void reapComments(JsonObject object, Element context) {
    }

    private int line(JsonElement e) {
        return e.getStart().getLine();
    }

    private int col(JsonElement e) {
        return e.getEnd().getCol();
    }

    protected void prop(String name, String value, String link) throws IOException {
        this.json.link(link);
        if (name != null) {
            this.json.name(name);
        }
        this.json.value(value);
    }

    protected void open(String name, String link) throws IOException {
        this.json.link(link);
        if (name != null) {
            this.json.name(name);
        }
        this.json.beginObject();
    }

    protected void close() throws IOException {
        this.json.endObject();
    }

    protected void openArray(String name, String link) throws IOException {
        this.json.link(link);
        if (name != null) {
            this.json.name(name);
        }
        this.json.beginArray();
    }

    protected void closeArray() throws IOException {
        this.json.endArray();
    }

    @Override
    public void compose(Element e, OutputStream stream, IParser.OutputStyle style, String identity) throws FHIRException, IOException {
        if (e.getPath() == null) {
            e.populatePaths(null);
        }
        OutputStreamWriter osw = new OutputStreamWriter(stream, "UTF-8");
        this.json = style == IParser.OutputStyle.CANONICAL ? new JsonCreatorCanonical(osw) : (style == IParser.OutputStyle.PRETTY ? new JsonCreatorDirect(osw, true, this.allowComments) : new JsonCreatorDirect(osw, false, this.allowComments));
        this.checkComposeComments(e);
        this.json.beginObject();
        this.prop("resourceType", e.getType(), null);
        HashSet<String> done = new HashSet<String>();
        for (Element child : e.getChildren()) {
            this.compose(e.getName(), e, done, child);
        }
        this.json.endObject();
        this.json.finish();
        osw.flush();
    }

    private void checkComposeComments(Element e) {
        for (String s : e.getComments()) {
            this.json.comment(s);
        }
    }

    public void compose(Element e, JsonCreator json) throws Exception {
        if (e.getPath() == null) {
            e.populatePaths(null);
        }
        this.json = json;
        this.checkComposeComments(e);
        json.beginObject();
        this.prop("resourceType", e.getType(), this.linkResolver == null ? null : this.linkResolver.resolveProperty(e.getProperty()));
        HashSet<String> done = new HashSet<String>();
        for (Element child : e.getChildren()) {
            this.compose(e.getName(), e, done, child);
        }
        json.endObject();
        json.finish();
    }

    private void compose(String path, Element e, Set<String> done, Element child) throws IOException {
        this.checkComposeComments(child);
        if (this.wantCompose(path, child)) {
            boolean isList;
            boolean bl = isList = child.hasElementProperty() ? child.getElementProperty().isList() : child.getProperty().isList();
            if (!isList) {
                this.compose(path, child);
            } else if (!done.contains(child.getName())) {
                done.add(child.getName());
                List<Element> list = e.getChildrenByName(child.getName());
                this.composeList(path, list);
            }
        }
    }

    private void composeList(String path, List<Element> list) throws IOException {
        Object name = list.get(0).getName();
        boolean complex = true;
        if (list.get(0).isPrimitive()) {
            boolean prim = false;
            complex = false;
            for (Element item : list) {
                if (item.hasValue()) {
                    prim = true;
                }
                if (!item.hasChildren()) continue;
                complex = true;
            }
            if (prim) {
                this.openArray((String)name, this.linkResolver == null ? null : this.linkResolver.resolveProperty(list.get(0).getProperty()));
                for (Element item : list) {
                    if (item.hasValue()) {
                        this.primitiveValue(null, item);
                        continue;
                    }
                    this.json.nullValue();
                }
                this.closeArray();
            }
            name = "_" + (String)name;
        }
        if (complex) {
            this.openArray((String)name, this.linkResolver == null ? null : this.linkResolver.resolveProperty(list.get(0).getProperty()));
            for (Element item : list) {
                if (item.hasChildren()) {
                    this.open(null, null);
                    if (item.getProperty().isResource()) {
                        this.prop("resourceType", item.getType(), this.linkResolver == null ? null : this.linkResolver.resolveType(item.getType()));
                    }
                    HashSet<String> done = new HashSet<String>();
                    for (Element child : item.getChildren()) {
                        this.compose(path + "." + (String)name + "[]", item, done, child);
                    }
                    this.close();
                    continue;
                }
                this.json.nullValue();
            }
            this.closeArray();
        }
    }

    private void primitiveValue(String name, Element item) throws IOException {
        String type;
        if (name != null) {
            if (this.linkResolver != null) {
                this.json.link(this.linkResolver.resolveProperty(item.getProperty()));
            }
            this.json.name(name);
        }
        if (Utilities.existsInList((String)(type = item.getType()), (String[])new String[]{"boolean"})) {
            this.json.value(item.getValue().trim().equals("true") ? new Boolean(true) : new Boolean(false));
        } else if (Utilities.existsInList((String)type, (String[])new String[]{"integer", "unsignedInt", "positiveInt"})) {
            this.json.value(new Integer(item.getValue()));
        } else if (Utilities.existsInList((String)type, (String[])new String[]{"decimal"})) {
            try {
                this.json.value(new BigDecimal(item.getValue()));
            }
            catch (Exception e) {
                throw new NumberFormatException(this.context.formatMessage("error_writing_number__to_JSON", item.getValue()));
            }
        } else {
            this.json.value(item.getValue());
        }
    }

    private void compose(String path, Element element) throws IOException {
        Object name = element.getName();
        if (element.isPrimitive() || this.isPrimitive(element.getType())) {
            if (element.hasValue()) {
                this.primitiveValue((String)name, element);
            }
            name = "_" + (String)name;
            if (element.getType().equals("xhtml")) {
                this.json.anchor("end-xhtml");
            }
        }
        if (element.hasChildren()) {
            this.open((String)name, this.linkResolver == null ? null : this.linkResolver.resolveProperty(element.getProperty()));
            if (element.getProperty().isResource()) {
                this.prop("resourceType", element.getType(), this.linkResolver == null ? null : this.linkResolver.resolveType(element.getType()));
            }
            HashSet<String> done = new HashSet<String>();
            for (Element child : element.getChildren()) {
                this.compose(path + "." + element.getName(), element, done, child);
            }
            this.close();
        }
    }

    public boolean isAllowComments() {
        return this.allowComments;
    }

    public JsonParser setAllowComments(boolean allowComments) {
        this.allowComments = allowComments;
        return this;
    }
}

