/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.conformance.profile;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.ElementRedirection;
import org.hl7.fhir.r5.conformance.profile.BaseTypeSlice;
import org.hl7.fhir.r5.conformance.profile.ProfileKnowledgeProvider;
import org.hl7.fhir.r5.conformance.profile.ProfilePathProcessor;
import org.hl7.fhir.r5.conformance.profile.TypeSlice;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.ObjectConverter;
import org.hl7.fhir.r5.elementmodel.Property;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ExpressionNode;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.TranslatingUtilities;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.r5.utils.formats.CSVWriter;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xml.SchematronWriter;

public class ProfileUtilities
extends TranslatingUtilities {
    private static final List<String> INHERITED_ED_URLS = Arrays.asList("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-binding-style", "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-extension-style");
    private static final int MAX_RECURSION_LIMIT = 10;
    public static final String UD_BASE_MODEL = "base.model";
    public static final String UD_BASE_PATH = "base.path";
    public static final String UD_DERIVATION_EQUALS = "derivation.equals";
    public static final String UD_DERIVATION_POINTER = "derived.pointer";
    public static final String UD_IS_DERIVED = "derived.fact";
    public static final String UD_GENERATED_IN_SNAPSHOT = "profileutilities.snapshot.processed";
    private static final boolean COPY_BINDING_EXTENSIONS = false;
    private static final boolean DONT_DO_THIS = false;
    private boolean debug;
    private final IWorkerContext context;
    private FHIRPathEngine fpe;
    private List<ValidationMessage> messages;
    private List<String> snapshotStack = new ArrayList<String>();
    private ProfileKnowledgeProvider pkp;
    private boolean exception;
    private ValidationOptions terminologyServiceOptions = new ValidationOptions();
    private boolean newSlicingProcessing;
    private String defWebRoot;
    private boolean autoFixSliceNames;
    private XVerExtensionManager xver;
    private boolean wantFixDifferentialFirstElementType;
    private Set<String> masterSourceFileNames;
    private Map<ElementDefinition, SourcedChildDefinitions> childMapCache = new HashMap<ElementDefinition, SourcedChildDefinitions>();
    public static final String UD_ERROR_STATUS = "error-status";
    public static final int STATUS_OK = 0;
    public static final int STATUS_HINT = 1;
    public static final int STATUS_WARNING = 2;
    public static final int STATUS_ERROR = 3;
    public static final int STATUS_FATAL = 4;
    private static final String ROW_COLOR_ERROR = "#ffcccc";
    private static final String ROW_COLOR_FATAL = "#ff9999";
    private static final String ROW_COLOR_WARNING = "#ffebcc";
    private static final String ROW_COLOR_HINT = "#ebf5ff";
    private static final String ROW_COLOR_NOT_MUST_SUPPORT = "#d6eaf8";

    public IWorkerContext getContext() {
        return this.context;
    }

    public ProfileUtilities(IWorkerContext context, List<ValidationMessage> messages, ProfileKnowledgeProvider pkp, FHIRPathEngine fpe) {
        this.context = context;
        this.messages = messages;
        this.pkp = pkp;
        this.fpe = fpe;
        if (context != null && this.fpe == null) {
            this.fpe = new FHIRPathEngine(context, this);
        }
    }

    public ProfileUtilities(IWorkerContext context, List<ValidationMessage> messages, ProfileKnowledgeProvider pkp) {
        this.context = context;
        this.messages = messages;
        this.pkp = pkp;
        if (context != null) {
            this.fpe = new FHIRPathEngine(context, this);
        }
    }

    public boolean isWantFixDifferentialFirstElementType() {
        return this.wantFixDifferentialFirstElementType;
    }

    public void setWantFixDifferentialFirstElementType(boolean wantFixDifferentialFirstElementType) {
        this.wantFixDifferentialFirstElementType = wantFixDifferentialFirstElementType;
    }

    public boolean isAutoFixSliceNames() {
        return this.autoFixSliceNames;
    }

    public ProfileUtilities setAutoFixSliceNames(boolean autoFixSliceNames) {
        this.autoFixSliceNames = autoFixSliceNames;
        return this;
    }

    public SourcedChildDefinitions getChildMap(StructureDefinition profile, ElementDefinition element) throws DefinitionException {
        ElementDefinition e;
        if (this.childMapCache.containsKey(element)) {
            return this.childMapCache.get(element);
        }
        StructureDefinition src = profile;
        if (element.getContentReference() != null) {
            List<ElementDefinition> list = null;
            String id = null;
            if (element.getContentReference().startsWith("#")) {
                id = element.getContentReference().substring(1);
                list = profile.getSnapshot().getElement();
            } else if (element.getContentReference().contains("#")) {
                String ref = element.getContentReference();
                StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, ref.substring(0, ref.indexOf("#")), profile);
                if (sd == null) {
                    throw new DefinitionException("unable to process contentReference '" + element.getContentReference() + "' on element '" + element.getId() + "'");
                }
                src = sd;
                list = sd.getSnapshot().getElement();
                id = ref.substring(ref.indexOf("#") + 1);
            } else {
                throw new DefinitionException("unable to process contentReference '" + element.getContentReference() + "' on element '" + element.getId() + "'");
            }
            for (ElementDefinition e2 : list) {
                if (!id.equals(e2.getId())) continue;
                return this.getChildMap(profile, e2);
            }
            throw new DefinitionException(this.context.formatMessage("Unable_to_resolve_name_reference__at_path_", element.getContentReference(), element.getPath()));
        }
        ArrayList<ElementDefinition> res = new ArrayList<ElementDefinition>();
        List<ElementDefinition> elements = profile.getSnapshot().getElement();
        String path = element.getPath();
        for (int index = elements.indexOf(element) + 1; index < elements.size() && (e = elements.get(index)).getPath().startsWith(path + "."); ++index) {
            if (e.getPath().substring(path.length() + 1).contains(".")) continue;
            res.add(e);
        }
        SourcedChildDefinitions result = new SourcedChildDefinitions(src, res);
        this.childMapCache.put(element, result);
        return result;
    }

    public List<ElementDefinition> getSliceList(StructureDefinition profile, ElementDefinition element) throws DefinitionException {
        ElementDefinition e;
        if (!element.hasSlicing()) {
            throw new Error(this.context.formatMessage("getSliceList_should_only_be_called_when_the_element_has_slicing", new Object[0]));
        }
        ArrayList<ElementDefinition> res = new ArrayList<ElementDefinition>();
        List<ElementDefinition> elements = profile.getSnapshot().getElement();
        String path = element.getPath();
        for (int index = elements.indexOf(element) + 1; index < elements.size() && ((e = elements.get(index)).getPath().startsWith(path + ".") || e.getPath().equals(path)); ++index) {
            if (!e.getPath().equals(element.getPath())) continue;
            res.add(e);
        }
        return res;
    }

    public List<ElementDefinition> getChildList(StructureDefinition profile, String path, String id) {
        return this.getChildList(profile, path, id, false);
    }

    public List<ElementDefinition> getChildList(StructureDefinition profile, String path, String id, boolean diff) {
        return this.getChildList(profile, path, id, diff, false);
    }

    public List<ElementDefinition> getChildList(StructureDefinition profile, String path, String id, boolean diff, boolean refs) {
        boolean capturing;
        ArrayList<ElementDefinition> res = new ArrayList<ElementDefinition>();
        boolean bl = capturing = id == null;
        if (id == null && !path.contains(".")) {
            capturing = true;
        }
        List<ElementDefinition> list = diff ? profile.getDifferential().getElement() : profile.getSnapshot().getElement();
        for (ElementDefinition e : list) {
            String tail;
            if (e == null) {
                throw new Error(this.context.formatMessage("element__null_", profile.getUrl()));
            }
            if (e.getId() == null) {
                throw new Error(this.context.formatMessage("element_id__null__on_", e.toString(), profile.getUrl()));
            }
            if (!capturing && id != null && e.getId().equals(id)) {
                capturing = true;
            }
            if (capturing && e.hasId() && id != null && !e.getId().equals(id) && e.getPath().equals(path)) break;
            if (!capturing) continue;
            String p = e.getPath();
            if (refs && !Utilities.noString((String)e.getContentReference()) && path.startsWith(p)) {
                if (path.length() > p.length()) {
                    return this.getChildList(profile, e.getContentReference() + "." + path.substring(p.length() + 1), null, diff);
                }
                if (e.getContentReference().startsWith("#")) {
                    return this.getChildList(profile, e.getContentReference().substring(1), null, diff);
                }
                if (e.getContentReference().contains("#")) {
                    String url = e.getContentReference().substring(0, e.getContentReference().indexOf("#"));
                    StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, url, profile);
                    if (sd == null) {
                        throw new DefinitionException("Unable to find Structure " + url);
                    }
                    return this.getChildList(sd, e.getContentReference().substring(e.getContentReference().indexOf("#") + 1), null, diff);
                }
                return this.getChildList(profile, e.getContentReference(), null, diff);
            }
            if (!p.startsWith(path + ".") || p.equals(path) || (tail = p.substring(path.length() + 1)).contains(".")) continue;
            res.add(e);
        }
        return res;
    }

    public List<ElementDefinition> getChildList(StructureDefinition structure, ElementDefinition element, boolean diff, boolean refs) {
        return this.getChildList(structure, element.getPath(), element.getId(), diff, refs);
    }

    public List<ElementDefinition> getChildList(StructureDefinition structure, ElementDefinition element, boolean diff) {
        return this.getChildList(structure, element.getPath(), element.getId(), diff);
    }

    public List<ElementDefinition> getChildList(StructureDefinition structure, ElementDefinition element) {
        if (element.hasContentReference()) {
            ElementDefinition target = element;
            for (ElementDefinition t : structure.getSnapshot().getElement()) {
                if (!t.getId().equals(element.getContentReference().substring(1))) continue;
                target = t;
            }
            return this.getChildList(structure, target.getPath(), target.getId(), false);
        }
        return this.getChildList(structure, element.getPath(), element.getId(), false);
    }

    private void updateMaps(StructureDefinition base, StructureDefinition derived) throws DefinitionException {
        if (base == null) {
            throw new DefinitionException(this.context.formatMessage("no_base_profile_provided", new Object[0]));
        }
        if (derived == null) {
            throw new DefinitionException(this.context.formatMessage("no_derived_structure_provided", new Object[0]));
        }
        for (StructureDefinition.StructureDefinitionMappingComponent baseMap : base.getMapping()) {
            boolean found = false;
            for (StructureDefinition.StructureDefinitionMappingComponent derivedMap : derived.getMapping()) {
                if (derivedMap.getUri() == null || !derivedMap.getUri().equals(baseMap.getUri())) continue;
                found = true;
                break;
            }
            if (found) continue;
            derived.getMapping().add(baseMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSnapshot(StructureDefinition base, StructureDefinition derived, String url, String webUrl, String profileName) throws DefinitionException, FHIRException {
        if (base == null) {
            throw new DefinitionException(this.context.formatMessage("no_base_profile_provided", new Object[0]));
        }
        if (derived == null) {
            throw new DefinitionException(this.context.formatMessage("no_derived_structure_provided", new Object[0]));
        }
        this.checkNotGenerating(base, "Base for generating a snapshot for the profile " + derived.getUrl());
        this.checkNotGenerating(derived, "Focus for generating a snapshot");
        if (!base.hasType()) {
            throw new DefinitionException(this.context.formatMessage("Base_profile__has_no_type", base.getUrl()));
        }
        if (!derived.hasType()) {
            throw new DefinitionException(this.context.formatMessage("Derived_profile__has_no_type", derived.getUrl()));
        }
        if (!derived.hasDerivation()) {
            throw new DefinitionException(this.context.formatMessage("Derived_profile__has_no_derivation_value_and_so_cant_be_processed", derived.getUrl()));
        }
        if (!base.getType().equals(derived.getType()) && derived.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            throw new DefinitionException(this.context.formatMessage("Base__Derived_profiles_have_different_types____vs___", base.getUrl(), base.getType(), derived.getUrl(), derived.getType()));
        }
        this.fixTypeOfResourceId(base);
        if (this.snapshotStack.contains(derived.getUrl())) {
            throw new DefinitionException(this.context.formatMessage("Circular_snapshot_references_detected_cannot_generate_snapshot_stack__", this.snapshotStack.toString()));
        }
        derived.setUserData("profileutils.snapshot.generating", true);
        this.snapshotStack.add(derived.getUrl());
        try {
            if (!Utilities.noString((String)webUrl) && !((String)webUrl).endsWith("/")) {
                webUrl = (String)webUrl + "/";
            }
            if (this.defWebRoot == null) {
                this.defWebRoot = webUrl;
            }
            derived.setSnapshot(new StructureDefinition.StructureDefinitionSnapshotComponent());
            try {
                this.checkDifferential(derived.getDifferential().getElement(), derived.getTypeName(), derived.getUrl());
                this.checkDifferentialBaseType(derived);
                this.copyInheritedExtensions(base, derived);
                for (ElementDefinition e : derived.getDifferential().getElement()) {
                    e.clearUserData(UD_GENERATED_IN_SNAPSHOT);
                }
                StructureDefinition.StructureDefinitionDifferentialComponent diff = this.cloneDiff(derived.getDifferential());
                StructureDefinition.StructureDefinitionSnapshotComponent baseSnapshot = base.getSnapshot();
                if (derived.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION) {
                    Iterator<ElementDefinition> derivedType = derived.getTypeName();
                    baseSnapshot = this.cloneSnapshot(baseSnapshot, base.getTypeName(), (String)((Object)derivedType));
                }
                ProfilePathProcessor.processPaths(this, base, derived, url, (String)webUrl, diff, baseSnapshot);
                this.checkGroupConstraints(derived);
                if (derived.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION) {
                    for (ElementDefinition e : diff.getElement()) {
                        if (e.hasUserData(UD_GENERATED_IN_SNAPSHOT) || !e.getPath().contains(".")) continue;
                        ElementDefinition outcome = this.updateURLs(url, (String)webUrl, e.copy());
                        e.setUserData(UD_GENERATED_IN_SNAPSHOT, outcome);
                        derived.getSnapshot().addElement(outcome);
                        if (!this.walksInto(diff.getElement(), e)) continue;
                        if (e.getType().size() > 1) {
                            throw new DefinitionException("Unsupported scenario: specialization walks into multiple types at " + e.getId());
                        }
                        this.addInheritedElementsForSpecialization(derived.getSnapshot(), outcome, outcome.getTypeFirstRep().getWorkingCode(), outcome.getPath(), url, (String)webUrl);
                    }
                }
                if (derived.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL && !derived.getSnapshot().getElementFirstRep().getType().isEmpty()) {
                    throw new Error(this.context.formatMessage("type_on_first_snapshot_element_for__in__from_", derived.getSnapshot().getElementFirstRep().getPath(), derived.getUrl(), base.getUrl()));
                }
                this.updateMaps(base, derived);
                this.setIds(derived, false);
                if (this.debug) {
                    System.out.println("Differential: ");
                    for (ElementDefinition ed : derived.getDifferential().getElement()) {
                        System.out.println("  " + ed.getId() + " : " + this.typeSummaryWithProfile(ed) + "[" + ed.getMin() + ".." + ed.getMax() + "]" + this.sliceSummary(ed) + "  " + this.constraintSummary(ed));
                    }
                    System.out.println("Snapshot: ");
                    for (ElementDefinition ed : derived.getSnapshot().getElement()) {
                        System.out.println("  " + ed.getId() + " : " + this.typeSummaryWithProfile(ed) + "[" + ed.getMin() + ".." + ed.getMax() + "]" + this.sliceSummary(ed) + "  " + this.constraintSummary(ed));
                    }
                }
                CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
                int ce = 0;
                for (ElementDefinition elementDefinition : diff.getElement()) {
                    if (!elementDefinition.hasUserData("diff-source")) {
                        throw new Error(this.context.formatMessage("Unxpected_internal_condition__no_source_on_diff_element", new Object[0]));
                    }
                    if (elementDefinition.hasUserData(UD_DERIVATION_EQUALS)) {
                        ((Base)elementDefinition.getUserData("diff-source")).setUserData(UD_DERIVATION_EQUALS, elementDefinition.getUserData(UD_DERIVATION_EQUALS));
                    }
                    if (elementDefinition.hasUserData(UD_DERIVATION_POINTER)) {
                        ((Base)elementDefinition.getUserData("diff-source")).setUserData(UD_DERIVATION_POINTER, elementDefinition.getUserData(UD_DERIVATION_POINTER));
                    }
                    if (elementDefinition.hasUserData(UD_GENERATED_IN_SNAPSHOT)) continue;
                    b.append(elementDefinition.hasId() ? "id: " + elementDefinition.getId() : "path: " + elementDefinition.getPath());
                    ++ce;
                    if (!elementDefinition.hasId()) continue;
                    String msg = "No match found in the generated snapshot: check that the path and definitions are legal in the differential (including order)";
                    this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.VALUE, url + "#" + elementDefinition.getId(), msg, ValidationMessage.IssueSeverity.ERROR));
                }
                if (!Utilities.noString((String)b.toString())) {
                    String msg = "The profile " + derived.getUrl() + " has " + ce + " " + Utilities.pluralize((String)"element", (int)ce) + " in the differential (" + b.toString() + ") that don't have a matching element in the snapshot: check that the path and definitions are legal in the differential (including order)";
                    if (this.debug) {
                        System.out.println("Error in snapshot generation: " + msg);
                        if (!this.debug) {
                            System.out.println("Differential: ");
                            for (ElementDefinition ed : derived.getDifferential().getElement()) {
                                System.out.println("  " + ed.getId() + " = " + ed.getPath() + " : " + this.typeSummaryWithProfile(ed) + "[" + ed.getMin() + ".." + ed.getMax() + "]" + this.sliceSummary(ed) + "  " + this.constraintSummary(ed));
                            }
                            System.out.println("Snapshot: ");
                            for (ElementDefinition ed : derived.getSnapshot().getElement()) {
                                System.out.println("  " + ed.getId() + " = " + ed.getPath() + " : " + this.typeSummaryWithProfile(ed) + "[" + ed.getMin() + ".." + ed.getMax() + "]" + this.sliceSummary(ed) + "  " + this.constraintSummary(ed));
                            }
                        }
                    }
                    if (this.exception) {
                        throw new DefinitionException(msg);
                    }
                    this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.VALUE, url, msg, ValidationMessage.IssueSeverity.ERROR));
                }
                for (ElementDefinition elementDefinition : derived.getSnapshot().getElement()) {
                    for (ElementDefinition.ElementDefinitionMappingComponent mm : elementDefinition.getMapping()) {
                        if (!mm.hasMap()) continue;
                        mm.setMap(mm.getMap().trim());
                    }
                    for (ElementDefinition.ElementDefinitionConstraintComponent s : elementDefinition.getConstraint()) {
                        String ref;
                        if (!s.hasSource() || Utilities.isAbsoluteUrl((String)(ref = s.getSource()))) continue;
                        if (ref.contains(".")) {
                            s.setSource("http://hl7.org/fhir/StructureDefinition/" + ref.substring(0, ref.indexOf(".")) + "#" + ref);
                            continue;
                        }
                        s.setSource("http://hl7.org/fhir/StructureDefinition/" + ref);
                    }
                }
                if (derived.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION) {
                    for (ElementDefinition elementDefinition : derived.getSnapshot().getElement()) {
                        if (elementDefinition.hasBase()) continue;
                        elementDefinition.getBase().setPath(elementDefinition.getPath()).setMin(elementDefinition.getMin()).setMax(elementDefinition.getMax());
                    }
                }
                for (ElementDefinition elementDefinition : derived.getSnapshot().getElement()) {
                    for (ElementDefinition.TypeRefComponent t : elementDefinition.getType()) {
                        for (UriType uriType : t.getProfile()) {
                            boolean ok;
                            StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, (String)uriType.getValue(), derived);
                            if (sd == null && this.xver != null && this.xver.matchingUrl((String)uriType.getValue()) && this.xver.status((String)uriType.getValue()) == XVerExtensionManager.XVerExtensionStatus.Valid) {
                                sd = this.xver.makeDefinition((String)uriType.getValue());
                            }
                            if (sd == null) {
                                if (this.messages == null) continue;
                                this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.VALUE, url + "#" + elementDefinition.getId(), "The type of profile " + (String)uriType.getValue() + " cannot be checked as the profile is not known", ValidationMessage.IssueSeverity.WARNING));
                                continue;
                            }
                            String wt = t.getWorkingCode();
                            if (elementDefinition.getPath().equals("Bundle.entry.response.outcome")) {
                                wt = "OperationOutcome";
                            }
                            if (sd.getType().equals(wt) || (ok = this.isCompatibleType(wt, sd))) continue;
                            String smsg = "The profile " + (String)uriType.getValue() + " has type " + sd.getType() + " which is not consistent with the stated type " + wt;
                            if (this.exception) {
                                throw new DefinitionException(smsg);
                            }
                            this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.VALUE, url + "#" + elementDefinition.getId(), smsg, ValidationMessage.IssueSeverity.ERROR));
                        }
                    }
                }
            }
            catch (Exception e) {
                derived.setSnapshot(null);
                derived.clearUserData("profileutils.snapshot.generating");
                throw e;
            }
        }
        finally {
            derived.clearUserData("profileutils.snapshot.generating");
            this.snapshotStack.remove(derived.getUrl());
        }
    }

    private void copyInheritedExtensions(StructureDefinition base, StructureDefinition derived) {
        for (Extension ext : base.getExtension()) {
            if (!Utilities.existsInList((String)ext.getUrl(), INHERITED_ED_URLS) || derived.hasExtension(ext.getUrl())) continue;
            derived.getExtension().add(ext.copy());
        }
    }

    private void addInheritedElementsForSpecialization(StructureDefinition.StructureDefinitionSnapshotComponent snapshot, ElementDefinition focus, String type, String path, String url, String weburl) {
        StructureDefinition sd = this.context.fetchTypeDefinition(type);
        if (sd != null) {
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                if (ed.getPath().contains(".")) {
                    ElementDefinition outcome = this.updateURLs(url, weburl, ed.copy());
                    outcome.setPath(outcome.getPath().replace(sd.getTypeName(), path));
                    snapshot.getElement().add(outcome);
                    continue;
                }
                focus.getConstraint().addAll(ed.getConstraint());
                for (Extension ext : ed.getExtension()) {
                    if (!Utilities.existsInList((String)ext.getUrl(), INHERITED_ED_URLS) || focus.hasExtension(ext.getUrl())) continue;
                    focus.getExtension().add(ext.copy());
                }
            }
        }
    }

    private boolean walksInto(List<ElementDefinition> list, ElementDefinition ed) {
        int i = list.indexOf(ed);
        return i < list.size() - 1 && list.get(i + 1).getPath().startsWith(ed.getPath() + ".");
    }

    private void fixTypeOfResourceId(StructureDefinition base) {
        if (base.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE && (base.getFhirVersion() == null || VersionUtilities.isR4Plus((String)base.getFhirVersion().toCode()))) {
            this.fixTypeOfResourceId(base.getSnapshot().getElement());
            this.fixTypeOfResourceId(base.getDifferential().getElement());
        }
    }

    private void fixTypeOfResourceId(List<ElementDefinition> list) {
        for (ElementDefinition ed : list) {
            if (!ed.hasBase() || !ed.getBase().getPath().equals("Resource.id")) continue;
            for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
                tr.setCode("http://hl7.org/fhirpath/System.String");
                tr.removeExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type");
                ToolingExtensions.addUrlExtension(tr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type", "id");
            }
        }
    }

    private void checkDifferentialBaseType(StructureDefinition derived) throws Error {
        if (derived.hasDifferential() && !derived.getDifferential().getElementFirstRep().getPath().contains(".") && !derived.getDifferential().getElementFirstRep().getType().isEmpty()) {
            if (this.wantFixDifferentialFirstElementType && this.typeMatchesAncestor(derived.getDifferential().getElementFirstRep().getType(), derived.getBaseDefinition(), derived)) {
                derived.getDifferential().getElementFirstRep().getType().clear();
            } else if (derived.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL) {
                throw new Error(this.context.formatMessage("type_on_first_differential_element", new Object[0]));
            }
        }
    }

    private boolean typeMatchesAncestor(List<ElementDefinition.TypeRefComponent> type, String baseDefinition, Resource src) {
        StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, baseDefinition, src);
        return sd != null && type.size() == 1 && sd.getType().equals(type.get(0).getCode());
    }

    private void checkGroupConstraints(StructureDefinition derived) {
        ArrayList<ElementDefinition> toRemove = new ArrayList<ElementDefinition>();
        for (ElementDefinition element : derived.getSnapshot().getElement()) {
            if (toRemove.contains(element) || element.hasSlicing() || "0".equals(element.getMax())) continue;
            this.checkForChildrenInGroup(derived, toRemove, element);
        }
        derived.getSnapshot().getElement().removeAll(toRemove);
    }

    private void checkForChildrenInGroup(StructureDefinition derived, List<ElementDefinition> toRemove, ElementDefinition element) throws Error {
        List<ElementDefinition> children = this.getChildren(derived, element);
        List<ElementChoiceGroup> groups = this.readChoices(element, children);
        for (ElementChoiceGroup group : groups) {
            String name;
            String mandated = null;
            HashSet<String> names = new HashSet<String>();
            for (ElementDefinition ed : children) {
                name = this.tail(ed.getPath());
                if (names.contains(name)) {
                    throw new Error("huh?");
                }
                names.add(name);
                if (!group.getElements().contains(name) || ed.getMin() != 1) continue;
                if (mandated == null) {
                    mandated = name;
                    continue;
                }
                throw new Error("Error: there are two mandatory elements in " + derived.getUrl() + " when there can only be one: " + mandated + " and " + name);
            }
            if (mandated == null) continue;
            for (ElementDefinition ed : children) {
                name = this.tail(ed.getPath());
                if (!group.getElements().contains(name) || mandated.equals(name)) continue;
                ed.setMax("0");
                this.addAllChildren(derived, ed, toRemove);
            }
        }
    }

    private List<ElementDefinition> getChildren(StructureDefinition derived, ElementDefinition element) {
        ElementDefinition e;
        String p;
        List<ElementDefinition> elements = derived.getSnapshot().getElement();
        String path = element.getPath() + ".";
        ArrayList<ElementDefinition> list = new ArrayList<ElementDefinition>();
        for (int index = elements.indexOf(element) + 1; index < elements.size() && (p = (e = elements.get(index)).getPath()).startsWith(path) && !e.hasSliceName(); ++index) {
            if (p.substring(path.length()).contains(".")) continue;
            list.add(e);
        }
        return list;
    }

    private void addAllChildren(StructureDefinition derived, ElementDefinition element, List<ElementDefinition> toRemove) {
        List<ElementDefinition> children = this.getChildList(derived, element);
        for (ElementDefinition child : children) {
            toRemove.add(child);
            this.addAllChildren(derived, child, toRemove);
        }
    }

    private void checkDifferential(List<ElementDefinition> elements, String type, String url) {
        boolean first = true;
        for (ElementDefinition ed : elements) {
            String[] pl;
            if (!ed.hasPath()) {
                throw new FHIRException(this.context.formatMessage("No_path_on_element_in_differential_in_", url));
            }
            String p = ed.getPath();
            if (p == null) {
                throw new FHIRException(this.context.formatMessage("No_path_value_on_element_in_differential_in_", url));
            }
            if (!(first && type.equals(p) || p.startsWith(type + "."))) {
                throw new FHIRException(this.context.formatMessage("Illegal_path__in_differential_in__must_start_with_", p, url, type, first ? " (or be '" + type + "')" : ""));
            }
            if (!p.contains(".")) continue;
            for (String pp : pl = p.split("\\.")) {
                if (pp.length() < 1) {
                    throw new FHIRException(this.context.formatMessage("Illegal_path__in_differential_in__name_portion_mising_", p, url));
                }
                if (pp.length() > 64) {
                    throw new FHIRException(this.context.formatMessage("Illegal_path__in_differential_in__name_portion_exceeds_64_chars_in_length", p, url));
                }
                for (char ch : pp.toCharArray()) {
                    if (Character.isWhitespace(ch)) {
                        throw new FHIRException(this.context.formatMessage("Illegal_path__in_differential_in__no_unicode_whitespace", p, url));
                    }
                    if (Utilities.existsInList((int)ch, (int[])new int[]{44, 58, 59, 39, 34, 47, 124, 63, 33, 64, 35, 36, 37, 94, 38, 42, 40, 41, 123, 125})) {
                        throw new FHIRException(this.context.formatMessage("Illegal_path__in_differential_in__illegal_character_", p, url, Character.valueOf(ch)));
                    }
                    if (ch >= ' ' && ch <= 'z') continue;
                    throw new FHIRException(this.context.formatMessage("Illegal_path__in_differential_in__illegal_character_", p, url, Character.valueOf(ch)));
                }
                if (!pp.contains("[") && !pp.contains("]") || pp.endsWith("[x]") && !pp.substring(0, pp.length() - 3).contains("[") && !pp.substring(0, pp.length() - 3).contains("]")) continue;
                throw new FHIRException(this.context.formatMessage("Illegal_path__in_differential_in__illegal_characters_", p, url));
            }
        }
    }

    private boolean isCompatibleType(String base, StructureDefinition sdt) {
        StructureDefinition sdb = this.context.fetchTypeDefinition(base);
        if (sdb.getType().equals(sdt.getType())) {
            return true;
        }
        StructureDefinition sd = this.context.fetchTypeDefinition(sdt.getType());
        while (sd != null) {
            if (sd.getType().equals(sdb.getType())) {
                return true;
            }
            if (sd.getUrl().equals(sdb.getUrl())) {
                return true;
            }
            sd = this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition(), sd);
        }
        return false;
    }

    private StructureDefinition.StructureDefinitionDifferentialComponent cloneDiff(StructureDefinition.StructureDefinitionDifferentialComponent source) {
        StructureDefinition.StructureDefinitionDifferentialComponent diff = new StructureDefinition.StructureDefinitionDifferentialComponent();
        for (ElementDefinition sed : source.getElement()) {
            ElementDefinition ted = sed.copy();
            diff.getElement().add(ted);
            ted.setUserData("diff-source", sed);
        }
        return diff;
    }

    private StructureDefinition.StructureDefinitionSnapshotComponent cloneSnapshot(StructureDefinition.StructureDefinitionSnapshotComponent source, String baseType, String derivedType) {
        StructureDefinition.StructureDefinitionSnapshotComponent diff = new StructureDefinition.StructureDefinitionSnapshotComponent();
        for (ElementDefinition sed : source.getElement()) {
            ElementDefinition ted = sed.copy();
            ted.setId(ted.getId().replaceFirst(baseType, derivedType));
            ted.setPath(ted.getPath().replaceFirst(baseType, derivedType));
            diff.getElement().add(ted);
        }
        return diff;
    }

    private String constraintSummary(ElementDefinition ed) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (ed.hasPattern()) {
            b.append("pattern=" + ed.getPattern().fhirType());
        }
        if (ed.hasFixed()) {
            b.append("fixed=" + ed.getFixed().fhirType());
        }
        if (ed.hasConstraint()) {
            b.append("constraints=" + ed.getConstraint().size());
        }
        return b.toString();
    }

    private String sliceSummary(ElementDefinition ed) {
        if (!ed.hasSlicing() && !ed.hasSliceName()) {
            return "";
        }
        if (ed.hasSliceName()) {
            return " (slicename = " + ed.getSliceName() + ")";
        }
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d : ed.getSlicing().getDiscriminator()) {
            if (first) {
                first = false;
            } else {
                b.append("|");
            }
            b.append(d.getPath());
        }
        return " (slicing by " + b.toString() + ")";
    }

    private String typeSummaryWithProfile(ElementDefinition ed) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
            if (first) {
                first = false;
            } else {
                b.append("|");
            }
            b.append(tr.getWorkingCode());
            if (!tr.hasProfile()) continue;
            b.append("(");
            b.append(tr.getProfile());
            b.append(")");
        }
        return b.toString();
    }

    protected ElementDefinition getById(List<ElementDefinition> list, String baseId) {
        for (ElementDefinition t : list) {
            if (!baseId.equals(t.getId())) continue;
            return t;
        }
        return null;
    }

    protected void updateConstraintSources(ElementDefinition ed, String url) {
        for (ElementDefinition.ElementDefinitionConstraintComponent c : ed.getConstraint()) {
            if (c.hasSource()) continue;
            c.setSource(url);
        }
    }

    protected Set<String> getListOfTypes(ElementDefinition e) {
        HashSet<String> result = new HashSet<String>();
        for (ElementDefinition.TypeRefComponent t : e.getType()) {
            result.add(t.getCode());
        }
        return result;
    }

    StructureDefinition getTypeForElement(StructureDefinition.StructureDefinitionDifferentialComponent differential, int diffCursor, String profileName, List<ElementDefinition> diffMatches, ElementDefinition outcome, String webUrl, Resource srcSD) {
        StructureDefinition dt;
        if (outcome.getType().size() == 0) {
            if (outcome.hasContentReference()) {
                throw new Error(this.context.formatMessage("UNABLE_TO_RESOLVE_CONTENT_REFERENCE_IN_THIS_CONTEXT", outcome.getContentReference(), outcome.getId(), outcome.getPath()));
            }
            throw new DefinitionException(this.context.formatMessage("_has_no_children__and_no_types_in_profile_", diffMatches.get(0).getPath(), differential.getElement().get(diffCursor).getPath(), profileName));
        }
        if (outcome.getType().size() > 1) {
            for (ElementDefinition.TypeRefComponent t : outcome.getType()) {
                if (t.getWorkingCode().equals("Reference")) continue;
                throw new DefinitionException(this.context.formatMessage("_has_children__and_multiple_types__in_profile_", diffMatches.get(0).getPath(), differential.getElement().get(diffCursor).getPath(), ProfileUtilities.typeCode(outcome.getType()), profileName));
            }
        }
        if ((dt = this.getProfileForDataType(outcome.getType().get(0), webUrl, srcSD)) == null) {
            throw new DefinitionException(this.context.formatMessage("Unknown_type__at_", outcome.getType().get(0), diffMatches.get(0).getPath()));
        }
        return dt;
    }

    protected String sliceNames(List<ElementDefinition> diffMatches) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ElementDefinition ed : diffMatches) {
            if (!ed.hasSliceName()) continue;
            b.append(ed.getSliceName());
        }
        return b.toString();
    }

    protected boolean isMatchingType(StructureDefinition sd, List<ElementDefinition.TypeRefComponent> types, String inner) {
        while (sd != null) {
            for (ElementDefinition.TypeRefComponent tr : types) {
                if (sd.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition") && sd.getType().equals(tr.getCode())) {
                    return true;
                }
                if (inner == null && sd.getUrl().equals(tr.getCode())) {
                    return true;
                }
                if (inner == null) continue;
                ElementDefinition ed = null;
                for (ElementDefinition t : sd.getSnapshot().getElement()) {
                    if (!inner.equals(t.getId())) continue;
                    ed = t;
                }
                if (ed == null) continue;
                return this.isMatchingType(ed.getType(), types);
            }
            sd = this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition(), sd);
        }
        return false;
    }

    private boolean isMatchingType(List<ElementDefinition.TypeRefComponent> test, List<ElementDefinition.TypeRefComponent> desired) {
        for (ElementDefinition.TypeRefComponent t : test) {
            for (ElementDefinition.TypeRefComponent d : desired) {
                if (!t.getCode().equals(d.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isValidType(ElementDefinition.TypeRefComponent t, ElementDefinition base) {
        for (ElementDefinition.TypeRefComponent tr : base.getType()) {
            if (tr.getCode().equals(t.getCode())) {
                return true;
            }
            if (!tr.getWorkingCode().equals(t.getCode())) continue;
            System.out.println("Type error: use of a simple type \"" + t.getCode() + "\" wrongly constraining " + base.getPath());
            return true;
        }
        return false;
    }

    protected boolean isGenerating(StructureDefinition sd) {
        return sd.hasUserData("profileutils.snapshot.generating");
    }

    protected void checkNotGenerating(StructureDefinition sd, String role) {
        if (sd.hasUserData("profileutils.snapshot.generating")) {
            throw new FHIRException(this.context.formatMessage("Attempt_to_use_a_snapshot_on_profile__as__before_it_is_generated", sd.getUrl(), role));
        }
    }

    protected boolean isBaseResource(List<ElementDefinition.TypeRefComponent> types) {
        if (types.isEmpty()) {
            return false;
        }
        for (ElementDefinition.TypeRefComponent type : types) {
            String t = type.getWorkingCode();
            if (!"Resource".equals(t)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String determineFixedType(List<ElementDefinition> diffMatches, String fixedType, int i) {
        if (diffMatches.get(i).getType().size() == 0 && diffMatches.get(i).hasSliceName()) {
            String n = this.tail(diffMatches.get(i).getPath()).replace("[x]", "");
            String t = diffMatches.get(i).getSliceName().substring(n.length());
            if (this.isDataType(t)) {
                return t;
            }
            if (!this.isPrimitive(Utilities.uncapitalize((String)t))) throw new FHIRException(this.context.formatMessage("Unexpected_condition_in_differential_typeslicetypelistsize__10_and_implicit_slice_name_does_not_contain_a_valid_type__at_", t, diffMatches.get(i).getPath(), diffMatches.get(i).getSliceName()));
            return Utilities.uncapitalize((String)t);
        }
        if (diffMatches.get(i).getType().size() != 1) throw new FHIRException(this.context.formatMessage("Unexpected_condition_in_differential_typeslicetypelistsize__1_at_", diffMatches.get(i).getPath(), diffMatches.get(i).getSliceName()));
        return diffMatches.get(i).getType().get(0).getCode();
    }

    protected BaseTypeSlice chooseMatchingBaseSlice(List<BaseTypeSlice> baseSlices, String type) {
        for (BaseTypeSlice bs : baseSlices) {
            if (!bs.getType().equals(type)) continue;
            return bs;
        }
        return null;
    }

    protected List<BaseTypeSlice> findBaseSlices(StructureDefinition.StructureDefinitionSnapshotComponent list, int start) {
        int i;
        ArrayList<BaseTypeSlice> res = new ArrayList<BaseTypeSlice>();
        ElementDefinition base = list.getElement().get(start);
        for (i = start + 1; i < list.getElement().size() && list.getElement().get(i).getPath().startsWith(base.getPath() + "."); ++i) {
        }
        while (i < list.getElement().size() && list.getElement().get(i).getPath().equals(base.getPath()) && list.getElement().get(i).hasSliceName()) {
            int s = i++;
            while (i < list.getElement().size() && list.getElement().get(i).getPath().startsWith(base.getPath() + ".")) {
                ++i;
            }
            res.add(new BaseTypeSlice(list.getElement().get(s), list.getElement().get(s).getTypeFirstRep().getCode(), s, i - 1));
        }
        return res;
    }

    protected String getWebUrl(StructureDefinition dt, String webUrl) {
        if (dt.hasUserData("path")) {
            String url = dt.getUserString("path");
            int i = url.lastIndexOf("/");
            if (i < 1) {
                return this.defWebRoot;
            }
            return url.substring(0, i + 1);
        }
        return webUrl;
    }

    protected void removeStatusExtensions(ElementDefinition outcome) {
        outcome.removeExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm");
        outcome.removeExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm-support");
        outcome.removeExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom");
        outcome.removeExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status");
        outcome.removeExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-normative-version");
        outcome.removeExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-wg");
        outcome.removeExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm-support");
        outcome.removeExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom");
    }

    protected String descED(List<ElementDefinition> list, int index) {
        return index >= 0 && index < list.size() ? list.get(index).present() : "X";
    }

    protected String rootName(String cpath) {
        String t = this.tail(cpath);
        return t.replace("[x]", "");
    }

    protected String determineTypeSlicePath(String path, String cpath) {
        String headP = path.substring(0, path.lastIndexOf("."));
        String tailC = cpath.substring(cpath.lastIndexOf(".") + 1);
        return headP + "." + tailC;
    }

    protected boolean isImplicitSlicing(ElementDefinition ed, String path) {
        if (ed == null || ed.getPath() == null || path == null) {
            return false;
        }
        if (path.equals(ed.getPath())) {
            return false;
        }
        boolean ok = path.endsWith("[x]") && ed.getPath().startsWith(path.substring(0, path.length() - 3));
        return ok;
    }

    protected boolean diffsConstrainTypes(List<ElementDefinition> diffMatches, String cPath, List<TypeSlice> typeList) {
        String p = diffMatches.get(0).getPath();
        if (!p.endsWith("[x]") && !cPath.endsWith("[x]")) {
            return false;
        }
        typeList.clear();
        String rn = this.tail(cPath);
        rn = rn.substring(0, rn.length() - 3);
        for (int i = 0; i < diffMatches.size(); ++i) {
            ElementDefinition ed = diffMatches.get(i);
            String n = this.tail(ed.getPath());
            if (!n.startsWith(rn)) {
                return false;
            }
            String s = n.substring(rn.length());
            if (s.contains(".")) continue;
            if (ed.hasSliceName() && ed.getType().size() == 1) {
                typeList.add(new TypeSlice(ed, ed.getTypeFirstRep().getWorkingCode()));
                continue;
            }
            if (ed.hasSliceName() && ed.getType().size() == 0) {
                if (this.isDataType(s)) {
                    typeList.add(new TypeSlice(ed, s));
                    continue;
                }
                if (this.isPrimitive(Utilities.uncapitalize((String)s))) {
                    typeList.add(new TypeSlice(ed, Utilities.uncapitalize((String)s)));
                    continue;
                }
                String tn = ed.getSliceName().substring(n.length());
                if (this.isDataType(tn)) {
                    typeList.add(new TypeSlice(ed, tn));
                    continue;
                }
                if (!this.isPrimitive(Utilities.uncapitalize((String)tn))) continue;
                typeList.add(new TypeSlice(ed, Utilities.uncapitalize((String)tn)));
                continue;
            }
            if (!ed.hasSliceName() && !s.equals("[x]")) {
                if (this.isDataType(s)) {
                    typeList.add(new TypeSlice(ed, s));
                    continue;
                }
                if (this.isConstrainedDataType(s)) {
                    typeList.add(new TypeSlice(ed, this.baseType(s)));
                    continue;
                }
                if (!this.isPrimitive(Utilities.uncapitalize((String)s))) continue;
                typeList.add(new TypeSlice(ed, Utilities.uncapitalize((String)s)));
                continue;
            }
            if (ed.hasSliceName() || !s.equals("[x]")) continue;
            typeList.add(new TypeSlice(ed, null));
        }
        return true;
    }

    protected List<ElementRedirection> redirectorStack(List<ElementRedirection> redirector, ElementDefinition outcome, String path) {
        ArrayList<ElementRedirection> result = new ArrayList<ElementRedirection>();
        result.addAll(redirector);
        result.add(new ElementRedirection(outcome, path));
        return result;
    }

    protected List<ElementDefinition.TypeRefComponent> getByTypeName(List<ElementDefinition.TypeRefComponent> type, String t) {
        ArrayList<ElementDefinition.TypeRefComponent> res = new ArrayList<ElementDefinition.TypeRefComponent>();
        for (ElementDefinition.TypeRefComponent tr : type) {
            if (!t.equals(tr.getWorkingCode())) continue;
            res.add(tr);
        }
        return res;
    }

    protected void replaceFromContentReference(ElementDefinition outcome, ElementDefinition tgt) {
        outcome.setContentReference(null);
        outcome.getType().clear();
        outcome.getType().addAll(tgt.getType());
    }

    protected boolean baseWalksInto(List<ElementDefinition> elements, int cursor) {
        if (cursor >= elements.size()) {
            return false;
        }
        String path = elements.get(cursor).getPath();
        String prevPath = elements.get(cursor - 1).getPath();
        return path.startsWith(prevPath + ".");
    }

    protected ElementDefinition fillOutFromBase(ElementDefinition profile, ElementDefinition usage) throws FHIRFormatError {
        ElementDefinition res = profile.copy();
        if (!res.hasSliceName()) {
            res.setSliceName(usage.getSliceName());
        }
        if (!res.hasLabel()) {
            res.setLabel(usage.getLabel());
        }
        for (Coding coding : usage.getCode()) {
            if (res.hasCode(coding)) continue;
            res.addCode(coding);
        }
        if (!res.hasDefinition()) {
            res.setDefinition(usage.getDefinition());
        }
        if (!res.hasShort() && usage.hasShort()) {
            res.setShort(usage.getShort());
        }
        if (!res.hasComment() && usage.hasComment()) {
            res.setComment(usage.getComment());
        }
        if (!res.hasRequirements() && usage.hasRequirements()) {
            res.setRequirements(usage.getRequirements());
        }
        for (StringType stringType : usage.getAlias()) {
            if (res.hasAlias((String)stringType.getValue())) continue;
            res.addAlias((String)stringType.getValue());
        }
        if (!res.hasMin() && usage.hasMin()) {
            res.setMin(usage.getMin());
        }
        if (!res.hasMax() && usage.hasMax()) {
            res.setMax(usage.getMax());
        }
        if (!res.hasFixed() && usage.hasFixed()) {
            res.setFixed(usage.getFixed());
        }
        if (!res.hasPattern() && usage.hasPattern()) {
            res.setPattern(usage.getPattern());
        }
        if (!res.hasExample() && usage.hasExample()) {
            res.setExample(usage.getExample());
        }
        if (!res.hasMinValue() && usage.hasMinValue()) {
            res.setMinValue(usage.getMinValue());
        }
        if (!res.hasMaxValue() && usage.hasMaxValue()) {
            res.setMaxValue(usage.getMaxValue());
        }
        if (!res.hasMaxLength() && usage.hasMaxLength()) {
            res.setMaxLength(usage.getMaxLength());
        }
        if (!res.hasMustSupport() && usage.hasMustSupport()) {
            res.setMustSupport(usage.getMustSupport());
        }
        if (!res.hasMustHaveValue() && usage.hasMustHaveValue()) {
            res.setMustHaveValue(usage.getMustHaveValue());
        }
        if (!res.hasBinding() && usage.hasBinding()) {
            res.setBinding(usage.getBinding().copy());
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : usage.getConstraint()) {
            if (res.hasConstraint(elementDefinitionConstraintComponent.getKey())) continue;
            res.addConstraint(elementDefinitionConstraintComponent);
        }
        for (Extension extension : usage.getExtension()) {
            if (res.hasExtension(extension.getUrl())) continue;
            res.addExtension(extension.copy());
        }
        return res;
    }

    protected boolean checkExtensionDoco(ElementDefinition base) {
        boolean isExtension;
        boolean bl = isExtension = !(!base.getPath().equals("Extension") && !base.getPath().endsWith(".extension") && !base.getPath().endsWith(".modifierExtension") || base.hasBase() && "II.extension".equals(base.getBase().getPath()));
        if (isExtension) {
            base.setDefinition("An Extension");
            base.setShort("Extension");
            base.setCommentElement(null);
            base.setRequirementsElement(null);
            base.getAlias().clear();
            base.getMapping().clear();
        }
        return isExtension;
    }

    protected String pathTail(List<ElementDefinition> diffMatches, int i) {
        ElementDefinition d = diffMatches.get(i);
        String s = d.getPath().contains(".") ? d.getPath().substring(d.getPath().lastIndexOf(".") + 1) : d.getPath();
        return "." + s + (String)(d.hasType() && d.getType().get(0).hasProfile() ? "[" + d.getType().get(0).getProfile() + "]" : "");
    }

    protected void markDerived(ElementDefinition outcome) {
        for (ElementDefinition.ElementDefinitionConstraintComponent inv : outcome.getConstraint()) {
            inv.setUserData(UD_IS_DERIVED, true);
        }
    }

    static String summarizeSlicing(ElementDefinition.ElementDefinitionSlicingComponent slice) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d : slice.getDiscriminator()) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(d.getType().toCode() + ":" + d.getPath());
        }
        b.append(" (");
        if (slice.hasOrdered()) {
            b.append(slice.getOrdered() ? "ordered" : "unordered");
        }
        b.append("/");
        if (slice.hasRules()) {
            b.append(slice.getRules().toCode());
        }
        b.append(")");
        if (slice.hasDescription()) {
            b.append(" \"");
            b.append(slice.getDescription());
            b.append("\"");
        }
        return b.toString();
    }

    protected void updateFromBase(ElementDefinition derived, ElementDefinition base, String baseProfileUrl) {
        derived.setUserData(UD_BASE_MODEL, baseProfileUrl);
        derived.setUserData(UD_BASE_PATH, base.getPath());
        if (base.hasBase()) {
            if (!derived.hasBase()) {
                derived.setBase(new ElementDefinition.ElementDefinitionBaseComponent());
            }
            derived.getBase().setPath(base.getBase().getPath());
            derived.getBase().setMin(base.getBase().getMin());
            derived.getBase().setMax(base.getBase().getMax());
        } else {
            if (!derived.hasBase()) {
                derived.setBase(new ElementDefinition.ElementDefinitionBaseComponent());
            }
            derived.getBase().setPath(base.getPath());
            derived.getBase().setMin(base.getMin());
            derived.getBase().setMax(base.getMax());
        }
    }

    protected boolean pathStartsWith(String p1, String p2) {
        return p1.startsWith(p2) || p2.endsWith("[x].") && p1.startsWith(p2.substring(0, p2.length() - 4));
    }

    private boolean pathMatches(String p1, String p2) {
        return p1.equals(p2) || p2.endsWith("[x]") && p1.startsWith(p2.substring(0, p2.length() - 3)) && !p1.substring(p2.length() - 3).contains(".");
    }

    protected String fixedPathSource(String contextPath, String pathSimple, List<ElementRedirection> redirector) {
        if (contextPath == null) {
            return pathSimple;
        }
        if (redirector != null && redirector.size() > 0) {
            String ptail = null;
            ptail = contextPath.length() >= pathSimple.length() ? pathSimple.substring(pathSimple.indexOf(".") + 1) : pathSimple.substring(contextPath.length() + 1);
            return redirector.get(redirector.size() - 1).getPath() + "." + ptail;
        }
        String ptail = pathSimple.substring(pathSimple.indexOf(".") + 1);
        return contextPath + "." + ptail;
    }

    protected String fixedPathDest(String contextPath, String pathSimple, List<ElementRedirection> redirector, String redirectSource) {
        Object s;
        if (contextPath == null) {
            s = pathSimple;
        } else if (redirector != null && redirector.size() > 0) {
            String ptail = null;
            ptail = redirectSource.length() >= pathSimple.length() ? pathSimple.substring(pathSimple.indexOf(".") + 1) : pathSimple.substring(redirectSource.length() + 1);
            s = contextPath + "." + ptail;
        } else {
            String ptail = pathSimple.substring(pathSimple.indexOf(".") + 1);
            s = contextPath + "." + ptail;
        }
        return s;
    }

    protected StructureDefinition getProfileForDataType(ElementDefinition.TypeRefComponent type, String webUrl, Resource src) {
        StructureDefinition sd = null;
        if (type.hasProfile()) {
            sd = this.context.fetchResource(StructureDefinition.class, (String)type.getProfile().get(0).getValue(), src);
            if (sd == null && this.xver != null && this.xver.matchingUrl((String)type.getProfile().get(0).getValue()) && this.xver.status((String)type.getProfile().get(0).getValue()) == XVerExtensionManager.XVerExtensionStatus.Valid) {
                sd = this.xver.makeDefinition((String)type.getProfile().get(0).getValue());
                this.generateSnapshot(this.context.fetchTypeDefinition("Extension"), sd, sd.getUrl(), webUrl, sd.getName());
            }
            if (sd == null && this.debug) {
                System.out.println("Failed to find referenced profile: " + type.getProfile());
            }
        }
        if (sd == null) {
            sd = this.context.fetchTypeDefinition(type.getWorkingCode());
        }
        if (sd == null) {
            System.out.println("XX: failed to find profle for type: " + type.getWorkingCode());
        }
        return sd;
    }

    protected StructureDefinition getProfileForDataType(String type) {
        StructureDefinition sd = this.context.fetchTypeDefinition(type);
        if (sd == null) {
            System.out.println("XX: failed to find profle for type: " + type);
        }
        return sd;
    }

    static String typeCode(List<ElementDefinition.TypeRefComponent> types) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (ElementDefinition.TypeRefComponent type : types) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(type.getWorkingCode());
            if (type.hasTargetProfile()) {
                b.append("{" + type.getTargetProfile() + "}");
                continue;
            }
            if (!type.hasProfile()) continue;
            b.append("{" + type.getProfile() + "}");
        }
        return b.toString();
    }

    protected boolean isDataType(List<ElementDefinition.TypeRefComponent> types) {
        if (types.isEmpty()) {
            return false;
        }
        for (ElementDefinition.TypeRefComponent type : types) {
            String t = type.getWorkingCode();
            if (this.isDataType(t) || this.isPrimitive(t)) continue;
            return false;
        }
        return true;
    }

    public ElementDefinition updateURLs(String url, String webUrl, ElementDefinition element) {
        if (element != null) {
            ElementDefinition defn = element;
            if (defn.hasBinding() && defn.getBinding().hasValueSet() && defn.getBinding().getValueSet().startsWith("#")) {
                defn.getBinding().setValueSet(url + defn.getBinding().getValueSet());
            }
            for (ElementDefinition.TypeRefComponent t : defn.getType()) {
                for (UriType uriType : t.getProfile()) {
                    if (!((String)uriType.getValue()).startsWith("#")) continue;
                    uriType.setValue(url + t.getProfile());
                }
                for (UriType uriType : t.getTargetProfile()) {
                    if (!((String)uriType.getValue()).startsWith("#")) continue;
                    uriType.setValue(url + t.getTargetProfile());
                }
            }
            if (webUrl != null) {
                if (element.hasDefinition()) {
                    element.setDefinition(ProfileUtilities.processRelativeUrls(element.getDefinition(), webUrl, this.context.getSpecUrl(), this.context.getResourceNames(), this.masterSourceFileNames, null, false));
                }
                if (element.hasComment()) {
                    element.setComment(ProfileUtilities.processRelativeUrls(element.getComment(), webUrl, this.context.getSpecUrl(), this.context.getResourceNames(), this.masterSourceFileNames, null, false));
                }
                if (element.hasRequirements()) {
                    element.setRequirements(ProfileUtilities.processRelativeUrls(element.getRequirements(), webUrl, this.context.getSpecUrl(), this.context.getResourceNames(), this.masterSourceFileNames, null, false));
                }
                if (element.hasMeaningWhenMissing()) {
                    element.setMeaningWhenMissing(ProfileUtilities.processRelativeUrls(element.getMeaningWhenMissing(), webUrl, this.context.getSpecUrl(), this.context.getResourceNames(), this.masterSourceFileNames, null, false));
                }
            }
        }
        return element;
    }

    public static String processRelativeUrls(String markdown, String webUrl, String basePath, List<String> resourceNames, Set<String> baseFilenames, Set<String> localFilenames, boolean processRelatives) {
        if (markdown == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < markdown.length(); ++i) {
            if (i < markdown.length() - 3 && markdown.substring(i, i + 2).equals("](")) {
                int j;
                for (j = i + 2; j < markdown.length() && markdown.charAt(j) != ')'; ++j) {
                }
                if (j < markdown.length()) {
                    String url = markdown.substring(i + 2, j);
                    if (!Utilities.isAbsoluteUrl((String)url) && !url.startsWith("..")) {
                        if (ProfileUtilities.isLikelySourceURLReference(url, resourceNames, baseFilenames, localFilenames)) {
                            b.append("](");
                            b.append(basePath);
                            ++i;
                            continue;
                        }
                        b.append("](");
                        if (processRelatives && webUrl != null && !ProfileUtilities.issLocalFileName(url, localFilenames)) {
                            b.append(webUrl);
                        }
                        ++i;
                        continue;
                    }
                    b.append(markdown.charAt(i));
                    continue;
                }
                b.append(markdown.charAt(i));
                continue;
            }
            b.append(markdown.charAt(i));
        }
        return b.toString();
    }

    private static boolean issLocalFileName(String url, Set<String> localFilenames) {
        if (localFilenames != null) {
            for (String n : localFilenames) {
                if (!url.startsWith(n.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isLikelySourceURLReference(String url, List<String> resourceNames, Set<String> baseFilenames, Set<String> localFilenames) {
        if (resourceNames != null) {
            for (String n : resourceNames) {
                if (n != null && url.startsWith(n.toLowerCase() + ".html")) {
                    return true;
                }
                if (n == null || !url.startsWith(n.toLowerCase() + "-definitions.html")) continue;
                return true;
            }
        }
        if (localFilenames != null) {
            for (String n : localFilenames) {
                if (n == null || !url.startsWith(n.toLowerCase())) continue;
                return false;
            }
        }
        if (baseFilenames != null) {
            for (String n : baseFilenames) {
                if (n == null || !url.startsWith(n.toLowerCase())) continue;
                return true;
            }
        }
        return url.startsWith("extensibility.html") || url.startsWith("terminologies.html") || url.startsWith("observation.html") || url.startsWith("codesystem.html") || url.startsWith("fhirpath.html") || url.startsWith("datatypes.html") || url.startsWith("operations.html") || url.startsWith("resource.html") || url.startsWith("elementdefinition.html") || url.startsWith("element-definitions.html") || url.startsWith("snomedct.html") || url.startsWith("loinc.html") || url.startsWith("http.html") || url.startsWith("references") || url.startsWith("narrative.html") || url.startsWith("search.html") || url.startsWith("patient-operation-match.html") || url.startsWith("extension-") && url.contains(".html") || url.startsWith("resource-definitions.html");
    }

    protected List<ElementDefinition> getSiblings(List<ElementDefinition> list, ElementDefinition current) {
        ArrayList<ElementDefinition> result = new ArrayList<ElementDefinition>();
        String path = current.getPath();
        for (int cursor = list.indexOf(current) + 1; cursor < list.size() && list.get(cursor).getPath().length() >= path.length(); ++cursor) {
            if (!this.pathMatches(list.get(cursor).getPath(), path)) continue;
            result.add(list.get(cursor));
        }
        return result;
    }

    protected void updateFromSlicing(ElementDefinition.ElementDefinitionSlicingComponent dst, ElementDefinition.ElementDefinitionSlicingComponent src) {
        if (src.hasOrderedElement()) {
            dst.setOrderedElement(src.getOrderedElement().copy());
        }
        if (src.hasDiscriminator()) {
            for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent s : src.getDiscriminator()) {
                boolean found = false;
                for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d : dst.getDiscriminator()) {
                    if (!this.matches(d, s)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                dst.getDiscriminator().add(s);
            }
        }
        if (src.hasRulesElement()) {
            dst.setRulesElement((Enumeration<ElementDefinition.SlicingRules>)src.getRulesElement().copy());
        }
    }

    protected boolean orderMatches(BooleanType diff, BooleanType base) {
        return diff == null || base == null || diff.getValue() == base.getValue();
    }

    protected boolean discriminatorMatches(List<ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent> diff, List<ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent> base) {
        if (diff.isEmpty() || base.isEmpty()) {
            return true;
        }
        if (diff.size() != base.size()) {
            return false;
        }
        for (int i = 0; i < diff.size(); ++i) {
            if (this.matches(diff.get(i), base.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean matches(ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent c1, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent c2) {
        return c1.getType().equals((Object)c2.getType()) && c1.getPath().equals(c2.getPath());
    }

    protected boolean ruleMatches(ElementDefinition.SlicingRules diff, ElementDefinition.SlicingRules base) {
        return diff == null || base == null || diff == base || base == ElementDefinition.SlicingRules.OPEN || diff == ElementDefinition.SlicingRules.OPENATEND && base == ElementDefinition.SlicingRules.CLOSED;
    }

    protected boolean isSlicedToOneOnly(ElementDefinition e) {
        return e.hasSlicing() && e.hasMaxElement() && e.getMax().equals("1");
    }

    protected ElementDefinition.ElementDefinitionSlicingComponent makeExtensionSlicing() {
        ElementDefinition.ElementDefinitionSlicingComponent slice = new ElementDefinition.ElementDefinitionSlicingComponent();
        slice.addDiscriminator().setPath("url").setType(ElementDefinition.DiscriminatorType.VALUE);
        slice.setOrdered(false);
        slice.setRules(ElementDefinition.SlicingRules.OPEN);
        return slice;
    }

    protected boolean isExtension(ElementDefinition currentBase) {
        return currentBase.getPath().endsWith(".extension") || currentBase.getPath().endsWith(".modifierExtension");
    }

    boolean hasInnerDiffMatches(StructureDefinition.StructureDefinitionDifferentialComponent context, String path, int start, int end, List<ElementDefinition> base, boolean allowSlices) throws DefinitionException {
        end = Math.min(context.getElement().size(), end);
        for (int i = start = Math.max(0, start); i <= end; ++i) {
            ElementDefinition ed = context.getElement().get(i);
            String statedPath = ed.getPath();
            if (!allowSlices && statedPath.equals(path) && ed.hasSliceName()) {
                return false;
            }
            if (statedPath.startsWith(path + ".")) {
                return true;
            }
            if (path.endsWith("[x]") && statedPath.startsWith(path.substring(0, path.length() - 3))) {
                return true;
            }
            if (i != start && !allowSlices && !statedPath.startsWith(path + ".")) {
                return false;
            }
            if (i == start || !allowSlices || statedPath.startsWith(path)) continue;
            return false;
        }
        return false;
    }

    protected List<ElementDefinition> getDiffMatches(StructureDefinition.StructureDefinitionDifferentialComponent context, String path, int start, int end, String profileName) throws DefinitionException {
        ArrayList<ElementDefinition> result = new ArrayList<ElementDefinition>();
        String[] p = path.split("\\.");
        for (int i = start; i <= end; ++i) {
            String statedPath = context.getElement().get(i).getPath();
            String[] sp = statedPath.split("\\.");
            boolean ok = sp.length == p.length;
            for (int j = 0; j < p.length; ++j) {
                ok = ok && sp.length > j && (p[j].equals(sp[j]) || this.isSameBase(p[j], sp[j]));
            }
            if (!ok) continue;
            result.add(context.getElement().get(i));
        }
        return result;
    }

    private boolean isSameBase(String p, String sp) {
        return p.endsWith("[x]") && sp.startsWith(p.substring(0, p.length() - 3)) || sp.endsWith("[x]") && p.startsWith(sp.substring(0, sp.length() - 3));
    }

    protected int findEndOfElement(StructureDefinition.StructureDefinitionDifferentialComponent context, int cursor) {
        int result;
        if (cursor >= context.getElement().size()) {
            return result;
        }
        String path = context.getElement().get(cursor).getPath() + ".";
        for (result = cursor; result < context.getElement().size() - 1 && context.getElement().get(result + 1).getPath().startsWith(path); ++result) {
        }
        return result;
    }

    protected int findEndOfElement(StructureDefinition.StructureDefinitionSnapshotComponent context, int cursor) {
        int result;
        String path = context.getElement().get(cursor).getPath() + ".";
        for (result = cursor; result < context.getElement().size() - 1 && context.getElement().get(result + 1).getPath().startsWith(path); ++result) {
        }
        return result;
    }

    protected boolean unbounded(ElementDefinition definition) {
        StringType max = definition.getMaxElement();
        if (max == null) {
            return false;
        }
        if (((String)max.getValue()).equals("1")) {
            return false;
        }
        return !((String)max.getValue()).equals("0");
    }

    protected void updateFromDefinition(ElementDefinition dest, ElementDefinition source, String pn, boolean trimDifferential, String purl, StructureDefinition srcSD, StructureDefinition derivedSrc) throws DefinitionException, FHIRException {
        source.setUserData(UD_GENERATED_IN_SNAPSHOT, dest);
        ElementDefinition base = dest;
        ElementDefinition derived = source;
        derived.setUserData(UD_DERIVATION_POINTER, base);
        boolean isExtension = this.checkExtensionDoco(base);
        for (Extension ext : source.getExtension()) {
            if (!Utilities.existsInList((String)ext.getUrl(), INHERITED_ED_URLS) || dest.hasExtension(ext.getUrl())) continue;
            dest.getExtension().add(ext.copy());
        }
        StructureDefinition profile = null;
        if (base.hasSliceName()) {
            StructureDefinition structureDefinition = profile = base.getType().size() == 1 && base.getTypeFirstRep().hasProfile() ? this.context.fetchResource(StructureDefinition.class, (String)base.getTypeFirstRep().getProfile().get(0).getValue(), srcSD) : null;
        }
        if (profile == null) {
            StructureDefinition structureDefinition = profile = source.getType().size() == 1 && source.getTypeFirstRep().hasProfile() ? this.context.fetchResource(StructureDefinition.class, (String)source.getTypeFirstRep().getProfile().get(0).getValue(), derivedSrc) : null;
        }
        if (profile != null) {
            Iterator<Element> e = profile.getSnapshot().getElement().get(0);
            String string = profile.getUserString("webroot");
            if (((ElementDefinition)((Object)e)).hasDefinition()) {
                base.setDefinition(ProfileUtilities.processRelativeUrls(((ElementDefinition)((Object)e)).getDefinition(), string, this.context.getSpecUrl(), this.context.getResourceNames(), this.masterSourceFileNames, null, true));
            }
            base.setShort(((ElementDefinition)((Object)e)).getShort());
            if (((ElementDefinition)((Object)e)).hasCommentElement()) {
                base.setCommentElement(((ElementDefinition)((Object)e)).getCommentElement());
            }
            if (((ElementDefinition)((Object)e)).hasRequirementsElement()) {
                base.setRequirementsElement(((ElementDefinition)((Object)e)).getRequirementsElement());
            }
            base.getAlias().clear();
            base.getAlias().addAll(((ElementDefinition)((Object)e)).getAlias());
            base.getMapping().clear();
            base.getMapping().addAll(((ElementDefinition)((Object)e)).getMapping());
        }
        if (derived != null) {
            if (derived.hasSliceName()) {
                base.setSliceName(derived.getSliceName());
            }
            if (derived.hasShortElement()) {
                if (!Base.compareDeep(derived.getShortElement(), base.getShortElement(), false)) {
                    base.setShortElement(derived.getShortElement().copy());
                } else if (trimDifferential) {
                    derived.setShortElement(null);
                } else if (derived.hasShortElement()) {
                    derived.getShortElement().setUserData(UD_DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasDefinitionElement()) {
                if (derived.getDefinition().startsWith("...")) {
                    base.setDefinition(Utilities.appendDerivedTextToBase((String)base.getDefinition(), (String)derived.getDefinition()));
                } else if (!Base.compareDeep(derived.getDefinitionElement(), base.getDefinitionElement(), false)) {
                    base.setDefinitionElement(derived.getDefinitionElement().copy());
                } else if (trimDifferential) {
                    derived.setDefinitionElement(null);
                } else if (derived.hasDefinitionElement()) {
                    derived.getDefinitionElement().setUserData(UD_DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasCommentElement()) {
                if (derived.getComment().startsWith("...")) {
                    base.setComment(Utilities.appendDerivedTextToBase((String)base.getComment(), (String)derived.getComment()));
                } else if (derived.hasCommentElement() != base.hasCommentElement() || !Base.compareDeep(derived.getCommentElement(), base.getCommentElement(), false)) {
                    base.setCommentElement(derived.getCommentElement().copy());
                } else if (trimDifferential) {
                    base.setCommentElement(derived.getCommentElement().copy());
                } else if (derived.hasCommentElement()) {
                    derived.getCommentElement().setUserData(UD_DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasLabelElement()) {
                if (derived.getLabel().startsWith("...")) {
                    base.setLabel(Utilities.appendDerivedTextToBase((String)base.getLabel(), (String)derived.getLabel()));
                } else if (!base.hasLabelElement() || !Base.compareDeep(derived.getLabelElement(), base.getLabelElement(), false)) {
                    base.setLabelElement(derived.getLabelElement().copy());
                } else if (trimDifferential) {
                    base.setLabelElement(derived.getLabelElement().copy());
                } else if (derived.hasLabelElement()) {
                    derived.getLabelElement().setUserData(UD_DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasRequirementsElement()) {
                if (derived.getRequirements().startsWith("...")) {
                    base.setRequirements(Utilities.appendDerivedTextToBase((String)base.getRequirements(), (String)derived.getRequirements()));
                } else if (!base.hasRequirementsElement() || !Base.compareDeep(derived.getRequirementsElement(), base.getRequirementsElement(), false)) {
                    base.setRequirementsElement(derived.getRequirementsElement().copy());
                } else if (trimDifferential) {
                    base.setRequirementsElement(derived.getRequirementsElement().copy());
                } else if (derived.hasRequirementsElement()) {
                    derived.getRequirementsElement().setUserData(UD_DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasRequirements() && !base.getPath().contains(".")) {
                derived.setRequirements(null);
            }
            if (base.hasRequirements() && !base.getPath().contains(".")) {
                base.setRequirements(null);
            }
            if (derived.hasAlias()) {
                if (!Base.compareDeep(derived.getAlias(), base.getAlias(), false)) {
                    for (StringType stringType : derived.getAlias()) {
                        if (base.hasAlias((String)stringType.getValue())) continue;
                        base.getAlias().add(stringType.copy());
                    }
                } else if (trimDifferential) {
                    derived.getAlias().clear();
                } else {
                    for (StringType stringType : derived.getAlias()) {
                        stringType.setUserData(UD_DERIVATION_EQUALS, true);
                    }
                }
            }
            if (derived.hasMinElement()) {
                if (!Base.compareDeep(derived.getMinElement(), base.getMinElement(), false)) {
                    if (derived.getMin() < base.getMin() && !derived.hasSliceName()) {
                        this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + source.getPath(), "Element " + base.getPath() + ": derived min (" + Integer.toString(derived.getMin()) + ") cannot be less than base min (" + Integer.toString(base.getMin()) + ")", ValidationMessage.IssueSeverity.ERROR));
                    }
                    base.setMinElement(derived.getMinElement().copy());
                } else if (trimDifferential) {
                    derived.setMinElement(null);
                } else {
                    derived.getMinElement().setUserData(UD_DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasMaxElement()) {
                if (!Base.compareDeep(derived.getMaxElement(), base.getMaxElement(), false)) {
                    if (this.isLargerMax(derived.getMax(), base.getMax())) {
                        this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + source.getPath(), "Element " + base.getPath() + ": derived max (" + derived.getMax() + ") cannot be greater than base max (" + base.getMax() + ")", ValidationMessage.IssueSeverity.ERROR));
                    }
                    base.setMaxElement(derived.getMaxElement().copy());
                } else if (trimDifferential) {
                    derived.setMaxElement(null);
                } else {
                    derived.getMaxElement().setUserData(UD_DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasFixed()) {
                if (!Base.compareDeep(derived.getFixed(), base.getFixed(), true)) {
                    base.setFixed(derived.getFixed().copy());
                } else if (trimDifferential) {
                    derived.setFixed(null);
                } else {
                    derived.getFixed().setUserData(UD_DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasPattern()) {
                if (!Base.compareDeep(derived.getPattern(), base.getPattern(), false)) {
                    base.setPattern(derived.getPattern().copy());
                } else if (trimDifferential) {
                    derived.setPattern(null);
                } else {
                    derived.getPattern().setUserData(UD_DERIVATION_EQUALS, true);
                }
            }
            for (ElementDefinition.ElementDefinitionExampleComponent elementDefinitionExampleComponent : derived.getExample()) {
                boolean found = false;
                for (ElementDefinition.ElementDefinitionExampleComponent exS : base.getExample()) {
                    if (!Base.compareDeep(elementDefinitionExampleComponent, exS, false)) continue;
                    found = true;
                }
                if (!found) {
                    base.addExample(elementDefinitionExampleComponent.copy());
                    continue;
                }
                if (trimDifferential) {
                    derived.getExample().remove(elementDefinitionExampleComponent);
                    continue;
                }
                elementDefinitionExampleComponent.setUserData(UD_DERIVATION_EQUALS, true);
            }
            if (derived.hasMaxLengthElement()) {
                if (!Base.compareDeep(derived.getMaxLengthElement(), base.getMaxLengthElement(), false)) {
                    base.setMaxLengthElement(derived.getMaxLengthElement().copy());
                } else if (trimDifferential) {
                    derived.setMaxLengthElement(null);
                } else {
                    derived.getMaxLengthElement().setUserData(UD_DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasMaxValue()) {
                if (!Base.compareDeep(derived.getMaxValue(), base.getMaxValue(), false)) {
                    base.setMaxValue(derived.getMaxValue().copy());
                } else if (trimDifferential) {
                    derived.setMaxValue(null);
                } else {
                    derived.getMaxValue().setUserData(UD_DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasMinValue()) {
                if (!Base.compareDeep(derived.getMinValue(), base.getMinValue(), false)) {
                    base.setMinValue(derived.getMinValue().copy());
                } else if (trimDifferential) {
                    derived.setMinValue(null);
                } else {
                    derived.getMinValue().setUserData(UD_DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasMustSupportElement()) {
                if (!base.hasMustSupportElement() || !Base.compareDeep(derived.getMustSupportElement(), base.getMustSupportElement(), false)) {
                    if (base.hasMustSupport() && base.getMustSupport() && !derived.getMustSupport()) {
                        this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "Illegal constraint [must-support = false] when [must-support = true] in the base profile", ValidationMessage.IssueSeverity.ERROR));
                    }
                    base.setMustSupportElement(derived.getMustSupportElement().copy());
                } else if (trimDifferential) {
                    derived.setMustSupportElement(null);
                } else {
                    derived.getMustSupportElement().setUserData(UD_DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasMustHaveValueElement()) {
                if (!base.hasMustHaveValueElement() || !Base.compareDeep(derived.getMustHaveValueElement(), base.getMustHaveValueElement(), false)) {
                    if (base.hasMustHaveValue() && base.getMustHaveValue() && !derived.getMustHaveValue()) {
                        this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "Illegal constraint [must-have-value = false] when [must-have-value = true] in the base profile", ValidationMessage.IssueSeverity.ERROR));
                    }
                    base.setMustHaveValueElement(derived.getMustHaveValueElement().copy());
                } else if (trimDifferential) {
                    derived.setMustHaveValueElement(null);
                } else {
                    derived.getMustHaveValueElement().setUserData(UD_DERIVATION_EQUALS, true);
                }
            }
            if (isExtension) {
                if (!(!derived.hasIsModifierElement() || base.hasIsModifierElement() && Base.compareDeep(derived.getIsModifierElement(), base.getIsModifierElement(), false))) {
                    base.setIsModifierElement(derived.getIsModifierElement().copy());
                } else if (trimDifferential) {
                    derived.setIsModifierElement(null);
                } else if (derived.hasIsModifierElement()) {
                    derived.getIsModifierElement().setUserData(UD_DERIVATION_EQUALS, true);
                }
                if (!(!derived.hasIsModifierReasonElement() || base.hasIsModifierReasonElement() && Base.compareDeep(derived.getIsModifierReasonElement(), base.getIsModifierReasonElement(), false))) {
                    base.setIsModifierReasonElement(derived.getIsModifierReasonElement().copy());
                } else if (trimDifferential) {
                    derived.setIsModifierReasonElement(null);
                } else if (derived.hasIsModifierReasonElement()) {
                    derived.getIsModifierReasonElement().setUserData(UD_DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasBinding()) {
                if (!base.hasBinding() || !Base.compareDeep(derived.getBinding(), base.getBinding(), false)) {
                    if (base.hasBinding() && base.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED && derived.getBinding().getStrength() != Enumerations.BindingStrength.REQUIRED) {
                        this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "illegal attempt to change the binding on " + derived.getPath() + " from " + base.getBinding().getStrength().toCode() + " to " + derived.getBinding().getStrength().toCode(), ValidationMessage.IssueSeverity.ERROR));
                    } else if (base.hasBinding() && derived.hasBinding() && base.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED && base.getBinding().hasValueSet() && derived.getBinding().hasValueSet()) {
                        ValueSet baseVs = this.context.fetchResource(ValueSet.class, base.getBinding().getValueSet(), srcSD);
                        ValueSet valueSet = this.context.fetchResource(ValueSet.class, derived.getBinding().getValueSet(), derivedSrc);
                        if (baseVs == null) {
                            this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + base.getPath(), "Binding " + base.getBinding().getValueSet() + " could not be located", ValidationMessage.IssueSeverity.WARNING));
                        } else if (valueSet == null) {
                            this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "Binding " + derived.getBinding().getValueSet() + " could not be located", ValidationMessage.IssueSeverity.WARNING));
                        } else {
                            ValueSetExpander.ValueSetExpansionOutcome expBase = this.context.expandVS(baseVs, true, false);
                            ValueSetExpander.ValueSetExpansionOutcome expDerived = this.context.expandVS(valueSet, true, false);
                            if (expBase.getValueset() == null) {
                                this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + base.getPath(), "Binding " + base.getBinding().getValueSet() + " could not be expanded", ValidationMessage.IssueSeverity.WARNING));
                            } else if (expDerived.getValueset() == null) {
                                this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "Binding " + derived.getBinding().getValueSet() + " could not be expanded", ValidationMessage.IssueSeverity.WARNING));
                            } else if (ToolingExtensions.hasExtension(expBase.getValueset().getExpansion(), "http://hl7.org/fhir/StructureDefinition/valueset-toocostly")) {
                                this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "Unable to check if " + derived.getBinding().getValueSet() + " is a proper subset of " + base.getBinding().getValueSet() + " - base value set is too large to check", ValidationMessage.IssueSeverity.WARNING));
                            } else if (!this.isSubset(expBase.getValueset(), expDerived.getValueset())) {
                                this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "Binding " + derived.getBinding().getValueSet() + " is not a subset of binding " + base.getBinding().getValueSet(), ValidationMessage.IssueSeverity.ERROR));
                            }
                        }
                    }
                    ElementDefinition.ElementDefinitionBindingComponent d = derived.getBinding();
                    ElementDefinition.ElementDefinitionBindingComponent elementDefinitionBindingComponent = base.getBinding().copy();
                    elementDefinitionBindingComponent.getExtension().clear();
                    elementDefinitionBindingComponent.setDescription(null);
                    elementDefinitionBindingComponent.getExtension().addAll(d.getExtension());
                    if (d.hasStrength()) {
                        elementDefinitionBindingComponent.setStrength(d.getStrength());
                    }
                    if (d.hasDescription()) {
                        elementDefinitionBindingComponent.setDescription(d.getDescription());
                    }
                    if (d.hasValueSet()) {
                        elementDefinitionBindingComponent.setValueSet(d.getValueSet());
                    }
                    base.setBinding(elementDefinitionBindingComponent);
                } else if (trimDifferential) {
                    derived.setBinding(null);
                } else {
                    derived.getBinding().setUserData(UD_DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasIsSummaryElement()) {
                if (!Base.compareDeep(derived.getIsSummaryElement(), base.getIsSummaryElement(), false)) {
                    if (base.hasIsSummary() && !this.context.getVersion().equals("1.4.0")) {
                        throw new Error(this.context.formatMessage("Error_in_profile__at__Base_isSummary___derived_isSummary__", purl, derived.getPath(), base.getIsSummaryElement().asStringValue(), derived.getIsSummaryElement().asStringValue()));
                    }
                    base.setIsSummaryElement(derived.getIsSummaryElement().copy());
                } else if (trimDifferential) {
                    derived.setIsSummaryElement(null);
                } else {
                    derived.getIsSummaryElement().setUserData(UD_DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasType()) {
                if (!Base.compareDeep(derived.getType(), base.getType(), false)) {
                    if (base.hasType()) {
                        for (ElementDefinition.TypeRefComponent typeRefComponent : derived.getType()) {
                            this.checkTypeDerivation(purl, derivedSrc, base, derived, typeRefComponent);
                        }
                    }
                    base.getType().clear();
                    for (ElementDefinition.TypeRefComponent typeRefComponent : derived.getType()) {
                        ElementDefinition.TypeRefComponent tt = typeRefComponent.copy();
                        base.getType().add(tt);
                    }
                } else if (trimDifferential) {
                    derived.getType().clear();
                } else {
                    for (ElementDefinition.TypeRefComponent typeRefComponent : derived.getType()) {
                        typeRefComponent.setUserData(UD_DERIVATION_EQUALS, true);
                    }
                }
            }
            if (derived.hasMapping()) {
                if (!Base.compareDeep(derived.getMapping(), base.getMapping(), false)) {
                    for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : derived.getMapping()) {
                        boolean found = false;
                        for (ElementDefinition.ElementDefinitionMappingComponent d : base.getMapping()) {
                            found = found || d.getIdentity().equals(elementDefinitionMappingComponent.getIdentity()) && d.getMap().equals(elementDefinitionMappingComponent.getMap());
                        }
                        if (found) continue;
                        base.getMapping().add(elementDefinitionMappingComponent);
                    }
                } else if (trimDifferential) {
                    derived.getMapping().clear();
                } else {
                    for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : derived.getMapping()) {
                        elementDefinitionMappingComponent.setUserData(UD_DERIVATION_EQUALS, true);
                    }
                }
            }
            for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : base.getMapping()) {
                if (!elementDefinitionMappingComponent.hasMap()) continue;
                elementDefinitionMappingComponent.setMap(elementDefinitionMappingComponent.getMap().trim());
            }
            for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : base.getConstraint()) {
                elementDefinitionConstraintComponent.setUserData(UD_IS_DERIVED, true);
                if (elementDefinitionConstraintComponent.hasSource()) continue;
                elementDefinitionConstraintComponent.setSource(srcSD.getUrl());
            }
            if (derived.hasConstraint()) {
                for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : derived.getConstraint()) {
                    if (base.hasConstraint(elementDefinitionConstraintComponent.getKey())) continue;
                    ElementDefinition.ElementDefinitionConstraintComponent inv = elementDefinitionConstraintComponent.copy();
                    base.getConstraint().add(inv);
                }
            }
            for (IdType idType : derived.getCondition()) {
                if (base.hasCondition(idType)) continue;
                base.getCondition().add(idType);
            }
            if (dest.hasBinding() && !this.hasBindableType(dest)) {
                dest.setBinding(null);
            }
            for (Extension extension : derived.getExtension()) {
                StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, extension.getUrl(), derivedSrc);
                if (sd == null || sd.getSnapshot() == null || sd.getSnapshot().getElementFirstRep().getMax().equals("1")) {
                    ToolingExtensions.removeExtension(dest, extension.getUrl());
                }
                dest.addExtension(extension.copy());
            }
        }
        if (dest.hasFixed()) {
            this.checkTypeOk(dest, dest.getFixed().fhirType(), srcSD, "fixed");
        }
        if (dest.hasPattern()) {
            this.checkTypeOk(dest, dest.getPattern().fhirType(), srcSD, "pattern");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkTypeDerivation(String purl, StructureDefinition srcSD, ElementDefinition base, ElementDefinition derived, ElementDefinition.TypeRefComponent ts) {
        boolean ok = false;
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        String t = ts.getWorkingCode();
        for (ElementDefinition.TypeRefComponent td : base.getType()) {
            StructureDefinition sdt;
            String tt = td.getWorkingCode();
            b.append(tt);
            if (td.hasCode() && tt.equals(t)) {
                ok = true;
            }
            if (!ok && (sdt = this.context.fetchTypeDefinition(tt)) != null && (sdt.getAbstract() || sdt.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL)) {
                void var13_15;
                StructureDefinition structureDefinition = this.context.fetchTypeDefinition(t);
                while (var13_15 != null && !ok) {
                    ok = var13_15.getType().equals(sdt.getType());
                    StructureDefinition structureDefinition2 = this.context.fetchResource(StructureDefinition.class, var13_15.getBaseDefinition(), (Resource)var13_15);
                }
            }
            if (!ok || !ts.hasTargetProfile()) continue;
            for (UriType uriType : ts.getTargetProfile()) {
                boolean tgtOk;
                String url = (String)uriType.getValue();
                boolean bl = tgtOk = !td.hasTargetProfile() || td.hasTargetProfile(url);
                while (url != null && !tgtOk) {
                    StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, url);
                    if (sd == null) {
                        if (this.messages != null) {
                            this.messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, purl + "#" + derived.getPath(), "Cannot check whether the target profile " + url + " is valid constraint on the base because it is not known", ValidationMessage.IssueSeverity.WARNING));
                        }
                        url = null;
                        tgtOk = true;
                        continue;
                    }
                    url = sd.getBaseDefinition();
                    tgtOk = td.hasTargetProfile(url);
                }
                if (tgtOk) continue;
                if (this.messages == null) {
                    throw new FHIRException(this.context.formatMessage("Error_at__The_target_profile__is_not__valid_constraint_on_the_base_", purl, derived.getPath(), url, td.getTargetProfile()));
                }
                this.messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.BUSINESSRULE, derived.getPath(), "The target profile " + (String)uriType.getValue() + " is not a valid constraint on the base (" + td.getTargetProfile() + ") at " + derived.getPath(), ValidationMessage.IssueSeverity.ERROR));
            }
        }
        if (!ok) {
            throw new DefinitionException(this.context.formatMessage("StructureDefinition__at__illegal_constrained_type__from__in_", purl, derived.getPath(), t, b.toString(), srcSD.getUrl()));
        }
    }

    private void checkTypeOk(ElementDefinition dest, String ft, StructureDefinition sd, String fieldName) {
        boolean ok = false;
        HashSet<String> types = new HashSet<String>();
        if (dest.getPath().contains(".")) {
            for (ElementDefinition.TypeRefComponent t : dest.getType()) {
                if (t.hasCode()) {
                    types.add(t.getWorkingCode());
                }
                ok = ft.equals(t.getWorkingCode());
            }
        } else {
            types.add(sd.getType());
            ok = ft.equals(sd.getType());
        }
        if (!ok) {
            this.messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.CONFLICT, dest.getId(), "The " + fieldName + " value has type '" + ft + "' which is not valid (valid " + Utilities.pluralize((String)"type", (int)dest.getType().size()) + ": " + ((Object)types).toString() + ")", ValidationMessage.IssueSeverity.ERROR));
        }
    }

    private boolean hasBindableType(ElementDefinition ed) {
        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
            if (Utilities.existsInList((String)tr.getWorkingCode(), (String[])new String[]{"Coding", "CodeableConcept", "Quantity", "uri", "string", "code", "CodeableReference"})) {
                return true;
            }
            StructureDefinition sd = this.context.fetchTypeDefinition(tr.getCode());
            if (sd == null || !sd.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-binding-style")) continue;
            return true;
        }
        return false;
    }

    private boolean isLargerMax(String derived, String base) {
        if ("*".equals(base)) {
            return false;
        }
        if ("*".equals(derived)) {
            return true;
        }
        return Integer.parseInt(derived) > Integer.parseInt(base);
    }

    private boolean isSubset(ValueSet expBase, ValueSet expDerived) {
        return this.codesInExpansion(expDerived.getExpansion().getContains(), expBase.getExpansion());
    }

    private boolean codesInExpansion(List<ValueSet.ValueSetExpansionContainsComponent> contains, ValueSet.ValueSetExpansionComponent expansion) {
        for (ValueSet.ValueSetExpansionContainsComponent cc : contains) {
            if (!this.inExpansion(cc, expansion.getContains())) {
                return false;
            }
            if (this.codesInExpansion(cc.getContains(), expansion)) continue;
            return false;
        }
        return true;
    }

    private boolean inExpansion(ValueSet.ValueSetExpansionContainsComponent cc, List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent cc1 : contains) {
            if (cc.getSystem().equals(cc1.getSystem()) && cc.getCode().equals(cc1.getCode())) {
                return true;
            }
            if (!this.inExpansion(cc, cc1.getContains())) continue;
            return true;
        }
        return false;
    }

    public void closeDifferential(StructureDefinition base, StructureDefinition derived) throws FHIRException {
        for (ElementDefinition edb : base.getSnapshot().getElement()) {
            if (!this.isImmediateChild(edb) || edb.getPath().endsWith(".id")) continue;
            ElementDefinition edm = this.getMatchInDerived(edb, derived.getDifferential().getElement());
            if (edm == null) {
                ElementDefinition edd = derived.getDifferential().addElement();
                edd.setPath(edb.getPath());
                edd.setMax("0");
                continue;
            }
            if (!edb.hasSlicing()) continue;
            this.closeChildren(base, edb, derived, edm);
        }
        this.sortDifferential(base, derived, derived.getName(), new ArrayList<String>(), false);
    }

    private void closeChildren(StructureDefinition base, ElementDefinition edb, StructureDefinition derived, ElementDefinition edm) {
        int baseStart = base.getSnapshot().getElement().indexOf(edb);
        int baseEnd = this.findEnd(base.getSnapshot().getElement(), edb, baseStart + 1);
        int diffStart = derived.getDifferential().getElement().indexOf(edm);
        int diffEnd = this.findEnd(derived.getDifferential().getElement(), edm, diffStart + 1);
        for (int cBase = baseStart; cBase < baseEnd; ++cBase) {
            ElementDefinition edBase = base.getSnapshot().getElement().get(cBase);
            if (!this.isImmediateChild(edBase, edb)) continue;
            ElementDefinition edMatch = this.getMatchInDerived(edBase, derived.getDifferential().getElement(), diffStart, diffEnd);
            if (edMatch == null) {
                ElementDefinition edd = derived.getDifferential().addElement();
                edd.setPath(edBase.getPath());
                edd.setMax("0");
                continue;
            }
            this.closeChildren(base, edBase, derived, edMatch);
        }
    }

    private int findEnd(List<ElementDefinition> list, ElementDefinition ed, int cursor) {
        String path = ed.getPath() + ".";
        while (cursor < list.size() && list.get(cursor).getPath().startsWith(path)) {
            ++cursor;
        }
        return cursor;
    }

    private ElementDefinition getMatchInDerived(ElementDefinition ed, List<ElementDefinition> list) {
        for (ElementDefinition t : list) {
            if (!t.getPath().equals(ed.getPath())) continue;
            return t;
        }
        return null;
    }

    private ElementDefinition getMatchInDerived(ElementDefinition ed, List<ElementDefinition> list, int start, int end) {
        for (int i = start; i < end; ++i) {
            ElementDefinition t = list.get(i);
            if (!t.getPath().equals(ed.getPath())) continue;
            return t;
        }
        return null;
    }

    private boolean isImmediateChild(ElementDefinition ed) {
        String p = ed.getPath();
        if (!p.contains(".")) {
            return false;
        }
        return !(p = p.substring(p.indexOf(".") + 1)).contains(".");
    }

    private boolean isImmediateChild(ElementDefinition candidate, ElementDefinition base) {
        String p = candidate.getPath();
        if (!p.contains(".")) {
            return false;
        }
        if (!p.startsWith(base.getPath() + ".")) {
            return false;
        }
        return !(p = p.substring(base.getPath().length() + 1)).contains(".");
    }

    private ElementDefinition getUrlFor(StructureDefinition ed, ElementDefinition c) {
        for (int i = ed.getSnapshot().getElement().indexOf(c) + 1; i < ed.getSnapshot().getElement().size() && ed.getSnapshot().getElement().get(i).getPath().startsWith(c.getPath() + "."); ++i) {
            if (!ed.getSnapshot().getElement().get(i).getPath().equals(c.getPath() + ".url")) continue;
            return ed.getSnapshot().getElement().get(i);
        }
        return null;
    }

    protected ElementDefinitionResolution getElementById(StructureDefinition source, List<ElementDefinition> elements, String contentReference) {
        if (!contentReference.startsWith("#") && contentReference.contains("#")) {
            String url = contentReference.substring(0, contentReference.indexOf("#"));
            contentReference = contentReference.substring(contentReference.indexOf("#"));
            if (!url.equals(source.getUrl())) {
                if ((source = this.context.fetchResource(StructureDefinition.class, url, source)) == null) {
                    return null;
                }
                elements = source.getSnapshot().getElement();
            }
        }
        for (ElementDefinition ed : elements) {
            if (!ed.hasId() || !("#" + ed.getId()).equals(contentReference)) continue;
            return new ElementDefinitionResolution(source, ed);
        }
        return null;
    }

    public static String describeExtensionContext(StructureDefinition ext) {
        StringBuilder b = new StringBuilder();
        b.append("Use on ");
        for (int i = 0; i < ext.getContext().size(); ++i) {
            StructureDefinition.StructureDefinitionContextComponent ec = ext.getContext().get(i);
            if (i > 0) {
                b.append(i < ext.getContext().size() - 1 ? ", " : " or ");
            }
            b.append(ec.getType().getDisplay());
            b.append(" ");
            b.append(ec.getExpression());
        }
        if (ext.hasContextInvariant()) {
            b.append(", with <a href=\"structuredefinition-definitions.html#StructureDefinition.contextInvariant\">Context Invariant</a> = ");
            boolean first = true;
            for (StringType s : ext.getContextInvariant()) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append("<code>" + (String)s.getValue() + "</code>");
            }
        }
        return b.toString();
    }

    protected String tail(String path) {
        if (path == null) {
            return "";
        }
        if (path.contains(".")) {
            return path.substring(path.lastIndexOf(46) + 1);
        }
        return path;
    }

    private boolean isDataType(String value) {
        StructureDefinition sd = this.context.fetchTypeDefinition(value);
        if (sd == null) {
            return Utilities.existsInList((String)value, (String[])new String[]{"Address", "Age", "Annotation", "Attachment", "CodeableConcept", "Coding", "ContactPoint", "Count", "Distance", "Duration", "HumanName", "Identifier", "Money", "Period", "Quantity", "Range", "Ratio", "Reference", "SampledData", "Signature", "Timing", "ContactDetail", "Contributor", "DataRequirement", "Expression", "ParameterDefinition", "RelatedArtifact", "TriggerDefinition", "UsageContext"});
        }
        return sd.getKind() == StructureDefinition.StructureDefinitionKind.COMPLEXTYPE && sd.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION;
    }

    private boolean isConstrainedDataType(String value) {
        StructureDefinition sd = this.context.fetchTypeDefinition(value);
        if (sd == null) {
            return Utilities.existsInList((String)value, (String[])new String[]{"SimpleQuantity", "MoneyQuantity"});
        }
        return sd.getKind() == StructureDefinition.StructureDefinitionKind.COMPLEXTYPE && sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT;
    }

    private String baseType(String value) {
        StructureDefinition sd = this.context.fetchTypeDefinition(value);
        if (sd != null) {
            return sd.getTypeName();
        }
        if (Utilities.existsInList((String)value, (String[])new String[]{"SimpleQuantity", "MoneyQuantity"})) {
            return "Quantity";
        }
        throw new Error(this.context.formatMessage("Internal_error___type_not_known_", value));
    }

    protected boolean isPrimitive(String value) {
        StructureDefinition sd = this.context.fetchTypeDefinition(value);
        if (sd == null) {
            return Utilities.existsInList((String)value, (String[])new String[]{"base64Binary", "boolean", "canonical", "code", "date", "dateTime", "decimal", "id", "instant", "integer", "integer64", "markdown", "oid", "positiveInt", "string", "time", "unsignedInt", "uri", "url", "uuid"});
        }
        return sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
    }

    public StructureDefinition getProfile(StructureDefinition source, String url) {
        StructureDefinition profile = null;
        String code = null;
        if (url.startsWith("#")) {
            profile = source;
            code = url.substring(1);
        } else if (this.context != null) {
            String[] parts = url.split("\\#");
            profile = this.context.fetchResource(StructureDefinition.class, parts[0], source);
            String string = code = parts.length == 1 ? null : parts[1];
        }
        if (profile == null) {
            return null;
        }
        if (code == null) {
            return profile;
        }
        for (Resource r : profile.getContained()) {
            if (!(r instanceof StructureDefinition) || !r.getId().equals(code)) continue;
            return (StructureDefinition)r;
        }
        return null;
    }

    public void sortDifferential(StructureDefinition base, StructureDefinition diff, String name, List<String> errors, boolean errorIfChanges) throws FHIRException {
        ArrayList<ElementDefinition> original = new ArrayList<ElementDefinition>();
        original.addAll(diff.getDifferential().getElement());
        List<ElementDefinition> diffList = diff.getDifferential().getElement();
        int lastCount = diffList.size();
        if (diffList.isEmpty()) {
            return;
        }
        ElementDefinitionHolder edh = null;
        int i = 0;
        if (diffList.get(0).getPath().contains(".")) {
            String newPath = diffList.get(0).getPath().split("\\.")[0];
            ElementDefinition e = new ElementDefinition(newPath);
            edh = new ElementDefinitionHolder(e, true);
        } else {
            edh = new ElementDefinitionHolder(diffList.get(0));
            i = 1;
        }
        boolean hasSlicing = false;
        ArrayList<String> paths = new ArrayList<String>();
        for (ElementDefinition elt : diffList) {
            if (elt.hasSlicing() || paths.contains(elt.getPath())) {
                hasSlicing = true;
                break;
            }
            paths.add(elt.getPath());
        }
        if (!hasSlicing) {
            Collections.sort(diffList, new ElementNameCompare());
        }
        this.processElementsIntoTree(edh, i, diff.getDifferential().getElement());
        ElementDefinitionComparer cmp = new ElementDefinitionComparer(true, base.getSnapshot().getElement(), "", 0, name, base.getType());
        this.sortElements(edh, cmp, errors);
        ArrayList<ElementDefinition> newDiff = new ArrayList<ElementDefinition>();
        this.writeElements(edh, newDiff);
        if (errorIfChanges) {
            this.compareDiffs(original, newDiff, errors);
        }
        diffList.clear();
        diffList.addAll(newDiff);
        if (lastCount != diffList.size()) {
            errors.add("Sort failed: counts differ; at least one of the paths in the differential is illegal");
        }
    }

    private void compareDiffs(List<ElementDefinition> diffList, List<ElementDefinition> newDiff, List<String> errors) {
        if (diffList.size() != newDiff.size()) {
            errors.add("The diff list size changed when sorting - was " + diffList.size() + " is now " + newDiff.size());
        } else {
            for (int i = 0; i < Integer.min(diffList.size(), newDiff.size()); ++i) {
                ElementDefinition e = diffList.get(i);
                ElementDefinition n = newDiff.get(i);
                if (n.getPath().equals(e.getPath())) continue;
                errors.add("The element " + e.getPath() + " is out of order (and maybe others after it)");
                return;
            }
        }
    }

    private int processElementsIntoTree(ElementDefinitionHolder edh, int i, List<ElementDefinition> list) {
        String path = edh.getSelf().getPath();
        String prefix = path + ".";
        while (i < list.size() && list.get(i).getPath().startsWith(prefix)) {
            if (list.get(i).getPath().substring(prefix.length() + 1).contains(".")) {
                String newPath = prefix + list.get(i).getPath().substring(prefix.length()).split("\\.")[0];
                ElementDefinition e = new ElementDefinition(newPath);
                ElementDefinitionHolder child = new ElementDefinitionHolder(e, true);
                edh.getChildren().add(child);
                i = this.processElementsIntoTree(child, i, list);
                continue;
            }
            ElementDefinitionHolder child = new ElementDefinitionHolder(list.get(i));
            edh.getChildren().add(child);
            i = this.processElementsIntoTree(child, i + 1, list);
        }
        return i;
    }

    private void sortElements(ElementDefinitionHolder edh, ElementDefinitionComparer cmp, List<String> errors) throws FHIRException {
        if (edh.getChildren().size() == 1) {
            edh.getChildren().get((int)0).baseIndex = cmp.find(edh.getChildren().get(0).getSelf().getPath(), false);
        } else {
            Collections.sort(edh.getChildren(), cmp);
        }
        cmp.checkForErrors(errors);
        for (ElementDefinitionHolder child : edh.getChildren()) {
            ElementDefinitionComparer ccmp;
            if (child.getChildren().size() <= 0 || (ccmp = this.getComparer(cmp, child)) == null) continue;
            this.sortElements(child, ccmp, errors);
        }
    }

    public ElementDefinitionComparer getComparer(ElementDefinitionComparer cmp, ElementDefinitionHolder child) throws FHIRException, Error {
        ElementDefinitionComparer ccmp;
        ElementDefinition ed = cmp.snapshot.get(child.getBaseIndex());
        if (ed.getType().isEmpty() || this.isAbstract(ed.getType().get(0).getWorkingCode()) || ed.getType().get(0).getWorkingCode().equals(ed.getPath())) {
            if (ed.hasType() && "Resource".equals(ed.getType().get(0).getWorkingCode()) && child.getSelf().hasType() && child.getSelf().getType().get(0).hasProfile()) {
                if (child.getSelf().getType().get(0).getProfile().size() > 1) {
                    throw new FHIRException(this.context.formatMessage("Unhandled_situation_resource_is_profiled_to_more_than_one_option__cannot_sort_profile", new Object[0]));
                }
                StructureDefinition profile = this.context.fetchResource(StructureDefinition.class, (String)child.getSelf().getType().get(0).getProfile().get(0).getValue());
                while (profile != null && profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
                    profile = this.context.fetchResource(StructureDefinition.class, profile.getBaseDefinition());
                }
                ccmp = profile == null ? null : new ElementDefinitionComparer(true, profile.getSnapshot().getElement(), profile.getType(), child.getSelf().getPath().length(), cmp.name, profile.present());
            } else {
                ccmp = new ElementDefinitionComparer(true, cmp.snapshot, cmp.base, cmp.prefixLength, cmp.name, cmp.name);
            }
        } else if (ed.getType().get(0).getWorkingCode().equals("Extension") && child.getSelf().getType().size() == 1 && child.getSelf().getType().get(0).hasProfile()) {
            StructureDefinition profile = this.context.fetchResource(StructureDefinition.class, (String)child.getSelf().getType().get(0).getProfile().get(0).getValue());
            ccmp = profile == null ? null : new ElementDefinitionComparer(true, profile.getSnapshot().getElement(), this.resolveType(ed.getType().get(0).getWorkingCode()), child.getSelf().getPath().length(), cmp.name, profile.present());
        } else if (ed.getType().size() == 1 && !ed.getType().get(0).getWorkingCode().equals("*")) {
            StructureDefinition profile = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(ed.getType().get(0).getWorkingCode()));
            if (profile == null) {
                throw new FHIRException(this.context.formatMessage("Unable_to_resolve_profile__in_element_", ProfileUtilities.sdNs(ed.getType().get(0).getWorkingCode()), ed.getPath()));
            }
            ccmp = new ElementDefinitionComparer(false, profile.getSnapshot().getElement(), this.resolveType(ed.getType().get(0).getWorkingCode()), child.getSelf().getPath().length(), cmp.name, profile.present());
        } else if (child.getSelf().getType().size() == 1) {
            StructureDefinition profile = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(child.getSelf().getType().get(0).getWorkingCode()));
            if (profile == null) {
                throw new FHIRException(this.context.formatMessage("Unable_to_resolve_profile__in_element_", ProfileUtilities.sdNs(ed.getType().get(0).getWorkingCode()), ed.getPath()));
            }
            ccmp = new ElementDefinitionComparer(false, profile.getSnapshot().getElement(), child.getSelf().getType().get(0).getWorkingCode(), child.getSelf().getPath().length(), cmp.name, profile.present());
        } else if (ed.getPath().endsWith("[x]") && !child.getSelf().getPath().endsWith("[x]")) {
            StructureDefinition sd;
            String edLastNode = ed.getPath().replaceAll("(.*\\.)*(.*)", "$2");
            String childLastNode = child.getSelf().getPath().replaceAll("(.*\\.)*(.*)", "$2");
            String p = childLastNode.substring(edLastNode.length() - 3);
            if (this.isPrimitive(Utilities.uncapitalize((String)p))) {
                p = Utilities.uncapitalize((String)p);
            }
            if ((sd = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(p))) == null) {
                throw new Error(this.context.formatMessage("Unable_to_find_profile__at_", p, ed.getId()));
            }
            ccmp = new ElementDefinitionComparer(false, sd.getSnapshot().getElement(), p, child.getSelf().getPath().length(), cmp.name, sd.present());
        } else if (child.getSelf().hasType() && child.getSelf().getType().get(0).getWorkingCode().equals("Reference")) {
            for (ElementDefinition.TypeRefComponent t : child.getSelf().getType()) {
                if (t.getWorkingCode().equals("Reference")) continue;
                throw new Error(this.context.formatMessage("Cant_have_children_on_an_element_with_a_polymorphic_type__you_must_slice_and_constrain_the_types_first_sortElements_", ed.getPath(), ProfileUtilities.typeCode(ed.getType())));
            }
            StructureDefinition profile = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(ed.getType().get(0).getWorkingCode()));
            ccmp = new ElementDefinitionComparer(false, profile.getSnapshot().getElement(), ed.getType().get(0).getWorkingCode(), child.getSelf().getPath().length(), cmp.name, profile.present());
        } else if (!child.getSelf().hasType() && ed.getType().get(0).getWorkingCode().equals("Reference")) {
            for (ElementDefinition.TypeRefComponent t : ed.getType()) {
                if (t.getWorkingCode().equals("Reference")) continue;
                throw new Error(this.context.formatMessage("Not_handled_yet_sortElements_", ed.getPath(), ProfileUtilities.typeCode(ed.getType())));
            }
            StructureDefinition profile = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(ed.getType().get(0).getWorkingCode()));
            ccmp = new ElementDefinitionComparer(false, profile.getSnapshot().getElement(), ed.getType().get(0).getWorkingCode(), child.getSelf().getPath().length(), cmp.name, profile.present());
        } else {
            StructureDefinition profile = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs("Element"));
            if (profile == null) {
                throw new FHIRException(this.context.formatMessage("Unable_to_resolve_profile__in_element_", ProfileUtilities.sdNs(ed.getType().get(0).getWorkingCode()), ed.getPath()));
            }
            ccmp = new ElementDefinitionComparer(false, profile.getSnapshot().getElement(), "Element", child.getSelf().getPath().length(), cmp.name, profile.present());
        }
        return ccmp;
    }

    private String resolveType(String code) {
        StructureDefinition sd;
        if (Utilities.isAbsoluteUrl((String)code) && (sd = this.context.fetchResource(StructureDefinition.class, code)) != null) {
            return sd.getType();
        }
        return code;
    }

    private static String sdNs(String type) {
        return ProfileUtilities.sdNs(type, null);
    }

    public static String sdNs(String type, String overrideVersionNs) {
        if (Utilities.isAbsoluteUrl((String)type)) {
            return type;
        }
        if (overrideVersionNs != null) {
            return Utilities.pathURL((String[])new String[]{overrideVersionNs, type});
        }
        return "http://hl7.org/fhir/StructureDefinition/" + type;
    }

    private boolean isAbstract(String code) {
        return code.equals("Element") || code.equals("BackboneElement") || code.equals("Resource") || code.equals("DomainResource");
    }

    private void writeElements(ElementDefinitionHolder edh, List<ElementDefinition> list) {
        if (!edh.isPlaceHolder()) {
            list.add(edh.getSelf());
        }
        for (ElementDefinitionHolder child : edh.getChildren()) {
            this.writeElements(child, list);
        }
    }

    public void generateSchematrons(OutputStream dest, StructureDefinition structure) throws IOException, DefinitionException {
        if (structure.getDerivation() != StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            throw new DefinitionException(this.context.formatMessage("not_the_right_kind_of_structure_to_generate_schematrons_for", new Object[0]));
        }
        if (!structure.hasSnapshot()) {
            throw new DefinitionException(this.context.formatMessage("needs_a_snapshot", new Object[0]));
        }
        StructureDefinition base = this.context.fetchResource(StructureDefinition.class, structure.getBaseDefinition(), structure);
        if (base != null) {
            SchematronWriter sch = new SchematronWriter(dest, SchematronWriter.SchematronType.PROFILE, base.getName());
            ElementDefinition ed = structure.getSnapshot().getElement().get(0);
            this.generateForChildren(sch, "f:" + ed.getPath(), ed, structure, base);
            sch.dump();
        }
    }

    public void generateCsv(OutputStream dest, StructureDefinition structure, boolean asXml) throws IOException, DefinitionException, Exception {
        if (!structure.hasSnapshot()) {
            throw new DefinitionException(this.context.formatMessage("needs_a_snapshot", new Object[0]));
        }
        CSVWriter csv = new CSVWriter(dest, structure, asXml);
        for (ElementDefinition child : structure.getSnapshot().getElement()) {
            csv.processElement(null, child);
        }
        csv.dump();
    }

    public void addToCSV(CSVWriter csv, StructureDefinition structure) throws IOException, DefinitionException, Exception {
        if (!structure.hasSnapshot()) {
            throw new DefinitionException(this.context.formatMessage("needs_a_snapshot", new Object[0]));
        }
        for (ElementDefinition child : structure.getSnapshot().getElement()) {
            csv.processElement(structure, child);
        }
    }

    private Slicer generateSlicer(ElementDefinition child, ElementDefinition.ElementDefinitionSlicingComponent slicing, StructureDefinition structure) {
        if (child.getPath().endsWith(".extension")) {
            ElementDefinition ued = this.getUrlFor(structure, child);
            if (!(ued != null && ued.hasFixed() || child.hasType() && child.getType().get(0).hasProfile())) {
                return new Slicer(false);
            }
            Slicer s = new Slicer(true);
            String url = ued == null || !ued.hasFixed() ? (String)child.getType().get(0).getProfile().get(0).getValue() : ((UriType)ued.getFixed()).asStringValue();
            s.name = " with URL = '" + url + "'";
            s.criteria = "[@url = '" + url + "']";
            return s;
        }
        return new Slicer(false);
    }

    private void generateForChildren(SchematronWriter sch, String xpath, ElementDefinition ed, StructureDefinition structure, StructureDefinition base) throws IOException {
        String name;
        List<ElementDefinition> children = this.getChildList(structure, ed);
        String sliceName = null;
        ElementDefinition.ElementDefinitionSlicingComponent slicing = null;
        for (ElementDefinition child : children) {
            Slicer slicer;
            name = this.tail(child.getPath());
            if (child.hasSlicing()) {
                sliceName = name;
                slicing = child.getSlicing();
            } else if (!name.equals(sliceName)) {
                slicing = null;
            }
            ElementDefinition based = this.getByPath(base, child.getPath());
            boolean doMin = child.getMin() > 0 && (based == null || child.getMin() != based.getMin());
            boolean doMax = child.hasMax() && !child.getMax().equals("*") && (based == null || !child.getMax().equals(based.getMax()));
            Slicer slicer2 = slicer = slicing == null ? new Slicer(true) : this.generateSlicer(child, slicing, structure);
            if (!slicer.check || !doMin && !doMax) continue;
            SchematronWriter.Section s = sch.section(xpath);
            SchematronWriter.Rule r = s.rule(xpath);
            if (doMin) {
                r.assrt("count(f:" + name + slicer.criteria + ") >= " + Integer.toString(child.getMin()), name + slicer.name + ": minimum cardinality of '" + name + "' is " + Integer.toString(child.getMin()));
            }
            if (!doMax) continue;
            r.assrt("count(f:" + name + slicer.criteria + ") <= " + child.getMax(), name + slicer.name + ": maximum cardinality of '" + name + "' is " + child.getMax());
        }
        if (!ed.hasContentReference()) {
            for (ElementDefinition child : children) {
                name = this.tail(child.getPath());
                this.generateForChildren(sch, xpath + "/f:" + name, child, structure, base);
            }
        }
    }

    private ElementDefinition getByPath(StructureDefinition base, String path) {
        for (ElementDefinition ed : base.getSnapshot().getElement()) {
            if (ed.getPath().equals(path)) {
                return ed;
            }
            if (!ed.getPath().endsWith("[x]") || ed.getPath().length() > path.length() - 3 || !ed.getPath().substring(0, ed.getPath().length() - 3).equals(path.substring(0, ed.getPath().length() - 3))) continue;
            return ed;
        }
        return null;
    }

    public void setIds(StructureDefinition sd, boolean checkFirst) throws DefinitionException {
        if (!checkFirst || !sd.hasDifferential() || this.hasMissingIds(sd.getDifferential().getElement())) {
            if (!sd.hasDifferential()) {
                sd.setDifferential(new StructureDefinition.StructureDefinitionDifferentialComponent());
            }
            this.generateIds(sd.getDifferential().getElement(), sd.getUrl(), sd.getType(), sd);
        }
        if (!checkFirst || !sd.hasSnapshot() || this.hasMissingIds(sd.getSnapshot().getElement())) {
            if (!sd.hasSnapshot()) {
                sd.setSnapshot(new StructureDefinition.StructureDefinitionSnapshotComponent());
            }
            this.generateIds(sd.getSnapshot().getElement(), sd.getUrl(), sd.getType(), sd);
        }
    }

    private boolean hasMissingIds(List<ElementDefinition> list) {
        for (ElementDefinition ed : list) {
            if (ed.hasId()) continue;
            return true;
        }
        return false;
    }

    protected void generateIds(List<ElementDefinition> list, String name, String type, StructureDefinition srcSD) throws DefinitionException {
        if (list.isEmpty()) {
            return;
        }
        HashMap<String, String> idList = new HashMap<String, String>();
        HashMap<String, String> replacedIds = new HashMap<String, String>();
        SliceList sliceInfo = new SliceList();
        for (ElementDefinition ed : list) {
            String s;
            ArrayList<String> paths = new ArrayList<String>();
            if (!ed.hasPath()) {
                throw new DefinitionException(this.context.formatMessage("No_path_on_element_Definition__in_", Integer.toString(list.indexOf(ed)), name));
            }
            sliceInfo.seeElement(ed);
            String[] pl = ed.getPath().split("\\.");
            for (int i = paths.size(); i < pl.length; ++i) {
                paths.add(pl[i]);
            }
            String[] slices = sliceInfo.analyse(paths);
            StringBuilder b = new StringBuilder();
            b.append((String)paths.get(0));
            for (int i = 1; i < paths.size(); ++i) {
                b.append(".");
                s = (String)paths.get(i);
                String p = slices[i];
                b.append(this.fixChars(s));
                if (p == null) continue;
                b.append(":");
                b.append(p);
            }
            String bs = b.toString();
            if (ed.hasId()) {
                replacedIds.put(ed.getId(), ed.getPath());
            }
            ed.setId(bs);
            if (idList.containsKey(bs)) {
                if (this.exception || this.messages == null) {
                    throw new DefinitionException(this.context.formatMessage("Same_id_on_multiple_elements__in_", bs, idList.get(bs), ed.getPath(), name));
                }
                this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, name + "." + bs, "Duplicate Element id " + bs, ValidationMessage.IssueSeverity.ERROR));
            }
            idList.put(bs, ed.getPath());
            if (!ed.hasContentReference() || !ed.getContentReference().startsWith("#")) continue;
            s = ed.getContentReference();
            String typeURL = this.getUrlForSource(type, srcSD);
            if (replacedIds.containsKey(s.substring(1))) {
                ed.setContentReference(typeURL + "#" + (String)replacedIds.get(s.substring(1)));
                continue;
            }
            ed.setContentReference(typeURL + s);
        }
    }

    private String getUrlForSource(String type, StructureDefinition srcSD) {
        if (srcSD.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL) {
            return srcSD.getUrl();
        }
        return "http://hl7.org/fhir/StructureDefinition/" + type;
    }

    private Object fixChars(String s) {
        return s.replace("_", "-");
    }

    private static String urlTail(String profile) {
        return profile.contains("/") ? profile.substring(profile.lastIndexOf("/") + 1) : profile;
    }

    public List<org.hl7.fhir.r5.elementmodel.Element> generateExamples(StructureDefinition sd, boolean evenWhenNoExamples) throws FHIRException {
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> examples = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        if (sd.hasSnapshot()) {
            if (evenWhenNoExamples || this.hasAnyExampleValues(sd)) {
                examples.add(this.generateExample(sd, new BaseExampleValueAccessor()));
            }
            for (int i = 1; i <= 50; ++i) {
                if (!this.hasAnyExampleValues(sd, Integer.toString(i))) continue;
                examples.add(this.generateExample(sd, new ExtendedExampleValueAccessor(Integer.toString(i))));
            }
        }
        return examples;
    }

    private org.hl7.fhir.r5.elementmodel.Element generateExample(StructureDefinition profile, ExampleValueAccessor accessor) throws FHIRException {
        ElementDefinition ed = profile.getSnapshot().getElementFirstRep();
        org.hl7.fhir.r5.elementmodel.Element r = new org.hl7.fhir.r5.elementmodel.Element(ed.getPath(), new Property(this.context, ed, profile));
        SourcedChildDefinitions children = this.getChildMap(profile, ed);
        for (ElementDefinition child : children.getList()) {
            if (child.getPath().endsWith(".id")) {
                org.hl7.fhir.r5.elementmodel.Element id = new org.hl7.fhir.r5.elementmodel.Element("id", new Property(this.context, child, profile));
                id.setValue(profile.getId() + accessor.getId());
                r.getChildren().add(id);
                continue;
            }
            org.hl7.fhir.r5.elementmodel.Element e = this.createExampleElement(profile, child, accessor);
            if (e == null) continue;
            r.getChildren().add(e);
        }
        return r;
    }

    private org.hl7.fhir.r5.elementmodel.Element createExampleElement(StructureDefinition profile, ElementDefinition ed, ExampleValueAccessor accessor) throws FHIRException {
        DataType v = accessor.getExampleValue(ed);
        if (v != null) {
            return new ObjectConverter(this.context).convert(new Property(this.context, ed, profile), v);
        }
        org.hl7.fhir.r5.elementmodel.Element res = new org.hl7.fhir.r5.elementmodel.Element(this.tail(ed.getPath()), new Property(this.context, ed, profile));
        boolean hasValue = false;
        SourcedChildDefinitions children = this.getChildMap(profile, ed);
        for (ElementDefinition child : children.getList()) {
            org.hl7.fhir.r5.elementmodel.Element e;
            if (child.hasContentReference() || (e = this.createExampleElement(profile, child, accessor)) == null) continue;
            hasValue = true;
            res.getChildren().add(e);
        }
        if (hasValue) {
            return res;
        }
        return null;
    }

    private boolean hasAnyExampleValues(StructureDefinition sd, String index) {
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            for (Extension ex : ed.getExtension()) {
                String ndx = ToolingExtensions.readStringExtension(ex, "index");
                Extension exv = ToolingExtensions.getExtension(ex, "exValue");
                if (exv == null) continue;
                DataType value = exv.getValue();
                if (!index.equals(ndx) || value == null) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAnyExampleValues(StructureDefinition sd) {
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!ed.hasExample()) continue;
            return true;
        }
        return false;
    }

    public void populateLogicalSnapshot(StructureDefinition sd) throws FHIRException {
        sd.getSnapshot().getElement().add(sd.getDifferential().getElementFirstRep().copy());
        if (sd.hasBaseDefinition()) {
            StructureDefinition base = this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition(), sd);
            if (base == null) {
                throw new FHIRException(this.context.formatMessage("Unable_to_find_base_definition_for_logical_model__from_", sd.getBaseDefinition(), sd.getUrl()));
            }
            this.copyElements(sd, base.getSnapshot().getElement());
        }
        this.copyElements(sd, sd.getDifferential().getElement());
    }

    private void copyElements(StructureDefinition sd, List<ElementDefinition> list) {
        for (ElementDefinition ed : list) {
            if (!ed.getPath().contains(".")) continue;
            ElementDefinition n = ed.copy();
            n.setPath(sd.getSnapshot().getElementFirstRep().getPath() + "." + ed.getPath().substring(ed.getPath().indexOf(".") + 1));
            sd.getSnapshot().addElement(n);
        }
    }

    public void cleanUpDifferential(StructureDefinition sd) {
        if (sd.getDifferential().getElement().size() > 1) {
            this.cleanUpDifferential(sd, 1);
        }
    }

    private void cleanUpDifferential(StructureDefinition sd, int start) {
        int level = Utilities.charCount((String)sd.getDifferential().getElement().get(start).getPath(), (char)'.');
        int c = start;
        int len = sd.getDifferential().getElement().size();
        HashSet<String> paths = new HashSet<String>();
        while (c < len && Utilities.charCount((String)sd.getDifferential().getElement().get(c).getPath(), (char)'.') == level) {
            ElementDefinition ed = sd.getDifferential().getElement().get(c);
            if (!paths.contains(ed.getPath())) {
                int ic;
                paths.add(ed.getPath());
                for (ic = c + 1; ic < len && Utilities.charCount((String)sd.getDifferential().getElement().get(ic).getPath(), (char)'.') > level; ++ic) {
                }
                ElementDefinition slicer = null;
                ArrayList<ElementDefinition> slices = new ArrayList<ElementDefinition>();
                slices.add(ed);
                while (ic < len && Utilities.charCount((String)sd.getDifferential().getElement().get(ic).getPath(), (char)'.') == level) {
                    ElementDefinition edi = sd.getDifferential().getElement().get(ic);
                    if (ed.getPath().equals(edi.getPath())) {
                        if (slicer == null) {
                            slicer = new ElementDefinition();
                            slicer.setPath(edi.getPath());
                            slicer.getSlicing().setRules(ElementDefinition.SlicingRules.OPEN);
                            sd.getDifferential().getElement().add(c, slicer);
                            ++c;
                            ++ic;
                        }
                        slices.add(edi);
                    }
                    ++ic;
                    while (ic < len && Utilities.charCount((String)sd.getDifferential().getElement().get(ic).getPath(), (char)'.') > level) {
                        ++ic;
                    }
                }
                if (slicer != null) {
                    this.determineSlicing(slicer, slices);
                }
            }
            if (++c >= len || Utilities.charCount((String)sd.getDifferential().getElement().get(c).getPath(), (char)'.') <= level) continue;
            this.cleanUpDifferential(sd, c);
            ++c;
            while (c < len && Utilities.charCount((String)sd.getDifferential().getElement().get(c).getPath(), (char)'.') > level) {
                ++c;
            }
        }
    }

    private void determineSlicing(ElementDefinition slicer, List<ElementDefinition> slices) {
        int i = 0;
        for (ElementDefinition ed : slices) {
            if (ed.hasUserData("slice-name")) {
                ed.setSliceName(ed.getUserString("slice-name"));
                continue;
            }
            ed.setSliceName("slice-" + Integer.toString(++i));
        }
        if (slicer.getPath().endsWith(".extension") || slicer.getPath().endsWith(".modifierExtension")) {
            slicer.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.VALUE).setPath("url");
        } else if (slicer.getPath().equals("DiagnosticReport.result")) {
            slicer.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.VALUE).setPath("reference.code");
        } else if (slicer.getPath().equals("Observation.related")) {
            slicer.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.VALUE).setPath("target.reference.code");
        } else if (slicer.getPath().equals("Bundle.entry")) {
            slicer.getSlicing().addDiscriminator().setType(ElementDefinition.DiscriminatorType.VALUE).setPath("resource.@profile");
        } else {
            throw new Error("No slicing for " + slicer.getPath());
        }
    }

    public static ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent interpretR2Discriminator(String discriminator, boolean isExists) {
        if (discriminator.endsWith("@pattern")) {
            return ProfileUtilities.makeDiscriminator(ElementDefinition.DiscriminatorType.PATTERN, discriminator.length() == 8 ? "" : discriminator.substring(0, discriminator.length() - 9));
        }
        if (discriminator.endsWith("@profile")) {
            return ProfileUtilities.makeDiscriminator(ElementDefinition.DiscriminatorType.PROFILE, discriminator.length() == 8 ? "" : discriminator.substring(0, discriminator.length() - 9));
        }
        if (discriminator.endsWith("@type")) {
            return ProfileUtilities.makeDiscriminator(ElementDefinition.DiscriminatorType.TYPE, discriminator.length() == 5 ? "" : discriminator.substring(0, discriminator.length() - 6));
        }
        if (discriminator.endsWith("@exists")) {
            return ProfileUtilities.makeDiscriminator(ElementDefinition.DiscriminatorType.EXISTS, discriminator.length() == 7 ? "" : discriminator.substring(0, discriminator.length() - 8));
        }
        if (isExists) {
            return ProfileUtilities.makeDiscriminator(ElementDefinition.DiscriminatorType.EXISTS, discriminator);
        }
        return new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent().setType(ElementDefinition.DiscriminatorType.VALUE).setPath(discriminator);
    }

    private static ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent makeDiscriminator(ElementDefinition.DiscriminatorType dType, String str) {
        return new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent().setType(dType).setPath(Utilities.noString((String)str) ? "$this" : str);
    }

    public static String buildR2Discriminator(ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t) throws FHIRException {
        switch (t.getType()) {
            case PROFILE: {
                return t.getPath() + "/@profile";
            }
            case PATTERN: {
                return t.getPath() + "/@pattern";
            }
            case TYPE: {
                return t.getPath() + "/@type";
            }
            case VALUE: {
                return t.getPath();
            }
            case EXISTS: {
                return t.getPath();
            }
        }
        throw new FHIRException("Unable to represent " + t.getType().toCode() + ":" + t.getPath() + " in R2");
    }

    public static StructureDefinition makeExtensionForVersionedURL(IWorkerContext context, String url) {
        String epath = url.substring(54);
        if (!epath.contains(".")) {
            return null;
        }
        String type = epath.substring(0, epath.indexOf("."));
        StructureDefinition sd = context.fetchTypeDefinition(type);
        if (sd == null) {
            return null;
        }
        ElementDefinition ed = null;
        for (ElementDefinition t : sd.getSnapshot().getElement()) {
            if (!t.getPath().equals(epath)) continue;
            ed = t;
            break;
        }
        if (ed == null) {
            return null;
        }
        if ("Element".equals(ed.typeSummary()) || "BackboneElement".equals(ed.typeSummary())) {
            return null;
        }
        StructureDefinition template = context.fetchResource(StructureDefinition.class, "http://fhir-registry.smarthealthit.org/StructureDefinition/capabilities");
        StructureDefinition ext = template.copy();
        ext.setUrl(url);
        ext.setId("extension-" + epath);
        ext.setName("Extension-" + epath);
        ext.setTitle("Extension for r4 " + epath);
        ext.setStatus(sd.getStatus());
        ext.setDate(sd.getDate());
        ext.getContact().clear();
        ext.getContact().addAll(sd.getContact());
        ext.setFhirVersion(sd.getFhirVersion());
        ext.setDescription(ed.getDefinition());
        ext.getContext().clear();
        ext.addContext().setType(StructureDefinition.ExtensionContextType.ELEMENT).setExpression(epath.substring(0, epath.lastIndexOf(".")));
        ext.getDifferential().getElement().clear();
        ext.getSnapshot().getElement().get(3).setFixed(new UriType(url));
        ext.getSnapshot().getElement().set(4, ed.copy());
        ext.getSnapshot().getElement().get(4).setPath("Extension.value" + Utilities.capitalize((String)ed.typeSummary()));
        return ext;
    }

    public boolean isThrowException() {
        return this.exception;
    }

    public void setThrowException(boolean exception) {
        this.exception = exception;
    }

    public ValidationOptions getTerminologyServiceOptions() {
        return this.terminologyServiceOptions;
    }

    public void setTerminologyServiceOptions(ValidationOptions terminologyServiceOptions) {
        this.terminologyServiceOptions = terminologyServiceOptions;
    }

    public boolean isNewSlicingProcessing() {
        return this.newSlicingProcessing;
    }

    public ProfileUtilities setNewSlicingProcessing(boolean newSlicingProcessing) {
        this.newSlicingProcessing = newSlicingProcessing;
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getDefWebRoot() {
        return this.defWebRoot;
    }

    public void setDefWebRoot(String defWebRoot) {
        this.defWebRoot = defWebRoot;
        if (!this.defWebRoot.endsWith("/")) {
            this.defWebRoot = this.defWebRoot + "/";
        }
    }

    public static StructureDefinition makeBaseDefinition(Enumerations.FHIRVersion fhirVersion) {
        return ProfileUtilities.makeBaseDefinition(fhirVersion.toCode());
    }

    public static StructureDefinition makeBaseDefinition(String fhirVersion) {
        StructureDefinition base = new StructureDefinition();
        base.setId("Base");
        base.setUrl("http://hl7.org/fhir/StructureDefinition/Base");
        base.setVersion(fhirVersion);
        base.setName("Base");
        base.setStatus(Enumerations.PublicationStatus.ACTIVE);
        base.setDate(new Date());
        base.setFhirVersion(Enumerations.FHIRVersion.fromCode(fhirVersion));
        base.setKind(StructureDefinition.StructureDefinitionKind.COMPLEXTYPE);
        base.setAbstract(true);
        base.setType("Base");
        base.setUserData("path", "http://build.fhir.org/types.html#Base");
        ElementDefinition e = base.getSnapshot().getElementFirstRep();
        e.setId("Base");
        e.setPath("Base");
        e.setMin(0);
        e.setMax("*");
        e.getBase().setPath("Base");
        e.getBase().setMin(0);
        e.getBase().setMax("*");
        e.setIsModifier(false);
        e = base.getDifferential().getElementFirstRep();
        e.setId("Base");
        e.setPath("Base");
        e.setMin(0);
        e.setMax("*");
        return base;
    }

    public XVerExtensionManager getXver() {
        return this.xver;
    }

    public ProfileUtilities setXver(XVerExtensionManager xver) {
        this.xver = xver;
        return this;
    }

    private List<ElementChoiceGroup> readChoices(ElementDefinition ed, List<ElementDefinition> children) {
        ArrayList<ElementChoiceGroup> result = new ArrayList<ElementChoiceGroup>();
        for (ElementDefinition.ElementDefinitionConstraintComponent c : ed.getConstraint()) {
            ElementChoiceGroup grp = this.processConstraint(children, c);
            if (grp == null) continue;
            result.add(grp);
        }
        return result;
    }

    public ElementChoiceGroup processConstraint(List<ElementDefinition> children, ElementDefinition.ElementDefinitionConstraintComponent c) {
        if (!c.hasExpression()) {
            return null;
        }
        ExpressionNode expr = null;
        try {
            expr = this.fpe.parse(c.getExpression());
        }
        catch (Exception e) {
            return null;
        }
        if (expr.getKind() != ExpressionNode.Kind.Group || expr.getOpNext() == null || expr.getOperation() != ExpressionNode.Operation.Equals && expr.getOperation() != ExpressionNode.Operation.LessOrEqual) {
            return null;
        }
        ExpressionNode n2 = expr.getOpNext();
        if (n2.getKind() != ExpressionNode.Kind.Constant || n2.getInner() != null || n2.getOpNext() != null || !"1".equals(n2.getConstant().primitiveValue())) {
            return null;
        }
        ElementChoiceGroup grp = new ElementChoiceGroup(c.getKey(), expr.getOperation() == ExpressionNode.Operation.Equals);
        for (ExpressionNode n1 = expr.getGroup(); n1 != null; n1 = n1.getOpNext()) {
            if (n1.getKind() != ExpressionNode.Kind.Name || n1.getInner() != null) {
                return null;
            }
            grp.elements.add(n1.getName());
            if (n1.getOperation() == null || n1.getOperation() == ExpressionNode.Operation.Union) {
                continue;
            }
            return null;
        }
        int total = 0;
        for (String n : grp.elements) {
            boolean found = false;
            for (ElementDefinition child : children) {
                String name = this.tail(child.getPath());
                if (!n.equals(name)) continue;
                found = true;
                if ("0".equals(child.getMax())) continue;
                ++total;
            }
            if (found) continue;
            return null;
        }
        if (total <= 1) {
            return null;
        }
        return grp;
    }

    public Set<String> getMasterSourceFileNames() {
        return this.masterSourceFileNames;
    }

    public void setMasterSourceFileNames(Set<String> masterSourceFileNames) {
        this.masterSourceFileNames = masterSourceFileNames;
    }

    public ProfileKnowledgeProvider getPkp() {
        return this.pkp;
    }

    public String getRowColor(ElementDefinition element, boolean isConstraintMode) {
        switch (element.getUserInt(UD_ERROR_STATUS)) {
            case 1: {
                return ROW_COLOR_HINT;
            }
            case 2: {
                return ROW_COLOR_WARNING;
            }
            case 3: {
                return ROW_COLOR_ERROR;
            }
            case 4: {
                return ROW_COLOR_FATAL;
            }
        }
        if (isConstraintMode && !element.getMustSupport() && !element.getIsModifier() && element.getPath().contains(".")) {
            return null;
        }
        return null;
    }

    private class ExtendedExampleValueAccessor
    implements ExampleValueAccessor {
        private String index;

        public ExtendedExampleValueAccessor(String index) {
            this.index = index;
        }

        @Override
        public DataType getExampleValue(ElementDefinition ed) {
            if (ed.hasFixed()) {
                return ed.getFixed();
            }
            for (Extension ex : ed.getExtension()) {
                String ndx = ToolingExtensions.readStringExtension(ex, "index");
                DataType value = ToolingExtensions.getExtension(ex, "exValue").getValue();
                if (!this.index.equals(ndx) || value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public String getId() {
            return "-genexample-" + this.index;
        }
    }

    private class BaseExampleValueAccessor
    implements ExampleValueAccessor {
        private BaseExampleValueAccessor() {
        }

        @Override
        public DataType getExampleValue(ElementDefinition ed) {
            if (ed.hasFixed()) {
                return ed.getFixed();
            }
            if (ed.hasExample()) {
                return ed.getExample().get(0).getValue();
            }
            return null;
        }

        @Override
        public String getId() {
            return "-genexample";
        }
    }

    private static interface ExampleValueAccessor {
        public DataType getExampleValue(ElementDefinition var1);

        public String getId();
    }

    private class SliceList {
        private Map<String, String> slices = new HashMap<String, String>();

        private SliceList() {
        }

        public void seeElement(ElementDefinition ed) {
            Iterator<Map.Entry<String, String>> iter = this.slices.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                if (entry.getKey().length() <= ed.getPath().length() && !entry.getKey().equals(ed.getPath())) continue;
                iter.remove();
            }
            if (ed.hasSliceName()) {
                this.slices.put(ed.getPath(), ed.getSliceName());
            }
        }

        public String[] analyse(List<String> paths) {
            Object s = paths.get(0);
            String[] res = new String[paths.size()];
            res[0] = null;
            for (int i = 1; i < paths.size(); ++i) {
                res[i] = this.slices.containsKey(s = (String)s + "." + paths.get(i)) ? this.slices.get(s) : null;
            }
            return res;
        }
    }

    private class Slicer
    extends ElementDefinition.ElementDefinitionSlicingComponent {
        String criteria = "";
        String name = "";
        boolean check;

        public Slicer(boolean cantCheck) {
            this.check = cantCheck;
        }
    }

    private static class ElementNameCompare
    implements Comparator<ElementDefinition> {
        private ElementNameCompare() {
        }

        @Override
        public int compare(ElementDefinition o1, ElementDefinition o2) {
            String path2;
            String path1 = ElementNameCompare.normalizePath(o1);
            int cmp = path1.compareTo(path2 = ElementNameCompare.normalizePath(o2));
            if (cmp == 0) {
                String name1 = o1.hasSliceName() ? o1.getSliceName() : "";
                String name2 = o2.hasSliceName() ? o2.getSliceName() : "";
                cmp = name1.compareTo(name2);
            }
            return cmp;
        }

        private static String normalizePath(ElementDefinition e) {
            if (!e.hasPath()) {
                return "";
            }
            String path = e.getPath();
            if (path.endsWith("[x]")) {
                path = path.substring(0, path.length() - 3);
            }
            return path;
        }
    }

    private static class ElementDefinitionComparer
    implements Comparator<ElementDefinitionHolder> {
        private boolean inExtension;
        private List<ElementDefinition> snapshot;
        private int prefixLength;
        private String base;
        private String name;
        private String baseName;
        private Set<String> errors = new HashSet<String>();

        public ElementDefinitionComparer(boolean inExtension, List<ElementDefinition> snapshot, String base, int prefixLength, String name, String baseName) {
            this.inExtension = inExtension;
            this.snapshot = snapshot;
            this.prefixLength = prefixLength;
            this.base = base;
            if (Utilities.isAbsoluteUrl((String)base)) {
                this.base = ProfileUtilities.urlTail(base);
            }
            this.name = name;
            this.baseName = baseName;
        }

        @Override
        public int compare(ElementDefinitionHolder o1, ElementDefinitionHolder o2) {
            if (o1.getBaseIndex() == 0) {
                o1.setBaseIndex(this.find(o1.getSelf().getPath(), true));
            }
            if (o2.getBaseIndex() == 0) {
                o2.setBaseIndex(this.find(o2.getSelf().getPath(), true));
            }
            return o1.getBaseIndex() - o2.getBaseIndex();
        }

        private int find(String path, boolean mandatory) {
            String op = path;
            int lc = 0;
            String actual = this.base + ((String)path).substring(this.prefixLength);
            for (int i = 0; i < this.snapshot.size(); ++i) {
                String p = this.snapshot.get(i).getPath();
                if (p.equals(actual)) {
                    return i;
                }
                if (p.endsWith("[x]") && actual.startsWith(p.substring(0, p.length() - 3)) && !actual.endsWith("[x]") && !actual.substring(p.length() - 3).contains(".")) {
                    return i;
                }
                if (actual.endsWith("[x]") && p.startsWith(actual.substring(0, actual.length() - 3)) && !p.substring(actual.length() - 3).contains(".")) {
                    return i;
                }
                if (!((String)path).startsWith(p + ".") || !this.snapshot.get(i).hasContentReference()) continue;
                String ref = this.snapshot.get(i).getContentReference();
                if (ref.substring(1, 2).toUpperCase().equals(ref.substring(1, 2))) {
                    actual = this.base + (ref.substring(1) + "." + ((String)path).substring(p.length() + 1)).substring(this.prefixLength);
                    path = actual;
                } else if (ref.startsWith("http:")) {
                    actual = this.base + (ref.substring(ref.indexOf("#") + 1) + "." + ((String)path).substring(p.length() + 1)).substring(this.prefixLength);
                    path = actual;
                } else {
                    actual = this.base + (((String)path).substring(0, ((String)path).indexOf(".") + 1) + ref.substring(1) + "." + ((String)path).substring(p.length() + 1)).substring(this.prefixLength);
                    path = actual;
                }
                i = 0;
                if (++lc <= 10) continue;
                throw new Error("Internal recursion detection: find() loop path recursion > 10 - check paths are valid (for path " + (String)path + "/" + op + ")");
            }
            if (mandatory) {
                if (this.prefixLength == 0) {
                    this.errors.add("Differential contains path " + (String)path + " which is not found in the in base " + this.baseName);
                } else {
                    this.errors.add("Differential contains path " + (String)path + " which is actually " + actual + ", which is not found in the in base " + this.baseName);
                }
            }
            return 0;
        }

        public void checkForErrors(List<String> errorList) {
            if (this.errors.size() > 0) {
                for (String s : this.errors) {
                    if (s.startsWith("!")) {
                        errorList.add("!StructureDefinition " + this.name + ": " + s.substring(1));
                        continue;
                    }
                    errorList.add("StructureDefinition " + this.name + ": " + s);
                }
            }
        }
    }

    private static class ElementDefinitionHolder {
        private String name;
        private ElementDefinition self;
        private int baseIndex = 0;
        private List<ElementDefinitionHolder> children;
        private boolean placeHolder = false;

        public ElementDefinitionHolder(ElementDefinition self, boolean isPlaceholder) {
            this.self = self;
            this.name = self.getPath();
            this.placeHolder = isPlaceholder;
            this.children = new ArrayList<ElementDefinitionHolder>();
        }

        public ElementDefinitionHolder(ElementDefinition self) {
            this(self, false);
        }

        public ElementDefinition getSelf() {
            return this.self;
        }

        public List<ElementDefinitionHolder> getChildren() {
            return this.children;
        }

        public int getBaseIndex() {
            return this.baseIndex;
        }

        public void setBaseIndex(int baseIndex) {
            this.baseIndex = baseIndex;
        }

        public boolean isPlaceHolder() {
            return this.placeHolder;
        }

        public String toString() {
            if (this.self.hasSliceName()) {
                return this.self.getPath() + "(" + this.self.getSliceName() + ")";
            }
            return this.self.getPath();
        }
    }

    public static class ExtensionContext {
        private ElementDefinition element;
        private StructureDefinition defn;

        public ExtensionContext(StructureDefinition ext, ElementDefinition ed) {
            this.defn = ext;
            this.element = ed;
        }

        public ElementDefinition getElement() {
            return this.element;
        }

        public StructureDefinition getDefn() {
            return this.defn;
        }

        public String getUrl() {
            if (this.element == this.defn.getSnapshot().getElement().get(0)) {
                return this.defn.getUrl();
            }
            return this.element.getSliceName();
        }

        public ElementDefinition getExtensionValueDefinition() {
            for (int i = this.defn.getSnapshot().getElement().indexOf(this.element) + 1; i < this.defn.getSnapshot().getElement().size(); ++i) {
                ElementDefinition ed = this.defn.getSnapshot().getElement().get(i);
                if (ed.getPath().equals(this.element.getPath())) {
                    return null;
                }
                if (!ed.getPath().startsWith(this.element.getPath() + ".value") || ed.hasSlicing()) continue;
                return ed;
            }
            return null;
        }
    }

    public static class ElementChoiceGroup {
        private HierarchicalTableGenerator.Row row;
        private String name;
        private boolean mandatory;
        private List<String> elements = new ArrayList<String>();

        public ElementChoiceGroup(String name, boolean mandatory) {
            this.name = name;
            this.mandatory = mandatory;
        }

        public HierarchicalTableGenerator.Row getRow() {
            return this.row;
        }

        public List<String> getElements() {
            return this.elements;
        }

        public void setRow(HierarchicalTableGenerator.Row row) {
            this.row = row;
        }

        public String getName() {
            return this.name;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public void setMandatory(boolean mandatory) {
            this.mandatory = mandatory;
        }
    }

    public class ElementDefinitionResolution {
        private StructureDefinition source;
        private ElementDefinition element;

        public ElementDefinitionResolution(StructureDefinition source, ElementDefinition element) {
            this.source = source;
            this.element = element;
        }

        public StructureDefinition getSource() {
            return this.source;
        }

        public ElementDefinition getElement() {
            return this.element;
        }
    }

    public static class SourcedChildDefinitions {
        private StructureDefinition source;
        private List<ElementDefinition> list;

        public SourcedChildDefinitions(StructureDefinition source, List<ElementDefinition> list) {
            this.source = source;
            this.list = list;
        }

        public StructureDefinition getSource() {
            return this.source;
        }

        public List<ElementDefinition> getList() {
            return this.list;
        }
    }
}

