/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.conformance;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class R5ExtensionsLoader {
    private BasePackageCacheManager pcm;
    private int count;
    private NpmPackage pck;
    private Map<String, Loadable<ValueSet>> valueSets;
    private Map<String, Loadable<CodeSystem>> codeSystems;
    private List<Loadable<StructureDefinition>> structures;
    private IWorkerContext context;
    private PackageInformation pd;
    private JsonParser json;

    public R5ExtensionsLoader(BasePackageCacheManager pcm, IWorkerContext context) {
        this.pcm = pcm;
        this.context = context;
        this.valueSets = new HashMap<String, Loadable<ValueSet>>();
        this.codeSystems = new HashMap<String, Loadable<CodeSystem>>();
        this.structures = new ArrayList<Loadable<StructureDefinition>>();
    }

    public void load() throws FHIRException, IOException {
        this.pck = this.pcm.loadPackage("hl7.fhir.r5.core", "current");
        this.pd = new PackageInformation(this.pck);
        String[] types = new String[]{"StructureDefinition", "ValueSet", "CodeSystem"};
        this.json = new JsonParser();
        for (NpmPackage.PackageResourceInformation pri : this.pck.listIndexedResources(types)) {
            if (pri.getResourceType().equals("CodeSystem")) {
                this.codeSystems.put(pri.getUrl(), new Loadable(pri));
                this.codeSystems.put(pri.getUrl() + "|" + pri.getVersion(), new Loadable(pri));
                continue;
            }
            if (pri.getResourceType().equals("ValueSet")) {
                this.valueSets.put(pri.getUrl(), new Loadable(pri));
                this.valueSets.put(pri.getUrl() + "|" + pri.getVersion(), new Loadable(pri));
                continue;
            }
            if (!pri.getResourceType().equals("StructureDefinition")) continue;
            this.structures.add(new Loadable(pri));
        }
    }

    public void loadR5Extensions() throws FHIRException, IOException {
        this.count = 0;
        List<String> typeNames = new ContextUtilities(this.context).getTypeNames();
        for (Loadable<StructureDefinition> lsd : this.structures) {
            StructureDefinition sd;
            if (!lsd.info.getStatedType().equals("Extension") || this.context.hasResource(StructureDefinition.class, lsd.info.getUrl()) || (sd = lsd.getResource()).getDerivation() != StructureDefinition.TypeDerivationRule.CONSTRAINT || !this.survivesStrippingTypes(sd, this.context, typeNames)) continue;
            ++this.count;
            sd.setUserData("path", Utilities.pathURL((String[])new String[]{this.pck.getWebLocation(), "extension-" + sd.getId().toLowerCase() + ".html"}));
            this.registerTerminologies(sd);
            this.context.cacheResourceFromPackage(sd, this.pd);
        }
    }

    public void loadR5SpecialTypes(List<String> types) throws FHIRException, IOException {
        for (Loadable<StructureDefinition> lsd : this.structures) {
            StructureDefinition sd = lsd.getResource();
            if (!Utilities.existsInList((String)sd.getType(), types)) continue;
            ++this.count;
            sd.setUserData("path", Utilities.pathURL((String[])new String[]{this.pck.getWebLocation(), sd.getId().toLowerCase() + ".html"}));
            this.registerTerminologies(sd);
            this.context.cacheResourceFromPackage(sd, this.pd);
        }
    }

    private void registerTerminologies(StructureDefinition sd) throws FHIRFormatError, FileNotFoundException, IOException {
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!ed.hasBinding() || !ed.getBinding().hasValueSet()) continue;
            String vsu = ed.getBinding().getValueSet();
            ValueSet vs = this.context.fetchResource(ValueSet.class, vsu);
            if (vs == null) {
                this.loadValueSet(vsu, this.context, this.valueSets, this.codeSystems, this.pd);
                continue;
            }
            if (!vs.hasVersion()) continue;
            ed.getBinding().setValueSet(vs.getUrl() + "|" + vs.getVersion());
        }
    }

    private void loadValueSet(String url, IWorkerContext context, Map<String, Loadable<ValueSet>> valueSets, Map<String, Loadable<CodeSystem>> codeSystems, PackageInformation pd) throws FHIRFormatError, FileNotFoundException, IOException {
        if (valueSets.containsKey(url)) {
            ValueSet vs = valueSets.get(url).getResource();
            context.cacheResourceFromPackage(vs, pd);
            for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
                for (CanonicalType t : inc.getValueSet()) {
                    this.loadValueSet(t.asStringValue(), context, valueSets, codeSystems, pd);
                }
                if (!inc.hasSystem() || inc.hasVersion()) continue;
                if (codeSystems.containsKey(inc.getSystem())) {
                    CodeSystem cs = codeSystems.get(inc.getSystem()).getResource();
                    inc.setVersion(cs.getVersion());
                    context.cacheResourceFromPackage(cs, pd);
                    continue;
                }
                if (context.hasResource(CodeSystem.class, inc.getSystem()) || !codeSystems.containsKey(inc.getSystem())) continue;
                context.cacheResourceFromPackage(codeSystems.get(inc.getSystem()).getResource(), pd);
            }
        }
    }

    private boolean survivesStrippingTypes(StructureDefinition sd, IWorkerContext context, List<String> typeNames) {
        for (ElementDefinition ed : sd.getDifferential().getElement()) {
            this.stripTypes(ed, context, typeNames);
        }
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (this.stripTypes(ed, context, typeNames)) continue;
            return false;
        }
        return true;
    }

    private boolean stripTypes(ElementDefinition ed, IWorkerContext context, List<String> typeNames) {
        if (!ed.getPath().contains(".") || !ed.hasType()) {
            return true;
        }
        ed.getType().removeIf(tr -> !typeNames.contains(tr.getWorkingCode()));
        if (!ed.hasType()) {
            return false;
        }
        for (ElementDefinition.TypeRefComponent tr2 : ed.getType()) {
            if (!tr2.hasTargetProfile()) continue;
            tr2.getTargetProfile().removeIf(n -> !context.hasResource(StructureDefinition.class, n.asStringValue()));
            if (tr2.hasTargetProfile()) continue;
            return false;
        }
        return true;
    }

    public BasePackageCacheManager getPcm() {
        return this.pcm;
    }

    public int getCount() {
        return this.count;
    }

    public byte[] getMap() throws IOException {
        return this.pck.hasFile("other", "spec.internals") ? TextFile.streamToBytes((InputStream)this.pck.load("other", "spec.internals")) : null;
    }

    public NpmPackage getPck() {
        return this.pck;
    }

    public class Loadable<T extends CanonicalResource> {
        private T resource;
        private NpmPackage.PackageResourceInformation info;

        public Loadable(NpmPackage.PackageResourceInformation info) {
            this.info = info;
        }

        public T getResource() throws FHIRFormatError, FileNotFoundException, IOException {
            if (this.resource == null) {
                CanonicalResource r = (CanonicalResource)R5ExtensionsLoader.this.json.parse(R5ExtensionsLoader.this.pck.load(this.info));
                r.setUserData("path", Utilities.pathURL((String[])new String[]{R5ExtensionsLoader.this.pck.getWebLocation(), r.fhirType().toLowerCase() + "-" + r.getId().toLowerCase() + ".html"}));
                this.resource = r;
            }
            return this.resource;
        }
    }

    public static class CanonicalResourceSortByUrl<T extends CanonicalResource>
    implements Comparator<Loadable<T>> {
        @Override
        public int compare(Loadable<T> arg0, Loadable<T> arg1) {
            return arg0.info.getUrl().compareTo(arg1.info.getUrl());
        }
    }
}

