/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.utils;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.Element;
import org.hl7.fhir.r4b.model.ElementDefinition;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Resource;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.utilities.Utilities;

public class FHIRPathUtilityClasses {

    public static class FunctionDetails {
        private String description;
        private int minParameters;
        private int maxParameters;

        public FunctionDetails(String description, int minParameters, int maxParameters) {
            this.description = description;
            this.minParameters = minParameters;
            this.maxParameters = maxParameters;
        }

        public String getDescription() {
            return this.description;
        }

        public int getMinParameters() {
            return this.minParameters;
        }

        public int getMaxParameters() {
            return this.maxParameters;
        }
    }

    public static class TypedElementDefinition {
        private ElementDefinition element;
        private String type;

        public TypedElementDefinition(ElementDefinition element, String type) {
            this.element = element;
            this.type = type;
        }

        public TypedElementDefinition(ElementDefinition element) {
            this.element = element;
        }

        public ElementDefinition getElement() {
            return this.element;
        }

        public String getType() {
            return this.type;
        }

        public List<ElementDefinition.TypeRefComponent> getTypes() {
            ArrayList<ElementDefinition.TypeRefComponent> res = new ArrayList<ElementDefinition.TypeRefComponent>();
            for (ElementDefinition.TypeRefComponent tr : this.element.getType()) {
                if (this.type != null && !this.type.equals(tr.getCode())) continue;
                res.add(tr);
            }
            return res;
        }

        public boolean hasType(String tn) {
            if (this.type != null) {
                return tn.equals(this.type);
            }
            for (ElementDefinition.TypeRefComponent t : this.element.getType()) {
                if (!tn.equals(t.getCode())) continue;
                return true;
            }
            return false;
        }
    }

    public static class ClassTypeInfo
    extends Base {
        private static final long serialVersionUID = 4909223114071029317L;
        private Base instance;

        public ClassTypeInfo(Base instance) {
            this.instance = instance;
        }

        @Override
        public String fhirType() {
            return "ClassInfo";
        }

        @Override
        protected void listChildren(List<Property> result) {
        }

        @Override
        public String getIdBase() {
            return null;
        }

        @Override
        public void setIdBase(String value) {
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            if (name.equals("name")) {
                return new Base[]{new StringType(this.getName())};
            }
            if (name.equals("namespace")) {
                return new Base[]{new StringType(this.getNamespace())};
            }
            return super.getProperty(hash, name, checkValid);
        }

        private String getNamespace() {
            if (this.instance instanceof Resource) {
                return "FHIR";
            }
            if (!(this.instance instanceof Element) || ((Element)this.instance).isDisallowExtensions()) {
                return "System";
            }
            return "FHIR";
        }

        private String getName() {
            if (this.instance instanceof Resource) {
                return this.instance.fhirType();
            }
            if (!(this.instance instanceof Element) || ((Element)this.instance).isDisallowExtensions()) {
                return Utilities.capitalize((String)this.instance.fhirType());
            }
            return this.instance.fhirType();
        }

        @Override
        public Base copy() {
            throw new Error("Not Implemented");
        }
    }

    public static class FHIRConstant
    extends Base {
        private static final long serialVersionUID = -8933773658248269439L;
        private String value;

        public FHIRConstant(String value) {
            this.value = value;
        }

        @Override
        public String fhirType() {
            return "%constant";
        }

        @Override
        protected void listChildren(List<Property> result) {
        }

        @Override
        public String getIdBase() {
            return null;
        }

        @Override
        public void setIdBase(String value) {
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public String primitiveValue() {
            return this.value;
        }

        @Override
        public Base copy() {
            throw new Error("Not Implemented");
        }
    }
}

