/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.Bundle;
import org.hl7.fhir.r4b.model.Composition;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Provenance;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.Resource;
import org.hl7.fhir.r4b.renderers.RendererFactory;
import org.hl7.fhir.r4b.renderers.ResourceRenderer;
import org.hl7.fhir.r4b.renderers.utils.BaseWrappers;
import org.hl7.fhir.r4b.renderers.utils.RenderingContext;
import org.hl7.fhir.r4b.renderers.utils.Resolver;
import org.hl7.fhir.r4b.utils.EOperationOutcome;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class BundleRenderer
extends ResourceRenderer {
    public BundleRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    public BundleRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public boolean render(XhtmlNode x, Resource r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        XhtmlNode n = this.render((Bundle)r);
        x.addChildren((List)n.getChildNodes());
        return false;
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return null;
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return null;
    }

    @Override
    public boolean render(XhtmlNode x, BaseWrappers.ResourceWrapper b) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        List<BaseWrappers.BaseWrapper> entries = b.children("entry");
        if ("document".equals(b.get("type").primitiveValue())) {
            if (entries.isEmpty() || entries.get(0).has("resource") && !"Composition".equals(entries.get(0).get("resource").fhirType())) {
                throw new FHIRException("Invalid document '" + b.getId() + "' - first entry is not a Composition ('" + entries.get(0).get("resource").fhirType() + "')");
            }
            return this.renderDocument(x, b, entries);
        }
        if (!"collection".equals(b.get("type").primitiveValue()) || !BundleRenderer.allEntriesAreHistoryProvenance(entries)) {
            XhtmlNode root = new XhtmlNode(NodeType.Element, "div");
            root.para().addText(this.formatMessage("RENDER_BUNDLE_HEADER_ROOT", b.getId(), b.get("type").primitiveValue()));
            int i = 0;
            for (BaseWrappers.BaseWrapper be : entries) {
                ++i;
                if (be.has("fullUrl")) {
                    root.an(BundleRenderer.makeInternalBundleLink(be.get("fullUrl").primitiveValue()));
                }
                if (be.has("resource") && be.getChildByName("resource").getValues().get(0).has("id")) {
                    root.an(be.get("resource").fhirType() + "_" + be.getChildByName("resource").getValues().get(0).get("id").primitiveValue());
                }
                root.hr();
                if (be.has("fullUrl")) {
                    root.para().addText(this.formatMessage("RENDER_BUNDLE_HEADER_ENTRY_URL", Integer.toString(i), be.get("fullUrl").primitiveValue()));
                } else {
                    root.para().addText(this.formatMessage("RENDER_BUNDLE_HEADER_ENTRY", Integer.toString(i)));
                }
                if (!be.has("resource")) continue;
                root.para().addText(this.formatMessage("RENDER_BUNDLE_RESOURCE", be.get("resource").fhirType()));
                BaseWrappers.ResourceWrapper rw = be.getChildByName("resource").getAsResource();
                XhtmlNode xn = rw.getNarrative();
                if (xn == null || xn.isEmpty()) {
                    ResourceRenderer rr = RendererFactory.factory(rw, this.context);
                    try {
                        xn = rr.render(rw);
                    }
                    catch (Exception e) {
                        xn = new XhtmlNode();
                        xn.para().b().tx("Exception generating narrative: " + e.getMessage());
                    }
                }
                root.blockquote().addChildren(xn);
            }
        }
        return false;
    }

    private boolean renderDocument(XhtmlNode x, BaseWrappers.ResourceWrapper b, List<BaseWrappers.BaseWrapper> entries) throws UnsupportedEncodingException, FHIRException, IOException, EOperationOutcome {
        BaseWrappers.ResourceWrapper comp = entries.get(0).getChildByName("resource").getAsResource();
        BaseWrappers.ResourceWrapper subject = this.resolveReference(entries, comp.get("subject"));
        if (subject != null) {
            if (subject.hasNarrative()) {
                x.addChildren(subject.getNarrative());
            } else {
                RendererFactory.factory(subject, this.context).render(x, subject);
            }
        }
        x.hr();
        if (comp.hasNarrative()) {
            x.addChildren(comp.getNarrative());
            x.hr();
        }
        List<BaseWrappers.BaseWrapper> sections = comp.children("section");
        for (BaseWrappers.BaseWrapper section : sections) {
            this.addSection(x, section, 2, false);
        }
        return false;
    }

    private void addSection(XhtmlNode x, BaseWrappers.BaseWrapper section, int level, boolean nested) throws UnsupportedEncodingException, FHIRException, IOException {
        if (section.has("title") || section.has("code") || section.has("text") || section.has("section")) {
            XhtmlNode div = x.div();
            if (section.has("title")) {
                div.h(level).tx(section.get("title").primitiveValue());
            } else if (section.has("code")) {
                this.renderBase(div.h(level), section.get("code"));
            }
            if (section.has("text")) {
                Base narrative = section.get("text");
                x.addChildren(narrative.getXhtml());
            }
            if (section.has("section")) {
                List<BaseWrappers.BaseWrapper> sections = section.children("section");
                for (BaseWrappers.BaseWrapper child : sections) {
                    if (nested) {
                        this.addSection(x.blockquote(), child, level + 1, true);
                        continue;
                    }
                    this.addSection(x, child, level + 1, true);
                }
            }
        }
    }

    private BaseWrappers.ResourceWrapper resolveReference(List<BaseWrappers.BaseWrapper> entries, Base base) throws UnsupportedEncodingException, FHIRException, IOException {
        String ref;
        Property prop = base.getChildByName("reference");
        if (prop.hasValues() && (ref = prop.getValues().get(0).primitiveValue()) != null) {
            for (BaseWrappers.BaseWrapper entry : entries) {
                String fu;
                if (!entry.has("fullUrl") || !ref.equals(fu = entry.get("fullUrl").primitiveValue())) continue;
                return entry.getChildByName("resource").getAsResource();
            }
        }
        return null;
    }

    private boolean renderDocument(XhtmlNode x, Bundle b) throws UnsupportedEncodingException, FHIRException, IOException, EOperationOutcome {
        Composition comp = (Composition)b.getEntry().get(0).getResource();
        Resource subject = this.resolveReference(b, comp.getSubject());
        if (subject != null) {
            XhtmlNode nx;
            XhtmlNode xhtmlNode = nx = subject instanceof DomainResource ? ((DomainResource)subject).getText().getDiv() : null;
            if (nx != null) {
                x.addChildren(nx);
            } else {
                RendererFactory.factory(subject, this.context).render(x, subject);
            }
        }
        x.hr();
        if (comp.getText().hasDiv()) {
            x.addChildren(comp.getText().getDiv());
            x.hr();
        }
        for (Composition.SectionComponent section : comp.getSection()) {
            this.addSection(x, section, 2, false);
        }
        return false;
    }

    private Resource resolveReference(Bundle bnd, Reference reference) {
        String ref = reference.getReference();
        if (ref == null) {
            return null;
        }
        for (Bundle.BundleEntryComponent be : bnd.getEntry()) {
            if (!ref.equals(be.getFullUrl())) continue;
            return be.getResource();
        }
        return null;
    }

    private void addSection(XhtmlNode x, Composition.SectionComponent section, int level, boolean nested) throws UnsupportedEncodingException, FHIRException, IOException {
        if (section.hasTitle() || section.hasCode() || section.hasText() || section.hasSection()) {
            XhtmlNode div = x.div();
            if (section.hasTitle()) {
                div.h(level).tx(section.getTitle());
            } else if (section.hasCode()) {
                this.renderBase(div.h(level), section.getCode());
            }
            if (section.hasText()) {
                x.addChildren(section.getText().getDiv());
            }
            if (section.hasSection()) {
                List<Composition.SectionComponent> sections = section.getSection();
                for (Composition.SectionComponent child : sections) {
                    if (nested) {
                        this.addSection(x.blockquote(), child, level + 1, true);
                        continue;
                    }
                    this.addSection(x, child, level + 1, true);
                }
            }
        }
    }

    public XhtmlNode render(Bundle b) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        if (b.getType() == Bundle.BundleType.DOCUMENT) {
            if (!(b.hasEntry() && b.getEntryFirstRep().hasResource() && b.getEntryFirstRep().getResource() instanceof Composition)) {
                throw new FHIRException("Invalid document - first entry is not a Composition");
            }
            XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
            this.renderDocument(x, b);
            return x;
        }
        if (b.getType() == Bundle.BundleType.COLLECTION && this.allEntresAreHistoryProvenance(b)) {
            return null;
        }
        XhtmlNode root = new XhtmlNode(NodeType.Element, "div");
        root.para().addText(this.formatMessage("RENDER_BUNDLE_HEADER_ROOT", b.getId(), b.getType().toCode()));
        int i = 0;
        for (Bundle.BundleEntryComponent be : b.getEntry()) {
            ++i;
            if (be.hasFullUrl()) {
                root.an(BundleRenderer.makeInternalBundleLink(be.getFullUrl()));
            }
            if (be.hasResource() && be.getResource().hasId()) {
                root.an(be.getResource().getResourceType().name() + "_" + be.getResource().getId());
            }
            root.hr();
            if (be.hasFullUrl()) {
                root.para().addText(this.formatMessage("RENDER_BUNDLE_HEADER_ENTRY_URL", Integer.toString(i), be.getFullUrl()));
            } else {
                root.para().addText(this.formatMessage("RENDER_BUNDLE_HEADER_ENTRY", Integer.toString(i)));
            }
            if (be.hasRequest()) {
                this.renderRequest(root, be.getRequest());
            }
            if (be.hasSearch()) {
                this.renderSearch(root, be.getSearch());
            }
            if (be.hasResponse()) {
                this.renderResponse(root, be.getResponse());
            }
            if (!be.hasResource()) continue;
            root.para().addText(this.formatMessage("RENDER_BUNDLE_RESOURCE", be.getResource().fhirType()));
            if (!be.hasResource()) continue;
            XhtmlNode xn = null;
            if (be.getResource() instanceof DomainResource) {
                DomainResource dr = (DomainResource)be.getResource();
                xn = dr.getText().getDiv();
            }
            if (xn == null || xn.isEmpty()) {
                ResourceRenderer rr = RendererFactory.factory(be.getResource(), this.context);
                try {
                    xn = rr.build(be.getResource());
                }
                catch (Exception e) {
                    xn = this.makeExceptionXhtml(e, "generating narrative");
                }
            }
            root.blockquote().getChildNodes().addAll(this.checkInternalLinks(b, (List<XhtmlNode>)xn.getChildNodes()));
        }
        return root;
    }

    public static boolean allEntriesAreHistoryProvenance(List<BaseWrappers.BaseWrapper> entries) throws UnsupportedEncodingException, FHIRException, IOException {
        for (BaseWrappers.BaseWrapper be : entries) {
            if ("Provenance".equals(be.get("resource").fhirType())) continue;
            return false;
        }
        return !entries.isEmpty();
    }

    private boolean allEntresAreHistoryProvenance(Bundle b) {
        for (Bundle.BundleEntryComponent be : b.getEntry()) {
            if (be.getResource() instanceof Provenance) continue;
            return false;
        }
        return !b.getEntry().isEmpty();
    }

    private List<XhtmlNode> checkInternalLinks(Bundle b, List<XhtmlNode> childNodes) {
        this.scanNodesForInternalLinks(b, childNodes);
        return childNodes;
    }

    private void scanNodesForInternalLinks(Bundle b, List<XhtmlNode> nodes) {
        for (XhtmlNode n : nodes) {
            if ("a".equals(n.getName()) && n.hasAttribute("href")) {
                this.scanInternalLink(b, n);
            }
            this.scanNodesForInternalLinks(b, (List<XhtmlNode>)n.getChildNodes());
        }
    }

    private void scanInternalLink(Bundle b, XhtmlNode n) {
        boolean fix = false;
        for (Bundle.BundleEntryComponent be : b.getEntry()) {
            if (!be.hasFullUrl() || !be.getFullUrl().equals(n.getAttribute("href"))) continue;
            fix = true;
        }
        if (fix) {
            n.setAttribute("href", "#" + BundleRenderer.makeInternalBundleLink(n.getAttribute("href")));
        }
    }

    private void renderSearch(XhtmlNode root, Bundle.BundleEntrySearchComponent search) {
        StringBuilder b = new StringBuilder();
        b.append(this.formatMessage("RENDER_BUNDLE_SEARCH", new Object[0]));
        if (search.hasMode()) {
            b.append(this.formatMessage("RENDER_BUNDLE_SEARCH_MODE", search.getMode().toCode()));
        }
        if (search.hasScore()) {
            if (search.hasMode()) {
                b.append(",");
            }
            b.append(this.formatMessage("RENDER_BUNDLE_SEARCH_SCORE", search.getScore()));
        }
        root.para().addText(b.toString());
    }

    private void renderResponse(XhtmlNode root, Bundle.BundleEntryResponseComponent response) {
        root.para().addText(this.formatMessage("RENDER_BUNDLE_RESPONSE", new Object[0]));
        StringBuilder b = new StringBuilder();
        b.append(response.getStatus() + "\r\n");
        if (response.hasLocation()) {
            b.append(this.formatMessage("RENDER_BUNDLE_LOCATION", response.getLocation()) + "\r\n");
        }
        if (response.hasEtag()) {
            b.append(this.formatMessage("RENDER_BUNDLE_ETAG", response.getEtag()) + "\r\n");
        }
        if (response.hasLastModified()) {
            b.append(this.formatMessage("RENDER_BUNDLE_LAST_MOD", response.getEtag()) + "\r\n");
        }
        root.pre().addText(b.toString());
    }

    private void renderRequest(XhtmlNode root, Bundle.BundleEntryRequestComponent request) {
        root.para().addText(this.formatMessage("RENDER_BUNDLE_REQUEST", new Object[0]));
        StringBuilder b = new StringBuilder();
        b.append(request.getMethod() + " " + request.getUrl() + "\r\n");
        if (request.hasIfNoneMatch()) {
            b.append(this.formatMessage("RENDER_BUNDLE_IF_NON_MATCH", request.getIfNoneMatch()) + "\r\n");
        }
        if (request.hasIfModifiedSince()) {
            b.append(this.formatMessage("RENDER_BUNDLE_IF_MOD", request.getIfModifiedSince()) + "\r\n");
        }
        if (request.hasIfMatch()) {
            b.append(this.formatMessage("RENDER_BUNDLE_IF_MATCH", request.getIfMatch()) + "\r\n");
        }
        if (request.hasIfNoneExist()) {
            b.append(this.formatMessage("RENDER_BUNDLE_IF_NONE", request.getIfNoneExist()) + "\r\n");
        }
        root.pre().addText(b.toString());
    }

    public String display(Bundle bundle) throws UnsupportedEncodingException, IOException {
        return "??";
    }

    public boolean canRender(Bundle b) {
        for (Bundle.BundleEntryComponent be : b.getEntry()) {
            ResourceRenderer rr;
            if (!be.hasResource() || (rr = RendererFactory.factory(be.getResource(), this.context)).canRender(be.getResource())) continue;
            return false;
        }
        return true;
    }
}

