/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.Annotation;
import org.hl7.fhir.r4b.model.Attachment;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.Base64BinaryType;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.CodeableReference;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.Organization;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Quantity;
import org.hl7.fhir.r4b.model.Ratio;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="NutritionProduct", profile="http://hl7.org/fhir/StructureDefinition/NutritionProduct")
public class NutritionProduct
extends DomainResource {
    @Child(name="status", type={CodeType.class}, order=0, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | inactive | entered-in-error", formalDefinition="The current state of the product.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/nutritionproduct-status")
    protected Enumeration<NutritionProductStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A category or class of the nutrition product (halal, kosher, gluten free, vegan, etc)", formalDefinition="Nutrition products can have different classifications - according to its nutritional properties, preparation methods, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/nutrition-product-category")
    protected List<CodeableConcept> category;
    @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A code designating a specific type of nutritional product", formalDefinition="The code assigned to the product, for example a manufacturer number or other terminology.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/edible-substance-type")
    protected CodeableConcept code;
    @Child(name="manufacturer", type={Organization.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer, representative or officially responsible for the product", formalDefinition="The organisation (manufacturer, representative or legal authorisation holder) that is responsible for the device.")
    protected List<Reference> manufacturer;
    @Child(name="nutrient", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The product's nutritional information expressed by the nutrients", formalDefinition="The product's nutritional information expressed by the nutrients.")
    protected List<NutritionProductNutrientComponent> nutrient;
    @Child(name="ingredient", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Ingredients contained in this product", formalDefinition="Ingredients contained in this product.")
    protected List<NutritionProductIngredientComponent> ingredient;
    @Child(name="knownAllergen", type={CodeableReference.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Known or suspected allergens that are a part of this product", formalDefinition="Allergens that are known or suspected to be a part of this nutrition product.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/allergen-class")
    protected List<CodeableReference> knownAllergen;
    @Child(name="productCharacteristic", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Specifies descriptive properties of the nutrition product", formalDefinition="Specifies descriptive properties of the nutrition product.")
    protected List<NutritionProductProductCharacteristicComponent> productCharacteristic;
    @Child(name="instance", type={}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="One or several physical instances or occurrences of the nutrition product", formalDefinition="Conveys instance-level information about this product item. One or several physical, countable instances or occurrences of the product.")
    protected NutritionProductInstanceComponent instance;
    @Child(name="note", type={Annotation.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about the product", formalDefinition="Comments made about the product.")
    protected List<Annotation> note;
    private static final long serialVersionUID = -565022355L;
    @SearchParamDefinition(name="identifier", path="NutritionProduct.instance.identifier", description="The identifier for the physical instance, typically a serial number", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="status", path="NutritionProduct.status", description="active | inactive | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public NutritionProduct() {
    }

    public NutritionProduct(NutritionProductStatus status) {
        this.setStatus(status);
    }

    public Enumeration<NutritionProductStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionProduct.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<NutritionProductStatus>(new NutritionProductStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public NutritionProduct setStatusElement(Enumeration<NutritionProductStatus> value) {
        this.status = value;
        return this;
    }

    public NutritionProductStatus getStatus() {
        return this.status == null ? null : (NutritionProductStatus)((Object)this.status.getValue());
    }

    public NutritionProduct setStatus(NutritionProductStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<NutritionProductStatus>(new NutritionProductStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public NutritionProduct setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public NutritionProduct addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionProduct.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public NutritionProduct setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public List<Reference> getManufacturer() {
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        return this.manufacturer;
    }

    public NutritionProduct setManufacturer(List<Reference> theManufacturer) {
        this.manufacturer = theManufacturer;
        return this;
    }

    public boolean hasManufacturer() {
        if (this.manufacturer == null) {
            return false;
        }
        for (Reference item : this.manufacturer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addManufacturer() {
        Reference t = new Reference();
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return t;
    }

    public NutritionProduct addManufacturer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return this;
    }

    public Reference getManufacturerFirstRep() {
        if (this.getManufacturer().isEmpty()) {
            this.addManufacturer();
        }
        return this.getManufacturer().get(0);
    }

    public List<NutritionProductNutrientComponent> getNutrient() {
        if (this.nutrient == null) {
            this.nutrient = new ArrayList<NutritionProductNutrientComponent>();
        }
        return this.nutrient;
    }

    public NutritionProduct setNutrient(List<NutritionProductNutrientComponent> theNutrient) {
        this.nutrient = theNutrient;
        return this;
    }

    public boolean hasNutrient() {
        if (this.nutrient == null) {
            return false;
        }
        for (NutritionProductNutrientComponent item : this.nutrient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NutritionProductNutrientComponent addNutrient() {
        NutritionProductNutrientComponent t = new NutritionProductNutrientComponent();
        if (this.nutrient == null) {
            this.nutrient = new ArrayList<NutritionProductNutrientComponent>();
        }
        this.nutrient.add(t);
        return t;
    }

    public NutritionProduct addNutrient(NutritionProductNutrientComponent t) {
        if (t == null) {
            return this;
        }
        if (this.nutrient == null) {
            this.nutrient = new ArrayList<NutritionProductNutrientComponent>();
        }
        this.nutrient.add(t);
        return this;
    }

    public NutritionProductNutrientComponent getNutrientFirstRep() {
        if (this.getNutrient().isEmpty()) {
            this.addNutrient();
        }
        return this.getNutrient().get(0);
    }

    public List<NutritionProductIngredientComponent> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<NutritionProductIngredientComponent>();
        }
        return this.ingredient;
    }

    public NutritionProduct setIngredient(List<NutritionProductIngredientComponent> theIngredient) {
        this.ingredient = theIngredient;
        return this;
    }

    public boolean hasIngredient() {
        if (this.ingredient == null) {
            return false;
        }
        for (NutritionProductIngredientComponent item : this.ingredient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NutritionProductIngredientComponent addIngredient() {
        NutritionProductIngredientComponent t = new NutritionProductIngredientComponent();
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<NutritionProductIngredientComponent>();
        }
        this.ingredient.add(t);
        return t;
    }

    public NutritionProduct addIngredient(NutritionProductIngredientComponent t) {
        if (t == null) {
            return this;
        }
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<NutritionProductIngredientComponent>();
        }
        this.ingredient.add(t);
        return this;
    }

    public NutritionProductIngredientComponent getIngredientFirstRep() {
        if (this.getIngredient().isEmpty()) {
            this.addIngredient();
        }
        return this.getIngredient().get(0);
    }

    public List<CodeableReference> getKnownAllergen() {
        if (this.knownAllergen == null) {
            this.knownAllergen = new ArrayList<CodeableReference>();
        }
        return this.knownAllergen;
    }

    public NutritionProduct setKnownAllergen(List<CodeableReference> theKnownAllergen) {
        this.knownAllergen = theKnownAllergen;
        return this;
    }

    public boolean hasKnownAllergen() {
        if (this.knownAllergen == null) {
            return false;
        }
        for (CodeableReference item : this.knownAllergen) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addKnownAllergen() {
        CodeableReference t = new CodeableReference();
        if (this.knownAllergen == null) {
            this.knownAllergen = new ArrayList<CodeableReference>();
        }
        this.knownAllergen.add(t);
        return t;
    }

    public NutritionProduct addKnownAllergen(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.knownAllergen == null) {
            this.knownAllergen = new ArrayList<CodeableReference>();
        }
        this.knownAllergen.add(t);
        return this;
    }

    public CodeableReference getKnownAllergenFirstRep() {
        if (this.getKnownAllergen().isEmpty()) {
            this.addKnownAllergen();
        }
        return this.getKnownAllergen().get(0);
    }

    public List<NutritionProductProductCharacteristicComponent> getProductCharacteristic() {
        if (this.productCharacteristic == null) {
            this.productCharacteristic = new ArrayList<NutritionProductProductCharacteristicComponent>();
        }
        return this.productCharacteristic;
    }

    public NutritionProduct setProductCharacteristic(List<NutritionProductProductCharacteristicComponent> theProductCharacteristic) {
        this.productCharacteristic = theProductCharacteristic;
        return this;
    }

    public boolean hasProductCharacteristic() {
        if (this.productCharacteristic == null) {
            return false;
        }
        for (NutritionProductProductCharacteristicComponent item : this.productCharacteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NutritionProductProductCharacteristicComponent addProductCharacteristic() {
        NutritionProductProductCharacteristicComponent t = new NutritionProductProductCharacteristicComponent();
        if (this.productCharacteristic == null) {
            this.productCharacteristic = new ArrayList<NutritionProductProductCharacteristicComponent>();
        }
        this.productCharacteristic.add(t);
        return t;
    }

    public NutritionProduct addProductCharacteristic(NutritionProductProductCharacteristicComponent t) {
        if (t == null) {
            return this;
        }
        if (this.productCharacteristic == null) {
            this.productCharacteristic = new ArrayList<NutritionProductProductCharacteristicComponent>();
        }
        this.productCharacteristic.add(t);
        return this;
    }

    public NutritionProductProductCharacteristicComponent getProductCharacteristicFirstRep() {
        if (this.getProductCharacteristic().isEmpty()) {
            this.addProductCharacteristic();
        }
        return this.getProductCharacteristic().get(0);
    }

    public NutritionProductInstanceComponent getInstance() {
        if (this.instance == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionProduct.instance");
            }
            if (Configuration.doAutoCreate()) {
                this.instance = new NutritionProductInstanceComponent();
            }
        }
        return this.instance;
    }

    public boolean hasInstance() {
        return this.instance != null && !this.instance.isEmpty();
    }

    public NutritionProduct setInstance(NutritionProductInstanceComponent value) {
        this.instance = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public NutritionProduct setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public NutritionProduct addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_STATUS, "code", "The current state of the product.", 0, 1, this.status));
        children.add(new Property("category", "CodeableConcept", "Nutrition products can have different classifications - according to its nutritional properties, preparation methods, etc.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property("code", "CodeableConcept", "The code assigned to the product, for example a manufacturer number or other terminology.", 0, 1, this.code));
        children.add(new Property("manufacturer", "Reference(Organization)", "The organisation (manufacturer, representative or legal authorisation holder) that is responsible for the device.", 0, Integer.MAX_VALUE, this.manufacturer));
        children.add(new Property("nutrient", "", "The product's nutritional information expressed by the nutrients.", 0, Integer.MAX_VALUE, this.nutrient));
        children.add(new Property("ingredient", "", "Ingredients contained in this product.", 0, Integer.MAX_VALUE, this.ingredient));
        children.add(new Property("knownAllergen", "CodeableReference(Substance)", "Allergens that are known or suspected to be a part of this nutrition product.", 0, Integer.MAX_VALUE, this.knownAllergen));
        children.add(new Property("productCharacteristic", "", "Specifies descriptive properties of the nutrition product.", 0, Integer.MAX_VALUE, this.productCharacteristic));
        children.add(new Property("instance", "", "Conveys instance-level information about this product item. One or several physical, countable instances or occurrences of the product.", 0, 1, this.instance));
        children.add(new Property("note", "Annotation", "Comments made about the product.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the product.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property("category", "CodeableConcept", "Nutrition products can have different classifications - according to its nutritional properties, preparation methods, etc.", 0, Integer.MAX_VALUE, this.category);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "The code assigned to the product, for example a manufacturer number or other terminology.", 0, 1, this.code);
            }
            case -1969347631: {
                return new Property("manufacturer", "Reference(Organization)", "The organisation (manufacturer, representative or legal authorisation holder) that is responsible for the device.", 0, Integer.MAX_VALUE, this.manufacturer);
            }
            case -1671151641: {
                return new Property("nutrient", "", "The product's nutritional information expressed by the nutrients.", 0, Integer.MAX_VALUE, this.nutrient);
            }
            case -206409263: {
                return new Property("ingredient", "", "Ingredients contained in this product.", 0, Integer.MAX_VALUE, this.ingredient);
            }
            case 1093336805: {
                return new Property("knownAllergen", "CodeableReference(Substance)", "Allergens that are known or suspected to be a part of this nutrition product.", 0, Integer.MAX_VALUE, this.knownAllergen);
            }
            case 1231899754: {
                return new Property("productCharacteristic", "", "Specifies descriptive properties of the nutrition product.", 0, Integer.MAX_VALUE, this.productCharacteristic);
            }
            case 555127957: {
                return new Property("instance", "", "Conveys instance-level information about this product item. One or several physical, countable instances or occurrences of the product.", 0, 1, this.instance);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments made about the product.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.code;
                }
                return baseArray;
            }
            case -1969347631: {
                return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
            }
            case -1671151641: {
                return this.nutrient == null ? new Base[]{} : this.nutrient.toArray(new Base[this.nutrient.size()]);
            }
            case -206409263: {
                return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
            }
            case 1093336805: {
                return this.knownAllergen == null ? new Base[]{} : this.knownAllergen.toArray(new Base[this.knownAllergen.size()]);
            }
            case 1231899754: {
                return this.productCharacteristic == null ? new Base[]{} : this.productCharacteristic.toArray(new Base[this.productCharacteristic.size()]);
            }
            case 555127957: {
                Base[] baseArray;
                if (this.instance == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.instance;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -892481550: {
                value = new NutritionProductStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1969347631: {
                this.getManufacturer().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1671151641: {
                this.getNutrient().add((NutritionProductNutrientComponent)((Object)value));
                return value;
            }
            case -206409263: {
                this.getIngredient().add((NutritionProductIngredientComponent)((Object)value));
                return value;
            }
            case 1093336805: {
                this.getKnownAllergen().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 1231899754: {
                this.getProductCharacteristic().add((NutritionProductProductCharacteristicComponent)((Object)value));
                return value;
            }
            case 555127957: {
                this.instance = (NutritionProductInstanceComponent)((Object)value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_STATUS)) {
            value = new NutritionProductStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("category")) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("code")) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("manufacturer")) {
            this.getManufacturer().add(TypeConvertor.castToReference(value));
        } else if (name.equals("nutrient")) {
            this.getNutrient().add((NutritionProductNutrientComponent)((Object)value));
        } else if (name.equals("ingredient")) {
            this.getIngredient().add((NutritionProductIngredientComponent)((Object)value));
        } else if (name.equals("knownAllergen")) {
            this.getKnownAllergen().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("productCharacteristic")) {
            this.getProductCharacteristic().add((NutritionProductProductCharacteristicComponent)((Object)value));
        } else if (name.equals("instance")) {
            this.instance = (NutritionProductInstanceComponent)((Object)value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1969347631: {
                return this.addManufacturer();
            }
            case -1671151641: {
                return this.addNutrient();
            }
            case -206409263: {
                return this.addIngredient();
            }
            case 1093336805: {
                return this.addKnownAllergen();
            }
            case 1231899754: {
                return this.addProductCharacteristic();
            }
            case 555127957: {
                return this.getInstance();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -892481550: {
                return new String[]{"code"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case -1671151641: {
                return new String[0];
            }
            case -206409263: {
                return new String[0];
            }
            case 1093336805: {
                return new String[]{"CodeableReference"};
            }
            case 1231899754: {
                return new String[0];
            }
            case 555127957: {
                return new String[0];
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property NutritionProduct.status");
        }
        if (name.equals("category")) {
            return this.addCategory();
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("manufacturer")) {
            return this.addManufacturer();
        }
        if (name.equals("nutrient")) {
            return this.addNutrient();
        }
        if (name.equals("ingredient")) {
            return this.addIngredient();
        }
        if (name.equals("knownAllergen")) {
            return this.addKnownAllergen();
        }
        if (name.equals("productCharacteristic")) {
            return this.addProductCharacteristic();
        }
        if (name.equals("instance")) {
            this.instance = new NutritionProductInstanceComponent();
            return this.instance;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "NutritionProduct";
    }

    @Override
    public NutritionProduct copy() {
        NutritionProduct dst = new NutritionProduct();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(NutritionProduct dst) {
        super.copyValues(dst);
        Enumeration<NutritionProductStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
        if (this.manufacturer != null) {
            dst.manufacturer = new ArrayList<Reference>();
            for (Reference reference : this.manufacturer) {
                dst.manufacturer.add(reference.copy());
            }
        }
        if (this.nutrient != null) {
            dst.nutrient = new ArrayList<NutritionProductNutrientComponent>();
            for (NutritionProductNutrientComponent nutritionProductNutrientComponent : this.nutrient) {
                dst.nutrient.add(nutritionProductNutrientComponent.copy());
            }
        }
        if (this.ingredient != null) {
            dst.ingredient = new ArrayList<NutritionProductIngredientComponent>();
            for (NutritionProductIngredientComponent nutritionProductIngredientComponent : this.ingredient) {
                dst.ingredient.add(nutritionProductIngredientComponent.copy());
            }
        }
        if (this.knownAllergen != null) {
            dst.knownAllergen = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.knownAllergen) {
                dst.knownAllergen.add(codeableReference.copy());
            }
        }
        if (this.productCharacteristic != null) {
            dst.productCharacteristic = new ArrayList<NutritionProductProductCharacteristicComponent>();
            for (NutritionProductProductCharacteristicComponent nutritionProductProductCharacteristicComponent : this.productCharacteristic) {
                dst.productCharacteristic.add(nutritionProductProductCharacteristicComponent.copy());
            }
        }
        NutritionProductInstanceComponent nutritionProductInstanceComponent = dst.instance = this.instance == null ? null : this.instance.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected NutritionProduct typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof NutritionProduct)) {
            return false;
        }
        NutritionProduct o = (NutritionProduct)other_;
        return NutritionProduct.compareDeep(this.status, o.status, true) && NutritionProduct.compareDeep(this.category, o.category, true) && NutritionProduct.compareDeep(this.code, o.code, true) && NutritionProduct.compareDeep(this.manufacturer, o.manufacturer, true) && NutritionProduct.compareDeep(this.nutrient, o.nutrient, true) && NutritionProduct.compareDeep(this.ingredient, o.ingredient, true) && NutritionProduct.compareDeep(this.knownAllergen, o.knownAllergen, true) && NutritionProduct.compareDeep(this.productCharacteristic, o.productCharacteristic, true) && NutritionProduct.compareDeep(this.instance, o.instance, true) && NutritionProduct.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof NutritionProduct)) {
            return false;
        }
        NutritionProduct o = (NutritionProduct)other_;
        return NutritionProduct.compareValues(this.status, o.status, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.status, this.category, this.code, this.manufacturer, this.nutrient, this.ingredient, this.knownAllergen, this.productCharacteristic, this.instance, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.NutritionProduct;
    }

    @Block
    public static class NutritionProductInstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="quantity", type={Quantity.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The amount of items or instances", formalDefinition="The amount of items or instances that the resource considers, for instance when referring to 2 identical units together.")
        protected Quantity quantity;
        @Child(name="identifier", type={Identifier.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The identifier for the physical instance, typically a serial number", formalDefinition="The identifier for the physical instance, typically a serial number.")
        protected List<Identifier> identifier;
        @Child(name="lotNumber", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The identification of the batch or lot of the product", formalDefinition="The identification of the batch or lot of the product.")
        protected StringType lotNumber;
        @Child(name="expiry", type={DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The expiry date or date and time for the product", formalDefinition="The time after which the product is no longer expected to be in proper condition, or its use is not advised or not allowed.")
        protected DateTimeType expiry;
        @Child(name="useBy", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The date until which the product is expected to be good for consumption", formalDefinition="The time after which the product is no longer expected to be in proper condition, or its use is not advised or not allowed.")
        protected DateTimeType useBy;
        private static final long serialVersionUID = -17755640L;

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionProductInstanceComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public NutritionProductInstanceComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public NutritionProductInstanceComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public NutritionProductInstanceComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public StringType getLotNumberElement() {
            if (this.lotNumber == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionProductInstanceComponent.lotNumber");
                }
                if (Configuration.doAutoCreate()) {
                    this.lotNumber = new StringType();
                }
            }
            return this.lotNumber;
        }

        public boolean hasLotNumberElement() {
            return this.lotNumber != null && !this.lotNumber.isEmpty();
        }

        public boolean hasLotNumber() {
            return this.lotNumber != null && !this.lotNumber.isEmpty();
        }

        public NutritionProductInstanceComponent setLotNumberElement(StringType value) {
            this.lotNumber = value;
            return this;
        }

        public String getLotNumber() {
            return this.lotNumber == null ? null : (String)this.lotNumber.getValue();
        }

        public NutritionProductInstanceComponent setLotNumber(String value) {
            if (Utilities.noString((String)value)) {
                this.lotNumber = null;
            } else {
                if (this.lotNumber == null) {
                    this.lotNumber = new StringType();
                }
                this.lotNumber.setValue(value);
            }
            return this;
        }

        public DateTimeType getExpiryElement() {
            if (this.expiry == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionProductInstanceComponent.expiry");
                }
                if (Configuration.doAutoCreate()) {
                    this.expiry = new DateTimeType();
                }
            }
            return this.expiry;
        }

        public boolean hasExpiryElement() {
            return this.expiry != null && !this.expiry.isEmpty();
        }

        public boolean hasExpiry() {
            return this.expiry != null && !this.expiry.isEmpty();
        }

        public NutritionProductInstanceComponent setExpiryElement(DateTimeType value) {
            this.expiry = value;
            return this;
        }

        public Date getExpiry() {
            return this.expiry == null ? null : (Date)this.expiry.getValue();
        }

        public NutritionProductInstanceComponent setExpiry(Date value) {
            if (value == null) {
                this.expiry = null;
            } else {
                if (this.expiry == null) {
                    this.expiry = new DateTimeType();
                }
                this.expiry.setValue(value);
            }
            return this;
        }

        public DateTimeType getUseByElement() {
            if (this.useBy == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionProductInstanceComponent.useBy");
                }
                if (Configuration.doAutoCreate()) {
                    this.useBy = new DateTimeType();
                }
            }
            return this.useBy;
        }

        public boolean hasUseByElement() {
            return this.useBy != null && !this.useBy.isEmpty();
        }

        public boolean hasUseBy() {
            return this.useBy != null && !this.useBy.isEmpty();
        }

        public NutritionProductInstanceComponent setUseByElement(DateTimeType value) {
            this.useBy = value;
            return this;
        }

        public Date getUseBy() {
            return this.useBy == null ? null : (Date)this.useBy.getValue();
        }

        public NutritionProductInstanceComponent setUseBy(Date value) {
            if (value == null) {
                this.useBy = null;
            } else {
                if (this.useBy == null) {
                    this.useBy = new DateTimeType();
                }
                this.useBy.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("quantity", "Quantity", "The amount of items or instances that the resource considers, for instance when referring to 2 identical units together.", 0, 1, this.quantity));
            children.add(new Property(NutritionProduct.SP_IDENTIFIER, "Identifier", "The identifier for the physical instance, typically a serial number.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("lotNumber", "string", "The identification of the batch or lot of the product.", 0, 1, this.lotNumber));
            children.add(new Property("expiry", "dateTime", "The time after which the product is no longer expected to be in proper condition, or its use is not advised or not allowed.", 0, 1, this.expiry));
            children.add(new Property("useBy", "dateTime", "The time after which the product is no longer expected to be in proper condition, or its use is not advised or not allowed.", 0, 1, this.useBy));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The amount of items or instances that the resource considers, for instance when referring to 2 identical units together.", 0, 1, this.quantity);
                }
                case -1618432855: {
                    return new Property(NutritionProduct.SP_IDENTIFIER, "Identifier", "The identifier for the physical instance, typically a serial number.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case 462547450: {
                    return new Property("lotNumber", "string", "The identification of the batch or lot of the product.", 0, 1, this.lotNumber);
                }
                case -1289159373: {
                    return new Property("expiry", "dateTime", "The time after which the product is no longer expected to be in proper condition, or its use is not advised or not allowed.", 0, 1, this.expiry);
                }
                case 111577150: {
                    return new Property("useBy", "dateTime", "The time after which the product is no longer expected to be in proper condition, or its use is not advised or not allowed.", 0, 1, this.useBy);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 462547450: {
                    Base[] baseArray;
                    if (this.lotNumber == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.lotNumber;
                    }
                    return baseArray;
                }
                case -1289159373: {
                    Base[] baseArray;
                    if (this.expiry == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.expiry;
                    }
                    return baseArray;
                }
                case 111577150: {
                    Base[] baseArray;
                    if (this.useBy == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.useBy;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case 462547450: {
                    this.lotNumber = TypeConvertor.castToString(value);
                    return value;
                }
                case -1289159373: {
                    this.expiry = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 111577150: {
                    this.useBy = TypeConvertor.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals(NutritionProduct.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("lotNumber")) {
                this.lotNumber = TypeConvertor.castToString(value);
            } else if (name.equals("expiry")) {
                this.expiry = TypeConvertor.castToDateTime(value);
            } else if (name.equals("useBy")) {
                this.useBy = TypeConvertor.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    return this.getQuantity();
                }
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 462547450: {
                    return this.getLotNumberElement();
                }
                case -1289159373: {
                    return this.getExpiryElement();
                }
                case 111577150: {
                    return this.getUseByElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 462547450: {
                    return new String[]{"string"};
                }
                case -1289159373: {
                    return new String[]{"dateTime"};
                }
                case 111577150: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals(NutritionProduct.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("lotNumber")) {
                throw new FHIRException("Cannot call addChild on a singleton property NutritionProduct.instance.lotNumber");
            }
            if (name.equals("expiry")) {
                throw new FHIRException("Cannot call addChild on a singleton property NutritionProduct.instance.expiry");
            }
            if (name.equals("useBy")) {
                throw new FHIRException("Cannot call addChild on a singleton property NutritionProduct.instance.useBy");
            }
            return super.addChild(name);
        }

        @Override
        public NutritionProductInstanceComponent copy() {
            NutritionProductInstanceComponent dst = new NutritionProductInstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NutritionProductInstanceComponent dst) {
            super.copyValues(dst);
            Quantity quantity = dst.quantity = this.quantity == null ? null : this.quantity.copy();
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier i : this.identifier) {
                    dst.identifier.add(i.copy());
                }
            }
            dst.lotNumber = this.lotNumber == null ? null : this.lotNumber.copy();
            dst.expiry = this.expiry == null ? null : this.expiry.copy();
            dst.useBy = this.useBy == null ? null : this.useBy.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionProductInstanceComponent)) {
                return false;
            }
            NutritionProductInstanceComponent o = (NutritionProductInstanceComponent)other_;
            return NutritionProductInstanceComponent.compareDeep(this.quantity, o.quantity, true) && NutritionProductInstanceComponent.compareDeep(this.identifier, o.identifier, true) && NutritionProductInstanceComponent.compareDeep(this.lotNumber, o.lotNumber, true) && NutritionProductInstanceComponent.compareDeep(this.expiry, o.expiry, true) && NutritionProductInstanceComponent.compareDeep(this.useBy, o.useBy, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionProductInstanceComponent)) {
                return false;
            }
            NutritionProductInstanceComponent o = (NutritionProductInstanceComponent)other_;
            return NutritionProductInstanceComponent.compareValues(this.lotNumber, o.lotNumber, true) && NutritionProductInstanceComponent.compareValues(this.expiry, o.expiry, true) && NutritionProductInstanceComponent.compareValues(this.useBy, o.useBy, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.quantity, this.identifier, this.lotNumber, this.expiry, this.useBy});
        }

        @Override
        public String fhirType() {
            return "NutritionProduct.instance";
        }
    }

    @Block
    public static class NutritionProductProductCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code specifying the type of characteristic", formalDefinition="A code specifying which characteristic of the product is being described (for example, colour, shape).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/measurement-property")
        protected CodeableConcept type;
        @Child(name="value", type={CodeableConcept.class, StringType.class, Quantity.class, Base64BinaryType.class, Attachment.class, BooleanType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The value of the characteristic", formalDefinition="The actual characteristic value corresponding to the type.")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public NutritionProductProductCharacteristicComponent() {
        }

        public NutritionProductProductCharacteristicComponent(CodeableConcept type, DataType value) {
            this.setType(type);
            this.setValue(value);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionProductProductCharacteristicComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public NutritionProductProductCharacteristicComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Base64BinaryType getValueBase64BinaryType() throws FHIRException {
            if (this.value == null) {
                this.value = new Base64BinaryType();
            }
            if (!(this.value instanceof Base64BinaryType)) {
                throw new FHIRException("Type mismatch: the type Base64BinaryType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Base64BinaryType)this.value;
        }

        public boolean hasValueBase64BinaryType() {
            return this != null && this.value instanceof Base64BinaryType;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public NutritionProductProductCharacteristicComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof StringType || value instanceof Quantity || value instanceof Base64BinaryType || value instanceof Attachment || value instanceof BooleanType)) {
                throw new Error("Not the right type for NutritionProduct.productCharacteristic.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "A code specifying which characteristic of the product is being described (for example, colour, shape).", 0, 1, this.type));
            children.add(new Property("value[x]", "CodeableConcept|string|Quantity|base64Binary|Attachment|boolean", "The actual characteristic value corresponding to the type.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A code specifying which characteristic of the product is being described (for example, colour, shape).", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|string|Quantity|base64Binary|Attachment|boolean", "The actual characteristic value corresponding to the type.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|string|Quantity|base64Binary|Attachment|boolean", "The actual characteristic value corresponding to the type.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "The actual characteristic value corresponding to the type.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "The actual characteristic value corresponding to the type.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "The actual characteristic value corresponding to the type.", 0, 1, this.value);
                }
                case -1535024575: {
                    return new Property("value[x]", "base64Binary", "The actual characteristic value corresponding to the type.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "The actual characteristic value corresponding to the type.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "The actual characteristic value corresponding to the type.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "string", "Quantity", "base64Binary", "Attachment", "boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public NutritionProductProductCharacteristicComponent copy() {
            NutritionProductProductCharacteristicComponent dst = new NutritionProductProductCharacteristicComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NutritionProductProductCharacteristicComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionProductProductCharacteristicComponent)) {
                return false;
            }
            NutritionProductProductCharacteristicComponent o = (NutritionProductProductCharacteristicComponent)other_;
            return NutritionProductProductCharacteristicComponent.compareDeep(this.type, o.type, true) && NutritionProductProductCharacteristicComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionProductProductCharacteristicComponent)) {
                return false;
            }
            NutritionProductProductCharacteristicComponent o = (NutritionProductProductCharacteristicComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value});
        }

        @Override
        public String fhirType() {
            return "NutritionProduct.productCharacteristic";
        }
    }

    @Block
    public static class NutritionProductIngredientComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={CodeableReference.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The ingredient contained in the product", formalDefinition="The ingredient contained in the product.")
        protected CodeableReference item;
        @Child(name="amount", type={Ratio.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The amount of ingredient that is in the product", formalDefinition="The amount of ingredient that is in the product.")
        protected List<Ratio> amount;
        private static final long serialVersionUID = -776277304L;

        public NutritionProductIngredientComponent() {
        }

        public NutritionProductIngredientComponent(CodeableReference item) {
            this.setItem(item);
        }

        public CodeableReference getItem() {
            if (this.item == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionProductIngredientComponent.item");
                }
                if (Configuration.doAutoCreate()) {
                    this.item = new CodeableReference();
                }
            }
            return this.item;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public NutritionProductIngredientComponent setItem(CodeableReference value) {
            this.item = value;
            return this;
        }

        public List<Ratio> getAmount() {
            if (this.amount == null) {
                this.amount = new ArrayList<Ratio>();
            }
            return this.amount;
        }

        public NutritionProductIngredientComponent setAmount(List<Ratio> theAmount) {
            this.amount = theAmount;
            return this;
        }

        public boolean hasAmount() {
            if (this.amount == null) {
                return false;
            }
            for (Ratio item : this.amount) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Ratio addAmount() {
            Ratio t = new Ratio();
            if (this.amount == null) {
                this.amount = new ArrayList<Ratio>();
            }
            this.amount.add(t);
            return t;
        }

        public NutritionProductIngredientComponent addAmount(Ratio t) {
            if (t == null) {
                return this;
            }
            if (this.amount == null) {
                this.amount = new ArrayList<Ratio>();
            }
            this.amount.add(t);
            return this;
        }

        public Ratio getAmountFirstRep() {
            if (this.getAmount().isEmpty()) {
                this.addAmount();
            }
            return this.getAmount().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item", "CodeableReference(NutritionProduct)", "The ingredient contained in the product.", 0, 1, this.item));
            children.add(new Property("amount", "Ratio", "The amount of ingredient that is in the product.", 0, Integer.MAX_VALUE, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3242771: {
                    return new Property("item", "CodeableReference(NutritionProduct)", "The ingredient contained in the product.", 0, 1, this.item);
                }
                case -1413853096: {
                    return new Property("amount", "Ratio", "The amount of ingredient that is in the product.", 0, Integer.MAX_VALUE, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    return this.amount == null ? new Base[]{} : this.amount.toArray(new Base[this.amount.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -1413853096: {
                    this.getAmount().add(TypeConvertor.castToRatio(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("item")) {
                this.item = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("amount")) {
                this.getAmount().add(TypeConvertor.castToRatio(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return this.getItem();
                }
                case -1413853096: {
                    return this.addAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"CodeableReference"};
                }
                case -1413853096: {
                    return new String[]{"Ratio"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("item")) {
                this.item = new CodeableReference();
                return this.item;
            }
            if (name.equals("amount")) {
                return this.addAmount();
            }
            return super.addChild(name);
        }

        @Override
        public NutritionProductIngredientComponent copy() {
            NutritionProductIngredientComponent dst = new NutritionProductIngredientComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NutritionProductIngredientComponent dst) {
            super.copyValues(dst);
            CodeableReference codeableReference = dst.item = this.item == null ? null : this.item.copy();
            if (this.amount != null) {
                dst.amount = new ArrayList<Ratio>();
                for (Ratio i : this.amount) {
                    dst.amount.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionProductIngredientComponent)) {
                return false;
            }
            NutritionProductIngredientComponent o = (NutritionProductIngredientComponent)other_;
            return NutritionProductIngredientComponent.compareDeep(this.item, o.item, true) && NutritionProductIngredientComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionProductIngredientComponent)) {
                return false;
            }
            NutritionProductIngredientComponent o = (NutritionProductIngredientComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.item, this.amount});
        }

        @Override
        public String fhirType() {
            return "NutritionProduct.ingredient";
        }
    }

    @Block
    public static class NutritionProductNutrientComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={CodeableReference.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The (relevant) nutrients in the product", formalDefinition="The (relevant) nutrients in the product.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/nutrition-product-nutrient")
        protected CodeableReference item;
        @Child(name="amount", type={Ratio.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The amount of nutrient expressed in one or more units: X per pack / per serving / per dose", formalDefinition="The amount of nutrient expressed in one or more units: X per pack / per serving / per dose.")
        protected List<Ratio> amount;
        private static final long serialVersionUID = -776277304L;

        public CodeableReference getItem() {
            if (this.item == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionProductNutrientComponent.item");
                }
                if (Configuration.doAutoCreate()) {
                    this.item = new CodeableReference();
                }
            }
            return this.item;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public NutritionProductNutrientComponent setItem(CodeableReference value) {
            this.item = value;
            return this;
        }

        public List<Ratio> getAmount() {
            if (this.amount == null) {
                this.amount = new ArrayList<Ratio>();
            }
            return this.amount;
        }

        public NutritionProductNutrientComponent setAmount(List<Ratio> theAmount) {
            this.amount = theAmount;
            return this;
        }

        public boolean hasAmount() {
            if (this.amount == null) {
                return false;
            }
            for (Ratio item : this.amount) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Ratio addAmount() {
            Ratio t = new Ratio();
            if (this.amount == null) {
                this.amount = new ArrayList<Ratio>();
            }
            this.amount.add(t);
            return t;
        }

        public NutritionProductNutrientComponent addAmount(Ratio t) {
            if (t == null) {
                return this;
            }
            if (this.amount == null) {
                this.amount = new ArrayList<Ratio>();
            }
            this.amount.add(t);
            return this;
        }

        public Ratio getAmountFirstRep() {
            if (this.getAmount().isEmpty()) {
                this.addAmount();
            }
            return this.getAmount().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item", "CodeableReference(Substance)", "The (relevant) nutrients in the product.", 0, 1, this.item));
            children.add(new Property("amount", "Ratio", "The amount of nutrient expressed in one or more units: X per pack / per serving / per dose.", 0, Integer.MAX_VALUE, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3242771: {
                    return new Property("item", "CodeableReference(Substance)", "The (relevant) nutrients in the product.", 0, 1, this.item);
                }
                case -1413853096: {
                    return new Property("amount", "Ratio", "The amount of nutrient expressed in one or more units: X per pack / per serving / per dose.", 0, Integer.MAX_VALUE, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    return this.amount == null ? new Base[]{} : this.amount.toArray(new Base[this.amount.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -1413853096: {
                    this.getAmount().add(TypeConvertor.castToRatio(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("item")) {
                this.item = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("amount")) {
                this.getAmount().add(TypeConvertor.castToRatio(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return this.getItem();
                }
                case -1413853096: {
                    return this.addAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"CodeableReference"};
                }
                case -1413853096: {
                    return new String[]{"Ratio"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("item")) {
                this.item = new CodeableReference();
                return this.item;
            }
            if (name.equals("amount")) {
                return this.addAmount();
            }
            return super.addChild(name);
        }

        @Override
        public NutritionProductNutrientComponent copy() {
            NutritionProductNutrientComponent dst = new NutritionProductNutrientComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NutritionProductNutrientComponent dst) {
            super.copyValues(dst);
            CodeableReference codeableReference = dst.item = this.item == null ? null : this.item.copy();
            if (this.amount != null) {
                dst.amount = new ArrayList<Ratio>();
                for (Ratio i : this.amount) {
                    dst.amount.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionProductNutrientComponent)) {
                return false;
            }
            NutritionProductNutrientComponent o = (NutritionProductNutrientComponent)other_;
            return NutritionProductNutrientComponent.compareDeep(this.item, o.item, true) && NutritionProductNutrientComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NutritionProductNutrientComponent)) {
                return false;
            }
            NutritionProductNutrientComponent o = (NutritionProductNutrientComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.item, this.amount});
        }

        @Override
        public String fhirType() {
            return "NutritionProduct.nutrient";
        }
    }

    public static class NutritionProductStatusEnumFactory
    implements EnumFactory<NutritionProductStatus> {
        @Override
        public NutritionProductStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return NutritionProductStatus.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return NutritionProductStatus.INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return NutritionProductStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown NutritionProductStatus code '" + codeString + "'");
        }

        public Enumeration<NutritionProductStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<NutritionProductStatus>(this, NutritionProductStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<NutritionProductStatus>(this, NutritionProductStatus.NULL, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<NutritionProductStatus>(this, NutritionProductStatus.ACTIVE, code);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<NutritionProductStatus>(this, NutritionProductStatus.INACTIVE, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<NutritionProductStatus>(this, NutritionProductStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown NutritionProductStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(NutritionProductStatus code) {
            if (code == NutritionProductStatus.ACTIVE) {
                return "active";
            }
            if (code == NutritionProductStatus.INACTIVE) {
                return "inactive";
            }
            if (code == NutritionProductStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(NutritionProductStatus code) {
            return code.getSystem();
        }
    }

    public static enum NutritionProductStatus {
        ACTIVE,
        INACTIVE,
        ENTEREDINERROR,
        NULL;


        public static NutritionProductStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown NutritionProductStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/nutritionproduct-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/nutritionproduct-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/nutritionproduct-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The product can be used.";
                }
                case INACTIVE: {
                    return "The product is not expected or allowed to be used.";
                }
                case ENTEREDINERROR: {
                    return "This electronic record should never have existed, though it is possible that real-world decisions were based on it.  (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

