/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.Attachment;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.CodeableReference;
import org.hl7.fhir.r4b.model.Coding;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.DateType;
import org.hl7.fhir.r4b.model.DocumentReference;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.MarkdownType;
import org.hl7.fhir.r4b.model.MarketingStatus;
import org.hl7.fhir.r4b.model.Organization;
import org.hl7.fhir.r4b.model.Period;
import org.hl7.fhir.r4b.model.PractitionerRole;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Quantity;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.ResearchStudy;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicinalProductDefinition", profile="http://hl7.org/fhir/StructureDefinition/MedicinalProductDefinition")
public class MedicinalProductDefinition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for this product. Could be an MPID", formalDefinition="Business identifier for this product. Could be an MPID.")
    protected List<Identifier> identifier;
    @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Regulatory type, e.g. Investigational or Authorized", formalDefinition="Regulatory type, e.g. Investigational or Authorized.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicinal-product-type")
    protected CodeableConcept type;
    @Child(name="domain", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If this medicine applies to human or veterinary uses", formalDefinition="If this medicine applies to human or veterinary uses.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicinal-product-domain")
    protected CodeableConcept domain;
    @Child(name="version", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A business identifier relating to a specific version of the product, this is commonly used to support revisions to an existing product", formalDefinition="A business identifier relating to a specific version of the product, this is commonly used to support revisions to an existing product.")
    protected StringType version;
    @Child(name="status", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="The status within the lifecycle of this product record. A high-level status, this is not intended to duplicate details carried elsewhere such as legal status, or authorization status", formalDefinition="The status within the lifecycle of this product record. A high-level status, this is not intended to duplicate details carried elsewhere such as legal status, or authorization status.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected CodeableConcept status;
    @Child(name="statusDate", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date at which the given status became applicable", formalDefinition="The date at which the given status became applicable.")
    protected DateTimeType statusDate;
    @Child(name="description", type={MarkdownType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="General description of this product", formalDefinition="General description of this product.")
    protected MarkdownType description;
    @Child(name="combinedPharmaceuticalDoseForm", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The dose form for a single part product, or combined form of a multiple part product", formalDefinition="The dose form for a single part product, or combined form of a multiple part product.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/combined-dose-form")
    protected CodeableConcept combinedPharmaceuticalDoseForm;
    @Child(name="route", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The path by which the product is taken into or makes contact with the body. In some regions this is referred to as the licenced or approved route. See also AdministrableProductDefinition resource", formalDefinition="The path by which the product is taken into or makes contact with the body. In some regions this is referred to as the licenced or approved route. See also AdministrableProductDefinition resource.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/route-codes")
    protected List<CodeableConcept> route;
    @Child(name="indication", type={MarkdownType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description of indication(s) for this product, used when structured indications are not required. In cases where structured indications are required, they are captured using the ClinicalUseDefinition resource. An indication is a medical situation for which using the product is appropriate", formalDefinition="Description of indication(s) for this product, used when structured indications are not required. In cases where structured indications are required, they are captured using the ClinicalUseDefinition resource. An indication is a medical situation for which using the product is appropriate.")
    protected MarkdownType indication;
    @Child(name="legalStatusOfSupply", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The legal status of supply of the medicinal product as classified by the regulator", formalDefinition="The legal status of supply of the medicinal product as classified by the regulator.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/legal-status-of-supply")
    protected CodeableConcept legalStatusOfSupply;
    @Child(name="additionalMonitoringIndicator", type={CodeableConcept.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether the Medicinal Product is subject to additional monitoring for regulatory reasons", formalDefinition="Whether the Medicinal Product is subject to additional monitoring for regulatory reasons.")
    protected CodeableConcept additionalMonitoringIndicator;
    @Child(name="specialMeasures", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Whether the Medicinal Product is subject to special measures for regulatory reasons", formalDefinition="Whether the Medicinal Product is subject to special measures for regulatory reasons.")
    protected List<CodeableConcept> specialMeasures;
    @Child(name="pediatricUseIndicator", type={CodeableConcept.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If authorised for use in children", formalDefinition="If authorised for use in children.")
    protected CodeableConcept pediatricUseIndicator;
    @Child(name="classification", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Allows the product to be classified by various systems", formalDefinition="Allows the product to be classified by various systems.")
    protected List<CodeableConcept> classification;
    @Child(name="marketingStatus", type={MarketingStatus.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Marketing status of the medicinal product, in contrast to marketing authorization", formalDefinition="Marketing status of the medicinal product, in contrast to marketing authorization.")
    protected List<MarketingStatus> marketingStatus;
    @Child(name="packagedMedicinalProduct", type={CodeableConcept.class}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Package representation for the product", formalDefinition="Package representation for the product. See also the PackagedProductDefinition resource.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicinal-product-package-type")
    protected List<CodeableConcept> packagedMedicinalProduct;
    @Child(name="ingredient", type={CodeableConcept.class}, order=17, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The ingredients of this medicinal product - when not detailed in other resources. This is only needed if the ingredients are not specified by incoming references from the Ingredient resource, or indirectly via incoming AdministrableProductDefinition, PackagedProductDefinition or ManufacturedItemDefinition references. In cases where those levels of detail are not used, the ingredients may be specified directly here as codes", formalDefinition="The ingredients of this medicinal product - when not detailed in other resources. This is only needed if the ingredients are not specified by incoming references from the Ingredient resource, or indirectly via incoming AdministrableProductDefinition, PackagedProductDefinition or ManufacturedItemDefinition references. In cases where those levels of detail are not used, the ingredients may be specified directly here as codes.")
    protected List<CodeableConcept> ingredient;
    @Child(name="impurity", type={CodeableReference.class}, order=18, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Any component of the drug product which is not the chemical entity defined as the drug substance or an excipient in the drug product. This includes process-related impurities and contaminants, product-related impurities including degradation products", formalDefinition="Any component of the drug product which is not the chemical entity defined as the drug substance or an excipient in the drug product. This includes process-related impurities and contaminants, product-related impurities including degradation products.")
    protected List<CodeableReference> impurity;
    @Child(name="attachedDocument", type={DocumentReference.class}, order=19, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional information or supporting documentation about the medicinal product", formalDefinition="Additional information or supporting documentation about the medicinal product.")
    protected List<Reference> attachedDocument;
    @Child(name="masterFile", type={DocumentReference.class}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A master file for the medicinal product (e.g. Pharmacovigilance System Master File)", formalDefinition="A master file for the medicinal product (e.g. Pharmacovigilance System Master File). Drug master files (DMFs) are documents submitted to regulatory agencies to provide confidential detailed information about facilities, processes or articles used in the manufacturing, processing, packaging and storing of drug products.")
    protected List<Reference> masterFile;
    @Child(name="contact", type={}, order=21, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A product specific contact, person (in a role), or an organization", formalDefinition="A product specific contact, person (in a role), or an organization.")
    protected List<MedicinalProductDefinitionContactComponent> contact;
    @Child(name="clinicalTrial", type={ResearchStudy.class}, order=22, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Clinical trials or studies that this product is involved in", formalDefinition="Clinical trials or studies that this product is involved in.")
    protected List<Reference> clinicalTrial;
    @Child(name="code", type={Coding.class}, order=23, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A code that this product is known by, within some formal terminology", formalDefinition="A code that this product is known by, usually within some formal terminology. Products (types of medications) tend to be known by identifiers during development and within regulatory process. However when they are prescribed they tend to be identified by codes. The same product may be have multiple codes, applied to it by multiple organizations.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    protected List<Coding> code;
    @Child(name="name", type={}, order=24, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The product's name, including full name and possibly coded parts", formalDefinition="The product's name, including full name and possibly coded parts.")
    protected List<MedicinalProductDefinitionNameComponent> name;
    @Child(name="crossReference", type={}, order=25, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Reference to another product, e.g. for linking authorised to investigational product", formalDefinition="Reference to another product, e.g. for linking authorised to investigational product.")
    protected List<MedicinalProductDefinitionCrossReferenceComponent> crossReference;
    @Child(name="operation", type={}, order=26, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A manufacturing or administrative process or step associated with (or performed on) the medicinal product", formalDefinition="A manufacturing or administrative process or step associated with (or performed on) the medicinal product.")
    protected List<MedicinalProductDefinitionOperationComponent> operation;
    @Child(name="characteristic", type={}, order=27, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Allows the key product features to be recorded, such as \"sugar free\", \"modified release\", \"parallel import\"", formalDefinition="Allows the key product features to be recorded, such as \"sugar free\", \"modified release\", \"parallel import\".")
    protected List<MedicinalProductDefinitionCharacteristicComponent> characteristic;
    private static final long serialVersionUID = -2099569280L;
    @SearchParamDefinition(name="characteristic-type", path="MedicinalProductDefinition.characteristic.type", description="A category for the characteristic", type="token")
    public static final String SP_CHARACTERISTIC_TYPE = "characteristic-type";
    public static final TokenClientParam CHARACTERISTIC_TYPE = new TokenClientParam("characteristic-type");
    @SearchParamDefinition(name="characteristic", path="MedicinalProductDefinition.characteristic.value", description="Allows the key product features to be recorded, such as \"sugar free\", \"modified release\", \"parallel import\"", type="token")
    public static final String SP_CHARACTERISTIC = "characteristic";
    public static final TokenClientParam CHARACTERISTIC = new TokenClientParam("characteristic");
    @SearchParamDefinition(name="contact", path="MedicinalProductDefinition.contact.contact", description="A product specific contact, person (in a role), or an organization", type="reference", target={Organization.class, PractitionerRole.class})
    public static final String SP_CONTACT = "contact";
    public static final ReferenceClientParam CONTACT = new ReferenceClientParam("contact");
    public static final Include INCLUDE_CONTACT = new Include("MedicinalProductDefinition:contact").toLocked();
    @SearchParamDefinition(name="domain", path="MedicinalProductDefinition.domain", description="If this medicine applies to human or veterinary uses", type="token")
    public static final String SP_DOMAIN = "domain";
    public static final TokenClientParam DOMAIN = new TokenClientParam("domain");
    @SearchParamDefinition(name="identifier", path="MedicinalProductDefinition.identifier", description="Business identifier for this product. Could be an MPID", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="ingredient", path="MedicinalProductDefinition.ingredient", description="An ingredient of this product", type="token")
    public static final String SP_INGREDIENT = "ingredient";
    public static final TokenClientParam INGREDIENT = new TokenClientParam("ingredient");
    @SearchParamDefinition(name="master-file", path="MedicinalProductDefinition.masterFile", description="A master file for to the medicinal product (e.g. Pharmacovigilance System Master File)", type="reference", target={DocumentReference.class})
    public static final String SP_MASTER_FILE = "master-file";
    public static final ReferenceClientParam MASTER_FILE = new ReferenceClientParam("master-file");
    public static final Include INCLUDE_MASTER_FILE = new Include("MedicinalProductDefinition:master-file").toLocked();
    @SearchParamDefinition(name="name-language", path="MedicinalProductDefinition.name.countryLanguage.language", description="Language code for this name", type="token")
    public static final String SP_NAME_LANGUAGE = "name-language";
    public static final TokenClientParam NAME_LANGUAGE = new TokenClientParam("name-language");
    @SearchParamDefinition(name="name", path="MedicinalProductDefinition.name.productName", description="The full product name", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="product-classification", path="MedicinalProductDefinition.classification", description="Allows the product to be classified by various systems", type="token")
    public static final String SP_PRODUCT_CLASSIFICATION = "product-classification";
    public static final TokenClientParam PRODUCT_CLASSIFICATION = new TokenClientParam("product-classification");
    @SearchParamDefinition(name="status", path="MedicinalProductDefinition.status", description="The status within the lifecycle of this product record. A high-level status, this is not intended to duplicate details carried elsewhere such as legal status, or authorization status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="type", path="MedicinalProductDefinition.type", description="Regulatory type, e.g. Investigational or Authorized", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public MedicinalProductDefinition() {
    }

    public MedicinalProductDefinition(MedicinalProductDefinitionNameComponent name) {
        this.addName(name);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicinalProductDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicinalProductDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public MedicinalProductDefinition setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public CodeableConcept getDomain() {
        if (this.domain == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.domain");
            }
            if (Configuration.doAutoCreate()) {
                this.domain = new CodeableConcept();
            }
        }
        return this.domain;
    }

    public boolean hasDomain() {
        return this.domain != null && !this.domain.isEmpty();
    }

    public MedicinalProductDefinition setDomain(CodeableConcept value) {
        this.domain = value;
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public MedicinalProductDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public MedicinalProductDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public CodeableConcept getStatus() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new CodeableConcept();
            }
        }
        return this.status;
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicinalProductDefinition setStatus(CodeableConcept value) {
        this.status = value;
        return this;
    }

    public DateTimeType getStatusDateElement() {
        if (this.statusDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.statusDate");
            }
            if (Configuration.doAutoCreate()) {
                this.statusDate = new DateTimeType();
            }
        }
        return this.statusDate;
    }

    public boolean hasStatusDateElement() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public boolean hasStatusDate() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public MedicinalProductDefinition setStatusDateElement(DateTimeType value) {
        this.statusDate = value;
        return this;
    }

    public Date getStatusDate() {
        return this.statusDate == null ? null : (Date)this.statusDate.getValue();
    }

    public MedicinalProductDefinition setStatusDate(Date value) {
        if (value == null) {
            this.statusDate = null;
        } else {
            if (this.statusDate == null) {
                this.statusDate = new DateTimeType();
            }
            this.statusDate.setValue(value);
        }
        return this;
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public MedicinalProductDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public MedicinalProductDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public CodeableConcept getCombinedPharmaceuticalDoseForm() {
        if (this.combinedPharmaceuticalDoseForm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.combinedPharmaceuticalDoseForm");
            }
            if (Configuration.doAutoCreate()) {
                this.combinedPharmaceuticalDoseForm = new CodeableConcept();
            }
        }
        return this.combinedPharmaceuticalDoseForm;
    }

    public boolean hasCombinedPharmaceuticalDoseForm() {
        return this.combinedPharmaceuticalDoseForm != null && !this.combinedPharmaceuticalDoseForm.isEmpty();
    }

    public MedicinalProductDefinition setCombinedPharmaceuticalDoseForm(CodeableConcept value) {
        this.combinedPharmaceuticalDoseForm = value;
        return this;
    }

    public List<CodeableConcept> getRoute() {
        if (this.route == null) {
            this.route = new ArrayList<CodeableConcept>();
        }
        return this.route;
    }

    public MedicinalProductDefinition setRoute(List<CodeableConcept> theRoute) {
        this.route = theRoute;
        return this;
    }

    public boolean hasRoute() {
        if (this.route == null) {
            return false;
        }
        for (CodeableConcept item : this.route) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addRoute() {
        CodeableConcept t = new CodeableConcept();
        if (this.route == null) {
            this.route = new ArrayList<CodeableConcept>();
        }
        this.route.add(t);
        return t;
    }

    public MedicinalProductDefinition addRoute(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.route == null) {
            this.route = new ArrayList<CodeableConcept>();
        }
        this.route.add(t);
        return this;
    }

    public CodeableConcept getRouteFirstRep() {
        if (this.getRoute().isEmpty()) {
            this.addRoute();
        }
        return this.getRoute().get(0);
    }

    public MarkdownType getIndicationElement() {
        if (this.indication == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.indication");
            }
            if (Configuration.doAutoCreate()) {
                this.indication = new MarkdownType();
            }
        }
        return this.indication;
    }

    public boolean hasIndicationElement() {
        return this.indication != null && !this.indication.isEmpty();
    }

    public boolean hasIndication() {
        return this.indication != null && !this.indication.isEmpty();
    }

    public MedicinalProductDefinition setIndicationElement(MarkdownType value) {
        this.indication = value;
        return this;
    }

    public String getIndication() {
        return this.indication == null ? null : (String)this.indication.getValue();
    }

    public MedicinalProductDefinition setIndication(String value) {
        if (value == null) {
            this.indication = null;
        } else {
            if (this.indication == null) {
                this.indication = new MarkdownType();
            }
            this.indication.setValue(value);
        }
        return this;
    }

    public CodeableConcept getLegalStatusOfSupply() {
        if (this.legalStatusOfSupply == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.legalStatusOfSupply");
            }
            if (Configuration.doAutoCreate()) {
                this.legalStatusOfSupply = new CodeableConcept();
            }
        }
        return this.legalStatusOfSupply;
    }

    public boolean hasLegalStatusOfSupply() {
        return this.legalStatusOfSupply != null && !this.legalStatusOfSupply.isEmpty();
    }

    public MedicinalProductDefinition setLegalStatusOfSupply(CodeableConcept value) {
        this.legalStatusOfSupply = value;
        return this;
    }

    public CodeableConcept getAdditionalMonitoringIndicator() {
        if (this.additionalMonitoringIndicator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.additionalMonitoringIndicator");
            }
            if (Configuration.doAutoCreate()) {
                this.additionalMonitoringIndicator = new CodeableConcept();
            }
        }
        return this.additionalMonitoringIndicator;
    }

    public boolean hasAdditionalMonitoringIndicator() {
        return this.additionalMonitoringIndicator != null && !this.additionalMonitoringIndicator.isEmpty();
    }

    public MedicinalProductDefinition setAdditionalMonitoringIndicator(CodeableConcept value) {
        this.additionalMonitoringIndicator = value;
        return this;
    }

    public List<CodeableConcept> getSpecialMeasures() {
        if (this.specialMeasures == null) {
            this.specialMeasures = new ArrayList<CodeableConcept>();
        }
        return this.specialMeasures;
    }

    public MedicinalProductDefinition setSpecialMeasures(List<CodeableConcept> theSpecialMeasures) {
        this.specialMeasures = theSpecialMeasures;
        return this;
    }

    public boolean hasSpecialMeasures() {
        if (this.specialMeasures == null) {
            return false;
        }
        for (CodeableConcept item : this.specialMeasures) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSpecialMeasures() {
        CodeableConcept t = new CodeableConcept();
        if (this.specialMeasures == null) {
            this.specialMeasures = new ArrayList<CodeableConcept>();
        }
        this.specialMeasures.add(t);
        return t;
    }

    public MedicinalProductDefinition addSpecialMeasures(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.specialMeasures == null) {
            this.specialMeasures = new ArrayList<CodeableConcept>();
        }
        this.specialMeasures.add(t);
        return this;
    }

    public CodeableConcept getSpecialMeasuresFirstRep() {
        if (this.getSpecialMeasures().isEmpty()) {
            this.addSpecialMeasures();
        }
        return this.getSpecialMeasures().get(0);
    }

    public CodeableConcept getPediatricUseIndicator() {
        if (this.pediatricUseIndicator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductDefinition.pediatricUseIndicator");
            }
            if (Configuration.doAutoCreate()) {
                this.pediatricUseIndicator = new CodeableConcept();
            }
        }
        return this.pediatricUseIndicator;
    }

    public boolean hasPediatricUseIndicator() {
        return this.pediatricUseIndicator != null && !this.pediatricUseIndicator.isEmpty();
    }

    public MedicinalProductDefinition setPediatricUseIndicator(CodeableConcept value) {
        this.pediatricUseIndicator = value;
        return this;
    }

    public List<CodeableConcept> getClassification() {
        if (this.classification == null) {
            this.classification = new ArrayList<CodeableConcept>();
        }
        return this.classification;
    }

    public MedicinalProductDefinition setClassification(List<CodeableConcept> theClassification) {
        this.classification = theClassification;
        return this;
    }

    public boolean hasClassification() {
        if (this.classification == null) {
            return false;
        }
        for (CodeableConcept item : this.classification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addClassification() {
        CodeableConcept t = new CodeableConcept();
        if (this.classification == null) {
            this.classification = new ArrayList<CodeableConcept>();
        }
        this.classification.add(t);
        return t;
    }

    public MedicinalProductDefinition addClassification(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.classification == null) {
            this.classification = new ArrayList<CodeableConcept>();
        }
        this.classification.add(t);
        return this;
    }

    public CodeableConcept getClassificationFirstRep() {
        if (this.getClassification().isEmpty()) {
            this.addClassification();
        }
        return this.getClassification().get(0);
    }

    public List<MarketingStatus> getMarketingStatus() {
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        return this.marketingStatus;
    }

    public MedicinalProductDefinition setMarketingStatus(List<MarketingStatus> theMarketingStatus) {
        this.marketingStatus = theMarketingStatus;
        return this;
    }

    public boolean hasMarketingStatus() {
        if (this.marketingStatus == null) {
            return false;
        }
        for (MarketingStatus item : this.marketingStatus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MarketingStatus addMarketingStatus() {
        MarketingStatus t = new MarketingStatus();
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        this.marketingStatus.add(t);
        return t;
    }

    public MedicinalProductDefinition addMarketingStatus(MarketingStatus t) {
        if (t == null) {
            return this;
        }
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        this.marketingStatus.add(t);
        return this;
    }

    public MarketingStatus getMarketingStatusFirstRep() {
        if (this.getMarketingStatus().isEmpty()) {
            this.addMarketingStatus();
        }
        return this.getMarketingStatus().get(0);
    }

    public List<CodeableConcept> getPackagedMedicinalProduct() {
        if (this.packagedMedicinalProduct == null) {
            this.packagedMedicinalProduct = new ArrayList<CodeableConcept>();
        }
        return this.packagedMedicinalProduct;
    }

    public MedicinalProductDefinition setPackagedMedicinalProduct(List<CodeableConcept> thePackagedMedicinalProduct) {
        this.packagedMedicinalProduct = thePackagedMedicinalProduct;
        return this;
    }

    public boolean hasPackagedMedicinalProduct() {
        if (this.packagedMedicinalProduct == null) {
            return false;
        }
        for (CodeableConcept item : this.packagedMedicinalProduct) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addPackagedMedicinalProduct() {
        CodeableConcept t = new CodeableConcept();
        if (this.packagedMedicinalProduct == null) {
            this.packagedMedicinalProduct = new ArrayList<CodeableConcept>();
        }
        this.packagedMedicinalProduct.add(t);
        return t;
    }

    public MedicinalProductDefinition addPackagedMedicinalProduct(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.packagedMedicinalProduct == null) {
            this.packagedMedicinalProduct = new ArrayList<CodeableConcept>();
        }
        this.packagedMedicinalProduct.add(t);
        return this;
    }

    public CodeableConcept getPackagedMedicinalProductFirstRep() {
        if (this.getPackagedMedicinalProduct().isEmpty()) {
            this.addPackagedMedicinalProduct();
        }
        return this.getPackagedMedicinalProduct().get(0);
    }

    public List<CodeableConcept> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<CodeableConcept>();
        }
        return this.ingredient;
    }

    public MedicinalProductDefinition setIngredient(List<CodeableConcept> theIngredient) {
        this.ingredient = theIngredient;
        return this;
    }

    public boolean hasIngredient() {
        if (this.ingredient == null) {
            return false;
        }
        for (CodeableConcept item : this.ingredient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addIngredient() {
        CodeableConcept t = new CodeableConcept();
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<CodeableConcept>();
        }
        this.ingredient.add(t);
        return t;
    }

    public MedicinalProductDefinition addIngredient(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<CodeableConcept>();
        }
        this.ingredient.add(t);
        return this;
    }

    public CodeableConcept getIngredientFirstRep() {
        if (this.getIngredient().isEmpty()) {
            this.addIngredient();
        }
        return this.getIngredient().get(0);
    }

    public List<CodeableReference> getImpurity() {
        if (this.impurity == null) {
            this.impurity = new ArrayList<CodeableReference>();
        }
        return this.impurity;
    }

    public MedicinalProductDefinition setImpurity(List<CodeableReference> theImpurity) {
        this.impurity = theImpurity;
        return this;
    }

    public boolean hasImpurity() {
        if (this.impurity == null) {
            return false;
        }
        for (CodeableReference item : this.impurity) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addImpurity() {
        CodeableReference t = new CodeableReference();
        if (this.impurity == null) {
            this.impurity = new ArrayList<CodeableReference>();
        }
        this.impurity.add(t);
        return t;
    }

    public MedicinalProductDefinition addImpurity(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.impurity == null) {
            this.impurity = new ArrayList<CodeableReference>();
        }
        this.impurity.add(t);
        return this;
    }

    public CodeableReference getImpurityFirstRep() {
        if (this.getImpurity().isEmpty()) {
            this.addImpurity();
        }
        return this.getImpurity().get(0);
    }

    public List<Reference> getAttachedDocument() {
        if (this.attachedDocument == null) {
            this.attachedDocument = new ArrayList<Reference>();
        }
        return this.attachedDocument;
    }

    public MedicinalProductDefinition setAttachedDocument(List<Reference> theAttachedDocument) {
        this.attachedDocument = theAttachedDocument;
        return this;
    }

    public boolean hasAttachedDocument() {
        if (this.attachedDocument == null) {
            return false;
        }
        for (Reference item : this.attachedDocument) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAttachedDocument() {
        Reference t = new Reference();
        if (this.attachedDocument == null) {
            this.attachedDocument = new ArrayList<Reference>();
        }
        this.attachedDocument.add(t);
        return t;
    }

    public MedicinalProductDefinition addAttachedDocument(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.attachedDocument == null) {
            this.attachedDocument = new ArrayList<Reference>();
        }
        this.attachedDocument.add(t);
        return this;
    }

    public Reference getAttachedDocumentFirstRep() {
        if (this.getAttachedDocument().isEmpty()) {
            this.addAttachedDocument();
        }
        return this.getAttachedDocument().get(0);
    }

    public List<Reference> getMasterFile() {
        if (this.masterFile == null) {
            this.masterFile = new ArrayList<Reference>();
        }
        return this.masterFile;
    }

    public MedicinalProductDefinition setMasterFile(List<Reference> theMasterFile) {
        this.masterFile = theMasterFile;
        return this;
    }

    public boolean hasMasterFile() {
        if (this.masterFile == null) {
            return false;
        }
        for (Reference item : this.masterFile) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addMasterFile() {
        Reference t = new Reference();
        if (this.masterFile == null) {
            this.masterFile = new ArrayList<Reference>();
        }
        this.masterFile.add(t);
        return t;
    }

    public MedicinalProductDefinition addMasterFile(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.masterFile == null) {
            this.masterFile = new ArrayList<Reference>();
        }
        this.masterFile.add(t);
        return this;
    }

    public Reference getMasterFileFirstRep() {
        if (this.getMasterFile().isEmpty()) {
            this.addMasterFile();
        }
        return this.getMasterFile().get(0);
    }

    public List<MedicinalProductDefinitionContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<MedicinalProductDefinitionContactComponent>();
        }
        return this.contact;
    }

    public MedicinalProductDefinition setContact(List<MedicinalProductDefinitionContactComponent> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (MedicinalProductDefinitionContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductDefinitionContactComponent addContact() {
        MedicinalProductDefinitionContactComponent t = new MedicinalProductDefinitionContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<MedicinalProductDefinitionContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public MedicinalProductDefinition addContact(MedicinalProductDefinitionContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<MedicinalProductDefinitionContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public MedicinalProductDefinitionContactComponent getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public List<Reference> getClinicalTrial() {
        if (this.clinicalTrial == null) {
            this.clinicalTrial = new ArrayList<Reference>();
        }
        return this.clinicalTrial;
    }

    public MedicinalProductDefinition setClinicalTrial(List<Reference> theClinicalTrial) {
        this.clinicalTrial = theClinicalTrial;
        return this;
    }

    public boolean hasClinicalTrial() {
        if (this.clinicalTrial == null) {
            return false;
        }
        for (Reference item : this.clinicalTrial) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addClinicalTrial() {
        Reference t = new Reference();
        if (this.clinicalTrial == null) {
            this.clinicalTrial = new ArrayList<Reference>();
        }
        this.clinicalTrial.add(t);
        return t;
    }

    public MedicinalProductDefinition addClinicalTrial(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.clinicalTrial == null) {
            this.clinicalTrial = new ArrayList<Reference>();
        }
        this.clinicalTrial.add(t);
        return this;
    }

    public Reference getClinicalTrialFirstRep() {
        if (this.getClinicalTrial().isEmpty()) {
            this.addClinicalTrial();
        }
        return this.getClinicalTrial().get(0);
    }

    public List<Coding> getCode() {
        if (this.code == null) {
            this.code = new ArrayList<Coding>();
        }
        return this.code;
    }

    public MedicinalProductDefinition setCode(List<Coding> theCode) {
        this.code = theCode;
        return this;
    }

    public boolean hasCode() {
        if (this.code == null) {
            return false;
        }
        for (Coding item : this.code) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addCode() {
        Coding t = new Coding();
        if (this.code == null) {
            this.code = new ArrayList<Coding>();
        }
        this.code.add(t);
        return t;
    }

    public MedicinalProductDefinition addCode(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.code == null) {
            this.code = new ArrayList<Coding>();
        }
        this.code.add(t);
        return this;
    }

    public Coding getCodeFirstRep() {
        if (this.getCode().isEmpty()) {
            this.addCode();
        }
        return this.getCode().get(0);
    }

    public List<MedicinalProductDefinitionNameComponent> getName() {
        if (this.name == null) {
            this.name = new ArrayList<MedicinalProductDefinitionNameComponent>();
        }
        return this.name;
    }

    public MedicinalProductDefinition setName(List<MedicinalProductDefinitionNameComponent> theName) {
        this.name = theName;
        return this;
    }

    public boolean hasName() {
        if (this.name == null) {
            return false;
        }
        for (MedicinalProductDefinitionNameComponent item : this.name) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductDefinitionNameComponent addName() {
        MedicinalProductDefinitionNameComponent t = new MedicinalProductDefinitionNameComponent();
        if (this.name == null) {
            this.name = new ArrayList<MedicinalProductDefinitionNameComponent>();
        }
        this.name.add(t);
        return t;
    }

    public MedicinalProductDefinition addName(MedicinalProductDefinitionNameComponent t) {
        if (t == null) {
            return this;
        }
        if (this.name == null) {
            this.name = new ArrayList<MedicinalProductDefinitionNameComponent>();
        }
        this.name.add(t);
        return this;
    }

    public MedicinalProductDefinitionNameComponent getNameFirstRep() {
        if (this.getName().isEmpty()) {
            this.addName();
        }
        return this.getName().get(0);
    }

    public List<MedicinalProductDefinitionCrossReferenceComponent> getCrossReference() {
        if (this.crossReference == null) {
            this.crossReference = new ArrayList<MedicinalProductDefinitionCrossReferenceComponent>();
        }
        return this.crossReference;
    }

    public MedicinalProductDefinition setCrossReference(List<MedicinalProductDefinitionCrossReferenceComponent> theCrossReference) {
        this.crossReference = theCrossReference;
        return this;
    }

    public boolean hasCrossReference() {
        if (this.crossReference == null) {
            return false;
        }
        for (MedicinalProductDefinitionCrossReferenceComponent item : this.crossReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductDefinitionCrossReferenceComponent addCrossReference() {
        MedicinalProductDefinitionCrossReferenceComponent t = new MedicinalProductDefinitionCrossReferenceComponent();
        if (this.crossReference == null) {
            this.crossReference = new ArrayList<MedicinalProductDefinitionCrossReferenceComponent>();
        }
        this.crossReference.add(t);
        return t;
    }

    public MedicinalProductDefinition addCrossReference(MedicinalProductDefinitionCrossReferenceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.crossReference == null) {
            this.crossReference = new ArrayList<MedicinalProductDefinitionCrossReferenceComponent>();
        }
        this.crossReference.add(t);
        return this;
    }

    public MedicinalProductDefinitionCrossReferenceComponent getCrossReferenceFirstRep() {
        if (this.getCrossReference().isEmpty()) {
            this.addCrossReference();
        }
        return this.getCrossReference().get(0);
    }

    public List<MedicinalProductDefinitionOperationComponent> getOperation() {
        if (this.operation == null) {
            this.operation = new ArrayList<MedicinalProductDefinitionOperationComponent>();
        }
        return this.operation;
    }

    public MedicinalProductDefinition setOperation(List<MedicinalProductDefinitionOperationComponent> theOperation) {
        this.operation = theOperation;
        return this;
    }

    public boolean hasOperation() {
        if (this.operation == null) {
            return false;
        }
        for (MedicinalProductDefinitionOperationComponent item : this.operation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductDefinitionOperationComponent addOperation() {
        MedicinalProductDefinitionOperationComponent t = new MedicinalProductDefinitionOperationComponent();
        if (this.operation == null) {
            this.operation = new ArrayList<MedicinalProductDefinitionOperationComponent>();
        }
        this.operation.add(t);
        return t;
    }

    public MedicinalProductDefinition addOperation(MedicinalProductDefinitionOperationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.operation == null) {
            this.operation = new ArrayList<MedicinalProductDefinitionOperationComponent>();
        }
        this.operation.add(t);
        return this;
    }

    public MedicinalProductDefinitionOperationComponent getOperationFirstRep() {
        if (this.getOperation().isEmpty()) {
            this.addOperation();
        }
        return this.getOperation().get(0);
    }

    public List<MedicinalProductDefinitionCharacteristicComponent> getCharacteristic() {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<MedicinalProductDefinitionCharacteristicComponent>();
        }
        return this.characteristic;
    }

    public MedicinalProductDefinition setCharacteristic(List<MedicinalProductDefinitionCharacteristicComponent> theCharacteristic) {
        this.characteristic = theCharacteristic;
        return this;
    }

    public boolean hasCharacteristic() {
        if (this.characteristic == null) {
            return false;
        }
        for (MedicinalProductDefinitionCharacteristicComponent item : this.characteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductDefinitionCharacteristicComponent addCharacteristic() {
        MedicinalProductDefinitionCharacteristicComponent t = new MedicinalProductDefinitionCharacteristicComponent();
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<MedicinalProductDefinitionCharacteristicComponent>();
        }
        this.characteristic.add(t);
        return t;
    }

    public MedicinalProductDefinition addCharacteristic(MedicinalProductDefinitionCharacteristicComponent t) {
        if (t == null) {
            return this;
        }
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<MedicinalProductDefinitionCharacteristicComponent>();
        }
        this.characteristic.add(t);
        return this;
    }

    public MedicinalProductDefinitionCharacteristicComponent getCharacteristicFirstRep() {
        if (this.getCharacteristic().isEmpty()) {
            this.addCharacteristic();
        }
        return this.getCharacteristic().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier for this product. Could be an MPID.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Regulatory type, e.g. Investigational or Authorized.", 0, 1, this.type));
        children.add(new Property(SP_DOMAIN, "CodeableConcept", "If this medicine applies to human or veterinary uses.", 0, 1, this.domain));
        children.add(new Property("version", "string", "A business identifier relating to a specific version of the product, this is commonly used to support revisions to an existing product.", 0, 1, this.version));
        children.add(new Property(SP_STATUS, "CodeableConcept", "The status within the lifecycle of this product record. A high-level status, this is not intended to duplicate details carried elsewhere such as legal status, or authorization status.", 0, 1, this.status));
        children.add(new Property("statusDate", "dateTime", "The date at which the given status became applicable.", 0, 1, this.statusDate));
        children.add(new Property("description", "markdown", "General description of this product.", 0, 1, this.description));
        children.add(new Property("combinedPharmaceuticalDoseForm", "CodeableConcept", "The dose form for a single part product, or combined form of a multiple part product.", 0, 1, this.combinedPharmaceuticalDoseForm));
        children.add(new Property("route", "CodeableConcept", "The path by which the product is taken into or makes contact with the body. In some regions this is referred to as the licenced or approved route. See also AdministrableProductDefinition resource.", 0, Integer.MAX_VALUE, this.route));
        children.add(new Property("indication", "markdown", "Description of indication(s) for this product, used when structured indications are not required. In cases where structured indications are required, they are captured using the ClinicalUseDefinition resource. An indication is a medical situation for which using the product is appropriate.", 0, 1, this.indication));
        children.add(new Property("legalStatusOfSupply", "CodeableConcept", "The legal status of supply of the medicinal product as classified by the regulator.", 0, 1, this.legalStatusOfSupply));
        children.add(new Property("additionalMonitoringIndicator", "CodeableConcept", "Whether the Medicinal Product is subject to additional monitoring for regulatory reasons.", 0, 1, this.additionalMonitoringIndicator));
        children.add(new Property("specialMeasures", "CodeableConcept", "Whether the Medicinal Product is subject to special measures for regulatory reasons.", 0, Integer.MAX_VALUE, this.specialMeasures));
        children.add(new Property("pediatricUseIndicator", "CodeableConcept", "If authorised for use in children.", 0, 1, this.pediatricUseIndicator));
        children.add(new Property("classification", "CodeableConcept", "Allows the product to be classified by various systems.", 0, Integer.MAX_VALUE, this.classification));
        children.add(new Property("marketingStatus", "MarketingStatus", "Marketing status of the medicinal product, in contrast to marketing authorization.", 0, Integer.MAX_VALUE, this.marketingStatus));
        children.add(new Property("packagedMedicinalProduct", "CodeableConcept", "Package representation for the product. See also the PackagedProductDefinition resource.", 0, Integer.MAX_VALUE, this.packagedMedicinalProduct));
        children.add(new Property(SP_INGREDIENT, "CodeableConcept", "The ingredients of this medicinal product - when not detailed in other resources. This is only needed if the ingredients are not specified by incoming references from the Ingredient resource, or indirectly via incoming AdministrableProductDefinition, PackagedProductDefinition or ManufacturedItemDefinition references. In cases where those levels of detail are not used, the ingredients may be specified directly here as codes.", 0, Integer.MAX_VALUE, this.ingredient));
        children.add(new Property("impurity", "CodeableReference(SubstanceDefinition)", "Any component of the drug product which is not the chemical entity defined as the drug substance or an excipient in the drug product. This includes process-related impurities and contaminants, product-related impurities including degradation products.", 0, Integer.MAX_VALUE, this.impurity));
        children.add(new Property("attachedDocument", "Reference(DocumentReference)", "Additional information or supporting documentation about the medicinal product.", 0, Integer.MAX_VALUE, this.attachedDocument));
        children.add(new Property("masterFile", "Reference(DocumentReference)", "A master file for the medicinal product (e.g. Pharmacovigilance System Master File). Drug master files (DMFs) are documents submitted to regulatory agencies to provide confidential detailed information about facilities, processes or articles used in the manufacturing, processing, packaging and storing of drug products.", 0, Integer.MAX_VALUE, this.masterFile));
        children.add(new Property(SP_CONTACT, "", "A product specific contact, person (in a role), or an organization.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("clinicalTrial", "Reference(ResearchStudy)", "Clinical trials or studies that this product is involved in.", 0, Integer.MAX_VALUE, this.clinicalTrial));
        children.add(new Property("code", "Coding", "A code that this product is known by, usually within some formal terminology. Products (types of medications) tend to be known by identifiers during development and within regulatory process. However when they are prescribed they tend to be identified by codes. The same product may be have multiple codes, applied to it by multiple organizations.", 0, Integer.MAX_VALUE, this.code));
        children.add(new Property(SP_NAME, "", "The product's name, including full name and possibly coded parts.", 0, Integer.MAX_VALUE, this.name));
        children.add(new Property("crossReference", "", "Reference to another product, e.g. for linking authorised to investigational product.", 0, Integer.MAX_VALUE, this.crossReference));
        children.add(new Property("operation", "", "A manufacturing or administrative process or step associated with (or performed on) the medicinal product.", 0, Integer.MAX_VALUE, this.operation));
        children.add(new Property(SP_CHARACTERISTIC, "", "Allows the key product features to be recorded, such as \"sugar free\", \"modified release\", \"parallel import\".", 0, Integer.MAX_VALUE, this.characteristic));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifier for this product. Could be an MPID.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Regulatory type, e.g. Investigational or Authorized.", 0, 1, this.type);
            }
            case -1326197564: {
                return new Property(SP_DOMAIN, "CodeableConcept", "If this medicine applies to human or veterinary uses.", 0, 1, this.domain);
            }
            case 351608024: {
                return new Property("version", "string", "A business identifier relating to a specific version of the product, this is commonly used to support revisions to an existing product.", 0, 1, this.version);
            }
            case -892481550: {
                return new Property(SP_STATUS, "CodeableConcept", "The status within the lifecycle of this product record. A high-level status, this is not intended to duplicate details carried elsewhere such as legal status, or authorization status.", 0, 1, this.status);
            }
            case 247524032: {
                return new Property("statusDate", "dateTime", "The date at which the given status became applicable.", 0, 1, this.statusDate);
            }
            case -1724546052: {
                return new Property("description", "markdown", "General description of this product.", 0, 1, this.description);
            }
            case -1992898487: {
                return new Property("combinedPharmaceuticalDoseForm", "CodeableConcept", "The dose form for a single part product, or combined form of a multiple part product.", 0, 1, this.combinedPharmaceuticalDoseForm);
            }
            case 108704329: {
                return new Property("route", "CodeableConcept", "The path by which the product is taken into or makes contact with the body. In some regions this is referred to as the licenced or approved route. See also AdministrableProductDefinition resource.", 0, Integer.MAX_VALUE, this.route);
            }
            case -597168804: {
                return new Property("indication", "markdown", "Description of indication(s) for this product, used when structured indications are not required. In cases where structured indications are required, they are captured using the ClinicalUseDefinition resource. An indication is a medical situation for which using the product is appropriate.", 0, 1, this.indication);
            }
            case -844874031: {
                return new Property("legalStatusOfSupply", "CodeableConcept", "The legal status of supply of the medicinal product as classified by the regulator.", 0, 1, this.legalStatusOfSupply);
            }
            case 1935999744: {
                return new Property("additionalMonitoringIndicator", "CodeableConcept", "Whether the Medicinal Product is subject to additional monitoring for regulatory reasons.", 0, 1, this.additionalMonitoringIndicator);
            }
            case 975102638: {
                return new Property("specialMeasures", "CodeableConcept", "Whether the Medicinal Product is subject to special measures for regulatory reasons.", 0, Integer.MAX_VALUE, this.specialMeasures);
            }
            case -1515533081: {
                return new Property("pediatricUseIndicator", "CodeableConcept", "If authorised for use in children.", 0, 1, this.pediatricUseIndicator);
            }
            case 382350310: {
                return new Property("classification", "CodeableConcept", "Allows the product to be classified by various systems.", 0, Integer.MAX_VALUE, this.classification);
            }
            case 70767032: {
                return new Property("marketingStatus", "MarketingStatus", "Marketing status of the medicinal product, in contrast to marketing authorization.", 0, Integer.MAX_VALUE, this.marketingStatus);
            }
            case -361025513: {
                return new Property("packagedMedicinalProduct", "CodeableConcept", "Package representation for the product. See also the PackagedProductDefinition resource.", 0, Integer.MAX_VALUE, this.packagedMedicinalProduct);
            }
            case -206409263: {
                return new Property(SP_INGREDIENT, "CodeableConcept", "The ingredients of this medicinal product - when not detailed in other resources. This is only needed if the ingredients are not specified by incoming references from the Ingredient resource, or indirectly via incoming AdministrableProductDefinition, PackagedProductDefinition or ManufacturedItemDefinition references. In cases where those levels of detail are not used, the ingredients may be specified directly here as codes.", 0, Integer.MAX_VALUE, this.ingredient);
            }
            case -416837467: {
                return new Property("impurity", "CodeableReference(SubstanceDefinition)", "Any component of the drug product which is not the chemical entity defined as the drug substance or an excipient in the drug product. This includes process-related impurities and contaminants, product-related impurities including degradation products.", 0, Integer.MAX_VALUE, this.impurity);
            }
            case -513945889: {
                return new Property("attachedDocument", "Reference(DocumentReference)", "Additional information or supporting documentation about the medicinal product.", 0, Integer.MAX_VALUE, this.attachedDocument);
            }
            case -2039573762: {
                return new Property("masterFile", "Reference(DocumentReference)", "A master file for the medicinal product (e.g. Pharmacovigilance System Master File). Drug master files (DMFs) are documents submitted to regulatory agencies to provide confidential detailed information about facilities, processes or articles used in the manufacturing, processing, packaging and storing of drug products.", 0, Integer.MAX_VALUE, this.masterFile);
            }
            case 951526432: {
                return new Property(SP_CONTACT, "", "A product specific contact, person (in a role), or an organization.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 1232866243: {
                return new Property("clinicalTrial", "Reference(ResearchStudy)", "Clinical trials or studies that this product is involved in.", 0, Integer.MAX_VALUE, this.clinicalTrial);
            }
            case 3059181: {
                return new Property("code", "Coding", "A code that this product is known by, usually within some formal terminology. Products (types of medications) tend to be known by identifiers during development and within regulatory process. However when they are prescribed they tend to be identified by codes. The same product may be have multiple codes, applied to it by multiple organizations.", 0, Integer.MAX_VALUE, this.code);
            }
            case 3373707: {
                return new Property(SP_NAME, "", "The product's name, including full name and possibly coded parts.", 0, Integer.MAX_VALUE, this.name);
            }
            case -986968341: {
                return new Property("crossReference", "", "Reference to another product, e.g. for linking authorised to investigational product.", 0, Integer.MAX_VALUE, this.crossReference);
            }
            case 1662702951: {
                return new Property("operation", "", "A manufacturing or administrative process or step associated with (or performed on) the medicinal product.", 0, Integer.MAX_VALUE, this.operation);
            }
            case 366313883: {
                return new Property(SP_CHARACTERISTIC, "", "Allows the key product features to be recorded, such as \"sugar free\", \"modified release\", \"parallel import\".", 0, Integer.MAX_VALUE, this.characteristic);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case -1326197564: {
                Base[] baseArray;
                if (this.domain == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.domain;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.version;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case 247524032: {
                Base[] baseArray;
                if (this.statusDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.statusDate;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.description;
                }
                return baseArray;
            }
            case -1992898487: {
                Base[] baseArray;
                if (this.combinedPharmaceuticalDoseForm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.combinedPharmaceuticalDoseForm;
                }
                return baseArray;
            }
            case 108704329: {
                return this.route == null ? new Base[]{} : this.route.toArray(new Base[this.route.size()]);
            }
            case -597168804: {
                Base[] baseArray;
                if (this.indication == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.indication;
                }
                return baseArray;
            }
            case -844874031: {
                Base[] baseArray;
                if (this.legalStatusOfSupply == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.legalStatusOfSupply;
                }
                return baseArray;
            }
            case 1935999744: {
                Base[] baseArray;
                if (this.additionalMonitoringIndicator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.additionalMonitoringIndicator;
                }
                return baseArray;
            }
            case 975102638: {
                return this.specialMeasures == null ? new Base[]{} : this.specialMeasures.toArray(new Base[this.specialMeasures.size()]);
            }
            case -1515533081: {
                Base[] baseArray;
                if (this.pediatricUseIndicator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.pediatricUseIndicator;
                }
                return baseArray;
            }
            case 382350310: {
                return this.classification == null ? new Base[]{} : this.classification.toArray(new Base[this.classification.size()]);
            }
            case 70767032: {
                return this.marketingStatus == null ? new Base[]{} : this.marketingStatus.toArray(new Base[this.marketingStatus.size()]);
            }
            case -361025513: {
                return this.packagedMedicinalProduct == null ? new Base[]{} : this.packagedMedicinalProduct.toArray(new Base[this.packagedMedicinalProduct.size()]);
            }
            case -206409263: {
                return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
            }
            case -416837467: {
                return this.impurity == null ? new Base[]{} : this.impurity.toArray(new Base[this.impurity.size()]);
            }
            case -513945889: {
                return this.attachedDocument == null ? new Base[]{} : this.attachedDocument.toArray(new Base[this.attachedDocument.size()]);
            }
            case -2039573762: {
                return this.masterFile == null ? new Base[]{} : this.masterFile.toArray(new Base[this.masterFile.size()]);
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 1232866243: {
                return this.clinicalTrial == null ? new Base[]{} : this.clinicalTrial.toArray(new Base[this.clinicalTrial.size()]);
            }
            case 3059181: {
                return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
            }
            case 3373707: {
                return this.name == null ? new Base[]{} : this.name.toArray(new Base[this.name.size()]);
            }
            case -986968341: {
                return this.crossReference == null ? new Base[]{} : this.crossReference.toArray(new Base[this.crossReference.size()]);
            }
            case 1662702951: {
                return this.operation == null ? new Base[]{} : this.operation.toArray(new Base[this.operation.size()]);
            }
            case 366313883: {
                return this.characteristic == null ? new Base[]{} : this.characteristic.toArray(new Base[this.characteristic.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1326197564: {
                this.domain = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 247524032: {
                this.statusDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -1992898487: {
                this.combinedPharmaceuticalDoseForm = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 108704329: {
                this.getRoute().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -597168804: {
                this.indication = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -844874031: {
                this.legalStatusOfSupply = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1935999744: {
                this.additionalMonitoringIndicator = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 975102638: {
                this.getSpecialMeasures().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1515533081: {
                this.pediatricUseIndicator = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 382350310: {
                this.getClassification().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 70767032: {
                this.getMarketingStatus().add(TypeConvertor.castToMarketingStatus(value));
                return value;
            }
            case -361025513: {
                this.getPackagedMedicinalProduct().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -206409263: {
                this.getIngredient().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -416837467: {
                this.getImpurity().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case -513945889: {
                this.getAttachedDocument().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -2039573762: {
                this.getMasterFile().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 951526432: {
                this.getContact().add((MedicinalProductDefinitionContactComponent)value);
                return value;
            }
            case 1232866243: {
                this.getClinicalTrial().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3059181: {
                this.getCode().add(TypeConvertor.castToCoding(value));
                return value;
            }
            case 3373707: {
                this.getName().add((MedicinalProductDefinitionNameComponent)value);
                return value;
            }
            case -986968341: {
                this.getCrossReference().add((MedicinalProductDefinitionCrossReferenceComponent)value);
                return value;
            }
            case 1662702951: {
                this.getOperation().add((MedicinalProductDefinitionOperationComponent)value);
                return value;
            }
            case 366313883: {
                this.getCharacteristic().add((MedicinalProductDefinitionCharacteristicComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_TYPE)) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_DOMAIN)) {
            this.domain = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("version")) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("statusDate")) {
            this.statusDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("combinedPharmaceuticalDoseForm")) {
            this.combinedPharmaceuticalDoseForm = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("route")) {
            this.getRoute().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("indication")) {
            this.indication = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("legalStatusOfSupply")) {
            this.legalStatusOfSupply = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("additionalMonitoringIndicator")) {
            this.additionalMonitoringIndicator = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("specialMeasures")) {
            this.getSpecialMeasures().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("pediatricUseIndicator")) {
            this.pediatricUseIndicator = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("classification")) {
            this.getClassification().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("marketingStatus")) {
            this.getMarketingStatus().add(TypeConvertor.castToMarketingStatus(value));
        } else if (name.equals("packagedMedicinalProduct")) {
            this.getPackagedMedicinalProduct().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_INGREDIENT)) {
            this.getIngredient().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("impurity")) {
            this.getImpurity().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("attachedDocument")) {
            this.getAttachedDocument().add(TypeConvertor.castToReference(value));
        } else if (name.equals("masterFile")) {
            this.getMasterFile().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_CONTACT)) {
            this.getContact().add((MedicinalProductDefinitionContactComponent)value);
        } else if (name.equals("clinicalTrial")) {
            this.getClinicalTrial().add(TypeConvertor.castToReference(value));
        } else if (name.equals("code")) {
            this.getCode().add(TypeConvertor.castToCoding(value));
        } else if (name.equals(SP_NAME)) {
            this.getName().add((MedicinalProductDefinitionNameComponent)value);
        } else if (name.equals("crossReference")) {
            this.getCrossReference().add((MedicinalProductDefinitionCrossReferenceComponent)value);
        } else if (name.equals("operation")) {
            this.getOperation().add((MedicinalProductDefinitionOperationComponent)value);
        } else if (name.equals(SP_CHARACTERISTIC)) {
            this.getCharacteristic().add((MedicinalProductDefinitionCharacteristicComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3575610: {
                return this.getType();
            }
            case -1326197564: {
                return this.getDomain();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -892481550: {
                return this.getStatus();
            }
            case 247524032: {
                return this.getStatusDateElement();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -1992898487: {
                return this.getCombinedPharmaceuticalDoseForm();
            }
            case 108704329: {
                return this.addRoute();
            }
            case -597168804: {
                return this.getIndicationElement();
            }
            case -844874031: {
                return this.getLegalStatusOfSupply();
            }
            case 1935999744: {
                return this.getAdditionalMonitoringIndicator();
            }
            case 975102638: {
                return this.addSpecialMeasures();
            }
            case -1515533081: {
                return this.getPediatricUseIndicator();
            }
            case 382350310: {
                return this.addClassification();
            }
            case 70767032: {
                return this.addMarketingStatus();
            }
            case -361025513: {
                return this.addPackagedMedicinalProduct();
            }
            case -206409263: {
                return this.addIngredient();
            }
            case -416837467: {
                return this.addImpurity();
            }
            case -513945889: {
                return this.addAttachedDocument();
            }
            case -2039573762: {
                return this.addMasterFile();
            }
            case 951526432: {
                return this.addContact();
            }
            case 1232866243: {
                return this.addClinicalTrial();
            }
            case 3059181: {
                return this.addCode();
            }
            case 3373707: {
                return this.addName();
            }
            case -986968341: {
                return this.addCrossReference();
            }
            case 1662702951: {
                return this.addOperation();
            }
            case 366313883: {
                return this.addCharacteristic();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1326197564: {
                return new String[]{"CodeableConcept"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"CodeableConcept"};
            }
            case 247524032: {
                return new String[]{"dateTime"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -1992898487: {
                return new String[]{"CodeableConcept"};
            }
            case 108704329: {
                return new String[]{"CodeableConcept"};
            }
            case -597168804: {
                return new String[]{"markdown"};
            }
            case -844874031: {
                return new String[]{"CodeableConcept"};
            }
            case 1935999744: {
                return new String[]{"CodeableConcept"};
            }
            case 975102638: {
                return new String[]{"CodeableConcept"};
            }
            case -1515533081: {
                return new String[]{"CodeableConcept"};
            }
            case 382350310: {
                return new String[]{"CodeableConcept"};
            }
            case 70767032: {
                return new String[]{"MarketingStatus"};
            }
            case -361025513: {
                return new String[]{"CodeableConcept"};
            }
            case -206409263: {
                return new String[]{"CodeableConcept"};
            }
            case -416837467: {
                return new String[]{"CodeableReference"};
            }
            case -513945889: {
                return new String[]{"Reference"};
            }
            case -2039573762: {
                return new String[]{"Reference"};
            }
            case 951526432: {
                return new String[0];
            }
            case 1232866243: {
                return new String[]{"Reference"};
            }
            case 3059181: {
                return new String[]{"Coding"};
            }
            case 3373707: {
                return new String[0];
            }
            case -986968341: {
                return new String[0];
            }
            case 1662702951: {
                return new String[0];
            }
            case 366313883: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_DOMAIN)) {
            this.domain = new CodeableConcept();
            return this.domain;
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicinalProductDefinition.version");
        }
        if (name.equals(SP_STATUS)) {
            this.status = new CodeableConcept();
            return this.status;
        }
        if (name.equals("statusDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicinalProductDefinition.statusDate");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicinalProductDefinition.description");
        }
        if (name.equals("combinedPharmaceuticalDoseForm")) {
            this.combinedPharmaceuticalDoseForm = new CodeableConcept();
            return this.combinedPharmaceuticalDoseForm;
        }
        if (name.equals("route")) {
            return this.addRoute();
        }
        if (name.equals("indication")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicinalProductDefinition.indication");
        }
        if (name.equals("legalStatusOfSupply")) {
            this.legalStatusOfSupply = new CodeableConcept();
            return this.legalStatusOfSupply;
        }
        if (name.equals("additionalMonitoringIndicator")) {
            this.additionalMonitoringIndicator = new CodeableConcept();
            return this.additionalMonitoringIndicator;
        }
        if (name.equals("specialMeasures")) {
            return this.addSpecialMeasures();
        }
        if (name.equals("pediatricUseIndicator")) {
            this.pediatricUseIndicator = new CodeableConcept();
            return this.pediatricUseIndicator;
        }
        if (name.equals("classification")) {
            return this.addClassification();
        }
        if (name.equals("marketingStatus")) {
            return this.addMarketingStatus();
        }
        if (name.equals("packagedMedicinalProduct")) {
            return this.addPackagedMedicinalProduct();
        }
        if (name.equals(SP_INGREDIENT)) {
            return this.addIngredient();
        }
        if (name.equals("impurity")) {
            return this.addImpurity();
        }
        if (name.equals("attachedDocument")) {
            return this.addAttachedDocument();
        }
        if (name.equals("masterFile")) {
            return this.addMasterFile();
        }
        if (name.equals(SP_CONTACT)) {
            return this.addContact();
        }
        if (name.equals("clinicalTrial")) {
            return this.addClinicalTrial();
        }
        if (name.equals("code")) {
            return this.addCode();
        }
        if (name.equals(SP_NAME)) {
            return this.addName();
        }
        if (name.equals("crossReference")) {
            return this.addCrossReference();
        }
        if (name.equals("operation")) {
            return this.addOperation();
        }
        if (name.equals(SP_CHARACTERISTIC)) {
            return this.addCharacteristic();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicinalProductDefinition";
    }

    @Override
    public MedicinalProductDefinition copy() {
        MedicinalProductDefinition dst = new MedicinalProductDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MedicinalProductDefinition dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.domain = this.domain == null ? null : this.domain.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.statusDate = this.statusDate == null ? null : this.statusDate.copy();
        dst.description = this.description == null ? null : this.description.copy();
        CodeableConcept codeableConcept = dst.combinedPharmaceuticalDoseForm = this.combinedPharmaceuticalDoseForm == null ? null : this.combinedPharmaceuticalDoseForm.copy();
        if (this.route != null) {
            dst.route = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.route) {
                dst.route.add(codeableConcept2.copy());
            }
        }
        dst.indication = this.indication == null ? null : this.indication.copy();
        dst.legalStatusOfSupply = this.legalStatusOfSupply == null ? null : this.legalStatusOfSupply.copy();
        CodeableConcept codeableConcept3 = dst.additionalMonitoringIndicator = this.additionalMonitoringIndicator == null ? null : this.additionalMonitoringIndicator.copy();
        if (this.specialMeasures != null) {
            dst.specialMeasures = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept4 : this.specialMeasures) {
                dst.specialMeasures.add(codeableConcept4.copy());
            }
        }
        CodeableConcept codeableConcept5 = dst.pediatricUseIndicator = this.pediatricUseIndicator == null ? null : this.pediatricUseIndicator.copy();
        if (this.classification != null) {
            dst.classification = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept6 : this.classification) {
                dst.classification.add(codeableConcept6.copy());
            }
        }
        if (this.marketingStatus != null) {
            dst.marketingStatus = new ArrayList<MarketingStatus>();
            for (MarketingStatus marketingStatus : this.marketingStatus) {
                dst.marketingStatus.add(marketingStatus.copy());
            }
        }
        if (this.packagedMedicinalProduct != null) {
            dst.packagedMedicinalProduct = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept7 : this.packagedMedicinalProduct) {
                dst.packagedMedicinalProduct.add(codeableConcept7.copy());
            }
        }
        if (this.ingredient != null) {
            dst.ingredient = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept8 : this.ingredient) {
                dst.ingredient.add(codeableConcept8.copy());
            }
        }
        if (this.impurity != null) {
            dst.impurity = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.impurity) {
                dst.impurity.add(codeableReference.copy());
            }
        }
        if (this.attachedDocument != null) {
            dst.attachedDocument = new ArrayList<Reference>();
            for (Reference reference : this.attachedDocument) {
                dst.attachedDocument.add(reference.copy());
            }
        }
        if (this.masterFile != null) {
            dst.masterFile = new ArrayList<Reference>();
            for (Reference reference : this.masterFile) {
                dst.masterFile.add(reference.copy());
            }
        }
        if (this.contact != null) {
            dst.contact = new ArrayList<MedicinalProductDefinitionContactComponent>();
            for (MedicinalProductDefinitionContactComponent medicinalProductDefinitionContactComponent : this.contact) {
                dst.contact.add(medicinalProductDefinitionContactComponent.copy());
            }
        }
        if (this.clinicalTrial != null) {
            dst.clinicalTrial = new ArrayList<Reference>();
            for (Reference reference : this.clinicalTrial) {
                dst.clinicalTrial.add(reference.copy());
            }
        }
        if (this.code != null) {
            dst.code = new ArrayList<Coding>();
            for (Coding coding : this.code) {
                dst.code.add(coding.copy());
            }
        }
        if (this.name != null) {
            dst.name = new ArrayList<MedicinalProductDefinitionNameComponent>();
            for (MedicinalProductDefinitionNameComponent medicinalProductDefinitionNameComponent : this.name) {
                dst.name.add(medicinalProductDefinitionNameComponent.copy());
            }
        }
        if (this.crossReference != null) {
            dst.crossReference = new ArrayList<MedicinalProductDefinitionCrossReferenceComponent>();
            for (MedicinalProductDefinitionCrossReferenceComponent medicinalProductDefinitionCrossReferenceComponent : this.crossReference) {
                dst.crossReference.add(medicinalProductDefinitionCrossReferenceComponent.copy());
            }
        }
        if (this.operation != null) {
            dst.operation = new ArrayList<MedicinalProductDefinitionOperationComponent>();
            for (MedicinalProductDefinitionOperationComponent medicinalProductDefinitionOperationComponent : this.operation) {
                dst.operation.add(medicinalProductDefinitionOperationComponent.copy());
            }
        }
        if (this.characteristic != null) {
            dst.characteristic = new ArrayList<MedicinalProductDefinitionCharacteristicComponent>();
            for (MedicinalProductDefinitionCharacteristicComponent medicinalProductDefinitionCharacteristicComponent : this.characteristic) {
                dst.characteristic.add(medicinalProductDefinitionCharacteristicComponent.copy());
            }
        }
    }

    protected MedicinalProductDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductDefinition)) {
            return false;
        }
        MedicinalProductDefinition o = (MedicinalProductDefinition)other_;
        return MedicinalProductDefinition.compareDeep(this.identifier, o.identifier, true) && MedicinalProductDefinition.compareDeep(this.type, o.type, true) && MedicinalProductDefinition.compareDeep(this.domain, o.domain, true) && MedicinalProductDefinition.compareDeep(this.version, o.version, true) && MedicinalProductDefinition.compareDeep(this.status, o.status, true) && MedicinalProductDefinition.compareDeep(this.statusDate, o.statusDate, true) && MedicinalProductDefinition.compareDeep(this.description, o.description, true) && MedicinalProductDefinition.compareDeep(this.combinedPharmaceuticalDoseForm, o.combinedPharmaceuticalDoseForm, true) && MedicinalProductDefinition.compareDeep(this.route, o.route, true) && MedicinalProductDefinition.compareDeep(this.indication, o.indication, true) && MedicinalProductDefinition.compareDeep(this.legalStatusOfSupply, o.legalStatusOfSupply, true) && MedicinalProductDefinition.compareDeep(this.additionalMonitoringIndicator, o.additionalMonitoringIndicator, true) && MedicinalProductDefinition.compareDeep(this.specialMeasures, o.specialMeasures, true) && MedicinalProductDefinition.compareDeep(this.pediatricUseIndicator, o.pediatricUseIndicator, true) && MedicinalProductDefinition.compareDeep(this.classification, o.classification, true) && MedicinalProductDefinition.compareDeep(this.marketingStatus, o.marketingStatus, true) && MedicinalProductDefinition.compareDeep(this.packagedMedicinalProduct, o.packagedMedicinalProduct, true) && MedicinalProductDefinition.compareDeep(this.ingredient, o.ingredient, true) && MedicinalProductDefinition.compareDeep(this.impurity, o.impurity, true) && MedicinalProductDefinition.compareDeep(this.attachedDocument, o.attachedDocument, true) && MedicinalProductDefinition.compareDeep(this.masterFile, o.masterFile, true) && MedicinalProductDefinition.compareDeep(this.contact, o.contact, true) && MedicinalProductDefinition.compareDeep(this.clinicalTrial, o.clinicalTrial, true) && MedicinalProductDefinition.compareDeep(this.code, o.code, true) && MedicinalProductDefinition.compareDeep(this.name, o.name, true) && MedicinalProductDefinition.compareDeep(this.crossReference, o.crossReference, true) && MedicinalProductDefinition.compareDeep(this.operation, o.operation, true) && MedicinalProductDefinition.compareDeep(this.characteristic, o.characteristic, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductDefinition)) {
            return false;
        }
        MedicinalProductDefinition o = (MedicinalProductDefinition)other_;
        return MedicinalProductDefinition.compareValues(this.version, o.version, true) && MedicinalProductDefinition.compareValues(this.statusDate, o.statusDate, true) && MedicinalProductDefinition.compareValues(this.description, o.description, true) && MedicinalProductDefinition.compareValues(this.indication, o.indication, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.domain, this.version, this.status, this.statusDate, this.description, this.combinedPharmaceuticalDoseForm, this.route, this.indication, this.legalStatusOfSupply, this.additionalMonitoringIndicator, this.specialMeasures, this.pediatricUseIndicator, this.classification, this.marketingStatus, this.packagedMedicinalProduct, this.ingredient, this.impurity, this.attachedDocument, this.masterFile, this.contact, this.clinicalTrial, this.code, this.name, this.crossReference, this.operation, this.characteristic});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicinalProductDefinition;
    }

    @Block
    public static class MedicinalProductDefinitionCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A code expressing the type of characteristic", formalDefinition="A code expressing the type of characteristic.")
        protected CodeableConcept type;
        @Child(name="value", type={CodeableConcept.class, Quantity.class, DateType.class, BooleanType.class, Attachment.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A value for the characteristic", formalDefinition="A value for the characteristic.")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public MedicinalProductDefinitionCharacteristicComponent() {
        }

        public MedicinalProductDefinitionCharacteristicComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionCharacteristicComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicinalProductDefinitionCharacteristicComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public DateType getValueDateType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateType();
            }
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this != null && this.value instanceof DateType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public MedicinalProductDefinitionCharacteristicComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Quantity || value instanceof DateType || value instanceof BooleanType || value instanceof Attachment)) {
                throw new Error("Not the right type for MedicinalProductDefinition.characteristic.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(MedicinalProductDefinition.SP_TYPE, "CodeableConcept", "A code expressing the type of characteristic.", 0, 1, this.type));
            children.add(new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(MedicinalProductDefinition.SP_TYPE, "CodeableConcept", "A code expressing the type of characteristic.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "A value for the characteristic.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "A value for the characteristic.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "date", "A value for the characteristic.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "A value for the characteristic.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "Quantity", "date", "boolean", "Attachment"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductDefinitionCharacteristicComponent copy() {
            MedicinalProductDefinitionCharacteristicComponent dst = new MedicinalProductDefinitionCharacteristicComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductDefinitionCharacteristicComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionCharacteristicComponent)) {
                return false;
            }
            MedicinalProductDefinitionCharacteristicComponent o = (MedicinalProductDefinitionCharacteristicComponent)other_;
            return MedicinalProductDefinitionCharacteristicComponent.compareDeep(this.type, o.type, true) && MedicinalProductDefinitionCharacteristicComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionCharacteristicComponent)) {
                return false;
            }
            MedicinalProductDefinitionCharacteristicComponent o = (MedicinalProductDefinitionCharacteristicComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductDefinition.characteristic";
        }
    }

    @Block
    public static class MedicinalProductDefinitionOperationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableReference.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of manufacturing operation e.g. manufacturing itself, re-packaging. For the authorization of this, a RegulatedAuthorization would point to the same plan or activity referenced here", formalDefinition="The type of manufacturing operation e.g. manufacturing itself, re-packaging. For the authorization of this, a RegulatedAuthorization would point to the same plan or activity referenced here.")
        protected CodeableReference type;
        @Child(name="effectiveDate", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Date range of applicability", formalDefinition="Date range of applicability.")
        protected Period effectiveDate;
        @Child(name="organization", type={Organization.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The organization or establishment responsible for (or associated with) the particular process or step, examples include the manufacturer, importer, agent", formalDefinition="The organization or establishment responsible for (or associated with) the particular process or step, examples include the manufacturer, importer, agent.")
        protected List<Reference> organization;
        @Child(name="confidentialityIndicator", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specifies whether this particular business or manufacturing process is considered proprietary or confidential", formalDefinition="Specifies whether this particular business or manufacturing process is considered proprietary or confidential.")
        protected CodeableConcept confidentialityIndicator;
        private static final long serialVersionUID = 1036054906L;

        public CodeableReference getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionOperationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableReference();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicinalProductDefinitionOperationComponent setType(CodeableReference value) {
            this.type = value;
            return this;
        }

        public Period getEffectiveDate() {
            if (this.effectiveDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionOperationComponent.effectiveDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.effectiveDate = new Period();
                }
            }
            return this.effectiveDate;
        }

        public boolean hasEffectiveDate() {
            return this.effectiveDate != null && !this.effectiveDate.isEmpty();
        }

        public MedicinalProductDefinitionOperationComponent setEffectiveDate(Period value) {
            this.effectiveDate = value;
            return this;
        }

        public List<Reference> getOrganization() {
            if (this.organization == null) {
                this.organization = new ArrayList<Reference>();
            }
            return this.organization;
        }

        public MedicinalProductDefinitionOperationComponent setOrganization(List<Reference> theOrganization) {
            this.organization = theOrganization;
            return this;
        }

        public boolean hasOrganization() {
            if (this.organization == null) {
                return false;
            }
            for (Reference item : this.organization) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addOrganization() {
            Reference t = new Reference();
            if (this.organization == null) {
                this.organization = new ArrayList<Reference>();
            }
            this.organization.add(t);
            return t;
        }

        public MedicinalProductDefinitionOperationComponent addOrganization(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.organization == null) {
                this.organization = new ArrayList<Reference>();
            }
            this.organization.add(t);
            return this;
        }

        public Reference getOrganizationFirstRep() {
            if (this.getOrganization().isEmpty()) {
                this.addOrganization();
            }
            return this.getOrganization().get(0);
        }

        public CodeableConcept getConfidentialityIndicator() {
            if (this.confidentialityIndicator == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionOperationComponent.confidentialityIndicator");
                }
                if (Configuration.doAutoCreate()) {
                    this.confidentialityIndicator = new CodeableConcept();
                }
            }
            return this.confidentialityIndicator;
        }

        public boolean hasConfidentialityIndicator() {
            return this.confidentialityIndicator != null && !this.confidentialityIndicator.isEmpty();
        }

        public MedicinalProductDefinitionOperationComponent setConfidentialityIndicator(CodeableConcept value) {
            this.confidentialityIndicator = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(MedicinalProductDefinition.SP_TYPE, "CodeableReference(ActivityDefinition|PlanDefinition)", "The type of manufacturing operation e.g. manufacturing itself, re-packaging. For the authorization of this, a RegulatedAuthorization would point to the same plan or activity referenced here.", 0, 1, this.type));
            children.add(new Property("effectiveDate", "Period", "Date range of applicability.", 0, 1, this.effectiveDate));
            children.add(new Property("organization", "Reference(Organization)", "The organization or establishment responsible for (or associated with) the particular process or step, examples include the manufacturer, importer, agent.", 0, Integer.MAX_VALUE, this.organization));
            children.add(new Property("confidentialityIndicator", "CodeableConcept", "Specifies whether this particular business or manufacturing process is considered proprietary or confidential.", 0, 1, this.confidentialityIndicator));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(MedicinalProductDefinition.SP_TYPE, "CodeableReference(ActivityDefinition|PlanDefinition)", "The type of manufacturing operation e.g. manufacturing itself, re-packaging. For the authorization of this, a RegulatedAuthorization would point to the same plan or activity referenced here.", 0, 1, this.type);
                }
                case -930389515: {
                    return new Property("effectiveDate", "Period", "Date range of applicability.", 0, 1, this.effectiveDate);
                }
                case 1178922291: {
                    return new Property("organization", "Reference(Organization)", "The organization or establishment responsible for (or associated with) the particular process or step, examples include the manufacturer, importer, agent.", 0, Integer.MAX_VALUE, this.organization);
                }
                case -1449404791: {
                    return new Property("confidentialityIndicator", "CodeableConcept", "Specifies whether this particular business or manufacturing process is considered proprietary or confidential.", 0, 1, this.confidentialityIndicator);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -930389515: {
                    Base[] baseArray;
                    if (this.effectiveDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.effectiveDate;
                    }
                    return baseArray;
                }
                case 1178922291: {
                    return this.organization == null ? new Base[]{} : this.organization.toArray(new Base[this.organization.size()]);
                }
                case -1449404791: {
                    Base[] baseArray;
                    if (this.confidentialityIndicator == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.confidentialityIndicator;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -930389515: {
                    this.effectiveDate = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case 1178922291: {
                    this.getOrganization().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -1449404791: {
                    this.confidentialityIndicator = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("effectiveDate")) {
                this.effectiveDate = TypeConvertor.castToPeriod(value);
            } else if (name.equals("organization")) {
                this.getOrganization().add(TypeConvertor.castToReference(value));
            } else if (name.equals("confidentialityIndicator")) {
                this.confidentialityIndicator = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -930389515: {
                    return this.getEffectiveDate();
                }
                case 1178922291: {
                    return this.addOrganization();
                }
                case -1449404791: {
                    return this.getConfidentialityIndicator();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableReference"};
                }
                case -930389515: {
                    return new String[]{"Period"};
                }
                case 1178922291: {
                    return new String[]{"Reference"};
                }
                case -1449404791: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = new CodeableReference();
                return this.type;
            }
            if (name.equals("effectiveDate")) {
                this.effectiveDate = new Period();
                return this.effectiveDate;
            }
            if (name.equals("organization")) {
                return this.addOrganization();
            }
            if (name.equals("confidentialityIndicator")) {
                this.confidentialityIndicator = new CodeableConcept();
                return this.confidentialityIndicator;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductDefinitionOperationComponent copy() {
            MedicinalProductDefinitionOperationComponent dst = new MedicinalProductDefinitionOperationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductDefinitionOperationComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            Period period = dst.effectiveDate = this.effectiveDate == null ? null : this.effectiveDate.copy();
            if (this.organization != null) {
                dst.organization = new ArrayList<Reference>();
                for (Reference i : this.organization) {
                    dst.organization.add(i.copy());
                }
            }
            dst.confidentialityIndicator = this.confidentialityIndicator == null ? null : this.confidentialityIndicator.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionOperationComponent)) {
                return false;
            }
            MedicinalProductDefinitionOperationComponent o = (MedicinalProductDefinitionOperationComponent)other_;
            return MedicinalProductDefinitionOperationComponent.compareDeep(this.type, o.type, true) && MedicinalProductDefinitionOperationComponent.compareDeep(this.effectiveDate, o.effectiveDate, true) && MedicinalProductDefinitionOperationComponent.compareDeep(this.organization, o.organization, true) && MedicinalProductDefinitionOperationComponent.compareDeep(this.confidentialityIndicator, o.confidentialityIndicator, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionOperationComponent)) {
                return false;
            }
            MedicinalProductDefinitionOperationComponent o = (MedicinalProductDefinitionOperationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.effectiveDate, this.organization, this.confidentialityIndicator});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductDefinition.operation";
        }
    }

    @Block
    public static class MedicinalProductDefinitionCrossReferenceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="product", type={CodeableReference.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to another product, e.g. for linking authorised to investigational product", formalDefinition="Reference to another product, e.g. for linking authorised to investigational product.")
        protected CodeableReference product;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of relationship, for instance branded to generic, product to development product (investigational), parallel import version", formalDefinition="The type of relationship, for instance branded to generic, product to development product (investigational), parallel import version.")
        protected CodeableConcept type;
        private static final long serialVersionUID = -1746125578L;

        public MedicinalProductDefinitionCrossReferenceComponent() {
        }

        public MedicinalProductDefinitionCrossReferenceComponent(CodeableReference product) {
            this.setProduct(product);
        }

        public CodeableReference getProduct() {
            if (this.product == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionCrossReferenceComponent.product");
                }
                if (Configuration.doAutoCreate()) {
                    this.product = new CodeableReference();
                }
            }
            return this.product;
        }

        public boolean hasProduct() {
            return this.product != null && !this.product.isEmpty();
        }

        public MedicinalProductDefinitionCrossReferenceComponent setProduct(CodeableReference value) {
            this.product = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionCrossReferenceComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicinalProductDefinitionCrossReferenceComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("product", "CodeableReference(MedicinalProductDefinition)", "Reference to another product, e.g. for linking authorised to investigational product.", 0, 1, this.product));
            children.add(new Property(MedicinalProductDefinition.SP_TYPE, "CodeableConcept", "The type of relationship, for instance branded to generic, product to development product (investigational), parallel import version.", 0, 1, this.type));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -309474065: {
                    return new Property("product", "CodeableReference(MedicinalProductDefinition)", "Reference to another product, e.g. for linking authorised to investigational product.", 0, 1, this.product);
                }
                case 3575610: {
                    return new Property(MedicinalProductDefinition.SP_TYPE, "CodeableConcept", "The type of relationship, for instance branded to generic, product to development product (investigational), parallel import version.", 0, 1, this.type);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -309474065: {
                    Base[] baseArray;
                    if (this.product == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.product;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -309474065: {
                    this.product = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("product")) {
                this.product = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -309474065: {
                    return this.getProduct();
                }
                case 3575610: {
                    return this.getType();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -309474065: {
                    return new String[]{"CodeableReference"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("product")) {
                this.product = new CodeableReference();
                return this.product;
            }
            if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductDefinitionCrossReferenceComponent copy() {
            MedicinalProductDefinitionCrossReferenceComponent dst = new MedicinalProductDefinitionCrossReferenceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductDefinitionCrossReferenceComponent dst) {
            super.copyValues(dst);
            dst.product = this.product == null ? null : this.product.copy();
            dst.type = this.type == null ? null : this.type.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionCrossReferenceComponent)) {
                return false;
            }
            MedicinalProductDefinitionCrossReferenceComponent o = (MedicinalProductDefinitionCrossReferenceComponent)other_;
            return MedicinalProductDefinitionCrossReferenceComponent.compareDeep(this.product, o.product, true) && MedicinalProductDefinitionCrossReferenceComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionCrossReferenceComponent)) {
                return false;
            }
            MedicinalProductDefinitionCrossReferenceComponent o = (MedicinalProductDefinitionCrossReferenceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.product, this.type});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductDefinition.crossReference";
        }
    }

    @Block
    public static class MedicinalProductDefinitionNameCountryLanguageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="country", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Country code for where this name applies", formalDefinition="Country code for where this name applies.")
        protected CodeableConcept country;
        @Child(name="jurisdiction", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Jurisdiction code for where this name applies", formalDefinition="Jurisdiction code for where this name applies.")
        protected CodeableConcept jurisdiction;
        @Child(name="language", type={CodeableConcept.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Language code for this name", formalDefinition="Language code for this name.")
        protected CodeableConcept language;
        private static final long serialVersionUID = 1627157564L;

        public MedicinalProductDefinitionNameCountryLanguageComponent() {
        }

        public MedicinalProductDefinitionNameCountryLanguageComponent(CodeableConcept country, CodeableConcept language) {
            this.setCountry(country);
            this.setLanguage(language);
        }

        public CodeableConcept getCountry() {
            if (this.country == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionNameCountryLanguageComponent.country");
                }
                if (Configuration.doAutoCreate()) {
                    this.country = new CodeableConcept();
                }
            }
            return this.country;
        }

        public boolean hasCountry() {
            return this.country != null && !this.country.isEmpty();
        }

        public MedicinalProductDefinitionNameCountryLanguageComponent setCountry(CodeableConcept value) {
            this.country = value;
            return this;
        }

        public CodeableConcept getJurisdiction() {
            if (this.jurisdiction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionNameCountryLanguageComponent.jurisdiction");
                }
                if (Configuration.doAutoCreate()) {
                    this.jurisdiction = new CodeableConcept();
                }
            }
            return this.jurisdiction;
        }

        public boolean hasJurisdiction() {
            return this.jurisdiction != null && !this.jurisdiction.isEmpty();
        }

        public MedicinalProductDefinitionNameCountryLanguageComponent setJurisdiction(CodeableConcept value) {
            this.jurisdiction = value;
            return this;
        }

        public CodeableConcept getLanguage() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionNameCountryLanguageComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeableConcept();
                }
            }
            return this.language;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public MedicinalProductDefinitionNameCountryLanguageComponent setLanguage(CodeableConcept value) {
            this.language = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("country", "CodeableConcept", "Country code for where this name applies.", 0, 1, this.country));
            children.add(new Property("jurisdiction", "CodeableConcept", "Jurisdiction code for where this name applies.", 0, 1, this.jurisdiction));
            children.add(new Property("language", "CodeableConcept", "Language code for this name.", 0, 1, this.language));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 957831062: {
                    return new Property("country", "CodeableConcept", "Country code for where this name applies.", 0, 1, this.country);
                }
                case -507075711: {
                    return new Property("jurisdiction", "CodeableConcept", "Jurisdiction code for where this name applies.", 0, 1, this.jurisdiction);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "Language code for this name.", 0, 1, this.language);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 957831062: {
                    Base[] baseArray;
                    if (this.country == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.country;
                    }
                    return baseArray;
                }
                case -507075711: {
                    Base[] baseArray;
                    if (this.jurisdiction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.jurisdiction;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.language;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 957831062: {
                    this.country = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -507075711: {
                    this.jurisdiction = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1613589672: {
                    this.language = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("country")) {
                this.country = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("jurisdiction")) {
                this.jurisdiction = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("language")) {
                this.language = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 957831062: {
                    return this.getCountry();
                }
                case -507075711: {
                    return this.getJurisdiction();
                }
                case -1613589672: {
                    return this.getLanguage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 957831062: {
                    return new String[]{"CodeableConcept"};
                }
                case -507075711: {
                    return new String[]{"CodeableConcept"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("country")) {
                this.country = new CodeableConcept();
                return this.country;
            }
            if (name.equals("jurisdiction")) {
                this.jurisdiction = new CodeableConcept();
                return this.jurisdiction;
            }
            if (name.equals("language")) {
                this.language = new CodeableConcept();
                return this.language;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductDefinitionNameCountryLanguageComponent copy() {
            MedicinalProductDefinitionNameCountryLanguageComponent dst = new MedicinalProductDefinitionNameCountryLanguageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductDefinitionNameCountryLanguageComponent dst) {
            super.copyValues(dst);
            dst.country = this.country == null ? null : this.country.copy();
            dst.jurisdiction = this.jurisdiction == null ? null : this.jurisdiction.copy();
            dst.language = this.language == null ? null : this.language.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionNameCountryLanguageComponent)) {
                return false;
            }
            MedicinalProductDefinitionNameCountryLanguageComponent o = (MedicinalProductDefinitionNameCountryLanguageComponent)other_;
            return MedicinalProductDefinitionNameCountryLanguageComponent.compareDeep(this.country, o.country, true) && MedicinalProductDefinitionNameCountryLanguageComponent.compareDeep(this.jurisdiction, o.jurisdiction, true) && MedicinalProductDefinitionNameCountryLanguageComponent.compareDeep(this.language, o.language, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionNameCountryLanguageComponent)) {
                return false;
            }
            MedicinalProductDefinitionNameCountryLanguageComponent o = (MedicinalProductDefinitionNameCountryLanguageComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.country, this.jurisdiction, this.language});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductDefinition.name.countryLanguage";
        }
    }

    @Block
    public static class MedicinalProductDefinitionNameNamePartComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="part", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A fragment of a product name", formalDefinition="A fragment of a product name.")
        protected StringType part;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifying type for this part of the name (e.g. strength part)", formalDefinition="Identifying type for this part of the name (e.g. strength part).")
        protected CodeableConcept type;
        private static final long serialVersionUID = -1359126549L;

        public MedicinalProductDefinitionNameNamePartComponent() {
        }

        public MedicinalProductDefinitionNameNamePartComponent(String part, CodeableConcept type) {
            this.setPart(part);
            this.setType(type);
        }

        public StringType getPartElement() {
            if (this.part == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionNameNamePartComponent.part");
                }
                if (Configuration.doAutoCreate()) {
                    this.part = new StringType();
                }
            }
            return this.part;
        }

        public boolean hasPartElement() {
            return this.part != null && !this.part.isEmpty();
        }

        public boolean hasPart() {
            return this.part != null && !this.part.isEmpty();
        }

        public MedicinalProductDefinitionNameNamePartComponent setPartElement(StringType value) {
            this.part = value;
            return this;
        }

        public String getPart() {
            return this.part == null ? null : (String)this.part.getValue();
        }

        public MedicinalProductDefinitionNameNamePartComponent setPart(String value) {
            if (this.part == null) {
                this.part = new StringType();
            }
            this.part.setValue(value);
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionNameNamePartComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicinalProductDefinitionNameNamePartComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("part", "string", "A fragment of a product name.", 0, 1, this.part));
            children.add(new Property(MedicinalProductDefinition.SP_TYPE, "CodeableConcept", "Identifying type for this part of the name (e.g. strength part).", 0, 1, this.type));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3433459: {
                    return new Property("part", "string", "A fragment of a product name.", 0, 1, this.part);
                }
                case 3575610: {
                    return new Property(MedicinalProductDefinition.SP_TYPE, "CodeableConcept", "Identifying type for this part of the name (e.g. strength part).", 0, 1, this.type);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433459: {
                    Base[] baseArray;
                    if (this.part == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.part;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433459: {
                    this.part = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("part")) {
                this.part = TypeConvertor.castToString(value);
            } else if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433459: {
                    return this.getPartElement();
                }
                case 3575610: {
                    return this.getType();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433459: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("part")) {
                throw new FHIRException("Cannot call addChild on a singleton property MedicinalProductDefinition.name.namePart.part");
            }
            if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductDefinitionNameNamePartComponent copy() {
            MedicinalProductDefinitionNameNamePartComponent dst = new MedicinalProductDefinitionNameNamePartComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductDefinitionNameNamePartComponent dst) {
            super.copyValues(dst);
            dst.part = this.part == null ? null : this.part.copy();
            dst.type = this.type == null ? null : this.type.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionNameNamePartComponent)) {
                return false;
            }
            MedicinalProductDefinitionNameNamePartComponent o = (MedicinalProductDefinitionNameNamePartComponent)other_;
            return MedicinalProductDefinitionNameNamePartComponent.compareDeep(this.part, o.part, true) && MedicinalProductDefinitionNameNamePartComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionNameNamePartComponent)) {
                return false;
            }
            MedicinalProductDefinitionNameNamePartComponent o = (MedicinalProductDefinitionNameNamePartComponent)other_;
            return MedicinalProductDefinitionNameNamePartComponent.compareValues(this.part, o.part, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.part, this.type});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductDefinition.name.namePart";
        }
    }

    @Block
    public static class MedicinalProductDefinitionNameComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="productName", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The full product name", formalDefinition="The full product name.")
        protected StringType productName;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of product name, such as rINN, BAN, Proprietary, Non-Proprietary", formalDefinition="Type of product name, such as rINN, BAN, Proprietary, Non-Proprietary.")
        protected CodeableConcept type;
        @Child(name="namePart", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Coding words or phrases of the name", formalDefinition="Coding words or phrases of the name.")
        protected List<MedicinalProductDefinitionNameNamePartComponent> namePart;
        @Child(name="countryLanguage", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Country where the name applies", formalDefinition="Country where the name applies.")
        protected List<MedicinalProductDefinitionNameCountryLanguageComponent> countryLanguage;
        private static final long serialVersionUID = 829861294L;

        public MedicinalProductDefinitionNameComponent() {
        }

        public MedicinalProductDefinitionNameComponent(String productName) {
            this.setProductName(productName);
        }

        public StringType getProductNameElement() {
            if (this.productName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionNameComponent.productName");
                }
                if (Configuration.doAutoCreate()) {
                    this.productName = new StringType();
                }
            }
            return this.productName;
        }

        public boolean hasProductNameElement() {
            return this.productName != null && !this.productName.isEmpty();
        }

        public boolean hasProductName() {
            return this.productName != null && !this.productName.isEmpty();
        }

        public MedicinalProductDefinitionNameComponent setProductNameElement(StringType value) {
            this.productName = value;
            return this;
        }

        public String getProductName() {
            return this.productName == null ? null : (String)this.productName.getValue();
        }

        public MedicinalProductDefinitionNameComponent setProductName(String value) {
            if (this.productName == null) {
                this.productName = new StringType();
            }
            this.productName.setValue(value);
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionNameComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicinalProductDefinitionNameComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<MedicinalProductDefinitionNameNamePartComponent> getNamePart() {
            if (this.namePart == null) {
                this.namePart = new ArrayList<MedicinalProductDefinitionNameNamePartComponent>();
            }
            return this.namePart;
        }

        public MedicinalProductDefinitionNameComponent setNamePart(List<MedicinalProductDefinitionNameNamePartComponent> theNamePart) {
            this.namePart = theNamePart;
            return this;
        }

        public boolean hasNamePart() {
            if (this.namePart == null) {
                return false;
            }
            for (MedicinalProductDefinitionNameNamePartComponent item : this.namePart) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductDefinitionNameNamePartComponent addNamePart() {
            MedicinalProductDefinitionNameNamePartComponent t = new MedicinalProductDefinitionNameNamePartComponent();
            if (this.namePart == null) {
                this.namePart = new ArrayList<MedicinalProductDefinitionNameNamePartComponent>();
            }
            this.namePart.add(t);
            return t;
        }

        public MedicinalProductDefinitionNameComponent addNamePart(MedicinalProductDefinitionNameNamePartComponent t) {
            if (t == null) {
                return this;
            }
            if (this.namePart == null) {
                this.namePart = new ArrayList<MedicinalProductDefinitionNameNamePartComponent>();
            }
            this.namePart.add(t);
            return this;
        }

        public MedicinalProductDefinitionNameNamePartComponent getNamePartFirstRep() {
            if (this.getNamePart().isEmpty()) {
                this.addNamePart();
            }
            return this.getNamePart().get(0);
        }

        public List<MedicinalProductDefinitionNameCountryLanguageComponent> getCountryLanguage() {
            if (this.countryLanguage == null) {
                this.countryLanguage = new ArrayList<MedicinalProductDefinitionNameCountryLanguageComponent>();
            }
            return this.countryLanguage;
        }

        public MedicinalProductDefinitionNameComponent setCountryLanguage(List<MedicinalProductDefinitionNameCountryLanguageComponent> theCountryLanguage) {
            this.countryLanguage = theCountryLanguage;
            return this;
        }

        public boolean hasCountryLanguage() {
            if (this.countryLanguage == null) {
                return false;
            }
            for (MedicinalProductDefinitionNameCountryLanguageComponent item : this.countryLanguage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductDefinitionNameCountryLanguageComponent addCountryLanguage() {
            MedicinalProductDefinitionNameCountryLanguageComponent t = new MedicinalProductDefinitionNameCountryLanguageComponent();
            if (this.countryLanguage == null) {
                this.countryLanguage = new ArrayList<MedicinalProductDefinitionNameCountryLanguageComponent>();
            }
            this.countryLanguage.add(t);
            return t;
        }

        public MedicinalProductDefinitionNameComponent addCountryLanguage(MedicinalProductDefinitionNameCountryLanguageComponent t) {
            if (t == null) {
                return this;
            }
            if (this.countryLanguage == null) {
                this.countryLanguage = new ArrayList<MedicinalProductDefinitionNameCountryLanguageComponent>();
            }
            this.countryLanguage.add(t);
            return this;
        }

        public MedicinalProductDefinitionNameCountryLanguageComponent getCountryLanguageFirstRep() {
            if (this.getCountryLanguage().isEmpty()) {
                this.addCountryLanguage();
            }
            return this.getCountryLanguage().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("productName", "string", "The full product name.", 0, 1, this.productName));
            children.add(new Property(MedicinalProductDefinition.SP_TYPE, "CodeableConcept", "Type of product name, such as rINN, BAN, Proprietary, Non-Proprietary.", 0, 1, this.type));
            children.add(new Property("namePart", "", "Coding words or phrases of the name.", 0, Integer.MAX_VALUE, this.namePart));
            children.add(new Property("countryLanguage", "", "Country where the name applies.", 0, Integer.MAX_VALUE, this.countryLanguage));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1491817446: {
                    return new Property("productName", "string", "The full product name.", 0, 1, this.productName);
                }
                case 3575610: {
                    return new Property(MedicinalProductDefinition.SP_TYPE, "CodeableConcept", "Type of product name, such as rINN, BAN, Proprietary, Non-Proprietary.", 0, 1, this.type);
                }
                case 1840452894: {
                    return new Property("namePart", "", "Coding words or phrases of the name.", 0, Integer.MAX_VALUE, this.namePart);
                }
                case -141141746: {
                    return new Property("countryLanguage", "", "Country where the name applies.", 0, Integer.MAX_VALUE, this.countryLanguage);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1491817446: {
                    Base[] baseArray;
                    if (this.productName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.productName;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 1840452894: {
                    return this.namePart == null ? new Base[]{} : this.namePart.toArray(new Base[this.namePart.size()]);
                }
                case -141141746: {
                    return this.countryLanguage == null ? new Base[]{} : this.countryLanguage.toArray(new Base[this.countryLanguage.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1491817446: {
                    this.productName = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1840452894: {
                    this.getNamePart().add((MedicinalProductDefinitionNameNamePartComponent)value);
                    return value;
                }
                case -141141746: {
                    this.getCountryLanguage().add((MedicinalProductDefinitionNameCountryLanguageComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("productName")) {
                this.productName = TypeConvertor.castToString(value);
            } else if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("namePart")) {
                this.getNamePart().add((MedicinalProductDefinitionNameNamePartComponent)value);
            } else if (name.equals("countryLanguage")) {
                this.getCountryLanguage().add((MedicinalProductDefinitionNameCountryLanguageComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1491817446: {
                    return this.getProductNameElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case 1840452894: {
                    return this.addNamePart();
                }
                case -141141746: {
                    return this.addCountryLanguage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1491817446: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1840452894: {
                    return new String[0];
                }
                case -141141746: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("productName")) {
                throw new FHIRException("Cannot call addChild on a singleton property MedicinalProductDefinition.name.productName");
            }
            if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("namePart")) {
                return this.addNamePart();
            }
            if (name.equals("countryLanguage")) {
                return this.addCountryLanguage();
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductDefinitionNameComponent copy() {
            MedicinalProductDefinitionNameComponent dst = new MedicinalProductDefinitionNameComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductDefinitionNameComponent dst) {
            super.copyValues(dst);
            dst.productName = this.productName == null ? null : this.productName.copy();
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.namePart != null) {
                dst.namePart = new ArrayList<MedicinalProductDefinitionNameNamePartComponent>();
                for (MedicinalProductDefinitionNameNamePartComponent medicinalProductDefinitionNameNamePartComponent : this.namePart) {
                    dst.namePart.add(medicinalProductDefinitionNameNamePartComponent.copy());
                }
            }
            if (this.countryLanguage != null) {
                dst.countryLanguage = new ArrayList<MedicinalProductDefinitionNameCountryLanguageComponent>();
                for (MedicinalProductDefinitionNameCountryLanguageComponent medicinalProductDefinitionNameCountryLanguageComponent : this.countryLanguage) {
                    dst.countryLanguage.add(medicinalProductDefinitionNameCountryLanguageComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionNameComponent)) {
                return false;
            }
            MedicinalProductDefinitionNameComponent o = (MedicinalProductDefinitionNameComponent)other_;
            return MedicinalProductDefinitionNameComponent.compareDeep(this.productName, o.productName, true) && MedicinalProductDefinitionNameComponent.compareDeep(this.type, o.type, true) && MedicinalProductDefinitionNameComponent.compareDeep(this.namePart, o.namePart, true) && MedicinalProductDefinitionNameComponent.compareDeep(this.countryLanguage, o.countryLanguage, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionNameComponent)) {
                return false;
            }
            MedicinalProductDefinitionNameComponent o = (MedicinalProductDefinitionNameComponent)other_;
            return MedicinalProductDefinitionNameComponent.compareValues(this.productName, o.productName, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.productName, this.type, this.namePart, this.countryLanguage});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductDefinition.name";
        }
    }

    @Block
    public static class MedicinalProductDefinitionContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Allows the contact to be classified, for example QPPV, Pharmacovigilance Enquiry Information", formalDefinition="Allows the contact to be classified, for example QPPV, Pharmacovigilance Enquiry Information.")
        protected CodeableConcept type;
        @Child(name="contact", type={Organization.class, PractitionerRole.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A product specific contact, person (in a role), or an organization", formalDefinition="A product specific contact, person (in a role), or an organization.")
        protected Reference contact;
        private static final long serialVersionUID = -587616244L;

        public MedicinalProductDefinitionContactComponent() {
        }

        public MedicinalProductDefinitionContactComponent(Reference contact) {
            this.setContact(contact);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionContactComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicinalProductDefinitionContactComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Reference getContact() {
            if (this.contact == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductDefinitionContactComponent.contact");
                }
                if (Configuration.doAutoCreate()) {
                    this.contact = new Reference();
                }
            }
            return this.contact;
        }

        public boolean hasContact() {
            return this.contact != null && !this.contact.isEmpty();
        }

        public MedicinalProductDefinitionContactComponent setContact(Reference value) {
            this.contact = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(MedicinalProductDefinition.SP_TYPE, "CodeableConcept", "Allows the contact to be classified, for example QPPV, Pharmacovigilance Enquiry Information.", 0, 1, this.type));
            children.add(new Property(MedicinalProductDefinition.SP_CONTACT, "Reference(Organization|PractitionerRole)", "A product specific contact, person (in a role), or an organization.", 0, 1, this.contact));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(MedicinalProductDefinition.SP_TYPE, "CodeableConcept", "Allows the contact to be classified, for example QPPV, Pharmacovigilance Enquiry Information.", 0, 1, this.type);
                }
                case 951526432: {
                    return new Property(MedicinalProductDefinition.SP_CONTACT, "Reference(Organization|PractitionerRole)", "A product specific contact, person (in a role), or an organization.", 0, 1, this.contact);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 951526432: {
                    Base[] baseArray;
                    if (this.contact == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.contact;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 951526432: {
                    this.contact = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(MedicinalProductDefinition.SP_CONTACT)) {
                this.contact = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 951526432: {
                    return this.getContact();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 951526432: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(MedicinalProductDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals(MedicinalProductDefinition.SP_CONTACT)) {
                this.contact = new Reference();
                return this.contact;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductDefinitionContactComponent copy() {
            MedicinalProductDefinitionContactComponent dst = new MedicinalProductDefinitionContactComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductDefinitionContactComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.contact = this.contact == null ? null : this.contact.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionContactComponent)) {
                return false;
            }
            MedicinalProductDefinitionContactComponent o = (MedicinalProductDefinitionContactComponent)other_;
            return MedicinalProductDefinitionContactComponent.compareDeep(this.type, o.type, true) && MedicinalProductDefinitionContactComponent.compareDeep(this.contact, o.contact, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductDefinitionContactComponent)) {
                return false;
            }
            MedicinalProductDefinitionContactComponent o = (MedicinalProductDefinitionContactComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.contact});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductDefinition.contact";
        }
    }
}

