/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.utils;

import java.util.List;
import org.hl7.fhir.r4b.model.Bundle;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Coding;
import org.hl7.fhir.r4b.model.ContactPoint;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.ElementDefinition;
import org.hl7.fhir.r4b.model.Meta;
import org.hl7.fhir.r4b.model.OperationOutcome;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.Resource;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;

public class ResourceUtilities {
    public static final String FHIR_LANGUAGE = "urn:ietf:bcp:47";

    public static boolean isAnError(OperationOutcome error) {
        for (OperationOutcome.OperationOutcomeIssueComponent t : error.getIssue()) {
            if (t.getSeverity() == OperationOutcome.IssueSeverity.ERROR) {
                return true;
            }
            if (t.getSeverity() != OperationOutcome.IssueSeverity.FATAL) continue;
            return true;
        }
        return false;
    }

    public static String getErrorDescription(OperationOutcome error) {
        if (error.hasText() && error.getText().hasDiv()) {
            return new XhtmlComposer(true).composePlainText(error.getText().getDiv());
        }
        StringBuilder b = new StringBuilder();
        for (OperationOutcome.OperationOutcomeIssueComponent t : error.getIssue()) {
            if (t.getSeverity() == OperationOutcome.IssueSeverity.ERROR) {
                b.append("Error:" + ResourceUtilities.gen(t.getDetails()) + "\r\n");
                continue;
            }
            if (t.getSeverity() == OperationOutcome.IssueSeverity.FATAL) {
                b.append("Fatal:" + ResourceUtilities.gen(t.getDetails()) + "\r\n");
                continue;
            }
            if (t.getSeverity() == OperationOutcome.IssueSeverity.WARNING) {
                b.append("Warning:" + ResourceUtilities.gen(t.getDetails()) + "\r\n");
                continue;
            }
            if (t.getSeverity() != OperationOutcome.IssueSeverity.INFORMATION) continue;
            b.append("Information:" + ResourceUtilities.gen(t.getDetails()) + "\r\n");
        }
        return b.toString();
    }

    private static String gen(CodeableConcept details) {
        if (details.hasText()) {
            return details.getText();
        }
        for (Coding c : details.getCoding()) {
            if (!c.hasDisplay()) continue;
            return c.getDisplay();
        }
        for (Coding c : details.getCoding()) {
            if (!c.hasCode()) continue;
            return c.getCode();
        }
        return "(no details supplied)";
    }

    public static Resource getById(Bundle feed, ResourceType type, String reference) {
        for (Bundle.BundleEntryComponent item : feed.getEntry()) {
            if (!item.getResource().getId().equals(reference) || item.getResource().getResourceType() != type) continue;
            return item.getResource();
        }
        return null;
    }

    public static Bundle.BundleEntryComponent getEntryById(Bundle feed, ResourceType type, String reference) {
        for (Bundle.BundleEntryComponent item : feed.getEntry()) {
            if (!item.getResource().getId().equals(reference) || item.getResource().getResourceType() != type) continue;
            return item;
        }
        return null;
    }

    public static String getLink(Bundle feed, String rel) {
        for (Bundle.BundleLinkComponent link : feed.getLink()) {
            if (!link.getRelation().equals(rel)) continue;
            return link.getUrl();
        }
        return null;
    }

    public static Meta meta(Resource resource) {
        if (!resource.hasMeta()) {
            resource.setMeta(new Meta());
        }
        return resource.getMeta();
    }

    private static String renderBinding(ElementDefinition.ElementDefinitionBindingComponent binding) {
        return null;
    }

    private static String renderDEUnits(DataType units) {
        if (units == null || units.isEmpty()) {
            return "";
        }
        if (units instanceof CodeableConcept) {
            return ResourceUtilities.renderCodeable((CodeableConcept)units);
        }
        return "<a href=\"" + Utilities.escapeXml((String)((Reference)units).getReference()) + "\">" + Utilities.escapeXml((String)((Reference)units).getReference()) + "</a>";
    }

    private static String renderCodeable(CodeableConcept units) {
        if (units == null || units.isEmpty()) {
            return "";
        }
        Object v = ResourceUtilities.renderCoding(units.getCoding());
        if (units.hasText()) {
            v = (String)v + " " + Utilities.escapeXml((String)units.getText());
        }
        return v;
    }

    private static String renderCoding(List<Coding> codes) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (Coding c : codes) {
            b.append(ResourceUtilities.renderCoding(c));
        }
        return b.toString();
    }

    private static String renderCoding(Coding code) {
        if (code == null || code.isEmpty()) {
            return "";
        }
        return "<span title=\"" + Utilities.escapeXml((String)code.getSystem()) + "\">" + Utilities.escapeXml((String)code.getCode()) + "</span>";
    }

    private static String renderType(List<ElementDefinition.TypeRefComponent> type) {
        if (type == null || type.isEmpty()) {
            return "";
        }
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ElementDefinition.TypeRefComponent c : type) {
            b.append(ResourceUtilities.renderType(c));
        }
        return b.toString();
    }

    private static String renderType(ElementDefinition.TypeRefComponent type) {
        if (type == null || type.isEmpty()) {
            return "";
        }
        return type.getWorkingCode();
    }

    public static void renderContactPoint(StringBuilder b, ContactPoint cp) {
        if (cp != null && !cp.isEmpty()) {
            if (cp.getSystem() == ContactPoint.ContactPointSystem.EMAIL) {
                b.append("<a href=\"mailto:" + cp.getValue() + "\">" + cp.getValue() + "</a>");
            } else if (cp.getSystem() == ContactPoint.ContactPointSystem.FAX) {
                b.append("Fax: " + cp.getValue());
            } else if (cp.getSystem() == ContactPoint.ContactPointSystem.OTHER) {
                b.append("<a href=\"" + cp.getValue() + "\">" + cp.getValue() + "</a>");
            } else {
                b.append(cp.getValue());
            }
        }
    }
}

