/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.patterns;

import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4b.model.Annotation;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.CanonicalType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.Period;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.Timing;
import org.hl7.fhir.r4b.model.UriType;
import org.hl7.fhir.r4b.patterns.PatternBase;

public interface Request
extends PatternBase {
    public List<Identifier> getIdentifier() throws FHIRException;

    public Request setIdentifier(List<Identifier> var1) throws FHIRException;

    public boolean hasIdentifier();

    public int getIdentifierMin();

    public int getIdentifierMax();

    public Identifier addIdentifier() throws FHIRException;

    public Request addIdentifier(Identifier var1) throws FHIRException;

    public Identifier getIdentifierFirstRep() throws FHIRException;

    public List<CanonicalType> getInstantiatesCanonical() throws FHIRException;

    public Request setInstantiatesCanonical(List<CanonicalType> var1) throws FHIRException;

    public boolean hasInstantiatesCanonical();

    public int getInstantiatesCanonicalMin();

    public int getInstantiatesCanonicalMax();

    public CanonicalType addInstantiatesCanonicalElement() throws FHIRException;

    public Request addInstantiatesCanonical(String var1) throws FHIRException;

    public boolean hasInstantiatesCanonical(String var1) throws FHIRException;

    public List<UriType> getInstantiatesUri() throws FHIRException;

    public Request setInstantiatesUri(List<UriType> var1) throws FHIRException;

    public boolean hasInstantiatesUri();

    public int getInstantiatesUriMin();

    public int getInstantiatesUriMax();

    public UriType addInstantiatesUriElement() throws FHIRException;

    public Request addInstantiatesUri(String var1) throws FHIRException;

    public boolean hasInstantiatesUri(String var1) throws FHIRException;

    public List<Reference> getBasedOn() throws FHIRException;

    public Request setBasedOn(List<Reference> var1) throws FHIRException;

    public boolean hasBasedOn();

    public int getBasedOnMin();

    public int getBasedOnMax();

    public Reference addBasedOn() throws FHIRException;

    public Request addBasedOn(Reference var1) throws FHIRException;

    public Reference getBasedOnFirstRep() throws FHIRException;

    public List<Reference> getReplaces() throws FHIRException;

    public Request setReplaces(List<Reference> var1) throws FHIRException;

    public boolean hasReplaces();

    public int getReplacesMin();

    public int getReplacesMax();

    public Reference addReplaces() throws FHIRException;

    public Request addReplaces(Reference var1) throws FHIRException;

    public Reference getReplacesFirstRep() throws FHIRException;

    public Identifier getGroupIdentifier() throws FHIRException;

    public boolean hasGroupIdentifier();

    public int getGroupIdentifierMin();

    public int getGroupIdentifierMax();

    public Request setGroupIdentifier(Identifier var1) throws FHIRException;

    public Enumeration<RequestStatus> getStatusElement() throws FHIRException;

    public boolean hasStatus();

    public int getStatusMin() throws FHIRException;

    public int getStatusMax() throws FHIRException;

    public boolean hasStatusElement();

    public Request setStatusElement(Enumeration<RequestStatus> var1) throws FHIRException;

    public RequestStatus getStatus() throws FHIRException;

    public Request setStatus(RequestStatus var1) throws FHIRException;

    public CodeableConcept getStatusReason() throws FHIRException;

    public boolean hasStatusReason();

    public int getStatusReasonMin();

    public int getStatusReasonMax();

    public Request setStatusReason(CodeableConcept var1) throws FHIRException;

    public Enumeration<RequestIntent> getIntentElement() throws FHIRException;

    public boolean hasIntent();

    public int getIntentMin() throws FHIRException;

    public int getIntentMax() throws FHIRException;

    public boolean hasIntentElement();

    public Request setIntentElement(Enumeration<RequestIntent> var1) throws FHIRException;

    public RequestIntent getIntent() throws FHIRException;

    public Request setIntent(RequestIntent var1) throws FHIRException;

    public Enumeration<RequestPriority> getPriorityElement() throws FHIRException;

    public boolean hasPriority();

    public int getPriorityMin() throws FHIRException;

    public int getPriorityMax() throws FHIRException;

    public boolean hasPriorityElement();

    public Request setPriorityElement(Enumeration<RequestPriority> var1) throws FHIRException;

    public RequestPriority getPriority() throws FHIRException;

    public Request setPriority(RequestPriority var1) throws FHIRException;

    public BooleanType getDoNotPerformElement() throws FHIRException;

    public boolean hasDoNotPerform();

    public int getDoNotPerformMin() throws FHIRException;

    public int getDoNotPerformMax() throws FHIRException;

    public boolean hasDoNotPerformElement();

    public Request setDoNotPerformElement(BooleanType var1) throws FHIRException;

    public boolean getDoNotPerform() throws FHIRException;

    public Request setDoNotPerform(boolean var1) throws FHIRException;

    public CodeableConcept getCode() throws FHIRException;

    public boolean hasCode();

    public int getCodeMin();

    public int getCodeMax();

    public Request setCode(CodeableConcept var1) throws FHIRException;

    public Reference getSubject() throws FHIRException;

    public boolean hasSubject();

    public int getSubjectMin();

    public int getSubjectMax();

    public Request setSubject(Reference var1) throws FHIRException;

    public Reference getEncounter() throws FHIRException;

    public boolean hasEncounter();

    public int getEncounterMin();

    public int getEncounterMax();

    public Request setEncounter(Reference var1) throws FHIRException;

    public DataType getOccurrence() throws FHIRException;

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException;

    public boolean hasOccurrenceDateTimeType();

    public Period getOccurrencePeriod() throws FHIRException;

    public boolean hasOccurrencePeriod();

    public Timing getOccurrenceTiming() throws FHIRException;

    public boolean hasOccurrenceTiming();

    public boolean hasOccurrence();

    public int getOccurrenceMin();

    public int getOccurrenceMax();

    public Request setOccurrence(DataType var1) throws FHIRException;

    public DateTimeType getAuthoredOnElement() throws FHIRException;

    public boolean hasAuthoredOn();

    public int getAuthoredOnMin() throws FHIRException;

    public int getAuthoredOnMax() throws FHIRException;

    public boolean hasAuthoredOnElement();

    public Request setAuthoredOnElement(DateTimeType var1) throws FHIRException;

    public Date getAuthoredOn() throws FHIRException;

    public Request setAuthoredOn(Date var1) throws FHIRException;

    public Reference getRequester() throws FHIRException;

    public boolean hasRequester();

    public int getRequesterMin();

    public int getRequesterMax();

    public Request setRequester(Reference var1) throws FHIRException;

    public DataType getReported() throws FHIRException;

    public BooleanType getReportedBooleanType() throws FHIRException;

    public boolean hasReportedBooleanType();

    public Reference getReportedReference() throws FHIRException;

    public boolean hasReportedReference();

    public boolean hasReported();

    public int getReportedMin();

    public int getReportedMax();

    public Request setReported(DataType var1) throws FHIRException;

    public CodeableConcept getPerformerType() throws FHIRException;

    public boolean hasPerformerType();

    public int getPerformerTypeMin();

    public int getPerformerTypeMax();

    public Request setPerformerType(CodeableConcept var1) throws FHIRException;

    public Reference getPerformer() throws FHIRException;

    public boolean hasPerformer();

    public int getPerformerMin();

    public int getPerformerMax();

    public Request setPerformer(Reference var1) throws FHIRException;

    public List<CodeableConcept> getReasonCode() throws FHIRException;

    public Request setReasonCode(List<CodeableConcept> var1) throws FHIRException;

    public boolean hasReasonCode();

    public int getReasonCodeMin();

    public int getReasonCodeMax();

    public CodeableConcept addReasonCode() throws FHIRException;

    public Request addReasonCode(CodeableConcept var1) throws FHIRException;

    public CodeableConcept getReasonCodeFirstRep() throws FHIRException;

    public List<Reference> getReasonReference() throws FHIRException;

    public Request setReasonReference(List<Reference> var1) throws FHIRException;

    public boolean hasReasonReference();

    public int getReasonReferenceMin();

    public int getReasonReferenceMax();

    public Reference addReasonReference() throws FHIRException;

    public Request addReasonReference(Reference var1) throws FHIRException;

    public Reference getReasonReferenceFirstRep() throws FHIRException;

    public List<Reference> getInsurance() throws FHIRException;

    public Request setInsurance(List<Reference> var1) throws FHIRException;

    public boolean hasInsurance();

    public int getInsuranceMin();

    public int getInsuranceMax();

    public Reference addInsurance() throws FHIRException;

    public Request addInsurance(Reference var1) throws FHIRException;

    public Reference getInsuranceFirstRep() throws FHIRException;

    public List<Reference> getSupportingInfo() throws FHIRException;

    public Request setSupportingInfo(List<Reference> var1) throws FHIRException;

    public boolean hasSupportingInfo();

    public int getSupportingInfoMin();

    public int getSupportingInfoMax();

    public Reference addSupportingInfo() throws FHIRException;

    public Request addSupportingInfo(Reference var1) throws FHIRException;

    public Reference getSupportingInfoFirstRep() throws FHIRException;

    public List<Annotation> getNote() throws FHIRException;

    public Request setNote(List<Annotation> var1) throws FHIRException;

    public boolean hasNote();

    public int getNoteMin();

    public int getNoteMax();

    public Annotation addNote() throws FHIRException;

    public Request addNote(Annotation var1) throws FHIRException;

    public Annotation getNoteFirstRep() throws FHIRException;

    public List<Reference> getRelevantHistory() throws FHIRException;

    public Request setRelevantHistory(List<Reference> var1) throws FHIRException;

    public boolean hasRelevantHistory();

    public int getRelevantHistoryMin();

    public int getRelevantHistoryMax();

    public Reference addRelevantHistory() throws FHIRException;

    public Request addRelevantHistory(Reference var1) throws FHIRException;

    public Reference getRelevantHistoryFirstRep() throws FHIRException;

    public String fhirType();

    public static class RequestPriorityEnumFactory
    implements EnumFactory<RequestPriority> {
        @Override
        public RequestPriority fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return RequestPriority.ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return RequestPriority.URGENT;
            }
            if ("asap".equals(codeString)) {
                return RequestPriority.ASAP;
            }
            if ("stat".equals(codeString)) {
                return RequestPriority.STAT;
            }
            throw new IllegalArgumentException("Unknown RequestPriority code '" + codeString + "'");
        }

        public Enumeration<RequestPriority> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RequestPriority>(this, RequestPriority.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.NULL, code);
            }
            if ("routine".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.ROUTINE, code);
            }
            if ("urgent".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.URGENT, code);
            }
            if ("asap".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.ASAP, code);
            }
            if ("stat".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.STAT, code);
            }
            throw new FHIRException("Unknown RequestPriority code '" + codeString + "'");
        }

        @Override
        public String toCode(RequestPriority code) {
            if (code == RequestPriority.ROUTINE) {
                return "routine";
            }
            if (code == RequestPriority.URGENT) {
                return "urgent";
            }
            if (code == RequestPriority.ASAP) {
                return "asap";
            }
            if (code == RequestPriority.STAT) {
                return "stat";
            }
            return "?";
        }

        @Override
        public String toSystem(RequestPriority code) {
            return code.getSystem();
        }
    }

    public static enum RequestPriority {
        ROUTINE,
        URGENT,
        ASAP,
        STAT,
        NULL;


        public static RequestPriority fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return URGENT;
            }
            if ("asap".equals(codeString)) {
                return ASAP;
            }
            if ("stat".equals(codeString)) {
                return STAT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RequestPriority code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ROUTINE: {
                    return "routine";
                }
                case URGENT: {
                    return "urgent";
                }
                case ASAP: {
                    return "asap";
                }
                case STAT: {
                    return "stat";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ROUTINE: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case URGENT: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case ASAP: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case STAT: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ROUTINE: {
                    return "The request has normal priority.";
                }
                case URGENT: {
                    return "The request should be actioned promptly - higher priority than routine.";
                }
                case ASAP: {
                    return "The request should be actioned as soon as possible - higher priority than urgent.";
                }
                case STAT: {
                    return "The request should be actioned immediately - highest possible priority.  E.g. an emergency.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ROUTINE: {
                    return "Routine";
                }
                case URGENT: {
                    return "Urgent";
                }
                case ASAP: {
                    return "ASAP";
                }
                case STAT: {
                    return "STAT";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class RequestIntentEnumFactory
    implements EnumFactory<RequestIntent> {
        @Override
        public RequestIntent fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return RequestIntent.PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return RequestIntent.PLAN;
            }
            if ("directive".equals(codeString)) {
                return RequestIntent.DIRECTIVE;
            }
            if ("order".equals(codeString)) {
                return RequestIntent.ORDER;
            }
            if ("original-order".equals(codeString)) {
                return RequestIntent.ORIGINALORDER;
            }
            if ("reflex-order".equals(codeString)) {
                return RequestIntent.REFLEXORDER;
            }
            if ("filler-order".equals(codeString)) {
                return RequestIntent.FILLERORDER;
            }
            if ("instance-order".equals(codeString)) {
                return RequestIntent.INSTANCEORDER;
            }
            if ("option".equals(codeString)) {
                return RequestIntent.OPTION;
            }
            throw new IllegalArgumentException("Unknown RequestIntent code '" + codeString + "'");
        }

        public Enumeration<RequestIntent> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RequestIntent>(this, RequestIntent.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.NULL, code);
            }
            if ("proposal".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.PROPOSAL, code);
            }
            if ("plan".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.PLAN, code);
            }
            if ("directive".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.DIRECTIVE, code);
            }
            if ("order".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.ORDER, code);
            }
            if ("original-order".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.ORIGINALORDER, code);
            }
            if ("reflex-order".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.REFLEXORDER, code);
            }
            if ("filler-order".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.FILLERORDER, code);
            }
            if ("instance-order".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.INSTANCEORDER, code);
            }
            if ("option".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.OPTION, code);
            }
            throw new FHIRException("Unknown RequestIntent code '" + codeString + "'");
        }

        @Override
        public String toCode(RequestIntent code) {
            if (code == RequestIntent.PROPOSAL) {
                return "proposal";
            }
            if (code == RequestIntent.PLAN) {
                return "plan";
            }
            if (code == RequestIntent.DIRECTIVE) {
                return "directive";
            }
            if (code == RequestIntent.ORDER) {
                return "order";
            }
            if (code == RequestIntent.ORIGINALORDER) {
                return "original-order";
            }
            if (code == RequestIntent.REFLEXORDER) {
                return "reflex-order";
            }
            if (code == RequestIntent.FILLERORDER) {
                return "filler-order";
            }
            if (code == RequestIntent.INSTANCEORDER) {
                return "instance-order";
            }
            if (code == RequestIntent.OPTION) {
                return "option";
            }
            return "?";
        }

        @Override
        public String toSystem(RequestIntent code) {
            return code.getSystem();
        }
    }

    public static enum RequestIntent {
        PROPOSAL,
        PLAN,
        DIRECTIVE,
        ORDER,
        ORIGINALORDER,
        REFLEXORDER,
        FILLERORDER,
        INSTANCEORDER,
        OPTION,
        NULL;


        public static RequestIntent fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return PLAN;
            }
            if ("directive".equals(codeString)) {
                return DIRECTIVE;
            }
            if ("order".equals(codeString)) {
                return ORDER;
            }
            if ("original-order".equals(codeString)) {
                return ORIGINALORDER;
            }
            if ("reflex-order".equals(codeString)) {
                return REFLEXORDER;
            }
            if ("filler-order".equals(codeString)) {
                return FILLERORDER;
            }
            if ("instance-order".equals(codeString)) {
                return INSTANCEORDER;
            }
            if ("option".equals(codeString)) {
                return OPTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RequestIntent code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSAL: {
                    return "proposal";
                }
                case PLAN: {
                    return "plan";
                }
                case DIRECTIVE: {
                    return "directive";
                }
                case ORDER: {
                    return "order";
                }
                case ORIGINALORDER: {
                    return "original-order";
                }
                case REFLEXORDER: {
                    return "reflex-order";
                }
                case FILLERORDER: {
                    return "filler-order";
                }
                case INSTANCEORDER: {
                    return "instance-order";
                }
                case OPTION: {
                    return "option";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSAL: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case PLAN: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case DIRECTIVE: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case ORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case ORIGINALORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case REFLEXORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case FILLERORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case INSTANCEORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case OPTION: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSAL: {
                    return "The request is a suggestion made by someone/something that does not have an intention to ensure it occurs and without providing an authorization to act.";
                }
                case PLAN: {
                    return "The request represents an intention to ensure something occurs without providing an authorization for others to act.";
                }
                case DIRECTIVE: {
                    return "The request represents a legally binding instruction authored by a Patient or RelatedPerson.";
                }
                case ORDER: {
                    return "The request represents a request/demand and authorization for action by a Practitioner.";
                }
                case ORIGINALORDER: {
                    return "The request represents an original authorization for action.";
                }
                case REFLEXORDER: {
                    return "The request represents an automatically generated supplemental authorization for action based on a parent authorization together with initial results of the action taken against that parent authorization.";
                }
                case FILLERORDER: {
                    return "The request represents the view of an authorization instantiated by a fulfilling system representing the details of the fulfiller's intention to act upon a submitted order.";
                }
                case INSTANCEORDER: {
                    return "An order created in fulfillment of a broader order that represents the authorization for a single activity occurrence.  E.g. The administration of a single dose of a drug.";
                }
                case OPTION: {
                    return "The request represents a component or option for a RequestGroup that establishes timing, conditionality and/or other constraints among a set of requests.  Refer to [[[RequestGroup]]] for additional information on how this status is used.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSAL: {
                    return "Proposal";
                }
                case PLAN: {
                    return "Plan";
                }
                case DIRECTIVE: {
                    return "Directive";
                }
                case ORDER: {
                    return "Order";
                }
                case ORIGINALORDER: {
                    return "Original Order";
                }
                case REFLEXORDER: {
                    return "Reflex Order";
                }
                case FILLERORDER: {
                    return "Filler Order";
                }
                case INSTANCEORDER: {
                    return "Instance Order";
                }
                case OPTION: {
                    return "Option";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class RequestStatusEnumFactory
    implements EnumFactory<RequestStatus> {
        @Override
        public RequestStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return RequestStatus.DRAFT;
            }
            if ("active".equals(codeString)) {
                return RequestStatus.ACTIVE;
            }
            if ("on-hold".equals(codeString)) {
                return RequestStatus.ONHOLD;
            }
            if ("revoked".equals(codeString)) {
                return RequestStatus.REVOKED;
            }
            if ("completed".equals(codeString)) {
                return RequestStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return RequestStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return RequestStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown RequestStatus code '" + codeString + "'");
        }

        public Enumeration<RequestStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RequestStatus>(this, RequestStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<RequestStatus>(this, RequestStatus.NULL, code);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<RequestStatus>(this, RequestStatus.DRAFT, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<RequestStatus>(this, RequestStatus.ACTIVE, code);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<RequestStatus>(this, RequestStatus.ONHOLD, code);
            }
            if ("revoked".equals(codeString)) {
                return new Enumeration<RequestStatus>(this, RequestStatus.REVOKED, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<RequestStatus>(this, RequestStatus.COMPLETED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<RequestStatus>(this, RequestStatus.ENTEREDINERROR, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<RequestStatus>(this, RequestStatus.UNKNOWN, code);
            }
            throw new FHIRException("Unknown RequestStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(RequestStatus code) {
            if (code == RequestStatus.DRAFT) {
                return "draft";
            }
            if (code == RequestStatus.ACTIVE) {
                return "active";
            }
            if (code == RequestStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == RequestStatus.REVOKED) {
                return "revoked";
            }
            if (code == RequestStatus.COMPLETED) {
                return "completed";
            }
            if (code == RequestStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == RequestStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(RequestStatus code) {
            return code.getSystem();
        }
    }

    public static enum RequestStatus {
        DRAFT,
        ACTIVE,
        ONHOLD,
        REVOKED,
        COMPLETED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static RequestStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("revoked".equals(codeString)) {
                return REVOKED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RequestStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case ACTIVE: {
                    return "active";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case REVOKED: {
                    return "revoked";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/request-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/request-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/request-status";
                }
                case REVOKED: {
                    return "http://hl7.org/fhir/request-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/request-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/request-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/request-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "The request has been created but is not yet complete or ready for action.";
                }
                case ACTIVE: {
                    return "The request is in force and ready to be acted upon.";
                }
                case ONHOLD: {
                    return "The request (and any implicit authorization to act) has been temporarily withdrawn but is expected to resume in the future.";
                }
                case REVOKED: {
                    return "The request (and any implicit authorization to act) has been terminated prior to the known full completion of the intended actions.  No further activity should occur.";
                }
                case COMPLETED: {
                    return "The activity described by the request has been fully performed.  No further activity will occur.";
                }
                case ENTEREDINERROR: {
                    return "This request should never have existed and should be considered 'void'.  (It is possible that real-world decisions were based on it.  If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".).";
                }
                case UNKNOWN: {
                    return "The authoring/source system does not know which of the status values currently applies for this request.  Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply,  but the authoring/source system does not know which.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case ACTIVE: {
                    return "Active";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case REVOKED: {
                    return "Revoked";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

