/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.patterns;

import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.InstantType;
import org.hl7.fhir.r4b.model.Period;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.Timing;
import org.hl7.fhir.r4b.patterns.PatternBase;

public interface Fivews
extends PatternBase {
    public List<Identifier> getIdentifier() throws FHIRException;

    public Fivews setIdentifier(List<Identifier> var1) throws FHIRException;

    public boolean hasIdentifier();

    public int getIdentifierMin();

    public int getIdentifierMax();

    public Identifier addIdentifier() throws FHIRException;

    public Fivews addIdentifier(Identifier var1) throws FHIRException;

    public Identifier getIdentifierFirstRep() throws FHIRException;

    public StringType getVersionElement() throws FHIRException;

    public boolean hasVersion();

    public int getVersionMin() throws FHIRException;

    public int getVersionMax() throws FHIRException;

    public boolean hasVersionElement();

    public Fivews setVersionElement(StringType var1) throws FHIRException;

    public String getVersion() throws FHIRException;

    public Fivews setVersion(String var1) throws FHIRException;

    public Enumeration<CanonicalStatus> getStatusElement() throws FHIRException;

    public boolean hasStatus();

    public int getStatusMin() throws FHIRException;

    public int getStatusMax() throws FHIRException;

    public boolean hasStatusElement();

    public Fivews setStatusElement(Enumeration<CanonicalStatus> var1) throws FHIRException;

    public CanonicalStatus getStatus() throws FHIRException;

    public Fivews setStatus(CanonicalStatus var1) throws FHIRException;

    public List<CodeableConcept> getClass_() throws FHIRException;

    public Fivews setClass_(List<CodeableConcept> var1) throws FHIRException;

    public boolean hasClass_();

    public int getClass_Min();

    public int getClass_Max();

    public CodeableConcept addClass_() throws FHIRException;

    public Fivews addClass_(CodeableConcept var1) throws FHIRException;

    public CodeableConcept getClass_FirstRep() throws FHIRException;

    public CodeableConcept getGrade() throws FHIRException;

    public boolean hasGrade();

    public int getGradeMin();

    public int getGradeMax();

    public Fivews setGrade(CodeableConcept var1) throws FHIRException;

    public DataType getWhat() throws FHIRException;

    public CodeableConcept getWhatCodeableConcept() throws FHIRException;

    public boolean hasWhatCodeableConcept();

    public Reference getWhatReference() throws FHIRException;

    public boolean hasWhatReference();

    public boolean hasWhat();

    public int getWhatMin();

    public int getWhatMax();

    public Fivews setWhat(DataType var1) throws FHIRException;

    public List<Reference> getSubject() throws FHIRException;

    public Fivews setSubject(List<Reference> var1) throws FHIRException;

    public boolean hasSubject();

    public int getSubjectMin();

    public int getSubjectMax();

    public Reference addSubject() throws FHIRException;

    public Fivews addSubject(Reference var1) throws FHIRException;

    public Reference getSubjectFirstRep() throws FHIRException;

    public Reference getContext() throws FHIRException;

    public boolean hasContext();

    public int getContextMin();

    public int getContextMax();

    public Fivews setContext(Reference var1) throws FHIRException;

    public DateTimeType getInitElement() throws FHIRException;

    public boolean hasInit();

    public int getInitMin() throws FHIRException;

    public int getInitMax() throws FHIRException;

    public boolean hasInitElement();

    public Fivews setInitElement(DateTimeType var1) throws FHIRException;

    public Date getInit() throws FHIRException;

    public Fivews setInit(Date var1) throws FHIRException;

    public List<Timing> getPlanned() throws FHIRException;

    public Fivews setPlanned(List<Timing> var1) throws FHIRException;

    public boolean hasPlanned();

    public int getPlannedMin();

    public int getPlannedMax();

    public Timing addPlanned() throws FHIRException;

    public Fivews addPlanned(Timing var1) throws FHIRException;

    public Timing getPlannedFirstRep() throws FHIRException;

    public DataType getDone() throws FHIRException;

    public DateTimeType getDoneDateTimeType() throws FHIRException;

    public boolean hasDoneDateTimeType();

    public Period getDonePeriod() throws FHIRException;

    public boolean hasDonePeriod();

    public boolean hasDone();

    public int getDoneMin();

    public int getDoneMax();

    public Fivews setDone(DataType var1) throws FHIRException;

    public InstantType getRecordedElement() throws FHIRException;

    public boolean hasRecorded();

    public int getRecordedMin() throws FHIRException;

    public int getRecordedMax() throws FHIRException;

    public boolean hasRecordedElement();

    public Fivews setRecordedElement(InstantType var1) throws FHIRException;

    public Date getRecorded() throws FHIRException;

    public Fivews setRecorded(Date var1) throws FHIRException;

    public List<Reference> getAuthor() throws FHIRException;

    public Fivews setAuthor(List<Reference> var1) throws FHIRException;

    public boolean hasAuthor();

    public int getAuthorMin();

    public int getAuthorMax();

    public Reference addAuthor() throws FHIRException;

    public Fivews addAuthor(Reference var1) throws FHIRException;

    public Reference getAuthorFirstRep() throws FHIRException;

    public List<Reference> getSource() throws FHIRException;

    public Fivews setSource(List<Reference> var1) throws FHIRException;

    public boolean hasSource();

    public int getSourceMin();

    public int getSourceMax();

    public Reference addSource() throws FHIRException;

    public Fivews addSource(Reference var1) throws FHIRException;

    public Reference getSourceFirstRep() throws FHIRException;

    public List<Reference> getActor() throws FHIRException;

    public Fivews setActor(List<Reference> var1) throws FHIRException;

    public boolean hasActor();

    public int getActorMin();

    public int getActorMax();

    public Reference addActor() throws FHIRException;

    public Fivews addActor(Reference var1) throws FHIRException;

    public Reference getActorFirstRep() throws FHIRException;

    public List<Reference> getCause() throws FHIRException;

    public Fivews setCause(List<Reference> var1) throws FHIRException;

    public boolean hasCause();

    public int getCauseMin();

    public int getCauseMax();

    public Reference addCause() throws FHIRException;

    public Fivews addCause(Reference var1) throws FHIRException;

    public Reference getCauseFirstRep() throws FHIRException;

    public List<Reference> getWitness() throws FHIRException;

    public Fivews setWitness(List<Reference> var1) throws FHIRException;

    public boolean hasWitness();

    public int getWitnessMin();

    public int getWitnessMax();

    public Reference addWitness() throws FHIRException;

    public Fivews addWitness(Reference var1) throws FHIRException;

    public Reference getWitnessFirstRep() throws FHIRException;

    public List<Reference> getWho() throws FHIRException;

    public Fivews setWho(List<Reference> var1) throws FHIRException;

    public boolean hasWho();

    public int getWhoMin();

    public int getWhoMax();

    public Reference addWho() throws FHIRException;

    public Fivews addWho(Reference var1) throws FHIRException;

    public Reference getWhoFirstRep() throws FHIRException;

    public List<DataType> getWhere() throws FHIRException;

    public Fivews setWhere(List<DataType> var1) throws FHIRException;

    public boolean hasWhere();

    public int getWhereMin();

    public int getWhereMax();

    public DataType addWhere() throws FHIRException;

    public Fivews addWhere(DataType var1) throws FHIRException;

    public DataType getWhereFirstRep() throws FHIRException;

    public List<DataType> getWhy() throws FHIRException;

    public Fivews setWhy(List<DataType> var1) throws FHIRException;

    public boolean hasWhy();

    public int getWhyMin();

    public int getWhyMax();

    public DataType addWhy() throws FHIRException;

    public Fivews addWhy(DataType var1) throws FHIRException;

    public DataType getWhyFirstRep() throws FHIRException;

    public String fhirType();

    public static class CanonicalStatusEnumFactory
    implements EnumFactory<CanonicalStatus> {
        @Override
        public CanonicalStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("error".equals(codeString)) {
                return CanonicalStatus.ERROR;
            }
            if ("proposed".equals(codeString)) {
                return CanonicalStatus.PROPOSED;
            }
            if ("planned".equals(codeString)) {
                return CanonicalStatus.PLANNED;
            }
            if ("draft".equals(codeString)) {
                return CanonicalStatus.DRAFT;
            }
            if ("requested".equals(codeString)) {
                return CanonicalStatus.REQUESTED;
            }
            if ("received".equals(codeString)) {
                return CanonicalStatus.RECEIVED;
            }
            if ("declined".equals(codeString)) {
                return CanonicalStatus.DECLINED;
            }
            if ("accepted".equals(codeString)) {
                return CanonicalStatus.ACCEPTED;
            }
            if ("arrived".equals(codeString)) {
                return CanonicalStatus.ARRIVED;
            }
            if ("active".equals(codeString)) {
                return CanonicalStatus.ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return CanonicalStatus.SUSPENDED;
            }
            if ("failed".equals(codeString)) {
                return CanonicalStatus.FAILED;
            }
            if ("replaced".equals(codeString)) {
                return CanonicalStatus.REPLACED;
            }
            if ("complete".equals(codeString)) {
                return CanonicalStatus.COMPLETE;
            }
            if ("inactive".equals(codeString)) {
                return CanonicalStatus.INACTIVE;
            }
            if ("abandoned".equals(codeString)) {
                return CanonicalStatus.ABANDONED;
            }
            if ("unknown".equals(codeString)) {
                return CanonicalStatus.UNKNOWN;
            }
            if ("unconfirmed".equals(codeString)) {
                return CanonicalStatus.UNCONFIRMED;
            }
            if ("confirmed".equals(codeString)) {
                return CanonicalStatus.CONFIRMED;
            }
            if ("resolved".equals(codeString)) {
                return CanonicalStatus.RESOLVED;
            }
            if ("refuted".equals(codeString)) {
                return CanonicalStatus.REFUTED;
            }
            if ("differential".equals(codeString)) {
                return CanonicalStatus.DIFFERENTIAL;
            }
            if ("partial".equals(codeString)) {
                return CanonicalStatus.PARTIAL;
            }
            if ("busy-unavailable".equals(codeString)) {
                return CanonicalStatus.BUSYUNAVAILABLE;
            }
            if ("free".equals(codeString)) {
                return CanonicalStatus.FREE;
            }
            if ("on-target".equals(codeString)) {
                return CanonicalStatus.ONTARGET;
            }
            if ("ahead-of-target".equals(codeString)) {
                return CanonicalStatus.AHEADOFTARGET;
            }
            if ("behind-target".equals(codeString)) {
                return CanonicalStatus.BEHINDTARGET;
            }
            if ("not-ready".equals(codeString)) {
                return CanonicalStatus.NOTREADY;
            }
            if ("transduc-discon".equals(codeString)) {
                return CanonicalStatus.TRANSDUCDISCON;
            }
            if ("hw-discon".equals(codeString)) {
                return CanonicalStatus.HWDISCON;
            }
            throw new IllegalArgumentException("Unknown CanonicalStatus code '" + codeString + "'");
        }

        public Enumeration<CanonicalStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.NULL, code);
            }
            if ("error".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.ERROR, code);
            }
            if ("proposed".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.PROPOSED, code);
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.PLANNED, code);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.DRAFT, code);
            }
            if ("requested".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.REQUESTED, code);
            }
            if ("received".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.RECEIVED, code);
            }
            if ("declined".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.DECLINED, code);
            }
            if ("accepted".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.ACCEPTED, code);
            }
            if ("arrived".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.ARRIVED, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.ACTIVE, code);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.SUSPENDED, code);
            }
            if ("failed".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.FAILED, code);
            }
            if ("replaced".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.REPLACED, code);
            }
            if ("complete".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.COMPLETE, code);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.INACTIVE, code);
            }
            if ("abandoned".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.ABANDONED, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.UNKNOWN, code);
            }
            if ("unconfirmed".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.UNCONFIRMED, code);
            }
            if ("confirmed".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.CONFIRMED, code);
            }
            if ("resolved".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.RESOLVED, code);
            }
            if ("refuted".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.REFUTED, code);
            }
            if ("differential".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.DIFFERENTIAL, code);
            }
            if ("partial".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.PARTIAL, code);
            }
            if ("busy-unavailable".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.BUSYUNAVAILABLE, code);
            }
            if ("free".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.FREE, code);
            }
            if ("on-target".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.ONTARGET, code);
            }
            if ("ahead-of-target".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.AHEADOFTARGET, code);
            }
            if ("behind-target".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.BEHINDTARGET, code);
            }
            if ("not-ready".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.NOTREADY, code);
            }
            if ("transduc-discon".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.TRANSDUCDISCON, code);
            }
            if ("hw-discon".equals(codeString)) {
                return new Enumeration<CanonicalStatus>(this, CanonicalStatus.HWDISCON, code);
            }
            throw new FHIRException("Unknown CanonicalStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(CanonicalStatus code) {
            if (code == CanonicalStatus.ERROR) {
                return "error";
            }
            if (code == CanonicalStatus.PROPOSED) {
                return "proposed";
            }
            if (code == CanonicalStatus.PLANNED) {
                return "planned";
            }
            if (code == CanonicalStatus.DRAFT) {
                return "draft";
            }
            if (code == CanonicalStatus.REQUESTED) {
                return "requested";
            }
            if (code == CanonicalStatus.RECEIVED) {
                return "received";
            }
            if (code == CanonicalStatus.DECLINED) {
                return "declined";
            }
            if (code == CanonicalStatus.ACCEPTED) {
                return "accepted";
            }
            if (code == CanonicalStatus.ARRIVED) {
                return "arrived";
            }
            if (code == CanonicalStatus.ACTIVE) {
                return "active";
            }
            if (code == CanonicalStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == CanonicalStatus.FAILED) {
                return "failed";
            }
            if (code == CanonicalStatus.REPLACED) {
                return "replaced";
            }
            if (code == CanonicalStatus.COMPLETE) {
                return "complete";
            }
            if (code == CanonicalStatus.INACTIVE) {
                return "inactive";
            }
            if (code == CanonicalStatus.ABANDONED) {
                return "abandoned";
            }
            if (code == CanonicalStatus.UNKNOWN) {
                return "unknown";
            }
            if (code == CanonicalStatus.UNCONFIRMED) {
                return "unconfirmed";
            }
            if (code == CanonicalStatus.CONFIRMED) {
                return "confirmed";
            }
            if (code == CanonicalStatus.RESOLVED) {
                return "resolved";
            }
            if (code == CanonicalStatus.REFUTED) {
                return "refuted";
            }
            if (code == CanonicalStatus.DIFFERENTIAL) {
                return "differential";
            }
            if (code == CanonicalStatus.PARTIAL) {
                return "partial";
            }
            if (code == CanonicalStatus.BUSYUNAVAILABLE) {
                return "busy-unavailable";
            }
            if (code == CanonicalStatus.FREE) {
                return "free";
            }
            if (code == CanonicalStatus.ONTARGET) {
                return "on-target";
            }
            if (code == CanonicalStatus.AHEADOFTARGET) {
                return "ahead-of-target";
            }
            if (code == CanonicalStatus.BEHINDTARGET) {
                return "behind-target";
            }
            if (code == CanonicalStatus.NOTREADY) {
                return "not-ready";
            }
            if (code == CanonicalStatus.TRANSDUCDISCON) {
                return "transduc-discon";
            }
            if (code == CanonicalStatus.HWDISCON) {
                return "hw-discon";
            }
            return "?";
        }

        @Override
        public String toSystem(CanonicalStatus code) {
            return code.getSystem();
        }
    }

    public static enum CanonicalStatus {
        ERROR,
        PROPOSED,
        PLANNED,
        DRAFT,
        REQUESTED,
        RECEIVED,
        DECLINED,
        ACCEPTED,
        ARRIVED,
        ACTIVE,
        SUSPENDED,
        FAILED,
        REPLACED,
        COMPLETE,
        INACTIVE,
        ABANDONED,
        UNKNOWN,
        UNCONFIRMED,
        CONFIRMED,
        RESOLVED,
        REFUTED,
        DIFFERENTIAL,
        PARTIAL,
        BUSYUNAVAILABLE,
        FREE,
        ONTARGET,
        AHEADOFTARGET,
        BEHINDTARGET,
        NOTREADY,
        TRANSDUCDISCON,
        HWDISCON,
        NULL;


        public static CanonicalStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            if ("proposed".equals(codeString)) {
                return PROPOSED;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("requested".equals(codeString)) {
                return REQUESTED;
            }
            if ("received".equals(codeString)) {
                return RECEIVED;
            }
            if ("declined".equals(codeString)) {
                return DECLINED;
            }
            if ("accepted".equals(codeString)) {
                return ACCEPTED;
            }
            if ("arrived".equals(codeString)) {
                return ARRIVED;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("failed".equals(codeString)) {
                return FAILED;
            }
            if ("replaced".equals(codeString)) {
                return REPLACED;
            }
            if ("complete".equals(codeString)) {
                return COMPLETE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("abandoned".equals(codeString)) {
                return ABANDONED;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if ("unconfirmed".equals(codeString)) {
                return UNCONFIRMED;
            }
            if ("confirmed".equals(codeString)) {
                return CONFIRMED;
            }
            if ("resolved".equals(codeString)) {
                return RESOLVED;
            }
            if ("refuted".equals(codeString)) {
                return REFUTED;
            }
            if ("differential".equals(codeString)) {
                return DIFFERENTIAL;
            }
            if ("partial".equals(codeString)) {
                return PARTIAL;
            }
            if ("busy-unavailable".equals(codeString)) {
                return BUSYUNAVAILABLE;
            }
            if ("free".equals(codeString)) {
                return FREE;
            }
            if ("on-target".equals(codeString)) {
                return ONTARGET;
            }
            if ("ahead-of-target".equals(codeString)) {
                return AHEADOFTARGET;
            }
            if ("behind-target".equals(codeString)) {
                return BEHINDTARGET;
            }
            if ("not-ready".equals(codeString)) {
                return NOTREADY;
            }
            if ("transduc-discon".equals(codeString)) {
                return TRANSDUCDISCON;
            }
            if ("hw-discon".equals(codeString)) {
                return HWDISCON;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CanonicalStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ERROR: {
                    return "error";
                }
                case PROPOSED: {
                    return "proposed";
                }
                case PLANNED: {
                    return "planned";
                }
                case DRAFT: {
                    return "draft";
                }
                case REQUESTED: {
                    return "requested";
                }
                case RECEIVED: {
                    return "received";
                }
                case DECLINED: {
                    return "declined";
                }
                case ACCEPTED: {
                    return "accepted";
                }
                case ARRIVED: {
                    return "arrived";
                }
                case ACTIVE: {
                    return "active";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case FAILED: {
                    return "failed";
                }
                case REPLACED: {
                    return "replaced";
                }
                case COMPLETE: {
                    return "complete";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ABANDONED: {
                    return "abandoned";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case UNCONFIRMED: {
                    return "unconfirmed";
                }
                case CONFIRMED: {
                    return "confirmed";
                }
                case RESOLVED: {
                    return "resolved";
                }
                case REFUTED: {
                    return "refuted";
                }
                case DIFFERENTIAL: {
                    return "differential";
                }
                case PARTIAL: {
                    return "partial";
                }
                case BUSYUNAVAILABLE: {
                    return "busy-unavailable";
                }
                case FREE: {
                    return "free";
                }
                case ONTARGET: {
                    return "on-target";
                }
                case AHEADOFTARGET: {
                    return "ahead-of-target";
                }
                case BEHINDTARGET: {
                    return "behind-target";
                }
                case NOTREADY: {
                    return "not-ready";
                }
                case TRANSDUCDISCON: {
                    return "transduc-discon";
                }
                case HWDISCON: {
                    return "hw-discon";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ERROR: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case PROPOSED: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case PLANNED: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case REQUESTED: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case RECEIVED: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case DECLINED: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case ACCEPTED: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case ARRIVED: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case FAILED: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case REPLACED: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case COMPLETE: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case ABANDONED: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case UNCONFIRMED: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case CONFIRMED: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case RESOLVED: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case REFUTED: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case DIFFERENTIAL: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case PARTIAL: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case BUSYUNAVAILABLE: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case FREE: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case ONTARGET: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case AHEADOFTARGET: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case BEHINDTARGET: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case NOTREADY: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case TRANSDUCDISCON: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case HWDISCON: {
                    return "http://hl7.org/fhir/resource-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ERROR: {
                    return "The resource was created in error, and should not be treated as valid (note: in many cases, for various data integrity related reasons, the information cannot be removed from the record)";
                }
                case PROPOSED: {
                    return "The resource describes an action or plan that is proposed, and not yet approved by the participants";
                }
                case PLANNED: {
                    return "The resource describes a course of action that is planned and agreed/approved, but at the time of recording was still future";
                }
                case DRAFT: {
                    return "The information in the resource is still being prepared and edited";
                }
                case REQUESTED: {
                    return "A fulfiller has been asked to perform this action, but it has not yet occurred";
                }
                case RECEIVED: {
                    return "The fulfiller has received the request, but not yet agreed to carry out the action";
                }
                case DECLINED: {
                    return "The fulfiller chose not to perform the action";
                }
                case ACCEPTED: {
                    return "The fulfiller has decided to perform the action, and plans are in train to do this in the future";
                }
                case ARRIVED: {
                    return "The pre-conditions for the action are all fulfilled, and it is imminent";
                }
                case ACTIVE: {
                    return "The resource describes information that is currently valid or a process that is presently occuring";
                }
                case SUSPENDED: {
                    return "The process described/requested in this resource has been halted for some reason";
                }
                case FAILED: {
                    return "The process described/requested in the resource could not be completed, and no further action is planned";
                }
                case REPLACED: {
                    return "The information in this resource has been replaced by information in another resource";
                }
                case COMPLETE: {
                    return "The process described/requested in the resource has been completed, and no further action is planned";
                }
                case INACTIVE: {
                    return "The resource describes information that is no longer valid or a process that is stopped occurring";
                }
                case ABANDONED: {
                    return "The process described/requested in the resource did not complete - usually due to some workflow error, and no further action is planned";
                }
                case UNKNOWN: {
                    return "Authoring system does not know the status";
                }
                case UNCONFIRMED: {
                    return "The information in this resource is not yet approved";
                }
                case CONFIRMED: {
                    return "The information in this resource is approved";
                }
                case RESOLVED: {
                    return "The issue identified by this resource is no longer of concern";
                }
                case REFUTED: {
                    return "This information has been ruled out by testing and evaluation";
                }
                case DIFFERENTIAL: {
                    return "Potentially true?";
                }
                case PARTIAL: {
                    return "This information is still being assembled";
                }
                case BUSYUNAVAILABLE: {
                    return "not available at this time/location";
                }
                case FREE: {
                    return "Free for scheduling";
                }
                case ONTARGET: {
                    return "Ready to act";
                }
                case AHEADOFTARGET: {
                    return "Ahead of the planned timelines";
                }
                case BEHINDTARGET: {
                    return "";
                }
                case NOTREADY: {
                    return "Behind the planned timelines";
                }
                case TRANSDUCDISCON: {
                    return "The device transducer is disconnected";
                }
                case HWDISCON: {
                    return "The hardware is disconnected";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ERROR: {
                    return "error";
                }
                case PROPOSED: {
                    return "proposed";
                }
                case PLANNED: {
                    return "planned";
                }
                case DRAFT: {
                    return "draft";
                }
                case REQUESTED: {
                    return "requested";
                }
                case RECEIVED: {
                    return "received";
                }
                case DECLINED: {
                    return "declined";
                }
                case ACCEPTED: {
                    return "accepted";
                }
                case ARRIVED: {
                    return "arrived";
                }
                case ACTIVE: {
                    return "active";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case FAILED: {
                    return "failed";
                }
                case REPLACED: {
                    return "replaced";
                }
                case COMPLETE: {
                    return "complete";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ABANDONED: {
                    return "abandoned";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case UNCONFIRMED: {
                    return "unconfirmed";
                }
                case CONFIRMED: {
                    return "confirmed";
                }
                case RESOLVED: {
                    return "resolved";
                }
                case REFUTED: {
                    return "refuted";
                }
                case DIFFERENTIAL: {
                    return "differential";
                }
                case PARTIAL: {
                    return "partial";
                }
                case BUSYUNAVAILABLE: {
                    return "busy-unavailable";
                }
                case FREE: {
                    return "free";
                }
                case ONTARGET: {
                    return "on-target";
                }
                case AHEADOFTARGET: {
                    return "ahead-of-target";
                }
                case BEHINDTARGET: {
                    return "behind-target";
                }
                case NOTREADY: {
                    return "not-ready";
                }
                case TRANSDUCDISCON: {
                    return "transduc-discon";
                }
                case HWDISCON: {
                    return "hw-discon";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

