/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4b.model.Annotation;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.Device;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.Duration;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Group;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.Location;
import org.hl7.fhir.r4b.model.Patient;
import org.hl7.fhir.r4b.model.Period;
import org.hl7.fhir.r4b.model.Practitioner;
import org.hl7.fhir.r4b.model.PractitionerRole;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Quantity;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.ServiceRequest;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.Substance;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Specimen", profile="http://hl7.org/fhir/StructureDefinition/Specimen")
public class Specimen
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Identifier", formalDefinition="Id for specimen.")
    protected List<Identifier> identifier;
    @Child(name="accessionIdentifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier assigned by the lab", formalDefinition="The identifier assigned by the lab when accessioning specimen(s). This is not necessarily the same as the specimen identifier, depending on local lab procedures.")
    protected Identifier accessionIdentifier;
    @Child(name="status", type={CodeType.class}, order=2, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="available | unavailable | unsatisfactory | entered-in-error", formalDefinition="The availability of the specimen.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/specimen-status")
    protected Enumeration<SpecimenStatus> status;
    @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of material that forms the specimen", formalDefinition="The kind of material that forms the specimen.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0487")
    protected CodeableConcept type;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, Substance.class, Location.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where the specimen came from. This may be from patient(s), from a location (e.g., the source of an environmental sample), or a sampling of a substance or a device", formalDefinition="Where the specimen came from. This may be from patient(s), from a location (e.g., the source of an environmental sample), or a sampling of a substance or a device.")
    protected Reference subject;
    @Child(name="receivedTime", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The time when specimen was received for processing", formalDefinition="Time when specimen was received for processing or testing.")
    protected DateTimeType receivedTime;
    @Child(name="parent", type={Specimen.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Specimen from which this specimen originated", formalDefinition="Reference to the parent (source) specimen which is used when the specimen was either derived from or a component of another specimen.")
    protected List<Reference> parent;
    @Child(name="request", type={ServiceRequest.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Why the specimen was collected", formalDefinition="Details concerning a service request that required a specimen to be collected.")
    protected List<Reference> request;
    @Child(name="collection", type={}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Collection details", formalDefinition="Details concerning the specimen collection.")
    protected SpecimenCollectionComponent collection;
    @Child(name="processing", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Processing and processing step details", formalDefinition="Details concerning processing and processing steps for the specimen.")
    protected List<SpecimenProcessingComponent> processing;
    @Child(name="container", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Direct container of specimen (tube/slide, etc.)", formalDefinition="The container holding the specimen.  The recursive nature of containers; i.e. blood in tube in tray in rack is not addressed here.")
    protected List<SpecimenContainerComponent> container;
    @Child(name="condition", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="State of the specimen", formalDefinition="A mode or state of being that describes the nature of the specimen.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0493")
    protected List<CodeableConcept> condition;
    @Child(name="note", type={Annotation.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments", formalDefinition="To communicate any details or issues about the specimen or during the specimen collection. (for example: broken vial, sent with patient, frozen).")
    protected List<Annotation> note;
    private static final long serialVersionUID = -1069243129L;
    @SearchParamDefinition(name="accession", path="Specimen.accessionIdentifier", description="The accession number associated with the specimen", type="token")
    public static final String SP_ACCESSION = "accession";
    public static final TokenClientParam ACCESSION = new TokenClientParam("accession");
    @SearchParamDefinition(name="bodysite", path="Specimen.collection.bodySite", description="The code for the body site from where the specimen originated", type="token")
    public static final String SP_BODYSITE = "bodysite";
    public static final TokenClientParam BODYSITE = new TokenClientParam("bodysite");
    @SearchParamDefinition(name="collected", path="Specimen.collection.collected", description="The date the specimen was collected", type="date")
    public static final String SP_COLLECTED = "collected";
    public static final DateClientParam COLLECTED = new DateClientParam("collected");
    @SearchParamDefinition(name="collector", path="Specimen.collection.collector", description="Who collected the specimen", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Practitioner.class, PractitionerRole.class})
    public static final String SP_COLLECTOR = "collector";
    public static final ReferenceClientParam COLLECTOR = new ReferenceClientParam("collector");
    public static final Include INCLUDE_COLLECTOR = new Include("Specimen:collector").toLocked();
    @SearchParamDefinition(name="container-id", path="Specimen.container.identifier", description="The unique identifier associated with the specimen container", type="token")
    public static final String SP_CONTAINER_ID = "container-id";
    public static final TokenClientParam CONTAINER_ID = new TokenClientParam("container-id");
    @SearchParamDefinition(name="container", path="Specimen.container.type", description="The kind of specimen container", type="token")
    public static final String SP_CONTAINER = "container";
    public static final TokenClientParam CONTAINER = new TokenClientParam("container");
    @SearchParamDefinition(name="identifier", path="Specimen.identifier", description="The unique identifier associated with the specimen", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="parent", path="Specimen.parent", description="The parent of the specimen", type="reference", target={Specimen.class})
    public static final String SP_PARENT = "parent";
    public static final ReferenceClientParam PARENT = new ReferenceClientParam("parent");
    public static final Include INCLUDE_PARENT = new Include("Specimen:parent").toLocked();
    @SearchParamDefinition(name="patient", path="Specimen.subject.where(resolve() is Patient)", description="The patient the specimen comes from", type="reference", target={Device.class, Group.class, Location.class, Patient.class, Substance.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Specimen:patient").toLocked();
    @SearchParamDefinition(name="status", path="Specimen.status", description="available | unavailable | unsatisfactory | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="Specimen.subject", description="The subject of the specimen", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient")}, target={Device.class, Group.class, Location.class, Patient.class, Substance.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Specimen:subject").toLocked();
    @SearchParamDefinition(name="type", path="Specimen.type", description="The specimen type", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Specimen setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Specimen addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Identifier getAccessionIdentifier() {
        if (this.accessionIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.accessionIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.accessionIdentifier = new Identifier();
            }
        }
        return this.accessionIdentifier;
    }

    public boolean hasAccessionIdentifier() {
        return this.accessionIdentifier != null && !this.accessionIdentifier.isEmpty();
    }

    public Specimen setAccessionIdentifier(Identifier value) {
        this.accessionIdentifier = value;
        return this;
    }

    public Enumeration<SpecimenStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<SpecimenStatus>(new SpecimenStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Specimen setStatusElement(Enumeration<SpecimenStatus> value) {
        this.status = value;
        return this;
    }

    public SpecimenStatus getStatus() {
        return this.status == null ? null : (SpecimenStatus)((Object)this.status.getValue());
    }

    public Specimen setStatus(SpecimenStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<SpecimenStatus>(new SpecimenStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Specimen setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Specimen setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public DateTimeType getReceivedTimeElement() {
        if (this.receivedTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.receivedTime");
            }
            if (Configuration.doAutoCreate()) {
                this.receivedTime = new DateTimeType();
            }
        }
        return this.receivedTime;
    }

    public boolean hasReceivedTimeElement() {
        return this.receivedTime != null && !this.receivedTime.isEmpty();
    }

    public boolean hasReceivedTime() {
        return this.receivedTime != null && !this.receivedTime.isEmpty();
    }

    public Specimen setReceivedTimeElement(DateTimeType value) {
        this.receivedTime = value;
        return this;
    }

    public Date getReceivedTime() {
        return this.receivedTime == null ? null : (Date)this.receivedTime.getValue();
    }

    public Specimen setReceivedTime(Date value) {
        if (value == null) {
            this.receivedTime = null;
        } else {
            if (this.receivedTime == null) {
                this.receivedTime = new DateTimeType();
            }
            this.receivedTime.setValue(value);
        }
        return this;
    }

    public List<Reference> getParent() {
        if (this.parent == null) {
            this.parent = new ArrayList<Reference>();
        }
        return this.parent;
    }

    public Specimen setParent(List<Reference> theParent) {
        this.parent = theParent;
        return this;
    }

    public boolean hasParent() {
        if (this.parent == null) {
            return false;
        }
        for (Reference item : this.parent) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addParent() {
        Reference t = new Reference();
        if (this.parent == null) {
            this.parent = new ArrayList<Reference>();
        }
        this.parent.add(t);
        return t;
    }

    public Specimen addParent(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.parent == null) {
            this.parent = new ArrayList<Reference>();
        }
        this.parent.add(t);
        return this;
    }

    public Reference getParentFirstRep() {
        if (this.getParent().isEmpty()) {
            this.addParent();
        }
        return this.getParent().get(0);
    }

    public List<Reference> getRequest() {
        if (this.request == null) {
            this.request = new ArrayList<Reference>();
        }
        return this.request;
    }

    public Specimen setRequest(List<Reference> theRequest) {
        this.request = theRequest;
        return this;
    }

    public boolean hasRequest() {
        if (this.request == null) {
            return false;
        }
        for (Reference item : this.request) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRequest() {
        Reference t = new Reference();
        if (this.request == null) {
            this.request = new ArrayList<Reference>();
        }
        this.request.add(t);
        return t;
    }

    public Specimen addRequest(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.request == null) {
            this.request = new ArrayList<Reference>();
        }
        this.request.add(t);
        return this;
    }

    public Reference getRequestFirstRep() {
        if (this.getRequest().isEmpty()) {
            this.addRequest();
        }
        return this.getRequest().get(0);
    }

    public SpecimenCollectionComponent getCollection() {
        if (this.collection == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Specimen.collection");
            }
            if (Configuration.doAutoCreate()) {
                this.collection = new SpecimenCollectionComponent();
            }
        }
        return this.collection;
    }

    public boolean hasCollection() {
        return this.collection != null && !this.collection.isEmpty();
    }

    public Specimen setCollection(SpecimenCollectionComponent value) {
        this.collection = value;
        return this;
    }

    public List<SpecimenProcessingComponent> getProcessing() {
        if (this.processing == null) {
            this.processing = new ArrayList<SpecimenProcessingComponent>();
        }
        return this.processing;
    }

    public Specimen setProcessing(List<SpecimenProcessingComponent> theProcessing) {
        this.processing = theProcessing;
        return this;
    }

    public boolean hasProcessing() {
        if (this.processing == null) {
            return false;
        }
        for (SpecimenProcessingComponent item : this.processing) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SpecimenProcessingComponent addProcessing() {
        SpecimenProcessingComponent t = new SpecimenProcessingComponent();
        if (this.processing == null) {
            this.processing = new ArrayList<SpecimenProcessingComponent>();
        }
        this.processing.add(t);
        return t;
    }

    public Specimen addProcessing(SpecimenProcessingComponent t) {
        if (t == null) {
            return this;
        }
        if (this.processing == null) {
            this.processing = new ArrayList<SpecimenProcessingComponent>();
        }
        this.processing.add(t);
        return this;
    }

    public SpecimenProcessingComponent getProcessingFirstRep() {
        if (this.getProcessing().isEmpty()) {
            this.addProcessing();
        }
        return this.getProcessing().get(0);
    }

    public List<SpecimenContainerComponent> getContainer() {
        if (this.container == null) {
            this.container = new ArrayList<SpecimenContainerComponent>();
        }
        return this.container;
    }

    public Specimen setContainer(List<SpecimenContainerComponent> theContainer) {
        this.container = theContainer;
        return this;
    }

    public boolean hasContainer() {
        if (this.container == null) {
            return false;
        }
        for (SpecimenContainerComponent item : this.container) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SpecimenContainerComponent addContainer() {
        SpecimenContainerComponent t = new SpecimenContainerComponent();
        if (this.container == null) {
            this.container = new ArrayList<SpecimenContainerComponent>();
        }
        this.container.add(t);
        return t;
    }

    public Specimen addContainer(SpecimenContainerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.container == null) {
            this.container = new ArrayList<SpecimenContainerComponent>();
        }
        this.container.add(t);
        return this;
    }

    public SpecimenContainerComponent getContainerFirstRep() {
        if (this.getContainer().isEmpty()) {
            this.addContainer();
        }
        return this.getContainer().get(0);
    }

    public List<CodeableConcept> getCondition() {
        if (this.condition == null) {
            this.condition = new ArrayList<CodeableConcept>();
        }
        return this.condition;
    }

    public Specimen setCondition(List<CodeableConcept> theCondition) {
        this.condition = theCondition;
        return this;
    }

    public boolean hasCondition() {
        if (this.condition == null) {
            return false;
        }
        for (CodeableConcept item : this.condition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCondition() {
        CodeableConcept t = new CodeableConcept();
        if (this.condition == null) {
            this.condition = new ArrayList<CodeableConcept>();
        }
        this.condition.add(t);
        return t;
    }

    public Specimen addCondition(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.condition == null) {
            this.condition = new ArrayList<CodeableConcept>();
        }
        this.condition.add(t);
        return this;
    }

    public CodeableConcept getConditionFirstRep() {
        if (this.getCondition().isEmpty()) {
            this.addCondition();
        }
        return this.getCondition().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Specimen setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Specimen addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Id for specimen.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("accessionIdentifier", "Identifier", "The identifier assigned by the lab when accessioning specimen(s). This is not necessarily the same as the specimen identifier, depending on local lab procedures.", 0, 1, this.accessionIdentifier));
        children.add(new Property(SP_STATUS, "code", "The availability of the specimen.", 0, 1, this.status));
        children.add(new Property(SP_TYPE, "CodeableConcept", "The kind of material that forms the specimen.", 0, 1, this.type));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Substance|Location)", "Where the specimen came from. This may be from patient(s), from a location (e.g., the source of an environmental sample), or a sampling of a substance or a device.", 0, 1, this.subject));
        children.add(new Property("receivedTime", "dateTime", "Time when specimen was received for processing or testing.", 0, 1, this.receivedTime));
        children.add(new Property(SP_PARENT, "Reference(Specimen)", "Reference to the parent (source) specimen which is used when the specimen was either derived from or a component of another specimen.", 0, Integer.MAX_VALUE, this.parent));
        children.add(new Property("request", "Reference(ServiceRequest)", "Details concerning a service request that required a specimen to be collected.", 0, Integer.MAX_VALUE, this.request));
        children.add(new Property("collection", "", "Details concerning the specimen collection.", 0, 1, this.collection));
        children.add(new Property("processing", "", "Details concerning processing and processing steps for the specimen.", 0, Integer.MAX_VALUE, this.processing));
        children.add(new Property(SP_CONTAINER, "", "The container holding the specimen.  The recursive nature of containers; i.e. blood in tube in tray in rack is not addressed here.", 0, Integer.MAX_VALUE, this.container));
        children.add(new Property("condition", "CodeableConcept", "A mode or state of being that describes the nature of the specimen.", 0, Integer.MAX_VALUE, this.condition));
        children.add(new Property("note", "Annotation", "To communicate any details or issues about the specimen or during the specimen collection. (for example: broken vial, sent with patient, frozen).", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Id for specimen.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 818734061: {
                return new Property("accessionIdentifier", "Identifier", "The identifier assigned by the lab when accessioning specimen(s). This is not necessarily the same as the specimen identifier, depending on local lab procedures.", 0, 1, this.accessionIdentifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The availability of the specimen.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "The kind of material that forms the specimen.", 0, 1, this.type);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Substance|Location)", "Where the specimen came from. This may be from patient(s), from a location (e.g., the source of an environmental sample), or a sampling of a substance or a device.", 0, 1, this.subject);
            }
            case -767961010: {
                return new Property("receivedTime", "dateTime", "Time when specimen was received for processing or testing.", 0, 1, this.receivedTime);
            }
            case -995424086: {
                return new Property(SP_PARENT, "Reference(Specimen)", "Reference to the parent (source) specimen which is used when the specimen was either derived from or a component of another specimen.", 0, Integer.MAX_VALUE, this.parent);
            }
            case 1095692943: {
                return new Property("request", "Reference(ServiceRequest)", "Details concerning a service request that required a specimen to be collected.", 0, Integer.MAX_VALUE, this.request);
            }
            case -1741312354: {
                return new Property("collection", "", "Details concerning the specimen collection.", 0, 1, this.collection);
            }
            case 422194963: {
                return new Property("processing", "", "Details concerning processing and processing steps for the specimen.", 0, Integer.MAX_VALUE, this.processing);
            }
            case -410956671: {
                return new Property(SP_CONTAINER, "", "The container holding the specimen.  The recursive nature of containers; i.e. blood in tube in tray in rack is not addressed here.", 0, Integer.MAX_VALUE, this.container);
            }
            case -861311717: {
                return new Property("condition", "CodeableConcept", "A mode or state of being that describes the nature of the specimen.", 0, Integer.MAX_VALUE, this.condition);
            }
            case 3387378: {
                return new Property("note", "Annotation", "To communicate any details or issues about the specimen or during the specimen collection. (for example: broken vial, sent with patient, frozen).", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 818734061: {
                Base[] baseArray;
                if (this.accessionIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.accessionIdentifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.type;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case -767961010: {
                Base[] baseArray;
                if (this.receivedTime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.receivedTime;
                }
                return baseArray;
            }
            case -995424086: {
                return this.parent == null ? new Base[]{} : this.parent.toArray(new Base[this.parent.size()]);
            }
            case 1095692943: {
                return this.request == null ? new Base[]{} : this.request.toArray(new Base[this.request.size()]);
            }
            case -1741312354: {
                Base[] baseArray;
                if (this.collection == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.collection;
                }
                return baseArray;
            }
            case 422194963: {
                return this.processing == null ? new Base[]{} : this.processing.toArray(new Base[this.processing.size()]);
            }
            case -410956671: {
                return this.container == null ? new Base[]{} : this.container.toArray(new Base[this.container.size()]);
            }
            case -861311717: {
                return this.condition == null ? new Base[]{} : this.condition.toArray(new Base[this.condition.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 818734061: {
                this.accessionIdentifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case -892481550: {
                value = new SpecimenStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case -767961010: {
                this.receivedTime = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -995424086: {
                this.getParent().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1095692943: {
                this.getRequest().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1741312354: {
                this.collection = (SpecimenCollectionComponent)((Object)value);
                return value;
            }
            case 422194963: {
                this.getProcessing().add((SpecimenProcessingComponent)((Object)value));
                return value;
            }
            case -410956671: {
                this.getContainer().add((SpecimenContainerComponent)((Object)value));
                return value;
            }
            case -861311717: {
                this.getCondition().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("accessionIdentifier")) {
            this.accessionIdentifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            value = new SpecimenStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_TYPE)) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("receivedTime")) {
            this.receivedTime = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PARENT)) {
            this.getParent().add(TypeConvertor.castToReference(value));
        } else if (name.equals("request")) {
            this.getRequest().add(TypeConvertor.castToReference(value));
        } else if (name.equals("collection")) {
            this.collection = (SpecimenCollectionComponent)((Object)value);
        } else if (name.equals("processing")) {
            this.getProcessing().add((SpecimenProcessingComponent)((Object)value));
        } else if (name.equals(SP_CONTAINER)) {
            this.getContainer().add((SpecimenContainerComponent)((Object)value));
        } else if (name.equals("condition")) {
            this.getCondition().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 818734061: {
                return this.getAccessionIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3575610: {
                return this.getType();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case -767961010: {
                return this.getReceivedTimeElement();
            }
            case -995424086: {
                return this.addParent();
            }
            case 1095692943: {
                return this.addRequest();
            }
            case -1741312354: {
                return this.getCollection();
            }
            case 422194963: {
                return this.addProcessing();
            }
            case -410956671: {
                return this.addContainer();
            }
            case -861311717: {
                return this.addCondition();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 818734061: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case -767961010: {
                return new String[]{"dateTime"};
            }
            case -995424086: {
                return new String[]{"Reference"};
            }
            case 1095692943: {
                return new String[]{"Reference"};
            }
            case -1741312354: {
                return new String[0];
            }
            case 422194963: {
                return new String[0];
            }
            case -410956671: {
                return new String[0];
            }
            case -861311717: {
                return new String[]{"CodeableConcept"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("accessionIdentifier")) {
            this.accessionIdentifier = new Identifier();
            return this.accessionIdentifier;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Specimen.status");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("receivedTime")) {
            throw new FHIRException("Cannot call addChild on a primitive type Specimen.receivedTime");
        }
        if (name.equals(SP_PARENT)) {
            return this.addParent();
        }
        if (name.equals("request")) {
            return this.addRequest();
        }
        if (name.equals("collection")) {
            this.collection = new SpecimenCollectionComponent();
            return this.collection;
        }
        if (name.equals("processing")) {
            return this.addProcessing();
        }
        if (name.equals(SP_CONTAINER)) {
            return this.addContainer();
        }
        if (name.equals("condition")) {
            return this.addCondition();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Specimen";
    }

    @Override
    public Specimen copy() {
        Specimen dst = new Specimen();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Specimen dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.accessionIdentifier = this.accessionIdentifier == null ? null : this.accessionIdentifier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        DateTimeType dateTimeType = dst.receivedTime = this.receivedTime == null ? null : this.receivedTime.copy();
        if (this.parent != null) {
            dst.parent = new ArrayList<Reference>();
            for (Reference reference : this.parent) {
                dst.parent.add(reference.copy());
            }
        }
        if (this.request != null) {
            dst.request = new ArrayList<Reference>();
            for (Reference reference : this.request) {
                dst.request.add(reference.copy());
            }
        }
        SpecimenCollectionComponent specimenCollectionComponent = dst.collection = this.collection == null ? null : this.collection.copy();
        if (this.processing != null) {
            dst.processing = new ArrayList<SpecimenProcessingComponent>();
            for (SpecimenProcessingComponent specimenProcessingComponent : this.processing) {
                dst.processing.add(specimenProcessingComponent.copy());
            }
        }
        if (this.container != null) {
            dst.container = new ArrayList<SpecimenContainerComponent>();
            for (SpecimenContainerComponent specimenContainerComponent : this.container) {
                dst.container.add(specimenContainerComponent.copy());
            }
        }
        if (this.condition != null) {
            dst.condition = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.condition) {
                dst.condition.add(codeableConcept.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected Specimen typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Specimen)) {
            return false;
        }
        Specimen o = (Specimen)other_;
        return Specimen.compareDeep(this.identifier, o.identifier, true) && Specimen.compareDeep(this.accessionIdentifier, o.accessionIdentifier, true) && Specimen.compareDeep(this.status, o.status, true) && Specimen.compareDeep(this.type, o.type, true) && Specimen.compareDeep(this.subject, o.subject, true) && Specimen.compareDeep(this.receivedTime, o.receivedTime, true) && Specimen.compareDeep(this.parent, o.parent, true) && Specimen.compareDeep(this.request, o.request, true) && Specimen.compareDeep(this.collection, o.collection, true) && Specimen.compareDeep(this.processing, o.processing, true) && Specimen.compareDeep(this.container, o.container, true) && Specimen.compareDeep(this.condition, o.condition, true) && Specimen.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Specimen)) {
            return false;
        }
        Specimen o = (Specimen)other_;
        return Specimen.compareValues(this.status, o.status, true) && Specimen.compareValues(this.receivedTime, o.receivedTime, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.accessionIdentifier, this.status, this.type, this.subject, this.receivedTime, this.parent, this.request, this.collection, this.processing, this.container, this.condition, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Specimen;
    }

    @Block
    public static class SpecimenContainerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Id for the container", formalDefinition="Id for container. There may be multiple; a manufacturer's bar code, lab assigned identifier, etc. The container ID may differ from the specimen id in some circumstances.")
        protected List<Identifier> identifier;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Textual description of the container", formalDefinition="Textual description of the container.")
        protected StringType description;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Kind of container directly associated with specimen", formalDefinition="The type of container associated with the specimen (e.g. slide, aliquot, etc.).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/specimen-container-type")
        protected CodeableConcept type;
        @Child(name="capacity", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Container volume or size", formalDefinition="The capacity (volume or other measure) the container may contain.")
        protected Quantity capacity;
        @Child(name="specimenQuantity", type={Quantity.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Quantity of specimen within container", formalDefinition="The quantity of specimen in the container; may be volume, dimensions, or other appropriate measurements, depending on the specimen type.")
        protected Quantity specimenQuantity;
        @Child(name="additive", type={CodeableConcept.class, Substance.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additive associated with container", formalDefinition="Introduced substance to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0371")
        protected DataType additive;
        private static final long serialVersionUID = 1656280677L;

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public SpecimenContainerComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public SpecimenContainerComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenContainerComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SpecimenContainerComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SpecimenContainerComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenContainerComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SpecimenContainerComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Quantity getCapacity() {
            if (this.capacity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenContainerComponent.capacity");
                }
                if (Configuration.doAutoCreate()) {
                    this.capacity = new Quantity();
                }
            }
            return this.capacity;
        }

        public boolean hasCapacity() {
            return this.capacity != null && !this.capacity.isEmpty();
        }

        public SpecimenContainerComponent setCapacity(Quantity value) {
            this.capacity = value;
            return this;
        }

        public Quantity getSpecimenQuantity() {
            if (this.specimenQuantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenContainerComponent.specimenQuantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.specimenQuantity = new Quantity();
                }
            }
            return this.specimenQuantity;
        }

        public boolean hasSpecimenQuantity() {
            return this.specimenQuantity != null && !this.specimenQuantity.isEmpty();
        }

        public SpecimenContainerComponent setSpecimenQuantity(Quantity value) {
            this.specimenQuantity = value;
            return this;
        }

        public DataType getAdditive() {
            return this.additive;
        }

        public CodeableConcept getAdditiveCodeableConcept() throws FHIRException {
            if (this.additive == null) {
                this.additive = new CodeableConcept();
            }
            if (!(this.additive instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.additive.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.additive;
        }

        public boolean hasAdditiveCodeableConcept() {
            return this != null && this.additive instanceof CodeableConcept;
        }

        public Reference getAdditiveReference() throws FHIRException {
            if (this.additive == null) {
                this.additive = new Reference();
            }
            if (!(this.additive instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.additive.getClass().getName() + " was encountered");
            }
            return (Reference)this.additive;
        }

        public boolean hasAdditiveReference() {
            return this != null && this.additive instanceof Reference;
        }

        public boolean hasAdditive() {
            return this.additive != null && !this.additive.isEmpty();
        }

        public SpecimenContainerComponent setAdditive(DataType value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for Specimen.container.additive[x]: " + value.fhirType());
            }
            this.additive = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Specimen.SP_IDENTIFIER, "Identifier", "Id for container. There may be multiple; a manufacturer's bar code, lab assigned identifier, etc. The container ID may differ from the specimen id in some circumstances.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("description", "string", "Textual description of the container.", 0, 1, this.description));
            children.add(new Property(Specimen.SP_TYPE, "CodeableConcept", "The type of container associated with the specimen (e.g. slide, aliquot, etc.).", 0, 1, this.type));
            children.add(new Property("capacity", "Quantity", "The capacity (volume or other measure) the container may contain.", 0, 1, this.capacity));
            children.add(new Property("specimenQuantity", "Quantity", "The quantity of specimen in the container; may be volume, dimensions, or other appropriate measurements, depending on the specimen type.", 0, 1, this.specimenQuantity));
            children.add(new Property("additive[x]", "CodeableConcept|Reference(Substance)", "Introduced substance to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(Specimen.SP_IDENTIFIER, "Identifier", "Id for container. There may be multiple; a manufacturer's bar code, lab assigned identifier, etc. The container ID may differ from the specimen id in some circumstances.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case -1724546052: {
                    return new Property("description", "string", "Textual description of the container.", 0, 1, this.description);
                }
                case 3575610: {
                    return new Property(Specimen.SP_TYPE, "CodeableConcept", "The type of container associated with the specimen (e.g. slide, aliquot, etc.).", 0, 1, this.type);
                }
                case -67824454: {
                    return new Property("capacity", "Quantity", "The capacity (volume or other measure) the container may contain.", 0, 1, this.capacity);
                }
                case 1485980595: {
                    return new Property("specimenQuantity", "Quantity", "The quantity of specimen in the container; may be volume, dimensions, or other appropriate measurements, depending on the specimen type.", 0, 1, this.specimenQuantity);
                }
                case 261915956: {
                    return new Property("additive[x]", "CodeableConcept|Reference(Substance)", "Introduced substance to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive);
                }
                case -1226589236: {
                    return new Property("additive[x]", "CodeableConcept|Reference(Substance)", "Introduced substance to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive);
                }
                case 1330272821: {
                    return new Property("additive[x]", "CodeableConcept", "Introduced substance to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive);
                }
                case -386783009: {
                    return new Property("additive[x]", "Reference(Substance)", "Introduced substance to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -67824454: {
                    Base[] baseArray;
                    if (this.capacity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.capacity;
                    }
                    return baseArray;
                }
                case 1485980595: {
                    Base[] baseArray;
                    if (this.specimenQuantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.specimenQuantity;
                    }
                    return baseArray;
                }
                case -1226589236: {
                    Base[] baseArray;
                    if (this.additive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.additive;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -67824454: {
                    this.capacity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 1485980595: {
                    this.specimenQuantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -1226589236: {
                    this.additive = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Specimen.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals(Specimen.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("capacity")) {
                this.capacity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("specimenQuantity")) {
                this.specimenQuantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("additive[x]")) {
                this.additive = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case -67824454: {
                    return this.getCapacity();
                }
                case 1485980595: {
                    return this.getSpecimenQuantity();
                }
                case 261915956: {
                    return this.getAdditive();
                }
                case -1226589236: {
                    return this.getAdditive();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -67824454: {
                    return new String[]{"Quantity"};
                }
                case 1485980595: {
                    return new String[]{"Quantity"};
                }
                case -1226589236: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Specimen.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type Specimen.container.description");
            }
            if (name.equals(Specimen.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("capacity")) {
                this.capacity = new Quantity();
                return this.capacity;
            }
            if (name.equals("specimenQuantity")) {
                this.specimenQuantity = new Quantity();
                return this.specimenQuantity;
            }
            if (name.equals("additiveCodeableConcept")) {
                this.additive = new CodeableConcept();
                return this.additive;
            }
            if (name.equals("additiveReference")) {
                this.additive = new Reference();
                return this.additive;
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenContainerComponent copy() {
            SpecimenContainerComponent dst = new SpecimenContainerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SpecimenContainerComponent dst) {
            super.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier i : this.identifier) {
                    dst.identifier.add(i.copy());
                }
            }
            dst.description = this.description == null ? null : this.description.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.capacity = this.capacity == null ? null : this.capacity.copy();
            dst.specimenQuantity = this.specimenQuantity == null ? null : this.specimenQuantity.copy();
            dst.additive = this.additive == null ? null : this.additive.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenContainerComponent)) {
                return false;
            }
            SpecimenContainerComponent o = (SpecimenContainerComponent)other_;
            return SpecimenContainerComponent.compareDeep(this.identifier, o.identifier, true) && SpecimenContainerComponent.compareDeep(this.description, o.description, true) && SpecimenContainerComponent.compareDeep(this.type, o.type, true) && SpecimenContainerComponent.compareDeep(this.capacity, o.capacity, true) && SpecimenContainerComponent.compareDeep(this.specimenQuantity, o.specimenQuantity, true) && SpecimenContainerComponent.compareDeep(this.additive, o.additive, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenContainerComponent)) {
                return false;
            }
            SpecimenContainerComponent o = (SpecimenContainerComponent)other_;
            return SpecimenContainerComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.description, this.type, this.capacity, this.specimenQuantity, this.additive});
        }

        @Override
        public String fhirType() {
            return "Specimen.container";
        }
    }

    @Block
    public static class SpecimenProcessingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Textual description of procedure", formalDefinition="Textual description of procedure.")
        protected StringType description;
        @Child(name="procedure", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates the treatment step  applied to the specimen", formalDefinition="A coded value specifying the procedure used to process the specimen.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/specimen-processing-procedure")
        protected CodeableConcept procedure;
        @Child(name="additive", type={Substance.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Material used in the processing step", formalDefinition="Material used in the processing step.")
        protected List<Reference> additive;
        @Child(name="time", type={DateTimeType.class, Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date and time of specimen processing", formalDefinition="A record of the time or period when the specimen processing occurred.  For example the time of sample fixation or the period of time the sample was in formalin.")
        protected DataType time;
        private static final long serialVersionUID = -1155898633L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenProcessingComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SpecimenProcessingComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SpecimenProcessingComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public CodeableConcept getProcedure() {
            if (this.procedure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenProcessingComponent.procedure");
                }
                if (Configuration.doAutoCreate()) {
                    this.procedure = new CodeableConcept();
                }
            }
            return this.procedure;
        }

        public boolean hasProcedure() {
            return this.procedure != null && !this.procedure.isEmpty();
        }

        public SpecimenProcessingComponent setProcedure(CodeableConcept value) {
            this.procedure = value;
            return this;
        }

        public List<Reference> getAdditive() {
            if (this.additive == null) {
                this.additive = new ArrayList<Reference>();
            }
            return this.additive;
        }

        public SpecimenProcessingComponent setAdditive(List<Reference> theAdditive) {
            this.additive = theAdditive;
            return this;
        }

        public boolean hasAdditive() {
            if (this.additive == null) {
                return false;
            }
            for (Reference item : this.additive) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addAdditive() {
            Reference t = new Reference();
            if (this.additive == null) {
                this.additive = new ArrayList<Reference>();
            }
            this.additive.add(t);
            return t;
        }

        public SpecimenProcessingComponent addAdditive(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.additive == null) {
                this.additive = new ArrayList<Reference>();
            }
            this.additive.add(t);
            return this;
        }

        public Reference getAdditiveFirstRep() {
            if (this.getAdditive().isEmpty()) {
                this.addAdditive();
            }
            return this.getAdditive().get(0);
        }

        public DataType getTime() {
            return this.time;
        }

        public DateTimeType getTimeDateTimeType() throws FHIRException {
            if (this.time == null) {
                this.time = new DateTimeType();
            }
            if (!(this.time instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.time.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.time;
        }

        public boolean hasTimeDateTimeType() {
            return this != null && this.time instanceof DateTimeType;
        }

        public Period getTimePeriod() throws FHIRException {
            if (this.time == null) {
                this.time = new Period();
            }
            if (!(this.time instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.time.getClass().getName() + " was encountered");
            }
            return (Period)this.time;
        }

        public boolean hasTimePeriod() {
            return this != null && this.time instanceof Period;
        }

        public boolean hasTime() {
            return this.time != null && !this.time.isEmpty();
        }

        public SpecimenProcessingComponent setTime(DataType value) {
            if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
                throw new Error("Not the right type for Specimen.processing.time[x]: " + value.fhirType());
            }
            this.time = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "string", "Textual description of procedure.", 0, 1, this.description));
            children.add(new Property("procedure", "CodeableConcept", "A coded value specifying the procedure used to process the specimen.", 0, 1, this.procedure));
            children.add(new Property("additive", "Reference(Substance)", "Material used in the processing step.", 0, Integer.MAX_VALUE, this.additive));
            children.add(new Property("time[x]", "dateTime|Period", "A record of the time or period when the specimen processing occurred.  For example the time of sample fixation or the period of time the sample was in formalin.", 0, 1, this.time));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "string", "Textual description of procedure.", 0, 1, this.description);
                }
                case -1095204141: {
                    return new Property("procedure", "CodeableConcept", "A coded value specifying the procedure used to process the specimen.", 0, 1, this.procedure);
                }
                case -1226589236: {
                    return new Property("additive", "Reference(Substance)", "Material used in the processing step.", 0, Integer.MAX_VALUE, this.additive);
                }
                case -1313930605: {
                    return new Property("time[x]", "dateTime|Period", "A record of the time or period when the specimen processing occurred.  For example the time of sample fixation or the period of time the sample was in formalin.", 0, 1, this.time);
                }
                case 3560141: {
                    return new Property("time[x]", "dateTime|Period", "A record of the time or period when the specimen processing occurred.  For example the time of sample fixation or the period of time the sample was in formalin.", 0, 1, this.time);
                }
                case 2135345544: {
                    return new Property("time[x]", "dateTime", "A record of the time or period when the specimen processing occurred.  For example the time of sample fixation or the period of time the sample was in formalin.", 0, 1, this.time);
                }
                case 693544686: {
                    return new Property("time[x]", "Period", "A record of the time or period when the specimen processing occurred.  For example the time of sample fixation or the period of time the sample was in formalin.", 0, 1, this.time);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -1095204141: {
                    Base[] baseArray;
                    if (this.procedure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.procedure;
                    }
                    return baseArray;
                }
                case -1226589236: {
                    return this.additive == null ? new Base[]{} : this.additive.toArray(new Base[this.additive.size()]);
                }
                case 3560141: {
                    Base[] baseArray;
                    if (this.time == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.time;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -1095204141: {
                    this.procedure = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1226589236: {
                    this.getAdditive().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case 3560141: {
                    this.time = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("procedure")) {
                this.procedure = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("additive")) {
                this.getAdditive().add(TypeConvertor.castToReference(value));
            } else if (name.equals("time[x]")) {
                this.time = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1095204141: {
                    return this.getProcedure();
                }
                case -1226589236: {
                    return this.addAdditive();
                }
                case -1313930605: {
                    return this.getTime();
                }
                case 3560141: {
                    return this.getTime();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1095204141: {
                    return new String[]{"CodeableConcept"};
                }
                case -1226589236: {
                    return new String[]{"Reference"};
                }
                case 3560141: {
                    return new String[]{"dateTime", "Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type Specimen.processing.description");
            }
            if (name.equals("procedure")) {
                this.procedure = new CodeableConcept();
                return this.procedure;
            }
            if (name.equals("additive")) {
                return this.addAdditive();
            }
            if (name.equals("timeDateTime")) {
                this.time = new DateTimeType();
                return this.time;
            }
            if (name.equals("timePeriod")) {
                this.time = new Period();
                return this.time;
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenProcessingComponent copy() {
            SpecimenProcessingComponent dst = new SpecimenProcessingComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SpecimenProcessingComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            CodeableConcept codeableConcept = dst.procedure = this.procedure == null ? null : this.procedure.copy();
            if (this.additive != null) {
                dst.additive = new ArrayList<Reference>();
                for (Reference i : this.additive) {
                    dst.additive.add(i.copy());
                }
            }
            dst.time = this.time == null ? null : this.time.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenProcessingComponent)) {
                return false;
            }
            SpecimenProcessingComponent o = (SpecimenProcessingComponent)other_;
            return SpecimenProcessingComponent.compareDeep(this.description, o.description, true) && SpecimenProcessingComponent.compareDeep(this.procedure, o.procedure, true) && SpecimenProcessingComponent.compareDeep(this.additive, o.additive, true) && SpecimenProcessingComponent.compareDeep(this.time, o.time, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenProcessingComponent)) {
                return false;
            }
            SpecimenProcessingComponent o = (SpecimenProcessingComponent)other_;
            return SpecimenProcessingComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.procedure, this.additive, this.time});
        }

        @Override
        public String fhirType() {
            return "Specimen.processing";
        }
    }

    @Block
    public static class SpecimenCollectionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="collector", type={Practitioner.class, PractitionerRole.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Who collected the specimen", formalDefinition="Person who collected the specimen.")
        protected Reference collector;
        @Child(name="collected", type={DateTimeType.class, Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Collection time", formalDefinition="Time when specimen was collected from subject - the physiologically relevant time.")
        protected DataType collected;
        @Child(name="duration", type={Duration.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How long it took to collect specimen", formalDefinition="The span of time over which the collection of a specimen occurred.")
        protected Duration duration;
        @Child(name="quantity", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The quantity of specimen collected", formalDefinition="The quantity of specimen collected; for instance the volume of a blood sample, or the physical measurement of an anatomic pathology sample.")
        protected Quantity quantity;
        @Child(name="method", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Technique used to perform collection", formalDefinition="A coded value specifying the technique that is used to perform the procedure.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/specimen-collection-method")
        protected CodeableConcept method;
        @Child(name="bodySite", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Anatomical collection site", formalDefinition="Anatomical location from which the specimen was collected (if subject is a patient). This is the target site.  This element is not used for environmental specimens.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
        protected CodeableConcept bodySite;
        @Child(name="fastingStatus", type={CodeableConcept.class, Duration.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Whether or how long patient abstained from food and/or drink", formalDefinition="Abstinence or reduction from some or all food, drink, or both, for a period of time prior to sample collection.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0916")
        protected DataType fastingStatus;
        private static final long serialVersionUID = -1359178985L;

        public Reference getCollector() {
            if (this.collector == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenCollectionComponent.collector");
                }
                if (Configuration.doAutoCreate()) {
                    this.collector = new Reference();
                }
            }
            return this.collector;
        }

        public boolean hasCollector() {
            return this.collector != null && !this.collector.isEmpty();
        }

        public SpecimenCollectionComponent setCollector(Reference value) {
            this.collector = value;
            return this;
        }

        public DataType getCollected() {
            return this.collected;
        }

        public DateTimeType getCollectedDateTimeType() throws FHIRException {
            if (this.collected == null) {
                this.collected = new DateTimeType();
            }
            if (!(this.collected instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.collected.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.collected;
        }

        public boolean hasCollectedDateTimeType() {
            return this != null && this.collected instanceof DateTimeType;
        }

        public Period getCollectedPeriod() throws FHIRException {
            if (this.collected == null) {
                this.collected = new Period();
            }
            if (!(this.collected instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.collected.getClass().getName() + " was encountered");
            }
            return (Period)this.collected;
        }

        public boolean hasCollectedPeriod() {
            return this != null && this.collected instanceof Period;
        }

        public boolean hasCollected() {
            return this.collected != null && !this.collected.isEmpty();
        }

        public SpecimenCollectionComponent setCollected(DataType value) {
            if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
                throw new Error("Not the right type for Specimen.collection.collected[x]: " + value.fhirType());
            }
            this.collected = value;
            return this;
        }

        public Duration getDuration() {
            if (this.duration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenCollectionComponent.duration");
                }
                if (Configuration.doAutoCreate()) {
                    this.duration = new Duration();
                }
            }
            return this.duration;
        }

        public boolean hasDuration() {
            return this.duration != null && !this.duration.isEmpty();
        }

        public SpecimenCollectionComponent setDuration(Duration value) {
            this.duration = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenCollectionComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public SpecimenCollectionComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public CodeableConcept getMethod() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenCollectionComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new CodeableConcept();
                }
            }
            return this.method;
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public SpecimenCollectionComponent setMethod(CodeableConcept value) {
            this.method = value;
            return this;
        }

        public CodeableConcept getBodySite() {
            if (this.bodySite == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenCollectionComponent.bodySite");
                }
                if (Configuration.doAutoCreate()) {
                    this.bodySite = new CodeableConcept();
                }
            }
            return this.bodySite;
        }

        public boolean hasBodySite() {
            return this.bodySite != null && !this.bodySite.isEmpty();
        }

        public SpecimenCollectionComponent setBodySite(CodeableConcept value) {
            this.bodySite = value;
            return this;
        }

        public DataType getFastingStatus() {
            return this.fastingStatus;
        }

        public CodeableConcept getFastingStatusCodeableConcept() throws FHIRException {
            if (this.fastingStatus == null) {
                this.fastingStatus = new CodeableConcept();
            }
            if (!(this.fastingStatus instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.fastingStatus.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.fastingStatus;
        }

        public boolean hasFastingStatusCodeableConcept() {
            return this != null && this.fastingStatus instanceof CodeableConcept;
        }

        public Duration getFastingStatusDuration() throws FHIRException {
            if (this.fastingStatus == null) {
                this.fastingStatus = new Duration();
            }
            if (!(this.fastingStatus instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.fastingStatus.getClass().getName() + " was encountered");
            }
            return (Duration)this.fastingStatus;
        }

        public boolean hasFastingStatusDuration() {
            return this != null && this.fastingStatus instanceof Duration;
        }

        public boolean hasFastingStatus() {
            return this.fastingStatus != null && !this.fastingStatus.isEmpty();
        }

        public SpecimenCollectionComponent setFastingStatus(DataType value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Duration)) {
                throw new Error("Not the right type for Specimen.collection.fastingStatus[x]: " + value.fhirType());
            }
            this.fastingStatus = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Specimen.SP_COLLECTOR, "Reference(Practitioner|PractitionerRole)", "Person who collected the specimen.", 0, 1, this.collector));
            children.add(new Property("collected[x]", "dateTime|Period", "Time when specimen was collected from subject - the physiologically relevant time.", 0, 1, this.collected));
            children.add(new Property("duration", "Duration", "The span of time over which the collection of a specimen occurred.", 0, 1, this.duration));
            children.add(new Property("quantity", "Quantity", "The quantity of specimen collected; for instance the volume of a blood sample, or the physical measurement of an anatomic pathology sample.", 0, 1, this.quantity));
            children.add(new Property("method", "CodeableConcept", "A coded value specifying the technique that is used to perform the procedure.", 0, 1, this.method));
            children.add(new Property("bodySite", "CodeableConcept", "Anatomical location from which the specimen was collected (if subject is a patient). This is the target site.  This element is not used for environmental specimens.", 0, 1, this.bodySite));
            children.add(new Property("fastingStatus[x]", "CodeableConcept|Duration", "Abstinence or reduction from some or all food, drink, or both, for a period of time prior to sample collection.", 0, 1, this.fastingStatus));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1883491469: {
                    return new Property(Specimen.SP_COLLECTOR, "Reference(Practitioner|PractitionerRole)", "Person who collected the specimen.", 0, 1, this.collector);
                }
                case 1632037015: {
                    return new Property("collected[x]", "dateTime|Period", "Time when specimen was collected from subject - the physiologically relevant time.", 0, 1, this.collected);
                }
                case 1883491145: {
                    return new Property("collected[x]", "dateTime|Period", "Time when specimen was collected from subject - the physiologically relevant time.", 0, 1, this.collected);
                }
                case 2005009924: {
                    return new Property("collected[x]", "dateTime", "Time when specimen was collected from subject - the physiologically relevant time.", 0, 1, this.collected);
                }
                case 653185642: {
                    return new Property("collected[x]", "Period", "Time when specimen was collected from subject - the physiologically relevant time.", 0, 1, this.collected);
                }
                case -1992012396: {
                    return new Property("duration", "Duration", "The span of time over which the collection of a specimen occurred.", 0, 1, this.duration);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The quantity of specimen collected; for instance the volume of a blood sample, or the physical measurement of an anatomic pathology sample.", 0, 1, this.quantity);
                }
                case -1077554975: {
                    return new Property("method", "CodeableConcept", "A coded value specifying the technique that is used to perform the procedure.", 0, 1, this.method);
                }
                case 1702620169: {
                    return new Property("bodySite", "CodeableConcept", "Anatomical location from which the specimen was collected (if subject is a patient). This is the target site.  This element is not used for environmental specimens.", 0, 1, this.bodySite);
                }
                case -570577944: {
                    return new Property("fastingStatus[x]", "CodeableConcept|Duration", "Abstinence or reduction from some or all food, drink, or both, for a period of time prior to sample collection.", 0, 1, this.fastingStatus);
                }
                case -701550184: {
                    return new Property("fastingStatus[x]", "CodeableConcept|Duration", "Abstinence or reduction from some or all food, drink, or both, for a period of time prior to sample collection.", 0, 1, this.fastingStatus);
                }
                case -1153232151: {
                    return new Property("fastingStatus[x]", "CodeableConcept", "Abstinence or reduction from some or all food, drink, or both, for a period of time prior to sample collection.", 0, 1, this.fastingStatus);
                }
                case -433140916: {
                    return new Property("fastingStatus[x]", "Duration", "Abstinence or reduction from some or all food, drink, or both, for a period of time prior to sample collection.", 0, 1, this.fastingStatus);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1883491469: {
                    Base[] baseArray;
                    if (this.collector == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.collector;
                    }
                    return baseArray;
                }
                case 1883491145: {
                    Base[] baseArray;
                    if (this.collected == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.collected;
                    }
                    return baseArray;
                }
                case -1992012396: {
                    Base[] baseArray;
                    if (this.duration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.duration;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -1077554975: {
                    Base[] baseArray;
                    if (this.method == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.method;
                    }
                    return baseArray;
                }
                case 1702620169: {
                    Base[] baseArray;
                    if (this.bodySite == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.bodySite;
                    }
                    return baseArray;
                }
                case -701550184: {
                    Base[] baseArray;
                    if (this.fastingStatus == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.fastingStatus;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1883491469: {
                    this.collector = TypeConvertor.castToReference(value);
                    return value;
                }
                case 1883491145: {
                    this.collected = TypeConvertor.castToType(value);
                    return value;
                }
                case -1992012396: {
                    this.duration = TypeConvertor.castToDuration(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -1077554975: {
                    this.method = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1702620169: {
                    this.bodySite = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -701550184: {
                    this.fastingStatus = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Specimen.SP_COLLECTOR)) {
                this.collector = TypeConvertor.castToReference(value);
            } else if (name.equals("collected[x]")) {
                this.collected = TypeConvertor.castToType(value);
            } else if (name.equals("duration")) {
                this.duration = TypeConvertor.castToDuration(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("method")) {
                this.method = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("bodySite")) {
                this.bodySite = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("fastingStatus[x]")) {
                this.fastingStatus = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1883491469: {
                    return this.getCollector();
                }
                case 1632037015: {
                    return this.getCollected();
                }
                case 1883491145: {
                    return this.getCollected();
                }
                case -1992012396: {
                    return this.getDuration();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -1077554975: {
                    return this.getMethod();
                }
                case 1702620169: {
                    return this.getBodySite();
                }
                case -570577944: {
                    return this.getFastingStatus();
                }
                case -701550184: {
                    return this.getFastingStatus();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1883491469: {
                    return new String[]{"Reference"};
                }
                case 1883491145: {
                    return new String[]{"dateTime", "Period"};
                }
                case -1992012396: {
                    return new String[]{"Duration"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case -1077554975: {
                    return new String[]{"CodeableConcept"};
                }
                case 1702620169: {
                    return new String[]{"CodeableConcept"};
                }
                case -701550184: {
                    return new String[]{"CodeableConcept", "Duration"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Specimen.SP_COLLECTOR)) {
                this.collector = new Reference();
                return this.collector;
            }
            if (name.equals("collectedDateTime")) {
                this.collected = new DateTimeType();
                return this.collected;
            }
            if (name.equals("collectedPeriod")) {
                this.collected = new Period();
                return this.collected;
            }
            if (name.equals("duration")) {
                this.duration = new Duration();
                return this.duration;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("method")) {
                this.method = new CodeableConcept();
                return this.method;
            }
            if (name.equals("bodySite")) {
                this.bodySite = new CodeableConcept();
                return this.bodySite;
            }
            if (name.equals("fastingStatusCodeableConcept")) {
                this.fastingStatus = new CodeableConcept();
                return this.fastingStatus;
            }
            if (name.equals("fastingStatusDuration")) {
                this.fastingStatus = new Duration();
                return this.fastingStatus;
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenCollectionComponent copy() {
            SpecimenCollectionComponent dst = new SpecimenCollectionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SpecimenCollectionComponent dst) {
            super.copyValues(dst);
            dst.collector = this.collector == null ? null : this.collector.copy();
            dst.collected = this.collected == null ? null : this.collected.copy();
            dst.duration = this.duration == null ? null : this.duration.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.method = this.method == null ? null : this.method.copy();
            dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
            dst.fastingStatus = this.fastingStatus == null ? null : this.fastingStatus.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenCollectionComponent)) {
                return false;
            }
            SpecimenCollectionComponent o = (SpecimenCollectionComponent)other_;
            return SpecimenCollectionComponent.compareDeep(this.collector, o.collector, true) && SpecimenCollectionComponent.compareDeep(this.collected, o.collected, true) && SpecimenCollectionComponent.compareDeep(this.duration, o.duration, true) && SpecimenCollectionComponent.compareDeep(this.quantity, o.quantity, true) && SpecimenCollectionComponent.compareDeep(this.method, o.method, true) && SpecimenCollectionComponent.compareDeep(this.bodySite, o.bodySite, true) && SpecimenCollectionComponent.compareDeep(this.fastingStatus, o.fastingStatus, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenCollectionComponent)) {
                return false;
            }
            SpecimenCollectionComponent o = (SpecimenCollectionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.collector, this.collected, this.duration, this.quantity, this.method, this.bodySite, this.fastingStatus});
        }

        @Override
        public String fhirType() {
            return "Specimen.collection";
        }
    }

    public static class SpecimenStatusEnumFactory
    implements EnumFactory<SpecimenStatus> {
        @Override
        public SpecimenStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("available".equals(codeString)) {
                return SpecimenStatus.AVAILABLE;
            }
            if ("unavailable".equals(codeString)) {
                return SpecimenStatus.UNAVAILABLE;
            }
            if ("unsatisfactory".equals(codeString)) {
                return SpecimenStatus.UNSATISFACTORY;
            }
            if ("entered-in-error".equals(codeString)) {
                return SpecimenStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown SpecimenStatus code '" + codeString + "'");
        }

        public Enumeration<SpecimenStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SpecimenStatus>(this, SpecimenStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<SpecimenStatus>(this, SpecimenStatus.NULL, code);
            }
            if ("available".equals(codeString)) {
                return new Enumeration<SpecimenStatus>(this, SpecimenStatus.AVAILABLE, code);
            }
            if ("unavailable".equals(codeString)) {
                return new Enumeration<SpecimenStatus>(this, SpecimenStatus.UNAVAILABLE, code);
            }
            if ("unsatisfactory".equals(codeString)) {
                return new Enumeration<SpecimenStatus>(this, SpecimenStatus.UNSATISFACTORY, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<SpecimenStatus>(this, SpecimenStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown SpecimenStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(SpecimenStatus code) {
            if (code == SpecimenStatus.AVAILABLE) {
                return "available";
            }
            if (code == SpecimenStatus.UNAVAILABLE) {
                return "unavailable";
            }
            if (code == SpecimenStatus.UNSATISFACTORY) {
                return "unsatisfactory";
            }
            if (code == SpecimenStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(SpecimenStatus code) {
            return code.getSystem();
        }
    }

    public static enum SpecimenStatus {
        AVAILABLE,
        UNAVAILABLE,
        UNSATISFACTORY,
        ENTEREDINERROR,
        NULL;


        public static SpecimenStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("available".equals(codeString)) {
                return AVAILABLE;
            }
            if ("unavailable".equals(codeString)) {
                return UNAVAILABLE;
            }
            if ("unsatisfactory".equals(codeString)) {
                return UNSATISFACTORY;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SpecimenStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case AVAILABLE: {
                    return "available";
                }
                case UNAVAILABLE: {
                    return "unavailable";
                }
                case UNSATISFACTORY: {
                    return "unsatisfactory";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case AVAILABLE: {
                    return "http://hl7.org/fhir/specimen-status";
                }
                case UNAVAILABLE: {
                    return "http://hl7.org/fhir/specimen-status";
                }
                case UNSATISFACTORY: {
                    return "http://hl7.org/fhir/specimen-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/specimen-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case AVAILABLE: {
                    return "The physical specimen is present and in good condition.";
                }
                case UNAVAILABLE: {
                    return "There is no physical specimen because it is either lost, destroyed or consumed.";
                }
                case UNSATISFACTORY: {
                    return "The specimen cannot be used because of a quality issue such as a broken container, contamination, or too old.";
                }
                case ENTEREDINERROR: {
                    return "The specimen was entered in error and therefore nullified.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case AVAILABLE: {
                    return "Available";
                }
                case UNAVAILABLE: {
                    return "Unavailable";
                }
                case UNSATISFACTORY: {
                    return "Unsatisfactory";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

