/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ListEmptyReason {
    NILKNOWN,
    NOTASKED,
    WITHHELD,
    UNAVAILABLE,
    NOTSTARTED,
    CLOSED,
    NULL;


    public static ListEmptyReason fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("nilknown".equals(codeString)) {
            return NILKNOWN;
        }
        if ("notasked".equals(codeString)) {
            return NOTASKED;
        }
        if ("withheld".equals(codeString)) {
            return WITHHELD;
        }
        if ("unavailable".equals(codeString)) {
            return UNAVAILABLE;
        }
        if ("notstarted".equals(codeString)) {
            return NOTSTARTED;
        }
        if ("closed".equals(codeString)) {
            return CLOSED;
        }
        throw new FHIRException("Unknown ListEmptyReason code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NILKNOWN: {
                return "nilknown";
            }
            case NOTASKED: {
                return "notasked";
            }
            case WITHHELD: {
                return "withheld";
            }
            case UNAVAILABLE: {
                return "unavailable";
            }
            case NOTSTARTED: {
                return "notstarted";
            }
            case CLOSED: {
                return "closed";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/list-empty-reason";
    }

    public String getDefinition() {
        switch (this) {
            case NILKNOWN: {
                return "Clinical judgment that there are no known items for this list after reasonable investigation. Note that this a positive statement by a clinical user, and not a default position asserted by a computer system in the lack of other information. Example uses:  * For allergies: the patient or patient's agent/guardian has asserted that he/she is not aware of any allergies (NKA - nil known allergies)  * For medications: the patient or patient's agent/guardian has asserted that the patient is known to be taking no medications  * For diagnoses, problems and procedures: the patient or patient's agent/guardian has asserted that there is no known event to record.";
            }
            case NOTASKED: {
                return "The investigation to find out whether there are items for this list has not occurred.";
            }
            case WITHHELD: {
                return "The content of the list was not provided due to privacy or confidentiality concerns. Note that it should not be assumed that this means that the particular information in question was withheld due to its contents - it can also be a policy decision.";
            }
            case UNAVAILABLE: {
                return "Information to populate this list cannot be obtained; e.g. unconscious patient.";
            }
            case NOTSTARTED: {
                return "The work to populate this list has not yet begun.";
            }
            case CLOSED: {
                return "This list has now closed or has ceased to be relevant or useful.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NILKNOWN: {
                return "Nil Known";
            }
            case NOTASKED: {
                return "Not Asked";
            }
            case WITHHELD: {
                return "Information Withheld";
            }
            case UNAVAILABLE: {
                return "Unavailable";
            }
            case NOTSTARTED: {
                return "Not Started";
            }
            case CLOSED: {
                return "Closed";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

