/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ExDiagnosisOnAdmission {
    Y,
    N,
    U,
    W,
    NULL;


    public static ExDiagnosisOnAdmission fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("y".equals(codeString)) {
            return Y;
        }
        if ("n".equals(codeString)) {
            return N;
        }
        if ("u".equals(codeString)) {
            return U;
        }
        if ("w".equals(codeString)) {
            return W;
        }
        throw new FHIRException("Unknown ExDiagnosisOnAdmission code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case Y: {
                return "y";
            }
            case N: {
                return "n";
            }
            case U: {
                return "u";
            }
            case W: {
                return "w";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/ex-diagnosis-on-admission";
    }

    public String getDefinition() {
        switch (this) {
            case Y: {
                return "Diagnosis was present at time of inpatient admission.";
            }
            case N: {
                return "Diagnosis was not present at time of inpatient admission.";
            }
            case U: {
                return "Documentation insufficient to determine if condition was present at the time of inpatient admission.";
            }
            case W: {
                return "Clinically undetermined. Provider unable to clinically determine whether the condition was present at the time of inpatient admission.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case Y: {
                return "Yes";
            }
            case N: {
                return "No";
            }
            case U: {
                return "Unknown";
            }
            case W: {
                return "Undetermined";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

