/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Immunization;
import org.hl7.fhir.r4.model.ImmunizationEvaluation;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ImmunizationRecommendation", profile="http://hl7.org/fhir/StructureDefinition/ImmunizationRecommendation")
public class ImmunizationRecommendation
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier", formalDefinition="A unique identifier assigned to this particular recommendation record.")
    protected List<Identifier> identifier;
    @Child(name="patient", type={Patient.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who this profile is for", formalDefinition="The patient the recommendation(s) are for.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="date", type={DateTimeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date recommendation(s) created", formalDefinition="The date the immunization recommendation(s) were created.")
    protected DateTimeType date;
    @Child(name="authority", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Who is responsible for protocol", formalDefinition="Indicates the authority who published the protocol (e.g. ACIP).")
    protected Reference authority;
    protected Organization authorityTarget;
    @Child(name="recommendation", type={}, order=4, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Vaccine administration recommendations", formalDefinition="Vaccine administration recommendations.")
    protected List<ImmunizationRecommendationRecommendationComponent> recommendation;
    private static final long serialVersionUID = -2031711761L;
    @SearchParamDefinition(name="date", path="ImmunizationRecommendation.date", description="Date recommendation(s) created", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ImmunizationRecommendation.identifier", description="Business identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="target-disease", path="ImmunizationRecommendation.recommendation.targetDisease", description="Disease to be immunized against", type="token")
    public static final String SP_TARGET_DISEASE = "target-disease";
    public static final TokenClientParam TARGET_DISEASE = new TokenClientParam("target-disease");
    @SearchParamDefinition(name="patient", path="ImmunizationRecommendation.patient", description="Who this profile is for", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ImmunizationRecommendation:patient").toLocked();
    @SearchParamDefinition(name="vaccine-type", path="ImmunizationRecommendation.recommendation.vaccineCode", description="Vaccine  or vaccine group recommendation applies to", type="token")
    public static final String SP_VACCINE_TYPE = "vaccine-type";
    public static final TokenClientParam VACCINE_TYPE = new TokenClientParam("vaccine-type");
    @SearchParamDefinition(name="information", path="ImmunizationRecommendation.recommendation.supportingPatientInformation", description="Patient observations supporting recommendation", type="reference")
    public static final String SP_INFORMATION = "information";
    public static final ReferenceClientParam INFORMATION = new ReferenceClientParam("information");
    public static final Include INCLUDE_INFORMATION = new Include("ImmunizationRecommendation:information").toLocked();
    @SearchParamDefinition(name="support", path="ImmunizationRecommendation.recommendation.supportingImmunization", description="Past immunizations supporting recommendation", type="reference", target={Immunization.class, ImmunizationEvaluation.class})
    public static final String SP_SUPPORT = "support";
    public static final ReferenceClientParam SUPPORT = new ReferenceClientParam("support");
    public static final Include INCLUDE_SUPPORT = new Include("ImmunizationRecommendation:support").toLocked();
    @SearchParamDefinition(name="status", path="ImmunizationRecommendation.recommendation.forecastStatus", description="Vaccine recommendation status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public ImmunizationRecommendation() {
    }

    public ImmunizationRecommendation(Reference patient, DateTimeType date) {
        this.patient = patient;
        this.date = date;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ImmunizationRecommendation setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ImmunizationRecommendation addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationRecommendation.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public ImmunizationRecommendation setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationRecommendation.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public ImmunizationRecommendation setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationRecommendation.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public ImmunizationRecommendation setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public ImmunizationRecommendation setDate(Date value) {
        if (this.date == null) {
            this.date = new DateTimeType();
        }
        this.date.setValue(value);
        return this;
    }

    public Reference getAuthority() {
        if (this.authority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationRecommendation.authority");
            }
            if (Configuration.doAutoCreate()) {
                this.authority = new Reference();
            }
        }
        return this.authority;
    }

    public boolean hasAuthority() {
        return this.authority != null && !this.authority.isEmpty();
    }

    public ImmunizationRecommendation setAuthority(Reference value) {
        this.authority = value;
        return this;
    }

    public Organization getAuthorityTarget() {
        if (this.authorityTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationRecommendation.authority");
            }
            if (Configuration.doAutoCreate()) {
                this.authorityTarget = new Organization();
            }
        }
        return this.authorityTarget;
    }

    public ImmunizationRecommendation setAuthorityTarget(Organization value) {
        this.authorityTarget = value;
        return this;
    }

    public List<ImmunizationRecommendationRecommendationComponent> getRecommendation() {
        if (this.recommendation == null) {
            this.recommendation = new ArrayList<ImmunizationRecommendationRecommendationComponent>();
        }
        return this.recommendation;
    }

    public ImmunizationRecommendation setRecommendation(List<ImmunizationRecommendationRecommendationComponent> theRecommendation) {
        this.recommendation = theRecommendation;
        return this;
    }

    public boolean hasRecommendation() {
        if (this.recommendation == null) {
            return false;
        }
        for (ImmunizationRecommendationRecommendationComponent item : this.recommendation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImmunizationRecommendationRecommendationComponent addRecommendation() {
        ImmunizationRecommendationRecommendationComponent t = new ImmunizationRecommendationRecommendationComponent();
        if (this.recommendation == null) {
            this.recommendation = new ArrayList<ImmunizationRecommendationRecommendationComponent>();
        }
        this.recommendation.add(t);
        return t;
    }

    public ImmunizationRecommendation addRecommendation(ImmunizationRecommendationRecommendationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.recommendation == null) {
            this.recommendation = new ArrayList<ImmunizationRecommendationRecommendationComponent>();
        }
        this.recommendation.add(t);
        return this;
    }

    public ImmunizationRecommendationRecommendationComponent getRecommendationFirstRep() {
        if (this.getRecommendation().isEmpty()) {
            this.addRecommendation();
        }
        return this.getRecommendation().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this particular recommendation record.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient the recommendation(s) are for.", 0, 1, this.patient));
        children.add(new Property(SP_DATE, "dateTime", "The date the immunization recommendation(s) were created.", 0, 1, this.date));
        children.add(new Property("authority", "Reference(Organization)", "Indicates the authority who published the protocol (e.g. ACIP).", 0, 1, this.authority));
        children.add(new Property("recommendation", "", "Vaccine administration recommendations.", 0, Integer.MAX_VALUE, this.recommendation));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this particular recommendation record.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The patient the recommendation(s) are for.", 0, 1, this.patient);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date the immunization recommendation(s) were created.", 0, 1, this.date);
            }
            case 1475610435: {
                return new Property("authority", "Reference(Organization)", "Indicates the authority who published the protocol (e.g. ACIP).", 0, 1, this.authority);
            }
            case -1028636743: {
                return new Property("recommendation", "", "Vaccine administration recommendations.", 0, Integer.MAX_VALUE, this.recommendation);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.patient;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.date;
                }
                return baseArray;
            }
            case 1475610435: {
                Base[] baseArray;
                if (this.authority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.authority;
                }
                return baseArray;
            }
            case -1028636743: {
                return this.recommendation == null ? new Base[]{} : this.recommendation.toArray(new Base[this.recommendation.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1475610435: {
                this.authority = this.castToReference(value);
                return value;
            }
            case -1028636743: {
                this.getRecommendation().add((ImmunizationRecommendationRecommendationComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals("authority")) {
            this.authority = this.castToReference(value);
        } else if (name.equals("recommendation")) {
            this.getRecommendation().add((ImmunizationRecommendationRecommendationComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1475610435: {
                return this.getAuthority();
            }
            case -1028636743: {
                return this.addRecommendation();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1475610435: {
                return new String[]{"Reference"};
            }
            case -1028636743: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImmunizationRecommendation.date");
        }
        if (name.equals("authority")) {
            this.authority = new Reference();
            return this.authority;
        }
        if (name.equals("recommendation")) {
            return this.addRecommendation();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ImmunizationRecommendation";
    }

    @Override
    public ImmunizationRecommendation copy() {
        ImmunizationRecommendation dst = new ImmunizationRecommendation();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ImmunizationRecommendation dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.date = this.date == null ? null : this.date.copy();
        Reference reference = dst.authority = this.authority == null ? null : this.authority.copy();
        if (this.recommendation != null) {
            dst.recommendation = new ArrayList<ImmunizationRecommendationRecommendationComponent>();
            for (ImmunizationRecommendationRecommendationComponent immunizationRecommendationRecommendationComponent : this.recommendation) {
                dst.recommendation.add(immunizationRecommendationRecommendationComponent.copy());
            }
        }
    }

    protected ImmunizationRecommendation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ImmunizationRecommendation)) {
            return false;
        }
        ImmunizationRecommendation o = (ImmunizationRecommendation)other_;
        return ImmunizationRecommendation.compareDeep(this.identifier, o.identifier, true) && ImmunizationRecommendation.compareDeep(this.patient, o.patient, true) && ImmunizationRecommendation.compareDeep(this.date, o.date, true) && ImmunizationRecommendation.compareDeep(this.authority, o.authority, true) && ImmunizationRecommendation.compareDeep(this.recommendation, o.recommendation, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ImmunizationRecommendation)) {
            return false;
        }
        ImmunizationRecommendation o = (ImmunizationRecommendation)other_;
        return ImmunizationRecommendation.compareValues(this.date, o.date, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.patient, this.date, this.authority, this.recommendation});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImmunizationRecommendation;
    }

    @Block
    public static class ImmunizationRecommendationRecommendationDateCriterionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of date", formalDefinition="Date classification of recommendation.  For example, earliest date to give, latest date to give, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-recommendation-date-criterion")
        protected CodeableConcept code;
        @Child(name="value", type={DateTimeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recommended date", formalDefinition="The date whose meaning is specified by dateCriterion.code.")
        protected DateTimeType value;
        private static final long serialVersionUID = 1036994566L;

        public ImmunizationRecommendationRecommendationDateCriterionComponent() {
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent(CodeableConcept code, DateTimeType value) {
            this.code = code;
            this.value = value;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationDateCriterionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public DateTimeType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationDateCriterionComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new DateTimeType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent setValueElement(DateTimeType value) {
            this.value = value;
            return this;
        }

        public Date getValue() {
            return this.value == null ? null : (Date)this.value.getValue();
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent setValue(Date value) {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "Date classification of recommendation.  For example, earliest date to give, latest date to give, etc.", 0, 1, this.code));
            children.add(new Property("value", "dateTime", "The date whose meaning is specified by dateCriterion.code.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Date classification of recommendation.  For example, earliest date to give, latest date to give, etc.", 0, 1, this.code);
                }
                case 111972721: {
                    return new Property("value", "dateTime", "The date whose meaning is specified by dateCriterion.code.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = this.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImmunizationRecommendation.value");
            }
            return super.addChild(name);
        }

        @Override
        public ImmunizationRecommendationRecommendationDateCriterionComponent copy() {
            ImmunizationRecommendationRecommendationDateCriterionComponent dst = new ImmunizationRecommendationRecommendationDateCriterionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImmunizationRecommendationRecommendationDateCriterionComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImmunizationRecommendationRecommendationDateCriterionComponent)) {
                return false;
            }
            ImmunizationRecommendationRecommendationDateCriterionComponent o = (ImmunizationRecommendationRecommendationDateCriterionComponent)other_;
            return ImmunizationRecommendationRecommendationDateCriterionComponent.compareDeep(this.code, o.code, true) && ImmunizationRecommendationRecommendationDateCriterionComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImmunizationRecommendationRecommendationDateCriterionComponent)) {
                return false;
            }
            ImmunizationRecommendationRecommendationDateCriterionComponent o = (ImmunizationRecommendationRecommendationDateCriterionComponent)other_;
            return ImmunizationRecommendationRecommendationDateCriterionComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.value});
        }

        @Override
        public String fhirType() {
            return "ImmunizationRecommendation.recommendation.dateCriterion";
        }
    }

    @Block
    public static class ImmunizationRecommendationRecommendationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="vaccineCode", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Vaccine  or vaccine group recommendation applies to", formalDefinition="Vaccine(s) or vaccine group that pertain to the recommendation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/vaccine-code")
        protected List<CodeableConcept> vaccineCode;
        @Child(name="targetDisease", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Disease to be immunized against", formalDefinition="The targeted disease for the recommendation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-recommendation-target-disease")
        protected CodeableConcept targetDisease;
        @Child(name="contraindicatedVaccineCode", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Vaccine which is contraindicated to fulfill the recommendation", formalDefinition="Vaccine(s) which should not be used to fulfill the recommendation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/vaccine-code")
        protected List<CodeableConcept> contraindicatedVaccineCode;
        @Child(name="forecastStatus", type={CodeableConcept.class}, order=4, min=1, max=1, modifier=true, summary=true)
        @Description(shortDefinition="Vaccine recommendation status", formalDefinition="Indicates the patient status with respect to the path to immunity for the target disease.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-recommendation-status")
        protected CodeableConcept forecastStatus;
        @Child(name="forecastReason", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Vaccine administration status reason", formalDefinition="The reason for the assigned forecast status.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-recommendation-reason")
        protected List<CodeableConcept> forecastReason;
        @Child(name="dateCriterion", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Dates governing proposed immunization", formalDefinition="Vaccine date recommendations.  For example, earliest date to administer, latest date to administer, etc.")
        protected List<ImmunizationRecommendationRecommendationDateCriterionComponent> dateCriterion;
        @Child(name="description", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Protocol details", formalDefinition="Contains the description about the protocol under which the vaccine was administered.")
        protected StringType description;
        @Child(name="series", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of vaccination series", formalDefinition="One possible path to achieve presumed immunity against a disease - within the context of an authority.")
        protected StringType series;
        @Child(name="doseNumber", type={PositiveIntType.class, StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Recommended dose number within series", formalDefinition="Nominal position of the recommended dose in a series (e.g. dose 2 is the next recommended dose).")
        protected Type doseNumber;
        @Child(name="seriesDoses", type={PositiveIntType.class, StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recommended number of doses for immunity", formalDefinition="The recommended number of doses to achieve immunity.")
        protected Type seriesDoses;
        @Child(name="supportingImmunization", type={Immunization.class, ImmunizationEvaluation.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Past immunizations supporting recommendation", formalDefinition="Immunization event history and/or evaluation that supports the status and recommendation.")
        protected List<Reference> supportingImmunization;
        protected List<Resource> supportingImmunizationTarget;
        @Child(name="supportingPatientInformation", type={Reference.class}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Patient observations supporting recommendation", formalDefinition="Patient Information that supports the status and recommendation.  This includes patient observations, adverse reactions and allergy/intolerance information.")
        protected List<Reference> supportingPatientInformation;
        protected List<Resource> supportingPatientInformationTarget;
        private static final long serialVersionUID = -667399405L;

        public ImmunizationRecommendationRecommendationComponent() {
        }

        public ImmunizationRecommendationRecommendationComponent(CodeableConcept forecastStatus) {
            this.forecastStatus = forecastStatus;
        }

        public List<CodeableConcept> getVaccineCode() {
            if (this.vaccineCode == null) {
                this.vaccineCode = new ArrayList<CodeableConcept>();
            }
            return this.vaccineCode;
        }

        public ImmunizationRecommendationRecommendationComponent setVaccineCode(List<CodeableConcept> theVaccineCode) {
            this.vaccineCode = theVaccineCode;
            return this;
        }

        public boolean hasVaccineCode() {
            if (this.vaccineCode == null) {
                return false;
            }
            for (CodeableConcept item : this.vaccineCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addVaccineCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.vaccineCode == null) {
                this.vaccineCode = new ArrayList<CodeableConcept>();
            }
            this.vaccineCode.add(t);
            return t;
        }

        public ImmunizationRecommendationRecommendationComponent addVaccineCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.vaccineCode == null) {
                this.vaccineCode = new ArrayList<CodeableConcept>();
            }
            this.vaccineCode.add(t);
            return this;
        }

        public CodeableConcept getVaccineCodeFirstRep() {
            if (this.getVaccineCode().isEmpty()) {
                this.addVaccineCode();
            }
            return this.getVaccineCode().get(0);
        }

        public CodeableConcept getTargetDisease() {
            if (this.targetDisease == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationComponent.targetDisease");
                }
                if (Configuration.doAutoCreate()) {
                    this.targetDisease = new CodeableConcept();
                }
            }
            return this.targetDisease;
        }

        public boolean hasTargetDisease() {
            return this.targetDisease != null && !this.targetDisease.isEmpty();
        }

        public ImmunizationRecommendationRecommendationComponent setTargetDisease(CodeableConcept value) {
            this.targetDisease = value;
            return this;
        }

        public List<CodeableConcept> getContraindicatedVaccineCode() {
            if (this.contraindicatedVaccineCode == null) {
                this.contraindicatedVaccineCode = new ArrayList<CodeableConcept>();
            }
            return this.contraindicatedVaccineCode;
        }

        public ImmunizationRecommendationRecommendationComponent setContraindicatedVaccineCode(List<CodeableConcept> theContraindicatedVaccineCode) {
            this.contraindicatedVaccineCode = theContraindicatedVaccineCode;
            return this;
        }

        public boolean hasContraindicatedVaccineCode() {
            if (this.contraindicatedVaccineCode == null) {
                return false;
            }
            for (CodeableConcept item : this.contraindicatedVaccineCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addContraindicatedVaccineCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.contraindicatedVaccineCode == null) {
                this.contraindicatedVaccineCode = new ArrayList<CodeableConcept>();
            }
            this.contraindicatedVaccineCode.add(t);
            return t;
        }

        public ImmunizationRecommendationRecommendationComponent addContraindicatedVaccineCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.contraindicatedVaccineCode == null) {
                this.contraindicatedVaccineCode = new ArrayList<CodeableConcept>();
            }
            this.contraindicatedVaccineCode.add(t);
            return this;
        }

        public CodeableConcept getContraindicatedVaccineCodeFirstRep() {
            if (this.getContraindicatedVaccineCode().isEmpty()) {
                this.addContraindicatedVaccineCode();
            }
            return this.getContraindicatedVaccineCode().get(0);
        }

        public CodeableConcept getForecastStatus() {
            if (this.forecastStatus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationComponent.forecastStatus");
                }
                if (Configuration.doAutoCreate()) {
                    this.forecastStatus = new CodeableConcept();
                }
            }
            return this.forecastStatus;
        }

        public boolean hasForecastStatus() {
            return this.forecastStatus != null && !this.forecastStatus.isEmpty();
        }

        public ImmunizationRecommendationRecommendationComponent setForecastStatus(CodeableConcept value) {
            this.forecastStatus = value;
            return this;
        }

        public List<CodeableConcept> getForecastReason() {
            if (this.forecastReason == null) {
                this.forecastReason = new ArrayList<CodeableConcept>();
            }
            return this.forecastReason;
        }

        public ImmunizationRecommendationRecommendationComponent setForecastReason(List<CodeableConcept> theForecastReason) {
            this.forecastReason = theForecastReason;
            return this;
        }

        public boolean hasForecastReason() {
            if (this.forecastReason == null) {
                return false;
            }
            for (CodeableConcept item : this.forecastReason) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addForecastReason() {
            CodeableConcept t = new CodeableConcept();
            if (this.forecastReason == null) {
                this.forecastReason = new ArrayList<CodeableConcept>();
            }
            this.forecastReason.add(t);
            return t;
        }

        public ImmunizationRecommendationRecommendationComponent addForecastReason(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.forecastReason == null) {
                this.forecastReason = new ArrayList<CodeableConcept>();
            }
            this.forecastReason.add(t);
            return this;
        }

        public CodeableConcept getForecastReasonFirstRep() {
            if (this.getForecastReason().isEmpty()) {
                this.addForecastReason();
            }
            return this.getForecastReason().get(0);
        }

        public List<ImmunizationRecommendationRecommendationDateCriterionComponent> getDateCriterion() {
            if (this.dateCriterion == null) {
                this.dateCriterion = new ArrayList<ImmunizationRecommendationRecommendationDateCriterionComponent>();
            }
            return this.dateCriterion;
        }

        public ImmunizationRecommendationRecommendationComponent setDateCriterion(List<ImmunizationRecommendationRecommendationDateCriterionComponent> theDateCriterion) {
            this.dateCriterion = theDateCriterion;
            return this;
        }

        public boolean hasDateCriterion() {
            if (this.dateCriterion == null) {
                return false;
            }
            for (ImmunizationRecommendationRecommendationDateCriterionComponent item : this.dateCriterion) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent addDateCriterion() {
            ImmunizationRecommendationRecommendationDateCriterionComponent t = new ImmunizationRecommendationRecommendationDateCriterionComponent();
            if (this.dateCriterion == null) {
                this.dateCriterion = new ArrayList<ImmunizationRecommendationRecommendationDateCriterionComponent>();
            }
            this.dateCriterion.add(t);
            return t;
        }

        public ImmunizationRecommendationRecommendationComponent addDateCriterion(ImmunizationRecommendationRecommendationDateCriterionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dateCriterion == null) {
                this.dateCriterion = new ArrayList<ImmunizationRecommendationRecommendationDateCriterionComponent>();
            }
            this.dateCriterion.add(t);
            return this;
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent getDateCriterionFirstRep() {
            if (this.getDateCriterion().isEmpty()) {
                this.addDateCriterion();
            }
            return this.getDateCriterion().get(0);
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ImmunizationRecommendationRecommendationComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ImmunizationRecommendationRecommendationComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public StringType getSeriesElement() {
            if (this.series == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationComponent.series");
                }
                if (Configuration.doAutoCreate()) {
                    this.series = new StringType();
                }
            }
            return this.series;
        }

        public boolean hasSeriesElement() {
            return this.series != null && !this.series.isEmpty();
        }

        public boolean hasSeries() {
            return this.series != null && !this.series.isEmpty();
        }

        public ImmunizationRecommendationRecommendationComponent setSeriesElement(StringType value) {
            this.series = value;
            return this;
        }

        public String getSeries() {
            return this.series == null ? null : (String)this.series.getValue();
        }

        public ImmunizationRecommendationRecommendationComponent setSeries(String value) {
            if (Utilities.noString((String)value)) {
                this.series = null;
            } else {
                if (this.series == null) {
                    this.series = new StringType();
                }
                this.series.setValue(value);
            }
            return this;
        }

        public Type getDoseNumber() {
            return this.doseNumber;
        }

        public PositiveIntType getDoseNumberPositiveIntType() throws FHIRException {
            if (this.doseNumber == null) {
                this.doseNumber = new PositiveIntType();
            }
            if (!(this.doseNumber instanceof PositiveIntType)) {
                throw new FHIRException("Type mismatch: the type PositiveIntType was expected, but " + this.doseNumber.getClass().getName() + " was encountered");
            }
            return (PositiveIntType)this.doseNumber;
        }

        public boolean hasDoseNumberPositiveIntType() {
            return this != null && this.doseNumber instanceof PositiveIntType;
        }

        public StringType getDoseNumberStringType() throws FHIRException {
            if (this.doseNumber == null) {
                this.doseNumber = new StringType();
            }
            if (!(this.doseNumber instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.doseNumber.getClass().getName() + " was encountered");
            }
            return (StringType)this.doseNumber;
        }

        public boolean hasDoseNumberStringType() {
            return this != null && this.doseNumber instanceof StringType;
        }

        public boolean hasDoseNumber() {
            return this.doseNumber != null && !this.doseNumber.isEmpty();
        }

        public ImmunizationRecommendationRecommendationComponent setDoseNumber(Type value) {
            if (value != null && !(value instanceof PositiveIntType) && !(value instanceof StringType)) {
                throw new Error("Not the right type for ImmunizationRecommendation.recommendation.doseNumber[x]: " + value.fhirType());
            }
            this.doseNumber = value;
            return this;
        }

        public Type getSeriesDoses() {
            return this.seriesDoses;
        }

        public PositiveIntType getSeriesDosesPositiveIntType() throws FHIRException {
            if (this.seriesDoses == null) {
                this.seriesDoses = new PositiveIntType();
            }
            if (!(this.seriesDoses instanceof PositiveIntType)) {
                throw new FHIRException("Type mismatch: the type PositiveIntType was expected, but " + this.seriesDoses.getClass().getName() + " was encountered");
            }
            return (PositiveIntType)this.seriesDoses;
        }

        public boolean hasSeriesDosesPositiveIntType() {
            return this != null && this.seriesDoses instanceof PositiveIntType;
        }

        public StringType getSeriesDosesStringType() throws FHIRException {
            if (this.seriesDoses == null) {
                this.seriesDoses = new StringType();
            }
            if (!(this.seriesDoses instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.seriesDoses.getClass().getName() + " was encountered");
            }
            return (StringType)this.seriesDoses;
        }

        public boolean hasSeriesDosesStringType() {
            return this != null && this.seriesDoses instanceof StringType;
        }

        public boolean hasSeriesDoses() {
            return this.seriesDoses != null && !this.seriesDoses.isEmpty();
        }

        public ImmunizationRecommendationRecommendationComponent setSeriesDoses(Type value) {
            if (value != null && !(value instanceof PositiveIntType) && !(value instanceof StringType)) {
                throw new Error("Not the right type for ImmunizationRecommendation.recommendation.seriesDoses[x]: " + value.fhirType());
            }
            this.seriesDoses = value;
            return this;
        }

        public List<Reference> getSupportingImmunization() {
            if (this.supportingImmunization == null) {
                this.supportingImmunization = new ArrayList<Reference>();
            }
            return this.supportingImmunization;
        }

        public ImmunizationRecommendationRecommendationComponent setSupportingImmunization(List<Reference> theSupportingImmunization) {
            this.supportingImmunization = theSupportingImmunization;
            return this;
        }

        public boolean hasSupportingImmunization() {
            if (this.supportingImmunization == null) {
                return false;
            }
            for (Reference item : this.supportingImmunization) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSupportingImmunization() {
            Reference t = new Reference();
            if (this.supportingImmunization == null) {
                this.supportingImmunization = new ArrayList<Reference>();
            }
            this.supportingImmunization.add(t);
            return t;
        }

        public ImmunizationRecommendationRecommendationComponent addSupportingImmunization(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.supportingImmunization == null) {
                this.supportingImmunization = new ArrayList<Reference>();
            }
            this.supportingImmunization.add(t);
            return this;
        }

        public Reference getSupportingImmunizationFirstRep() {
            if (this.getSupportingImmunization().isEmpty()) {
                this.addSupportingImmunization();
            }
            return this.getSupportingImmunization().get(0);
        }

        @Deprecated
        public List<Resource> getSupportingImmunizationTarget() {
            if (this.supportingImmunizationTarget == null) {
                this.supportingImmunizationTarget = new ArrayList<Resource>();
            }
            return this.supportingImmunizationTarget;
        }

        public List<Reference> getSupportingPatientInformation() {
            if (this.supportingPatientInformation == null) {
                this.supportingPatientInformation = new ArrayList<Reference>();
            }
            return this.supportingPatientInformation;
        }

        public ImmunizationRecommendationRecommendationComponent setSupportingPatientInformation(List<Reference> theSupportingPatientInformation) {
            this.supportingPatientInformation = theSupportingPatientInformation;
            return this;
        }

        public boolean hasSupportingPatientInformation() {
            if (this.supportingPatientInformation == null) {
                return false;
            }
            for (Reference item : this.supportingPatientInformation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSupportingPatientInformation() {
            Reference t = new Reference();
            if (this.supportingPatientInformation == null) {
                this.supportingPatientInformation = new ArrayList<Reference>();
            }
            this.supportingPatientInformation.add(t);
            return t;
        }

        public ImmunizationRecommendationRecommendationComponent addSupportingPatientInformation(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.supportingPatientInformation == null) {
                this.supportingPatientInformation = new ArrayList<Reference>();
            }
            this.supportingPatientInformation.add(t);
            return this;
        }

        public Reference getSupportingPatientInformationFirstRep() {
            if (this.getSupportingPatientInformation().isEmpty()) {
                this.addSupportingPatientInformation();
            }
            return this.getSupportingPatientInformation().get(0);
        }

        @Deprecated
        public List<Resource> getSupportingPatientInformationTarget() {
            if (this.supportingPatientInformationTarget == null) {
                this.supportingPatientInformationTarget = new ArrayList<Resource>();
            }
            return this.supportingPatientInformationTarget;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("vaccineCode", "CodeableConcept", "Vaccine(s) or vaccine group that pertain to the recommendation.", 0, Integer.MAX_VALUE, this.vaccineCode));
            children.add(new Property("targetDisease", "CodeableConcept", "The targeted disease for the recommendation.", 0, 1, this.targetDisease));
            children.add(new Property("contraindicatedVaccineCode", "CodeableConcept", "Vaccine(s) which should not be used to fulfill the recommendation.", 0, Integer.MAX_VALUE, this.contraindicatedVaccineCode));
            children.add(new Property("forecastStatus", "CodeableConcept", "Indicates the patient status with respect to the path to immunity for the target disease.", 0, 1, this.forecastStatus));
            children.add(new Property("forecastReason", "CodeableConcept", "The reason for the assigned forecast status.", 0, Integer.MAX_VALUE, this.forecastReason));
            children.add(new Property("dateCriterion", "", "Vaccine date recommendations.  For example, earliest date to administer, latest date to administer, etc.", 0, Integer.MAX_VALUE, this.dateCriterion));
            children.add(new Property("description", "string", "Contains the description about the protocol under which the vaccine was administered.", 0, 1, this.description));
            children.add(new Property("series", "string", "One possible path to achieve presumed immunity against a disease - within the context of an authority.", 0, 1, this.series));
            children.add(new Property("doseNumber[x]", "positiveInt|string", "Nominal position of the recommended dose in a series (e.g. dose 2 is the next recommended dose).", 0, 1, this.doseNumber));
            children.add(new Property("seriesDoses[x]", "positiveInt|string", "The recommended number of doses to achieve immunity.", 0, 1, this.seriesDoses));
            children.add(new Property("supportingImmunization", "Reference(Immunization|ImmunizationEvaluation)", "Immunization event history and/or evaluation that supports the status and recommendation.", 0, Integer.MAX_VALUE, this.supportingImmunization));
            children.add(new Property("supportingPatientInformation", "Reference(Any)", "Patient Information that supports the status and recommendation.  This includes patient observations, adverse reactions and allergy/intolerance information.", 0, Integer.MAX_VALUE, this.supportingPatientInformation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 664556354: {
                    return new Property("vaccineCode", "CodeableConcept", "Vaccine(s) or vaccine group that pertain to the recommendation.", 0, Integer.MAX_VALUE, this.vaccineCode);
                }
                case -319593813: {
                    return new Property("targetDisease", "CodeableConcept", "The targeted disease for the recommendation.", 0, 1, this.targetDisease);
                }
                case 571105240: {
                    return new Property("contraindicatedVaccineCode", "CodeableConcept", "Vaccine(s) which should not be used to fulfill the recommendation.", 0, Integer.MAX_VALUE, this.contraindicatedVaccineCode);
                }
                case 1904598477: {
                    return new Property("forecastStatus", "CodeableConcept", "Indicates the patient status with respect to the path to immunity for the target disease.", 0, 1, this.forecastStatus);
                }
                case 1862115359: {
                    return new Property("forecastReason", "CodeableConcept", "The reason for the assigned forecast status.", 0, Integer.MAX_VALUE, this.forecastReason);
                }
                case 2087518867: {
                    return new Property("dateCriterion", "", "Vaccine date recommendations.  For example, earliest date to administer, latest date to administer, etc.", 0, Integer.MAX_VALUE, this.dateCriterion);
                }
                case -1724546052: {
                    return new Property("description", "string", "Contains the description about the protocol under which the vaccine was administered.", 0, 1, this.description);
                }
                case -905838985: {
                    return new Property("series", "string", "One possible path to achieve presumed immunity against a disease - within the context of an authority.", 0, 1, this.series);
                }
                case -1632295686: {
                    return new Property("doseNumber[x]", "positiveInt|string", "Nominal position of the recommended dose in a series (e.g. dose 2 is the next recommended dose).", 0, 1, this.doseNumber);
                }
                case -887709242: {
                    return new Property("doseNumber[x]", "positiveInt|string", "Nominal position of the recommended dose in a series (e.g. dose 2 is the next recommended dose).", 0, 1, this.doseNumber);
                }
                case -1826134640: {
                    return new Property("doseNumber[x]", "positiveInt|string", "Nominal position of the recommended dose in a series (e.g. dose 2 is the next recommended dose).", 0, 1, this.doseNumber);
                }
                case -333053577: {
                    return new Property("doseNumber[x]", "positiveInt|string", "Nominal position of the recommended dose in a series (e.g. dose 2 is the next recommended dose).", 0, 1, this.doseNumber);
                }
                case 1553560673: {
                    return new Property("seriesDoses[x]", "positiveInt|string", "The recommended number of doses to achieve immunity.", 0, 1, this.seriesDoses);
                }
                case -1936727105: {
                    return new Property("seriesDoses[x]", "positiveInt|string", "The recommended number of doses to achieve immunity.", 0, 1, this.seriesDoses);
                }
                case -220897801: {
                    return new Property("seriesDoses[x]", "positiveInt|string", "The recommended number of doses to achieve immunity.", 0, 1, this.seriesDoses);
                }
                case -673569616: {
                    return new Property("seriesDoses[x]", "positiveInt|string", "The recommended number of doses to achieve immunity.", 0, 1, this.seriesDoses);
                }
                case 1171592021: {
                    return new Property("supportingImmunization", "Reference(Immunization|ImmunizationEvaluation)", "Immunization event history and/or evaluation that supports the status and recommendation.", 0, Integer.MAX_VALUE, this.supportingImmunization);
                }
                case -1234160646: {
                    return new Property("supportingPatientInformation", "Reference(Any)", "Patient Information that supports the status and recommendation.  This includes patient observations, adverse reactions and allergy/intolerance information.", 0, Integer.MAX_VALUE, this.supportingPatientInformation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 664556354: {
                    return this.vaccineCode == null ? new Base[]{} : this.vaccineCode.toArray(new Base[this.vaccineCode.size()]);
                }
                case -319593813: {
                    Base[] baseArray;
                    if (this.targetDisease == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.targetDisease;
                    }
                    return baseArray;
                }
                case 571105240: {
                    return this.contraindicatedVaccineCode == null ? new Base[]{} : this.contraindicatedVaccineCode.toArray(new Base[this.contraindicatedVaccineCode.size()]);
                }
                case 1904598477: {
                    Base[] baseArray;
                    if (this.forecastStatus == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.forecastStatus;
                    }
                    return baseArray;
                }
                case 1862115359: {
                    return this.forecastReason == null ? new Base[]{} : this.forecastReason.toArray(new Base[this.forecastReason.size()]);
                }
                case 2087518867: {
                    return this.dateCriterion == null ? new Base[]{} : this.dateCriterion.toArray(new Base[this.dateCriterion.size()]);
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
                case -905838985: {
                    Base[] baseArray;
                    if (this.series == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.series;
                    }
                    return baseArray;
                }
                case -887709242: {
                    Base[] baseArray;
                    if (this.doseNumber == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.doseNumber;
                    }
                    return baseArray;
                }
                case -1936727105: {
                    Base[] baseArray;
                    if (this.seriesDoses == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.seriesDoses;
                    }
                    return baseArray;
                }
                case 1171592021: {
                    return this.supportingImmunization == null ? new Base[]{} : this.supportingImmunization.toArray(new Base[this.supportingImmunization.size()]);
                }
                case -1234160646: {
                    return this.supportingPatientInformation == null ? new Base[]{} : this.supportingPatientInformation.toArray(new Base[this.supportingPatientInformation.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 664556354: {
                    this.getVaccineCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -319593813: {
                    this.targetDisease = this.castToCodeableConcept(value);
                    return value;
                }
                case 571105240: {
                    this.getContraindicatedVaccineCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1904598477: {
                    this.forecastStatus = this.castToCodeableConcept(value);
                    return value;
                }
                case 1862115359: {
                    this.getForecastReason().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 2087518867: {
                    this.getDateCriterion().add((ImmunizationRecommendationRecommendationDateCriterionComponent)value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -905838985: {
                    this.series = this.castToString(value);
                    return value;
                }
                case -887709242: {
                    this.doseNumber = this.castToType(value);
                    return value;
                }
                case -1936727105: {
                    this.seriesDoses = this.castToType(value);
                    return value;
                }
                case 1171592021: {
                    this.getSupportingImmunization().add(this.castToReference(value));
                    return value;
                }
                case -1234160646: {
                    this.getSupportingPatientInformation().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("vaccineCode")) {
                this.getVaccineCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("targetDisease")) {
                this.targetDisease = this.castToCodeableConcept(value);
            } else if (name.equals("contraindicatedVaccineCode")) {
                this.getContraindicatedVaccineCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("forecastStatus")) {
                this.forecastStatus = this.castToCodeableConcept(value);
            } else if (name.equals("forecastReason")) {
                this.getForecastReason().add(this.castToCodeableConcept(value));
            } else if (name.equals("dateCriterion")) {
                this.getDateCriterion().add((ImmunizationRecommendationRecommendationDateCriterionComponent)value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("series")) {
                this.series = this.castToString(value);
            } else if (name.equals("doseNumber[x]")) {
                this.doseNumber = this.castToType(value);
            } else if (name.equals("seriesDoses[x]")) {
                this.seriesDoses = this.castToType(value);
            } else if (name.equals("supportingImmunization")) {
                this.getSupportingImmunization().add(this.castToReference(value));
            } else if (name.equals("supportingPatientInformation")) {
                this.getSupportingPatientInformation().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 664556354: {
                    return this.addVaccineCode();
                }
                case -319593813: {
                    return this.getTargetDisease();
                }
                case 571105240: {
                    return this.addContraindicatedVaccineCode();
                }
                case 1904598477: {
                    return this.getForecastStatus();
                }
                case 1862115359: {
                    return this.addForecastReason();
                }
                case 2087518867: {
                    return this.addDateCriterion();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -905838985: {
                    return this.getSeriesElement();
                }
                case -1632295686: {
                    return this.getDoseNumber();
                }
                case -887709242: {
                    return this.getDoseNumber();
                }
                case 1553560673: {
                    return this.getSeriesDoses();
                }
                case -1936727105: {
                    return this.getSeriesDoses();
                }
                case 1171592021: {
                    return this.addSupportingImmunization();
                }
                case -1234160646: {
                    return this.addSupportingPatientInformation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 664556354: {
                    return new String[]{"CodeableConcept"};
                }
                case -319593813: {
                    return new String[]{"CodeableConcept"};
                }
                case 571105240: {
                    return new String[]{"CodeableConcept"};
                }
                case 1904598477: {
                    return new String[]{"CodeableConcept"};
                }
                case 1862115359: {
                    return new String[]{"CodeableConcept"};
                }
                case 2087518867: {
                    return new String[0];
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -905838985: {
                    return new String[]{"string"};
                }
                case -887709242: {
                    return new String[]{"positiveInt", "string"};
                }
                case -1936727105: {
                    return new String[]{"positiveInt", "string"};
                }
                case 1171592021: {
                    return new String[]{"Reference"};
                }
                case -1234160646: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("vaccineCode")) {
                return this.addVaccineCode();
            }
            if (name.equals("targetDisease")) {
                this.targetDisease = new CodeableConcept();
                return this.targetDisease;
            }
            if (name.equals("contraindicatedVaccineCode")) {
                return this.addContraindicatedVaccineCode();
            }
            if (name.equals("forecastStatus")) {
                this.forecastStatus = new CodeableConcept();
                return this.forecastStatus;
            }
            if (name.equals("forecastReason")) {
                return this.addForecastReason();
            }
            if (name.equals("dateCriterion")) {
                return this.addDateCriterion();
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImmunizationRecommendation.description");
            }
            if (name.equals("series")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImmunizationRecommendation.series");
            }
            if (name.equals("doseNumberPositiveInt")) {
                this.doseNumber = new PositiveIntType();
                return this.doseNumber;
            }
            if (name.equals("doseNumberString")) {
                this.doseNumber = new StringType();
                return this.doseNumber;
            }
            if (name.equals("seriesDosesPositiveInt")) {
                this.seriesDoses = new PositiveIntType();
                return this.seriesDoses;
            }
            if (name.equals("seriesDosesString")) {
                this.seriesDoses = new StringType();
                return this.seriesDoses;
            }
            if (name.equals("supportingImmunization")) {
                return this.addSupportingImmunization();
            }
            if (name.equals("supportingPatientInformation")) {
                return this.addSupportingPatientInformation();
            }
            return super.addChild(name);
        }

        @Override
        public ImmunizationRecommendationRecommendationComponent copy() {
            ImmunizationRecommendationRecommendationComponent dst = new ImmunizationRecommendationRecommendationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImmunizationRecommendationRecommendationComponent dst) {
            super.copyValues(dst);
            if (this.vaccineCode != null) {
                dst.vaccineCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.vaccineCode) {
                    dst.vaccineCode.add(codeableConcept.copy());
                }
            }
            CodeableConcept codeableConcept = dst.targetDisease = this.targetDisease == null ? null : this.targetDisease.copy();
            if (this.contraindicatedVaccineCode != null) {
                dst.contraindicatedVaccineCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.contraindicatedVaccineCode) {
                    dst.contraindicatedVaccineCode.add(codeableConcept2.copy());
                }
            }
            CodeableConcept codeableConcept3 = dst.forecastStatus = this.forecastStatus == null ? null : this.forecastStatus.copy();
            if (this.forecastReason != null) {
                dst.forecastReason = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept4 : this.forecastReason) {
                    dst.forecastReason.add(codeableConcept4.copy());
                }
            }
            if (this.dateCriterion != null) {
                dst.dateCriterion = new ArrayList<ImmunizationRecommendationRecommendationDateCriterionComponent>();
                for (ImmunizationRecommendationRecommendationDateCriterionComponent immunizationRecommendationRecommendationDateCriterionComponent : this.dateCriterion) {
                    dst.dateCriterion.add(immunizationRecommendationRecommendationDateCriterionComponent.copy());
                }
            }
            dst.description = this.description == null ? null : this.description.copy();
            dst.series = this.series == null ? null : this.series.copy();
            dst.doseNumber = this.doseNumber == null ? null : this.doseNumber.copy();
            Type type = dst.seriesDoses = this.seriesDoses == null ? null : this.seriesDoses.copy();
            if (this.supportingImmunization != null) {
                dst.supportingImmunization = new ArrayList<Reference>();
                for (Reference reference : this.supportingImmunization) {
                    dst.supportingImmunization.add(reference.copy());
                }
            }
            if (this.supportingPatientInformation != null) {
                dst.supportingPatientInformation = new ArrayList<Reference>();
                for (Reference reference : this.supportingPatientInformation) {
                    dst.supportingPatientInformation.add(reference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImmunizationRecommendationRecommendationComponent)) {
                return false;
            }
            ImmunizationRecommendationRecommendationComponent o = (ImmunizationRecommendationRecommendationComponent)other_;
            return ImmunizationRecommendationRecommendationComponent.compareDeep(this.vaccineCode, o.vaccineCode, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.targetDisease, o.targetDisease, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.contraindicatedVaccineCode, o.contraindicatedVaccineCode, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.forecastStatus, o.forecastStatus, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.forecastReason, o.forecastReason, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.dateCriterion, o.dateCriterion, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.description, o.description, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.series, o.series, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.doseNumber, o.doseNumber, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.seriesDoses, o.seriesDoses, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.supportingImmunization, o.supportingImmunization, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.supportingPatientInformation, o.supportingPatientInformation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImmunizationRecommendationRecommendationComponent)) {
                return false;
            }
            ImmunizationRecommendationRecommendationComponent o = (ImmunizationRecommendationRecommendationComponent)other_;
            return ImmunizationRecommendationRecommendationComponent.compareValues(this.description, o.description, true) && ImmunizationRecommendationRecommendationComponent.compareValues(this.series, o.series, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.vaccineCode, this.targetDisease, this.contraindicatedVaccineCode, this.forecastStatus, this.forecastReason, this.dateCriterion, this.description, this.series, this.doseNumber, this.seriesDoses, this.supportingImmunization, this.supportingPatientInformation});
        }

        @Override
        public String fhirType() {
            return "ImmunizationRecommendation.recommendation";
        }
    }
}

