/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Ratio;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Substance;
import org.hl7.fhir.r4.model.SubstanceNucleicAcid;
import org.hl7.fhir.r4.model.SubstancePolymer;
import org.hl7.fhir.r4.model.SubstanceProtein;
import org.hl7.fhir.r4.model.SubstanceReferenceInformation;
import org.hl7.fhir.r4.model.SubstanceSourceMaterial;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="SubstanceSpecification", profile="http://hl7.org/fhir/StructureDefinition/SubstanceSpecification")
public class SubstanceSpecification
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier by which this substance is known", formalDefinition="Identifier by which this substance is known.")
    protected Identifier identifier;
    @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="High level categorization, e.g. polymer or nucleic acid", formalDefinition="High level categorization, e.g. polymer or nucleic acid.")
    protected CodeableConcept type;
    @Child(name="status", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Status of substance within the catalogue e.g. approved", formalDefinition="Status of substance within the catalogue e.g. approved.")
    protected CodeableConcept status;
    @Child(name="domain", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If the substance applies to only human or veterinary use", formalDefinition="If the substance applies to only human or veterinary use.")
    protected CodeableConcept domain;
    @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Textual description of the substance", formalDefinition="Textual description of the substance.")
    protected StringType description;
    @Child(name="source", type={DocumentReference.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Supporting literature", formalDefinition="Supporting literature.")
    protected List<Reference> source;
    protected List<DocumentReference> sourceTarget;
    @Child(name="comment", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Textual comment about this record of a substance", formalDefinition="Textual comment about this record of a substance.")
    protected StringType comment;
    @Child(name="moiety", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Moiety, for structural modifications", formalDefinition="Moiety, for structural modifications.")
    protected List<SubstanceSpecificationMoietyComponent> moiety;
    @Child(name="property", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="General specifications for this substance, including how it is related to other substances", formalDefinition="General specifications for this substance, including how it is related to other substances.")
    protected List<SubstanceSpecificationPropertyComponent> property;
    @Child(name="referenceInformation", type={SubstanceReferenceInformation.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="General information detailing this substance", formalDefinition="General information detailing this substance.")
    protected Reference referenceInformation;
    protected SubstanceReferenceInformation referenceInformationTarget;
    @Child(name="structure", type={}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Structural information", formalDefinition="Structural information.")
    protected SubstanceSpecificationStructureComponent structure;
    @Child(name="code", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Codes associated with the substance", formalDefinition="Codes associated with the substance.")
    protected List<SubstanceSpecificationCodeComponent> code;
    @Child(name="name", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Names applicable to this substance", formalDefinition="Names applicable to this substance.")
    protected List<SubstanceSpecificationNameComponent> name;
    @Child(name="molecularWeight", type={SubstanceSpecificationStructureIsotopeMolecularWeightComponent.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The molecular weight or weight range (for proteins, polymers or nucleic acids)", formalDefinition="The molecular weight or weight range (for proteins, polymers or nucleic acids).")
    protected List<SubstanceSpecificationStructureIsotopeMolecularWeightComponent> molecularWeight;
    @Child(name="relationship", type={}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A link between this substance and another, with details of the relationship", formalDefinition="A link between this substance and another, with details of the relationship.")
    protected List<SubstanceSpecificationRelationshipComponent> relationship;
    @Child(name="nucleicAcid", type={SubstanceNucleicAcid.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Data items specific to nucleic acids", formalDefinition="Data items specific to nucleic acids.")
    protected Reference nucleicAcid;
    protected SubstanceNucleicAcid nucleicAcidTarget;
    @Child(name="polymer", type={SubstancePolymer.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Data items specific to polymers", formalDefinition="Data items specific to polymers.")
    protected Reference polymer;
    protected SubstancePolymer polymerTarget;
    @Child(name="protein", type={SubstanceProtein.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Data items specific to proteins", formalDefinition="Data items specific to proteins.")
    protected Reference protein;
    protected SubstanceProtein proteinTarget;
    @Child(name="sourceMaterial", type={SubstanceSourceMaterial.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Material or taxonomic/anatomical source for the substance", formalDefinition="Material or taxonomic/anatomical source for the substance.")
    protected Reference sourceMaterial;
    protected SubstanceSourceMaterial sourceMaterialTarget;
    private static final long serialVersionUID = 1782072718L;
    @SearchParamDefinition(name="code", path="SubstanceSpecification.code.code", description="The specific code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public SubstanceSpecification setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public SubstanceSpecification setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public CodeableConcept getStatus() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new CodeableConcept();
            }
        }
        return this.status;
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public SubstanceSpecification setStatus(CodeableConcept value) {
        this.status = value;
        return this;
    }

    public CodeableConcept getDomain() {
        if (this.domain == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.domain");
            }
            if (Configuration.doAutoCreate()) {
                this.domain = new CodeableConcept();
            }
        }
        return this.domain;
    }

    public boolean hasDomain() {
        return this.domain != null && !this.domain.isEmpty();
    }

    public SubstanceSpecification setDomain(CodeableConcept value) {
        this.domain = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public SubstanceSpecification setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public SubstanceSpecification setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Reference> getSource() {
        if (this.source == null) {
            this.source = new ArrayList<Reference>();
        }
        return this.source;
    }

    public SubstanceSpecification setSource(List<Reference> theSource) {
        this.source = theSource;
        return this;
    }

    public boolean hasSource() {
        if (this.source == null) {
            return false;
        }
        for (Reference item : this.source) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSource() {
        Reference t = new Reference();
        if (this.source == null) {
            this.source = new ArrayList<Reference>();
        }
        this.source.add(t);
        return t;
    }

    public SubstanceSpecification addSource(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.source == null) {
            this.source = new ArrayList<Reference>();
        }
        this.source.add(t);
        return this;
    }

    public Reference getSourceFirstRep() {
        if (this.getSource().isEmpty()) {
            this.addSource();
        }
        return this.getSource().get(0);
    }

    @Deprecated
    public List<DocumentReference> getSourceTarget() {
        if (this.sourceTarget == null) {
            this.sourceTarget = new ArrayList<DocumentReference>();
        }
        return this.sourceTarget;
    }

    @Deprecated
    public DocumentReference addSourceTarget() {
        DocumentReference r = new DocumentReference();
        if (this.sourceTarget == null) {
            this.sourceTarget = new ArrayList<DocumentReference>();
        }
        this.sourceTarget.add(r);
        return r;
    }

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public SubstanceSpecification setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public SubstanceSpecification setComment(String value) {
        if (Utilities.noString((String)value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    public List<SubstanceSpecificationMoietyComponent> getMoiety() {
        if (this.moiety == null) {
            this.moiety = new ArrayList<SubstanceSpecificationMoietyComponent>();
        }
        return this.moiety;
    }

    public SubstanceSpecification setMoiety(List<SubstanceSpecificationMoietyComponent> theMoiety) {
        this.moiety = theMoiety;
        return this;
    }

    public boolean hasMoiety() {
        if (this.moiety == null) {
            return false;
        }
        for (SubstanceSpecificationMoietyComponent item : this.moiety) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceSpecificationMoietyComponent addMoiety() {
        SubstanceSpecificationMoietyComponent t = new SubstanceSpecificationMoietyComponent();
        if (this.moiety == null) {
            this.moiety = new ArrayList<SubstanceSpecificationMoietyComponent>();
        }
        this.moiety.add(t);
        return t;
    }

    public SubstanceSpecification addMoiety(SubstanceSpecificationMoietyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.moiety == null) {
            this.moiety = new ArrayList<SubstanceSpecificationMoietyComponent>();
        }
        this.moiety.add(t);
        return this;
    }

    public SubstanceSpecificationMoietyComponent getMoietyFirstRep() {
        if (this.getMoiety().isEmpty()) {
            this.addMoiety();
        }
        return this.getMoiety().get(0);
    }

    public List<SubstanceSpecificationPropertyComponent> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<SubstanceSpecificationPropertyComponent>();
        }
        return this.property;
    }

    public SubstanceSpecification setProperty(List<SubstanceSpecificationPropertyComponent> theProperty) {
        this.property = theProperty;
        return this;
    }

    public boolean hasProperty() {
        if (this.property == null) {
            return false;
        }
        for (SubstanceSpecificationPropertyComponent item : this.property) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceSpecificationPropertyComponent addProperty() {
        SubstanceSpecificationPropertyComponent t = new SubstanceSpecificationPropertyComponent();
        if (this.property == null) {
            this.property = new ArrayList<SubstanceSpecificationPropertyComponent>();
        }
        this.property.add(t);
        return t;
    }

    public SubstanceSpecification addProperty(SubstanceSpecificationPropertyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.property == null) {
            this.property = new ArrayList<SubstanceSpecificationPropertyComponent>();
        }
        this.property.add(t);
        return this;
    }

    public SubstanceSpecificationPropertyComponent getPropertyFirstRep() {
        if (this.getProperty().isEmpty()) {
            this.addProperty();
        }
        return this.getProperty().get(0);
    }

    public Reference getReferenceInformation() {
        if (this.referenceInformation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.referenceInformation");
            }
            if (Configuration.doAutoCreate()) {
                this.referenceInformation = new Reference();
            }
        }
        return this.referenceInformation;
    }

    public boolean hasReferenceInformation() {
        return this.referenceInformation != null && !this.referenceInformation.isEmpty();
    }

    public SubstanceSpecification setReferenceInformation(Reference value) {
        this.referenceInformation = value;
        return this;
    }

    public SubstanceReferenceInformation getReferenceInformationTarget() {
        if (this.referenceInformationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.referenceInformation");
            }
            if (Configuration.doAutoCreate()) {
                this.referenceInformationTarget = new SubstanceReferenceInformation();
            }
        }
        return this.referenceInformationTarget;
    }

    public SubstanceSpecification setReferenceInformationTarget(SubstanceReferenceInformation value) {
        this.referenceInformationTarget = value;
        return this;
    }

    public SubstanceSpecificationStructureComponent getStructure() {
        if (this.structure == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.structure");
            }
            if (Configuration.doAutoCreate()) {
                this.structure = new SubstanceSpecificationStructureComponent();
            }
        }
        return this.structure;
    }

    public boolean hasStructure() {
        return this.structure != null && !this.structure.isEmpty();
    }

    public SubstanceSpecification setStructure(SubstanceSpecificationStructureComponent value) {
        this.structure = value;
        return this;
    }

    public List<SubstanceSpecificationCodeComponent> getCode() {
        if (this.code == null) {
            this.code = new ArrayList<SubstanceSpecificationCodeComponent>();
        }
        return this.code;
    }

    public SubstanceSpecification setCode(List<SubstanceSpecificationCodeComponent> theCode) {
        this.code = theCode;
        return this;
    }

    public boolean hasCode() {
        if (this.code == null) {
            return false;
        }
        for (SubstanceSpecificationCodeComponent item : this.code) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceSpecificationCodeComponent addCode() {
        SubstanceSpecificationCodeComponent t = new SubstanceSpecificationCodeComponent();
        if (this.code == null) {
            this.code = new ArrayList<SubstanceSpecificationCodeComponent>();
        }
        this.code.add(t);
        return t;
    }

    public SubstanceSpecification addCode(SubstanceSpecificationCodeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.code == null) {
            this.code = new ArrayList<SubstanceSpecificationCodeComponent>();
        }
        this.code.add(t);
        return this;
    }

    public SubstanceSpecificationCodeComponent getCodeFirstRep() {
        if (this.getCode().isEmpty()) {
            this.addCode();
        }
        return this.getCode().get(0);
    }

    public List<SubstanceSpecificationNameComponent> getName() {
        if (this.name == null) {
            this.name = new ArrayList<SubstanceSpecificationNameComponent>();
        }
        return this.name;
    }

    public SubstanceSpecification setName(List<SubstanceSpecificationNameComponent> theName) {
        this.name = theName;
        return this;
    }

    public boolean hasName() {
        if (this.name == null) {
            return false;
        }
        for (SubstanceSpecificationNameComponent item : this.name) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceSpecificationNameComponent addName() {
        SubstanceSpecificationNameComponent t = new SubstanceSpecificationNameComponent();
        if (this.name == null) {
            this.name = new ArrayList<SubstanceSpecificationNameComponent>();
        }
        this.name.add(t);
        return t;
    }

    public SubstanceSpecification addName(SubstanceSpecificationNameComponent t) {
        if (t == null) {
            return this;
        }
        if (this.name == null) {
            this.name = new ArrayList<SubstanceSpecificationNameComponent>();
        }
        this.name.add(t);
        return this;
    }

    public SubstanceSpecificationNameComponent getNameFirstRep() {
        if (this.getName().isEmpty()) {
            this.addName();
        }
        return this.getName().get(0);
    }

    public List<SubstanceSpecificationStructureIsotopeMolecularWeightComponent> getMolecularWeight() {
        if (this.molecularWeight == null) {
            this.molecularWeight = new ArrayList<SubstanceSpecificationStructureIsotopeMolecularWeightComponent>();
        }
        return this.molecularWeight;
    }

    public SubstanceSpecification setMolecularWeight(List<SubstanceSpecificationStructureIsotopeMolecularWeightComponent> theMolecularWeight) {
        this.molecularWeight = theMolecularWeight;
        return this;
    }

    public boolean hasMolecularWeight() {
        if (this.molecularWeight == null) {
            return false;
        }
        for (SubstanceSpecificationStructureIsotopeMolecularWeightComponent item : this.molecularWeight) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceSpecificationStructureIsotopeMolecularWeightComponent addMolecularWeight() {
        SubstanceSpecificationStructureIsotopeMolecularWeightComponent t = new SubstanceSpecificationStructureIsotopeMolecularWeightComponent();
        if (this.molecularWeight == null) {
            this.molecularWeight = new ArrayList<SubstanceSpecificationStructureIsotopeMolecularWeightComponent>();
        }
        this.molecularWeight.add(t);
        return t;
    }

    public SubstanceSpecification addMolecularWeight(SubstanceSpecificationStructureIsotopeMolecularWeightComponent t) {
        if (t == null) {
            return this;
        }
        if (this.molecularWeight == null) {
            this.molecularWeight = new ArrayList<SubstanceSpecificationStructureIsotopeMolecularWeightComponent>();
        }
        this.molecularWeight.add(t);
        return this;
    }

    public SubstanceSpecificationStructureIsotopeMolecularWeightComponent getMolecularWeightFirstRep() {
        if (this.getMolecularWeight().isEmpty()) {
            this.addMolecularWeight();
        }
        return this.getMolecularWeight().get(0);
    }

    public List<SubstanceSpecificationRelationshipComponent> getRelationship() {
        if (this.relationship == null) {
            this.relationship = new ArrayList<SubstanceSpecificationRelationshipComponent>();
        }
        return this.relationship;
    }

    public SubstanceSpecification setRelationship(List<SubstanceSpecificationRelationshipComponent> theRelationship) {
        this.relationship = theRelationship;
        return this;
    }

    public boolean hasRelationship() {
        if (this.relationship == null) {
            return false;
        }
        for (SubstanceSpecificationRelationshipComponent item : this.relationship) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceSpecificationRelationshipComponent addRelationship() {
        SubstanceSpecificationRelationshipComponent t = new SubstanceSpecificationRelationshipComponent();
        if (this.relationship == null) {
            this.relationship = new ArrayList<SubstanceSpecificationRelationshipComponent>();
        }
        this.relationship.add(t);
        return t;
    }

    public SubstanceSpecification addRelationship(SubstanceSpecificationRelationshipComponent t) {
        if (t == null) {
            return this;
        }
        if (this.relationship == null) {
            this.relationship = new ArrayList<SubstanceSpecificationRelationshipComponent>();
        }
        this.relationship.add(t);
        return this;
    }

    public SubstanceSpecificationRelationshipComponent getRelationshipFirstRep() {
        if (this.getRelationship().isEmpty()) {
            this.addRelationship();
        }
        return this.getRelationship().get(0);
    }

    public Reference getNucleicAcid() {
        if (this.nucleicAcid == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.nucleicAcid");
            }
            if (Configuration.doAutoCreate()) {
                this.nucleicAcid = new Reference();
            }
        }
        return this.nucleicAcid;
    }

    public boolean hasNucleicAcid() {
        return this.nucleicAcid != null && !this.nucleicAcid.isEmpty();
    }

    public SubstanceSpecification setNucleicAcid(Reference value) {
        this.nucleicAcid = value;
        return this;
    }

    public SubstanceNucleicAcid getNucleicAcidTarget() {
        if (this.nucleicAcidTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.nucleicAcid");
            }
            if (Configuration.doAutoCreate()) {
                this.nucleicAcidTarget = new SubstanceNucleicAcid();
            }
        }
        return this.nucleicAcidTarget;
    }

    public SubstanceSpecification setNucleicAcidTarget(SubstanceNucleicAcid value) {
        this.nucleicAcidTarget = value;
        return this;
    }

    public Reference getPolymer() {
        if (this.polymer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.polymer");
            }
            if (Configuration.doAutoCreate()) {
                this.polymer = new Reference();
            }
        }
        return this.polymer;
    }

    public boolean hasPolymer() {
        return this.polymer != null && !this.polymer.isEmpty();
    }

    public SubstanceSpecification setPolymer(Reference value) {
        this.polymer = value;
        return this;
    }

    public SubstancePolymer getPolymerTarget() {
        if (this.polymerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.polymer");
            }
            if (Configuration.doAutoCreate()) {
                this.polymerTarget = new SubstancePolymer();
            }
        }
        return this.polymerTarget;
    }

    public SubstanceSpecification setPolymerTarget(SubstancePolymer value) {
        this.polymerTarget = value;
        return this;
    }

    public Reference getProtein() {
        if (this.protein == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.protein");
            }
            if (Configuration.doAutoCreate()) {
                this.protein = new Reference();
            }
        }
        return this.protein;
    }

    public boolean hasProtein() {
        return this.protein != null && !this.protein.isEmpty();
    }

    public SubstanceSpecification setProtein(Reference value) {
        this.protein = value;
        return this;
    }

    public SubstanceProtein getProteinTarget() {
        if (this.proteinTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.protein");
            }
            if (Configuration.doAutoCreate()) {
                this.proteinTarget = new SubstanceProtein();
            }
        }
        return this.proteinTarget;
    }

    public SubstanceSpecification setProteinTarget(SubstanceProtein value) {
        this.proteinTarget = value;
        return this;
    }

    public Reference getSourceMaterial() {
        if (this.sourceMaterial == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.sourceMaterial");
            }
            if (Configuration.doAutoCreate()) {
                this.sourceMaterial = new Reference();
            }
        }
        return this.sourceMaterial;
    }

    public boolean hasSourceMaterial() {
        return this.sourceMaterial != null && !this.sourceMaterial.isEmpty();
    }

    public SubstanceSpecification setSourceMaterial(Reference value) {
        this.sourceMaterial = value;
        return this;
    }

    public SubstanceSourceMaterial getSourceMaterialTarget() {
        if (this.sourceMaterialTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.sourceMaterial");
            }
            if (Configuration.doAutoCreate()) {
                this.sourceMaterialTarget = new SubstanceSourceMaterial();
            }
        }
        return this.sourceMaterialTarget;
    }

    public SubstanceSpecification setSourceMaterialTarget(SubstanceSourceMaterial value) {
        this.sourceMaterialTarget = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("identifier", "Identifier", "Identifier by which this substance is known.", 0, 1, this.identifier));
        children.add(new Property("type", "CodeableConcept", "High level categorization, e.g. polymer or nucleic acid.", 0, 1, this.type));
        children.add(new Property("status", "CodeableConcept", "Status of substance within the catalogue e.g. approved.", 0, 1, this.status));
        children.add(new Property("domain", "CodeableConcept", "If the substance applies to only human or veterinary use.", 0, 1, this.domain));
        children.add(new Property("description", "string", "Textual description of the substance.", 0, 1, this.description));
        children.add(new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source));
        children.add(new Property("comment", "string", "Textual comment about this record of a substance.", 0, 1, this.comment));
        children.add(new Property("moiety", "", "Moiety, for structural modifications.", 0, Integer.MAX_VALUE, this.moiety));
        children.add(new Property("property", "", "General specifications for this substance, including how it is related to other substances.", 0, Integer.MAX_VALUE, this.property));
        children.add(new Property("referenceInformation", "Reference(SubstanceReferenceInformation)", "General information detailing this substance.", 0, 1, this.referenceInformation));
        children.add(new Property("structure", "", "Structural information.", 0, 1, this.structure));
        children.add(new Property(SP_CODE, "", "Codes associated with the substance.", 0, Integer.MAX_VALUE, this.code));
        children.add(new Property("name", "", "Names applicable to this substance.", 0, Integer.MAX_VALUE, this.name));
        children.add(new Property("molecularWeight", "@SubstanceSpecification.structure.isotope.molecularWeight", "The molecular weight or weight range (for proteins, polymers or nucleic acids).", 0, Integer.MAX_VALUE, this.molecularWeight));
        children.add(new Property("relationship", "", "A link between this substance and another, with details of the relationship.", 0, Integer.MAX_VALUE, this.relationship));
        children.add(new Property("nucleicAcid", "Reference(SubstanceNucleicAcid)", "Data items specific to nucleic acids.", 0, 1, this.nucleicAcid));
        children.add(new Property("polymer", "Reference(SubstancePolymer)", "Data items specific to polymers.", 0, 1, this.polymer));
        children.add(new Property("protein", "Reference(SubstanceProtein)", "Data items specific to proteins.", 0, 1, this.protein));
        children.add(new Property("sourceMaterial", "Reference(SubstanceSourceMaterial)", "Material or taxonomic/anatomical source for the substance.", 0, 1, this.sourceMaterial));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property("identifier", "Identifier", "Identifier by which this substance is known.", 0, 1, this.identifier);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "High level categorization, e.g. polymer or nucleic acid.", 0, 1, this.type);
            }
            case -892481550: {
                return new Property("status", "CodeableConcept", "Status of substance within the catalogue e.g. approved.", 0, 1, this.status);
            }
            case -1326197564: {
                return new Property("domain", "CodeableConcept", "If the substance applies to only human or veterinary use.", 0, 1, this.domain);
            }
            case -1724546052: {
                return new Property("description", "string", "Textual description of the substance.", 0, 1, this.description);
            }
            case -896505829: {
                return new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source);
            }
            case 950398559: {
                return new Property("comment", "string", "Textual comment about this record of a substance.", 0, 1, this.comment);
            }
            case -1068650173: {
                return new Property("moiety", "", "Moiety, for structural modifications.", 0, Integer.MAX_VALUE, this.moiety);
            }
            case -993141291: {
                return new Property("property", "", "General specifications for this substance, including how it is related to other substances.", 0, Integer.MAX_VALUE, this.property);
            }
            case -2117930783: {
                return new Property("referenceInformation", "Reference(SubstanceReferenceInformation)", "General information detailing this substance.", 0, 1, this.referenceInformation);
            }
            case 144518515: {
                return new Property("structure", "", "Structural information.", 0, 1, this.structure);
            }
            case 3059181: {
                return new Property(SP_CODE, "", "Codes associated with the substance.", 0, Integer.MAX_VALUE, this.code);
            }
            case 3373707: {
                return new Property("name", "", "Names applicable to this substance.", 0, Integer.MAX_VALUE, this.name);
            }
            case 635625672: {
                return new Property("molecularWeight", "@SubstanceSpecification.structure.isotope.molecularWeight", "The molecular weight or weight range (for proteins, polymers or nucleic acids).", 0, Integer.MAX_VALUE, this.molecularWeight);
            }
            case -261851592: {
                return new Property("relationship", "", "A link between this substance and another, with details of the relationship.", 0, Integer.MAX_VALUE, this.relationship);
            }
            case 1625275180: {
                return new Property("nucleicAcid", "Reference(SubstanceNucleicAcid)", "Data items specific to nucleic acids.", 0, 1, this.nucleicAcid);
            }
            case -397514098: {
                return new Property("polymer", "Reference(SubstancePolymer)", "Data items specific to polymers.", 0, 1, this.polymer);
            }
            case -309012605: {
                return new Property("protein", "Reference(SubstanceProtein)", "Data items specific to proteins.", 0, 1, this.protein);
            }
            case -1064442270: {
                return new Property("sourceMaterial", "Reference(SubstanceSourceMaterial)", "Material or taxonomic/anatomical source for the substance.", 0, 1, this.sourceMaterial);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case -1326197564: {
                Base[] baseArray;
                if (this.domain == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.domain;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.description;
                }
                return baseArray;
            }
            case -896505829: {
                return this.source == null ? new Base[]{} : this.source.toArray(new Base[this.source.size()]);
            }
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.comment;
                }
                return baseArray;
            }
            case -1068650173: {
                return this.moiety == null ? new Base[]{} : this.moiety.toArray(new Base[this.moiety.size()]);
            }
            case -993141291: {
                return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
            }
            case -2117930783: {
                Base[] baseArray;
                if (this.referenceInformation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.referenceInformation;
                }
                return baseArray;
            }
            case 144518515: {
                Base[] baseArray;
                if (this.structure == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.structure;
                }
                return baseArray;
            }
            case 3059181: {
                return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
            }
            case 3373707: {
                return this.name == null ? new Base[]{} : this.name.toArray(new Base[this.name.size()]);
            }
            case 635625672: {
                return this.molecularWeight == null ? new Base[]{} : this.molecularWeight.toArray(new Base[this.molecularWeight.size()]);
            }
            case -261851592: {
                return this.relationship == null ? new Base[]{} : this.relationship.toArray(new Base[this.relationship.size()]);
            }
            case 1625275180: {
                Base[] baseArray;
                if (this.nucleicAcid == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.nucleicAcid;
                }
                return baseArray;
            }
            case -397514098: {
                Base[] baseArray;
                if (this.polymer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.polymer;
                }
                return baseArray;
            }
            case -309012605: {
                Base[] baseArray;
                if (this.protein == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.protein;
                }
                return baseArray;
            }
            case -1064442270: {
                Base[] baseArray;
                if (this.sourceMaterial == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.sourceMaterial;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -892481550: {
                this.status = this.castToCodeableConcept(value);
                return value;
            }
            case -1326197564: {
                this.domain = this.castToCodeableConcept(value);
                return value;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                return value;
            }
            case -896505829: {
                this.getSource().add(this.castToReference(value));
                return value;
            }
            case 950398559: {
                this.comment = this.castToString(value);
                return value;
            }
            case -1068650173: {
                this.getMoiety().add((SubstanceSpecificationMoietyComponent)value);
                return value;
            }
            case -993141291: {
                this.getProperty().add((SubstanceSpecificationPropertyComponent)value);
                return value;
            }
            case -2117930783: {
                this.referenceInformation = this.castToReference(value);
                return value;
            }
            case 144518515: {
                this.structure = (SubstanceSpecificationStructureComponent)value;
                return value;
            }
            case 3059181: {
                this.getCode().add((SubstanceSpecificationCodeComponent)value);
                return value;
            }
            case 3373707: {
                this.getName().add((SubstanceSpecificationNameComponent)value);
                return value;
            }
            case 635625672: {
                this.getMolecularWeight().add((SubstanceSpecificationStructureIsotopeMolecularWeightComponent)value);
                return value;
            }
            case -261851592: {
                this.getRelationship().add((SubstanceSpecificationRelationshipComponent)value);
                return value;
            }
            case 1625275180: {
                this.nucleicAcid = this.castToReference(value);
                return value;
            }
            case -397514098: {
                this.polymer = this.castToReference(value);
                return value;
            }
            case -309012605: {
                this.protein = this.castToReference(value);
                return value;
            }
            case -1064442270: {
                this.sourceMaterial = this.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("status")) {
            this.status = this.castToCodeableConcept(value);
        } else if (name.equals("domain")) {
            this.domain = this.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("source")) {
            this.getSource().add(this.castToReference(value));
        } else if (name.equals("comment")) {
            this.comment = this.castToString(value);
        } else if (name.equals("moiety")) {
            this.getMoiety().add((SubstanceSpecificationMoietyComponent)value);
        } else if (name.equals("property")) {
            this.getProperty().add((SubstanceSpecificationPropertyComponent)value);
        } else if (name.equals("referenceInformation")) {
            this.referenceInformation = this.castToReference(value);
        } else if (name.equals("structure")) {
            this.structure = (SubstanceSpecificationStructureComponent)value;
        } else if (name.equals(SP_CODE)) {
            this.getCode().add((SubstanceSpecificationCodeComponent)value);
        } else if (name.equals("name")) {
            this.getName().add((SubstanceSpecificationNameComponent)value);
        } else if (name.equals("molecularWeight")) {
            this.getMolecularWeight().add((SubstanceSpecificationStructureIsotopeMolecularWeightComponent)value);
        } else if (name.equals("relationship")) {
            this.getRelationship().add((SubstanceSpecificationRelationshipComponent)value);
        } else if (name.equals("nucleicAcid")) {
            this.nucleicAcid = this.castToReference(value);
        } else if (name.equals("polymer")) {
            this.polymer = this.castToReference(value);
        } else if (name.equals("protein")) {
            this.protein = this.castToReference(value);
        } else if (name.equals("sourceMaterial")) {
            this.sourceMaterial = this.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 3575610: {
                return this.getType();
            }
            case -892481550: {
                return this.getStatus();
            }
            case -1326197564: {
                return this.getDomain();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -896505829: {
                return this.addSource();
            }
            case 950398559: {
                return this.getCommentElement();
            }
            case -1068650173: {
                return this.addMoiety();
            }
            case -993141291: {
                return this.addProperty();
            }
            case -2117930783: {
                return this.getReferenceInformation();
            }
            case 144518515: {
                return this.getStructure();
            }
            case 3059181: {
                return this.addCode();
            }
            case 3373707: {
                return this.addName();
            }
            case 635625672: {
                return this.addMolecularWeight();
            }
            case -261851592: {
                return this.addRelationship();
            }
            case 1625275180: {
                return this.getNucleicAcid();
            }
            case -397514098: {
                return this.getPolymer();
            }
            case -309012605: {
                return this.getProtein();
            }
            case -1064442270: {
                return this.getSourceMaterial();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{"CodeableConcept"};
            }
            case -1326197564: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case -896505829: {
                return new String[]{"Reference"};
            }
            case 950398559: {
                return new String[]{"string"};
            }
            case -1068650173: {
                return new String[0];
            }
            case -993141291: {
                return new String[0];
            }
            case -2117930783: {
                return new String[]{"Reference"};
            }
            case 144518515: {
                return new String[0];
            }
            case 3059181: {
                return new String[0];
            }
            case 3373707: {
                return new String[0];
            }
            case 635625672: {
                return new String[]{"@SubstanceSpecification.structure.isotope.molecularWeight"};
            }
            case -261851592: {
                return new String[0];
            }
            case 1625275180: {
                return new String[]{"Reference"};
            }
            case -397514098: {
                return new String[]{"Reference"};
            }
            case -309012605: {
                return new String[]{"Reference"};
            }
            case -1064442270: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("status")) {
            this.status = new CodeableConcept();
            return this.status;
        }
        if (name.equals("domain")) {
            this.domain = new CodeableConcept();
            return this.domain;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.description");
        }
        if (name.equals("source")) {
            return this.addSource();
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.comment");
        }
        if (name.equals("moiety")) {
            return this.addMoiety();
        }
        if (name.equals("property")) {
            return this.addProperty();
        }
        if (name.equals("referenceInformation")) {
            this.referenceInformation = new Reference();
            return this.referenceInformation;
        }
        if (name.equals("structure")) {
            this.structure = new SubstanceSpecificationStructureComponent();
            return this.structure;
        }
        if (name.equals(SP_CODE)) {
            return this.addCode();
        }
        if (name.equals("name")) {
            return this.addName();
        }
        if (name.equals("molecularWeight")) {
            return this.addMolecularWeight();
        }
        if (name.equals("relationship")) {
            return this.addRelationship();
        }
        if (name.equals("nucleicAcid")) {
            this.nucleicAcid = new Reference();
            return this.nucleicAcid;
        }
        if (name.equals("polymer")) {
            this.polymer = new Reference();
            return this.polymer;
        }
        if (name.equals("protein")) {
            this.protein = new Reference();
            return this.protein;
        }
        if (name.equals("sourceMaterial")) {
            this.sourceMaterial = new Reference();
            return this.sourceMaterial;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SubstanceSpecification";
    }

    @Override
    public SubstanceSpecification copy() {
        SubstanceSpecification dst = new SubstanceSpecification();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SubstanceSpecification dst) {
        super.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.domain = this.domain == null ? null : this.domain.copy();
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.source != null) {
            dst.source = new ArrayList<Reference>();
            for (Reference reference : this.source) {
                dst.source.add(reference.copy());
            }
        }
        StringType stringType2 = dst.comment = this.comment == null ? null : this.comment.copy();
        if (this.moiety != null) {
            dst.moiety = new ArrayList<SubstanceSpecificationMoietyComponent>();
            for (SubstanceSpecificationMoietyComponent substanceSpecificationMoietyComponent : this.moiety) {
                dst.moiety.add(substanceSpecificationMoietyComponent.copy());
            }
        }
        if (this.property != null) {
            dst.property = new ArrayList<SubstanceSpecificationPropertyComponent>();
            for (SubstanceSpecificationPropertyComponent substanceSpecificationPropertyComponent : this.property) {
                dst.property.add(substanceSpecificationPropertyComponent.copy());
            }
        }
        dst.referenceInformation = this.referenceInformation == null ? null : this.referenceInformation.copy();
        SubstanceSpecificationStructureComponent substanceSpecificationStructureComponent = dst.structure = this.structure == null ? null : this.structure.copy();
        if (this.code != null) {
            dst.code = new ArrayList<SubstanceSpecificationCodeComponent>();
            for (SubstanceSpecificationCodeComponent substanceSpecificationCodeComponent : this.code) {
                dst.code.add(substanceSpecificationCodeComponent.copy());
            }
        }
        if (this.name != null) {
            dst.name = new ArrayList<SubstanceSpecificationNameComponent>();
            for (SubstanceSpecificationNameComponent substanceSpecificationNameComponent : this.name) {
                dst.name.add(substanceSpecificationNameComponent.copy());
            }
        }
        if (this.molecularWeight != null) {
            dst.molecularWeight = new ArrayList<SubstanceSpecificationStructureIsotopeMolecularWeightComponent>();
            for (SubstanceSpecificationStructureIsotopeMolecularWeightComponent substanceSpecificationStructureIsotopeMolecularWeightComponent : this.molecularWeight) {
                dst.molecularWeight.add(substanceSpecificationStructureIsotopeMolecularWeightComponent.copy());
            }
        }
        if (this.relationship != null) {
            dst.relationship = new ArrayList<SubstanceSpecificationRelationshipComponent>();
            for (SubstanceSpecificationRelationshipComponent substanceSpecificationRelationshipComponent : this.relationship) {
                dst.relationship.add(substanceSpecificationRelationshipComponent.copy());
            }
        }
        dst.nucleicAcid = this.nucleicAcid == null ? null : this.nucleicAcid.copy();
        dst.polymer = this.polymer == null ? null : this.polymer.copy();
        dst.protein = this.protein == null ? null : this.protein.copy();
        dst.sourceMaterial = this.sourceMaterial == null ? null : this.sourceMaterial.copy();
    }

    protected SubstanceSpecification typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstanceSpecification)) {
            return false;
        }
        SubstanceSpecification o = (SubstanceSpecification)other_;
        return SubstanceSpecification.compareDeep(this.identifier, o.identifier, true) && SubstanceSpecification.compareDeep(this.type, o.type, true) && SubstanceSpecification.compareDeep(this.status, o.status, true) && SubstanceSpecification.compareDeep(this.domain, o.domain, true) && SubstanceSpecification.compareDeep(this.description, o.description, true) && SubstanceSpecification.compareDeep(this.source, o.source, true) && SubstanceSpecification.compareDeep(this.comment, o.comment, true) && SubstanceSpecification.compareDeep(this.moiety, o.moiety, true) && SubstanceSpecification.compareDeep(this.property, o.property, true) && SubstanceSpecification.compareDeep(this.referenceInformation, o.referenceInformation, true) && SubstanceSpecification.compareDeep(this.structure, o.structure, true) && SubstanceSpecification.compareDeep(this.code, o.code, true) && SubstanceSpecification.compareDeep(this.name, o.name, true) && SubstanceSpecification.compareDeep(this.molecularWeight, o.molecularWeight, true) && SubstanceSpecification.compareDeep(this.relationship, o.relationship, true) && SubstanceSpecification.compareDeep(this.nucleicAcid, o.nucleicAcid, true) && SubstanceSpecification.compareDeep(this.polymer, o.polymer, true) && SubstanceSpecification.compareDeep(this.protein, o.protein, true) && SubstanceSpecification.compareDeep(this.sourceMaterial, o.sourceMaterial, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstanceSpecification)) {
            return false;
        }
        SubstanceSpecification o = (SubstanceSpecification)other_;
        return SubstanceSpecification.compareValues(this.description, o.description, true) && SubstanceSpecification.compareValues(this.comment, o.comment, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.status, this.domain, this.description, this.source, this.comment, this.moiety, this.property, this.referenceInformation, this.structure, this.code, this.name, this.molecularWeight, this.relationship, this.nucleicAcid, this.polymer, this.protein, this.sourceMaterial});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SubstanceSpecification;
    }

    @Block
    public static class SubstanceSpecificationRelationshipComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="substance", type={SubstanceSpecification.class, CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A pointer to another substance, as a resource or just a representational code", formalDefinition="A pointer to another substance, as a resource or just a representational code.")
        protected Type substance;
        @Child(name="relationship", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For example \"salt to parent\", \"active moiety\", \"starting material\"", formalDefinition="For example \"salt to parent\", \"active moiety\", \"starting material\".")
        protected CodeableConcept relationship;
        @Child(name="isDefining", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For example where an enzyme strongly bonds with a particular substance, this is a defining relationship for that enzyme, out of several possible substance relationships", formalDefinition="For example where an enzyme strongly bonds with a particular substance, this is a defining relationship for that enzyme, out of several possible substance relationships.")
        protected BooleanType isDefining;
        @Child(name="amount", type={Quantity.class, Range.class, Ratio.class, StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other", formalDefinition="A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.")
        protected Type amount;
        @Child(name="amountRatioLowLimit", type={Ratio.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For use when the numeric", formalDefinition="For use when the numeric.")
        protected Ratio amountRatioLowLimit;
        @Child(name="amountType", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="An operator for the amount, for example \"average\", \"approximately\", \"less than\"", formalDefinition="An operator for the amount, for example \"average\", \"approximately\", \"less than\".")
        protected CodeableConcept amountType;
        @Child(name="source", type={DocumentReference.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Supporting literature", formalDefinition="Supporting literature.")
        protected List<Reference> source;
        protected List<DocumentReference> sourceTarget;
        private static final long serialVersionUID = -1277419269L;

        public Type getSubstance() {
            return this.substance;
        }

        public Reference getSubstanceReference() throws FHIRException {
            if (this.substance == null) {
                this.substance = new Reference();
            }
            if (!(this.substance instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.substance.getClass().getName() + " was encountered");
            }
            return (Reference)this.substance;
        }

        public boolean hasSubstanceReference() {
            return this != null && this.substance instanceof Reference;
        }

        public CodeableConcept getSubstanceCodeableConcept() throws FHIRException {
            if (this.substance == null) {
                this.substance = new CodeableConcept();
            }
            if (!(this.substance instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.substance.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.substance;
        }

        public boolean hasSubstanceCodeableConcept() {
            return this != null && this.substance instanceof CodeableConcept;
        }

        public boolean hasSubstance() {
            return this.substance != null && !this.substance.isEmpty();
        }

        public SubstanceSpecificationRelationshipComponent setSubstance(Type value) {
            if (value != null && !(value instanceof Reference) && !(value instanceof CodeableConcept)) {
                throw new Error("Not the right type for SubstanceSpecification.relationship.substance[x]: " + value.fhirType());
            }
            this.substance = value;
            return this;
        }

        public CodeableConcept getRelationship() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationRelationshipComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new CodeableConcept();
                }
            }
            return this.relationship;
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public SubstanceSpecificationRelationshipComponent setRelationship(CodeableConcept value) {
            this.relationship = value;
            return this;
        }

        public BooleanType getIsDefiningElement() {
            if (this.isDefining == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationRelationshipComponent.isDefining");
                }
                if (Configuration.doAutoCreate()) {
                    this.isDefining = new BooleanType();
                }
            }
            return this.isDefining;
        }

        public boolean hasIsDefiningElement() {
            return this.isDefining != null && !this.isDefining.isEmpty();
        }

        public boolean hasIsDefining() {
            return this.isDefining != null && !this.isDefining.isEmpty();
        }

        public SubstanceSpecificationRelationshipComponent setIsDefiningElement(BooleanType value) {
            this.isDefining = value;
            return this;
        }

        public boolean getIsDefining() {
            return this.isDefining == null || this.isDefining.isEmpty() ? false : (Boolean)this.isDefining.getValue();
        }

        public SubstanceSpecificationRelationshipComponent setIsDefining(boolean value) {
            if (this.isDefining == null) {
                this.isDefining = new BooleanType();
            }
            this.isDefining.setValue((Object)value);
            return this;
        }

        public Type getAmount() {
            return this.amount;
        }

        public Quantity getAmountQuantity() throws FHIRException {
            if (this.amount == null) {
                this.amount = new Quantity();
            }
            if (!(this.amount instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (Quantity)this.amount;
        }

        public boolean hasAmountQuantity() {
            return this != null && this.amount instanceof Quantity;
        }

        public Range getAmountRange() throws FHIRException {
            if (this.amount == null) {
                this.amount = new Range();
            }
            if (!(this.amount instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (Range)this.amount;
        }

        public boolean hasAmountRange() {
            return this != null && this.amount instanceof Range;
        }

        public Ratio getAmountRatio() throws FHIRException {
            if (this.amount == null) {
                this.amount = new Ratio();
            }
            if (!(this.amount instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (Ratio)this.amount;
        }

        public boolean hasAmountRatio() {
            return this != null && this.amount instanceof Ratio;
        }

        public StringType getAmountStringType() throws FHIRException {
            if (this.amount == null) {
                this.amount = new StringType();
            }
            if (!(this.amount instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (StringType)this.amount;
        }

        public boolean hasAmountStringType() {
            return this != null && this.amount instanceof StringType;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public SubstanceSpecificationRelationshipComponent setAmount(Type value) {
            if (!(value == null || value instanceof Quantity || value instanceof Range || value instanceof Ratio || value instanceof StringType)) {
                throw new Error("Not the right type for SubstanceSpecification.relationship.amount[x]: " + value.fhirType());
            }
            this.amount = value;
            return this;
        }

        public Ratio getAmountRatioLowLimit() {
            if (this.amountRatioLowLimit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationRelationshipComponent.amountRatioLowLimit");
                }
                if (Configuration.doAutoCreate()) {
                    this.amountRatioLowLimit = new Ratio();
                }
            }
            return this.amountRatioLowLimit;
        }

        public boolean hasAmountRatioLowLimit() {
            return this.amountRatioLowLimit != null && !this.amountRatioLowLimit.isEmpty();
        }

        public SubstanceSpecificationRelationshipComponent setAmountRatioLowLimit(Ratio value) {
            this.amountRatioLowLimit = value;
            return this;
        }

        public CodeableConcept getAmountType() {
            if (this.amountType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationRelationshipComponent.amountType");
                }
                if (Configuration.doAutoCreate()) {
                    this.amountType = new CodeableConcept();
                }
            }
            return this.amountType;
        }

        public boolean hasAmountType() {
            return this.amountType != null && !this.amountType.isEmpty();
        }

        public SubstanceSpecificationRelationshipComponent setAmountType(CodeableConcept value) {
            this.amountType = value;
            return this;
        }

        public List<Reference> getSource() {
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            return this.source;
        }

        public SubstanceSpecificationRelationshipComponent setSource(List<Reference> theSource) {
            this.source = theSource;
            return this;
        }

        public boolean hasSource() {
            if (this.source == null) {
                return false;
            }
            for (Reference item : this.source) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSource() {
            Reference t = new Reference();
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return t;
        }

        public SubstanceSpecificationRelationshipComponent addSource(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return this;
        }

        public Reference getSourceFirstRep() {
            if (this.getSource().isEmpty()) {
                this.addSource();
            }
            return this.getSource().get(0);
        }

        @Deprecated
        public List<DocumentReference> getSourceTarget() {
            if (this.sourceTarget == null) {
                this.sourceTarget = new ArrayList<DocumentReference>();
            }
            return this.sourceTarget;
        }

        @Deprecated
        public DocumentReference addSourceTarget() {
            DocumentReference r = new DocumentReference();
            if (this.sourceTarget == null) {
                this.sourceTarget = new ArrayList<DocumentReference>();
            }
            this.sourceTarget.add(r);
            return r;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("substance[x]", "Reference(SubstanceSpecification)|CodeableConcept", "A pointer to another substance, as a resource or just a representational code.", 0, 1, this.substance));
            children.add(new Property("relationship", "CodeableConcept", "For example \"salt to parent\", \"active moiety\", \"starting material\".", 0, 1, this.relationship));
            children.add(new Property("isDefining", "boolean", "For example where an enzyme strongly bonds with a particular substance, this is a defining relationship for that enzyme, out of several possible substance relationships.", 0, 1, this.isDefining));
            children.add(new Property("amount[x]", "Quantity|Range|Ratio|string", "A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.", 0, 1, this.amount));
            children.add(new Property("amountRatioLowLimit", "Ratio", "For use when the numeric.", 0, 1, this.amountRatioLowLimit));
            children.add(new Property("amountType", "CodeableConcept", "An operator for the amount, for example \"average\", \"approximately\", \"less than\".", 0, 1, this.amountType));
            children.add(new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 2127194384: {
                    return new Property("substance[x]", "Reference(SubstanceSpecification)|CodeableConcept", "A pointer to another substance, as a resource or just a representational code.", 0, 1, this.substance);
                }
                case 530040176: {
                    return new Property("substance[x]", "Reference(SubstanceSpecification)|CodeableConcept", "A pointer to another substance, as a resource or just a representational code.", 0, 1, this.substance);
                }
                case 516208571: {
                    return new Property("substance[x]", "Reference(SubstanceSpecification)|CodeableConcept", "A pointer to another substance, as a resource or just a representational code.", 0, 1, this.substance);
                }
                case -1974119407: {
                    return new Property("substance[x]", "Reference(SubstanceSpecification)|CodeableConcept", "A pointer to another substance, as a resource or just a representational code.", 0, 1, this.substance);
                }
                case -261851592: {
                    return new Property("relationship", "CodeableConcept", "For example \"salt to parent\", \"active moiety\", \"starting material\".", 0, 1, this.relationship);
                }
                case -141812990: {
                    return new Property("isDefining", "boolean", "For example where an enzyme strongly bonds with a particular substance, this is a defining relationship for that enzyme, out of several possible substance relationships.", 0, 1, this.isDefining);
                }
                case 646780200: {
                    return new Property("amount[x]", "Quantity|Range|Ratio|string", "A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.", 0, 1, this.amount);
                }
                case -1413853096: {
                    return new Property("amount[x]", "Quantity|Range|Ratio|string", "A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.", 0, 1, this.amount);
                }
                case 1664303363: {
                    return new Property("amount[x]", "Quantity|Range|Ratio|string", "A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.", 0, 1, this.amount);
                }
                case -1223462971: {
                    return new Property("amount[x]", "Quantity|Range|Ratio|string", "A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.", 0, 1, this.amount);
                }
                case -1223457133: {
                    return new Property("amount[x]", "Quantity|Range|Ratio|string", "A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.", 0, 1, this.amount);
                }
                case 773651081: {
                    return new Property("amount[x]", "Quantity|Range|Ratio|string", "A numeric factor for the relationship, for instance to express that the salt of a substance has some percentage of the active substance in relation to some other.", 0, 1, this.amount);
                }
                case 2140623994: {
                    return new Property("amountRatioLowLimit", "Ratio", "For use when the numeric.", 0, 1, this.amountRatioLowLimit);
                }
                case -1424857166: {
                    return new Property("amountType", "CodeableConcept", "An operator for the amount, for example \"average\", \"approximately\", \"less than\".", 0, 1, this.amountType);
                }
                case -896505829: {
                    return new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    Base[] baseArray;
                    if (this.substance == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.substance;
                    }
                    return baseArray;
                }
                case -261851592: {
                    Base[] baseArray;
                    if (this.relationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.relationship;
                    }
                    return baseArray;
                }
                case -141812990: {
                    Base[] baseArray;
                    if (this.isDefining == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.isDefining;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.amount;
                    }
                    return baseArray;
                }
                case 2140623994: {
                    Base[] baseArray;
                    if (this.amountRatioLowLimit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.amountRatioLowLimit;
                    }
                    return baseArray;
                }
                case -1424857166: {
                    Base[] baseArray;
                    if (this.amountType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.amountType;
                    }
                    return baseArray;
                }
                case -896505829: {
                    return this.source == null ? new Base[]{} : this.source.toArray(new Base[this.source.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    this.substance = this.castToType(value);
                    return value;
                }
                case -261851592: {
                    this.relationship = this.castToCodeableConcept(value);
                    return value;
                }
                case -141812990: {
                    this.isDefining = this.castToBoolean(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToType(value);
                    return value;
                }
                case 2140623994: {
                    this.amountRatioLowLimit = this.castToRatio(value);
                    return value;
                }
                case -1424857166: {
                    this.amountType = this.castToCodeableConcept(value);
                    return value;
                }
                case -896505829: {
                    this.getSource().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("substance[x]")) {
                this.substance = this.castToType(value);
            } else if (name.equals("relationship")) {
                this.relationship = this.castToCodeableConcept(value);
            } else if (name.equals("isDefining")) {
                this.isDefining = this.castToBoolean(value);
            } else if (name.equals("amount[x]")) {
                this.amount = this.castToType(value);
            } else if (name.equals("amountRatioLowLimit")) {
                this.amountRatioLowLimit = this.castToRatio(value);
            } else if (name.equals("amountType")) {
                this.amountType = this.castToCodeableConcept(value);
            } else if (name.equals("source")) {
                this.getSource().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2127194384: {
                    return this.getSubstance();
                }
                case 530040176: {
                    return this.getSubstance();
                }
                case -261851592: {
                    return this.getRelationship();
                }
                case -141812990: {
                    return this.getIsDefiningElement();
                }
                case 646780200: {
                    return this.getAmount();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case 2140623994: {
                    return this.getAmountRatioLowLimit();
                }
                case -1424857166: {
                    return this.getAmountType();
                }
                case -896505829: {
                    return this.addSource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return new String[]{"Reference", "CodeableConcept"};
                }
                case -261851592: {
                    return new String[]{"CodeableConcept"};
                }
                case -141812990: {
                    return new String[]{"boolean"};
                }
                case -1413853096: {
                    return new String[]{"Quantity", "Range", "Ratio", "string"};
                }
                case 2140623994: {
                    return new String[]{"Ratio"};
                }
                case -1424857166: {
                    return new String[]{"CodeableConcept"};
                }
                case -896505829: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("substanceReference")) {
                this.substance = new Reference();
                return this.substance;
            }
            if (name.equals("substanceCodeableConcept")) {
                this.substance = new CodeableConcept();
                return this.substance;
            }
            if (name.equals("relationship")) {
                this.relationship = new CodeableConcept();
                return this.relationship;
            }
            if (name.equals("isDefining")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.isDefining");
            }
            if (name.equals("amountQuantity")) {
                this.amount = new Quantity();
                return this.amount;
            }
            if (name.equals("amountRange")) {
                this.amount = new Range();
                return this.amount;
            }
            if (name.equals("amountRatio")) {
                this.amount = new Ratio();
                return this.amount;
            }
            if (name.equals("amountString")) {
                this.amount = new StringType();
                return this.amount;
            }
            if (name.equals("amountRatioLowLimit")) {
                this.amountRatioLowLimit = new Ratio();
                return this.amountRatioLowLimit;
            }
            if (name.equals("amountType")) {
                this.amountType = new CodeableConcept();
                return this.amountType;
            }
            if (name.equals("source")) {
                return this.addSource();
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationRelationshipComponent copy() {
            SubstanceSpecificationRelationshipComponent dst = new SubstanceSpecificationRelationshipComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceSpecificationRelationshipComponent dst) {
            super.copyValues(dst);
            dst.substance = this.substance == null ? null : this.substance.copy();
            dst.relationship = this.relationship == null ? null : this.relationship.copy();
            dst.isDefining = this.isDefining == null ? null : this.isDefining.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.amountRatioLowLimit = this.amountRatioLowLimit == null ? null : this.amountRatioLowLimit.copy();
            CodeableConcept codeableConcept = dst.amountType = this.amountType == null ? null : this.amountType.copy();
            if (this.source != null) {
                dst.source = new ArrayList<Reference>();
                for (Reference i : this.source) {
                    dst.source.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationRelationshipComponent)) {
                return false;
            }
            SubstanceSpecificationRelationshipComponent o = (SubstanceSpecificationRelationshipComponent)other_;
            return SubstanceSpecificationRelationshipComponent.compareDeep(this.substance, o.substance, true) && SubstanceSpecificationRelationshipComponent.compareDeep(this.relationship, o.relationship, true) && SubstanceSpecificationRelationshipComponent.compareDeep(this.isDefining, o.isDefining, true) && SubstanceSpecificationRelationshipComponent.compareDeep(this.amount, o.amount, true) && SubstanceSpecificationRelationshipComponent.compareDeep(this.amountRatioLowLimit, o.amountRatioLowLimit, true) && SubstanceSpecificationRelationshipComponent.compareDeep(this.amountType, o.amountType, true) && SubstanceSpecificationRelationshipComponent.compareDeep(this.source, o.source, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationRelationshipComponent)) {
                return false;
            }
            SubstanceSpecificationRelationshipComponent o = (SubstanceSpecificationRelationshipComponent)other_;
            return SubstanceSpecificationRelationshipComponent.compareValues(this.isDefining, o.isDefining, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.substance, this.relationship, this.isDefining, this.amount, this.amountRatioLowLimit, this.amountType, this.source});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.relationship";
        }
    }

    @Block
    public static class SubstanceSpecificationNameOfficialComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="authority", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Which authority uses this official name", formalDefinition="Which authority uses this official name.")
        protected CodeableConcept authority;
        @Child(name="status", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The status of the official name", formalDefinition="The status of the official name.")
        protected CodeableConcept status;
        @Child(name="date", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Date of official name change", formalDefinition="Date of official name change.")
        protected DateTimeType date;
        private static final long serialVersionUID = -2040011008L;

        public CodeableConcept getAuthority() {
            if (this.authority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationNameOfficialComponent.authority");
                }
                if (Configuration.doAutoCreate()) {
                    this.authority = new CodeableConcept();
                }
            }
            return this.authority;
        }

        public boolean hasAuthority() {
            return this.authority != null && !this.authority.isEmpty();
        }

        public SubstanceSpecificationNameOfficialComponent setAuthority(CodeableConcept value) {
            this.authority = value;
            return this;
        }

        public CodeableConcept getStatus() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationNameOfficialComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new CodeableConcept();
                }
            }
            return this.status;
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public SubstanceSpecificationNameOfficialComponent setStatus(CodeableConcept value) {
            this.status = value;
            return this;
        }

        public DateTimeType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationNameOfficialComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateTimeType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public SubstanceSpecificationNameOfficialComponent setDateElement(DateTimeType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public SubstanceSpecificationNameOfficialComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("authority", "CodeableConcept", "Which authority uses this official name.", 0, 1, this.authority));
            children.add(new Property("status", "CodeableConcept", "The status of the official name.", 0, 1, this.status));
            children.add(new Property("date", "dateTime", "Date of official name change.", 0, 1, this.date));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1475610435: {
                    return new Property("authority", "CodeableConcept", "Which authority uses this official name.", 0, 1, this.authority);
                }
                case -892481550: {
                    return new Property("status", "CodeableConcept", "The status of the official name.", 0, 1, this.status);
                }
                case 3076014: {
                    return new Property("date", "dateTime", "Date of official name change.", 0, 1, this.date);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    Base[] baseArray;
                    if (this.authority == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.authority;
                    }
                    return baseArray;
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.status;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.date;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    this.authority = this.castToCodeableConcept(value);
                    return value;
                }
                case -892481550: {
                    this.status = this.castToCodeableConcept(value);
                    return value;
                }
                case 3076014: {
                    this.date = this.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("authority")) {
                this.authority = this.castToCodeableConcept(value);
            } else if (name.equals("status")) {
                this.status = this.castToCodeableConcept(value);
            } else if (name.equals("date")) {
                this.date = this.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    return this.getAuthority();
                }
                case -892481550: {
                    return this.getStatus();
                }
                case 3076014: {
                    return this.getDateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    return new String[]{"CodeableConcept"};
                }
                case -892481550: {
                    return new String[]{"CodeableConcept"};
                }
                case 3076014: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("authority")) {
                this.authority = new CodeableConcept();
                return this.authority;
            }
            if (name.equals("status")) {
                this.status = new CodeableConcept();
                return this.status;
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.date");
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationNameOfficialComponent copy() {
            SubstanceSpecificationNameOfficialComponent dst = new SubstanceSpecificationNameOfficialComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceSpecificationNameOfficialComponent dst) {
            super.copyValues(dst);
            dst.authority = this.authority == null ? null : this.authority.copy();
            dst.status = this.status == null ? null : this.status.copy();
            dst.date = this.date == null ? null : this.date.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationNameOfficialComponent)) {
                return false;
            }
            SubstanceSpecificationNameOfficialComponent o = (SubstanceSpecificationNameOfficialComponent)other_;
            return SubstanceSpecificationNameOfficialComponent.compareDeep(this.authority, o.authority, true) && SubstanceSpecificationNameOfficialComponent.compareDeep(this.status, o.status, true) && SubstanceSpecificationNameOfficialComponent.compareDeep(this.date, o.date, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationNameOfficialComponent)) {
                return false;
            }
            SubstanceSpecificationNameOfficialComponent o = (SubstanceSpecificationNameOfficialComponent)other_;
            return SubstanceSpecificationNameOfficialComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.authority, this.status, this.date});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.name.official";
        }
    }

    @Block
    public static class SubstanceSpecificationNameComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The actual name", formalDefinition="The actual name.")
        protected StringType name;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name type", formalDefinition="Name type.")
        protected CodeableConcept type;
        @Child(name="status", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The status of the name", formalDefinition="The status of the name.")
        protected CodeableConcept status;
        @Child(name="preferred", type={BooleanType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="If this is the preferred name for this substance", formalDefinition="If this is the preferred name for this substance.")
        protected BooleanType preferred;
        @Child(name="language", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Language of the name", formalDefinition="Language of the name.")
        protected List<CodeableConcept> language;
        @Child(name="domain", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The use context of this name for example if there is a different name a drug active ingredient as opposed to a food colour additive", formalDefinition="The use context of this name for example if there is a different name a drug active ingredient as opposed to a food colour additive.")
        protected List<CodeableConcept> domain;
        @Child(name="jurisdiction", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The jurisdiction where this name applies", formalDefinition="The jurisdiction where this name applies.")
        protected List<CodeableConcept> jurisdiction;
        @Child(name="synonym", type={SubstanceSpecificationNameComponent.class}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A synonym of this name", formalDefinition="A synonym of this name.")
        protected List<SubstanceSpecificationNameComponent> synonym;
        @Child(name="translation", type={SubstanceSpecificationNameComponent.class}, order=9, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A translation for this name", formalDefinition="A translation for this name.")
        protected List<SubstanceSpecificationNameComponent> translation;
        @Child(name="official", type={}, order=10, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Details of the official nature of this name", formalDefinition="Details of the official nature of this name.")
        protected List<SubstanceSpecificationNameOfficialComponent> official;
        @Child(name="source", type={DocumentReference.class}, order=11, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Supporting literature", formalDefinition="Supporting literature.")
        protected List<Reference> source;
        protected List<DocumentReference> sourceTarget;
        private static final long serialVersionUID = 1547107852L;

        public SubstanceSpecificationNameComponent() {
        }

        public SubstanceSpecificationNameComponent(StringType name) {
            this.name = name;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationNameComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public SubstanceSpecificationNameComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public SubstanceSpecificationNameComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationNameComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SubstanceSpecificationNameComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getStatus() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationNameComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new CodeableConcept();
                }
            }
            return this.status;
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public SubstanceSpecificationNameComponent setStatus(CodeableConcept value) {
            this.status = value;
            return this;
        }

        public BooleanType getPreferredElement() {
            if (this.preferred == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationNameComponent.preferred");
                }
                if (Configuration.doAutoCreate()) {
                    this.preferred = new BooleanType();
                }
            }
            return this.preferred;
        }

        public boolean hasPreferredElement() {
            return this.preferred != null && !this.preferred.isEmpty();
        }

        public boolean hasPreferred() {
            return this.preferred != null && !this.preferred.isEmpty();
        }

        public SubstanceSpecificationNameComponent setPreferredElement(BooleanType value) {
            this.preferred = value;
            return this;
        }

        public boolean getPreferred() {
            return this.preferred == null || this.preferred.isEmpty() ? false : (Boolean)this.preferred.getValue();
        }

        public SubstanceSpecificationNameComponent setPreferred(boolean value) {
            if (this.preferred == null) {
                this.preferred = new BooleanType();
            }
            this.preferred.setValue((Object)value);
            return this;
        }

        public List<CodeableConcept> getLanguage() {
            if (this.language == null) {
                this.language = new ArrayList<CodeableConcept>();
            }
            return this.language;
        }

        public SubstanceSpecificationNameComponent setLanguage(List<CodeableConcept> theLanguage) {
            this.language = theLanguage;
            return this;
        }

        public boolean hasLanguage() {
            if (this.language == null) {
                return false;
            }
            for (CodeableConcept item : this.language) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addLanguage() {
            CodeableConcept t = new CodeableConcept();
            if (this.language == null) {
                this.language = new ArrayList<CodeableConcept>();
            }
            this.language.add(t);
            return t;
        }

        public SubstanceSpecificationNameComponent addLanguage(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.language == null) {
                this.language = new ArrayList<CodeableConcept>();
            }
            this.language.add(t);
            return this;
        }

        public CodeableConcept getLanguageFirstRep() {
            if (this.getLanguage().isEmpty()) {
                this.addLanguage();
            }
            return this.getLanguage().get(0);
        }

        public List<CodeableConcept> getDomain() {
            if (this.domain == null) {
                this.domain = new ArrayList<CodeableConcept>();
            }
            return this.domain;
        }

        public SubstanceSpecificationNameComponent setDomain(List<CodeableConcept> theDomain) {
            this.domain = theDomain;
            return this;
        }

        public boolean hasDomain() {
            if (this.domain == null) {
                return false;
            }
            for (CodeableConcept item : this.domain) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addDomain() {
            CodeableConcept t = new CodeableConcept();
            if (this.domain == null) {
                this.domain = new ArrayList<CodeableConcept>();
            }
            this.domain.add(t);
            return t;
        }

        public SubstanceSpecificationNameComponent addDomain(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.domain == null) {
                this.domain = new ArrayList<CodeableConcept>();
            }
            this.domain.add(t);
            return this;
        }

        public CodeableConcept getDomainFirstRep() {
            if (this.getDomain().isEmpty()) {
                this.addDomain();
            }
            return this.getDomain().get(0);
        }

        public List<CodeableConcept> getJurisdiction() {
            if (this.jurisdiction == null) {
                this.jurisdiction = new ArrayList<CodeableConcept>();
            }
            return this.jurisdiction;
        }

        public SubstanceSpecificationNameComponent setJurisdiction(List<CodeableConcept> theJurisdiction) {
            this.jurisdiction = theJurisdiction;
            return this;
        }

        public boolean hasJurisdiction() {
            if (this.jurisdiction == null) {
                return false;
            }
            for (CodeableConcept item : this.jurisdiction) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addJurisdiction() {
            CodeableConcept t = new CodeableConcept();
            if (this.jurisdiction == null) {
                this.jurisdiction = new ArrayList<CodeableConcept>();
            }
            this.jurisdiction.add(t);
            return t;
        }

        public SubstanceSpecificationNameComponent addJurisdiction(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.jurisdiction == null) {
                this.jurisdiction = new ArrayList<CodeableConcept>();
            }
            this.jurisdiction.add(t);
            return this;
        }

        public CodeableConcept getJurisdictionFirstRep() {
            if (this.getJurisdiction().isEmpty()) {
                this.addJurisdiction();
            }
            return this.getJurisdiction().get(0);
        }

        public List<SubstanceSpecificationNameComponent> getSynonym() {
            if (this.synonym == null) {
                this.synonym = new ArrayList<SubstanceSpecificationNameComponent>();
            }
            return this.synonym;
        }

        public SubstanceSpecificationNameComponent setSynonym(List<SubstanceSpecificationNameComponent> theSynonym) {
            this.synonym = theSynonym;
            return this;
        }

        public boolean hasSynonym() {
            if (this.synonym == null) {
                return false;
            }
            for (SubstanceSpecificationNameComponent item : this.synonym) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstanceSpecificationNameComponent addSynonym() {
            SubstanceSpecificationNameComponent t = new SubstanceSpecificationNameComponent();
            if (this.synonym == null) {
                this.synonym = new ArrayList<SubstanceSpecificationNameComponent>();
            }
            this.synonym.add(t);
            return t;
        }

        public SubstanceSpecificationNameComponent addSynonym(SubstanceSpecificationNameComponent t) {
            if (t == null) {
                return this;
            }
            if (this.synonym == null) {
                this.synonym = new ArrayList<SubstanceSpecificationNameComponent>();
            }
            this.synonym.add(t);
            return this;
        }

        public SubstanceSpecificationNameComponent getSynonymFirstRep() {
            if (this.getSynonym().isEmpty()) {
                this.addSynonym();
            }
            return this.getSynonym().get(0);
        }

        public List<SubstanceSpecificationNameComponent> getTranslation() {
            if (this.translation == null) {
                this.translation = new ArrayList<SubstanceSpecificationNameComponent>();
            }
            return this.translation;
        }

        public SubstanceSpecificationNameComponent setTranslation(List<SubstanceSpecificationNameComponent> theTranslation) {
            this.translation = theTranslation;
            return this;
        }

        public boolean hasTranslation() {
            if (this.translation == null) {
                return false;
            }
            for (SubstanceSpecificationNameComponent item : this.translation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstanceSpecificationNameComponent addTranslation() {
            SubstanceSpecificationNameComponent t = new SubstanceSpecificationNameComponent();
            if (this.translation == null) {
                this.translation = new ArrayList<SubstanceSpecificationNameComponent>();
            }
            this.translation.add(t);
            return t;
        }

        public SubstanceSpecificationNameComponent addTranslation(SubstanceSpecificationNameComponent t) {
            if (t == null) {
                return this;
            }
            if (this.translation == null) {
                this.translation = new ArrayList<SubstanceSpecificationNameComponent>();
            }
            this.translation.add(t);
            return this;
        }

        public SubstanceSpecificationNameComponent getTranslationFirstRep() {
            if (this.getTranslation().isEmpty()) {
                this.addTranslation();
            }
            return this.getTranslation().get(0);
        }

        public List<SubstanceSpecificationNameOfficialComponent> getOfficial() {
            if (this.official == null) {
                this.official = new ArrayList<SubstanceSpecificationNameOfficialComponent>();
            }
            return this.official;
        }

        public SubstanceSpecificationNameComponent setOfficial(List<SubstanceSpecificationNameOfficialComponent> theOfficial) {
            this.official = theOfficial;
            return this;
        }

        public boolean hasOfficial() {
            if (this.official == null) {
                return false;
            }
            for (SubstanceSpecificationNameOfficialComponent item : this.official) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstanceSpecificationNameOfficialComponent addOfficial() {
            SubstanceSpecificationNameOfficialComponent t = new SubstanceSpecificationNameOfficialComponent();
            if (this.official == null) {
                this.official = new ArrayList<SubstanceSpecificationNameOfficialComponent>();
            }
            this.official.add(t);
            return t;
        }

        public SubstanceSpecificationNameComponent addOfficial(SubstanceSpecificationNameOfficialComponent t) {
            if (t == null) {
                return this;
            }
            if (this.official == null) {
                this.official = new ArrayList<SubstanceSpecificationNameOfficialComponent>();
            }
            this.official.add(t);
            return this;
        }

        public SubstanceSpecificationNameOfficialComponent getOfficialFirstRep() {
            if (this.getOfficial().isEmpty()) {
                this.addOfficial();
            }
            return this.getOfficial().get(0);
        }

        public List<Reference> getSource() {
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            return this.source;
        }

        public SubstanceSpecificationNameComponent setSource(List<Reference> theSource) {
            this.source = theSource;
            return this;
        }

        public boolean hasSource() {
            if (this.source == null) {
                return false;
            }
            for (Reference item : this.source) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSource() {
            Reference t = new Reference();
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return t;
        }

        public SubstanceSpecificationNameComponent addSource(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return this;
        }

        public Reference getSourceFirstRep() {
            if (this.getSource().isEmpty()) {
                this.addSource();
            }
            return this.getSource().get(0);
        }

        @Deprecated
        public List<DocumentReference> getSourceTarget() {
            if (this.sourceTarget == null) {
                this.sourceTarget = new ArrayList<DocumentReference>();
            }
            return this.sourceTarget;
        }

        @Deprecated
        public DocumentReference addSourceTarget() {
            DocumentReference r = new DocumentReference();
            if (this.sourceTarget == null) {
                this.sourceTarget = new ArrayList<DocumentReference>();
            }
            this.sourceTarget.add(r);
            return r;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "The actual name.", 0, 1, this.name));
            children.add(new Property("type", "CodeableConcept", "Name type.", 0, 1, this.type));
            children.add(new Property("status", "CodeableConcept", "The status of the name.", 0, 1, this.status));
            children.add(new Property("preferred", "boolean", "If this is the preferred name for this substance.", 0, 1, this.preferred));
            children.add(new Property("language", "CodeableConcept", "Language of the name.", 0, Integer.MAX_VALUE, this.language));
            children.add(new Property("domain", "CodeableConcept", "The use context of this name for example if there is a different name a drug active ingredient as opposed to a food colour additive.", 0, Integer.MAX_VALUE, this.domain));
            children.add(new Property("jurisdiction", "CodeableConcept", "The jurisdiction where this name applies.", 0, Integer.MAX_VALUE, this.jurisdiction));
            children.add(new Property("synonym", "@SubstanceSpecification.name", "A synonym of this name.", 0, Integer.MAX_VALUE, this.synonym));
            children.add(new Property("translation", "@SubstanceSpecification.name", "A translation for this name.", 0, Integer.MAX_VALUE, this.translation));
            children.add(new Property("official", "", "Details of the official nature of this name.", 0, Integer.MAX_VALUE, this.official));
            children.add(new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "The actual name.", 0, 1, this.name);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Name type.", 0, 1, this.type);
                }
                case -892481550: {
                    return new Property("status", "CodeableConcept", "The status of the name.", 0, 1, this.status);
                }
                case -1294005119: {
                    return new Property("preferred", "boolean", "If this is the preferred name for this substance.", 0, 1, this.preferred);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "Language of the name.", 0, Integer.MAX_VALUE, this.language);
                }
                case -1326197564: {
                    return new Property("domain", "CodeableConcept", "The use context of this name for example if there is a different name a drug active ingredient as opposed to a food colour additive.", 0, Integer.MAX_VALUE, this.domain);
                }
                case -507075711: {
                    return new Property("jurisdiction", "CodeableConcept", "The jurisdiction where this name applies.", 0, Integer.MAX_VALUE, this.jurisdiction);
                }
                case -1742128133: {
                    return new Property("synonym", "@SubstanceSpecification.name", "A synonym of this name.", 0, Integer.MAX_VALUE, this.synonym);
                }
                case -1840647503: {
                    return new Property("translation", "@SubstanceSpecification.name", "A translation for this name.", 0, Integer.MAX_VALUE, this.translation);
                }
                case -765289749: {
                    return new Property("official", "", "Details of the official nature of this name.", 0, Integer.MAX_VALUE, this.official);
                }
                case -896505829: {
                    return new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.status;
                    }
                    return baseArray;
                }
                case -1294005119: {
                    Base[] baseArray;
                    if (this.preferred == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.preferred;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    return this.language == null ? new Base[]{} : this.language.toArray(new Base[this.language.size()]);
                }
                case -1326197564: {
                    return this.domain == null ? new Base[]{} : this.domain.toArray(new Base[this.domain.size()]);
                }
                case -507075711: {
                    return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
                }
                case -1742128133: {
                    return this.synonym == null ? new Base[]{} : this.synonym.toArray(new Base[this.synonym.size()]);
                }
                case -1840647503: {
                    return this.translation == null ? new Base[]{} : this.translation.toArray(new Base[this.translation.size()]);
                }
                case -765289749: {
                    return this.official == null ? new Base[]{} : this.official.toArray(new Base[this.official.size()]);
                }
                case -896505829: {
                    return this.source == null ? new Base[]{} : this.source.toArray(new Base[this.source.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -892481550: {
                    this.status = this.castToCodeableConcept(value);
                    return value;
                }
                case -1294005119: {
                    this.preferred = this.castToBoolean(value);
                    return value;
                }
                case -1613589672: {
                    this.getLanguage().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1326197564: {
                    this.getDomain().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -507075711: {
                    this.getJurisdiction().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1742128133: {
                    this.getSynonym().add((SubstanceSpecificationNameComponent)value);
                    return value;
                }
                case -1840647503: {
                    this.getTranslation().add((SubstanceSpecificationNameComponent)value);
                    return value;
                }
                case -765289749: {
                    this.getOfficial().add((SubstanceSpecificationNameOfficialComponent)value);
                    return value;
                }
                case -896505829: {
                    this.getSource().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("status")) {
                this.status = this.castToCodeableConcept(value);
            } else if (name.equals("preferred")) {
                this.preferred = this.castToBoolean(value);
            } else if (name.equals("language")) {
                this.getLanguage().add(this.castToCodeableConcept(value));
            } else if (name.equals("domain")) {
                this.getDomain().add(this.castToCodeableConcept(value));
            } else if (name.equals("jurisdiction")) {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
            } else if (name.equals("synonym")) {
                this.getSynonym().add((SubstanceSpecificationNameComponent)value);
            } else if (name.equals("translation")) {
                this.getTranslation().add((SubstanceSpecificationNameComponent)value);
            } else if (name.equals("official")) {
                this.getOfficial().add((SubstanceSpecificationNameOfficialComponent)value);
            } else if (name.equals("source")) {
                this.getSource().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case -892481550: {
                    return this.getStatus();
                }
                case -1294005119: {
                    return this.getPreferredElement();
                }
                case -1613589672: {
                    return this.addLanguage();
                }
                case -1326197564: {
                    return this.addDomain();
                }
                case -507075711: {
                    return this.addJurisdiction();
                }
                case -1742128133: {
                    return this.addSynonym();
                }
                case -1840647503: {
                    return this.addTranslation();
                }
                case -765289749: {
                    return this.addOfficial();
                }
                case -896505829: {
                    return this.addSource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -892481550: {
                    return new String[]{"CodeableConcept"};
                }
                case -1294005119: {
                    return new String[]{"boolean"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
                case -1326197564: {
                    return new String[]{"CodeableConcept"};
                }
                case -507075711: {
                    return new String[]{"CodeableConcept"};
                }
                case -1742128133: {
                    return new String[]{"@SubstanceSpecification.name"};
                }
                case -1840647503: {
                    return new String[]{"@SubstanceSpecification.name"};
                }
                case -765289749: {
                    return new String[0];
                }
                case -896505829: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.name");
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("status")) {
                this.status = new CodeableConcept();
                return this.status;
            }
            if (name.equals("preferred")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.preferred");
            }
            if (name.equals("language")) {
                return this.addLanguage();
            }
            if (name.equals("domain")) {
                return this.addDomain();
            }
            if (name.equals("jurisdiction")) {
                return this.addJurisdiction();
            }
            if (name.equals("synonym")) {
                return this.addSynonym();
            }
            if (name.equals("translation")) {
                return this.addTranslation();
            }
            if (name.equals("official")) {
                return this.addOfficial();
            }
            if (name.equals("source")) {
                return this.addSource();
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationNameComponent copy() {
            SubstanceSpecificationNameComponent dst = new SubstanceSpecificationNameComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceSpecificationNameComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.status = this.status == null ? null : this.status.copy();
            BooleanType booleanType = dst.preferred = this.preferred == null ? null : this.preferred.copy();
            if (this.language != null) {
                dst.language = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.language) {
                    dst.language.add(codeableConcept.copy());
                }
            }
            if (this.domain != null) {
                dst.domain = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.domain) {
                    dst.domain.add(codeableConcept.copy());
                }
            }
            if (this.jurisdiction != null) {
                dst.jurisdiction = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.jurisdiction) {
                    dst.jurisdiction.add(codeableConcept.copy());
                }
            }
            if (this.synonym != null) {
                dst.synonym = new ArrayList<SubstanceSpecificationNameComponent>();
                for (SubstanceSpecificationNameComponent substanceSpecificationNameComponent : this.synonym) {
                    dst.synonym.add(substanceSpecificationNameComponent.copy());
                }
            }
            if (this.translation != null) {
                dst.translation = new ArrayList<SubstanceSpecificationNameComponent>();
                for (SubstanceSpecificationNameComponent substanceSpecificationNameComponent : this.translation) {
                    dst.translation.add(substanceSpecificationNameComponent.copy());
                }
            }
            if (this.official != null) {
                dst.official = new ArrayList<SubstanceSpecificationNameOfficialComponent>();
                for (SubstanceSpecificationNameOfficialComponent substanceSpecificationNameOfficialComponent : this.official) {
                    dst.official.add(substanceSpecificationNameOfficialComponent.copy());
                }
            }
            if (this.source != null) {
                dst.source = new ArrayList<Reference>();
                for (Reference reference : this.source) {
                    dst.source.add(reference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationNameComponent)) {
                return false;
            }
            SubstanceSpecificationNameComponent o = (SubstanceSpecificationNameComponent)other_;
            return SubstanceSpecificationNameComponent.compareDeep(this.name, o.name, true) && SubstanceSpecificationNameComponent.compareDeep(this.type, o.type, true) && SubstanceSpecificationNameComponent.compareDeep(this.status, o.status, true) && SubstanceSpecificationNameComponent.compareDeep(this.preferred, o.preferred, true) && SubstanceSpecificationNameComponent.compareDeep(this.language, o.language, true) && SubstanceSpecificationNameComponent.compareDeep(this.domain, o.domain, true) && SubstanceSpecificationNameComponent.compareDeep(this.jurisdiction, o.jurisdiction, true) && SubstanceSpecificationNameComponent.compareDeep(this.synonym, o.synonym, true) && SubstanceSpecificationNameComponent.compareDeep(this.translation, o.translation, true) && SubstanceSpecificationNameComponent.compareDeep(this.official, o.official, true) && SubstanceSpecificationNameComponent.compareDeep(this.source, o.source, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationNameComponent)) {
                return false;
            }
            SubstanceSpecificationNameComponent o = (SubstanceSpecificationNameComponent)other_;
            return SubstanceSpecificationNameComponent.compareValues(this.name, o.name, true) && SubstanceSpecificationNameComponent.compareValues(this.preferred, o.preferred, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.type, this.status, this.preferred, this.language, this.domain, this.jurisdiction, this.synonym, this.translation, this.official, this.source});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.name";
        }
    }

    @Block
    public static class SubstanceSpecificationCodeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The specific code", formalDefinition="The specific code.")
        protected CodeableConcept code;
        @Child(name="status", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Status of the code assignment", formalDefinition="Status of the code assignment.")
        protected CodeableConcept status;
        @Child(name="statusDate", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The date at which the code status is changed as part of the terminology maintenance", formalDefinition="The date at which the code status is changed as part of the terminology maintenance.")
        protected DateTimeType statusDate;
        @Child(name="comment", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Any comment can be provided in this field, if necessary", formalDefinition="Any comment can be provided in this field, if necessary.")
        protected StringType comment;
        @Child(name="source", type={DocumentReference.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Supporting literature", formalDefinition="Supporting literature.")
        protected List<Reference> source;
        protected List<DocumentReference> sourceTarget;
        private static final long serialVersionUID = -1629693460L;

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationCodeComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SubstanceSpecificationCodeComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public CodeableConcept getStatus() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationCodeComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new CodeableConcept();
                }
            }
            return this.status;
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public SubstanceSpecificationCodeComponent setStatus(CodeableConcept value) {
            this.status = value;
            return this;
        }

        public DateTimeType getStatusDateElement() {
            if (this.statusDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationCodeComponent.statusDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.statusDate = new DateTimeType();
                }
            }
            return this.statusDate;
        }

        public boolean hasStatusDateElement() {
            return this.statusDate != null && !this.statusDate.isEmpty();
        }

        public boolean hasStatusDate() {
            return this.statusDate != null && !this.statusDate.isEmpty();
        }

        public SubstanceSpecificationCodeComponent setStatusDateElement(DateTimeType value) {
            this.statusDate = value;
            return this;
        }

        public Date getStatusDate() {
            return this.statusDate == null ? null : (Date)this.statusDate.getValue();
        }

        public SubstanceSpecificationCodeComponent setStatusDate(Date value) {
            if (value == null) {
                this.statusDate = null;
            } else {
                if (this.statusDate == null) {
                    this.statusDate = new DateTimeType();
                }
                this.statusDate.setValue(value);
            }
            return this;
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationCodeComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public SubstanceSpecificationCodeComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public SubstanceSpecificationCodeComponent setComment(String value) {
            if (Utilities.noString((String)value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        public List<Reference> getSource() {
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            return this.source;
        }

        public SubstanceSpecificationCodeComponent setSource(List<Reference> theSource) {
            this.source = theSource;
            return this;
        }

        public boolean hasSource() {
            if (this.source == null) {
                return false;
            }
            for (Reference item : this.source) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSource() {
            Reference t = new Reference();
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return t;
        }

        public SubstanceSpecificationCodeComponent addSource(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return this;
        }

        public Reference getSourceFirstRep() {
            if (this.getSource().isEmpty()) {
                this.addSource();
            }
            return this.getSource().get(0);
        }

        @Deprecated
        public List<DocumentReference> getSourceTarget() {
            if (this.sourceTarget == null) {
                this.sourceTarget = new ArrayList<DocumentReference>();
            }
            return this.sourceTarget;
        }

        @Deprecated
        public DocumentReference addSourceTarget() {
            DocumentReference r = new DocumentReference();
            if (this.sourceTarget == null) {
                this.sourceTarget = new ArrayList<DocumentReference>();
            }
            this.sourceTarget.add(r);
            return r;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(SubstanceSpecification.SP_CODE, "CodeableConcept", "The specific code.", 0, 1, this.code));
            children.add(new Property("status", "CodeableConcept", "Status of the code assignment.", 0, 1, this.status));
            children.add(new Property("statusDate", "dateTime", "The date at which the code status is changed as part of the terminology maintenance.", 0, 1, this.statusDate));
            children.add(new Property("comment", "string", "Any comment can be provided in this field, if necessary.", 0, 1, this.comment));
            children.add(new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(SubstanceSpecification.SP_CODE, "CodeableConcept", "The specific code.", 0, 1, this.code);
                }
                case -892481550: {
                    return new Property("status", "CodeableConcept", "Status of the code assignment.", 0, 1, this.status);
                }
                case 247524032: {
                    return new Property("statusDate", "dateTime", "The date at which the code status is changed as part of the terminology maintenance.", 0, 1, this.statusDate);
                }
                case 950398559: {
                    return new Property("comment", "string", "Any comment can be provided in this field, if necessary.", 0, 1, this.comment);
                }
                case -896505829: {
                    return new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.status;
                    }
                    return baseArray;
                }
                case 247524032: {
                    Base[] baseArray;
                    if (this.statusDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.statusDate;
                    }
                    return baseArray;
                }
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.comment;
                    }
                    return baseArray;
                }
                case -896505829: {
                    return this.source == null ? new Base[]{} : this.source.toArray(new Base[this.source.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case -892481550: {
                    this.status = this.castToCodeableConcept(value);
                    return value;
                }
                case 247524032: {
                    this.statusDate = this.castToDateTime(value);
                    return value;
                }
                case 950398559: {
                    this.comment = this.castToString(value);
                    return value;
                }
                case -896505829: {
                    this.getSource().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(SubstanceSpecification.SP_CODE)) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("status")) {
                this.status = this.castToCodeableConcept(value);
            } else if (name.equals("statusDate")) {
                this.statusDate = this.castToDateTime(value);
            } else if (name.equals("comment")) {
                this.comment = this.castToString(value);
            } else if (name.equals("source")) {
                this.getSource().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -892481550: {
                    return this.getStatus();
                }
                case 247524032: {
                    return this.getStatusDateElement();
                }
                case 950398559: {
                    return this.getCommentElement();
                }
                case -896505829: {
                    return this.addSource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -892481550: {
                    return new String[]{"CodeableConcept"};
                }
                case 247524032: {
                    return new String[]{"dateTime"};
                }
                case 950398559: {
                    return new String[]{"string"};
                }
                case -896505829: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(SubstanceSpecification.SP_CODE)) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("status")) {
                this.status = new CodeableConcept();
                return this.status;
            }
            if (name.equals("statusDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.statusDate");
            }
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.comment");
            }
            if (name.equals("source")) {
                return this.addSource();
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationCodeComponent copy() {
            SubstanceSpecificationCodeComponent dst = new SubstanceSpecificationCodeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceSpecificationCodeComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.status = this.status == null ? null : this.status.copy();
            dst.statusDate = this.statusDate == null ? null : this.statusDate.copy();
            StringType stringType = dst.comment = this.comment == null ? null : this.comment.copy();
            if (this.source != null) {
                dst.source = new ArrayList<Reference>();
                for (Reference i : this.source) {
                    dst.source.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationCodeComponent)) {
                return false;
            }
            SubstanceSpecificationCodeComponent o = (SubstanceSpecificationCodeComponent)other_;
            return SubstanceSpecificationCodeComponent.compareDeep(this.code, o.code, true) && SubstanceSpecificationCodeComponent.compareDeep(this.status, o.status, true) && SubstanceSpecificationCodeComponent.compareDeep(this.statusDate, o.statusDate, true) && SubstanceSpecificationCodeComponent.compareDeep(this.comment, o.comment, true) && SubstanceSpecificationCodeComponent.compareDeep(this.source, o.source, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationCodeComponent)) {
                return false;
            }
            SubstanceSpecificationCodeComponent o = (SubstanceSpecificationCodeComponent)other_;
            return SubstanceSpecificationCodeComponent.compareValues(this.statusDate, o.statusDate, true) && SubstanceSpecificationCodeComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.status, this.statusDate, this.comment, this.source});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.code";
        }
    }

    @Block
    public static class SubstanceSpecificationStructureRepresentationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of structure (e.g. Full, Partial, Representative)", formalDefinition="The type of structure (e.g. Full, Partial, Representative).")
        protected CodeableConcept type;
        @Child(name="representation", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The structural representation as text string in a format e.g. InChI, SMILES, MOLFILE, CDX", formalDefinition="The structural representation as text string in a format e.g. InChI, SMILES, MOLFILE, CDX.")
        protected StringType representation;
        @Child(name="attachment", type={Attachment.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="An attached file with the structural representation", formalDefinition="An attached file with the structural representation.")
        protected Attachment attachment;
        private static final long serialVersionUID = 167954495L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureRepresentationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SubstanceSpecificationStructureRepresentationComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getRepresentationElement() {
            if (this.representation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureRepresentationComponent.representation");
                }
                if (Configuration.doAutoCreate()) {
                    this.representation = new StringType();
                }
            }
            return this.representation;
        }

        public boolean hasRepresentationElement() {
            return this.representation != null && !this.representation.isEmpty();
        }

        public boolean hasRepresentation() {
            return this.representation != null && !this.representation.isEmpty();
        }

        public SubstanceSpecificationStructureRepresentationComponent setRepresentationElement(StringType value) {
            this.representation = value;
            return this;
        }

        public String getRepresentation() {
            return this.representation == null ? null : (String)this.representation.getValue();
        }

        public SubstanceSpecificationStructureRepresentationComponent setRepresentation(String value) {
            if (Utilities.noString((String)value)) {
                this.representation = null;
            } else {
                if (this.representation == null) {
                    this.representation = new StringType();
                }
                this.representation.setValue(value);
            }
            return this;
        }

        public Attachment getAttachment() {
            if (this.attachment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureRepresentationComponent.attachment");
                }
                if (Configuration.doAutoCreate()) {
                    this.attachment = new Attachment();
                }
            }
            return this.attachment;
        }

        public boolean hasAttachment() {
            return this.attachment != null && !this.attachment.isEmpty();
        }

        public SubstanceSpecificationStructureRepresentationComponent setAttachment(Attachment value) {
            this.attachment = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The type of structure (e.g. Full, Partial, Representative).", 0, 1, this.type));
            children.add(new Property("representation", "string", "The structural representation as text string in a format e.g. InChI, SMILES, MOLFILE, CDX.", 0, 1, this.representation));
            children.add(new Property("attachment", "Attachment", "An attached file with the structural representation.", 0, 1, this.attachment));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type of structure (e.g. Full, Partial, Representative).", 0, 1, this.type);
                }
                case -671065907: {
                    return new Property("representation", "string", "The structural representation as text string in a format e.g. InChI, SMILES, MOLFILE, CDX.", 0, 1, this.representation);
                }
                case -1963501277: {
                    return new Property("attachment", "Attachment", "An attached file with the structural representation.", 0, 1, this.attachment);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -671065907: {
                    Base[] baseArray;
                    if (this.representation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.representation;
                    }
                    return baseArray;
                }
                case -1963501277: {
                    Base[] baseArray;
                    if (this.attachment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.attachment;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -671065907: {
                    this.representation = this.castToString(value);
                    return value;
                }
                case -1963501277: {
                    this.attachment = this.castToAttachment(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("representation")) {
                this.representation = this.castToString(value);
            } else if (name.equals("attachment")) {
                this.attachment = this.castToAttachment(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -671065907: {
                    return this.getRepresentationElement();
                }
                case -1963501277: {
                    return this.getAttachment();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -671065907: {
                    return new String[]{"string"};
                }
                case -1963501277: {
                    return new String[]{"Attachment"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("representation")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.representation");
            }
            if (name.equals("attachment")) {
                this.attachment = new Attachment();
                return this.attachment;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationStructureRepresentationComponent copy() {
            SubstanceSpecificationStructureRepresentationComponent dst = new SubstanceSpecificationStructureRepresentationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceSpecificationStructureRepresentationComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.representation = this.representation == null ? null : this.representation.copy();
            dst.attachment = this.attachment == null ? null : this.attachment.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationStructureRepresentationComponent)) {
                return false;
            }
            SubstanceSpecificationStructureRepresentationComponent o = (SubstanceSpecificationStructureRepresentationComponent)other_;
            return SubstanceSpecificationStructureRepresentationComponent.compareDeep(this.type, o.type, true) && SubstanceSpecificationStructureRepresentationComponent.compareDeep(this.representation, o.representation, true) && SubstanceSpecificationStructureRepresentationComponent.compareDeep(this.attachment, o.attachment, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationStructureRepresentationComponent)) {
                return false;
            }
            SubstanceSpecificationStructureRepresentationComponent o = (SubstanceSpecificationStructureRepresentationComponent)other_;
            return SubstanceSpecificationStructureRepresentationComponent.compareValues(this.representation, o.representation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.representation, this.attachment});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.structure.representation";
        }
    }

    @Block
    public static class SubstanceSpecificationStructureIsotopeMolecularWeightComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="method", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The method by which the molecular weight was determined", formalDefinition="The method by which the molecular weight was determined.")
        protected CodeableConcept method;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of molecular weight such as exact, average (also known as. number average), weight average", formalDefinition="Type of molecular weight such as exact, average (also known as. number average), weight average.")
        protected CodeableConcept type;
        @Child(name="amount", type={Quantity.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field", formalDefinition="Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.")
        protected Quantity amount;
        private static final long serialVersionUID = 805939780L;

        public CodeableConcept getMethod() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureIsotopeMolecularWeightComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new CodeableConcept();
                }
            }
            return this.method;
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public SubstanceSpecificationStructureIsotopeMolecularWeightComponent setMethod(CodeableConcept value) {
            this.method = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureIsotopeMolecularWeightComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SubstanceSpecificationStructureIsotopeMolecularWeightComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Quantity getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureIsotopeMolecularWeightComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Quantity();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public SubstanceSpecificationStructureIsotopeMolecularWeightComponent setAmount(Quantity value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("method", "CodeableConcept", "The method by which the molecular weight was determined.", 0, 1, this.method));
            children.add(new Property("type", "CodeableConcept", "Type of molecular weight such as exact, average (also known as. number average), weight average.", 0, 1, this.type));
            children.add(new Property("amount", "Quantity", "Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1077554975: {
                    return new Property("method", "CodeableConcept", "The method by which the molecular weight was determined.", 0, 1, this.method);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of molecular weight such as exact, average (also known as. number average), weight average.", 0, 1, this.type);
                }
                case -1413853096: {
                    return new Property("amount", "Quantity", "Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    Base[] baseArray;
                    if (this.method == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.method;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    this.method = this.castToCodeableConcept(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToQuantity(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("method")) {
                this.method = this.castToCodeableConcept(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToQuantity(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    return this.getMethod();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    return new String[]{"CodeableConcept"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1413853096: {
                    return new String[]{"Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("method")) {
                this.method = new CodeableConcept();
                return this.method;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("amount")) {
                this.amount = new Quantity();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationStructureIsotopeMolecularWeightComponent copy() {
            SubstanceSpecificationStructureIsotopeMolecularWeightComponent dst = new SubstanceSpecificationStructureIsotopeMolecularWeightComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceSpecificationStructureIsotopeMolecularWeightComponent dst) {
            super.copyValues(dst);
            dst.method = this.method == null ? null : this.method.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationStructureIsotopeMolecularWeightComponent)) {
                return false;
            }
            SubstanceSpecificationStructureIsotopeMolecularWeightComponent o = (SubstanceSpecificationStructureIsotopeMolecularWeightComponent)other_;
            return SubstanceSpecificationStructureIsotopeMolecularWeightComponent.compareDeep(this.method, o.method, true) && SubstanceSpecificationStructureIsotopeMolecularWeightComponent.compareDeep(this.type, o.type, true) && SubstanceSpecificationStructureIsotopeMolecularWeightComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationStructureIsotopeMolecularWeightComponent)) {
                return false;
            }
            SubstanceSpecificationStructureIsotopeMolecularWeightComponent o = (SubstanceSpecificationStructureIsotopeMolecularWeightComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.method, this.type, this.amount});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.structure.isotope.molecularWeight";
        }
    }

    @Block
    public static class SubstanceSpecificationStructureIsotopeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Substance identifier for each non-natural or radioisotope", formalDefinition="Substance identifier for each non-natural or radioisotope.")
        protected Identifier identifier;
        @Child(name="name", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Substance name for each non-natural or radioisotope", formalDefinition="Substance name for each non-natural or radioisotope.")
        protected CodeableConcept name;
        @Child(name="substitution", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of isotopic substitution present in a single substance", formalDefinition="The type of isotopic substitution present in a single substance.")
        protected CodeableConcept substitution;
        @Child(name="halfLife", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Half life - for a non-natural nuclide", formalDefinition="Half life - for a non-natural nuclide.")
        protected Quantity halfLife;
        @Child(name="molecularWeight", type={}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The molecular weight or weight range (for proteins, polymers or nucleic acids)", formalDefinition="The molecular weight or weight range (for proteins, polymers or nucleic acids).")
        protected SubstanceSpecificationStructureIsotopeMolecularWeightComponent molecularWeight;
        private static final long serialVersionUID = -531167114L;

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureIsotopeComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public SubstanceSpecificationStructureIsotopeComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public CodeableConcept getName() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureIsotopeComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new CodeableConcept();
                }
            }
            return this.name;
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public SubstanceSpecificationStructureIsotopeComponent setName(CodeableConcept value) {
            this.name = value;
            return this;
        }

        public CodeableConcept getSubstitution() {
            if (this.substitution == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureIsotopeComponent.substitution");
                }
                if (Configuration.doAutoCreate()) {
                    this.substitution = new CodeableConcept();
                }
            }
            return this.substitution;
        }

        public boolean hasSubstitution() {
            return this.substitution != null && !this.substitution.isEmpty();
        }

        public SubstanceSpecificationStructureIsotopeComponent setSubstitution(CodeableConcept value) {
            this.substitution = value;
            return this;
        }

        public Quantity getHalfLife() {
            if (this.halfLife == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureIsotopeComponent.halfLife");
                }
                if (Configuration.doAutoCreate()) {
                    this.halfLife = new Quantity();
                }
            }
            return this.halfLife;
        }

        public boolean hasHalfLife() {
            return this.halfLife != null && !this.halfLife.isEmpty();
        }

        public SubstanceSpecificationStructureIsotopeComponent setHalfLife(Quantity value) {
            this.halfLife = value;
            return this;
        }

        public SubstanceSpecificationStructureIsotopeMolecularWeightComponent getMolecularWeight() {
            if (this.molecularWeight == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureIsotopeComponent.molecularWeight");
                }
                if (Configuration.doAutoCreate()) {
                    this.molecularWeight = new SubstanceSpecificationStructureIsotopeMolecularWeightComponent();
                }
            }
            return this.molecularWeight;
        }

        public boolean hasMolecularWeight() {
            return this.molecularWeight != null && !this.molecularWeight.isEmpty();
        }

        public SubstanceSpecificationStructureIsotopeComponent setMolecularWeight(SubstanceSpecificationStructureIsotopeMolecularWeightComponent value) {
            this.molecularWeight = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("identifier", "Identifier", "Substance identifier for each non-natural or radioisotope.", 0, 1, this.identifier));
            children.add(new Property("name", "CodeableConcept", "Substance name for each non-natural or radioisotope.", 0, 1, this.name));
            children.add(new Property("substitution", "CodeableConcept", "The type of isotopic substitution present in a single substance.", 0, 1, this.substitution));
            children.add(new Property("halfLife", "Quantity", "Half life - for a non-natural nuclide.", 0, 1, this.halfLife));
            children.add(new Property("molecularWeight", "", "The molecular weight or weight range (for proteins, polymers or nucleic acids).", 0, 1, this.molecularWeight));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property("identifier", "Identifier", "Substance identifier for each non-natural or radioisotope.", 0, 1, this.identifier);
                }
                case 3373707: {
                    return new Property("name", "CodeableConcept", "Substance name for each non-natural or radioisotope.", 0, 1, this.name);
                }
                case 826147581: {
                    return new Property("substitution", "CodeableConcept", "The type of isotopic substitution present in a single substance.", 0, 1, this.substitution);
                }
                case -54292017: {
                    return new Property("halfLife", "Quantity", "Half life - for a non-natural nuclide.", 0, 1, this.halfLife);
                }
                case 635625672: {
                    return new Property("molecularWeight", "", "The molecular weight or weight range (for proteins, polymers or nucleic acids).", 0, 1, this.molecularWeight);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
                case 826147581: {
                    Base[] baseArray;
                    if (this.substitution == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.substitution;
                    }
                    return baseArray;
                }
                case -54292017: {
                    Base[] baseArray;
                    if (this.halfLife == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.halfLife;
                    }
                    return baseArray;
                }
                case 635625672: {
                    Base[] baseArray;
                    if (this.molecularWeight == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.molecularWeight;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToCodeableConcept(value);
                    return value;
                }
                case 826147581: {
                    this.substitution = this.castToCodeableConcept(value);
                    return value;
                }
                case -54292017: {
                    this.halfLife = this.castToQuantity(value);
                    return value;
                }
                case 635625672: {
                    this.molecularWeight = (SubstanceSpecificationStructureIsotopeMolecularWeightComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("identifier")) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("name")) {
                this.name = this.castToCodeableConcept(value);
            } else if (name.equals("substitution")) {
                this.substitution = this.castToCodeableConcept(value);
            } else if (name.equals("halfLife")) {
                this.halfLife = this.castToQuantity(value);
            } else if (name.equals("molecularWeight")) {
                this.molecularWeight = (SubstanceSpecificationStructureIsotopeMolecularWeightComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 3373707: {
                    return this.getName();
                }
                case 826147581: {
                    return this.getSubstitution();
                }
                case -54292017: {
                    return this.getHalfLife();
                }
                case 635625672: {
                    return this.getMolecularWeight();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3373707: {
                    return new String[]{"CodeableConcept"};
                }
                case 826147581: {
                    return new String[]{"CodeableConcept"};
                }
                case -54292017: {
                    return new String[]{"Quantity"};
                }
                case 635625672: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("identifier")) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("name")) {
                this.name = new CodeableConcept();
                return this.name;
            }
            if (name.equals("substitution")) {
                this.substitution = new CodeableConcept();
                return this.substitution;
            }
            if (name.equals("halfLife")) {
                this.halfLife = new Quantity();
                return this.halfLife;
            }
            if (name.equals("molecularWeight")) {
                this.molecularWeight = new SubstanceSpecificationStructureIsotopeMolecularWeightComponent();
                return this.molecularWeight;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationStructureIsotopeComponent copy() {
            SubstanceSpecificationStructureIsotopeComponent dst = new SubstanceSpecificationStructureIsotopeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceSpecificationStructureIsotopeComponent dst) {
            super.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.substitution = this.substitution == null ? null : this.substitution.copy();
            dst.halfLife = this.halfLife == null ? null : this.halfLife.copy();
            dst.molecularWeight = this.molecularWeight == null ? null : this.molecularWeight.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationStructureIsotopeComponent)) {
                return false;
            }
            SubstanceSpecificationStructureIsotopeComponent o = (SubstanceSpecificationStructureIsotopeComponent)other_;
            return SubstanceSpecificationStructureIsotopeComponent.compareDeep(this.identifier, o.identifier, true) && SubstanceSpecificationStructureIsotopeComponent.compareDeep(this.name, o.name, true) && SubstanceSpecificationStructureIsotopeComponent.compareDeep(this.substitution, o.substitution, true) && SubstanceSpecificationStructureIsotopeComponent.compareDeep(this.halfLife, o.halfLife, true) && SubstanceSpecificationStructureIsotopeComponent.compareDeep(this.molecularWeight, o.molecularWeight, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationStructureIsotopeComponent)) {
                return false;
            }
            SubstanceSpecificationStructureIsotopeComponent o = (SubstanceSpecificationStructureIsotopeComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.identifier, this.name, this.substitution, this.halfLife, this.molecularWeight});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.structure.isotope";
        }
    }

    @Block
    public static class SubstanceSpecificationStructureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="stereochemistry", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Stereochemistry type", formalDefinition="Stereochemistry type.")
        protected CodeableConcept stereochemistry;
        @Child(name="opticalActivity", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Optical activity type", formalDefinition="Optical activity type.")
        protected CodeableConcept opticalActivity;
        @Child(name="molecularFormula", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Molecular formula", formalDefinition="Molecular formula.")
        protected StringType molecularFormula;
        @Child(name="molecularFormulaByMoiety", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specified per moiety according to the Hill system, i.e. first C, then H, then alphabetical, each moiety separated by a dot", formalDefinition="Specified per moiety according to the Hill system, i.e. first C, then H, then alphabetical, each moiety separated by a dot.")
        protected StringType molecularFormulaByMoiety;
        @Child(name="isotope", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Applicable for single substances that contain a radionuclide or a non-natural isotopic ratio", formalDefinition="Applicable for single substances that contain a radionuclide or a non-natural isotopic ratio.")
        protected List<SubstanceSpecificationStructureIsotopeComponent> isotope;
        @Child(name="molecularWeight", type={SubstanceSpecificationStructureIsotopeMolecularWeightComponent.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The molecular weight or weight range (for proteins, polymers or nucleic acids)", formalDefinition="The molecular weight or weight range (for proteins, polymers or nucleic acids).")
        protected SubstanceSpecificationStructureIsotopeMolecularWeightComponent molecularWeight;
        @Child(name="source", type={DocumentReference.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Supporting literature", formalDefinition="Supporting literature.")
        protected List<Reference> source;
        protected List<DocumentReference> sourceTarget;
        @Child(name="representation", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Molecular structural representation", formalDefinition="Molecular structural representation.")
        protected List<SubstanceSpecificationStructureRepresentationComponent> representation;
        private static final long serialVersionUID = -851521497L;

        public CodeableConcept getStereochemistry() {
            if (this.stereochemistry == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureComponent.stereochemistry");
                }
                if (Configuration.doAutoCreate()) {
                    this.stereochemistry = new CodeableConcept();
                }
            }
            return this.stereochemistry;
        }

        public boolean hasStereochemistry() {
            return this.stereochemistry != null && !this.stereochemistry.isEmpty();
        }

        public SubstanceSpecificationStructureComponent setStereochemistry(CodeableConcept value) {
            this.stereochemistry = value;
            return this;
        }

        public CodeableConcept getOpticalActivity() {
            if (this.opticalActivity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureComponent.opticalActivity");
                }
                if (Configuration.doAutoCreate()) {
                    this.opticalActivity = new CodeableConcept();
                }
            }
            return this.opticalActivity;
        }

        public boolean hasOpticalActivity() {
            return this.opticalActivity != null && !this.opticalActivity.isEmpty();
        }

        public SubstanceSpecificationStructureComponent setOpticalActivity(CodeableConcept value) {
            this.opticalActivity = value;
            return this;
        }

        public StringType getMolecularFormulaElement() {
            if (this.molecularFormula == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureComponent.molecularFormula");
                }
                if (Configuration.doAutoCreate()) {
                    this.molecularFormula = new StringType();
                }
            }
            return this.molecularFormula;
        }

        public boolean hasMolecularFormulaElement() {
            return this.molecularFormula != null && !this.molecularFormula.isEmpty();
        }

        public boolean hasMolecularFormula() {
            return this.molecularFormula != null && !this.molecularFormula.isEmpty();
        }

        public SubstanceSpecificationStructureComponent setMolecularFormulaElement(StringType value) {
            this.molecularFormula = value;
            return this;
        }

        public String getMolecularFormula() {
            return this.molecularFormula == null ? null : (String)this.molecularFormula.getValue();
        }

        public SubstanceSpecificationStructureComponent setMolecularFormula(String value) {
            if (Utilities.noString((String)value)) {
                this.molecularFormula = null;
            } else {
                if (this.molecularFormula == null) {
                    this.molecularFormula = new StringType();
                }
                this.molecularFormula.setValue(value);
            }
            return this;
        }

        public StringType getMolecularFormulaByMoietyElement() {
            if (this.molecularFormulaByMoiety == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureComponent.molecularFormulaByMoiety");
                }
                if (Configuration.doAutoCreate()) {
                    this.molecularFormulaByMoiety = new StringType();
                }
            }
            return this.molecularFormulaByMoiety;
        }

        public boolean hasMolecularFormulaByMoietyElement() {
            return this.molecularFormulaByMoiety != null && !this.molecularFormulaByMoiety.isEmpty();
        }

        public boolean hasMolecularFormulaByMoiety() {
            return this.molecularFormulaByMoiety != null && !this.molecularFormulaByMoiety.isEmpty();
        }

        public SubstanceSpecificationStructureComponent setMolecularFormulaByMoietyElement(StringType value) {
            this.molecularFormulaByMoiety = value;
            return this;
        }

        public String getMolecularFormulaByMoiety() {
            return this.molecularFormulaByMoiety == null ? null : (String)this.molecularFormulaByMoiety.getValue();
        }

        public SubstanceSpecificationStructureComponent setMolecularFormulaByMoiety(String value) {
            if (Utilities.noString((String)value)) {
                this.molecularFormulaByMoiety = null;
            } else {
                if (this.molecularFormulaByMoiety == null) {
                    this.molecularFormulaByMoiety = new StringType();
                }
                this.molecularFormulaByMoiety.setValue(value);
            }
            return this;
        }

        public List<SubstanceSpecificationStructureIsotopeComponent> getIsotope() {
            if (this.isotope == null) {
                this.isotope = new ArrayList<SubstanceSpecificationStructureIsotopeComponent>();
            }
            return this.isotope;
        }

        public SubstanceSpecificationStructureComponent setIsotope(List<SubstanceSpecificationStructureIsotopeComponent> theIsotope) {
            this.isotope = theIsotope;
            return this;
        }

        public boolean hasIsotope() {
            if (this.isotope == null) {
                return false;
            }
            for (SubstanceSpecificationStructureIsotopeComponent item : this.isotope) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstanceSpecificationStructureIsotopeComponent addIsotope() {
            SubstanceSpecificationStructureIsotopeComponent t = new SubstanceSpecificationStructureIsotopeComponent();
            if (this.isotope == null) {
                this.isotope = new ArrayList<SubstanceSpecificationStructureIsotopeComponent>();
            }
            this.isotope.add(t);
            return t;
        }

        public SubstanceSpecificationStructureComponent addIsotope(SubstanceSpecificationStructureIsotopeComponent t) {
            if (t == null) {
                return this;
            }
            if (this.isotope == null) {
                this.isotope = new ArrayList<SubstanceSpecificationStructureIsotopeComponent>();
            }
            this.isotope.add(t);
            return this;
        }

        public SubstanceSpecificationStructureIsotopeComponent getIsotopeFirstRep() {
            if (this.getIsotope().isEmpty()) {
                this.addIsotope();
            }
            return this.getIsotope().get(0);
        }

        public SubstanceSpecificationStructureIsotopeMolecularWeightComponent getMolecularWeight() {
            if (this.molecularWeight == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureComponent.molecularWeight");
                }
                if (Configuration.doAutoCreate()) {
                    this.molecularWeight = new SubstanceSpecificationStructureIsotopeMolecularWeightComponent();
                }
            }
            return this.molecularWeight;
        }

        public boolean hasMolecularWeight() {
            return this.molecularWeight != null && !this.molecularWeight.isEmpty();
        }

        public SubstanceSpecificationStructureComponent setMolecularWeight(SubstanceSpecificationStructureIsotopeMolecularWeightComponent value) {
            this.molecularWeight = value;
            return this;
        }

        public List<Reference> getSource() {
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            return this.source;
        }

        public SubstanceSpecificationStructureComponent setSource(List<Reference> theSource) {
            this.source = theSource;
            return this;
        }

        public boolean hasSource() {
            if (this.source == null) {
                return false;
            }
            for (Reference item : this.source) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSource() {
            Reference t = new Reference();
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return t;
        }

        public SubstanceSpecificationStructureComponent addSource(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.source == null) {
                this.source = new ArrayList<Reference>();
            }
            this.source.add(t);
            return this;
        }

        public Reference getSourceFirstRep() {
            if (this.getSource().isEmpty()) {
                this.addSource();
            }
            return this.getSource().get(0);
        }

        @Deprecated
        public List<DocumentReference> getSourceTarget() {
            if (this.sourceTarget == null) {
                this.sourceTarget = new ArrayList<DocumentReference>();
            }
            return this.sourceTarget;
        }

        @Deprecated
        public DocumentReference addSourceTarget() {
            DocumentReference r = new DocumentReference();
            if (this.sourceTarget == null) {
                this.sourceTarget = new ArrayList<DocumentReference>();
            }
            this.sourceTarget.add(r);
            return r;
        }

        public List<SubstanceSpecificationStructureRepresentationComponent> getRepresentation() {
            if (this.representation == null) {
                this.representation = new ArrayList<SubstanceSpecificationStructureRepresentationComponent>();
            }
            return this.representation;
        }

        public SubstanceSpecificationStructureComponent setRepresentation(List<SubstanceSpecificationStructureRepresentationComponent> theRepresentation) {
            this.representation = theRepresentation;
            return this;
        }

        public boolean hasRepresentation() {
            if (this.representation == null) {
                return false;
            }
            for (SubstanceSpecificationStructureRepresentationComponent item : this.representation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstanceSpecificationStructureRepresentationComponent addRepresentation() {
            SubstanceSpecificationStructureRepresentationComponent t = new SubstanceSpecificationStructureRepresentationComponent();
            if (this.representation == null) {
                this.representation = new ArrayList<SubstanceSpecificationStructureRepresentationComponent>();
            }
            this.representation.add(t);
            return t;
        }

        public SubstanceSpecificationStructureComponent addRepresentation(SubstanceSpecificationStructureRepresentationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.representation == null) {
                this.representation = new ArrayList<SubstanceSpecificationStructureRepresentationComponent>();
            }
            this.representation.add(t);
            return this;
        }

        public SubstanceSpecificationStructureRepresentationComponent getRepresentationFirstRep() {
            if (this.getRepresentation().isEmpty()) {
                this.addRepresentation();
            }
            return this.getRepresentation().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("stereochemistry", "CodeableConcept", "Stereochemistry type.", 0, 1, this.stereochemistry));
            children.add(new Property("opticalActivity", "CodeableConcept", "Optical activity type.", 0, 1, this.opticalActivity));
            children.add(new Property("molecularFormula", "string", "Molecular formula.", 0, 1, this.molecularFormula));
            children.add(new Property("molecularFormulaByMoiety", "string", "Specified per moiety according to the Hill system, i.e. first C, then H, then alphabetical, each moiety separated by a dot.", 0, 1, this.molecularFormulaByMoiety));
            children.add(new Property("isotope", "", "Applicable for single substances that contain a radionuclide or a non-natural isotopic ratio.", 0, Integer.MAX_VALUE, this.isotope));
            children.add(new Property("molecularWeight", "@SubstanceSpecification.structure.isotope.molecularWeight", "The molecular weight or weight range (for proteins, polymers or nucleic acids).", 0, 1, this.molecularWeight));
            children.add(new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source));
            children.add(new Property("representation", "", "Molecular structural representation.", 0, Integer.MAX_VALUE, this.representation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 263475116: {
                    return new Property("stereochemistry", "CodeableConcept", "Stereochemistry type.", 0, 1, this.stereochemistry);
                }
                case 1420900135: {
                    return new Property("opticalActivity", "CodeableConcept", "Optical activity type.", 0, 1, this.opticalActivity);
                }
                case 616660246: {
                    return new Property("molecularFormula", "string", "Molecular formula.", 0, 1, this.molecularFormula);
                }
                case 1315452848: {
                    return new Property("molecularFormulaByMoiety", "string", "Specified per moiety according to the Hill system, i.e. first C, then H, then alphabetical, each moiety separated by a dot.", 0, 1, this.molecularFormulaByMoiety);
                }
                case 2097035189: {
                    return new Property("isotope", "", "Applicable for single substances that contain a radionuclide or a non-natural isotopic ratio.", 0, Integer.MAX_VALUE, this.isotope);
                }
                case 635625672: {
                    return new Property("molecularWeight", "@SubstanceSpecification.structure.isotope.molecularWeight", "The molecular weight or weight range (for proteins, polymers or nucleic acids).", 0, 1, this.molecularWeight);
                }
                case -896505829: {
                    return new Property("source", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.source);
                }
                case -671065907: {
                    return new Property("representation", "", "Molecular structural representation.", 0, Integer.MAX_VALUE, this.representation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 263475116: {
                    Base[] baseArray;
                    if (this.stereochemistry == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.stereochemistry;
                    }
                    return baseArray;
                }
                case 1420900135: {
                    Base[] baseArray;
                    if (this.opticalActivity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.opticalActivity;
                    }
                    return baseArray;
                }
                case 616660246: {
                    Base[] baseArray;
                    if (this.molecularFormula == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.molecularFormula;
                    }
                    return baseArray;
                }
                case 1315452848: {
                    Base[] baseArray;
                    if (this.molecularFormulaByMoiety == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.molecularFormulaByMoiety;
                    }
                    return baseArray;
                }
                case 2097035189: {
                    return this.isotope == null ? new Base[]{} : this.isotope.toArray(new Base[this.isotope.size()]);
                }
                case 635625672: {
                    Base[] baseArray;
                    if (this.molecularWeight == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.molecularWeight;
                    }
                    return baseArray;
                }
                case -896505829: {
                    return this.source == null ? new Base[]{} : this.source.toArray(new Base[this.source.size()]);
                }
                case -671065907: {
                    return this.representation == null ? new Base[]{} : this.representation.toArray(new Base[this.representation.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 263475116: {
                    this.stereochemistry = this.castToCodeableConcept(value);
                    return value;
                }
                case 1420900135: {
                    this.opticalActivity = this.castToCodeableConcept(value);
                    return value;
                }
                case 616660246: {
                    this.molecularFormula = this.castToString(value);
                    return value;
                }
                case 1315452848: {
                    this.molecularFormulaByMoiety = this.castToString(value);
                    return value;
                }
                case 2097035189: {
                    this.getIsotope().add((SubstanceSpecificationStructureIsotopeComponent)value);
                    return value;
                }
                case 635625672: {
                    this.molecularWeight = (SubstanceSpecificationStructureIsotopeMolecularWeightComponent)value;
                    return value;
                }
                case -896505829: {
                    this.getSource().add(this.castToReference(value));
                    return value;
                }
                case -671065907: {
                    this.getRepresentation().add((SubstanceSpecificationStructureRepresentationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("stereochemistry")) {
                this.stereochemistry = this.castToCodeableConcept(value);
            } else if (name.equals("opticalActivity")) {
                this.opticalActivity = this.castToCodeableConcept(value);
            } else if (name.equals("molecularFormula")) {
                this.molecularFormula = this.castToString(value);
            } else if (name.equals("molecularFormulaByMoiety")) {
                this.molecularFormulaByMoiety = this.castToString(value);
            } else if (name.equals("isotope")) {
                this.getIsotope().add((SubstanceSpecificationStructureIsotopeComponent)value);
            } else if (name.equals("molecularWeight")) {
                this.molecularWeight = (SubstanceSpecificationStructureIsotopeMolecularWeightComponent)value;
            } else if (name.equals("source")) {
                this.getSource().add(this.castToReference(value));
            } else if (name.equals("representation")) {
                this.getRepresentation().add((SubstanceSpecificationStructureRepresentationComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 263475116: {
                    return this.getStereochemistry();
                }
                case 1420900135: {
                    return this.getOpticalActivity();
                }
                case 616660246: {
                    return this.getMolecularFormulaElement();
                }
                case 1315452848: {
                    return this.getMolecularFormulaByMoietyElement();
                }
                case 2097035189: {
                    return this.addIsotope();
                }
                case 635625672: {
                    return this.getMolecularWeight();
                }
                case -896505829: {
                    return this.addSource();
                }
                case -671065907: {
                    return this.addRepresentation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 263475116: {
                    return new String[]{"CodeableConcept"};
                }
                case 1420900135: {
                    return new String[]{"CodeableConcept"};
                }
                case 616660246: {
                    return new String[]{"string"};
                }
                case 1315452848: {
                    return new String[]{"string"};
                }
                case 2097035189: {
                    return new String[0];
                }
                case 635625672: {
                    return new String[]{"@SubstanceSpecification.structure.isotope.molecularWeight"};
                }
                case -896505829: {
                    return new String[]{"Reference"};
                }
                case -671065907: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("stereochemistry")) {
                this.stereochemistry = new CodeableConcept();
                return this.stereochemistry;
            }
            if (name.equals("opticalActivity")) {
                this.opticalActivity = new CodeableConcept();
                return this.opticalActivity;
            }
            if (name.equals("molecularFormula")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.molecularFormula");
            }
            if (name.equals("molecularFormulaByMoiety")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.molecularFormulaByMoiety");
            }
            if (name.equals("isotope")) {
                return this.addIsotope();
            }
            if (name.equals("molecularWeight")) {
                this.molecularWeight = new SubstanceSpecificationStructureIsotopeMolecularWeightComponent();
                return this.molecularWeight;
            }
            if (name.equals("source")) {
                return this.addSource();
            }
            if (name.equals("representation")) {
                return this.addRepresentation();
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationStructureComponent copy() {
            SubstanceSpecificationStructureComponent dst = new SubstanceSpecificationStructureComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceSpecificationStructureComponent dst) {
            super.copyValues(dst);
            dst.stereochemistry = this.stereochemistry == null ? null : this.stereochemistry.copy();
            dst.opticalActivity = this.opticalActivity == null ? null : this.opticalActivity.copy();
            dst.molecularFormula = this.molecularFormula == null ? null : this.molecularFormula.copy();
            StringType stringType = dst.molecularFormulaByMoiety = this.molecularFormulaByMoiety == null ? null : this.molecularFormulaByMoiety.copy();
            if (this.isotope != null) {
                dst.isotope = new ArrayList<SubstanceSpecificationStructureIsotopeComponent>();
                for (SubstanceSpecificationStructureIsotopeComponent substanceSpecificationStructureIsotopeComponent : this.isotope) {
                    dst.isotope.add(substanceSpecificationStructureIsotopeComponent.copy());
                }
            }
            SubstanceSpecificationStructureIsotopeMolecularWeightComponent substanceSpecificationStructureIsotopeMolecularWeightComponent = dst.molecularWeight = this.molecularWeight == null ? null : this.molecularWeight.copy();
            if (this.source != null) {
                dst.source = new ArrayList<Reference>();
                for (Reference reference : this.source) {
                    dst.source.add(reference.copy());
                }
            }
            if (this.representation != null) {
                dst.representation = new ArrayList<SubstanceSpecificationStructureRepresentationComponent>();
                for (SubstanceSpecificationStructureRepresentationComponent substanceSpecificationStructureRepresentationComponent : this.representation) {
                    dst.representation.add(substanceSpecificationStructureRepresentationComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationStructureComponent)) {
                return false;
            }
            SubstanceSpecificationStructureComponent o = (SubstanceSpecificationStructureComponent)other_;
            return SubstanceSpecificationStructureComponent.compareDeep(this.stereochemistry, o.stereochemistry, true) && SubstanceSpecificationStructureComponent.compareDeep(this.opticalActivity, o.opticalActivity, true) && SubstanceSpecificationStructureComponent.compareDeep(this.molecularFormula, o.molecularFormula, true) && SubstanceSpecificationStructureComponent.compareDeep(this.molecularFormulaByMoiety, o.molecularFormulaByMoiety, true) && SubstanceSpecificationStructureComponent.compareDeep(this.isotope, o.isotope, true) && SubstanceSpecificationStructureComponent.compareDeep(this.molecularWeight, o.molecularWeight, true) && SubstanceSpecificationStructureComponent.compareDeep(this.source, o.source, true) && SubstanceSpecificationStructureComponent.compareDeep(this.representation, o.representation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationStructureComponent)) {
                return false;
            }
            SubstanceSpecificationStructureComponent o = (SubstanceSpecificationStructureComponent)other_;
            return SubstanceSpecificationStructureComponent.compareValues(this.molecularFormula, o.molecularFormula, true) && SubstanceSpecificationStructureComponent.compareValues(this.molecularFormulaByMoiety, o.molecularFormulaByMoiety, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.stereochemistry, this.opticalActivity, this.molecularFormula, this.molecularFormulaByMoiety, this.isotope, this.molecularWeight, this.source, this.representation});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.structure";
        }
    }

    @Block
    public static class SubstanceSpecificationPropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A category for this property, e.g. Physical, Chemical, Enzymatic", formalDefinition="A category for this property, e.g. Physical, Chemical, Enzymatic.")
        protected CodeableConcept category;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Property type e.g. viscosity, pH, isoelectric point", formalDefinition="Property type e.g. viscosity, pH, isoelectric point.")
        protected CodeableConcept code;
        @Child(name="parameters", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Parameters that were used in the measurement of a property (e.g. for viscosity: measured at 20C with a pH of 7.1)", formalDefinition="Parameters that were used in the measurement of a property (e.g. for viscosity: measured at 20C with a pH of 7.1).")
        protected StringType parameters;
        @Child(name="definingSubstance", type={SubstanceSpecification.class, Substance.class, CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A substance upon which a defining property depends (e.g. for solubility: in water, in alcohol)", formalDefinition="A substance upon which a defining property depends (e.g. for solubility: in water, in alcohol).")
        protected Type definingSubstance;
        @Child(name="amount", type={Quantity.class, StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Quantitative value for this property", formalDefinition="Quantitative value for this property.")
        protected Type amount;
        private static final long serialVersionUID = 556834916L;

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationPropertyComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public SubstanceSpecificationPropertyComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationPropertyComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SubstanceSpecificationPropertyComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public StringType getParametersElement() {
            if (this.parameters == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationPropertyComponent.parameters");
                }
                if (Configuration.doAutoCreate()) {
                    this.parameters = new StringType();
                }
            }
            return this.parameters;
        }

        public boolean hasParametersElement() {
            return this.parameters != null && !this.parameters.isEmpty();
        }

        public boolean hasParameters() {
            return this.parameters != null && !this.parameters.isEmpty();
        }

        public SubstanceSpecificationPropertyComponent setParametersElement(StringType value) {
            this.parameters = value;
            return this;
        }

        public String getParameters() {
            return this.parameters == null ? null : (String)this.parameters.getValue();
        }

        public SubstanceSpecificationPropertyComponent setParameters(String value) {
            if (Utilities.noString((String)value)) {
                this.parameters = null;
            } else {
                if (this.parameters == null) {
                    this.parameters = new StringType();
                }
                this.parameters.setValue(value);
            }
            return this;
        }

        public Type getDefiningSubstance() {
            return this.definingSubstance;
        }

        public Reference getDefiningSubstanceReference() throws FHIRException {
            if (this.definingSubstance == null) {
                this.definingSubstance = new Reference();
            }
            if (!(this.definingSubstance instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.definingSubstance.getClass().getName() + " was encountered");
            }
            return (Reference)this.definingSubstance;
        }

        public boolean hasDefiningSubstanceReference() {
            return this != null && this.definingSubstance instanceof Reference;
        }

        public CodeableConcept getDefiningSubstanceCodeableConcept() throws FHIRException {
            if (this.definingSubstance == null) {
                this.definingSubstance = new CodeableConcept();
            }
            if (!(this.definingSubstance instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.definingSubstance.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.definingSubstance;
        }

        public boolean hasDefiningSubstanceCodeableConcept() {
            return this != null && this.definingSubstance instanceof CodeableConcept;
        }

        public boolean hasDefiningSubstance() {
            return this.definingSubstance != null && !this.definingSubstance.isEmpty();
        }

        public SubstanceSpecificationPropertyComponent setDefiningSubstance(Type value) {
            if (value != null && !(value instanceof Reference) && !(value instanceof CodeableConcept)) {
                throw new Error("Not the right type for SubstanceSpecification.property.definingSubstance[x]: " + value.fhirType());
            }
            this.definingSubstance = value;
            return this;
        }

        public Type getAmount() {
            return this.amount;
        }

        public Quantity getAmountQuantity() throws FHIRException {
            if (this.amount == null) {
                this.amount = new Quantity();
            }
            if (!(this.amount instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (Quantity)this.amount;
        }

        public boolean hasAmountQuantity() {
            return this != null && this.amount instanceof Quantity;
        }

        public StringType getAmountStringType() throws FHIRException {
            if (this.amount == null) {
                this.amount = new StringType();
            }
            if (!(this.amount instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (StringType)this.amount;
        }

        public boolean hasAmountStringType() {
            return this != null && this.amount instanceof StringType;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public SubstanceSpecificationPropertyComponent setAmount(Type value) {
            if (value != null && !(value instanceof Quantity) && !(value instanceof StringType)) {
                throw new Error("Not the right type for SubstanceSpecification.property.amount[x]: " + value.fhirType());
            }
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "A category for this property, e.g. Physical, Chemical, Enzymatic.", 0, 1, this.category));
            children.add(new Property(SubstanceSpecification.SP_CODE, "CodeableConcept", "Property type e.g. viscosity, pH, isoelectric point.", 0, 1, this.code));
            children.add(new Property("parameters", "string", "Parameters that were used in the measurement of a property (e.g. for viscosity: measured at 20C with a pH of 7.1).", 0, 1, this.parameters));
            children.add(new Property("definingSubstance[x]", "Reference(SubstanceSpecification|Substance)|CodeableConcept", "A substance upon which a defining property depends (e.g. for solubility: in water, in alcohol).", 0, 1, this.definingSubstance));
            children.add(new Property("amount[x]", "Quantity|string", "Quantitative value for this property.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "A category for this property, e.g. Physical, Chemical, Enzymatic.", 0, 1, this.category);
                }
                case 3059181: {
                    return new Property(SubstanceSpecification.SP_CODE, "CodeableConcept", "Property type e.g. viscosity, pH, isoelectric point.", 0, 1, this.code);
                }
                case 458736106: {
                    return new Property("parameters", "string", "Parameters that were used in the measurement of a property (e.g. for viscosity: measured at 20C with a pH of 7.1).", 0, 1, this.parameters);
                }
                case 1535270120: {
                    return new Property("definingSubstance[x]", "Reference(SubstanceSpecification|Substance)|CodeableConcept", "A substance upon which a defining property depends (e.g. for solubility: in water, in alcohol).", 0, 1, this.definingSubstance);
                }
                case 1901076632: {
                    return new Property("definingSubstance[x]", "Reference(SubstanceSpecification|Substance)|CodeableConcept", "A substance upon which a defining property depends (e.g. for solubility: in water, in alcohol).", 0, 1, this.definingSubstance);
                }
                case -2101581421: {
                    return new Property("definingSubstance[x]", "Reference(SubstanceSpecification|Substance)|CodeableConcept", "A substance upon which a defining property depends (e.g. for solubility: in water, in alcohol).", 0, 1, this.definingSubstance);
                }
                case -1438235671: {
                    return new Property("definingSubstance[x]", "Reference(SubstanceSpecification|Substance)|CodeableConcept", "A substance upon which a defining property depends (e.g. for solubility: in water, in alcohol).", 0, 1, this.definingSubstance);
                }
                case 646780200: {
                    return new Property("amount[x]", "Quantity|string", "Quantitative value for this property.", 0, 1, this.amount);
                }
                case -1413853096: {
                    return new Property("amount[x]", "Quantity|string", "Quantitative value for this property.", 0, 1, this.amount);
                }
                case 1664303363: {
                    return new Property("amount[x]", "Quantity|string", "Quantitative value for this property.", 0, 1, this.amount);
                }
                case 773651081: {
                    return new Property("amount[x]", "Quantity|string", "Quantitative value for this property.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case 458736106: {
                    Base[] baseArray;
                    if (this.parameters == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.parameters;
                    }
                    return baseArray;
                }
                case 1901076632: {
                    Base[] baseArray;
                    if (this.definingSubstance == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.definingSubstance;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case 458736106: {
                    this.parameters = this.castToString(value);
                    return value;
                }
                case 1901076632: {
                    this.definingSubstance = this.castToType(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals(SubstanceSpecification.SP_CODE)) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("parameters")) {
                this.parameters = this.castToString(value);
            } else if (name.equals("definingSubstance[x]")) {
                this.definingSubstance = this.castToType(value);
            } else if (name.equals("amount[x]")) {
                this.amount = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case 3059181: {
                    return this.getCode();
                }
                case 458736106: {
                    return this.getParametersElement();
                }
                case 1535270120: {
                    return this.getDefiningSubstance();
                }
                case 1901076632: {
                    return this.getDefiningSubstance();
                }
                case 646780200: {
                    return this.getAmount();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 458736106: {
                    return new String[]{"string"};
                }
                case 1901076632: {
                    return new String[]{"Reference", "CodeableConcept"};
                }
                case -1413853096: {
                    return new String[]{"Quantity", "string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals(SubstanceSpecification.SP_CODE)) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("parameters")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.parameters");
            }
            if (name.equals("definingSubstanceReference")) {
                this.definingSubstance = new Reference();
                return this.definingSubstance;
            }
            if (name.equals("definingSubstanceCodeableConcept")) {
                this.definingSubstance = new CodeableConcept();
                return this.definingSubstance;
            }
            if (name.equals("amountQuantity")) {
                this.amount = new Quantity();
                return this.amount;
            }
            if (name.equals("amountString")) {
                this.amount = new StringType();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationPropertyComponent copy() {
            SubstanceSpecificationPropertyComponent dst = new SubstanceSpecificationPropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceSpecificationPropertyComponent dst) {
            super.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.parameters = this.parameters == null ? null : this.parameters.copy();
            dst.definingSubstance = this.definingSubstance == null ? null : this.definingSubstance.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationPropertyComponent)) {
                return false;
            }
            SubstanceSpecificationPropertyComponent o = (SubstanceSpecificationPropertyComponent)other_;
            return SubstanceSpecificationPropertyComponent.compareDeep(this.category, o.category, true) && SubstanceSpecificationPropertyComponent.compareDeep(this.code, o.code, true) && SubstanceSpecificationPropertyComponent.compareDeep(this.parameters, o.parameters, true) && SubstanceSpecificationPropertyComponent.compareDeep(this.definingSubstance, o.definingSubstance, true) && SubstanceSpecificationPropertyComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationPropertyComponent)) {
                return false;
            }
            SubstanceSpecificationPropertyComponent o = (SubstanceSpecificationPropertyComponent)other_;
            return SubstanceSpecificationPropertyComponent.compareValues(this.parameters, o.parameters, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.category, this.code, this.parameters, this.definingSubstance, this.amount});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.property";
        }
    }

    @Block
    public static class SubstanceSpecificationMoietyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Role that the moiety is playing", formalDefinition="Role that the moiety is playing.")
        protected CodeableConcept role;
        @Child(name="identifier", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifier by which this moiety substance is known", formalDefinition="Identifier by which this moiety substance is known.")
        protected Identifier identifier;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Textual name for this moiety substance", formalDefinition="Textual name for this moiety substance.")
        protected StringType name;
        @Child(name="stereochemistry", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Stereochemistry type", formalDefinition="Stereochemistry type.")
        protected CodeableConcept stereochemistry;
        @Child(name="opticalActivity", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Optical activity type", formalDefinition="Optical activity type.")
        protected CodeableConcept opticalActivity;
        @Child(name="molecularFormula", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Molecular formula", formalDefinition="Molecular formula.")
        protected StringType molecularFormula;
        @Child(name="amount", type={Quantity.class, StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Quantitative value for this moiety", formalDefinition="Quantitative value for this moiety.")
        protected Type amount;
        private static final long serialVersionUID = -505630417L;

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationMoietyComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public SubstanceSpecificationMoietyComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationMoietyComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public SubstanceSpecificationMoietyComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationMoietyComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public SubstanceSpecificationMoietyComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public SubstanceSpecificationMoietyComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public CodeableConcept getStereochemistry() {
            if (this.stereochemistry == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationMoietyComponent.stereochemistry");
                }
                if (Configuration.doAutoCreate()) {
                    this.stereochemistry = new CodeableConcept();
                }
            }
            return this.stereochemistry;
        }

        public boolean hasStereochemistry() {
            return this.stereochemistry != null && !this.stereochemistry.isEmpty();
        }

        public SubstanceSpecificationMoietyComponent setStereochemistry(CodeableConcept value) {
            this.stereochemistry = value;
            return this;
        }

        public CodeableConcept getOpticalActivity() {
            if (this.opticalActivity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationMoietyComponent.opticalActivity");
                }
                if (Configuration.doAutoCreate()) {
                    this.opticalActivity = new CodeableConcept();
                }
            }
            return this.opticalActivity;
        }

        public boolean hasOpticalActivity() {
            return this.opticalActivity != null && !this.opticalActivity.isEmpty();
        }

        public SubstanceSpecificationMoietyComponent setOpticalActivity(CodeableConcept value) {
            this.opticalActivity = value;
            return this;
        }

        public StringType getMolecularFormulaElement() {
            if (this.molecularFormula == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationMoietyComponent.molecularFormula");
                }
                if (Configuration.doAutoCreate()) {
                    this.molecularFormula = new StringType();
                }
            }
            return this.molecularFormula;
        }

        public boolean hasMolecularFormulaElement() {
            return this.molecularFormula != null && !this.molecularFormula.isEmpty();
        }

        public boolean hasMolecularFormula() {
            return this.molecularFormula != null && !this.molecularFormula.isEmpty();
        }

        public SubstanceSpecificationMoietyComponent setMolecularFormulaElement(StringType value) {
            this.molecularFormula = value;
            return this;
        }

        public String getMolecularFormula() {
            return this.molecularFormula == null ? null : (String)this.molecularFormula.getValue();
        }

        public SubstanceSpecificationMoietyComponent setMolecularFormula(String value) {
            if (Utilities.noString((String)value)) {
                this.molecularFormula = null;
            } else {
                if (this.molecularFormula == null) {
                    this.molecularFormula = new StringType();
                }
                this.molecularFormula.setValue(value);
            }
            return this;
        }

        public Type getAmount() {
            return this.amount;
        }

        public Quantity getAmountQuantity() throws FHIRException {
            if (this.amount == null) {
                this.amount = new Quantity();
            }
            if (!(this.amount instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (Quantity)this.amount;
        }

        public boolean hasAmountQuantity() {
            return this != null && this.amount instanceof Quantity;
        }

        public StringType getAmountStringType() throws FHIRException {
            if (this.amount == null) {
                this.amount = new StringType();
            }
            if (!(this.amount instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.amount.getClass().getName() + " was encountered");
            }
            return (StringType)this.amount;
        }

        public boolean hasAmountStringType() {
            return this != null && this.amount instanceof StringType;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public SubstanceSpecificationMoietyComponent setAmount(Type value) {
            if (value != null && !(value instanceof Quantity) && !(value instanceof StringType)) {
                throw new Error("Not the right type for SubstanceSpecification.moiety.amount[x]: " + value.fhirType());
            }
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("role", "CodeableConcept", "Role that the moiety is playing.", 0, 1, this.role));
            children.add(new Property("identifier", "Identifier", "Identifier by which this moiety substance is known.", 0, 1, this.identifier));
            children.add(new Property("name", "string", "Textual name for this moiety substance.", 0, 1, this.name));
            children.add(new Property("stereochemistry", "CodeableConcept", "Stereochemistry type.", 0, 1, this.stereochemistry));
            children.add(new Property("opticalActivity", "CodeableConcept", "Optical activity type.", 0, 1, this.opticalActivity));
            children.add(new Property("molecularFormula", "string", "Molecular formula.", 0, 1, this.molecularFormula));
            children.add(new Property("amount[x]", "Quantity|string", "Quantitative value for this moiety.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property("role", "CodeableConcept", "Role that the moiety is playing.", 0, 1, this.role);
                }
                case -1618432855: {
                    return new Property("identifier", "Identifier", "Identifier by which this moiety substance is known.", 0, 1, this.identifier);
                }
                case 3373707: {
                    return new Property("name", "string", "Textual name for this moiety substance.", 0, 1, this.name);
                }
                case 263475116: {
                    return new Property("stereochemistry", "CodeableConcept", "Stereochemistry type.", 0, 1, this.stereochemistry);
                }
                case 1420900135: {
                    return new Property("opticalActivity", "CodeableConcept", "Optical activity type.", 0, 1, this.opticalActivity);
                }
                case 616660246: {
                    return new Property("molecularFormula", "string", "Molecular formula.", 0, 1, this.molecularFormula);
                }
                case 646780200: {
                    return new Property("amount[x]", "Quantity|string", "Quantitative value for this moiety.", 0, 1, this.amount);
                }
                case -1413853096: {
                    return new Property("amount[x]", "Quantity|string", "Quantitative value for this moiety.", 0, 1, this.amount);
                }
                case 1664303363: {
                    return new Property("amount[x]", "Quantity|string", "Quantitative value for this moiety.", 0, 1, this.amount);
                }
                case 773651081: {
                    return new Property("amount[x]", "Quantity|string", "Quantitative value for this moiety.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
                case 263475116: {
                    Base[] baseArray;
                    if (this.stereochemistry == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.stereochemistry;
                    }
                    return baseArray;
                }
                case 1420900135: {
                    Base[] baseArray;
                    if (this.opticalActivity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.opticalActivity;
                    }
                    return baseArray;
                }
                case 616660246: {
                    Base[] baseArray;
                    if (this.molecularFormula == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.molecularFormula;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    return value;
                }
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 263475116: {
                    this.stereochemistry = this.castToCodeableConcept(value);
                    return value;
                }
                case 1420900135: {
                    this.opticalActivity = this.castToCodeableConcept(value);
                    return value;
                }
                case 616660246: {
                    this.molecularFormula = this.castToString(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else if (name.equals("identifier")) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("stereochemistry")) {
                this.stereochemistry = this.castToCodeableConcept(value);
            } else if (name.equals("opticalActivity")) {
                this.opticalActivity = this.castToCodeableConcept(value);
            } else if (name.equals("molecularFormula")) {
                this.molecularFormula = this.castToString(value);
            } else if (name.equals("amount[x]")) {
                this.amount = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case 263475116: {
                    return this.getStereochemistry();
                }
                case 1420900135: {
                    return this.getOpticalActivity();
                }
                case 616660246: {
                    return this.getMolecularFormulaElement();
                }
                case 646780200: {
                    return this.getAmount();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case 263475116: {
                    return new String[]{"CodeableConcept"};
                }
                case 1420900135: {
                    return new String[]{"CodeableConcept"};
                }
                case 616660246: {
                    return new String[]{"string"};
                }
                case -1413853096: {
                    return new String[]{"Quantity", "string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("identifier")) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.name");
            }
            if (name.equals("stereochemistry")) {
                this.stereochemistry = new CodeableConcept();
                return this.stereochemistry;
            }
            if (name.equals("opticalActivity")) {
                this.opticalActivity = new CodeableConcept();
                return this.opticalActivity;
            }
            if (name.equals("molecularFormula")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.molecularFormula");
            }
            if (name.equals("amountQuantity")) {
                this.amount = new Quantity();
                return this.amount;
            }
            if (name.equals("amountString")) {
                this.amount = new StringType();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationMoietyComponent copy() {
            SubstanceSpecificationMoietyComponent dst = new SubstanceSpecificationMoietyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceSpecificationMoietyComponent dst) {
            super.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.stereochemistry = this.stereochemistry == null ? null : this.stereochemistry.copy();
            dst.opticalActivity = this.opticalActivity == null ? null : this.opticalActivity.copy();
            dst.molecularFormula = this.molecularFormula == null ? null : this.molecularFormula.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationMoietyComponent)) {
                return false;
            }
            SubstanceSpecificationMoietyComponent o = (SubstanceSpecificationMoietyComponent)other_;
            return SubstanceSpecificationMoietyComponent.compareDeep(this.role, o.role, true) && SubstanceSpecificationMoietyComponent.compareDeep(this.identifier, o.identifier, true) && SubstanceSpecificationMoietyComponent.compareDeep(this.name, o.name, true) && SubstanceSpecificationMoietyComponent.compareDeep(this.stereochemistry, o.stereochemistry, true) && SubstanceSpecificationMoietyComponent.compareDeep(this.opticalActivity, o.opticalActivity, true) && SubstanceSpecificationMoietyComponent.compareDeep(this.molecularFormula, o.molecularFormula, true) && SubstanceSpecificationMoietyComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationMoietyComponent)) {
                return false;
            }
            SubstanceSpecificationMoietyComponent o = (SubstanceSpecificationMoietyComponent)other_;
            return SubstanceSpecificationMoietyComponent.compareValues(this.name, o.name, true) && SubstanceSpecificationMoietyComponent.compareValues(this.molecularFormula, o.molecularFormula, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.role, this.identifier, this.name, this.stereochemistry, this.opticalActivity, this.molecularFormula, this.amount});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.moiety";
        }
    }
}

