/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ExampleScenario", profile="http://hl7.org/fhir/StructureDefinition/ExampleScenario")
@ChildOrder(names={"url", "identifier", "version", "name", "status", "experimental", "date", "publisher", "contact", "useContext", "jurisdiction", "copyright", "purpose", "actor", "instance", "process", "workflow"})
public class ExampleScenario
extends MetadataResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the example scenario", formalDefinition="A formal identifier that is used to identify this example scenario when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="copyright", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the example scenario and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the example scenario.")
    protected MarkdownType copyright;
    @Child(name="purpose", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The purpose of the example, e.g. to illustrate a scenario", formalDefinition="What the example scenario resource is created for. This should not be used to show the business purpose of the scenario itself, but the purpose of documenting a scenario.")
    protected MarkdownType purpose;
    @Child(name="actor", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Actor participating in the resource", formalDefinition="Actor participating in the resource.")
    protected List<ExampleScenarioActorComponent> actor;
    @Child(name="instance", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Each resource and each version that is present in the workflow", formalDefinition="Each resource and each version that is present in the workflow.")
    protected List<ExampleScenarioInstanceComponent> instance;
    @Child(name="process", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Each major process - a group of operations", formalDefinition="Each major process - a group of operations.")
    protected List<ExampleScenarioProcessComponent> process;
    @Child(name="workflow", type={CanonicalType.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Another nested workflow", formalDefinition="Another nested workflow.")
    protected List<CanonicalType> workflow;
    private static final long serialVersionUID = 758248907L;
    @SearchParamDefinition(name="date", path="ExampleScenario.date", description="The example scenario publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ExampleScenario.identifier", description="External identifier for the example scenario", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="context-type-value", path="ExampleScenario.useContext", description="A use context type and value assigned to the example scenario", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="jurisdiction", path="ExampleScenario.jurisdiction", description="Intended jurisdiction for the example scenario", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="context-type", path="ExampleScenario.useContext.code", description="A type of use context assigned to the example scenario", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="version", path="ExampleScenario.version", description="The business version of the example scenario", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="ExampleScenario.url", description="The uri that identifies the example scenario", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="context-quantity", path="(ExampleScenario.useContext.value as Quantity) | (ExampleScenario.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the example scenario", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="name", path="ExampleScenario.name", description="Computationally friendly name of the example scenario", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="context", path="(ExampleScenario.useContext.value as CodeableConcept)", description="A use context assigned to the example scenario", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="publisher", path="ExampleScenario.publisher", description="Name of the publisher of the example scenario", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="context-type-quantity", path="ExampleScenario.useContext", description="A use context type and quantity- or range-based value assigned to the example scenario", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="status", path="ExampleScenario.status", description="The current status of the example scenario", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public ExampleScenario() {
    }

    public ExampleScenario(Enumeration<Enumerations.PublicationStatus> status) {
        this.status = status;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ExampleScenario setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ExampleScenario setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ExampleScenario setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ExampleScenario addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ExampleScenario setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ExampleScenario setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ExampleScenario setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ExampleScenario setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ExampleScenario setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ExampleScenario setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ExampleScenario setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ExampleScenario setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ExampleScenario setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ExampleScenario setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ExampleScenario setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ExampleScenario setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public ExampleScenario setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ExampleScenario addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public ExampleScenario setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ExampleScenario addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public ExampleScenario setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ExampleScenario addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public ExampleScenario setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public ExampleScenario setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExampleScenario.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public ExampleScenario setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public ExampleScenario setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public List<ExampleScenarioActorComponent> getActor() {
        if (this.actor == null) {
            this.actor = new ArrayList<ExampleScenarioActorComponent>();
        }
        return this.actor;
    }

    public ExampleScenario setActor(List<ExampleScenarioActorComponent> theActor) {
        this.actor = theActor;
        return this;
    }

    public boolean hasActor() {
        if (this.actor == null) {
            return false;
        }
        for (ExampleScenarioActorComponent item : this.actor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ExampleScenarioActorComponent addActor() {
        ExampleScenarioActorComponent t = new ExampleScenarioActorComponent();
        if (this.actor == null) {
            this.actor = new ArrayList<ExampleScenarioActorComponent>();
        }
        this.actor.add(t);
        return t;
    }

    public ExampleScenario addActor(ExampleScenarioActorComponent t) {
        if (t == null) {
            return this;
        }
        if (this.actor == null) {
            this.actor = new ArrayList<ExampleScenarioActorComponent>();
        }
        this.actor.add(t);
        return this;
    }

    public ExampleScenarioActorComponent getActorFirstRep() {
        if (this.getActor().isEmpty()) {
            this.addActor();
        }
        return this.getActor().get(0);
    }

    public List<ExampleScenarioInstanceComponent> getInstance() {
        if (this.instance == null) {
            this.instance = new ArrayList<ExampleScenarioInstanceComponent>();
        }
        return this.instance;
    }

    public ExampleScenario setInstance(List<ExampleScenarioInstanceComponent> theInstance) {
        this.instance = theInstance;
        return this;
    }

    public boolean hasInstance() {
        if (this.instance == null) {
            return false;
        }
        for (ExampleScenarioInstanceComponent item : this.instance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ExampleScenarioInstanceComponent addInstance() {
        ExampleScenarioInstanceComponent t = new ExampleScenarioInstanceComponent();
        if (this.instance == null) {
            this.instance = new ArrayList<ExampleScenarioInstanceComponent>();
        }
        this.instance.add(t);
        return t;
    }

    public ExampleScenario addInstance(ExampleScenarioInstanceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.instance == null) {
            this.instance = new ArrayList<ExampleScenarioInstanceComponent>();
        }
        this.instance.add(t);
        return this;
    }

    public ExampleScenarioInstanceComponent getInstanceFirstRep() {
        if (this.getInstance().isEmpty()) {
            this.addInstance();
        }
        return this.getInstance().get(0);
    }

    public List<ExampleScenarioProcessComponent> getProcess() {
        if (this.process == null) {
            this.process = new ArrayList<ExampleScenarioProcessComponent>();
        }
        return this.process;
    }

    public ExampleScenario setProcess(List<ExampleScenarioProcessComponent> theProcess) {
        this.process = theProcess;
        return this;
    }

    public boolean hasProcess() {
        if (this.process == null) {
            return false;
        }
        for (ExampleScenarioProcessComponent item : this.process) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ExampleScenarioProcessComponent addProcess() {
        ExampleScenarioProcessComponent t = new ExampleScenarioProcessComponent();
        if (this.process == null) {
            this.process = new ArrayList<ExampleScenarioProcessComponent>();
        }
        this.process.add(t);
        return t;
    }

    public ExampleScenario addProcess(ExampleScenarioProcessComponent t) {
        if (t == null) {
            return this;
        }
        if (this.process == null) {
            this.process = new ArrayList<ExampleScenarioProcessComponent>();
        }
        this.process.add(t);
        return this;
    }

    public ExampleScenarioProcessComponent getProcessFirstRep() {
        if (this.getProcess().isEmpty()) {
            this.addProcess();
        }
        return this.getProcess().get(0);
    }

    public List<CanonicalType> getWorkflow() {
        if (this.workflow == null) {
            this.workflow = new ArrayList<CanonicalType>();
        }
        return this.workflow;
    }

    public ExampleScenario setWorkflow(List<CanonicalType> theWorkflow) {
        this.workflow = theWorkflow;
        return this;
    }

    public boolean hasWorkflow() {
        if (this.workflow == null) {
            return false;
        }
        for (CanonicalType item : this.workflow) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addWorkflowElement() {
        CanonicalType t = new CanonicalType();
        if (this.workflow == null) {
            this.workflow = new ArrayList<CanonicalType>();
        }
        this.workflow.add(t);
        return t;
    }

    public ExampleScenario addWorkflow(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.workflow == null) {
            this.workflow = new ArrayList<CanonicalType>();
        }
        this.workflow.add(t);
        return this;
    }

    public boolean hasWorkflow(String value) {
        if (this.workflow == null) {
            return false;
        }
        for (CanonicalType v : this.workflow) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this example scenario when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this example scenario is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the example scenario is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this example scenario when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the example scenario when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the example scenario author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the example scenario. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_STATUS, "code", "The status of this example scenario. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this example scenario is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the example scenario was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the example scenario changes. (e.g. the 'content logical definition').", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the example scenario.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate example scenario instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the example scenario is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the example scenario and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the example scenario.", 0, 1, this.copyright));
        children.add(new Property("purpose", "markdown", "What the example scenario resource is created for. This should not be used to show the business purpose of the scenario itself, but the purpose of documenting a scenario.", 0, 1, this.purpose));
        children.add(new Property("actor", "", "Actor participating in the resource.", 0, Integer.MAX_VALUE, this.actor));
        children.add(new Property("instance", "", "Each resource and each version that is present in the workflow.", 0, Integer.MAX_VALUE, this.instance));
        children.add(new Property("process", "", "Each major process - a group of operations.", 0, Integer.MAX_VALUE, this.process));
        children.add(new Property("workflow", "canonical(ExampleScenario)", "Another nested workflow.", 0, Integer.MAX_VALUE, this.workflow));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this example scenario when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this example scenario is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the example scenario is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this example scenario when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the example scenario when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the example scenario author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the example scenario. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this example scenario. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this example scenario is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the example scenario was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the example scenario changes. (e.g. the 'content logical definition').", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the example scenario.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate example scenario instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the example scenario is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the example scenario and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the example scenario.", 0, 1, this.copyright);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "What the example scenario resource is created for. This should not be used to show the business purpose of the scenario itself, but the purpose of documenting a scenario.", 0, 1, this.purpose);
            }
            case 92645877: {
                return new Property("actor", "", "Actor participating in the resource.", 0, Integer.MAX_VALUE, this.actor);
            }
            case 555127957: {
                return new Property("instance", "", "Each resource and each version that is present in the workflow.", 0, Integer.MAX_VALUE, this.instance);
            }
            case -309518737: {
                return new Property("process", "", "Each major process - a group of operations.", 0, Integer.MAX_VALUE, this.process);
            }
            case 35379135: {
                return new Property("workflow", "canonical(ExampleScenario)", "Another nested workflow.", 0, Integer.MAX_VALUE, this.workflow);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.copyright;
                }
                return baseArray;
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.purpose;
                }
                return baseArray;
            }
            case 92645877: {
                return this.actor == null ? new Base[]{} : this.actor.toArray(new Base[this.actor.size()]);
            }
            case 555127957: {
                return this.instance == null ? new Base[]{} : this.instance.toArray(new Base[this.instance.size()]);
            }
            case -309518737: {
                return this.process == null ? new Base[]{} : this.process.toArray(new Base[this.process.size()]);
            }
            case 35379135: {
                return this.workflow == null ? new Base[]{} : this.workflow.toArray(new Base[this.workflow.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case -220463842: {
                this.purpose = this.castToMarkdown(value);
                return value;
            }
            case 92645877: {
                this.getActor().add((ExampleScenarioActorComponent)((Object)value));
                return value;
            }
            case 555127957: {
                this.getInstance().add((ExampleScenarioInstanceComponent)((Object)value));
                return value;
            }
            case -309518737: {
                this.getProcess().add((ExampleScenarioProcessComponent)((Object)value));
                return value;
            }
            case 35379135: {
                this.getWorkflow().add(this.castToCanonical(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("purpose")) {
            this.purpose = this.castToMarkdown(value);
        } else if (name.equals("actor")) {
            this.getActor().add((ExampleScenarioActorComponent)((Object)value));
        } else if (name.equals("instance")) {
            this.getInstance().add((ExampleScenarioInstanceComponent)((Object)value));
        } else if (name.equals("process")) {
            this.getProcess().add((ExampleScenarioProcessComponent)((Object)value));
        } else if (name.equals("workflow")) {
            this.getWorkflow().add(this.castToCanonical(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 92645877: {
                return this.addActor();
            }
            case 555127957: {
                return this.addInstance();
            }
            case -309518737: {
                return this.addProcess();
            }
            case 35379135: {
                return this.addWorkflowElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 92645877: {
                return new String[0];
            }
            case 555127957: {
                return new String[0];
            }
            case -309518737: {
                return new String[0];
            }
            case 35379135: {
                return new String[]{"canonical"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.copyright");
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.purpose");
        }
        if (name.equals("actor")) {
            return this.addActor();
        }
        if (name.equals("instance")) {
            return this.addInstance();
        }
        if (name.equals("process")) {
            return this.addProcess();
        }
        if (name.equals("workflow")) {
            throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.workflow");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ExampleScenario";
    }

    @Override
    public ExampleScenario copy() {
        ExampleScenario dst = new ExampleScenario();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ExampleScenario dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        MarkdownType markdownType = dst.purpose = this.purpose == null ? null : this.purpose.copy();
        if (this.actor != null) {
            dst.actor = new ArrayList<ExampleScenarioActorComponent>();
            for (ExampleScenarioActorComponent exampleScenarioActorComponent : this.actor) {
                dst.actor.add(exampleScenarioActorComponent.copy());
            }
        }
        if (this.instance != null) {
            dst.instance = new ArrayList<ExampleScenarioInstanceComponent>();
            for (ExampleScenarioInstanceComponent exampleScenarioInstanceComponent : this.instance) {
                dst.instance.add(exampleScenarioInstanceComponent.copy());
            }
        }
        if (this.process != null) {
            dst.process = new ArrayList<ExampleScenarioProcessComponent>();
            for (ExampleScenarioProcessComponent exampleScenarioProcessComponent : this.process) {
                dst.process.add(exampleScenarioProcessComponent.copy());
            }
        }
        if (this.workflow != null) {
            dst.workflow = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.workflow) {
                dst.workflow.add(canonicalType.copy());
            }
        }
    }

    protected ExampleScenario typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ExampleScenario)) {
            return false;
        }
        ExampleScenario o = (ExampleScenario)other_;
        return ExampleScenario.compareDeep(this.identifier, o.identifier, true) && ExampleScenario.compareDeep(this.copyright, o.copyright, true) && ExampleScenario.compareDeep(this.purpose, o.purpose, true) && ExampleScenario.compareDeep(this.actor, o.actor, true) && ExampleScenario.compareDeep(this.instance, o.instance, true) && ExampleScenario.compareDeep(this.process, o.process, true) && ExampleScenario.compareDeep(this.workflow, o.workflow, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ExampleScenario)) {
            return false;
        }
        ExampleScenario o = (ExampleScenario)other_;
        return ExampleScenario.compareValues(this.copyright, o.copyright, true) && ExampleScenario.compareValues(this.purpose, o.purpose, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.copyright, this.purpose, this.actor, this.instance, this.process, this.workflow});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ExampleScenario;
    }

    @Block
    public static class ExampleScenarioProcessStepAlternativeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="title", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for alternative", formalDefinition="The label to display for the alternative that gives a sense of the circumstance in which the alternative should be invoked.")
        protected StringType title;
        @Child(name="description", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A human-readable description of each option", formalDefinition="A human-readable description of the alternative explaining when the alternative should occur rather than the base step.")
        protected MarkdownType description;
        @Child(name="step", type={ExampleScenarioProcessStepComponent.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What happens in each alternative option", formalDefinition="What happens in each alternative option.")
        protected List<ExampleScenarioProcessStepComponent> step;
        private static final long serialVersionUID = -254687460L;

        public ExampleScenarioProcessStepAlternativeComponent() {
        }

        public ExampleScenarioProcessStepAlternativeComponent(StringType title) {
            this.title = title;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepAlternativeComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public ExampleScenarioProcessStepAlternativeComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public ExampleScenarioProcessStepAlternativeComponent setTitle(String value) {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepAlternativeComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ExampleScenarioProcessStepAlternativeComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ExampleScenarioProcessStepAlternativeComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<ExampleScenarioProcessStepComponent> getStep() {
            if (this.step == null) {
                this.step = new ArrayList<ExampleScenarioProcessStepComponent>();
            }
            return this.step;
        }

        public ExampleScenarioProcessStepAlternativeComponent setStep(List<ExampleScenarioProcessStepComponent> theStep) {
            this.step = theStep;
            return this;
        }

        public boolean hasStep() {
            if (this.step == null) {
                return false;
            }
            for (ExampleScenarioProcessStepComponent item : this.step) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExampleScenarioProcessStepComponent addStep() {
            ExampleScenarioProcessStepComponent t = new ExampleScenarioProcessStepComponent();
            if (this.step == null) {
                this.step = new ArrayList<ExampleScenarioProcessStepComponent>();
            }
            this.step.add(t);
            return t;
        }

        public ExampleScenarioProcessStepAlternativeComponent addStep(ExampleScenarioProcessStepComponent t) {
            if (t == null) {
                return this;
            }
            if (this.step == null) {
                this.step = new ArrayList<ExampleScenarioProcessStepComponent>();
            }
            this.step.add(t);
            return this;
        }

        public ExampleScenarioProcessStepComponent getStepFirstRep() {
            if (this.getStep().isEmpty()) {
                this.addStep();
            }
            return this.getStep().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("title", "string", "The label to display for the alternative that gives a sense of the circumstance in which the alternative should be invoked.", 0, 1, this.title));
            children.add(new Property("description", "markdown", "A human-readable description of the alternative explaining when the alternative should occur rather than the base step.", 0, 1, this.description));
            children.add(new Property("step", "@ExampleScenario.process.step", "What happens in each alternative option.", 0, Integer.MAX_VALUE, this.step));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 110371416: {
                    return new Property("title", "string", "The label to display for the alternative that gives a sense of the circumstance in which the alternative should be invoked.", 0, 1, this.title);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "A human-readable description of the alternative explaining when the alternative should occur rather than the base step.", 0, 1, this.description);
                }
                case 3540684: {
                    return new Property("step", "@ExampleScenario.process.step", "What happens in each alternative option.", 0, Integer.MAX_VALUE, this.step);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.title;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case 3540684: {
                    return this.step == null ? new Base[]{} : this.step.toArray(new Base[this.step.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    this.title = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToMarkdown(value);
                    return value;
                }
                case 3540684: {
                    this.getStep().add((ExampleScenarioProcessStepComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("title")) {
                this.title = this.castToString(value);
            } else if (name.equals("description")) {
                this.description = this.castToMarkdown(value);
            } else if (name.equals("step")) {
                this.getStep().add((ExampleScenarioProcessStepComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return this.getTitleElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3540684: {
                    return this.addStep();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 3540684: {
                    return new String[]{"@ExampleScenario.process.step"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.title");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.description");
            }
            if (name.equals("step")) {
                return this.addStep();
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioProcessStepAlternativeComponent copy() {
            ExampleScenarioProcessStepAlternativeComponent dst = new ExampleScenarioProcessStepAlternativeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioProcessStepAlternativeComponent dst) {
            super.copyValues(dst);
            dst.title = this.title == null ? null : this.title.copy();
            MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
            if (this.step != null) {
                dst.step = new ArrayList<ExampleScenarioProcessStepComponent>();
                for (ExampleScenarioProcessStepComponent i : this.step) {
                    dst.step.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessStepAlternativeComponent)) {
                return false;
            }
            ExampleScenarioProcessStepAlternativeComponent o = (ExampleScenarioProcessStepAlternativeComponent)other_;
            return ExampleScenarioProcessStepAlternativeComponent.compareDeep(this.title, o.title, true) && ExampleScenarioProcessStepAlternativeComponent.compareDeep(this.description, o.description, true) && ExampleScenarioProcessStepAlternativeComponent.compareDeep(this.step, o.step, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessStepAlternativeComponent)) {
                return false;
            }
            ExampleScenarioProcessStepAlternativeComponent o = (ExampleScenarioProcessStepAlternativeComponent)other_;
            return ExampleScenarioProcessStepAlternativeComponent.compareValues(this.title, o.title, true) && ExampleScenarioProcessStepAlternativeComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.title, this.description, this.step});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.process.step.alternative";
        }
    }

    @Block
    public static class ExampleScenarioProcessStepOperationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="number", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The sequential number of the interaction", formalDefinition="The sequential number of the interaction, e.g. 1.2.5.")
        protected StringType number;
        @Child(name="type", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of operation - CRUD", formalDefinition="The type of operation - CRUD.")
        protected StringType type;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The human-friendly name of the interaction", formalDefinition="The human-friendly name of the interaction.")
        protected StringType name;
        @Child(name="initiator", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who starts the transaction", formalDefinition="Who starts the transaction.")
        protected StringType initiator;
        @Child(name="receiver", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who receives the transaction", formalDefinition="Who receives the transaction.")
        protected StringType receiver;
        @Child(name="description", type={MarkdownType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A comment to be inserted in the diagram", formalDefinition="A comment to be inserted in the diagram.")
        protected MarkdownType description;
        @Child(name="initiatorActive", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the initiator is deactivated right after the transaction", formalDefinition="Whether the initiator is deactivated right after the transaction.")
        protected BooleanType initiatorActive;
        @Child(name="receiverActive", type={BooleanType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the receiver is deactivated right after the transaction", formalDefinition="Whether the receiver is deactivated right after the transaction.")
        protected BooleanType receiverActive;
        @Child(name="request", type={ExampleScenarioInstanceContainedInstanceComponent.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Each resource instance used by the initiator", formalDefinition="Each resource instance used by the initiator.")
        protected ExampleScenarioInstanceContainedInstanceComponent request;
        @Child(name="response", type={ExampleScenarioInstanceContainedInstanceComponent.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Each resource instance used by the responder", formalDefinition="Each resource instance used by the responder.")
        protected ExampleScenarioInstanceContainedInstanceComponent response;
        private static final long serialVersionUID = 911241906L;

        public ExampleScenarioProcessStepOperationComponent() {
        }

        public ExampleScenarioProcessStepOperationComponent(StringType number) {
            this.number = number;
        }

        public StringType getNumberElement() {
            if (this.number == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.number");
                }
                if (Configuration.doAutoCreate()) {
                    this.number = new StringType();
                }
            }
            return this.number;
        }

        public boolean hasNumberElement() {
            return this.number != null && !this.number.isEmpty();
        }

        public boolean hasNumber() {
            return this.number != null && !this.number.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setNumberElement(StringType value) {
            this.number = value;
            return this;
        }

        public String getNumber() {
            return this.number == null ? null : (String)this.number.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setNumber(String value) {
            if (this.number == null) {
                this.number = new StringType();
            }
            this.number.setValue(value);
            return this;
        }

        public StringType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new StringType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setTypeElement(StringType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setType(String value) {
            if (Utilities.noString((String)value)) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new StringType();
                }
                this.type.setValue(value);
            }
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getInitiatorElement() {
            if (this.initiator == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.initiator");
                }
                if (Configuration.doAutoCreate()) {
                    this.initiator = new StringType();
                }
            }
            return this.initiator;
        }

        public boolean hasInitiatorElement() {
            return this.initiator != null && !this.initiator.isEmpty();
        }

        public boolean hasInitiator() {
            return this.initiator != null && !this.initiator.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setInitiatorElement(StringType value) {
            this.initiator = value;
            return this;
        }

        public String getInitiator() {
            return this.initiator == null ? null : (String)this.initiator.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setInitiator(String value) {
            if (Utilities.noString((String)value)) {
                this.initiator = null;
            } else {
                if (this.initiator == null) {
                    this.initiator = new StringType();
                }
                this.initiator.setValue(value);
            }
            return this;
        }

        public StringType getReceiverElement() {
            if (this.receiver == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.receiver");
                }
                if (Configuration.doAutoCreate()) {
                    this.receiver = new StringType();
                }
            }
            return this.receiver;
        }

        public boolean hasReceiverElement() {
            return this.receiver != null && !this.receiver.isEmpty();
        }

        public boolean hasReceiver() {
            return this.receiver != null && !this.receiver.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setReceiverElement(StringType value) {
            this.receiver = value;
            return this;
        }

        public String getReceiver() {
            return this.receiver == null ? null : (String)this.receiver.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setReceiver(String value) {
            if (Utilities.noString((String)value)) {
                this.receiver = null;
            } else {
                if (this.receiver == null) {
                    this.receiver = new StringType();
                }
                this.receiver.setValue(value);
            }
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public BooleanType getInitiatorActiveElement() {
            if (this.initiatorActive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.initiatorActive");
                }
                if (Configuration.doAutoCreate()) {
                    this.initiatorActive = new BooleanType();
                }
            }
            return this.initiatorActive;
        }

        public boolean hasInitiatorActiveElement() {
            return this.initiatorActive != null && !this.initiatorActive.isEmpty();
        }

        public boolean hasInitiatorActive() {
            return this.initiatorActive != null && !this.initiatorActive.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setInitiatorActiveElement(BooleanType value) {
            this.initiatorActive = value;
            return this;
        }

        public boolean getInitiatorActive() {
            return this.initiatorActive == null || this.initiatorActive.isEmpty() ? false : (Boolean)this.initiatorActive.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setInitiatorActive(boolean value) {
            if (this.initiatorActive == null) {
                this.initiatorActive = new BooleanType();
            }
            this.initiatorActive.setValue((Object)value);
            return this;
        }

        public BooleanType getReceiverActiveElement() {
            if (this.receiverActive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.receiverActive");
                }
                if (Configuration.doAutoCreate()) {
                    this.receiverActive = new BooleanType();
                }
            }
            return this.receiverActive;
        }

        public boolean hasReceiverActiveElement() {
            return this.receiverActive != null && !this.receiverActive.isEmpty();
        }

        public boolean hasReceiverActive() {
            return this.receiverActive != null && !this.receiverActive.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setReceiverActiveElement(BooleanType value) {
            this.receiverActive = value;
            return this;
        }

        public boolean getReceiverActive() {
            return this.receiverActive == null || this.receiverActive.isEmpty() ? false : (Boolean)this.receiverActive.getValue();
        }

        public ExampleScenarioProcessStepOperationComponent setReceiverActive(boolean value) {
            if (this.receiverActive == null) {
                this.receiverActive = new BooleanType();
            }
            this.receiverActive.setValue((Object)value);
            return this;
        }

        public ExampleScenarioInstanceContainedInstanceComponent getRequest() {
            if (this.request == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.request");
                }
                if (Configuration.doAutoCreate()) {
                    this.request = new ExampleScenarioInstanceContainedInstanceComponent();
                }
            }
            return this.request;
        }

        public boolean hasRequest() {
            return this.request != null && !this.request.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setRequest(ExampleScenarioInstanceContainedInstanceComponent value) {
            this.request = value;
            return this;
        }

        public ExampleScenarioInstanceContainedInstanceComponent getResponse() {
            if (this.response == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepOperationComponent.response");
                }
                if (Configuration.doAutoCreate()) {
                    this.response = new ExampleScenarioInstanceContainedInstanceComponent();
                }
            }
            return this.response;
        }

        public boolean hasResponse() {
            return this.response != null && !this.response.isEmpty();
        }

        public ExampleScenarioProcessStepOperationComponent setResponse(ExampleScenarioInstanceContainedInstanceComponent value) {
            this.response = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("number", "string", "The sequential number of the interaction, e.g. 1.2.5.", 0, 1, this.number));
            children.add(new Property("type", "string", "The type of operation - CRUD.", 0, 1, this.type));
            children.add(new Property(ExampleScenario.SP_NAME, "string", "The human-friendly name of the interaction.", 0, 1, this.name));
            children.add(new Property("initiator", "string", "Who starts the transaction.", 0, 1, this.initiator));
            children.add(new Property("receiver", "string", "Who receives the transaction.", 0, 1, this.receiver));
            children.add(new Property("description", "markdown", "A comment to be inserted in the diagram.", 0, 1, this.description));
            children.add(new Property("initiatorActive", "boolean", "Whether the initiator is deactivated right after the transaction.", 0, 1, this.initiatorActive));
            children.add(new Property("receiverActive", "boolean", "Whether the receiver is deactivated right after the transaction.", 0, 1, this.receiverActive));
            children.add(new Property("request", "@ExampleScenario.instance.containedInstance", "Each resource instance used by the initiator.", 0, 1, this.request));
            children.add(new Property("response", "@ExampleScenario.instance.containedInstance", "Each resource instance used by the responder.", 0, 1, this.response));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1034364087: {
                    return new Property("number", "string", "The sequential number of the interaction, e.g. 1.2.5.", 0, 1, this.number);
                }
                case 3575610: {
                    return new Property("type", "string", "The type of operation - CRUD.", 0, 1, this.type);
                }
                case 3373707: {
                    return new Property(ExampleScenario.SP_NAME, "string", "The human-friendly name of the interaction.", 0, 1, this.name);
                }
                case -248987089: {
                    return new Property("initiator", "string", "Who starts the transaction.", 0, 1, this.initiator);
                }
                case -808719889: {
                    return new Property("receiver", "string", "Who receives the transaction.", 0, 1, this.receiver);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "A comment to be inserted in the diagram.", 0, 1, this.description);
                }
                case 384339477: {
                    return new Property("initiatorActive", "boolean", "Whether the initiator is deactivated right after the transaction.", 0, 1, this.initiatorActive);
                }
                case -285284907: {
                    return new Property("receiverActive", "boolean", "Whether the receiver is deactivated right after the transaction.", 0, 1, this.receiverActive);
                }
                case 1095692943: {
                    return new Property("request", "@ExampleScenario.instance.containedInstance", "Each resource instance used by the initiator.", 0, 1, this.request);
                }
                case -340323263: {
                    return new Property("response", "@ExampleScenario.instance.containedInstance", "Each resource instance used by the responder.", 0, 1, this.response);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    Base[] baseArray;
                    if (this.number == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.number;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
                case -248987089: {
                    Base[] baseArray;
                    if (this.initiator == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.initiator;
                    }
                    return baseArray;
                }
                case -808719889: {
                    Base[] baseArray;
                    if (this.receiver == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.receiver;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.description;
                    }
                    return baseArray;
                }
                case 384339477: {
                    Base[] baseArray;
                    if (this.initiatorActive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.initiatorActive;
                    }
                    return baseArray;
                }
                case -285284907: {
                    Base[] baseArray;
                    if (this.receiverActive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.receiverActive;
                    }
                    return baseArray;
                }
                case 1095692943: {
                    Base[] baseArray;
                    if (this.request == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.request;
                    }
                    return baseArray;
                }
                case -340323263: {
                    Base[] baseArray;
                    if (this.response == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.response;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    this.number = this.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToString(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case -248987089: {
                    this.initiator = this.castToString(value);
                    return value;
                }
                case -808719889: {
                    this.receiver = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToMarkdown(value);
                    return value;
                }
                case 384339477: {
                    this.initiatorActive = this.castToBoolean(value);
                    return value;
                }
                case -285284907: {
                    this.receiverActive = this.castToBoolean(value);
                    return value;
                }
                case 1095692943: {
                    this.request = (ExampleScenarioInstanceContainedInstanceComponent)value;
                    return value;
                }
                case -340323263: {
                    this.response = (ExampleScenarioInstanceContainedInstanceComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("number")) {
                this.number = this.castToString(value);
            } else if (name.equals("type")) {
                this.type = this.castToString(value);
            } else if (name.equals(ExampleScenario.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("initiator")) {
                this.initiator = this.castToString(value);
            } else if (name.equals("receiver")) {
                this.receiver = this.castToString(value);
            } else if (name.equals("description")) {
                this.description = this.castToMarkdown(value);
            } else if (name.equals("initiatorActive")) {
                this.initiatorActive = this.castToBoolean(value);
            } else if (name.equals("receiverActive")) {
                this.receiverActive = this.castToBoolean(value);
            } else if (name.equals("request")) {
                this.request = (ExampleScenarioInstanceContainedInstanceComponent)value;
            } else if (name.equals("response")) {
                this.response = (ExampleScenarioInstanceContainedInstanceComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    return this.getNumberElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case -248987089: {
                    return this.getInitiatorElement();
                }
                case -808719889: {
                    return this.getReceiverElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 384339477: {
                    return this.getInitiatorActiveElement();
                }
                case -285284907: {
                    return this.getReceiverActiveElement();
                }
                case 1095692943: {
                    return this.getRequest();
                }
                case -340323263: {
                    return this.getResponse();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"string"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case -248987089: {
                    return new String[]{"string"};
                }
                case -808719889: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 384339477: {
                    return new String[]{"boolean"};
                }
                case -285284907: {
                    return new String[]{"boolean"};
                }
                case 1095692943: {
                    return new String[]{"@ExampleScenario.instance.containedInstance"};
                }
                case -340323263: {
                    return new String[]{"@ExampleScenario.instance.containedInstance"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("number")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.number");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.type");
            }
            if (name.equals(ExampleScenario.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.name");
            }
            if (name.equals("initiator")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.initiator");
            }
            if (name.equals("receiver")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.receiver");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.description");
            }
            if (name.equals("initiatorActive")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.initiatorActive");
            }
            if (name.equals("receiverActive")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.receiverActive");
            }
            if (name.equals("request")) {
                this.request = new ExampleScenarioInstanceContainedInstanceComponent();
                return this.request;
            }
            if (name.equals("response")) {
                this.response = new ExampleScenarioInstanceContainedInstanceComponent();
                return this.response;
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioProcessStepOperationComponent copy() {
            ExampleScenarioProcessStepOperationComponent dst = new ExampleScenarioProcessStepOperationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioProcessStepOperationComponent dst) {
            super.copyValues(dst);
            dst.number = this.number == null ? null : this.number.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.initiator = this.initiator == null ? null : this.initiator.copy();
            dst.receiver = this.receiver == null ? null : this.receiver.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.initiatorActive = this.initiatorActive == null ? null : this.initiatorActive.copy();
            dst.receiverActive = this.receiverActive == null ? null : this.receiverActive.copy();
            dst.request = this.request == null ? null : this.request.copy();
            dst.response = this.response == null ? null : this.response.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessStepOperationComponent)) {
                return false;
            }
            ExampleScenarioProcessStepOperationComponent o = (ExampleScenarioProcessStepOperationComponent)other_;
            return ExampleScenarioProcessStepOperationComponent.compareDeep(this.number, o.number, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.type, o.type, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.name, o.name, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.initiator, o.initiator, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.receiver, o.receiver, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.description, o.description, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.initiatorActive, o.initiatorActive, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.receiverActive, o.receiverActive, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.request, o.request, true) && ExampleScenarioProcessStepOperationComponent.compareDeep(this.response, o.response, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessStepOperationComponent)) {
                return false;
            }
            ExampleScenarioProcessStepOperationComponent o = (ExampleScenarioProcessStepOperationComponent)other_;
            return ExampleScenarioProcessStepOperationComponent.compareValues(this.number, o.number, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.type, o.type, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.name, o.name, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.initiator, o.initiator, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.receiver, o.receiver, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.description, o.description, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.initiatorActive, o.initiatorActive, true) && ExampleScenarioProcessStepOperationComponent.compareValues(this.receiverActive, o.receiverActive, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.number, this.type, this.name, this.initiator, this.receiver, this.description, this.initiatorActive, this.receiverActive, this.request, this.response});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.process.step.operation";
        }
    }

    @Block
    public static class ExampleScenarioProcessStepComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="process", type={ExampleScenarioProcessComponent.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested process", formalDefinition="Nested process.")
        protected List<ExampleScenarioProcessComponent> process;
        @Child(name="pause", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If there is a pause in the flow", formalDefinition="If there is a pause in the flow.")
        protected BooleanType pause;
        @Child(name="operation", type={}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Each interaction or action", formalDefinition="Each interaction or action.")
        protected ExampleScenarioProcessStepOperationComponent operation;
        @Child(name="alternative", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Alternate non-typical step action", formalDefinition="Indicates an alternative step that can be taken instead of the operations on the base step in exceptional/atypical circumstances.")
        protected List<ExampleScenarioProcessStepAlternativeComponent> alternative;
        private static final long serialVersionUID = -894029605L;

        public List<ExampleScenarioProcessComponent> getProcess() {
            if (this.process == null) {
                this.process = new ArrayList<ExampleScenarioProcessComponent>();
            }
            return this.process;
        }

        public ExampleScenarioProcessStepComponent setProcess(List<ExampleScenarioProcessComponent> theProcess) {
            this.process = theProcess;
            return this;
        }

        public boolean hasProcess() {
            if (this.process == null) {
                return false;
            }
            for (ExampleScenarioProcessComponent item : this.process) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExampleScenarioProcessComponent addProcess() {
            ExampleScenarioProcessComponent t = new ExampleScenarioProcessComponent();
            if (this.process == null) {
                this.process = new ArrayList<ExampleScenarioProcessComponent>();
            }
            this.process.add(t);
            return t;
        }

        public ExampleScenarioProcessStepComponent addProcess(ExampleScenarioProcessComponent t) {
            if (t == null) {
                return this;
            }
            if (this.process == null) {
                this.process = new ArrayList<ExampleScenarioProcessComponent>();
            }
            this.process.add(t);
            return this;
        }

        public ExampleScenarioProcessComponent getProcessFirstRep() {
            if (this.getProcess().isEmpty()) {
                this.addProcess();
            }
            return this.getProcess().get(0);
        }

        public BooleanType getPauseElement() {
            if (this.pause == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepComponent.pause");
                }
                if (Configuration.doAutoCreate()) {
                    this.pause = new BooleanType();
                }
            }
            return this.pause;
        }

        public boolean hasPauseElement() {
            return this.pause != null && !this.pause.isEmpty();
        }

        public boolean hasPause() {
            return this.pause != null && !this.pause.isEmpty();
        }

        public ExampleScenarioProcessStepComponent setPauseElement(BooleanType value) {
            this.pause = value;
            return this;
        }

        public boolean getPause() {
            return this.pause == null || this.pause.isEmpty() ? false : (Boolean)this.pause.getValue();
        }

        public ExampleScenarioProcessStepComponent setPause(boolean value) {
            if (this.pause == null) {
                this.pause = new BooleanType();
            }
            this.pause.setValue((Object)value);
            return this;
        }

        public ExampleScenarioProcessStepOperationComponent getOperation() {
            if (this.operation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessStepComponent.operation");
                }
                if (Configuration.doAutoCreate()) {
                    this.operation = new ExampleScenarioProcessStepOperationComponent();
                }
            }
            return this.operation;
        }

        public boolean hasOperation() {
            return this.operation != null && !this.operation.isEmpty();
        }

        public ExampleScenarioProcessStepComponent setOperation(ExampleScenarioProcessStepOperationComponent value) {
            this.operation = value;
            return this;
        }

        public List<ExampleScenarioProcessStepAlternativeComponent> getAlternative() {
            if (this.alternative == null) {
                this.alternative = new ArrayList<ExampleScenarioProcessStepAlternativeComponent>();
            }
            return this.alternative;
        }

        public ExampleScenarioProcessStepComponent setAlternative(List<ExampleScenarioProcessStepAlternativeComponent> theAlternative) {
            this.alternative = theAlternative;
            return this;
        }

        public boolean hasAlternative() {
            if (this.alternative == null) {
                return false;
            }
            for (ExampleScenarioProcessStepAlternativeComponent item : this.alternative) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExampleScenarioProcessStepAlternativeComponent addAlternative() {
            ExampleScenarioProcessStepAlternativeComponent t = new ExampleScenarioProcessStepAlternativeComponent();
            if (this.alternative == null) {
                this.alternative = new ArrayList<ExampleScenarioProcessStepAlternativeComponent>();
            }
            this.alternative.add(t);
            return t;
        }

        public ExampleScenarioProcessStepComponent addAlternative(ExampleScenarioProcessStepAlternativeComponent t) {
            if (t == null) {
                return this;
            }
            if (this.alternative == null) {
                this.alternative = new ArrayList<ExampleScenarioProcessStepAlternativeComponent>();
            }
            this.alternative.add(t);
            return this;
        }

        public ExampleScenarioProcessStepAlternativeComponent getAlternativeFirstRep() {
            if (this.getAlternative().isEmpty()) {
                this.addAlternative();
            }
            return this.getAlternative().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("process", "@ExampleScenario.process", "Nested process.", 0, Integer.MAX_VALUE, this.process));
            children.add(new Property("pause", "boolean", "If there is a pause in the flow.", 0, 1, this.pause));
            children.add(new Property("operation", "", "Each interaction or action.", 0, 1, this.operation));
            children.add(new Property("alternative", "", "Indicates an alternative step that can be taken instead of the operations on the base step in exceptional/atypical circumstances.", 0, Integer.MAX_VALUE, this.alternative));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -309518737: {
                    return new Property("process", "@ExampleScenario.process", "Nested process.", 0, Integer.MAX_VALUE, this.process);
                }
                case 106440182: {
                    return new Property("pause", "boolean", "If there is a pause in the flow.", 0, 1, this.pause);
                }
                case 1662702951: {
                    return new Property("operation", "", "Each interaction or action.", 0, 1, this.operation);
                }
                case -196794451: {
                    return new Property("alternative", "", "Indicates an alternative step that can be taken instead of the operations on the base step in exceptional/atypical circumstances.", 0, Integer.MAX_VALUE, this.alternative);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -309518737: {
                    return this.process == null ? new Base[]{} : this.process.toArray(new Base[this.process.size()]);
                }
                case 106440182: {
                    Base[] baseArray;
                    if (this.pause == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.pause;
                    }
                    return baseArray;
                }
                case 1662702951: {
                    Base[] baseArray;
                    if (this.operation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.operation;
                    }
                    return baseArray;
                }
                case -196794451: {
                    return this.alternative == null ? new Base[]{} : this.alternative.toArray(new Base[this.alternative.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -309518737: {
                    this.getProcess().add((ExampleScenarioProcessComponent)value);
                    return value;
                }
                case 106440182: {
                    this.pause = this.castToBoolean(value);
                    return value;
                }
                case 1662702951: {
                    this.operation = (ExampleScenarioProcessStepOperationComponent)value;
                    return value;
                }
                case -196794451: {
                    this.getAlternative().add((ExampleScenarioProcessStepAlternativeComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("process")) {
                this.getProcess().add((ExampleScenarioProcessComponent)value);
            } else if (name.equals("pause")) {
                this.pause = this.castToBoolean(value);
            } else if (name.equals("operation")) {
                this.operation = (ExampleScenarioProcessStepOperationComponent)value;
            } else if (name.equals("alternative")) {
                this.getAlternative().add((ExampleScenarioProcessStepAlternativeComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -309518737: {
                    return this.addProcess();
                }
                case 106440182: {
                    return this.getPauseElement();
                }
                case 1662702951: {
                    return this.getOperation();
                }
                case -196794451: {
                    return this.addAlternative();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -309518737: {
                    return new String[]{"@ExampleScenario.process"};
                }
                case 106440182: {
                    return new String[]{"boolean"};
                }
                case 1662702951: {
                    return new String[0];
                }
                case -196794451: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("process")) {
                return this.addProcess();
            }
            if (name.equals("pause")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.pause");
            }
            if (name.equals("operation")) {
                this.operation = new ExampleScenarioProcessStepOperationComponent();
                return this.operation;
            }
            if (name.equals("alternative")) {
                return this.addAlternative();
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioProcessStepComponent copy() {
            ExampleScenarioProcessStepComponent dst = new ExampleScenarioProcessStepComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioProcessStepComponent dst) {
            super.copyValues(dst);
            if (this.process != null) {
                dst.process = new ArrayList<ExampleScenarioProcessComponent>();
                for (ExampleScenarioProcessComponent exampleScenarioProcessComponent : this.process) {
                    dst.process.add(exampleScenarioProcessComponent.copy());
                }
            }
            dst.pause = this.pause == null ? null : this.pause.copy();
            ExampleScenarioProcessStepOperationComponent exampleScenarioProcessStepOperationComponent = dst.operation = this.operation == null ? null : this.operation.copy();
            if (this.alternative != null) {
                dst.alternative = new ArrayList<ExampleScenarioProcessStepAlternativeComponent>();
                for (ExampleScenarioProcessStepAlternativeComponent exampleScenarioProcessStepAlternativeComponent : this.alternative) {
                    dst.alternative.add(exampleScenarioProcessStepAlternativeComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessStepComponent)) {
                return false;
            }
            ExampleScenarioProcessStepComponent o = (ExampleScenarioProcessStepComponent)other_;
            return ExampleScenarioProcessStepComponent.compareDeep(this.process, o.process, true) && ExampleScenarioProcessStepComponent.compareDeep(this.pause, o.pause, true) && ExampleScenarioProcessStepComponent.compareDeep(this.operation, o.operation, true) && ExampleScenarioProcessStepComponent.compareDeep(this.alternative, o.alternative, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessStepComponent)) {
                return false;
            }
            ExampleScenarioProcessStepComponent o = (ExampleScenarioProcessStepComponent)other_;
            return ExampleScenarioProcessStepComponent.compareValues(this.pause, o.pause, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.process, this.pause, this.operation, this.alternative});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.process.step";
        }
    }

    @Block
    public static class ExampleScenarioProcessComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="title", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The diagram title of the group of operations", formalDefinition="The diagram title of the group of operations.")
        protected StringType title;
        @Child(name="description", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A longer description of the group of operations", formalDefinition="A longer description of the group of operations.")
        protected MarkdownType description;
        @Child(name="preConditions", type={MarkdownType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of initial status before the process starts", formalDefinition="Description of initial status before the process starts.")
        protected MarkdownType preConditions;
        @Child(name="postConditions", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of final status after the process ends", formalDefinition="Description of final status after the process ends.")
        protected MarkdownType postConditions;
        @Child(name="step", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Each step of the process", formalDefinition="Each step of the process.")
        protected List<ExampleScenarioProcessStepComponent> step;
        private static final long serialVersionUID = 325578043L;

        public ExampleScenarioProcessComponent() {
        }

        public ExampleScenarioProcessComponent(StringType title) {
            this.title = title;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public ExampleScenarioProcessComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public ExampleScenarioProcessComponent setTitle(String value) {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ExampleScenarioProcessComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ExampleScenarioProcessComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public MarkdownType getPreConditionsElement() {
            if (this.preConditions == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessComponent.preConditions");
                }
                if (Configuration.doAutoCreate()) {
                    this.preConditions = new MarkdownType();
                }
            }
            return this.preConditions;
        }

        public boolean hasPreConditionsElement() {
            return this.preConditions != null && !this.preConditions.isEmpty();
        }

        public boolean hasPreConditions() {
            return this.preConditions != null && !this.preConditions.isEmpty();
        }

        public ExampleScenarioProcessComponent setPreConditionsElement(MarkdownType value) {
            this.preConditions = value;
            return this;
        }

        public String getPreConditions() {
            return this.preConditions == null ? null : (String)this.preConditions.getValue();
        }

        public ExampleScenarioProcessComponent setPreConditions(String value) {
            if (value == null) {
                this.preConditions = null;
            } else {
                if (this.preConditions == null) {
                    this.preConditions = new MarkdownType();
                }
                this.preConditions.setValue(value);
            }
            return this;
        }

        public MarkdownType getPostConditionsElement() {
            if (this.postConditions == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioProcessComponent.postConditions");
                }
                if (Configuration.doAutoCreate()) {
                    this.postConditions = new MarkdownType();
                }
            }
            return this.postConditions;
        }

        public boolean hasPostConditionsElement() {
            return this.postConditions != null && !this.postConditions.isEmpty();
        }

        public boolean hasPostConditions() {
            return this.postConditions != null && !this.postConditions.isEmpty();
        }

        public ExampleScenarioProcessComponent setPostConditionsElement(MarkdownType value) {
            this.postConditions = value;
            return this;
        }

        public String getPostConditions() {
            return this.postConditions == null ? null : (String)this.postConditions.getValue();
        }

        public ExampleScenarioProcessComponent setPostConditions(String value) {
            if (value == null) {
                this.postConditions = null;
            } else {
                if (this.postConditions == null) {
                    this.postConditions = new MarkdownType();
                }
                this.postConditions.setValue(value);
            }
            return this;
        }

        public List<ExampleScenarioProcessStepComponent> getStep() {
            if (this.step == null) {
                this.step = new ArrayList<ExampleScenarioProcessStepComponent>();
            }
            return this.step;
        }

        public ExampleScenarioProcessComponent setStep(List<ExampleScenarioProcessStepComponent> theStep) {
            this.step = theStep;
            return this;
        }

        public boolean hasStep() {
            if (this.step == null) {
                return false;
            }
            for (ExampleScenarioProcessStepComponent item : this.step) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExampleScenarioProcessStepComponent addStep() {
            ExampleScenarioProcessStepComponent t = new ExampleScenarioProcessStepComponent();
            if (this.step == null) {
                this.step = new ArrayList<ExampleScenarioProcessStepComponent>();
            }
            this.step.add(t);
            return t;
        }

        public ExampleScenarioProcessComponent addStep(ExampleScenarioProcessStepComponent t) {
            if (t == null) {
                return this;
            }
            if (this.step == null) {
                this.step = new ArrayList<ExampleScenarioProcessStepComponent>();
            }
            this.step.add(t);
            return this;
        }

        public ExampleScenarioProcessStepComponent getStepFirstRep() {
            if (this.getStep().isEmpty()) {
                this.addStep();
            }
            return this.getStep().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("title", "string", "The diagram title of the group of operations.", 0, 1, this.title));
            children.add(new Property("description", "markdown", "A longer description of the group of operations.", 0, 1, this.description));
            children.add(new Property("preConditions", "markdown", "Description of initial status before the process starts.", 0, 1, this.preConditions));
            children.add(new Property("postConditions", "markdown", "Description of final status after the process ends.", 0, 1, this.postConditions));
            children.add(new Property("step", "", "Each step of the process.", 0, Integer.MAX_VALUE, this.step));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 110371416: {
                    return new Property("title", "string", "The diagram title of the group of operations.", 0, 1, this.title);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "A longer description of the group of operations.", 0, 1, this.description);
                }
                case -1006692933: {
                    return new Property("preConditions", "markdown", "Description of initial status before the process starts.", 0, 1, this.preConditions);
                }
                case 1738302328: {
                    return new Property("postConditions", "markdown", "Description of final status after the process ends.", 0, 1, this.postConditions);
                }
                case 3540684: {
                    return new Property("step", "", "Each step of the process.", 0, Integer.MAX_VALUE, this.step);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.title;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -1006692933: {
                    Base[] baseArray;
                    if (this.preConditions == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.preConditions;
                    }
                    return baseArray;
                }
                case 1738302328: {
                    Base[] baseArray;
                    if (this.postConditions == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.postConditions;
                    }
                    return baseArray;
                }
                case 3540684: {
                    return this.step == null ? new Base[]{} : this.step.toArray(new Base[this.step.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    this.title = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToMarkdown(value);
                    return value;
                }
                case -1006692933: {
                    this.preConditions = this.castToMarkdown(value);
                    return value;
                }
                case 1738302328: {
                    this.postConditions = this.castToMarkdown(value);
                    return value;
                }
                case 3540684: {
                    this.getStep().add((ExampleScenarioProcessStepComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("title")) {
                this.title = this.castToString(value);
            } else if (name.equals("description")) {
                this.description = this.castToMarkdown(value);
            } else if (name.equals("preConditions")) {
                this.preConditions = this.castToMarkdown(value);
            } else if (name.equals("postConditions")) {
                this.postConditions = this.castToMarkdown(value);
            } else if (name.equals("step")) {
                this.getStep().add((ExampleScenarioProcessStepComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return this.getTitleElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1006692933: {
                    return this.getPreConditionsElement();
                }
                case 1738302328: {
                    return this.getPostConditionsElement();
                }
                case 3540684: {
                    return this.addStep();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case -1006692933: {
                    return new String[]{"markdown"};
                }
                case 1738302328: {
                    return new String[]{"markdown"};
                }
                case 3540684: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.title");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.description");
            }
            if (name.equals("preConditions")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.preConditions");
            }
            if (name.equals("postConditions")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.postConditions");
            }
            if (name.equals("step")) {
                return this.addStep();
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioProcessComponent copy() {
            ExampleScenarioProcessComponent dst = new ExampleScenarioProcessComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioProcessComponent dst) {
            super.copyValues(dst);
            dst.title = this.title == null ? null : this.title.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.preConditions = this.preConditions == null ? null : this.preConditions.copy();
            MarkdownType markdownType = dst.postConditions = this.postConditions == null ? null : this.postConditions.copy();
            if (this.step != null) {
                dst.step = new ArrayList<ExampleScenarioProcessStepComponent>();
                for (ExampleScenarioProcessStepComponent i : this.step) {
                    dst.step.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessComponent)) {
                return false;
            }
            ExampleScenarioProcessComponent o = (ExampleScenarioProcessComponent)other_;
            return ExampleScenarioProcessComponent.compareDeep(this.title, o.title, true) && ExampleScenarioProcessComponent.compareDeep(this.description, o.description, true) && ExampleScenarioProcessComponent.compareDeep(this.preConditions, o.preConditions, true) && ExampleScenarioProcessComponent.compareDeep(this.postConditions, o.postConditions, true) && ExampleScenarioProcessComponent.compareDeep(this.step, o.step, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioProcessComponent)) {
                return false;
            }
            ExampleScenarioProcessComponent o = (ExampleScenarioProcessComponent)other_;
            return ExampleScenarioProcessComponent.compareValues(this.title, o.title, true) && ExampleScenarioProcessComponent.compareValues(this.description, o.description, true) && ExampleScenarioProcessComponent.compareValues(this.preConditions, o.preConditions, true) && ExampleScenarioProcessComponent.compareValues(this.postConditions, o.postConditions, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.title, this.description, this.preConditions, this.postConditions, this.step});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.process";
        }
    }

    @Block
    public static class ExampleScenarioInstanceContainedInstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="resourceId", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Each resource contained in the instance", formalDefinition="Each resource contained in the instance.")
        protected StringType resourceId;
        @Child(name="versionId", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A specific version of a resource contained in the instance", formalDefinition="A specific version of a resource contained in the instance.")
        protected StringType versionId;
        private static final long serialVersionUID = 908084124L;

        public ExampleScenarioInstanceContainedInstanceComponent() {
        }

        public ExampleScenarioInstanceContainedInstanceComponent(StringType resourceId) {
            this.resourceId = resourceId;
        }

        public StringType getResourceIdElement() {
            if (this.resourceId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceContainedInstanceComponent.resourceId");
                }
                if (Configuration.doAutoCreate()) {
                    this.resourceId = new StringType();
                }
            }
            return this.resourceId;
        }

        public boolean hasResourceIdElement() {
            return this.resourceId != null && !this.resourceId.isEmpty();
        }

        public boolean hasResourceId() {
            return this.resourceId != null && !this.resourceId.isEmpty();
        }

        public ExampleScenarioInstanceContainedInstanceComponent setResourceIdElement(StringType value) {
            this.resourceId = value;
            return this;
        }

        public String getResourceId() {
            return this.resourceId == null ? null : (String)this.resourceId.getValue();
        }

        public ExampleScenarioInstanceContainedInstanceComponent setResourceId(String value) {
            if (this.resourceId == null) {
                this.resourceId = new StringType();
            }
            this.resourceId.setValue(value);
            return this;
        }

        public StringType getVersionIdElement() {
            if (this.versionId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceContainedInstanceComponent.versionId");
                }
                if (Configuration.doAutoCreate()) {
                    this.versionId = new StringType();
                }
            }
            return this.versionId;
        }

        public boolean hasVersionIdElement() {
            return this.versionId != null && !this.versionId.isEmpty();
        }

        public boolean hasVersionId() {
            return this.versionId != null && !this.versionId.isEmpty();
        }

        public ExampleScenarioInstanceContainedInstanceComponent setVersionIdElement(StringType value) {
            this.versionId = value;
            return this;
        }

        public String getVersionId() {
            return this.versionId == null ? null : (String)this.versionId.getValue();
        }

        public ExampleScenarioInstanceContainedInstanceComponent setVersionId(String value) {
            if (Utilities.noString((String)value)) {
                this.versionId = null;
            } else {
                if (this.versionId == null) {
                    this.versionId = new StringType();
                }
                this.versionId.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("resourceId", "string", "Each resource contained in the instance.", 0, 1, this.resourceId));
            children.add(new Property("versionId", "string", "A specific version of a resource contained in the instance.", 0, 1, this.versionId));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1345650231: {
                    return new Property("resourceId", "string", "Each resource contained in the instance.", 0, 1, this.resourceId);
                }
                case -1407102957: {
                    return new Property("versionId", "string", "A specific version of a resource contained in the instance.", 0, 1, this.versionId);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1345650231: {
                    Base[] baseArray;
                    if (this.resourceId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.resourceId;
                    }
                    return baseArray;
                }
                case -1407102957: {
                    Base[] baseArray;
                    if (this.versionId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.versionId;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1345650231: {
                    this.resourceId = this.castToString(value);
                    return value;
                }
                case -1407102957: {
                    this.versionId = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("resourceId")) {
                this.resourceId = this.castToString(value);
            } else if (name.equals("versionId")) {
                this.versionId = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1345650231: {
                    return this.getResourceIdElement();
                }
                case -1407102957: {
                    return this.getVersionIdElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1345650231: {
                    return new String[]{"string"};
                }
                case -1407102957: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("resourceId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.resourceId");
            }
            if (name.equals("versionId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.versionId");
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioInstanceContainedInstanceComponent copy() {
            ExampleScenarioInstanceContainedInstanceComponent dst = new ExampleScenarioInstanceContainedInstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioInstanceContainedInstanceComponent dst) {
            super.copyValues(dst);
            dst.resourceId = this.resourceId == null ? null : this.resourceId.copy();
            dst.versionId = this.versionId == null ? null : this.versionId.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioInstanceContainedInstanceComponent)) {
                return false;
            }
            ExampleScenarioInstanceContainedInstanceComponent o = (ExampleScenarioInstanceContainedInstanceComponent)other_;
            return ExampleScenarioInstanceContainedInstanceComponent.compareDeep(this.resourceId, o.resourceId, true) && ExampleScenarioInstanceContainedInstanceComponent.compareDeep(this.versionId, o.versionId, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioInstanceContainedInstanceComponent)) {
                return false;
            }
            ExampleScenarioInstanceContainedInstanceComponent o = (ExampleScenarioInstanceContainedInstanceComponent)other_;
            return ExampleScenarioInstanceContainedInstanceComponent.compareValues(this.resourceId, o.resourceId, true) && ExampleScenarioInstanceContainedInstanceComponent.compareValues(this.versionId, o.versionId, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.resourceId, this.versionId});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.instance.containedInstance";
        }
    }

    @Block
    public static class ExampleScenarioInstanceVersionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="versionId", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The identifier of a specific version of a resource", formalDefinition="The identifier of a specific version of a resource.")
        protected StringType versionId;
        @Child(name="description", type={MarkdownType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The description of the resource version", formalDefinition="The description of the resource version.")
        protected MarkdownType description;
        private static final long serialVersionUID = 960821913L;

        public ExampleScenarioInstanceVersionComponent() {
        }

        public ExampleScenarioInstanceVersionComponent(StringType versionId, MarkdownType description) {
            this.versionId = versionId;
            this.description = description;
        }

        public StringType getVersionIdElement() {
            if (this.versionId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceVersionComponent.versionId");
                }
                if (Configuration.doAutoCreate()) {
                    this.versionId = new StringType();
                }
            }
            return this.versionId;
        }

        public boolean hasVersionIdElement() {
            return this.versionId != null && !this.versionId.isEmpty();
        }

        public boolean hasVersionId() {
            return this.versionId != null && !this.versionId.isEmpty();
        }

        public ExampleScenarioInstanceVersionComponent setVersionIdElement(StringType value) {
            this.versionId = value;
            return this;
        }

        public String getVersionId() {
            return this.versionId == null ? null : (String)this.versionId.getValue();
        }

        public ExampleScenarioInstanceVersionComponent setVersionId(String value) {
            if (this.versionId == null) {
                this.versionId = new StringType();
            }
            this.versionId.setValue(value);
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceVersionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ExampleScenarioInstanceVersionComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ExampleScenarioInstanceVersionComponent setDescription(String value) {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("versionId", "string", "The identifier of a specific version of a resource.", 0, 1, this.versionId));
            children.add(new Property("description", "markdown", "The description of the resource version.", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1407102957: {
                    return new Property("versionId", "string", "The identifier of a specific version of a resource.", 0, 1, this.versionId);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "The description of the resource version.", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1407102957: {
                    Base[] baseArray;
                    if (this.versionId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.versionId;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1407102957: {
                    this.versionId = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("versionId")) {
                this.versionId = this.castToString(value);
            } else if (name.equals("description")) {
                this.description = this.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1407102957: {
                    return this.getVersionIdElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1407102957: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("versionId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.versionId");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.description");
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioInstanceVersionComponent copy() {
            ExampleScenarioInstanceVersionComponent dst = new ExampleScenarioInstanceVersionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioInstanceVersionComponent dst) {
            super.copyValues(dst);
            dst.versionId = this.versionId == null ? null : this.versionId.copy();
            dst.description = this.description == null ? null : this.description.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioInstanceVersionComponent)) {
                return false;
            }
            ExampleScenarioInstanceVersionComponent o = (ExampleScenarioInstanceVersionComponent)other_;
            return ExampleScenarioInstanceVersionComponent.compareDeep(this.versionId, o.versionId, true) && ExampleScenarioInstanceVersionComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioInstanceVersionComponent)) {
                return false;
            }
            ExampleScenarioInstanceVersionComponent o = (ExampleScenarioInstanceVersionComponent)other_;
            return ExampleScenarioInstanceVersionComponent.compareValues(this.versionId, o.versionId, true) && ExampleScenarioInstanceVersionComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.versionId, this.description});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.instance.version";
        }
    }

    @Block
    public static class ExampleScenarioInstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="resourceId", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The id of the resource for referencing", formalDefinition="The id of the resource for referencing.")
        protected StringType resourceId;
        @Child(name="resourceType", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of the resource", formalDefinition="The type of the resource.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
        protected Enumeration<FHIRResourceType> resourceType;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A short name for the resource instance", formalDefinition="A short name for the resource instance.")
        protected StringType name;
        @Child(name="description", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human-friendly description of the resource instance", formalDefinition="Human-friendly description of the resource instance.")
        protected MarkdownType description;
        @Child(name="version", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A specific version of the resource", formalDefinition="A specific version of the resource.")
        protected List<ExampleScenarioInstanceVersionComponent> version;
        @Child(name="containedInstance", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Resources contained in the instance", formalDefinition="Resources contained in the instance (e.g. the observations contained in a bundle).")
        protected List<ExampleScenarioInstanceContainedInstanceComponent> containedInstance;
        private static final long serialVersionUID = -1131860669L;

        public ExampleScenarioInstanceComponent() {
        }

        public ExampleScenarioInstanceComponent(StringType resourceId, Enumeration<FHIRResourceType> resourceType) {
            this.resourceId = resourceId;
            this.resourceType = resourceType;
        }

        public StringType getResourceIdElement() {
            if (this.resourceId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceComponent.resourceId");
                }
                if (Configuration.doAutoCreate()) {
                    this.resourceId = new StringType();
                }
            }
            return this.resourceId;
        }

        public boolean hasResourceIdElement() {
            return this.resourceId != null && !this.resourceId.isEmpty();
        }

        public boolean hasResourceId() {
            return this.resourceId != null && !this.resourceId.isEmpty();
        }

        public ExampleScenarioInstanceComponent setResourceIdElement(StringType value) {
            this.resourceId = value;
            return this;
        }

        public String getResourceId() {
            return this.resourceId == null ? null : (String)this.resourceId.getValue();
        }

        public ExampleScenarioInstanceComponent setResourceId(String value) {
            if (this.resourceId == null) {
                this.resourceId = new StringType();
            }
            this.resourceId.setValue(value);
            return this;
        }

        public Enumeration<FHIRResourceType> getResourceTypeElement() {
            if (this.resourceType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceComponent.resourceType");
                }
                if (Configuration.doAutoCreate()) {
                    this.resourceType = new Enumeration<FHIRResourceType>(new FHIRResourceTypeEnumFactory());
                }
            }
            return this.resourceType;
        }

        public boolean hasResourceTypeElement() {
            return this.resourceType != null && !this.resourceType.isEmpty();
        }

        public boolean hasResourceType() {
            return this.resourceType != null && !this.resourceType.isEmpty();
        }

        public ExampleScenarioInstanceComponent setResourceTypeElement(Enumeration<FHIRResourceType> value) {
            this.resourceType = value;
            return this;
        }

        public FHIRResourceType getResourceType() {
            return this.resourceType == null ? null : (FHIRResourceType)((Object)this.resourceType.getValue());
        }

        public ExampleScenarioInstanceComponent setResourceType(FHIRResourceType value) {
            if (this.resourceType == null) {
                this.resourceType = new Enumeration<FHIRResourceType>(new FHIRResourceTypeEnumFactory());
            }
            this.resourceType.setValue((Object)value);
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ExampleScenarioInstanceComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ExampleScenarioInstanceComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioInstanceComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ExampleScenarioInstanceComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ExampleScenarioInstanceComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<ExampleScenarioInstanceVersionComponent> getVersion() {
            if (this.version == null) {
                this.version = new ArrayList<ExampleScenarioInstanceVersionComponent>();
            }
            return this.version;
        }

        public ExampleScenarioInstanceComponent setVersion(List<ExampleScenarioInstanceVersionComponent> theVersion) {
            this.version = theVersion;
            return this;
        }

        public boolean hasVersion() {
            if (this.version == null) {
                return false;
            }
            for (ExampleScenarioInstanceVersionComponent item : this.version) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExampleScenarioInstanceVersionComponent addVersion() {
            ExampleScenarioInstanceVersionComponent t = new ExampleScenarioInstanceVersionComponent();
            if (this.version == null) {
                this.version = new ArrayList<ExampleScenarioInstanceVersionComponent>();
            }
            this.version.add(t);
            return t;
        }

        public ExampleScenarioInstanceComponent addVersion(ExampleScenarioInstanceVersionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.version == null) {
                this.version = new ArrayList<ExampleScenarioInstanceVersionComponent>();
            }
            this.version.add(t);
            return this;
        }

        public ExampleScenarioInstanceVersionComponent getVersionFirstRep() {
            if (this.getVersion().isEmpty()) {
                this.addVersion();
            }
            return this.getVersion().get(0);
        }

        public List<ExampleScenarioInstanceContainedInstanceComponent> getContainedInstance() {
            if (this.containedInstance == null) {
                this.containedInstance = new ArrayList<ExampleScenarioInstanceContainedInstanceComponent>();
            }
            return this.containedInstance;
        }

        public ExampleScenarioInstanceComponent setContainedInstance(List<ExampleScenarioInstanceContainedInstanceComponent> theContainedInstance) {
            this.containedInstance = theContainedInstance;
            return this;
        }

        public boolean hasContainedInstance() {
            if (this.containedInstance == null) {
                return false;
            }
            for (ExampleScenarioInstanceContainedInstanceComponent item : this.containedInstance) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExampleScenarioInstanceContainedInstanceComponent addContainedInstance() {
            ExampleScenarioInstanceContainedInstanceComponent t = new ExampleScenarioInstanceContainedInstanceComponent();
            if (this.containedInstance == null) {
                this.containedInstance = new ArrayList<ExampleScenarioInstanceContainedInstanceComponent>();
            }
            this.containedInstance.add(t);
            return t;
        }

        public ExampleScenarioInstanceComponent addContainedInstance(ExampleScenarioInstanceContainedInstanceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.containedInstance == null) {
                this.containedInstance = new ArrayList<ExampleScenarioInstanceContainedInstanceComponent>();
            }
            this.containedInstance.add(t);
            return this;
        }

        public ExampleScenarioInstanceContainedInstanceComponent getContainedInstanceFirstRep() {
            if (this.getContainedInstance().isEmpty()) {
                this.addContainedInstance();
            }
            return this.getContainedInstance().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("resourceId", "string", "The id of the resource for referencing.", 0, 1, this.resourceId));
            children.add(new Property("resourceType", "code", "The type of the resource.", 0, 1, this.resourceType));
            children.add(new Property(ExampleScenario.SP_NAME, "string", "A short name for the resource instance.", 0, 1, this.name));
            children.add(new Property("description", "markdown", "Human-friendly description of the resource instance.", 0, 1, this.description));
            children.add(new Property(ExampleScenario.SP_VERSION, "", "A specific version of the resource.", 0, Integer.MAX_VALUE, this.version));
            children.add(new Property("containedInstance", "", "Resources contained in the instance (e.g. the observations contained in a bundle).", 0, Integer.MAX_VALUE, this.containedInstance));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1345650231: {
                    return new Property("resourceId", "string", "The id of the resource for referencing.", 0, 1, this.resourceId);
                }
                case -384364440: {
                    return new Property("resourceType", "code", "The type of the resource.", 0, 1, this.resourceType);
                }
                case 3373707: {
                    return new Property(ExampleScenario.SP_NAME, "string", "A short name for the resource instance.", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "Human-friendly description of the resource instance.", 0, 1, this.description);
                }
                case 351608024: {
                    return new Property(ExampleScenario.SP_VERSION, "", "A specific version of the resource.", 0, Integer.MAX_VALUE, this.version);
                }
                case -417062360: {
                    return new Property("containedInstance", "", "Resources contained in the instance (e.g. the observations contained in a bundle).", 0, Integer.MAX_VALUE, this.containedInstance);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1345650231: {
                    Base[] baseArray;
                    if (this.resourceId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.resourceId;
                    }
                    return baseArray;
                }
                case -384364440: {
                    Base[] baseArray;
                    if (this.resourceType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resourceType;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
                case 351608024: {
                    return this.version == null ? new Base[]{} : this.version.toArray(new Base[this.version.size()]);
                }
                case -417062360: {
                    return this.containedInstance == null ? new Base[]{} : this.containedInstance.toArray(new Base[this.containedInstance.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1345650231: {
                    this.resourceId = this.castToString(value);
                    return value;
                }
                case -384364440: {
                    value = new FHIRResourceTypeEnumFactory().fromType(this.castToCode(value));
                    this.resourceType = value;
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToMarkdown(value);
                    return value;
                }
                case 351608024: {
                    this.getVersion().add((ExampleScenarioInstanceVersionComponent)((Object)value));
                    return value;
                }
                case -417062360: {
                    this.getContainedInstance().add((ExampleScenarioInstanceContainedInstanceComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("resourceId")) {
                this.resourceId = this.castToString(value);
            } else if (name.equals("resourceType")) {
                value = new FHIRResourceTypeEnumFactory().fromType(this.castToCode(value));
                this.resourceType = value;
            } else if (name.equals(ExampleScenario.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("description")) {
                this.description = this.castToMarkdown(value);
            } else if (name.equals(ExampleScenario.SP_VERSION)) {
                this.getVersion().add((ExampleScenarioInstanceVersionComponent)((Object)value));
            } else if (name.equals("containedInstance")) {
                this.getContainedInstance().add((ExampleScenarioInstanceContainedInstanceComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1345650231: {
                    return this.getResourceIdElement();
                }
                case -384364440: {
                    return this.getResourceTypeElement();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 351608024: {
                    return this.addVersion();
                }
                case -417062360: {
                    return this.addContainedInstance();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1345650231: {
                    return new String[]{"string"};
                }
                case -384364440: {
                    return new String[]{"code"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 351608024: {
                    return new String[0];
                }
                case -417062360: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("resourceId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.resourceId");
            }
            if (name.equals("resourceType")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.resourceType");
            }
            if (name.equals(ExampleScenario.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.name");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.description");
            }
            if (name.equals(ExampleScenario.SP_VERSION)) {
                return this.addVersion();
            }
            if (name.equals("containedInstance")) {
                return this.addContainedInstance();
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioInstanceComponent copy() {
            ExampleScenarioInstanceComponent dst = new ExampleScenarioInstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioInstanceComponent dst) {
            super.copyValues(dst);
            dst.resourceId = this.resourceId == null ? null : this.resourceId.copy();
            dst.resourceType = this.resourceType == null ? null : this.resourceType.copy();
            dst.name = this.name == null ? null : this.name.copy();
            MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
            if (this.version != null) {
                dst.version = new ArrayList<ExampleScenarioInstanceVersionComponent>();
                for (ExampleScenarioInstanceVersionComponent exampleScenarioInstanceVersionComponent : this.version) {
                    dst.version.add(exampleScenarioInstanceVersionComponent.copy());
                }
            }
            if (this.containedInstance != null) {
                dst.containedInstance = new ArrayList<ExampleScenarioInstanceContainedInstanceComponent>();
                for (ExampleScenarioInstanceContainedInstanceComponent exampleScenarioInstanceContainedInstanceComponent : this.containedInstance) {
                    dst.containedInstance.add(exampleScenarioInstanceContainedInstanceComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioInstanceComponent)) {
                return false;
            }
            ExampleScenarioInstanceComponent o = (ExampleScenarioInstanceComponent)other_;
            return ExampleScenarioInstanceComponent.compareDeep(this.resourceId, o.resourceId, true) && ExampleScenarioInstanceComponent.compareDeep(this.resourceType, o.resourceType, true) && ExampleScenarioInstanceComponent.compareDeep(this.name, o.name, true) && ExampleScenarioInstanceComponent.compareDeep(this.description, o.description, true) && ExampleScenarioInstanceComponent.compareDeep(this.version, o.version, true) && ExampleScenarioInstanceComponent.compareDeep(this.containedInstance, o.containedInstance, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioInstanceComponent)) {
                return false;
            }
            ExampleScenarioInstanceComponent o = (ExampleScenarioInstanceComponent)other_;
            return ExampleScenarioInstanceComponent.compareValues(this.resourceId, o.resourceId, true) && ExampleScenarioInstanceComponent.compareValues(this.resourceType, o.resourceType, true) && ExampleScenarioInstanceComponent.compareValues(this.name, o.name, true) && ExampleScenarioInstanceComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.resourceId, this.resourceType, this.name, this.description, this.version, this.containedInstance});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.instance";
        }
    }

    @Block
    public static class ExampleScenarioActorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="actorId", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="ID or acronym of the actor", formalDefinition="ID or acronym of actor.")
        protected StringType actorId;
        @Child(name="type", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="person | entity", formalDefinition="The type of actor - person or system.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/examplescenario-actor-type")
        protected Enumeration<ExampleScenarioActorType> type;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The name of the actor as shown in the page", formalDefinition="The name of the actor as shown in the page.")
        protected StringType name;
        @Child(name="description", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The description of the actor", formalDefinition="The description of the actor.")
        protected MarkdownType description;
        private static final long serialVersionUID = 1348364162L;

        public ExampleScenarioActorComponent() {
        }

        public ExampleScenarioActorComponent(StringType actorId, Enumeration<ExampleScenarioActorType> type) {
            this.actorId = actorId;
            this.type = type;
        }

        public StringType getActorIdElement() {
            if (this.actorId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioActorComponent.actorId");
                }
                if (Configuration.doAutoCreate()) {
                    this.actorId = new StringType();
                }
            }
            return this.actorId;
        }

        public boolean hasActorIdElement() {
            return this.actorId != null && !this.actorId.isEmpty();
        }

        public boolean hasActorId() {
            return this.actorId != null && !this.actorId.isEmpty();
        }

        public ExampleScenarioActorComponent setActorIdElement(StringType value) {
            this.actorId = value;
            return this;
        }

        public String getActorId() {
            return this.actorId == null ? null : (String)this.actorId.getValue();
        }

        public ExampleScenarioActorComponent setActorId(String value) {
            if (this.actorId == null) {
                this.actorId = new StringType();
            }
            this.actorId.setValue(value);
            return this;
        }

        public Enumeration<ExampleScenarioActorType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioActorComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<ExampleScenarioActorType>(new ExampleScenarioActorTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ExampleScenarioActorComponent setTypeElement(Enumeration<ExampleScenarioActorType> value) {
            this.type = value;
            return this;
        }

        public ExampleScenarioActorType getType() {
            return this.type == null ? null : (ExampleScenarioActorType)((Object)this.type.getValue());
        }

        public ExampleScenarioActorComponent setType(ExampleScenarioActorType value) {
            if (this.type == null) {
                this.type = new Enumeration<ExampleScenarioActorType>(new ExampleScenarioActorTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioActorComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ExampleScenarioActorComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ExampleScenarioActorComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExampleScenarioActorComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ExampleScenarioActorComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ExampleScenarioActorComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("actorId", "string", "ID or acronym of actor.", 0, 1, this.actorId));
            children.add(new Property("type", "code", "The type of actor - person or system.", 0, 1, this.type));
            children.add(new Property(ExampleScenario.SP_NAME, "string", "The name of the actor as shown in the page.", 0, 1, this.name));
            children.add(new Property("description", "markdown", "The description of the actor.", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1161623056: {
                    return new Property("actorId", "string", "ID or acronym of actor.", 0, 1, this.actorId);
                }
                case 3575610: {
                    return new Property("type", "code", "The type of actor - person or system.", 0, 1, this.type);
                }
                case 3373707: {
                    return new Property(ExampleScenario.SP_NAME, "string", "The name of the actor as shown in the page.", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "The description of the actor.", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1161623056: {
                    Base[] baseArray;
                    if (this.actorId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.actorId;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1161623056: {
                    this.actorId = this.castToString(value);
                    return value;
                }
                case 3575610: {
                    value = new ExampleScenarioActorTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("actorId")) {
                this.actorId = this.castToString(value);
            } else if (name.equals("type")) {
                value = new ExampleScenarioActorTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals(ExampleScenario.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("description")) {
                this.description = this.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1161623056: {
                    return this.getActorIdElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1161623056: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("actorId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.actorId");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.type");
            }
            if (name.equals(ExampleScenario.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.name");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExampleScenario.description");
            }
            return super.addChild(name);
        }

        @Override
        public ExampleScenarioActorComponent copy() {
            ExampleScenarioActorComponent dst = new ExampleScenarioActorComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ExampleScenarioActorComponent dst) {
            super.copyValues(dst);
            dst.actorId = this.actorId == null ? null : this.actorId.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioActorComponent)) {
                return false;
            }
            ExampleScenarioActorComponent o = (ExampleScenarioActorComponent)other_;
            return ExampleScenarioActorComponent.compareDeep(this.actorId, o.actorId, true) && ExampleScenarioActorComponent.compareDeep(this.type, o.type, true) && ExampleScenarioActorComponent.compareDeep(this.name, o.name, true) && ExampleScenarioActorComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExampleScenarioActorComponent)) {
                return false;
            }
            ExampleScenarioActorComponent o = (ExampleScenarioActorComponent)other_;
            return ExampleScenarioActorComponent.compareValues(this.actorId, o.actorId, true) && ExampleScenarioActorComponent.compareValues(this.type, o.type, true) && ExampleScenarioActorComponent.compareValues(this.name, o.name, true) && ExampleScenarioActorComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.actorId, this.type, this.name, this.description});
        }

        @Override
        public String fhirType() {
            return "ExampleScenario.actor";
        }
    }

    public static class FHIRResourceTypeEnumFactory
    implements EnumFactory<FHIRResourceType> {
        @Override
        public FHIRResourceType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("Account".equals(codeString)) {
                return FHIRResourceType.ACCOUNT;
            }
            if ("ActivityDefinition".equals(codeString)) {
                return FHIRResourceType.ACTIVITYDEFINITION;
            }
            if ("AdverseEvent".equals(codeString)) {
                return FHIRResourceType.ADVERSEEVENT;
            }
            if ("AllergyIntolerance".equals(codeString)) {
                return FHIRResourceType.ALLERGYINTOLERANCE;
            }
            if ("Appointment".equals(codeString)) {
                return FHIRResourceType.APPOINTMENT;
            }
            if ("AppointmentResponse".equals(codeString)) {
                return FHIRResourceType.APPOINTMENTRESPONSE;
            }
            if ("AuditEvent".equals(codeString)) {
                return FHIRResourceType.AUDITEVENT;
            }
            if ("Basic".equals(codeString)) {
                return FHIRResourceType.BASIC;
            }
            if ("Binary".equals(codeString)) {
                return FHIRResourceType.BINARY;
            }
            if ("BiologicallyDerivedProduct".equals(codeString)) {
                return FHIRResourceType.BIOLOGICALLYDERIVEDPRODUCT;
            }
            if ("BodyStructure".equals(codeString)) {
                return FHIRResourceType.BODYSTRUCTURE;
            }
            if ("Bundle".equals(codeString)) {
                return FHIRResourceType.BUNDLE;
            }
            if ("CapabilityStatement".equals(codeString)) {
                return FHIRResourceType.CAPABILITYSTATEMENT;
            }
            if ("CarePlan".equals(codeString)) {
                return FHIRResourceType.CAREPLAN;
            }
            if ("CareTeam".equals(codeString)) {
                return FHIRResourceType.CARETEAM;
            }
            if ("CatalogEntry".equals(codeString)) {
                return FHIRResourceType.CATALOGENTRY;
            }
            if ("ChargeItem".equals(codeString)) {
                return FHIRResourceType.CHARGEITEM;
            }
            if ("ChargeItemDefinition".equals(codeString)) {
                return FHIRResourceType.CHARGEITEMDEFINITION;
            }
            if ("Claim".equals(codeString)) {
                return FHIRResourceType.CLAIM;
            }
            if ("ClaimResponse".equals(codeString)) {
                return FHIRResourceType.CLAIMRESPONSE;
            }
            if ("ClinicalImpression".equals(codeString)) {
                return FHIRResourceType.CLINICALIMPRESSION;
            }
            if ("CodeSystem".equals(codeString)) {
                return FHIRResourceType.CODESYSTEM;
            }
            if ("Communication".equals(codeString)) {
                return FHIRResourceType.COMMUNICATION;
            }
            if ("CommunicationRequest".equals(codeString)) {
                return FHIRResourceType.COMMUNICATIONREQUEST;
            }
            if ("CompartmentDefinition".equals(codeString)) {
                return FHIRResourceType.COMPARTMENTDEFINITION;
            }
            if ("Composition".equals(codeString)) {
                return FHIRResourceType.COMPOSITION;
            }
            if ("ConceptMap".equals(codeString)) {
                return FHIRResourceType.CONCEPTMAP;
            }
            if ("Condition".equals(codeString)) {
                return FHIRResourceType.CONDITION;
            }
            if ("Consent".equals(codeString)) {
                return FHIRResourceType.CONSENT;
            }
            if ("Contract".equals(codeString)) {
                return FHIRResourceType.CONTRACT;
            }
            if ("Coverage".equals(codeString)) {
                return FHIRResourceType.COVERAGE;
            }
            if ("CoverageEligibilityRequest".equals(codeString)) {
                return FHIRResourceType.COVERAGEELIGIBILITYREQUEST;
            }
            if ("CoverageEligibilityResponse".equals(codeString)) {
                return FHIRResourceType.COVERAGEELIGIBILITYRESPONSE;
            }
            if ("DetectedIssue".equals(codeString)) {
                return FHIRResourceType.DETECTEDISSUE;
            }
            if ("Device".equals(codeString)) {
                return FHIRResourceType.DEVICE;
            }
            if ("DeviceDefinition".equals(codeString)) {
                return FHIRResourceType.DEVICEDEFINITION;
            }
            if ("DeviceMetric".equals(codeString)) {
                return FHIRResourceType.DEVICEMETRIC;
            }
            if ("DeviceRequest".equals(codeString)) {
                return FHIRResourceType.DEVICEREQUEST;
            }
            if ("DeviceUseStatement".equals(codeString)) {
                return FHIRResourceType.DEVICEUSESTATEMENT;
            }
            if ("DiagnosticReport".equals(codeString)) {
                return FHIRResourceType.DIAGNOSTICREPORT;
            }
            if ("DocumentManifest".equals(codeString)) {
                return FHIRResourceType.DOCUMENTMANIFEST;
            }
            if ("DocumentReference".equals(codeString)) {
                return FHIRResourceType.DOCUMENTREFERENCE;
            }
            if ("DomainResource".equals(codeString)) {
                return FHIRResourceType.DOMAINRESOURCE;
            }
            if ("EffectEvidenceSynthesis".equals(codeString)) {
                return FHIRResourceType.EFFECTEVIDENCESYNTHESIS;
            }
            if ("Encounter".equals(codeString)) {
                return FHIRResourceType.ENCOUNTER;
            }
            if ("Endpoint".equals(codeString)) {
                return FHIRResourceType.ENDPOINT;
            }
            if ("EnrollmentRequest".equals(codeString)) {
                return FHIRResourceType.ENROLLMENTREQUEST;
            }
            if ("EnrollmentResponse".equals(codeString)) {
                return FHIRResourceType.ENROLLMENTRESPONSE;
            }
            if ("EpisodeOfCare".equals(codeString)) {
                return FHIRResourceType.EPISODEOFCARE;
            }
            if ("EventDefinition".equals(codeString)) {
                return FHIRResourceType.EVENTDEFINITION;
            }
            if ("Evidence".equals(codeString)) {
                return FHIRResourceType.EVIDENCE;
            }
            if ("EvidenceVariable".equals(codeString)) {
                return FHIRResourceType.EVIDENCEVARIABLE;
            }
            if ("ExampleScenario".equals(codeString)) {
                return FHIRResourceType.EXAMPLESCENARIO;
            }
            if ("ExplanationOfBenefit".equals(codeString)) {
                return FHIRResourceType.EXPLANATIONOFBENEFIT;
            }
            if ("FamilyMemberHistory".equals(codeString)) {
                return FHIRResourceType.FAMILYMEMBERHISTORY;
            }
            if ("Flag".equals(codeString)) {
                return FHIRResourceType.FLAG;
            }
            if ("Goal".equals(codeString)) {
                return FHIRResourceType.GOAL;
            }
            if ("GraphDefinition".equals(codeString)) {
                return FHIRResourceType.GRAPHDEFINITION;
            }
            if ("Group".equals(codeString)) {
                return FHIRResourceType.GROUP;
            }
            if ("GuidanceResponse".equals(codeString)) {
                return FHIRResourceType.GUIDANCERESPONSE;
            }
            if ("HealthcareService".equals(codeString)) {
                return FHIRResourceType.HEALTHCARESERVICE;
            }
            if ("ImagingStudy".equals(codeString)) {
                return FHIRResourceType.IMAGINGSTUDY;
            }
            if ("Immunization".equals(codeString)) {
                return FHIRResourceType.IMMUNIZATION;
            }
            if ("ImmunizationEvaluation".equals(codeString)) {
                return FHIRResourceType.IMMUNIZATIONEVALUATION;
            }
            if ("ImmunizationRecommendation".equals(codeString)) {
                return FHIRResourceType.IMMUNIZATIONRECOMMENDATION;
            }
            if ("ImplementationGuide".equals(codeString)) {
                return FHIRResourceType.IMPLEMENTATIONGUIDE;
            }
            if ("InsurancePlan".equals(codeString)) {
                return FHIRResourceType.INSURANCEPLAN;
            }
            if ("Invoice".equals(codeString)) {
                return FHIRResourceType.INVOICE;
            }
            if ("Library".equals(codeString)) {
                return FHIRResourceType.LIBRARY;
            }
            if ("Linkage".equals(codeString)) {
                return FHIRResourceType.LINKAGE;
            }
            if ("List".equals(codeString)) {
                return FHIRResourceType.LIST;
            }
            if ("Location".equals(codeString)) {
                return FHIRResourceType.LOCATION;
            }
            if ("Measure".equals(codeString)) {
                return FHIRResourceType.MEASURE;
            }
            if ("MeasureReport".equals(codeString)) {
                return FHIRResourceType.MEASUREREPORT;
            }
            if ("Media".equals(codeString)) {
                return FHIRResourceType.MEDIA;
            }
            if ("Medication".equals(codeString)) {
                return FHIRResourceType.MEDICATION;
            }
            if ("MedicationAdministration".equals(codeString)) {
                return FHIRResourceType.MEDICATIONADMINISTRATION;
            }
            if ("MedicationDispense".equals(codeString)) {
                return FHIRResourceType.MEDICATIONDISPENSE;
            }
            if ("MedicationKnowledge".equals(codeString)) {
                return FHIRResourceType.MEDICATIONKNOWLEDGE;
            }
            if ("MedicationRequest".equals(codeString)) {
                return FHIRResourceType.MEDICATIONREQUEST;
            }
            if ("MedicationStatement".equals(codeString)) {
                return FHIRResourceType.MEDICATIONSTATEMENT;
            }
            if ("MedicinalProduct".equals(codeString)) {
                return FHIRResourceType.MEDICINALPRODUCT;
            }
            if ("MedicinalProductAuthorization".equals(codeString)) {
                return FHIRResourceType.MEDICINALPRODUCTAUTHORIZATION;
            }
            if ("MedicinalProductContraindication".equals(codeString)) {
                return FHIRResourceType.MEDICINALPRODUCTCONTRAINDICATION;
            }
            if ("MedicinalProductIndication".equals(codeString)) {
                return FHIRResourceType.MEDICINALPRODUCTINDICATION;
            }
            if ("MedicinalProductIngredient".equals(codeString)) {
                return FHIRResourceType.MEDICINALPRODUCTINGREDIENT;
            }
            if ("MedicinalProductInteraction".equals(codeString)) {
                return FHIRResourceType.MEDICINALPRODUCTINTERACTION;
            }
            if ("MedicinalProductManufactured".equals(codeString)) {
                return FHIRResourceType.MEDICINALPRODUCTMANUFACTURED;
            }
            if ("MedicinalProductPackaged".equals(codeString)) {
                return FHIRResourceType.MEDICINALPRODUCTPACKAGED;
            }
            if ("MedicinalProductPharmaceutical".equals(codeString)) {
                return FHIRResourceType.MEDICINALPRODUCTPHARMACEUTICAL;
            }
            if ("MedicinalProductUndesirableEffect".equals(codeString)) {
                return FHIRResourceType.MEDICINALPRODUCTUNDESIRABLEEFFECT;
            }
            if ("MessageDefinition".equals(codeString)) {
                return FHIRResourceType.MESSAGEDEFINITION;
            }
            if ("MessageHeader".equals(codeString)) {
                return FHIRResourceType.MESSAGEHEADER;
            }
            if ("MolecularSequence".equals(codeString)) {
                return FHIRResourceType.MOLECULARSEQUENCE;
            }
            if ("NamingSystem".equals(codeString)) {
                return FHIRResourceType.NAMINGSYSTEM;
            }
            if ("NutritionOrder".equals(codeString)) {
                return FHIRResourceType.NUTRITIONORDER;
            }
            if ("Observation".equals(codeString)) {
                return FHIRResourceType.OBSERVATION;
            }
            if ("ObservationDefinition".equals(codeString)) {
                return FHIRResourceType.OBSERVATIONDEFINITION;
            }
            if ("OperationDefinition".equals(codeString)) {
                return FHIRResourceType.OPERATIONDEFINITION;
            }
            if ("OperationOutcome".equals(codeString)) {
                return FHIRResourceType.OPERATIONOUTCOME;
            }
            if ("Organization".equals(codeString)) {
                return FHIRResourceType.ORGANIZATION;
            }
            if ("OrganizationAffiliation".equals(codeString)) {
                return FHIRResourceType.ORGANIZATIONAFFILIATION;
            }
            if ("Parameters".equals(codeString)) {
                return FHIRResourceType.PARAMETERS;
            }
            if ("Patient".equals(codeString)) {
                return FHIRResourceType.PATIENT;
            }
            if ("PaymentNotice".equals(codeString)) {
                return FHIRResourceType.PAYMENTNOTICE;
            }
            if ("PaymentReconciliation".equals(codeString)) {
                return FHIRResourceType.PAYMENTRECONCILIATION;
            }
            if ("Person".equals(codeString)) {
                return FHIRResourceType.PERSON;
            }
            if ("PlanDefinition".equals(codeString)) {
                return FHIRResourceType.PLANDEFINITION;
            }
            if ("Practitioner".equals(codeString)) {
                return FHIRResourceType.PRACTITIONER;
            }
            if ("PractitionerRole".equals(codeString)) {
                return FHIRResourceType.PRACTITIONERROLE;
            }
            if ("Procedure".equals(codeString)) {
                return FHIRResourceType.PROCEDURE;
            }
            if ("Provenance".equals(codeString)) {
                return FHIRResourceType.PROVENANCE;
            }
            if ("Questionnaire".equals(codeString)) {
                return FHIRResourceType.QUESTIONNAIRE;
            }
            if ("QuestionnaireResponse".equals(codeString)) {
                return FHIRResourceType.QUESTIONNAIRERESPONSE;
            }
            if ("RelatedPerson".equals(codeString)) {
                return FHIRResourceType.RELATEDPERSON;
            }
            if ("RequestGroup".equals(codeString)) {
                return FHIRResourceType.REQUESTGROUP;
            }
            if ("ResearchDefinition".equals(codeString)) {
                return FHIRResourceType.RESEARCHDEFINITION;
            }
            if ("ResearchElementDefinition".equals(codeString)) {
                return FHIRResourceType.RESEARCHELEMENTDEFINITION;
            }
            if ("ResearchStudy".equals(codeString)) {
                return FHIRResourceType.RESEARCHSTUDY;
            }
            if ("ResearchSubject".equals(codeString)) {
                return FHIRResourceType.RESEARCHSUBJECT;
            }
            if ("Resource".equals(codeString)) {
                return FHIRResourceType.RESOURCE;
            }
            if ("RiskAssessment".equals(codeString)) {
                return FHIRResourceType.RISKASSESSMENT;
            }
            if ("RiskEvidenceSynthesis".equals(codeString)) {
                return FHIRResourceType.RISKEVIDENCESYNTHESIS;
            }
            if ("Schedule".equals(codeString)) {
                return FHIRResourceType.SCHEDULE;
            }
            if ("SearchParameter".equals(codeString)) {
                return FHIRResourceType.SEARCHPARAMETER;
            }
            if ("ServiceRequest".equals(codeString)) {
                return FHIRResourceType.SERVICEREQUEST;
            }
            if ("Slot".equals(codeString)) {
                return FHIRResourceType.SLOT;
            }
            if ("Specimen".equals(codeString)) {
                return FHIRResourceType.SPECIMEN;
            }
            if ("SpecimenDefinition".equals(codeString)) {
                return FHIRResourceType.SPECIMENDEFINITION;
            }
            if ("StructureDefinition".equals(codeString)) {
                return FHIRResourceType.STRUCTUREDEFINITION;
            }
            if ("StructureMap".equals(codeString)) {
                return FHIRResourceType.STRUCTUREMAP;
            }
            if ("Subscription".equals(codeString)) {
                return FHIRResourceType.SUBSCRIPTION;
            }
            if ("Substance".equals(codeString)) {
                return FHIRResourceType.SUBSTANCE;
            }
            if ("SubstanceNucleicAcid".equals(codeString)) {
                return FHIRResourceType.SUBSTANCENUCLEICACID;
            }
            if ("SubstancePolymer".equals(codeString)) {
                return FHIRResourceType.SUBSTANCEPOLYMER;
            }
            if ("SubstanceProtein".equals(codeString)) {
                return FHIRResourceType.SUBSTANCEPROTEIN;
            }
            if ("SubstanceReferenceInformation".equals(codeString)) {
                return FHIRResourceType.SUBSTANCEREFERENCEINFORMATION;
            }
            if ("SubstanceSourceMaterial".equals(codeString)) {
                return FHIRResourceType.SUBSTANCESOURCEMATERIAL;
            }
            if ("SubstanceSpecification".equals(codeString)) {
                return FHIRResourceType.SUBSTANCESPECIFICATION;
            }
            if ("SupplyDelivery".equals(codeString)) {
                return FHIRResourceType.SUPPLYDELIVERY;
            }
            if ("SupplyRequest".equals(codeString)) {
                return FHIRResourceType.SUPPLYREQUEST;
            }
            if ("Task".equals(codeString)) {
                return FHIRResourceType.TASK;
            }
            if ("TerminologyCapabilities".equals(codeString)) {
                return FHIRResourceType.TERMINOLOGYCAPABILITIES;
            }
            if ("TestReport".equals(codeString)) {
                return FHIRResourceType.TESTREPORT;
            }
            if ("TestScript".equals(codeString)) {
                return FHIRResourceType.TESTSCRIPT;
            }
            if ("ValueSet".equals(codeString)) {
                return FHIRResourceType.VALUESET;
            }
            if ("VerificationResult".equals(codeString)) {
                return FHIRResourceType.VERIFICATIONRESULT;
            }
            if ("VisionPrescription".equals(codeString)) {
                return FHIRResourceType.VISIONPRESCRIPTION;
            }
            throw new IllegalArgumentException("Unknown FHIRResourceType code '" + codeString + "'");
        }

        public Enumeration<FHIRResourceType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<FHIRResourceType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("Account".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.ACCOUNT);
            }
            if ("ActivityDefinition".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.ACTIVITYDEFINITION);
            }
            if ("AdverseEvent".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.ADVERSEEVENT);
            }
            if ("AllergyIntolerance".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.ALLERGYINTOLERANCE);
            }
            if ("Appointment".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.APPOINTMENT);
            }
            if ("AppointmentResponse".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.APPOINTMENTRESPONSE);
            }
            if ("AuditEvent".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.AUDITEVENT);
            }
            if ("Basic".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.BASIC);
            }
            if ("Binary".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.BINARY);
            }
            if ("BiologicallyDerivedProduct".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.BIOLOGICALLYDERIVEDPRODUCT);
            }
            if ("BodyStructure".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.BODYSTRUCTURE);
            }
            if ("Bundle".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.BUNDLE);
            }
            if ("CapabilityStatement".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.CAPABILITYSTATEMENT);
            }
            if ("CarePlan".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.CAREPLAN);
            }
            if ("CareTeam".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.CARETEAM);
            }
            if ("CatalogEntry".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.CATALOGENTRY);
            }
            if ("ChargeItem".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.CHARGEITEM);
            }
            if ("ChargeItemDefinition".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.CHARGEITEMDEFINITION);
            }
            if ("Claim".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.CLAIM);
            }
            if ("ClaimResponse".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.CLAIMRESPONSE);
            }
            if ("ClinicalImpression".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.CLINICALIMPRESSION);
            }
            if ("CodeSystem".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.CODESYSTEM);
            }
            if ("Communication".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.COMMUNICATION);
            }
            if ("CommunicationRequest".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.COMMUNICATIONREQUEST);
            }
            if ("CompartmentDefinition".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.COMPARTMENTDEFINITION);
            }
            if ("Composition".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.COMPOSITION);
            }
            if ("ConceptMap".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.CONCEPTMAP);
            }
            if ("Condition".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.CONDITION);
            }
            if ("Consent".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.CONSENT);
            }
            if ("Contract".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.CONTRACT);
            }
            if ("Coverage".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.COVERAGE);
            }
            if ("CoverageEligibilityRequest".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.COVERAGEELIGIBILITYREQUEST);
            }
            if ("CoverageEligibilityResponse".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.COVERAGEELIGIBILITYRESPONSE);
            }
            if ("DetectedIssue".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.DETECTEDISSUE);
            }
            if ("Device".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.DEVICE);
            }
            if ("DeviceDefinition".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.DEVICEDEFINITION);
            }
            if ("DeviceMetric".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.DEVICEMETRIC);
            }
            if ("DeviceRequest".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.DEVICEREQUEST);
            }
            if ("DeviceUseStatement".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.DEVICEUSESTATEMENT);
            }
            if ("DiagnosticReport".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.DIAGNOSTICREPORT);
            }
            if ("DocumentManifest".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.DOCUMENTMANIFEST);
            }
            if ("DocumentReference".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.DOCUMENTREFERENCE);
            }
            if ("DomainResource".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.DOMAINRESOURCE);
            }
            if ("EffectEvidenceSynthesis".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.EFFECTEVIDENCESYNTHESIS);
            }
            if ("Encounter".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.ENCOUNTER);
            }
            if ("Endpoint".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.ENDPOINT);
            }
            if ("EnrollmentRequest".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.ENROLLMENTREQUEST);
            }
            if ("EnrollmentResponse".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.ENROLLMENTRESPONSE);
            }
            if ("EpisodeOfCare".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.EPISODEOFCARE);
            }
            if ("EventDefinition".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.EVENTDEFINITION);
            }
            if ("Evidence".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.EVIDENCE);
            }
            if ("EvidenceVariable".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.EVIDENCEVARIABLE);
            }
            if ("ExampleScenario".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.EXAMPLESCENARIO);
            }
            if ("ExplanationOfBenefit".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.EXPLANATIONOFBENEFIT);
            }
            if ("FamilyMemberHistory".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.FAMILYMEMBERHISTORY);
            }
            if ("Flag".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.FLAG);
            }
            if ("Goal".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.GOAL);
            }
            if ("GraphDefinition".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.GRAPHDEFINITION);
            }
            if ("Group".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.GROUP);
            }
            if ("GuidanceResponse".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.GUIDANCERESPONSE);
            }
            if ("HealthcareService".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.HEALTHCARESERVICE);
            }
            if ("ImagingStudy".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.IMAGINGSTUDY);
            }
            if ("Immunization".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.IMMUNIZATION);
            }
            if ("ImmunizationEvaluation".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.IMMUNIZATIONEVALUATION);
            }
            if ("ImmunizationRecommendation".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.IMMUNIZATIONRECOMMENDATION);
            }
            if ("ImplementationGuide".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.IMPLEMENTATIONGUIDE);
            }
            if ("InsurancePlan".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.INSURANCEPLAN);
            }
            if ("Invoice".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.INVOICE);
            }
            if ("Library".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.LIBRARY);
            }
            if ("Linkage".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.LINKAGE);
            }
            if ("List".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.LIST);
            }
            if ("Location".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.LOCATION);
            }
            if ("Measure".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEASURE);
            }
            if ("MeasureReport".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEASUREREPORT);
            }
            if ("Media".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEDIA);
            }
            if ("Medication".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEDICATION);
            }
            if ("MedicationAdministration".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEDICATIONADMINISTRATION);
            }
            if ("MedicationDispense".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEDICATIONDISPENSE);
            }
            if ("MedicationKnowledge".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEDICATIONKNOWLEDGE);
            }
            if ("MedicationRequest".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEDICATIONREQUEST);
            }
            if ("MedicationStatement".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEDICATIONSTATEMENT);
            }
            if ("MedicinalProduct".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEDICINALPRODUCT);
            }
            if ("MedicinalProductAuthorization".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEDICINALPRODUCTAUTHORIZATION);
            }
            if ("MedicinalProductContraindication".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEDICINALPRODUCTCONTRAINDICATION);
            }
            if ("MedicinalProductIndication".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEDICINALPRODUCTINDICATION);
            }
            if ("MedicinalProductIngredient".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEDICINALPRODUCTINGREDIENT);
            }
            if ("MedicinalProductInteraction".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEDICINALPRODUCTINTERACTION);
            }
            if ("MedicinalProductManufactured".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEDICINALPRODUCTMANUFACTURED);
            }
            if ("MedicinalProductPackaged".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEDICINALPRODUCTPACKAGED);
            }
            if ("MedicinalProductPharmaceutical".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEDICINALPRODUCTPHARMACEUTICAL);
            }
            if ("MedicinalProductUndesirableEffect".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MEDICINALPRODUCTUNDESIRABLEEFFECT);
            }
            if ("MessageDefinition".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MESSAGEDEFINITION);
            }
            if ("MessageHeader".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MESSAGEHEADER);
            }
            if ("MolecularSequence".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.MOLECULARSEQUENCE);
            }
            if ("NamingSystem".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.NAMINGSYSTEM);
            }
            if ("NutritionOrder".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.NUTRITIONORDER);
            }
            if ("Observation".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.OBSERVATION);
            }
            if ("ObservationDefinition".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.OBSERVATIONDEFINITION);
            }
            if ("OperationDefinition".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.OPERATIONDEFINITION);
            }
            if ("OperationOutcome".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.OPERATIONOUTCOME);
            }
            if ("Organization".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.ORGANIZATION);
            }
            if ("OrganizationAffiliation".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.ORGANIZATIONAFFILIATION);
            }
            if ("Parameters".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.PARAMETERS);
            }
            if ("Patient".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.PATIENT);
            }
            if ("PaymentNotice".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.PAYMENTNOTICE);
            }
            if ("PaymentReconciliation".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.PAYMENTRECONCILIATION);
            }
            if ("Person".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.PERSON);
            }
            if ("PlanDefinition".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.PLANDEFINITION);
            }
            if ("Practitioner".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.PRACTITIONER);
            }
            if ("PractitionerRole".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.PRACTITIONERROLE);
            }
            if ("Procedure".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.PROCEDURE);
            }
            if ("Provenance".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.PROVENANCE);
            }
            if ("Questionnaire".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.QUESTIONNAIRE);
            }
            if ("QuestionnaireResponse".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.QUESTIONNAIRERESPONSE);
            }
            if ("RelatedPerson".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.RELATEDPERSON);
            }
            if ("RequestGroup".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.REQUESTGROUP);
            }
            if ("ResearchDefinition".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.RESEARCHDEFINITION);
            }
            if ("ResearchElementDefinition".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.RESEARCHELEMENTDEFINITION);
            }
            if ("ResearchStudy".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.RESEARCHSTUDY);
            }
            if ("ResearchSubject".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.RESEARCHSUBJECT);
            }
            if ("Resource".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.RESOURCE);
            }
            if ("RiskAssessment".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.RISKASSESSMENT);
            }
            if ("RiskEvidenceSynthesis".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.RISKEVIDENCESYNTHESIS);
            }
            if ("Schedule".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.SCHEDULE);
            }
            if ("SearchParameter".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.SEARCHPARAMETER);
            }
            if ("ServiceRequest".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.SERVICEREQUEST);
            }
            if ("Slot".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.SLOT);
            }
            if ("Specimen".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.SPECIMEN);
            }
            if ("SpecimenDefinition".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.SPECIMENDEFINITION);
            }
            if ("StructureDefinition".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.STRUCTUREDEFINITION);
            }
            if ("StructureMap".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.STRUCTUREMAP);
            }
            if ("Subscription".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.SUBSCRIPTION);
            }
            if ("Substance".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.SUBSTANCE);
            }
            if ("SubstanceNucleicAcid".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.SUBSTANCENUCLEICACID);
            }
            if ("SubstancePolymer".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.SUBSTANCEPOLYMER);
            }
            if ("SubstanceProtein".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.SUBSTANCEPROTEIN);
            }
            if ("SubstanceReferenceInformation".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.SUBSTANCEREFERENCEINFORMATION);
            }
            if ("SubstanceSourceMaterial".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.SUBSTANCESOURCEMATERIAL);
            }
            if ("SubstanceSpecification".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.SUBSTANCESPECIFICATION);
            }
            if ("SupplyDelivery".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.SUPPLYDELIVERY);
            }
            if ("SupplyRequest".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.SUPPLYREQUEST);
            }
            if ("Task".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.TASK);
            }
            if ("TerminologyCapabilities".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.TERMINOLOGYCAPABILITIES);
            }
            if ("TestReport".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.TESTREPORT);
            }
            if ("TestScript".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.TESTSCRIPT);
            }
            if ("ValueSet".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.VALUESET);
            }
            if ("VerificationResult".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.VERIFICATIONRESULT);
            }
            if ("VisionPrescription".equals(codeString)) {
                return new Enumeration<FHIRResourceType>(this, FHIRResourceType.VISIONPRESCRIPTION);
            }
            throw new FHIRException("Unknown FHIRResourceType code '" + codeString + "'");
        }

        @Override
        public String toCode(FHIRResourceType code) {
            if (code == FHIRResourceType.ACCOUNT) {
                return "Account";
            }
            if (code == FHIRResourceType.ACTIVITYDEFINITION) {
                return "ActivityDefinition";
            }
            if (code == FHIRResourceType.ADVERSEEVENT) {
                return "AdverseEvent";
            }
            if (code == FHIRResourceType.ALLERGYINTOLERANCE) {
                return "AllergyIntolerance";
            }
            if (code == FHIRResourceType.APPOINTMENT) {
                return "Appointment";
            }
            if (code == FHIRResourceType.APPOINTMENTRESPONSE) {
                return "AppointmentResponse";
            }
            if (code == FHIRResourceType.AUDITEVENT) {
                return "AuditEvent";
            }
            if (code == FHIRResourceType.BASIC) {
                return "Basic";
            }
            if (code == FHIRResourceType.BINARY) {
                return "Binary";
            }
            if (code == FHIRResourceType.BIOLOGICALLYDERIVEDPRODUCT) {
                return "BiologicallyDerivedProduct";
            }
            if (code == FHIRResourceType.BODYSTRUCTURE) {
                return "BodyStructure";
            }
            if (code == FHIRResourceType.BUNDLE) {
                return "Bundle";
            }
            if (code == FHIRResourceType.CAPABILITYSTATEMENT) {
                return "CapabilityStatement";
            }
            if (code == FHIRResourceType.CAREPLAN) {
                return "CarePlan";
            }
            if (code == FHIRResourceType.CARETEAM) {
                return "CareTeam";
            }
            if (code == FHIRResourceType.CATALOGENTRY) {
                return "CatalogEntry";
            }
            if (code == FHIRResourceType.CHARGEITEM) {
                return "ChargeItem";
            }
            if (code == FHIRResourceType.CHARGEITEMDEFINITION) {
                return "ChargeItemDefinition";
            }
            if (code == FHIRResourceType.CLAIM) {
                return "Claim";
            }
            if (code == FHIRResourceType.CLAIMRESPONSE) {
                return "ClaimResponse";
            }
            if (code == FHIRResourceType.CLINICALIMPRESSION) {
                return "ClinicalImpression";
            }
            if (code == FHIRResourceType.CODESYSTEM) {
                return "CodeSystem";
            }
            if (code == FHIRResourceType.COMMUNICATION) {
                return "Communication";
            }
            if (code == FHIRResourceType.COMMUNICATIONREQUEST) {
                return "CommunicationRequest";
            }
            if (code == FHIRResourceType.COMPARTMENTDEFINITION) {
                return "CompartmentDefinition";
            }
            if (code == FHIRResourceType.COMPOSITION) {
                return "Composition";
            }
            if (code == FHIRResourceType.CONCEPTMAP) {
                return "ConceptMap";
            }
            if (code == FHIRResourceType.CONDITION) {
                return "Condition";
            }
            if (code == FHIRResourceType.CONSENT) {
                return "Consent";
            }
            if (code == FHIRResourceType.CONTRACT) {
                return "Contract";
            }
            if (code == FHIRResourceType.COVERAGE) {
                return "Coverage";
            }
            if (code == FHIRResourceType.COVERAGEELIGIBILITYREQUEST) {
                return "CoverageEligibilityRequest";
            }
            if (code == FHIRResourceType.COVERAGEELIGIBILITYRESPONSE) {
                return "CoverageEligibilityResponse";
            }
            if (code == FHIRResourceType.DETECTEDISSUE) {
                return "DetectedIssue";
            }
            if (code == FHIRResourceType.DEVICE) {
                return "Device";
            }
            if (code == FHIRResourceType.DEVICEDEFINITION) {
                return "DeviceDefinition";
            }
            if (code == FHIRResourceType.DEVICEMETRIC) {
                return "DeviceMetric";
            }
            if (code == FHIRResourceType.DEVICEREQUEST) {
                return "DeviceRequest";
            }
            if (code == FHIRResourceType.DEVICEUSESTATEMENT) {
                return "DeviceUseStatement";
            }
            if (code == FHIRResourceType.DIAGNOSTICREPORT) {
                return "DiagnosticReport";
            }
            if (code == FHIRResourceType.DOCUMENTMANIFEST) {
                return "DocumentManifest";
            }
            if (code == FHIRResourceType.DOCUMENTREFERENCE) {
                return "DocumentReference";
            }
            if (code == FHIRResourceType.DOMAINRESOURCE) {
                return "DomainResource";
            }
            if (code == FHIRResourceType.EFFECTEVIDENCESYNTHESIS) {
                return "EffectEvidenceSynthesis";
            }
            if (code == FHIRResourceType.ENCOUNTER) {
                return "Encounter";
            }
            if (code == FHIRResourceType.ENDPOINT) {
                return "Endpoint";
            }
            if (code == FHIRResourceType.ENROLLMENTREQUEST) {
                return "EnrollmentRequest";
            }
            if (code == FHIRResourceType.ENROLLMENTRESPONSE) {
                return "EnrollmentResponse";
            }
            if (code == FHIRResourceType.EPISODEOFCARE) {
                return "EpisodeOfCare";
            }
            if (code == FHIRResourceType.EVENTDEFINITION) {
                return "EventDefinition";
            }
            if (code == FHIRResourceType.EVIDENCE) {
                return "Evidence";
            }
            if (code == FHIRResourceType.EVIDENCEVARIABLE) {
                return "EvidenceVariable";
            }
            if (code == FHIRResourceType.EXAMPLESCENARIO) {
                return "ExampleScenario";
            }
            if (code == FHIRResourceType.EXPLANATIONOFBENEFIT) {
                return "ExplanationOfBenefit";
            }
            if (code == FHIRResourceType.FAMILYMEMBERHISTORY) {
                return "FamilyMemberHistory";
            }
            if (code == FHIRResourceType.FLAG) {
                return "Flag";
            }
            if (code == FHIRResourceType.GOAL) {
                return "Goal";
            }
            if (code == FHIRResourceType.GRAPHDEFINITION) {
                return "GraphDefinition";
            }
            if (code == FHIRResourceType.GROUP) {
                return "Group";
            }
            if (code == FHIRResourceType.GUIDANCERESPONSE) {
                return "GuidanceResponse";
            }
            if (code == FHIRResourceType.HEALTHCARESERVICE) {
                return "HealthcareService";
            }
            if (code == FHIRResourceType.IMAGINGSTUDY) {
                return "ImagingStudy";
            }
            if (code == FHIRResourceType.IMMUNIZATION) {
                return "Immunization";
            }
            if (code == FHIRResourceType.IMMUNIZATIONEVALUATION) {
                return "ImmunizationEvaluation";
            }
            if (code == FHIRResourceType.IMMUNIZATIONRECOMMENDATION) {
                return "ImmunizationRecommendation";
            }
            if (code == FHIRResourceType.IMPLEMENTATIONGUIDE) {
                return "ImplementationGuide";
            }
            if (code == FHIRResourceType.INSURANCEPLAN) {
                return "InsurancePlan";
            }
            if (code == FHIRResourceType.INVOICE) {
                return "Invoice";
            }
            if (code == FHIRResourceType.LIBRARY) {
                return "Library";
            }
            if (code == FHIRResourceType.LINKAGE) {
                return "Linkage";
            }
            if (code == FHIRResourceType.LIST) {
                return "List";
            }
            if (code == FHIRResourceType.LOCATION) {
                return "Location";
            }
            if (code == FHIRResourceType.MEASURE) {
                return "Measure";
            }
            if (code == FHIRResourceType.MEASUREREPORT) {
                return "MeasureReport";
            }
            if (code == FHIRResourceType.MEDIA) {
                return "Media";
            }
            if (code == FHIRResourceType.MEDICATION) {
                return "Medication";
            }
            if (code == FHIRResourceType.MEDICATIONADMINISTRATION) {
                return "MedicationAdministration";
            }
            if (code == FHIRResourceType.MEDICATIONDISPENSE) {
                return "MedicationDispense";
            }
            if (code == FHIRResourceType.MEDICATIONKNOWLEDGE) {
                return "MedicationKnowledge";
            }
            if (code == FHIRResourceType.MEDICATIONREQUEST) {
                return "MedicationRequest";
            }
            if (code == FHIRResourceType.MEDICATIONSTATEMENT) {
                return "MedicationStatement";
            }
            if (code == FHIRResourceType.MEDICINALPRODUCT) {
                return "MedicinalProduct";
            }
            if (code == FHIRResourceType.MEDICINALPRODUCTAUTHORIZATION) {
                return "MedicinalProductAuthorization";
            }
            if (code == FHIRResourceType.MEDICINALPRODUCTCONTRAINDICATION) {
                return "MedicinalProductContraindication";
            }
            if (code == FHIRResourceType.MEDICINALPRODUCTINDICATION) {
                return "MedicinalProductIndication";
            }
            if (code == FHIRResourceType.MEDICINALPRODUCTINGREDIENT) {
                return "MedicinalProductIngredient";
            }
            if (code == FHIRResourceType.MEDICINALPRODUCTINTERACTION) {
                return "MedicinalProductInteraction";
            }
            if (code == FHIRResourceType.MEDICINALPRODUCTMANUFACTURED) {
                return "MedicinalProductManufactured";
            }
            if (code == FHIRResourceType.MEDICINALPRODUCTPACKAGED) {
                return "MedicinalProductPackaged";
            }
            if (code == FHIRResourceType.MEDICINALPRODUCTPHARMACEUTICAL) {
                return "MedicinalProductPharmaceutical";
            }
            if (code == FHIRResourceType.MEDICINALPRODUCTUNDESIRABLEEFFECT) {
                return "MedicinalProductUndesirableEffect";
            }
            if (code == FHIRResourceType.MESSAGEDEFINITION) {
                return "MessageDefinition";
            }
            if (code == FHIRResourceType.MESSAGEHEADER) {
                return "MessageHeader";
            }
            if (code == FHIRResourceType.MOLECULARSEQUENCE) {
                return "MolecularSequence";
            }
            if (code == FHIRResourceType.NAMINGSYSTEM) {
                return "NamingSystem";
            }
            if (code == FHIRResourceType.NUTRITIONORDER) {
                return "NutritionOrder";
            }
            if (code == FHIRResourceType.OBSERVATION) {
                return "Observation";
            }
            if (code == FHIRResourceType.OBSERVATIONDEFINITION) {
                return "ObservationDefinition";
            }
            if (code == FHIRResourceType.OPERATIONDEFINITION) {
                return "OperationDefinition";
            }
            if (code == FHIRResourceType.OPERATIONOUTCOME) {
                return "OperationOutcome";
            }
            if (code == FHIRResourceType.ORGANIZATION) {
                return "Organization";
            }
            if (code == FHIRResourceType.ORGANIZATIONAFFILIATION) {
                return "OrganizationAffiliation";
            }
            if (code == FHIRResourceType.PARAMETERS) {
                return "Parameters";
            }
            if (code == FHIRResourceType.PATIENT) {
                return "Patient";
            }
            if (code == FHIRResourceType.PAYMENTNOTICE) {
                return "PaymentNotice";
            }
            if (code == FHIRResourceType.PAYMENTRECONCILIATION) {
                return "PaymentReconciliation";
            }
            if (code == FHIRResourceType.PERSON) {
                return "Person";
            }
            if (code == FHIRResourceType.PLANDEFINITION) {
                return "PlanDefinition";
            }
            if (code == FHIRResourceType.PRACTITIONER) {
                return "Practitioner";
            }
            if (code == FHIRResourceType.PRACTITIONERROLE) {
                return "PractitionerRole";
            }
            if (code == FHIRResourceType.PROCEDURE) {
                return "Procedure";
            }
            if (code == FHIRResourceType.PROVENANCE) {
                return "Provenance";
            }
            if (code == FHIRResourceType.QUESTIONNAIRE) {
                return "Questionnaire";
            }
            if (code == FHIRResourceType.QUESTIONNAIRERESPONSE) {
                return "QuestionnaireResponse";
            }
            if (code == FHIRResourceType.RELATEDPERSON) {
                return "RelatedPerson";
            }
            if (code == FHIRResourceType.REQUESTGROUP) {
                return "RequestGroup";
            }
            if (code == FHIRResourceType.RESEARCHDEFINITION) {
                return "ResearchDefinition";
            }
            if (code == FHIRResourceType.RESEARCHELEMENTDEFINITION) {
                return "ResearchElementDefinition";
            }
            if (code == FHIRResourceType.RESEARCHSTUDY) {
                return "ResearchStudy";
            }
            if (code == FHIRResourceType.RESEARCHSUBJECT) {
                return "ResearchSubject";
            }
            if (code == FHIRResourceType.RESOURCE) {
                return "Resource";
            }
            if (code == FHIRResourceType.RISKASSESSMENT) {
                return "RiskAssessment";
            }
            if (code == FHIRResourceType.RISKEVIDENCESYNTHESIS) {
                return "RiskEvidenceSynthesis";
            }
            if (code == FHIRResourceType.SCHEDULE) {
                return "Schedule";
            }
            if (code == FHIRResourceType.SEARCHPARAMETER) {
                return "SearchParameter";
            }
            if (code == FHIRResourceType.SERVICEREQUEST) {
                return "ServiceRequest";
            }
            if (code == FHIRResourceType.SLOT) {
                return "Slot";
            }
            if (code == FHIRResourceType.SPECIMEN) {
                return "Specimen";
            }
            if (code == FHIRResourceType.SPECIMENDEFINITION) {
                return "SpecimenDefinition";
            }
            if (code == FHIRResourceType.STRUCTUREDEFINITION) {
                return "StructureDefinition";
            }
            if (code == FHIRResourceType.STRUCTUREMAP) {
                return "StructureMap";
            }
            if (code == FHIRResourceType.SUBSCRIPTION) {
                return "Subscription";
            }
            if (code == FHIRResourceType.SUBSTANCE) {
                return "Substance";
            }
            if (code == FHIRResourceType.SUBSTANCENUCLEICACID) {
                return "SubstanceNucleicAcid";
            }
            if (code == FHIRResourceType.SUBSTANCEPOLYMER) {
                return "SubstancePolymer";
            }
            if (code == FHIRResourceType.SUBSTANCEPROTEIN) {
                return "SubstanceProtein";
            }
            if (code == FHIRResourceType.SUBSTANCEREFERENCEINFORMATION) {
                return "SubstanceReferenceInformation";
            }
            if (code == FHIRResourceType.SUBSTANCESOURCEMATERIAL) {
                return "SubstanceSourceMaterial";
            }
            if (code == FHIRResourceType.SUBSTANCESPECIFICATION) {
                return "SubstanceSpecification";
            }
            if (code == FHIRResourceType.SUPPLYDELIVERY) {
                return "SupplyDelivery";
            }
            if (code == FHIRResourceType.SUPPLYREQUEST) {
                return "SupplyRequest";
            }
            if (code == FHIRResourceType.TASK) {
                return "Task";
            }
            if (code == FHIRResourceType.TERMINOLOGYCAPABILITIES) {
                return "TerminologyCapabilities";
            }
            if (code == FHIRResourceType.TESTREPORT) {
                return "TestReport";
            }
            if (code == FHIRResourceType.TESTSCRIPT) {
                return "TestScript";
            }
            if (code == FHIRResourceType.VALUESET) {
                return "ValueSet";
            }
            if (code == FHIRResourceType.VERIFICATIONRESULT) {
                return "VerificationResult";
            }
            if (code == FHIRResourceType.VISIONPRESCRIPTION) {
                return "VisionPrescription";
            }
            return "?";
        }

        @Override
        public String toSystem(FHIRResourceType code) {
            return code.getSystem();
        }
    }

    public static enum FHIRResourceType {
        ACCOUNT,
        ACTIVITYDEFINITION,
        ADVERSEEVENT,
        ALLERGYINTOLERANCE,
        APPOINTMENT,
        APPOINTMENTRESPONSE,
        AUDITEVENT,
        BASIC,
        BINARY,
        BIOLOGICALLYDERIVEDPRODUCT,
        BODYSTRUCTURE,
        BUNDLE,
        CAPABILITYSTATEMENT,
        CAREPLAN,
        CARETEAM,
        CATALOGENTRY,
        CHARGEITEM,
        CHARGEITEMDEFINITION,
        CLAIM,
        CLAIMRESPONSE,
        CLINICALIMPRESSION,
        CODESYSTEM,
        COMMUNICATION,
        COMMUNICATIONREQUEST,
        COMPARTMENTDEFINITION,
        COMPOSITION,
        CONCEPTMAP,
        CONDITION,
        CONSENT,
        CONTRACT,
        COVERAGE,
        COVERAGEELIGIBILITYREQUEST,
        COVERAGEELIGIBILITYRESPONSE,
        DETECTEDISSUE,
        DEVICE,
        DEVICEDEFINITION,
        DEVICEMETRIC,
        DEVICEREQUEST,
        DEVICEUSESTATEMENT,
        DIAGNOSTICREPORT,
        DOCUMENTMANIFEST,
        DOCUMENTREFERENCE,
        DOMAINRESOURCE,
        EFFECTEVIDENCESYNTHESIS,
        ENCOUNTER,
        ENDPOINT,
        ENROLLMENTREQUEST,
        ENROLLMENTRESPONSE,
        EPISODEOFCARE,
        EVENTDEFINITION,
        EVIDENCE,
        EVIDENCEVARIABLE,
        EXAMPLESCENARIO,
        EXPLANATIONOFBENEFIT,
        FAMILYMEMBERHISTORY,
        FLAG,
        GOAL,
        GRAPHDEFINITION,
        GROUP,
        GUIDANCERESPONSE,
        HEALTHCARESERVICE,
        IMAGINGSTUDY,
        IMMUNIZATION,
        IMMUNIZATIONEVALUATION,
        IMMUNIZATIONRECOMMENDATION,
        IMPLEMENTATIONGUIDE,
        INSURANCEPLAN,
        INVOICE,
        LIBRARY,
        LINKAGE,
        LIST,
        LOCATION,
        MEASURE,
        MEASUREREPORT,
        MEDIA,
        MEDICATION,
        MEDICATIONADMINISTRATION,
        MEDICATIONDISPENSE,
        MEDICATIONKNOWLEDGE,
        MEDICATIONREQUEST,
        MEDICATIONSTATEMENT,
        MEDICINALPRODUCT,
        MEDICINALPRODUCTAUTHORIZATION,
        MEDICINALPRODUCTCONTRAINDICATION,
        MEDICINALPRODUCTINDICATION,
        MEDICINALPRODUCTINGREDIENT,
        MEDICINALPRODUCTINTERACTION,
        MEDICINALPRODUCTMANUFACTURED,
        MEDICINALPRODUCTPACKAGED,
        MEDICINALPRODUCTPHARMACEUTICAL,
        MEDICINALPRODUCTUNDESIRABLEEFFECT,
        MESSAGEDEFINITION,
        MESSAGEHEADER,
        MOLECULARSEQUENCE,
        NAMINGSYSTEM,
        NUTRITIONORDER,
        OBSERVATION,
        OBSERVATIONDEFINITION,
        OPERATIONDEFINITION,
        OPERATIONOUTCOME,
        ORGANIZATION,
        ORGANIZATIONAFFILIATION,
        PARAMETERS,
        PATIENT,
        PAYMENTNOTICE,
        PAYMENTRECONCILIATION,
        PERSON,
        PLANDEFINITION,
        PRACTITIONER,
        PRACTITIONERROLE,
        PROCEDURE,
        PROVENANCE,
        QUESTIONNAIRE,
        QUESTIONNAIRERESPONSE,
        RELATEDPERSON,
        REQUESTGROUP,
        RESEARCHDEFINITION,
        RESEARCHELEMENTDEFINITION,
        RESEARCHSTUDY,
        RESEARCHSUBJECT,
        RESOURCE,
        RISKASSESSMENT,
        RISKEVIDENCESYNTHESIS,
        SCHEDULE,
        SEARCHPARAMETER,
        SERVICEREQUEST,
        SLOT,
        SPECIMEN,
        SPECIMENDEFINITION,
        STRUCTUREDEFINITION,
        STRUCTUREMAP,
        SUBSCRIPTION,
        SUBSTANCE,
        SUBSTANCENUCLEICACID,
        SUBSTANCEPOLYMER,
        SUBSTANCEPROTEIN,
        SUBSTANCEREFERENCEINFORMATION,
        SUBSTANCESOURCEMATERIAL,
        SUBSTANCESPECIFICATION,
        SUPPLYDELIVERY,
        SUPPLYREQUEST,
        TASK,
        TERMINOLOGYCAPABILITIES,
        TESTREPORT,
        TESTSCRIPT,
        VALUESET,
        VERIFICATIONRESULT,
        VISIONPRESCRIPTION,
        NULL;


        public static FHIRResourceType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("Account".equals(codeString)) {
                return ACCOUNT;
            }
            if ("ActivityDefinition".equals(codeString)) {
                return ACTIVITYDEFINITION;
            }
            if ("AdverseEvent".equals(codeString)) {
                return ADVERSEEVENT;
            }
            if ("AllergyIntolerance".equals(codeString)) {
                return ALLERGYINTOLERANCE;
            }
            if ("Appointment".equals(codeString)) {
                return APPOINTMENT;
            }
            if ("AppointmentResponse".equals(codeString)) {
                return APPOINTMENTRESPONSE;
            }
            if ("AuditEvent".equals(codeString)) {
                return AUDITEVENT;
            }
            if ("Basic".equals(codeString)) {
                return BASIC;
            }
            if ("Binary".equals(codeString)) {
                return BINARY;
            }
            if ("BiologicallyDerivedProduct".equals(codeString)) {
                return BIOLOGICALLYDERIVEDPRODUCT;
            }
            if ("BodyStructure".equals(codeString)) {
                return BODYSTRUCTURE;
            }
            if ("Bundle".equals(codeString)) {
                return BUNDLE;
            }
            if ("CapabilityStatement".equals(codeString)) {
                return CAPABILITYSTATEMENT;
            }
            if ("CarePlan".equals(codeString)) {
                return CAREPLAN;
            }
            if ("CareTeam".equals(codeString)) {
                return CARETEAM;
            }
            if ("CatalogEntry".equals(codeString)) {
                return CATALOGENTRY;
            }
            if ("ChargeItem".equals(codeString)) {
                return CHARGEITEM;
            }
            if ("ChargeItemDefinition".equals(codeString)) {
                return CHARGEITEMDEFINITION;
            }
            if ("Claim".equals(codeString)) {
                return CLAIM;
            }
            if ("ClaimResponse".equals(codeString)) {
                return CLAIMRESPONSE;
            }
            if ("ClinicalImpression".equals(codeString)) {
                return CLINICALIMPRESSION;
            }
            if ("CodeSystem".equals(codeString)) {
                return CODESYSTEM;
            }
            if ("Communication".equals(codeString)) {
                return COMMUNICATION;
            }
            if ("CommunicationRequest".equals(codeString)) {
                return COMMUNICATIONREQUEST;
            }
            if ("CompartmentDefinition".equals(codeString)) {
                return COMPARTMENTDEFINITION;
            }
            if ("Composition".equals(codeString)) {
                return COMPOSITION;
            }
            if ("ConceptMap".equals(codeString)) {
                return CONCEPTMAP;
            }
            if ("Condition".equals(codeString)) {
                return CONDITION;
            }
            if ("Consent".equals(codeString)) {
                return CONSENT;
            }
            if ("Contract".equals(codeString)) {
                return CONTRACT;
            }
            if ("Coverage".equals(codeString)) {
                return COVERAGE;
            }
            if ("CoverageEligibilityRequest".equals(codeString)) {
                return COVERAGEELIGIBILITYREQUEST;
            }
            if ("CoverageEligibilityResponse".equals(codeString)) {
                return COVERAGEELIGIBILITYRESPONSE;
            }
            if ("DetectedIssue".equals(codeString)) {
                return DETECTEDISSUE;
            }
            if ("Device".equals(codeString)) {
                return DEVICE;
            }
            if ("DeviceDefinition".equals(codeString)) {
                return DEVICEDEFINITION;
            }
            if ("DeviceMetric".equals(codeString)) {
                return DEVICEMETRIC;
            }
            if ("DeviceRequest".equals(codeString)) {
                return DEVICEREQUEST;
            }
            if ("DeviceUseStatement".equals(codeString)) {
                return DEVICEUSESTATEMENT;
            }
            if ("DiagnosticReport".equals(codeString)) {
                return DIAGNOSTICREPORT;
            }
            if ("DocumentManifest".equals(codeString)) {
                return DOCUMENTMANIFEST;
            }
            if ("DocumentReference".equals(codeString)) {
                return DOCUMENTREFERENCE;
            }
            if ("DomainResource".equals(codeString)) {
                return DOMAINRESOURCE;
            }
            if ("EffectEvidenceSynthesis".equals(codeString)) {
                return EFFECTEVIDENCESYNTHESIS;
            }
            if ("Encounter".equals(codeString)) {
                return ENCOUNTER;
            }
            if ("Endpoint".equals(codeString)) {
                return ENDPOINT;
            }
            if ("EnrollmentRequest".equals(codeString)) {
                return ENROLLMENTREQUEST;
            }
            if ("EnrollmentResponse".equals(codeString)) {
                return ENROLLMENTRESPONSE;
            }
            if ("EpisodeOfCare".equals(codeString)) {
                return EPISODEOFCARE;
            }
            if ("EventDefinition".equals(codeString)) {
                return EVENTDEFINITION;
            }
            if ("Evidence".equals(codeString)) {
                return EVIDENCE;
            }
            if ("EvidenceVariable".equals(codeString)) {
                return EVIDENCEVARIABLE;
            }
            if ("ExampleScenario".equals(codeString)) {
                return EXAMPLESCENARIO;
            }
            if ("ExplanationOfBenefit".equals(codeString)) {
                return EXPLANATIONOFBENEFIT;
            }
            if ("FamilyMemberHistory".equals(codeString)) {
                return FAMILYMEMBERHISTORY;
            }
            if ("Flag".equals(codeString)) {
                return FLAG;
            }
            if ("Goal".equals(codeString)) {
                return GOAL;
            }
            if ("GraphDefinition".equals(codeString)) {
                return GRAPHDEFINITION;
            }
            if ("Group".equals(codeString)) {
                return GROUP;
            }
            if ("GuidanceResponse".equals(codeString)) {
                return GUIDANCERESPONSE;
            }
            if ("HealthcareService".equals(codeString)) {
                return HEALTHCARESERVICE;
            }
            if ("ImagingStudy".equals(codeString)) {
                return IMAGINGSTUDY;
            }
            if ("Immunization".equals(codeString)) {
                return IMMUNIZATION;
            }
            if ("ImmunizationEvaluation".equals(codeString)) {
                return IMMUNIZATIONEVALUATION;
            }
            if ("ImmunizationRecommendation".equals(codeString)) {
                return IMMUNIZATIONRECOMMENDATION;
            }
            if ("ImplementationGuide".equals(codeString)) {
                return IMPLEMENTATIONGUIDE;
            }
            if ("InsurancePlan".equals(codeString)) {
                return INSURANCEPLAN;
            }
            if ("Invoice".equals(codeString)) {
                return INVOICE;
            }
            if ("Library".equals(codeString)) {
                return LIBRARY;
            }
            if ("Linkage".equals(codeString)) {
                return LINKAGE;
            }
            if ("List".equals(codeString)) {
                return LIST;
            }
            if ("Location".equals(codeString)) {
                return LOCATION;
            }
            if ("Measure".equals(codeString)) {
                return MEASURE;
            }
            if ("MeasureReport".equals(codeString)) {
                return MEASUREREPORT;
            }
            if ("Media".equals(codeString)) {
                return MEDIA;
            }
            if ("Medication".equals(codeString)) {
                return MEDICATION;
            }
            if ("MedicationAdministration".equals(codeString)) {
                return MEDICATIONADMINISTRATION;
            }
            if ("MedicationDispense".equals(codeString)) {
                return MEDICATIONDISPENSE;
            }
            if ("MedicationKnowledge".equals(codeString)) {
                return MEDICATIONKNOWLEDGE;
            }
            if ("MedicationRequest".equals(codeString)) {
                return MEDICATIONREQUEST;
            }
            if ("MedicationStatement".equals(codeString)) {
                return MEDICATIONSTATEMENT;
            }
            if ("MedicinalProduct".equals(codeString)) {
                return MEDICINALPRODUCT;
            }
            if ("MedicinalProductAuthorization".equals(codeString)) {
                return MEDICINALPRODUCTAUTHORIZATION;
            }
            if ("MedicinalProductContraindication".equals(codeString)) {
                return MEDICINALPRODUCTCONTRAINDICATION;
            }
            if ("MedicinalProductIndication".equals(codeString)) {
                return MEDICINALPRODUCTINDICATION;
            }
            if ("MedicinalProductIngredient".equals(codeString)) {
                return MEDICINALPRODUCTINGREDIENT;
            }
            if ("MedicinalProductInteraction".equals(codeString)) {
                return MEDICINALPRODUCTINTERACTION;
            }
            if ("MedicinalProductManufactured".equals(codeString)) {
                return MEDICINALPRODUCTMANUFACTURED;
            }
            if ("MedicinalProductPackaged".equals(codeString)) {
                return MEDICINALPRODUCTPACKAGED;
            }
            if ("MedicinalProductPharmaceutical".equals(codeString)) {
                return MEDICINALPRODUCTPHARMACEUTICAL;
            }
            if ("MedicinalProductUndesirableEffect".equals(codeString)) {
                return MEDICINALPRODUCTUNDESIRABLEEFFECT;
            }
            if ("MessageDefinition".equals(codeString)) {
                return MESSAGEDEFINITION;
            }
            if ("MessageHeader".equals(codeString)) {
                return MESSAGEHEADER;
            }
            if ("MolecularSequence".equals(codeString)) {
                return MOLECULARSEQUENCE;
            }
            if ("NamingSystem".equals(codeString)) {
                return NAMINGSYSTEM;
            }
            if ("NutritionOrder".equals(codeString)) {
                return NUTRITIONORDER;
            }
            if ("Observation".equals(codeString)) {
                return OBSERVATION;
            }
            if ("ObservationDefinition".equals(codeString)) {
                return OBSERVATIONDEFINITION;
            }
            if ("OperationDefinition".equals(codeString)) {
                return OPERATIONDEFINITION;
            }
            if ("OperationOutcome".equals(codeString)) {
                return OPERATIONOUTCOME;
            }
            if ("Organization".equals(codeString)) {
                return ORGANIZATION;
            }
            if ("OrganizationAffiliation".equals(codeString)) {
                return ORGANIZATIONAFFILIATION;
            }
            if ("Parameters".equals(codeString)) {
                return PARAMETERS;
            }
            if ("Patient".equals(codeString)) {
                return PATIENT;
            }
            if ("PaymentNotice".equals(codeString)) {
                return PAYMENTNOTICE;
            }
            if ("PaymentReconciliation".equals(codeString)) {
                return PAYMENTRECONCILIATION;
            }
            if ("Person".equals(codeString)) {
                return PERSON;
            }
            if ("PlanDefinition".equals(codeString)) {
                return PLANDEFINITION;
            }
            if ("Practitioner".equals(codeString)) {
                return PRACTITIONER;
            }
            if ("PractitionerRole".equals(codeString)) {
                return PRACTITIONERROLE;
            }
            if ("Procedure".equals(codeString)) {
                return PROCEDURE;
            }
            if ("Provenance".equals(codeString)) {
                return PROVENANCE;
            }
            if ("Questionnaire".equals(codeString)) {
                return QUESTIONNAIRE;
            }
            if ("QuestionnaireResponse".equals(codeString)) {
                return QUESTIONNAIRERESPONSE;
            }
            if ("RelatedPerson".equals(codeString)) {
                return RELATEDPERSON;
            }
            if ("RequestGroup".equals(codeString)) {
                return REQUESTGROUP;
            }
            if ("ResearchDefinition".equals(codeString)) {
                return RESEARCHDEFINITION;
            }
            if ("ResearchElementDefinition".equals(codeString)) {
                return RESEARCHELEMENTDEFINITION;
            }
            if ("ResearchStudy".equals(codeString)) {
                return RESEARCHSTUDY;
            }
            if ("ResearchSubject".equals(codeString)) {
                return RESEARCHSUBJECT;
            }
            if ("Resource".equals(codeString)) {
                return RESOURCE;
            }
            if ("RiskAssessment".equals(codeString)) {
                return RISKASSESSMENT;
            }
            if ("RiskEvidenceSynthesis".equals(codeString)) {
                return RISKEVIDENCESYNTHESIS;
            }
            if ("Schedule".equals(codeString)) {
                return SCHEDULE;
            }
            if ("SearchParameter".equals(codeString)) {
                return SEARCHPARAMETER;
            }
            if ("ServiceRequest".equals(codeString)) {
                return SERVICEREQUEST;
            }
            if ("Slot".equals(codeString)) {
                return SLOT;
            }
            if ("Specimen".equals(codeString)) {
                return SPECIMEN;
            }
            if ("SpecimenDefinition".equals(codeString)) {
                return SPECIMENDEFINITION;
            }
            if ("StructureDefinition".equals(codeString)) {
                return STRUCTUREDEFINITION;
            }
            if ("StructureMap".equals(codeString)) {
                return STRUCTUREMAP;
            }
            if ("Subscription".equals(codeString)) {
                return SUBSCRIPTION;
            }
            if ("Substance".equals(codeString)) {
                return SUBSTANCE;
            }
            if ("SubstanceNucleicAcid".equals(codeString)) {
                return SUBSTANCENUCLEICACID;
            }
            if ("SubstancePolymer".equals(codeString)) {
                return SUBSTANCEPOLYMER;
            }
            if ("SubstanceProtein".equals(codeString)) {
                return SUBSTANCEPROTEIN;
            }
            if ("SubstanceReferenceInformation".equals(codeString)) {
                return SUBSTANCEREFERENCEINFORMATION;
            }
            if ("SubstanceSourceMaterial".equals(codeString)) {
                return SUBSTANCESOURCEMATERIAL;
            }
            if ("SubstanceSpecification".equals(codeString)) {
                return SUBSTANCESPECIFICATION;
            }
            if ("SupplyDelivery".equals(codeString)) {
                return SUPPLYDELIVERY;
            }
            if ("SupplyRequest".equals(codeString)) {
                return SUPPLYREQUEST;
            }
            if ("Task".equals(codeString)) {
                return TASK;
            }
            if ("TerminologyCapabilities".equals(codeString)) {
                return TERMINOLOGYCAPABILITIES;
            }
            if ("TestReport".equals(codeString)) {
                return TESTREPORT;
            }
            if ("TestScript".equals(codeString)) {
                return TESTSCRIPT;
            }
            if ("ValueSet".equals(codeString)) {
                return VALUESET;
            }
            if ("VerificationResult".equals(codeString)) {
                return VERIFICATIONRESULT;
            }
            if ("VisionPrescription".equals(codeString)) {
                return VISIONPRESCRIPTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown FHIRResourceType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACCOUNT: {
                    return "Account";
                }
                case ACTIVITYDEFINITION: {
                    return "ActivityDefinition";
                }
                case ADVERSEEVENT: {
                    return "AdverseEvent";
                }
                case ALLERGYINTOLERANCE: {
                    return "AllergyIntolerance";
                }
                case APPOINTMENT: {
                    return "Appointment";
                }
                case APPOINTMENTRESPONSE: {
                    return "AppointmentResponse";
                }
                case AUDITEVENT: {
                    return "AuditEvent";
                }
                case BASIC: {
                    return "Basic";
                }
                case BINARY: {
                    return "Binary";
                }
                case BIOLOGICALLYDERIVEDPRODUCT: {
                    return "BiologicallyDerivedProduct";
                }
                case BODYSTRUCTURE: {
                    return "BodyStructure";
                }
                case BUNDLE: {
                    return "Bundle";
                }
                case CAPABILITYSTATEMENT: {
                    return "CapabilityStatement";
                }
                case CAREPLAN: {
                    return "CarePlan";
                }
                case CARETEAM: {
                    return "CareTeam";
                }
                case CATALOGENTRY: {
                    return "CatalogEntry";
                }
                case CHARGEITEM: {
                    return "ChargeItem";
                }
                case CHARGEITEMDEFINITION: {
                    return "ChargeItemDefinition";
                }
                case CLAIM: {
                    return "Claim";
                }
                case CLAIMRESPONSE: {
                    return "ClaimResponse";
                }
                case CLINICALIMPRESSION: {
                    return "ClinicalImpression";
                }
                case CODESYSTEM: {
                    return "CodeSystem";
                }
                case COMMUNICATION: {
                    return "Communication";
                }
                case COMMUNICATIONREQUEST: {
                    return "CommunicationRequest";
                }
                case COMPARTMENTDEFINITION: {
                    return "CompartmentDefinition";
                }
                case COMPOSITION: {
                    return "Composition";
                }
                case CONCEPTMAP: {
                    return "ConceptMap";
                }
                case CONDITION: {
                    return "Condition";
                }
                case CONSENT: {
                    return "Consent";
                }
                case CONTRACT: {
                    return "Contract";
                }
                case COVERAGE: {
                    return "Coverage";
                }
                case COVERAGEELIGIBILITYREQUEST: {
                    return "CoverageEligibilityRequest";
                }
                case COVERAGEELIGIBILITYRESPONSE: {
                    return "CoverageEligibilityResponse";
                }
                case DETECTEDISSUE: {
                    return "DetectedIssue";
                }
                case DEVICE: {
                    return "Device";
                }
                case DEVICEDEFINITION: {
                    return "DeviceDefinition";
                }
                case DEVICEMETRIC: {
                    return "DeviceMetric";
                }
                case DEVICEREQUEST: {
                    return "DeviceRequest";
                }
                case DEVICEUSESTATEMENT: {
                    return "DeviceUseStatement";
                }
                case DIAGNOSTICREPORT: {
                    return "DiagnosticReport";
                }
                case DOCUMENTMANIFEST: {
                    return "DocumentManifest";
                }
                case DOCUMENTREFERENCE: {
                    return "DocumentReference";
                }
                case DOMAINRESOURCE: {
                    return "DomainResource";
                }
                case EFFECTEVIDENCESYNTHESIS: {
                    return "EffectEvidenceSynthesis";
                }
                case ENCOUNTER: {
                    return "Encounter";
                }
                case ENDPOINT: {
                    return "Endpoint";
                }
                case ENROLLMENTREQUEST: {
                    return "EnrollmentRequest";
                }
                case ENROLLMENTRESPONSE: {
                    return "EnrollmentResponse";
                }
                case EPISODEOFCARE: {
                    return "EpisodeOfCare";
                }
                case EVENTDEFINITION: {
                    return "EventDefinition";
                }
                case EVIDENCE: {
                    return "Evidence";
                }
                case EVIDENCEVARIABLE: {
                    return "EvidenceVariable";
                }
                case EXAMPLESCENARIO: {
                    return "ExampleScenario";
                }
                case EXPLANATIONOFBENEFIT: {
                    return "ExplanationOfBenefit";
                }
                case FAMILYMEMBERHISTORY: {
                    return "FamilyMemberHistory";
                }
                case FLAG: {
                    return "Flag";
                }
                case GOAL: {
                    return "Goal";
                }
                case GRAPHDEFINITION: {
                    return "GraphDefinition";
                }
                case GROUP: {
                    return "Group";
                }
                case GUIDANCERESPONSE: {
                    return "GuidanceResponse";
                }
                case HEALTHCARESERVICE: {
                    return "HealthcareService";
                }
                case IMAGINGSTUDY: {
                    return "ImagingStudy";
                }
                case IMMUNIZATION: {
                    return "Immunization";
                }
                case IMMUNIZATIONEVALUATION: {
                    return "ImmunizationEvaluation";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "ImmunizationRecommendation";
                }
                case IMPLEMENTATIONGUIDE: {
                    return "ImplementationGuide";
                }
                case INSURANCEPLAN: {
                    return "InsurancePlan";
                }
                case INVOICE: {
                    return "Invoice";
                }
                case LIBRARY: {
                    return "Library";
                }
                case LINKAGE: {
                    return "Linkage";
                }
                case LIST: {
                    return "List";
                }
                case LOCATION: {
                    return "Location";
                }
                case MEASURE: {
                    return "Measure";
                }
                case MEASUREREPORT: {
                    return "MeasureReport";
                }
                case MEDIA: {
                    return "Media";
                }
                case MEDICATION: {
                    return "Medication";
                }
                case MEDICATIONADMINISTRATION: {
                    return "MedicationAdministration";
                }
                case MEDICATIONDISPENSE: {
                    return "MedicationDispense";
                }
                case MEDICATIONKNOWLEDGE: {
                    return "MedicationKnowledge";
                }
                case MEDICATIONREQUEST: {
                    return "MedicationRequest";
                }
                case MEDICATIONSTATEMENT: {
                    return "MedicationStatement";
                }
                case MEDICINALPRODUCT: {
                    return "MedicinalProduct";
                }
                case MEDICINALPRODUCTAUTHORIZATION: {
                    return "MedicinalProductAuthorization";
                }
                case MEDICINALPRODUCTCONTRAINDICATION: {
                    return "MedicinalProductContraindication";
                }
                case MEDICINALPRODUCTINDICATION: {
                    return "MedicinalProductIndication";
                }
                case MEDICINALPRODUCTINGREDIENT: {
                    return "MedicinalProductIngredient";
                }
                case MEDICINALPRODUCTINTERACTION: {
                    return "MedicinalProductInteraction";
                }
                case MEDICINALPRODUCTMANUFACTURED: {
                    return "MedicinalProductManufactured";
                }
                case MEDICINALPRODUCTPACKAGED: {
                    return "MedicinalProductPackaged";
                }
                case MEDICINALPRODUCTPHARMACEUTICAL: {
                    return "MedicinalProductPharmaceutical";
                }
                case MEDICINALPRODUCTUNDESIRABLEEFFECT: {
                    return "MedicinalProductUndesirableEffect";
                }
                case MESSAGEDEFINITION: {
                    return "MessageDefinition";
                }
                case MESSAGEHEADER: {
                    return "MessageHeader";
                }
                case MOLECULARSEQUENCE: {
                    return "MolecularSequence";
                }
                case NAMINGSYSTEM: {
                    return "NamingSystem";
                }
                case NUTRITIONORDER: {
                    return "NutritionOrder";
                }
                case OBSERVATION: {
                    return "Observation";
                }
                case OBSERVATIONDEFINITION: {
                    return "ObservationDefinition";
                }
                case OPERATIONDEFINITION: {
                    return "OperationDefinition";
                }
                case OPERATIONOUTCOME: {
                    return "OperationOutcome";
                }
                case ORGANIZATION: {
                    return "Organization";
                }
                case ORGANIZATIONAFFILIATION: {
                    return "OrganizationAffiliation";
                }
                case PARAMETERS: {
                    return "Parameters";
                }
                case PATIENT: {
                    return "Patient";
                }
                case PAYMENTNOTICE: {
                    return "PaymentNotice";
                }
                case PAYMENTRECONCILIATION: {
                    return "PaymentReconciliation";
                }
                case PERSON: {
                    return "Person";
                }
                case PLANDEFINITION: {
                    return "PlanDefinition";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case PRACTITIONERROLE: {
                    return "PractitionerRole";
                }
                case PROCEDURE: {
                    return "Procedure";
                }
                case PROVENANCE: {
                    return "Provenance";
                }
                case QUESTIONNAIRE: {
                    return "Questionnaire";
                }
                case QUESTIONNAIRERESPONSE: {
                    return "QuestionnaireResponse";
                }
                case RELATEDPERSON: {
                    return "RelatedPerson";
                }
                case REQUESTGROUP: {
                    return "RequestGroup";
                }
                case RESEARCHDEFINITION: {
                    return "ResearchDefinition";
                }
                case RESEARCHELEMENTDEFINITION: {
                    return "ResearchElementDefinition";
                }
                case RESEARCHSTUDY: {
                    return "ResearchStudy";
                }
                case RESEARCHSUBJECT: {
                    return "ResearchSubject";
                }
                case RESOURCE: {
                    return "Resource";
                }
                case RISKASSESSMENT: {
                    return "RiskAssessment";
                }
                case RISKEVIDENCESYNTHESIS: {
                    return "RiskEvidenceSynthesis";
                }
                case SCHEDULE: {
                    return "Schedule";
                }
                case SEARCHPARAMETER: {
                    return "SearchParameter";
                }
                case SERVICEREQUEST: {
                    return "ServiceRequest";
                }
                case SLOT: {
                    return "Slot";
                }
                case SPECIMEN: {
                    return "Specimen";
                }
                case SPECIMENDEFINITION: {
                    return "SpecimenDefinition";
                }
                case STRUCTUREDEFINITION: {
                    return "StructureDefinition";
                }
                case STRUCTUREMAP: {
                    return "StructureMap";
                }
                case SUBSCRIPTION: {
                    return "Subscription";
                }
                case SUBSTANCE: {
                    return "Substance";
                }
                case SUBSTANCENUCLEICACID: {
                    return "SubstanceNucleicAcid";
                }
                case SUBSTANCEPOLYMER: {
                    return "SubstancePolymer";
                }
                case SUBSTANCEPROTEIN: {
                    return "SubstanceProtein";
                }
                case SUBSTANCEREFERENCEINFORMATION: {
                    return "SubstanceReferenceInformation";
                }
                case SUBSTANCESOURCEMATERIAL: {
                    return "SubstanceSourceMaterial";
                }
                case SUBSTANCESPECIFICATION: {
                    return "SubstanceSpecification";
                }
                case SUPPLYDELIVERY: {
                    return "SupplyDelivery";
                }
                case SUPPLYREQUEST: {
                    return "SupplyRequest";
                }
                case TASK: {
                    return "Task";
                }
                case TERMINOLOGYCAPABILITIES: {
                    return "TerminologyCapabilities";
                }
                case TESTREPORT: {
                    return "TestReport";
                }
                case TESTSCRIPT: {
                    return "TestScript";
                }
                case VALUESET: {
                    return "ValueSet";
                }
                case VERIFICATIONRESULT: {
                    return "VerificationResult";
                }
                case VISIONPRESCRIPTION: {
                    return "VisionPrescription";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACCOUNT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ACTIVITYDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ADVERSEEVENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ALLERGYINTOLERANCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case APPOINTMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case APPOINTMENTRESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case AUDITEVENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BASIC: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BINARY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BIOLOGICALLYDERIVEDPRODUCT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BODYSTRUCTURE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BUNDLE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CAPABILITYSTATEMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CAREPLAN: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CARETEAM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CATALOGENTRY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CHARGEITEM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CHARGEITEMDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CLAIM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CLAIMRESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CLINICALIMPRESSION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CODESYSTEM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COMMUNICATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COMMUNICATIONREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COMPARTMENTDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COMPOSITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CONCEPTMAP: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CONDITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CONSENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CONTRACT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COVERAGE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COVERAGEELIGIBILITYREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COVERAGEELIGIBILITYRESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DETECTEDISSUE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICEDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICEMETRIC: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICEREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICEUSESTATEMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DIAGNOSTICREPORT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DOCUMENTMANIFEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DOCUMENTREFERENCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DOMAINRESOURCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EFFECTEVIDENCESYNTHESIS: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ENCOUNTER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ENDPOINT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ENROLLMENTREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ENROLLMENTRESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EPISODEOFCARE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EVENTDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EVIDENCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EVIDENCEVARIABLE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EXAMPLESCENARIO: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EXPLANATIONOFBENEFIT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case FAMILYMEMBERHISTORY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case FLAG: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case GOAL: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case GRAPHDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case GROUP: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case GUIDANCERESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case HEALTHCARESERVICE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMAGINGSTUDY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMMUNIZATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMMUNIZATIONEVALUATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMPLEMENTATIONGUIDE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case INSURANCEPLAN: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case INVOICE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case LIBRARY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case LINKAGE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case LIST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case LOCATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEASURE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEASUREREPORT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDIA: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONADMINISTRATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONDISPENSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONKNOWLEDGE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONSTATEMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICINALPRODUCT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICINALPRODUCTAUTHORIZATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICINALPRODUCTCONTRAINDICATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICINALPRODUCTINDICATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICINALPRODUCTINGREDIENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICINALPRODUCTINTERACTION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICINALPRODUCTMANUFACTURED: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICINALPRODUCTPACKAGED: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICINALPRODUCTPHARMACEUTICAL: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICINALPRODUCTUNDESIRABLEEFFECT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MESSAGEDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MESSAGEHEADER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MOLECULARSEQUENCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case NAMINGSYSTEM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case NUTRITIONORDER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case OBSERVATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case OBSERVATIONDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case OPERATIONDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case OPERATIONOUTCOME: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ORGANIZATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ORGANIZATIONAFFILIATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PARAMETERS: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PATIENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PAYMENTNOTICE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PAYMENTRECONCILIATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PERSON: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PLANDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PRACTITIONER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PRACTITIONERROLE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PROCEDURE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PROVENANCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case QUESTIONNAIRE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case QUESTIONNAIRERESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RELATEDPERSON: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case REQUESTGROUP: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RESEARCHDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RESEARCHELEMENTDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RESEARCHSTUDY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RESEARCHSUBJECT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RESOURCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RISKASSESSMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RISKEVIDENCESYNTHESIS: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SCHEDULE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SEARCHPARAMETER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SERVICEREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SLOT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SPECIMEN: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SPECIMENDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case STRUCTUREDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case STRUCTUREMAP: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSCRIPTION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSTANCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSTANCENUCLEICACID: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSTANCEPOLYMER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSTANCEPROTEIN: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSTANCEREFERENCEINFORMATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSTANCESOURCEMATERIAL: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSTANCESPECIFICATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUPPLYDELIVERY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUPPLYREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case TASK: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case TERMINOLOGYCAPABILITIES: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case TESTREPORT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case TESTSCRIPT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case VALUESET: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case VERIFICATIONRESULT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case VISIONPRESCRIPTION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACCOUNT: {
                    return "A financial tool for tracking value accrued for a particular purpose.  In the healthcare field, used to track charges for a patient, cost centers, etc.";
                }
                case ACTIVITYDEFINITION: {
                    return "This resource allows for the definition of some activity to be performed, independent of a particular patient, practitioner, or other performance context.";
                }
                case ADVERSEEVENT: {
                    return "Actual or  potential/avoided event causing unintended physical injury resulting from or contributed to by medical care, a research study or other healthcare setting factors that requires additional monitoring, treatment, or hospitalization, or that results in death.";
                }
                case ALLERGYINTOLERANCE: {
                    return "Risk of harmful or undesirable, physiological response which is unique to an individual and associated with exposure to a substance.";
                }
                case APPOINTMENT: {
                    return "A booking of a healthcare event among patient(s), practitioner(s), related person(s) and/or device(s) for a specific date/time. This may result in one or more Encounter(s).";
                }
                case APPOINTMENTRESPONSE: {
                    return "A reply to an appointment request for a patient and/or practitioner(s), such as a confirmation or rejection.";
                }
                case AUDITEVENT: {
                    return "A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.";
                }
                case BASIC: {
                    return "Basic is used for handling concepts not yet defined in FHIR, narrative-only resources that don't map to an existing resource, and custom resources not appropriate for inclusion in the FHIR specification.";
                }
                case BINARY: {
                    return "A resource that represents the data of a single raw artifact as digital content accessible in its native format.  A Binary resource can contain any content, whether text, image, pdf, zip archive, etc.";
                }
                case BIOLOGICALLYDERIVEDPRODUCT: {
                    return "A material substance originating from a biological entity intended to be transplanted or infused\ninto another (possibly the same) biological entity.";
                }
                case BODYSTRUCTURE: {
                    return "Record details about an anatomical structure.  This resource may be used when a coded concept does not provide the necessary detail needed for the use case.";
                }
                case BUNDLE: {
                    return "A container for a collection of resources.";
                }
                case CAPABILITYSTATEMENT: {
                    return "A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server for a particular version of FHIR that may be used as a statement of actual server functionality or a statement of required or desired server implementation.";
                }
                case CAREPLAN: {
                    return "Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.";
                }
                case CARETEAM: {
                    return "The Care Team includes all the people and organizations who plan to participate in the coordination and delivery of care for a patient.";
                }
                case CATALOGENTRY: {
                    return "Catalog entries are wrappers that contextualize items included in a catalog.";
                }
                case CHARGEITEM: {
                    return "The resource ChargeItem describes the provision of healthcare provider products for a certain patient, therefore referring not only to the product, but containing in addition details of the provision, like date, time, amounts and participating organizations and persons. Main Usage of the ChargeItem is to enable the billing process and internal cost allocation.";
                }
                case CHARGEITEMDEFINITION: {
                    return "The ChargeItemDefinition resource provides the properties that apply to the (billing) codes necessary to calculate costs and prices. The properties may differ largely depending on type and realm, therefore this resource gives only a rough structure and requires profiling for each type of billing code system.";
                }
                case CLAIM: {
                    return "A provider issued list of professional services and products which have been provided, or are to be provided, to a patient which is sent to an insurer for reimbursement.";
                }
                case CLAIMRESPONSE: {
                    return "This resource provides the adjudication details from the processing of a Claim resource.";
                }
                case CLINICALIMPRESSION: {
                    return "A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter,  but this varies greatly depending on the clinical workflow. This resource is called \"ClinicalImpression\" rather than \"ClinicalAssessment\" to avoid confusion with the recording of assessment tools such as Apgar score.";
                }
                case CODESYSTEM: {
                    return "The CodeSystem resource is used to declare the existence of and describe a code system or code system supplement and its key properties, and optionally define a part or all of its content.";
                }
                case COMMUNICATION: {
                    return "An occurrence of information being transmitted; e.g. an alert that was sent to a responsible provider, a public health agency that was notified about a reportable condition.";
                }
                case COMMUNICATIONREQUEST: {
                    return "A request to convey information; e.g. the CDS system proposes that an alert be sent to a responsible provider, the CDS system proposes that the public health agency be notified about a reportable condition.";
                }
                case COMPARTMENTDEFINITION: {
                    return "A compartment definition that defines how resources are accessed on a server.";
                }
                case COMPOSITION: {
                    return "A set of healthcare-related information that is assembled together into a single logical package that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. A Composition defines the structure and narrative content necessary for a document. However, a Composition alone does not constitute a document. Rather, the Composition must be the first entry in a Bundle where Bundle.type=document, and any other resources referenced from Composition must be included as subsequent entries in the Bundle (for example Patient, Practitioner, Encounter, etc.).";
                }
                case CONCEPTMAP: {
                    return "A statement of relationships from one set of concepts to one or more other concepts - either concepts in code systems, or data element/data element concepts, or classes in class models.";
                }
                case CONDITION: {
                    return "A clinical condition, problem, diagnosis, or other event, situation, issue, or clinical concept that has risen to a level of concern.";
                }
                case CONSENT: {
                    return "A record of a healthcare consumer\u2019s  choices, which permits or denies identified recipient(s) or recipient role(s) to perform one or more actions within a given policy context, for specific purposes and periods of time.";
                }
                case CONTRACT: {
                    return "Legally enforceable, formally recorded unilateral or bilateral directive i.e., a policy or agreement.";
                }
                case COVERAGE: {
                    return "Financial instrument which may be used to reimburse or pay for health care products and services. Includes both insurance and self-payment.";
                }
                case COVERAGEELIGIBILITYREQUEST: {
                    return "The CoverageEligibilityRequest provides patient and insurance coverage information to an insurer for them to respond, in the form of an CoverageEligibilityResponse, with information regarding whether the stated coverage is valid and in-force and optionally to provide the insurance details of the policy.";
                }
                case COVERAGEELIGIBILITYRESPONSE: {
                    return "This resource provides eligibility and plan details from the processing of an CoverageEligibilityRequest resource.";
                }
                case DETECTEDISSUE: {
                    return "Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. Drug-drug interaction, Ineffective treatment frequency, Procedure-condition conflict, etc.";
                }
                case DEVICE: {
                    return "A type of a manufactured item that is used in the provision of healthcare without being substantially changed through that activity. The device may be a medical or non-medical device.";
                }
                case DEVICEDEFINITION: {
                    return "The characteristics, operational status and capabilities of a medical-related component of a medical device.";
                }
                case DEVICEMETRIC: {
                    return "Describes a measurement, calculation or setting capability of a medical device.";
                }
                case DEVICEREQUEST: {
                    return "Represents a request for a patient to employ a medical device. The device may be an implantable device, or an external assistive device, such as a walker.";
                }
                case DEVICEUSESTATEMENT: {
                    return "A record of a device being used by a patient where the record is the result of a report from the patient or another clinician.";
                }
                case DIAGNOSTICREPORT: {
                    return "The findings and interpretation of diagnostic  tests performed on patients, groups of patients, devices, and locations, and/or specimens derived from these. The report includes clinical context such as requesting and provider information, and some mix of atomic results, images, textual and coded interpretations, and formatted representation of diagnostic reports.";
                }
                case DOCUMENTMANIFEST: {
                    return "A collection of documents compiled for a purpose together with metadata that applies to the collection.";
                }
                case DOCUMENTREFERENCE: {
                    return "A reference to a document of any kind for any purpose. Provides metadata about the document so that the document can be discovered and managed. The scope of a document is any seralized object with a mime-type, so includes formal patient centric documents (CDA), cliical notes, scanned paper, and non-patient specific documents like policy text.";
                }
                case DOMAINRESOURCE: {
                    return "A resource that includes narrative, extensions, and contained resources.";
                }
                case EFFECTEVIDENCESYNTHESIS: {
                    return "The EffectEvidenceSynthesis resource describes the difference in an outcome between exposures states in a population where the effect estimate is derived from a combination of research studies.";
                }
                case ENCOUNTER: {
                    return "An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient.";
                }
                case ENDPOINT: {
                    return "The technical details of an endpoint that can be used for electronic services, such as for web services providing XDS.b or a REST endpoint for another FHIR server. This may include any security context information.";
                }
                case ENROLLMENTREQUEST: {
                    return "This resource provides the insurance enrollment details to the insurer regarding a specified coverage.";
                }
                case ENROLLMENTRESPONSE: {
                    return "This resource provides enrollment and plan details from the processing of an EnrollmentRequest resource.";
                }
                case EPISODEOFCARE: {
                    return "An association between a patient and an organization / healthcare provider(s) during which time encounters may occur. The managing organization assumes a level of responsibility for the patient during this time.";
                }
                case EVENTDEFINITION: {
                    return "The EventDefinition resource provides a reusable description of when a particular event can occur.";
                }
                case EVIDENCE: {
                    return "The Evidence resource describes the conditional state (population and any exposures being compared within the population) and outcome (if specified) that the knowledge (evidence, assertion, recommendation) is about.";
                }
                case EVIDENCEVARIABLE: {
                    return "The EvidenceVariable resource describes a \"PICO\" element that knowledge (evidence, assertion, recommendation) is about.";
                }
                case EXAMPLESCENARIO: {
                    return "Example of workflow instance.";
                }
                case EXPLANATIONOFBENEFIT: {
                    return "This resource provides: the claim details; adjudication details from the processing of a Claim; and optionally account balance information, for informing the subscriber of the benefits provided.";
                }
                case FAMILYMEMBERHISTORY: {
                    return "Significant health conditions for a person related to the patient relevant in the context of care for the patient.";
                }
                case FLAG: {
                    return "Prospective warnings of potential issues when providing care to the patient.";
                }
                case GOAL: {
                    return "Describes the intended objective(s) for a patient, group or organization care, for example, weight loss, restoring an activity of daily living, obtaining herd immunity via immunization, meeting a process improvement objective, etc.";
                }
                case GRAPHDEFINITION: {
                    return "A formal computable definition of a graph of resources - that is, a coherent set of resources that form a graph by following references. The Graph Definition resource defines a set and makes rules about the set.";
                }
                case GROUP: {
                    return "Represents a defined collection of entities that may be discussed or acted upon collectively but which are not expected to act collectively, and are not formally or legally recognized; i.e. a collection of entities that isn't an Organization.";
                }
                case GUIDANCERESPONSE: {
                    return "A guidance response is the formal response to a guidance request, including any output parameters returned by the evaluation, as well as the description of any proposed actions to be taken.";
                }
                case HEALTHCARESERVICE: {
                    return "The details of a healthcare service available at a location.";
                }
                case IMAGINGSTUDY: {
                    return "Representation of the content produced in a DICOM imaging study. A study comprises a set of series, each of which includes a set of Service-Object Pair Instances (SOP Instances - images or other data) acquired or produced in a common context.  A series is of only one modality (e.g. X-ray, CT, MR, ultrasound), but a study may have multiple series of different modalities.";
                }
                case IMMUNIZATION: {
                    return "Describes the event of a patient being administered a vaccine or a record of an immunization as reported by a patient, a clinician or another party.";
                }
                case IMMUNIZATIONEVALUATION: {
                    return "Describes a comparison of an immunization event against published recommendations to determine if the administration is \"valid\" in relation to those  recommendations.";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "A patient's point-in-time set of recommendations (i.e. forecasting) according to a published schedule with optional supporting justification.";
                }
                case IMPLEMENTATIONGUIDE: {
                    return "A set of rules of how a particular interoperability or standards problem is solved - typically through the use of FHIR resources. This resource is used to gather all the parts of an implementation guide into a logical whole and to publish a computable definition of all the parts.";
                }
                case INSURANCEPLAN: {
                    return "Details of a Health Insurance product/plan provided by an organization.";
                }
                case INVOICE: {
                    return "Invoice containing collected ChargeItems from an Account with calculated individual and total price for Billing purpose.";
                }
                case LIBRARY: {
                    return "The Library resource is a general-purpose container for knowledge asset definitions. It can be used to describe and expose existing knowledge assets such as logic libraries and information model descriptions, as well as to describe a collection of knowledge assets.";
                }
                case LINKAGE: {
                    return "Identifies two or more records (resource instances) that refer to the same real-world \"occurrence\".";
                }
                case LIST: {
                    return "A list is a curated collection of resources.";
                }
                case LOCATION: {
                    return "Details and position information for a physical place where services are provided and resources and participants may be stored, found, contained, or accommodated.";
                }
                case MEASURE: {
                    return "The Measure resource provides the definition of a quality measure.";
                }
                case MEASUREREPORT: {
                    return "The MeasureReport resource contains the results of the calculation of a measure; and optionally a reference to the resources involved in that calculation.";
                }
                case MEDIA: {
                    return "A photo, video, or audio recording acquired or used in healthcare. The actual content may be inline or provided by direct reference.";
                }
                case MEDICATION: {
                    return "This resource is primarily used for the identification and definition of a medication for the purposes of prescribing, dispensing, and administering a medication as well as for making statements about medication use.";
                }
                case MEDICATIONADMINISTRATION: {
                    return "Describes the event of a patient consuming or otherwise being administered a medication.  This may be as simple as swallowing a tablet or it may be a long running infusion.  Related resources tie this event to the authorizing prescription, and the specific encounter between patient and health care practitioner.";
                }
                case MEDICATIONDISPENSE: {
                    return "Indicates that a medication product is to be or has been dispensed for a named person/patient.  This includes a description of the medication product (supply) provided and the instructions for administering the medication.  The medication dispense is the result of a pharmacy system responding to a medication order.";
                }
                case MEDICATIONKNOWLEDGE: {
                    return "Information about a medication that is used to support knowledge.";
                }
                case MEDICATIONREQUEST: {
                    return "An order or request for both supply of the medication and the instructions for administration of the medication to a patient. The resource is called \"MedicationRequest\" rather than \"MedicationPrescription\" or \"MedicationOrder\" to generalize the use across inpatient and outpatient settings, including care plans, etc., and to harmonize with workflow patterns.";
                }
                case MEDICATIONSTATEMENT: {
                    return "A record of a medication that is being consumed by a patient.   A MedicationStatement may indicate that the patient may be taking the medication now or has taken the medication in the past or will be taking the medication in the future.  The source of this information can be the patient, significant other (such as a family member or spouse), or a clinician.  A common scenario where this information is captured is during the history taking process during a patient visit or stay.   The medication information may come from sources such as the patient's memory, from a prescription bottle,  or from a list of medications the patient, clinician or other party maintains. \n\nThe primary difference between a medication statement and a medication administration is that the medication administration has complete administration information and is based on actual administration information from the person who administered the medication.  A medication statement is often, if not always, less specific.  There is no required date/time when the medication was administered, in fact we only know that a source has reported the patient is taking this medication, where details such as time, quantity, or rate or even medication product may be incomplete or missing or less precise.  As stated earlier, the medication statement information may come from the patient's memory, from a prescription bottle or from a list of medications the patient, clinician or other party maintains.  Medication administration is more formal and is not missing detailed information.";
                }
                case MEDICINALPRODUCT: {
                    return "Detailed definition of a medicinal product, typically for uses other than direct patient care (e.g. regulatory use).";
                }
                case MEDICINALPRODUCTAUTHORIZATION: {
                    return "The regulatory authorization of a medicinal product.";
                }
                case MEDICINALPRODUCTCONTRAINDICATION: {
                    return "The clinical particulars - indications, contraindications etc. of a medicinal product, including for regulatory purposes.";
                }
                case MEDICINALPRODUCTINDICATION: {
                    return "Indication for the Medicinal Product.";
                }
                case MEDICINALPRODUCTINGREDIENT: {
                    return "An ingredient of a manufactured item or pharmaceutical product.";
                }
                case MEDICINALPRODUCTINTERACTION: {
                    return "The interactions of the medicinal product with other medicinal products, or other forms of interactions.";
                }
                case MEDICINALPRODUCTMANUFACTURED: {
                    return "The manufactured item as contained in the packaged medicinal product.";
                }
                case MEDICINALPRODUCTPACKAGED: {
                    return "A medicinal product in a container or package.";
                }
                case MEDICINALPRODUCTPHARMACEUTICAL: {
                    return "A pharmaceutical product described in terms of its composition and dose form.";
                }
                case MEDICINALPRODUCTUNDESIRABLEEFFECT: {
                    return "Describe the undesirable effects of the medicinal product.";
                }
                case MESSAGEDEFINITION: {
                    return "Defines the characteristics of a message that can be shared between systems, including the type of event that initiates the message, the content to be transmitted and what response(s), if any, are permitted.";
                }
                case MESSAGEHEADER: {
                    return "The header for a message exchange that is either requesting or responding to an action.  The reference(s) that are the subject of the action as well as other information related to the action are typically transmitted in a bundle in which the MessageHeader resource instance is the first resource in the bundle.";
                }
                case MOLECULARSEQUENCE: {
                    return "Raw data describing a biological sequence.";
                }
                case NAMINGSYSTEM: {
                    return "A curated namespace that issues unique symbols within that namespace for the identification of concepts, people, devices, etc.  Represents a \"System\" used within the Identifier and Coding data types.";
                }
                case NUTRITIONORDER: {
                    return "A request to supply a diet, formula feeding (enteral) or oral nutritional supplement to a patient/resident.";
                }
                case OBSERVATION: {
                    return "Measurements and simple assertions made about a patient, device or other subject.";
                }
                case OBSERVATIONDEFINITION: {
                    return "Set of definitional characteristics for a kind of observation or measurement produced or consumed by an orderable health care service.";
                }
                case OPERATIONDEFINITION: {
                    return "A formal computable definition of an operation (on the RESTful interface) or a named query (using the search interaction).";
                }
                case OPERATIONOUTCOME: {
                    return "A collection of error, warning, or information messages that result from a system action.";
                }
                case ORGANIZATION: {
                    return "A formally or informally recognized grouping of people or organizations formed for the purpose of achieving some form of collective action.  Includes companies, institutions, corporations, departments, community groups, healthcare practice groups, payer/insurer, etc.";
                }
                case ORGANIZATIONAFFILIATION: {
                    return "Defines an affiliation/assotiation/relationship between 2 distinct oganizations, that is not a part-of relationship/sub-division relationship.";
                }
                case PARAMETERS: {
                    return "This resource is a non-persisted resource used to pass information into and back from an [operation](operations.html). It has no other use, and there is no RESTful endpoint associated with it.";
                }
                case PATIENT: {
                    return "Demographics and other administrative information about an individual or animal receiving care or other health-related services.";
                }
                case PAYMENTNOTICE: {
                    return "This resource provides the status of the payment for goods and services rendered, and the request and response resource references.";
                }
                case PAYMENTRECONCILIATION: {
                    return "This resource provides the details including amount of a payment and allocates the payment items being paid.";
                }
                case PERSON: {
                    return "Demographics and administrative information about a person independent of a specific health-related context.";
                }
                case PLANDEFINITION: {
                    return "This resource allows for the definition of various types of plans as a sharable, consumable, and executable artifact. The resource is general enough to support the description of a broad range of clinical artifacts such as clinical decision support rules, order sets and protocols.";
                }
                case PRACTITIONER: {
                    return "A person who is directly or indirectly involved in the provisioning of healthcare.";
                }
                case PRACTITIONERROLE: {
                    return "A specific set of Roles/Locations/specialties/services that a practitioner may perform at an organization for a period of time.";
                }
                case PROCEDURE: {
                    return "An action that is or was performed on or for a patient. This can be a physical intervention like an operation, or less invasive like long term services, counseling, or hypnotherapy.";
                }
                case PROVENANCE: {
                    return "Provenance of a resource is a record that describes entities and processes involved in producing and delivering or otherwise influencing that resource. Provenance provides a critical foundation for assessing authenticity, enabling trust, and allowing reproducibility. Provenance assertions are a form of contextual metadata and can themselves become important records with their own provenance. Provenance statement indicates clinical significance in terms of confidence in authenticity, reliability, and trustworthiness, integrity, and stage in lifecycle (e.g. Document Completion - has the artifact been legally authenticated), all of which may impact security, privacy, and trust policies.";
                }
                case QUESTIONNAIRE: {
                    return "A structured set of questions intended to guide the collection of answers from end-users. Questionnaires provide detailed control over order, presentation, phraseology and grouping to allow coherent, consistent data collection.";
                }
                case QUESTIONNAIRERESPONSE: {
                    return "A structured set of questions and their answers. The questions are ordered and grouped into coherent subsets, corresponding to the structure of the grouping of the questionnaire being responded to.";
                }
                case RELATEDPERSON: {
                    return "Information about a person that is involved in the care for a patient, but who is not the target of healthcare, nor has a formal responsibility in the care process.";
                }
                case REQUESTGROUP: {
                    return "A group of related requests that can be used to capture intended activities that have inter-dependencies such as \"give this medication after that one\".";
                }
                case RESEARCHDEFINITION: {
                    return "The ResearchDefinition resource describes the conditional state (population and any exposures being compared within the population) and outcome (if specified) that the knowledge (evidence, assertion, recommendation) is about.";
                }
                case RESEARCHELEMENTDEFINITION: {
                    return "The ResearchElementDefinition resource describes a \"PICO\" element that knowledge (evidence, assertion, recommendation) is about.";
                }
                case RESEARCHSTUDY: {
                    return "A process where a researcher or organization plans and then executes a series of steps intended to increase the field of healthcare-related knowledge.  This includes studies of safety, efficacy, comparative effectiveness and other information about medications, devices, therapies and other interventional and investigative techniques.  A ResearchStudy involves the gathering of information about human or animal subjects.";
                }
                case RESEARCHSUBJECT: {
                    return "A physical entity which is the primary unit of operational and/or administrative interest in a study.";
                }
                case RESOURCE: {
                    return "This is the base resource type for everything.";
                }
                case RISKASSESSMENT: {
                    return "An assessment of the likely outcome(s) for a patient or other subject as well as the likelihood of each outcome.";
                }
                case RISKEVIDENCESYNTHESIS: {
                    return "The RiskEvidenceSynthesis resource describes the likelihood of an outcome in a population plus exposure state where the risk estimate is derived from a combination of research studies.";
                }
                case SCHEDULE: {
                    return "A container for slots of time that may be available for booking appointments.";
                }
                case SEARCHPARAMETER: {
                    return "A search parameter that defines a named search item that can be used to search/filter on a resource.";
                }
                case SERVICEREQUEST: {
                    return "A record of a request for service such as diagnostic investigations, treatments, or operations to be performed.";
                }
                case SLOT: {
                    return "A slot of time on a schedule that may be available for booking appointments.";
                }
                case SPECIMEN: {
                    return "A sample to be used for analysis.";
                }
                case SPECIMENDEFINITION: {
                    return "A kind of specimen with associated set of requirements.";
                }
                case STRUCTUREDEFINITION: {
                    return "A definition of a FHIR structure. This resource is used to describe the underlying resources, data types defined in FHIR, and also for describing extensions and constraints on resources and data types.";
                }
                case STRUCTUREMAP: {
                    return "A Map of relationships between 2 structures that can be used to transform data.";
                }
                case SUBSCRIPTION: {
                    return "The subscription resource is used to define a push-based subscription from a server to another system. Once a subscription is registered with the server, the server checks every resource that is created or updated, and if the resource matches the given criteria, it sends a message on the defined \"channel\" so that another system can take an appropriate action.";
                }
                case SUBSTANCE: {
                    return "A homogeneous material with a definite composition.";
                }
                case SUBSTANCENUCLEICACID: {
                    return "Nucleic acids are defined by three distinct elements: the base, sugar and linkage. Individual substance/moiety IDs will be created for each of these elements. The nucleotide sequence will be always entered in the 5\u2019-3\u2019 direction.";
                }
                case SUBSTANCEPOLYMER: {
                    return "Todo.";
                }
                case SUBSTANCEPROTEIN: {
                    return "A SubstanceProtein is defined as a single unit of a linear amino acid sequence, or a combination of subunits that are either covalently linked or have a defined invariant stoichiometric relationship. This includes all synthetic, recombinant and purified SubstanceProteins of defined sequence, whether the use is therapeutic or prophylactic. This set of elements will be used to describe albumins, coagulation factors, cytokines, growth factors, peptide/SubstanceProtein hormones, enzymes, toxins, toxoids, recombinant vaccines, and immunomodulators.";
                }
                case SUBSTANCEREFERENCEINFORMATION: {
                    return "Todo.";
                }
                case SUBSTANCESOURCEMATERIAL: {
                    return "Source material shall capture information on the taxonomic and anatomical origins as well as the fraction of a material that can result in or can be modified to form a substance. This set of data elements shall be used to define polymer substances isolated from biological matrices. Taxonomic and anatomical origins shall be described using a controlled vocabulary as required. This information is captured for naturally derived polymers ( . starch) and structurally diverse substances. For Organisms belonging to the Kingdom Plantae the Substance level defines the fresh material of a single species or infraspecies, the Herbal Drug and the Herbal preparation. For Herbal preparations, the fraction information will be captured at the Substance information level and additional information for herbal extracts will be captured at the Specified Substance Group 1 information level. See for further explanation the Substance Class: Structurally Diverse and the herbal annex.";
                }
                case SUBSTANCESPECIFICATION: {
                    return "The detailed description of a substance, typically at a level beyond what is used for prescribing.";
                }
                case SUPPLYDELIVERY: {
                    return "Record of delivery of what is supplied.";
                }
                case SUPPLYREQUEST: {
                    return "A record of a request for a medication, substance or device used in the healthcare setting.";
                }
                case TASK: {
                    return "A task to be performed.";
                }
                case TERMINOLOGYCAPABILITIES: {
                    return "A TerminologyCapabilities resource documents a set of capabilities (behaviors) of a FHIR Terminology Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.";
                }
                case TESTREPORT: {
                    return "A summary of information based on the results of executing a TestScript.";
                }
                case TESTSCRIPT: {
                    return "A structured set of tests against a FHIR server or client implementation to determine compliance against the FHIR specification.";
                }
                case VALUESET: {
                    return "A ValueSet resource instance specifies a set of codes drawn from one or more code systems, intended for use in a particular context. Value sets link between [[[CodeSystem]]] definitions and their use in [coded elements](terminologies.html).";
                }
                case VERIFICATIONRESULT: {
                    return "Describes validation requirements, source(s), status and dates for one or more elements.";
                }
                case VISIONPRESCRIPTION: {
                    return "An authorization for the provision of glasses and/or contact lenses to a patient.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACCOUNT: {
                    return "Account";
                }
                case ACTIVITYDEFINITION: {
                    return "ActivityDefinition";
                }
                case ADVERSEEVENT: {
                    return "AdverseEvent";
                }
                case ALLERGYINTOLERANCE: {
                    return "AllergyIntolerance";
                }
                case APPOINTMENT: {
                    return "Appointment";
                }
                case APPOINTMENTRESPONSE: {
                    return "AppointmentResponse";
                }
                case AUDITEVENT: {
                    return "AuditEvent";
                }
                case BASIC: {
                    return "Basic";
                }
                case BINARY: {
                    return "Binary";
                }
                case BIOLOGICALLYDERIVEDPRODUCT: {
                    return "BiologicallyDerivedProduct";
                }
                case BODYSTRUCTURE: {
                    return "BodyStructure";
                }
                case BUNDLE: {
                    return "Bundle";
                }
                case CAPABILITYSTATEMENT: {
                    return "CapabilityStatement";
                }
                case CAREPLAN: {
                    return "CarePlan";
                }
                case CARETEAM: {
                    return "CareTeam";
                }
                case CATALOGENTRY: {
                    return "CatalogEntry";
                }
                case CHARGEITEM: {
                    return "ChargeItem";
                }
                case CHARGEITEMDEFINITION: {
                    return "ChargeItemDefinition";
                }
                case CLAIM: {
                    return "Claim";
                }
                case CLAIMRESPONSE: {
                    return "ClaimResponse";
                }
                case CLINICALIMPRESSION: {
                    return "ClinicalImpression";
                }
                case CODESYSTEM: {
                    return "CodeSystem";
                }
                case COMMUNICATION: {
                    return "Communication";
                }
                case COMMUNICATIONREQUEST: {
                    return "CommunicationRequest";
                }
                case COMPARTMENTDEFINITION: {
                    return "CompartmentDefinition";
                }
                case COMPOSITION: {
                    return "Composition";
                }
                case CONCEPTMAP: {
                    return "ConceptMap";
                }
                case CONDITION: {
                    return "Condition";
                }
                case CONSENT: {
                    return "Consent";
                }
                case CONTRACT: {
                    return "Contract";
                }
                case COVERAGE: {
                    return "Coverage";
                }
                case COVERAGEELIGIBILITYREQUEST: {
                    return "CoverageEligibilityRequest";
                }
                case COVERAGEELIGIBILITYRESPONSE: {
                    return "CoverageEligibilityResponse";
                }
                case DETECTEDISSUE: {
                    return "DetectedIssue";
                }
                case DEVICE: {
                    return "Device";
                }
                case DEVICEDEFINITION: {
                    return "DeviceDefinition";
                }
                case DEVICEMETRIC: {
                    return "DeviceMetric";
                }
                case DEVICEREQUEST: {
                    return "DeviceRequest";
                }
                case DEVICEUSESTATEMENT: {
                    return "DeviceUseStatement";
                }
                case DIAGNOSTICREPORT: {
                    return "DiagnosticReport";
                }
                case DOCUMENTMANIFEST: {
                    return "DocumentManifest";
                }
                case DOCUMENTREFERENCE: {
                    return "DocumentReference";
                }
                case DOMAINRESOURCE: {
                    return "DomainResource";
                }
                case EFFECTEVIDENCESYNTHESIS: {
                    return "EffectEvidenceSynthesis";
                }
                case ENCOUNTER: {
                    return "Encounter";
                }
                case ENDPOINT: {
                    return "Endpoint";
                }
                case ENROLLMENTREQUEST: {
                    return "EnrollmentRequest";
                }
                case ENROLLMENTRESPONSE: {
                    return "EnrollmentResponse";
                }
                case EPISODEOFCARE: {
                    return "EpisodeOfCare";
                }
                case EVENTDEFINITION: {
                    return "EventDefinition";
                }
                case EVIDENCE: {
                    return "Evidence";
                }
                case EVIDENCEVARIABLE: {
                    return "EvidenceVariable";
                }
                case EXAMPLESCENARIO: {
                    return "ExampleScenario";
                }
                case EXPLANATIONOFBENEFIT: {
                    return "ExplanationOfBenefit";
                }
                case FAMILYMEMBERHISTORY: {
                    return "FamilyMemberHistory";
                }
                case FLAG: {
                    return "Flag";
                }
                case GOAL: {
                    return "Goal";
                }
                case GRAPHDEFINITION: {
                    return "GraphDefinition";
                }
                case GROUP: {
                    return "Group";
                }
                case GUIDANCERESPONSE: {
                    return "GuidanceResponse";
                }
                case HEALTHCARESERVICE: {
                    return "HealthcareService";
                }
                case IMAGINGSTUDY: {
                    return "ImagingStudy";
                }
                case IMMUNIZATION: {
                    return "Immunization";
                }
                case IMMUNIZATIONEVALUATION: {
                    return "ImmunizationEvaluation";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "ImmunizationRecommendation";
                }
                case IMPLEMENTATIONGUIDE: {
                    return "ImplementationGuide";
                }
                case INSURANCEPLAN: {
                    return "InsurancePlan";
                }
                case INVOICE: {
                    return "Invoice";
                }
                case LIBRARY: {
                    return "Library";
                }
                case LINKAGE: {
                    return "Linkage";
                }
                case LIST: {
                    return "List";
                }
                case LOCATION: {
                    return "Location";
                }
                case MEASURE: {
                    return "Measure";
                }
                case MEASUREREPORT: {
                    return "MeasureReport";
                }
                case MEDIA: {
                    return "Media";
                }
                case MEDICATION: {
                    return "Medication";
                }
                case MEDICATIONADMINISTRATION: {
                    return "MedicationAdministration";
                }
                case MEDICATIONDISPENSE: {
                    return "MedicationDispense";
                }
                case MEDICATIONKNOWLEDGE: {
                    return "MedicationKnowledge";
                }
                case MEDICATIONREQUEST: {
                    return "MedicationRequest";
                }
                case MEDICATIONSTATEMENT: {
                    return "MedicationStatement";
                }
                case MEDICINALPRODUCT: {
                    return "MedicinalProduct";
                }
                case MEDICINALPRODUCTAUTHORIZATION: {
                    return "MedicinalProductAuthorization";
                }
                case MEDICINALPRODUCTCONTRAINDICATION: {
                    return "MedicinalProductContraindication";
                }
                case MEDICINALPRODUCTINDICATION: {
                    return "MedicinalProductIndication";
                }
                case MEDICINALPRODUCTINGREDIENT: {
                    return "MedicinalProductIngredient";
                }
                case MEDICINALPRODUCTINTERACTION: {
                    return "MedicinalProductInteraction";
                }
                case MEDICINALPRODUCTMANUFACTURED: {
                    return "MedicinalProductManufactured";
                }
                case MEDICINALPRODUCTPACKAGED: {
                    return "MedicinalProductPackaged";
                }
                case MEDICINALPRODUCTPHARMACEUTICAL: {
                    return "MedicinalProductPharmaceutical";
                }
                case MEDICINALPRODUCTUNDESIRABLEEFFECT: {
                    return "MedicinalProductUndesirableEffect";
                }
                case MESSAGEDEFINITION: {
                    return "MessageDefinition";
                }
                case MESSAGEHEADER: {
                    return "MessageHeader";
                }
                case MOLECULARSEQUENCE: {
                    return "MolecularSequence";
                }
                case NAMINGSYSTEM: {
                    return "NamingSystem";
                }
                case NUTRITIONORDER: {
                    return "NutritionOrder";
                }
                case OBSERVATION: {
                    return "Observation";
                }
                case OBSERVATIONDEFINITION: {
                    return "ObservationDefinition";
                }
                case OPERATIONDEFINITION: {
                    return "OperationDefinition";
                }
                case OPERATIONOUTCOME: {
                    return "OperationOutcome";
                }
                case ORGANIZATION: {
                    return "Organization";
                }
                case ORGANIZATIONAFFILIATION: {
                    return "OrganizationAffiliation";
                }
                case PARAMETERS: {
                    return "Parameters";
                }
                case PATIENT: {
                    return "Patient";
                }
                case PAYMENTNOTICE: {
                    return "PaymentNotice";
                }
                case PAYMENTRECONCILIATION: {
                    return "PaymentReconciliation";
                }
                case PERSON: {
                    return "Person";
                }
                case PLANDEFINITION: {
                    return "PlanDefinition";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case PRACTITIONERROLE: {
                    return "PractitionerRole";
                }
                case PROCEDURE: {
                    return "Procedure";
                }
                case PROVENANCE: {
                    return "Provenance";
                }
                case QUESTIONNAIRE: {
                    return "Questionnaire";
                }
                case QUESTIONNAIRERESPONSE: {
                    return "QuestionnaireResponse";
                }
                case RELATEDPERSON: {
                    return "RelatedPerson";
                }
                case REQUESTGROUP: {
                    return "RequestGroup";
                }
                case RESEARCHDEFINITION: {
                    return "ResearchDefinition";
                }
                case RESEARCHELEMENTDEFINITION: {
                    return "ResearchElementDefinition";
                }
                case RESEARCHSTUDY: {
                    return "ResearchStudy";
                }
                case RESEARCHSUBJECT: {
                    return "ResearchSubject";
                }
                case RESOURCE: {
                    return "Resource";
                }
                case RISKASSESSMENT: {
                    return "RiskAssessment";
                }
                case RISKEVIDENCESYNTHESIS: {
                    return "RiskEvidenceSynthesis";
                }
                case SCHEDULE: {
                    return "Schedule";
                }
                case SEARCHPARAMETER: {
                    return "SearchParameter";
                }
                case SERVICEREQUEST: {
                    return "ServiceRequest";
                }
                case SLOT: {
                    return "Slot";
                }
                case SPECIMEN: {
                    return "Specimen";
                }
                case SPECIMENDEFINITION: {
                    return "SpecimenDefinition";
                }
                case STRUCTUREDEFINITION: {
                    return "StructureDefinition";
                }
                case STRUCTUREMAP: {
                    return "StructureMap";
                }
                case SUBSCRIPTION: {
                    return "Subscription";
                }
                case SUBSTANCE: {
                    return "Substance";
                }
                case SUBSTANCENUCLEICACID: {
                    return "SubstanceNucleicAcid";
                }
                case SUBSTANCEPOLYMER: {
                    return "SubstancePolymer";
                }
                case SUBSTANCEPROTEIN: {
                    return "SubstanceProtein";
                }
                case SUBSTANCEREFERENCEINFORMATION: {
                    return "SubstanceReferenceInformation";
                }
                case SUBSTANCESOURCEMATERIAL: {
                    return "SubstanceSourceMaterial";
                }
                case SUBSTANCESPECIFICATION: {
                    return "SubstanceSpecification";
                }
                case SUPPLYDELIVERY: {
                    return "SupplyDelivery";
                }
                case SUPPLYREQUEST: {
                    return "SupplyRequest";
                }
                case TASK: {
                    return "Task";
                }
                case TERMINOLOGYCAPABILITIES: {
                    return "TerminologyCapabilities";
                }
                case TESTREPORT: {
                    return "TestReport";
                }
                case TESTSCRIPT: {
                    return "TestScript";
                }
                case VALUESET: {
                    return "ValueSet";
                }
                case VERIFICATIONRESULT: {
                    return "VerificationResult";
                }
                case VISIONPRESCRIPTION: {
                    return "VisionPrescription";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ExampleScenarioActorTypeEnumFactory
    implements EnumFactory<ExampleScenarioActorType> {
        @Override
        public ExampleScenarioActorType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("person".equals(codeString)) {
                return ExampleScenarioActorType.PERSON;
            }
            if ("entity".equals(codeString)) {
                return ExampleScenarioActorType.ENTITY;
            }
            throw new IllegalArgumentException("Unknown ExampleScenarioActorType code '" + codeString + "'");
        }

        public Enumeration<ExampleScenarioActorType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ExampleScenarioActorType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("person".equals(codeString)) {
                return new Enumeration<ExampleScenarioActorType>(this, ExampleScenarioActorType.PERSON);
            }
            if ("entity".equals(codeString)) {
                return new Enumeration<ExampleScenarioActorType>(this, ExampleScenarioActorType.ENTITY);
            }
            throw new FHIRException("Unknown ExampleScenarioActorType code '" + codeString + "'");
        }

        @Override
        public String toCode(ExampleScenarioActorType code) {
            if (code == ExampleScenarioActorType.PERSON) {
                return "person";
            }
            if (code == ExampleScenarioActorType.ENTITY) {
                return "entity";
            }
            return "?";
        }

        @Override
        public String toSystem(ExampleScenarioActorType code) {
            return code.getSystem();
        }
    }

    public static enum ExampleScenarioActorType {
        PERSON,
        ENTITY,
        NULL;


        public static ExampleScenarioActorType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("person".equals(codeString)) {
                return PERSON;
            }
            if ("entity".equals(codeString)) {
                return ENTITY;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ExampleScenarioActorType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PERSON: {
                    return "person";
                }
                case ENTITY: {
                    return "entity";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PERSON: {
                    return "http://hl7.org/fhir/examplescenario-actor-type";
                }
                case ENTITY: {
                    return "http://hl7.org/fhir/examplescenario-actor-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PERSON: {
                    return "A person.";
                }
                case ENTITY: {
                    return "A system.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PERSON: {
                    return "Person";
                }
                case ENTITY: {
                    return "System";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

