/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DiagnosticReport;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.FamilyMemberHistory;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ImagingStudy;
import org.hl7.fhir.r4.model.Media;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.RiskAssessment;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ClinicalImpression", profile="http://hl7.org/fhir/StructureDefinition/ClinicalImpression")
public class ClinicalImpression
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier", formalDefinition="Business identifiers assigned to this clinical impression by the performer or other systems which remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="in-progress | completed | entered-in-error", formalDefinition="Identifies the workflow status of the assessment.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinicalimpression-status")
    protected Enumeration<ClinicalImpressionStatus> status;
    @Child(name="statusReason", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for current status", formalDefinition="Captures the reason for the current state of the ClinicalImpression.")
    protected CodeableConcept statusReason;
    @Child(name="code", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of assessment performed", formalDefinition="Categorizes the type of clinical assessment performed.")
    protected CodeableConcept code;
    @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Why/how the assessment was performed", formalDefinition="A summary of the context and/or cause of the assessment - why / where it was performed, and what patient events/status prompted it.")
    protected StringType description;
    @Child(name="subject", type={Patient.class, Group.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient or group assessed", formalDefinition="The patient or group of individuals assessed as part of this record.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="encounter", type={Encounter.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter created as part of", formalDefinition="The Encounter during which this ClinicalImpression was created or to which the creation of this record is tightly associated.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="effective", type={DateTimeType.class, Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time of assessment", formalDefinition="The point in time or period over which the subject was assessed.")
    protected Type effective;
    @Child(name="date", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the assessment was documented", formalDefinition="Indicates when the documentation of the assessment was complete.")
    protected DateTimeType date;
    @Child(name="assessor", type={Practitioner.class, PractitionerRole.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The clinician performing the assessment", formalDefinition="The clinician performing the assessment.")
    protected Reference assessor;
    protected Resource assessorTarget;
    @Child(name="previous", type={ClinicalImpression.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to last assessment", formalDefinition="A reference to the last assessment that was conducted on this patient. Assessments are often/usually ongoing in nature; a care provider (practitioner or team) will make new assessments on an ongoing basis as new data arises or the patient's conditions changes.")
    protected Reference previous;
    protected ClinicalImpression previousTarget;
    @Child(name="problem", type={Condition.class, AllergyIntolerance.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Relevant impressions of patient state", formalDefinition="A list of the relevant problems/conditions for a patient.")
    protected List<Reference> problem;
    protected List<Resource> problemTarget;
    @Child(name="investigation", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="One or more sets of investigations (signs, symptoms, etc.)", formalDefinition="One or more sets of investigations (signs, symptoms, etc.). The actual grouping of investigations varies greatly depending on the type and context of the assessment. These investigations may include data generated during the assessment process, or data previously generated and recorded that is pertinent to the outcomes.")
    protected List<ClinicalImpressionInvestigationComponent> investigation;
    @Child(name="protocol", type={UriType.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Clinical Protocol followed", formalDefinition="Reference to a specific published clinical protocol that was followed during this assessment, and/or that provides evidence in support of the diagnosis.")
    protected List<UriType> protocol;
    @Child(name="summary", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Summary of the assessment", formalDefinition="A text summary of the investigations and the diagnosis.")
    protected StringType summary;
    @Child(name="finding", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Possible or likely findings and diagnoses", formalDefinition="Specific findings or diagnoses that were considered likely or relevant to ongoing treatment.")
    protected List<ClinicalImpressionFindingComponent> finding;
    @Child(name="prognosisCodeableConcept", type={CodeableConcept.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Estimate of likely outcome", formalDefinition="Estimate of likely outcome.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinicalimpression-prognosis")
    protected List<CodeableConcept> prognosisCodeableConcept;
    @Child(name="prognosisReference", type={RiskAssessment.class}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="RiskAssessment expressing likely outcome", formalDefinition="RiskAssessment expressing likely outcome.")
    protected List<Reference> prognosisReference;
    protected List<RiskAssessment> prognosisReferenceTarget;
    @Child(name="supportingInfo", type={Reference.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information supporting the clinical impression", formalDefinition="Information supporting the clinical impression.")
    protected List<Reference> supportingInfo;
    protected List<Resource> supportingInfoTarget;
    @Child(name="note", type={Annotation.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about the ClinicalImpression", formalDefinition="Commentary about the impression, typically recorded after the impression itself was made, though supplemental notes by the original author could also appear.")
    protected List<Annotation> note;
    private static final long serialVersionUID = 1158874575L;
    @SearchParamDefinition(name="date", path="ClinicalImpression.date", description="When the assessment was documented", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ClinicalImpression.identifier", description="Business identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="previous", path="ClinicalImpression.previous", description="Reference to last assessment", type="reference", target={ClinicalImpression.class})
    public static final String SP_PREVIOUS = "previous";
    public static final ReferenceClientParam PREVIOUS = new ReferenceClientParam("previous");
    public static final Include INCLUDE_PREVIOUS = new Include("ClinicalImpression:previous").toLocked();
    @SearchParamDefinition(name="finding-code", path="ClinicalImpression.finding.itemCodeableConcept", description="What was found", type="token")
    public static final String SP_FINDING_CODE = "finding-code";
    public static final TokenClientParam FINDING_CODE = new TokenClientParam("finding-code");
    @SearchParamDefinition(name="assessor", path="ClinicalImpression.assessor", description="The clinician performing the assessment", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class, PractitionerRole.class})
    public static final String SP_ASSESSOR = "assessor";
    public static final ReferenceClientParam ASSESSOR = new ReferenceClientParam("assessor");
    public static final Include INCLUDE_ASSESSOR = new Include("ClinicalImpression:assessor").toLocked();
    @SearchParamDefinition(name="subject", path="ClinicalImpression.subject", description="Patient or group assessed", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("ClinicalImpression:subject").toLocked();
    @SearchParamDefinition(name="encounter", path="ClinicalImpression.encounter", description="Encounter created as part of", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("ClinicalImpression:encounter").toLocked();
    @SearchParamDefinition(name="finding-ref", path="ClinicalImpression.finding.itemReference", description="What was found", type="reference", target={Condition.class, Media.class, Observation.class})
    public static final String SP_FINDING_REF = "finding-ref";
    public static final ReferenceClientParam FINDING_REF = new ReferenceClientParam("finding-ref");
    public static final Include INCLUDE_FINDING_REF = new Include("ClinicalImpression:finding-ref").toLocked();
    @SearchParamDefinition(name="problem", path="ClinicalImpression.problem", description="Relevant impressions of patient state", type="reference", target={AllergyIntolerance.class, Condition.class})
    public static final String SP_PROBLEM = "problem";
    public static final ReferenceClientParam PROBLEM = new ReferenceClientParam("problem");
    public static final Include INCLUDE_PROBLEM = new Include("ClinicalImpression:problem").toLocked();
    @SearchParamDefinition(name="patient", path="ClinicalImpression.subject.where(resolve() is Patient)", description="Patient or group assessed", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ClinicalImpression:patient").toLocked();
    @SearchParamDefinition(name="supporting-info", path="ClinicalImpression.supportingInfo", description="Information supporting the clinical impression", type="reference")
    public static final String SP_SUPPORTING_INFO = "supporting-info";
    public static final ReferenceClientParam SUPPORTING_INFO = new ReferenceClientParam("supporting-info");
    public static final Include INCLUDE_SUPPORTING_INFO = new Include("ClinicalImpression:supporting-info").toLocked();
    @SearchParamDefinition(name="investigation", path="ClinicalImpression.investigation.item", description="Record of a specific investigation", type="reference", target={DiagnosticReport.class, FamilyMemberHistory.class, ImagingStudy.class, Media.class, Observation.class, QuestionnaireResponse.class, RiskAssessment.class})
    public static final String SP_INVESTIGATION = "investigation";
    public static final ReferenceClientParam INVESTIGATION = new ReferenceClientParam("investigation");
    public static final Include INCLUDE_INVESTIGATION = new Include("ClinicalImpression:investigation").toLocked();
    @SearchParamDefinition(name="status", path="ClinicalImpression.status", description="in-progress | completed | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public ClinicalImpression() {
    }

    public ClinicalImpression(Enumeration<ClinicalImpressionStatus> status, Reference subject) {
        this.status = status;
        this.subject = subject;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ClinicalImpression setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ClinicalImpression addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<ClinicalImpressionStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ClinicalImpressionStatus>(new ClinicalImpressionStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ClinicalImpression setStatusElement(Enumeration<ClinicalImpressionStatus> value) {
        this.status = value;
        return this;
    }

    public ClinicalImpressionStatus getStatus() {
        return this.status == null ? null : (ClinicalImpressionStatus)((Object)this.status.getValue());
    }

    public ClinicalImpression setStatus(ClinicalImpressionStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ClinicalImpressionStatus>(new ClinicalImpressionStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getStatusReason() {
        if (this.statusReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.statusReason");
            }
            if (Configuration.doAutoCreate()) {
                this.statusReason = new CodeableConcept();
            }
        }
        return this.statusReason;
    }

    public boolean hasStatusReason() {
        return this.statusReason != null && !this.statusReason.isEmpty();
    }

    public ClinicalImpression setStatusReason(CodeableConcept value) {
        this.statusReason = value;
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public ClinicalImpression setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ClinicalImpression setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ClinicalImpression setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public ClinicalImpression setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public ClinicalImpression setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public ClinicalImpression setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public ClinicalImpression setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public Type getEffective() {
        return this.effective;
    }

    public DateTimeType getEffectiveDateTimeType() throws FHIRException {
        if (this.effective == null) {
            this.effective = new DateTimeType();
        }
        if (!(this.effective instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.effective;
    }

    public boolean hasEffectiveDateTimeType() {
        return this != null && this.effective instanceof DateTimeType;
    }

    public Period getEffectivePeriod() throws FHIRException {
        if (this.effective == null) {
            this.effective = new Period();
        }
        if (!(this.effective instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (Period)this.effective;
    }

    public boolean hasEffectivePeriod() {
        return this != null && this.effective instanceof Period;
    }

    public boolean hasEffective() {
        return this.effective != null && !this.effective.isEmpty();
    }

    public ClinicalImpression setEffective(Type value) {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
            throw new Error("Not the right type for ClinicalImpression.effective[x]: " + value.fhirType());
        }
        this.effective = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public ClinicalImpression setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public ClinicalImpression setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public Reference getAssessor() {
        if (this.assessor == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.assessor");
            }
            if (Configuration.doAutoCreate()) {
                this.assessor = new Reference();
            }
        }
        return this.assessor;
    }

    public boolean hasAssessor() {
        return this.assessor != null && !this.assessor.isEmpty();
    }

    public ClinicalImpression setAssessor(Reference value) {
        this.assessor = value;
        return this;
    }

    public Resource getAssessorTarget() {
        return this.assessorTarget;
    }

    public ClinicalImpression setAssessorTarget(Resource value) {
        this.assessorTarget = value;
        return this;
    }

    public Reference getPrevious() {
        if (this.previous == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.previous");
            }
            if (Configuration.doAutoCreate()) {
                this.previous = new Reference();
            }
        }
        return this.previous;
    }

    public boolean hasPrevious() {
        return this.previous != null && !this.previous.isEmpty();
    }

    public ClinicalImpression setPrevious(Reference value) {
        this.previous = value;
        return this;
    }

    public ClinicalImpression getPreviousTarget() {
        if (this.previousTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.previous");
            }
            if (Configuration.doAutoCreate()) {
                this.previousTarget = new ClinicalImpression();
            }
        }
        return this.previousTarget;
    }

    public ClinicalImpression setPreviousTarget(ClinicalImpression value) {
        this.previousTarget = value;
        return this;
    }

    public List<Reference> getProblem() {
        if (this.problem == null) {
            this.problem = new ArrayList<Reference>();
        }
        return this.problem;
    }

    public ClinicalImpression setProblem(List<Reference> theProblem) {
        this.problem = theProblem;
        return this;
    }

    public boolean hasProblem() {
        if (this.problem == null) {
            return false;
        }
        for (Reference item : this.problem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addProblem() {
        Reference t = new Reference();
        if (this.problem == null) {
            this.problem = new ArrayList<Reference>();
        }
        this.problem.add(t);
        return t;
    }

    public ClinicalImpression addProblem(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.problem == null) {
            this.problem = new ArrayList<Reference>();
        }
        this.problem.add(t);
        return this;
    }

    public Reference getProblemFirstRep() {
        if (this.getProblem().isEmpty()) {
            this.addProblem();
        }
        return this.getProblem().get(0);
    }

    @Deprecated
    public List<Resource> getProblemTarget() {
        if (this.problemTarget == null) {
            this.problemTarget = new ArrayList<Resource>();
        }
        return this.problemTarget;
    }

    public List<ClinicalImpressionInvestigationComponent> getInvestigation() {
        if (this.investigation == null) {
            this.investigation = new ArrayList<ClinicalImpressionInvestigationComponent>();
        }
        return this.investigation;
    }

    public ClinicalImpression setInvestigation(List<ClinicalImpressionInvestigationComponent> theInvestigation) {
        this.investigation = theInvestigation;
        return this;
    }

    public boolean hasInvestigation() {
        if (this.investigation == null) {
            return false;
        }
        for (ClinicalImpressionInvestigationComponent item : this.investigation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ClinicalImpressionInvestigationComponent addInvestigation() {
        ClinicalImpressionInvestigationComponent t = new ClinicalImpressionInvestigationComponent();
        if (this.investigation == null) {
            this.investigation = new ArrayList<ClinicalImpressionInvestigationComponent>();
        }
        this.investigation.add(t);
        return t;
    }

    public ClinicalImpression addInvestigation(ClinicalImpressionInvestigationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.investigation == null) {
            this.investigation = new ArrayList<ClinicalImpressionInvestigationComponent>();
        }
        this.investigation.add(t);
        return this;
    }

    public ClinicalImpressionInvestigationComponent getInvestigationFirstRep() {
        if (this.getInvestigation().isEmpty()) {
            this.addInvestigation();
        }
        return this.getInvestigation().get(0);
    }

    public List<UriType> getProtocol() {
        if (this.protocol == null) {
            this.protocol = new ArrayList<UriType>();
        }
        return this.protocol;
    }

    public ClinicalImpression setProtocol(List<UriType> theProtocol) {
        this.protocol = theProtocol;
        return this;
    }

    public boolean hasProtocol() {
        if (this.protocol == null) {
            return false;
        }
        for (UriType item : this.protocol) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addProtocolElement() {
        UriType t = new UriType();
        if (this.protocol == null) {
            this.protocol = new ArrayList<UriType>();
        }
        this.protocol.add(t);
        return t;
    }

    public ClinicalImpression addProtocol(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.protocol == null) {
            this.protocol = new ArrayList<UriType>();
        }
        this.protocol.add(t);
        return this;
    }

    public boolean hasProtocol(String value) {
        if (this.protocol == null) {
            return false;
        }
        for (UriType v : this.protocol) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public StringType getSummaryElement() {
        if (this.summary == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClinicalImpression.summary");
            }
            if (Configuration.doAutoCreate()) {
                this.summary = new StringType();
            }
        }
        return this.summary;
    }

    public boolean hasSummaryElement() {
        return this.summary != null && !this.summary.isEmpty();
    }

    public boolean hasSummary() {
        return this.summary != null && !this.summary.isEmpty();
    }

    public ClinicalImpression setSummaryElement(StringType value) {
        this.summary = value;
        return this;
    }

    public String getSummary() {
        return this.summary == null ? null : (String)this.summary.getValue();
    }

    public ClinicalImpression setSummary(String value) {
        if (Utilities.noString((String)value)) {
            this.summary = null;
        } else {
            if (this.summary == null) {
                this.summary = new StringType();
            }
            this.summary.setValue(value);
        }
        return this;
    }

    public List<ClinicalImpressionFindingComponent> getFinding() {
        if (this.finding == null) {
            this.finding = new ArrayList<ClinicalImpressionFindingComponent>();
        }
        return this.finding;
    }

    public ClinicalImpression setFinding(List<ClinicalImpressionFindingComponent> theFinding) {
        this.finding = theFinding;
        return this;
    }

    public boolean hasFinding() {
        if (this.finding == null) {
            return false;
        }
        for (ClinicalImpressionFindingComponent item : this.finding) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ClinicalImpressionFindingComponent addFinding() {
        ClinicalImpressionFindingComponent t = new ClinicalImpressionFindingComponent();
        if (this.finding == null) {
            this.finding = new ArrayList<ClinicalImpressionFindingComponent>();
        }
        this.finding.add(t);
        return t;
    }

    public ClinicalImpression addFinding(ClinicalImpressionFindingComponent t) {
        if (t == null) {
            return this;
        }
        if (this.finding == null) {
            this.finding = new ArrayList<ClinicalImpressionFindingComponent>();
        }
        this.finding.add(t);
        return this;
    }

    public ClinicalImpressionFindingComponent getFindingFirstRep() {
        if (this.getFinding().isEmpty()) {
            this.addFinding();
        }
        return this.getFinding().get(0);
    }

    public List<CodeableConcept> getPrognosisCodeableConcept() {
        if (this.prognosisCodeableConcept == null) {
            this.prognosisCodeableConcept = new ArrayList<CodeableConcept>();
        }
        return this.prognosisCodeableConcept;
    }

    public ClinicalImpression setPrognosisCodeableConcept(List<CodeableConcept> thePrognosisCodeableConcept) {
        this.prognosisCodeableConcept = thePrognosisCodeableConcept;
        return this;
    }

    public boolean hasPrognosisCodeableConcept() {
        if (this.prognosisCodeableConcept == null) {
            return false;
        }
        for (CodeableConcept item : this.prognosisCodeableConcept) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addPrognosisCodeableConcept() {
        CodeableConcept t = new CodeableConcept();
        if (this.prognosisCodeableConcept == null) {
            this.prognosisCodeableConcept = new ArrayList<CodeableConcept>();
        }
        this.prognosisCodeableConcept.add(t);
        return t;
    }

    public ClinicalImpression addPrognosisCodeableConcept(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.prognosisCodeableConcept == null) {
            this.prognosisCodeableConcept = new ArrayList<CodeableConcept>();
        }
        this.prognosisCodeableConcept.add(t);
        return this;
    }

    public CodeableConcept getPrognosisCodeableConceptFirstRep() {
        if (this.getPrognosisCodeableConcept().isEmpty()) {
            this.addPrognosisCodeableConcept();
        }
        return this.getPrognosisCodeableConcept().get(0);
    }

    public List<Reference> getPrognosisReference() {
        if (this.prognosisReference == null) {
            this.prognosisReference = new ArrayList<Reference>();
        }
        return this.prognosisReference;
    }

    public ClinicalImpression setPrognosisReference(List<Reference> thePrognosisReference) {
        this.prognosisReference = thePrognosisReference;
        return this;
    }

    public boolean hasPrognosisReference() {
        if (this.prognosisReference == null) {
            return false;
        }
        for (Reference item : this.prognosisReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPrognosisReference() {
        Reference t = new Reference();
        if (this.prognosisReference == null) {
            this.prognosisReference = new ArrayList<Reference>();
        }
        this.prognosisReference.add(t);
        return t;
    }

    public ClinicalImpression addPrognosisReference(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.prognosisReference == null) {
            this.prognosisReference = new ArrayList<Reference>();
        }
        this.prognosisReference.add(t);
        return this;
    }

    public Reference getPrognosisReferenceFirstRep() {
        if (this.getPrognosisReference().isEmpty()) {
            this.addPrognosisReference();
        }
        return this.getPrognosisReference().get(0);
    }

    @Deprecated
    public List<RiskAssessment> getPrognosisReferenceTarget() {
        if (this.prognosisReferenceTarget == null) {
            this.prognosisReferenceTarget = new ArrayList<RiskAssessment>();
        }
        return this.prognosisReferenceTarget;
    }

    @Deprecated
    public RiskAssessment addPrognosisReferenceTarget() {
        RiskAssessment r = new RiskAssessment();
        if (this.prognosisReferenceTarget == null) {
            this.prognosisReferenceTarget = new ArrayList<RiskAssessment>();
        }
        this.prognosisReferenceTarget.add(r);
        return r;
    }

    public List<Reference> getSupportingInfo() {
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        return this.supportingInfo;
    }

    public ClinicalImpression setSupportingInfo(List<Reference> theSupportingInfo) {
        this.supportingInfo = theSupportingInfo;
        return this;
    }

    public boolean hasSupportingInfo() {
        if (this.supportingInfo == null) {
            return false;
        }
        for (Reference item : this.supportingInfo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInfo() {
        Reference t = new Reference();
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        this.supportingInfo.add(t);
        return t;
    }

    public ClinicalImpression addSupportingInfo(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        this.supportingInfo.add(t);
        return this;
    }

    public Reference getSupportingInfoFirstRep() {
        if (this.getSupportingInfo().isEmpty()) {
            this.addSupportingInfo();
        }
        return this.getSupportingInfo().get(0);
    }

    @Deprecated
    public List<Resource> getSupportingInfoTarget() {
        if (this.supportingInfoTarget == null) {
            this.supportingInfoTarget = new ArrayList<Resource>();
        }
        return this.supportingInfoTarget;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public ClinicalImpression setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public ClinicalImpression addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this clinical impression by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "Identifies the workflow status of the assessment.", 0, 1, this.status));
        children.add(new Property("statusReason", "CodeableConcept", "Captures the reason for the current state of the ClinicalImpression.", 0, 1, this.statusReason));
        children.add(new Property("code", "CodeableConcept", "Categorizes the type of clinical assessment performed.", 0, 1, this.code));
        children.add(new Property("description", "string", "A summary of the context and/or cause of the assessment - why / where it was performed, and what patient events/status prompted it.", 0, 1, this.description));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group of individuals assessed as part of this record.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The Encounter during which this ClinicalImpression was created or to which the creation of this record is tightly associated.", 0, 1, this.encounter));
        children.add(new Property("effective[x]", "dateTime|Period", "The point in time or period over which the subject was assessed.", 0, 1, this.effective));
        children.add(new Property(SP_DATE, "dateTime", "Indicates when the documentation of the assessment was complete.", 0, 1, this.date));
        children.add(new Property(SP_ASSESSOR, "Reference(Practitioner|PractitionerRole)", "The clinician performing the assessment.", 0, 1, this.assessor));
        children.add(new Property(SP_PREVIOUS, "Reference(ClinicalImpression)", "A reference to the last assessment that was conducted on this patient. Assessments are often/usually ongoing in nature; a care provider (practitioner or team) will make new assessments on an ongoing basis as new data arises or the patient's conditions changes.", 0, 1, this.previous));
        children.add(new Property(SP_PROBLEM, "Reference(Condition|AllergyIntolerance)", "A list of the relevant problems/conditions for a patient.", 0, Integer.MAX_VALUE, this.problem));
        children.add(new Property(SP_INVESTIGATION, "", "One or more sets of investigations (signs, symptoms, etc.). The actual grouping of investigations varies greatly depending on the type and context of the assessment. These investigations may include data generated during the assessment process, or data previously generated and recorded that is pertinent to the outcomes.", 0, Integer.MAX_VALUE, this.investigation));
        children.add(new Property("protocol", "uri", "Reference to a specific published clinical protocol that was followed during this assessment, and/or that provides evidence in support of the diagnosis.", 0, Integer.MAX_VALUE, this.protocol));
        children.add(new Property("summary", "string", "A text summary of the investigations and the diagnosis.", 0, 1, this.summary));
        children.add(new Property("finding", "", "Specific findings or diagnoses that were considered likely or relevant to ongoing treatment.", 0, Integer.MAX_VALUE, this.finding));
        children.add(new Property("prognosisCodeableConcept", "CodeableConcept", "Estimate of likely outcome.", 0, Integer.MAX_VALUE, this.prognosisCodeableConcept));
        children.add(new Property("prognosisReference", "Reference(RiskAssessment)", "RiskAssessment expressing likely outcome.", 0, Integer.MAX_VALUE, this.prognosisReference));
        children.add(new Property("supportingInfo", "Reference(Any)", "Information supporting the clinical impression.", 0, Integer.MAX_VALUE, this.supportingInfo));
        children.add(new Property("note", "Annotation", "Commentary about the impression, typically recorded after the impression itself was made, though supplemental notes by the original author could also appear.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this clinical impression by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Identifies the workflow status of the assessment.", 0, 1, this.status);
            }
            case 2051346646: {
                return new Property("statusReason", "CodeableConcept", "Captures the reason for the current state of the ClinicalImpression.", 0, 1, this.statusReason);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "Categorizes the type of clinical assessment performed.", 0, 1, this.code);
            }
            case -1724546052: {
                return new Property("description", "string", "A summary of the context and/or cause of the assessment - why / where it was performed, and what patient events/status prompted it.", 0, 1, this.description);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group of individuals assessed as part of this record.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The Encounter during which this ClinicalImpression was created or to which the creation of this record is tightly associated.", 0, 1, this.encounter);
            }
            case 247104889: {
                return new Property("effective[x]", "dateTime|Period", "The point in time or period over which the subject was assessed.", 0, 1, this.effective);
            }
            case -1468651097: {
                return new Property("effective[x]", "dateTime|Period", "The point in time or period over which the subject was assessed.", 0, 1, this.effective);
            }
            case -275306910: {
                return new Property("effective[x]", "dateTime|Period", "The point in time or period over which the subject was assessed.", 0, 1, this.effective);
            }
            case -403934648: {
                return new Property("effective[x]", "dateTime|Period", "The point in time or period over which the subject was assessed.", 0, 1, this.effective);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "Indicates when the documentation of the assessment was complete.", 0, 1, this.date);
            }
            case -373213113: {
                return new Property(SP_ASSESSOR, "Reference(Practitioner|PractitionerRole)", "The clinician performing the assessment.", 0, 1, this.assessor);
            }
            case -1273775369: {
                return new Property(SP_PREVIOUS, "Reference(ClinicalImpression)", "A reference to the last assessment that was conducted on this patient. Assessments are often/usually ongoing in nature; a care provider (practitioner or team) will make new assessments on an ongoing basis as new data arises or the patient's conditions changes.", 0, 1, this.previous);
            }
            case -309542241: {
                return new Property(SP_PROBLEM, "Reference(Condition|AllergyIntolerance)", "A list of the relevant problems/conditions for a patient.", 0, Integer.MAX_VALUE, this.problem);
            }
            case 956015362: {
                return new Property(SP_INVESTIGATION, "", "One or more sets of investigations (signs, symptoms, etc.). The actual grouping of investigations varies greatly depending on the type and context of the assessment. These investigations may include data generated during the assessment process, or data previously generated and recorded that is pertinent to the outcomes.", 0, Integer.MAX_VALUE, this.investigation);
            }
            case -989163880: {
                return new Property("protocol", "uri", "Reference to a specific published clinical protocol that was followed during this assessment, and/or that provides evidence in support of the diagnosis.", 0, Integer.MAX_VALUE, this.protocol);
            }
            case -1857640538: {
                return new Property("summary", "string", "A text summary of the investigations and the diagnosis.", 0, 1, this.summary);
            }
            case -853173367: {
                return new Property("finding", "", "Specific findings or diagnoses that were considered likely or relevant to ongoing treatment.", 0, Integer.MAX_VALUE, this.finding);
            }
            case -676337953: {
                return new Property("prognosisCodeableConcept", "CodeableConcept", "Estimate of likely outcome.", 0, Integer.MAX_VALUE, this.prognosisCodeableConcept);
            }
            case -587137783: {
                return new Property("prognosisReference", "Reference(RiskAssessment)", "RiskAssessment expressing likely outcome.", 0, Integer.MAX_VALUE, this.prognosisReference);
            }
            case 1922406657: {
                return new Property("supportingInfo", "Reference(Any)", "Information supporting the clinical impression.", 0, Integer.MAX_VALUE, this.supportingInfo);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Commentary about the impression, typically recorded after the impression itself was made, though supplemental notes by the original author could also appear.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 2051346646: {
                Base[] baseArray;
                if (this.statusReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.statusReason;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.code;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.description;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.encounter;
                }
                return baseArray;
            }
            case -1468651097: {
                Base[] baseArray;
                if (this.effective == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.effective;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case -373213113: {
                Base[] baseArray;
                if (this.assessor == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.assessor;
                }
                return baseArray;
            }
            case -1273775369: {
                Base[] baseArray;
                if (this.previous == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.previous;
                }
                return baseArray;
            }
            case -309542241: {
                return this.problem == null ? new Base[]{} : this.problem.toArray(new Base[this.problem.size()]);
            }
            case 956015362: {
                return this.investigation == null ? new Base[]{} : this.investigation.toArray(new Base[this.investigation.size()]);
            }
            case -989163880: {
                return this.protocol == null ? new Base[]{} : this.protocol.toArray(new Base[this.protocol.size()]);
            }
            case -1857640538: {
                Base[] baseArray;
                if (this.summary == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.summary;
                }
                return baseArray;
            }
            case -853173367: {
                return this.finding == null ? new Base[]{} : this.finding.toArray(new Base[this.finding.size()]);
            }
            case -676337953: {
                return this.prognosisCodeableConcept == null ? new Base[]{} : this.prognosisCodeableConcept.toArray(new Base[this.prognosisCodeableConcept.size()]);
            }
            case -587137783: {
                return this.prognosisReference == null ? new Base[]{} : this.prognosisReference.toArray(new Base[this.prognosisReference.size()]);
            }
            case 1922406657: {
                return this.supportingInfo == null ? new Base[]{} : this.supportingInfo.toArray(new Base[this.supportingInfo.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new ClinicalImpressionStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 2051346646: {
                this.statusReason = this.castToCodeableConcept(value);
                return value;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = this.castToReference(value);
                return value;
            }
            case -1468651097: {
                this.effective = this.castToType(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case -373213113: {
                this.assessor = this.castToReference(value);
                return value;
            }
            case -1273775369: {
                this.previous = this.castToReference(value);
                return value;
            }
            case -309542241: {
                this.getProblem().add(this.castToReference(value));
                return value;
            }
            case 956015362: {
                this.getInvestigation().add((ClinicalImpressionInvestigationComponent)((Object)value));
                return value;
            }
            case -989163880: {
                this.getProtocol().add(this.castToUri(value));
                return value;
            }
            case -1857640538: {
                this.summary = this.castToString(value);
                return value;
            }
            case -853173367: {
                this.getFinding().add((ClinicalImpressionFindingComponent)((Object)value));
                return value;
            }
            case -676337953: {
                this.getPrognosisCodeableConcept().add(this.castToCodeableConcept(value));
                return value;
            }
            case -587137783: {
                this.getPrognosisReference().add(this.castToReference(value));
                return value;
            }
            case 1922406657: {
                this.getSupportingInfo().add(this.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ClinicalImpressionStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("statusReason")) {
            this.statusReason = this.castToCodeableConcept(value);
        } else if (name.equals("code")) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals("effective[x]")) {
            this.effective = this.castToType(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_ASSESSOR)) {
            this.assessor = this.castToReference(value);
        } else if (name.equals(SP_PREVIOUS)) {
            this.previous = this.castToReference(value);
        } else if (name.equals(SP_PROBLEM)) {
            this.getProblem().add(this.castToReference(value));
        } else if (name.equals(SP_INVESTIGATION)) {
            this.getInvestigation().add((ClinicalImpressionInvestigationComponent)((Object)value));
        } else if (name.equals("protocol")) {
            this.getProtocol().add(this.castToUri(value));
        } else if (name.equals("summary")) {
            this.summary = this.castToString(value);
        } else if (name.equals("finding")) {
            this.getFinding().add((ClinicalImpressionFindingComponent)((Object)value));
        } else if (name.equals("prognosisCodeableConcept")) {
            this.getPrognosisCodeableConcept().add(this.castToCodeableConcept(value));
        } else if (name.equals("prognosisReference")) {
            this.getPrognosisReference().add(this.castToReference(value));
        } else if (name.equals("supportingInfo")) {
            this.getSupportingInfo().add(this.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2051346646: {
                return this.getStatusReason();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 247104889: {
                return this.getEffective();
            }
            case -1468651097: {
                return this.getEffective();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case -373213113: {
                return this.getAssessor();
            }
            case -1273775369: {
                return this.getPrevious();
            }
            case -309542241: {
                return this.addProblem();
            }
            case 956015362: {
                return this.addInvestigation();
            }
            case -989163880: {
                return this.addProtocolElement();
            }
            case -1857640538: {
                return this.getSummaryElement();
            }
            case -853173367: {
                return this.addFinding();
            }
            case -676337953: {
                return this.addPrognosisCodeableConcept();
            }
            case -587137783: {
                return this.addPrognosisReference();
            }
            case 1922406657: {
                return this.addSupportingInfo();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 2051346646: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -1468651097: {
                return new String[]{"dateTime", "Period"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case -373213113: {
                return new String[]{"Reference"};
            }
            case -1273775369: {
                return new String[]{"Reference"};
            }
            case -309542241: {
                return new String[]{"Reference"};
            }
            case 956015362: {
                return new String[0];
            }
            case -989163880: {
                return new String[]{"uri"};
            }
            case -1857640538: {
                return new String[]{"string"};
            }
            case -853173367: {
                return new String[0];
            }
            case -676337953: {
                return new String[]{"CodeableConcept"};
            }
            case -587137783: {
                return new String[]{"Reference"};
            }
            case 1922406657: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ClinicalImpression.status");
        }
        if (name.equals("statusReason")) {
            this.statusReason = new CodeableConcept();
            return this.statusReason;
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type ClinicalImpression.description");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("effectiveDateTime")) {
            this.effective = new DateTimeType();
            return this.effective;
        }
        if (name.equals("effectivePeriod")) {
            this.effective = new Period();
            return this.effective;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ClinicalImpression.date");
        }
        if (name.equals(SP_ASSESSOR)) {
            this.assessor = new Reference();
            return this.assessor;
        }
        if (name.equals(SP_PREVIOUS)) {
            this.previous = new Reference();
            return this.previous;
        }
        if (name.equals(SP_PROBLEM)) {
            return this.addProblem();
        }
        if (name.equals(SP_INVESTIGATION)) {
            return this.addInvestigation();
        }
        if (name.equals("protocol")) {
            throw new FHIRException("Cannot call addChild on a primitive type ClinicalImpression.protocol");
        }
        if (name.equals("summary")) {
            throw new FHIRException("Cannot call addChild on a primitive type ClinicalImpression.summary");
        }
        if (name.equals("finding")) {
            return this.addFinding();
        }
        if (name.equals("prognosisCodeableConcept")) {
            return this.addPrognosisCodeableConcept();
        }
        if (name.equals("prognosisReference")) {
            return this.addPrognosisReference();
        }
        if (name.equals("supportingInfo")) {
            return this.addSupportingInfo();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ClinicalImpression";
    }

    @Override
    public ClinicalImpression copy() {
        ClinicalImpression dst = new ClinicalImpression();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ClinicalImpression dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.statusReason = this.statusReason == null ? null : this.statusReason.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.effective = this.effective == null ? null : this.effective.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.assessor = this.assessor == null ? null : this.assessor.copy();
        Reference reference = dst.previous = this.previous == null ? null : this.previous.copy();
        if (this.problem != null) {
            dst.problem = new ArrayList<Reference>();
            for (Reference reference2 : this.problem) {
                dst.problem.add(reference2.copy());
            }
        }
        if (this.investigation != null) {
            dst.investigation = new ArrayList<ClinicalImpressionInvestigationComponent>();
            for (ClinicalImpressionInvestigationComponent clinicalImpressionInvestigationComponent : this.investigation) {
                dst.investigation.add(clinicalImpressionInvestigationComponent.copy());
            }
        }
        if (this.protocol != null) {
            dst.protocol = new ArrayList<UriType>();
            for (UriType uriType : this.protocol) {
                dst.protocol.add(uriType.copy());
            }
        }
        StringType stringType = dst.summary = this.summary == null ? null : this.summary.copy();
        if (this.finding != null) {
            dst.finding = new ArrayList<ClinicalImpressionFindingComponent>();
            for (ClinicalImpressionFindingComponent clinicalImpressionFindingComponent : this.finding) {
                dst.finding.add(clinicalImpressionFindingComponent.copy());
            }
        }
        if (this.prognosisCodeableConcept != null) {
            dst.prognosisCodeableConcept = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.prognosisCodeableConcept) {
                dst.prognosisCodeableConcept.add(codeableConcept.copy());
            }
        }
        if (this.prognosisReference != null) {
            dst.prognosisReference = new ArrayList<Reference>();
            for (Reference reference3 : this.prognosisReference) {
                dst.prognosisReference.add(reference3.copy());
            }
        }
        if (this.supportingInfo != null) {
            dst.supportingInfo = new ArrayList<Reference>();
            for (Reference reference4 : this.supportingInfo) {
                dst.supportingInfo.add(reference4.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected ClinicalImpression typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ClinicalImpression)) {
            return false;
        }
        ClinicalImpression o = (ClinicalImpression)other_;
        return ClinicalImpression.compareDeep(this.identifier, o.identifier, true) && ClinicalImpression.compareDeep(this.status, o.status, true) && ClinicalImpression.compareDeep(this.statusReason, o.statusReason, true) && ClinicalImpression.compareDeep(this.code, o.code, true) && ClinicalImpression.compareDeep(this.description, o.description, true) && ClinicalImpression.compareDeep(this.subject, o.subject, true) && ClinicalImpression.compareDeep(this.encounter, o.encounter, true) && ClinicalImpression.compareDeep(this.effective, o.effective, true) && ClinicalImpression.compareDeep(this.date, o.date, true) && ClinicalImpression.compareDeep(this.assessor, o.assessor, true) && ClinicalImpression.compareDeep(this.previous, o.previous, true) && ClinicalImpression.compareDeep(this.problem, o.problem, true) && ClinicalImpression.compareDeep(this.investigation, o.investigation, true) && ClinicalImpression.compareDeep(this.protocol, o.protocol, true) && ClinicalImpression.compareDeep(this.summary, o.summary, true) && ClinicalImpression.compareDeep(this.finding, o.finding, true) && ClinicalImpression.compareDeep(this.prognosisCodeableConcept, o.prognosisCodeableConcept, true) && ClinicalImpression.compareDeep(this.prognosisReference, o.prognosisReference, true) && ClinicalImpression.compareDeep(this.supportingInfo, o.supportingInfo, true) && ClinicalImpression.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ClinicalImpression)) {
            return false;
        }
        ClinicalImpression o = (ClinicalImpression)other_;
        return ClinicalImpression.compareValues(this.status, o.status, true) && ClinicalImpression.compareValues(this.description, o.description, true) && ClinicalImpression.compareValues(this.date, o.date, true) && ClinicalImpression.compareValues(this.protocol, o.protocol, true) && ClinicalImpression.compareValues(this.summary, o.summary, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.statusReason, this.code, this.description, this.subject, this.encounter, this.effective, this.date, this.assessor, this.previous, this.problem, this.investigation, this.protocol, this.summary, this.finding, this.prognosisCodeableConcept, this.prognosisReference, this.supportingInfo, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ClinicalImpression;
    }

    @Block
    public static class ClinicalImpressionFindingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="itemCodeableConcept", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What was found", formalDefinition="Specific text or code for finding or diagnosis, which may include ruled-out or resolved conditions.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
        protected CodeableConcept itemCodeableConcept;
        @Child(name="itemReference", type={Condition.class, Observation.class, Media.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What was found", formalDefinition="Specific reference for finding or diagnosis, which may include ruled-out or resolved conditions.")
        protected Reference itemReference;
        protected Resource itemReferenceTarget;
        @Child(name="basis", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Which investigations support finding", formalDefinition="Which investigations support finding or diagnosis.")
        protected StringType basis;
        private static final long serialVersionUID = -1578446448L;

        public CodeableConcept getItemCodeableConcept() {
            if (this.itemCodeableConcept == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalImpressionFindingComponent.itemCodeableConcept");
                }
                if (Configuration.doAutoCreate()) {
                    this.itemCodeableConcept = new CodeableConcept();
                }
            }
            return this.itemCodeableConcept;
        }

        public boolean hasItemCodeableConcept() {
            return this.itemCodeableConcept != null && !this.itemCodeableConcept.isEmpty();
        }

        public ClinicalImpressionFindingComponent setItemCodeableConcept(CodeableConcept value) {
            this.itemCodeableConcept = value;
            return this;
        }

        public Reference getItemReference() {
            if (this.itemReference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalImpressionFindingComponent.itemReference");
                }
                if (Configuration.doAutoCreate()) {
                    this.itemReference = new Reference();
                }
            }
            return this.itemReference;
        }

        public boolean hasItemReference() {
            return this.itemReference != null && !this.itemReference.isEmpty();
        }

        public ClinicalImpressionFindingComponent setItemReference(Reference value) {
            this.itemReference = value;
            return this;
        }

        public Resource getItemReferenceTarget() {
            return this.itemReferenceTarget;
        }

        public ClinicalImpressionFindingComponent setItemReferenceTarget(Resource value) {
            this.itemReferenceTarget = value;
            return this;
        }

        public StringType getBasisElement() {
            if (this.basis == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalImpressionFindingComponent.basis");
                }
                if (Configuration.doAutoCreate()) {
                    this.basis = new StringType();
                }
            }
            return this.basis;
        }

        public boolean hasBasisElement() {
            return this.basis != null && !this.basis.isEmpty();
        }

        public boolean hasBasis() {
            return this.basis != null && !this.basis.isEmpty();
        }

        public ClinicalImpressionFindingComponent setBasisElement(StringType value) {
            this.basis = value;
            return this;
        }

        public String getBasis() {
            return this.basis == null ? null : (String)this.basis.getValue();
        }

        public ClinicalImpressionFindingComponent setBasis(String value) {
            if (Utilities.noString((String)value)) {
                this.basis = null;
            } else {
                if (this.basis == null) {
                    this.basis = new StringType();
                }
                this.basis.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("itemCodeableConcept", "CodeableConcept", "Specific text or code for finding or diagnosis, which may include ruled-out or resolved conditions.", 0, 1, this.itemCodeableConcept));
            children.add(new Property("itemReference", "Reference(Condition|Observation|Media)", "Specific reference for finding or diagnosis, which may include ruled-out or resolved conditions.", 0, 1, this.itemReference));
            children.add(new Property("basis", "string", "Which investigations support finding or diagnosis.", 0, 1, this.basis));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 106644494: {
                    return new Property("itemCodeableConcept", "CodeableConcept", "Specific text or code for finding or diagnosis, which may include ruled-out or resolved conditions.", 0, 1, this.itemCodeableConcept);
                }
                case 1376364920: {
                    return new Property("itemReference", "Reference(Condition|Observation|Media)", "Specific reference for finding or diagnosis, which may include ruled-out or resolved conditions.", 0, 1, this.itemReference);
                }
                case 93508670: {
                    return new Property("basis", "string", "Which investigations support finding or diagnosis.", 0, 1, this.basis);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 106644494: {
                    Base[] baseArray;
                    if (this.itemCodeableConcept == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.itemCodeableConcept;
                    }
                    return baseArray;
                }
                case 1376364920: {
                    Base[] baseArray;
                    if (this.itemReference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.itemReference;
                    }
                    return baseArray;
                }
                case 93508670: {
                    Base[] baseArray;
                    if (this.basis == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.basis;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 106644494: {
                    this.itemCodeableConcept = this.castToCodeableConcept(value);
                    return value;
                }
                case 1376364920: {
                    this.itemReference = this.castToReference(value);
                    return value;
                }
                case 93508670: {
                    this.basis = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("itemCodeableConcept")) {
                this.itemCodeableConcept = this.castToCodeableConcept(value);
            } else if (name.equals("itemReference")) {
                this.itemReference = this.castToReference(value);
            } else if (name.equals("basis")) {
                this.basis = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106644494: {
                    return this.getItemCodeableConcept();
                }
                case 1376364920: {
                    return this.getItemReference();
                }
                case 93508670: {
                    return this.getBasisElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106644494: {
                    return new String[]{"CodeableConcept"};
                }
                case 1376364920: {
                    return new String[]{"Reference"};
                }
                case 93508670: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemCodeableConcept")) {
                this.itemCodeableConcept = new CodeableConcept();
                return this.itemCodeableConcept;
            }
            if (name.equals("itemReference")) {
                this.itemReference = new Reference();
                return this.itemReference;
            }
            if (name.equals("basis")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClinicalImpression.basis");
            }
            return super.addChild(name);
        }

        @Override
        public ClinicalImpressionFindingComponent copy() {
            ClinicalImpressionFindingComponent dst = new ClinicalImpressionFindingComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ClinicalImpressionFindingComponent dst) {
            super.copyValues(dst);
            dst.itemCodeableConcept = this.itemCodeableConcept == null ? null : this.itemCodeableConcept.copy();
            dst.itemReference = this.itemReference == null ? null : this.itemReference.copy();
            dst.basis = this.basis == null ? null : this.basis.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalImpressionFindingComponent)) {
                return false;
            }
            ClinicalImpressionFindingComponent o = (ClinicalImpressionFindingComponent)other_;
            return ClinicalImpressionFindingComponent.compareDeep(this.itemCodeableConcept, o.itemCodeableConcept, true) && ClinicalImpressionFindingComponent.compareDeep(this.itemReference, o.itemReference, true) && ClinicalImpressionFindingComponent.compareDeep(this.basis, o.basis, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalImpressionFindingComponent)) {
                return false;
            }
            ClinicalImpressionFindingComponent o = (ClinicalImpressionFindingComponent)other_;
            return ClinicalImpressionFindingComponent.compareValues(this.basis, o.basis, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.itemCodeableConcept, this.itemReference, this.basis});
        }

        @Override
        public String fhirType() {
            return "ClinicalImpression.finding";
        }
    }

    @Block
    public static class ClinicalImpressionInvestigationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A name/code for the set", formalDefinition="A name/code for the group (\"set\") of investigations. Typically, this will be something like \"signs\", \"symptoms\", \"clinical\", \"diagnostic\", but the list is not constrained, and others such groups such as (exposure|family|travel|nutritional) history may be used.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/investigation-sets")
        protected CodeableConcept code;
        @Child(name="item", type={Observation.class, QuestionnaireResponse.class, FamilyMemberHistory.class, DiagnosticReport.class, RiskAssessment.class, ImagingStudy.class, Media.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Record of a specific investigation", formalDefinition="A record of a specific investigation that was undertaken.")
        protected List<Reference> item;
        protected List<Resource> itemTarget;
        private static final long serialVersionUID = -301363326L;

        public ClinicalImpressionInvestigationComponent() {
        }

        public ClinicalImpressionInvestigationComponent(CodeableConcept code) {
            this.code = code;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClinicalImpressionInvestigationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ClinicalImpressionInvestigationComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public List<Reference> getItem() {
            if (this.item == null) {
                this.item = new ArrayList<Reference>();
            }
            return this.item;
        }

        public ClinicalImpressionInvestigationComponent setItem(List<Reference> theItem) {
            this.item = theItem;
            return this;
        }

        public boolean hasItem() {
            if (this.item == null) {
                return false;
            }
            for (Reference item : this.item) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addItem() {
            Reference t = new Reference();
            if (this.item == null) {
                this.item = new ArrayList<Reference>();
            }
            this.item.add(t);
            return t;
        }

        public ClinicalImpressionInvestigationComponent addItem(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.item == null) {
                this.item = new ArrayList<Reference>();
            }
            this.item.add(t);
            return this;
        }

        public Reference getItemFirstRep() {
            if (this.getItem().isEmpty()) {
                this.addItem();
            }
            return this.getItem().get(0);
        }

        @Deprecated
        public List<Resource> getItemTarget() {
            if (this.itemTarget == null) {
                this.itemTarget = new ArrayList<Resource>();
            }
            return this.itemTarget;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "A name/code for the group (\"set\") of investigations. Typically, this will be something like \"signs\", \"symptoms\", \"clinical\", \"diagnostic\", but the list is not constrained, and others such groups such as (exposure|family|travel|nutritional) history may be used.", 0, 1, this.code));
            children.add(new Property("item", "Reference(Observation|QuestionnaireResponse|FamilyMemberHistory|DiagnosticReport|RiskAssessment|ImagingStudy|Media)", "A record of a specific investigation that was undertaken.", 0, Integer.MAX_VALUE, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "A name/code for the group (\"set\") of investigations. Typically, this will be something like \"signs\", \"symptoms\", \"clinical\", \"diagnostic\", but the list is not constrained, and others such groups such as (exposure|family|travel|nutritional) history may be used.", 0, 1, this.code);
                }
                case 3242771: {
                    return new Property("item", "Reference(Observation|QuestionnaireResponse|FamilyMemberHistory|DiagnosticReport|RiskAssessment|ImagingStudy|Media)", "A record of a specific investigation that was undertaken.", 0, Integer.MAX_VALUE, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 3242771: {
                    return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case 3242771: {
                    this.getItem().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("item")) {
                this.getItem().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 3242771: {
                    return this.addItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 3242771: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("item")) {
                return this.addItem();
            }
            return super.addChild(name);
        }

        @Override
        public ClinicalImpressionInvestigationComponent copy() {
            ClinicalImpressionInvestigationComponent dst = new ClinicalImpressionInvestigationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ClinicalImpressionInvestigationComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
            if (this.item != null) {
                dst.item = new ArrayList<Reference>();
                for (Reference i : this.item) {
                    dst.item.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalImpressionInvestigationComponent)) {
                return false;
            }
            ClinicalImpressionInvestigationComponent o = (ClinicalImpressionInvestigationComponent)other_;
            return ClinicalImpressionInvestigationComponent.compareDeep(this.code, o.code, true) && ClinicalImpressionInvestigationComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ClinicalImpressionInvestigationComponent)) {
                return false;
            }
            ClinicalImpressionInvestigationComponent o = (ClinicalImpressionInvestigationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.item});
        }

        @Override
        public String fhirType() {
            return "ClinicalImpression.investigation";
        }
    }

    public static class ClinicalImpressionStatusEnumFactory
    implements EnumFactory<ClinicalImpressionStatus> {
        @Override
        public ClinicalImpressionStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return ClinicalImpressionStatus.INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return ClinicalImpressionStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ClinicalImpressionStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown ClinicalImpressionStatus code '" + codeString + "'");
        }

        public Enumeration<ClinicalImpressionStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ClinicalImpressionStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<ClinicalImpressionStatus>(this, ClinicalImpressionStatus.INPROGRESS);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<ClinicalImpressionStatus>(this, ClinicalImpressionStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ClinicalImpressionStatus>(this, ClinicalImpressionStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown ClinicalImpressionStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ClinicalImpressionStatus code) {
            if (code == ClinicalImpressionStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == ClinicalImpressionStatus.COMPLETED) {
                return "completed";
            }
            if (code == ClinicalImpressionStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ClinicalImpressionStatus code) {
            return code.getSystem();
        }
    }

    public static enum ClinicalImpressionStatus {
        INPROGRESS,
        COMPLETED,
        ENTEREDINERROR,
        NULL;


        public static ClinicalImpressionStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ClinicalImpressionStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INPROGRESS: {
                    return "in-progress";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INPROGRESS: {
                    return "http://hl7.org/fhir/event-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/event-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/event-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INPROGRESS: {
                    return "";
                }
                case COMPLETED: {
                    return "";
                }
                case ENTEREDINERROR: {
                    return "";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INPROGRESS: {
                    return "in-progress";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

