/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Address")
public class Address
extends Type
implements ICompositeType {
    @Child(name="use", type={CodeType.class}, order=0, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="home | work | temp | old | billing - purpose of this address", formalDefinition="The purpose of this address.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/address-use")
    protected Enumeration<AddressUse> use;
    @Child(name="type", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="postal | physical | both", formalDefinition="Distinguishes between physical addresses (those you can visit) and mailing addresses (e.g. PO Boxes and care-of addresses). Most addresses are both.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/address-type")
    protected Enumeration<AddressType> type;
    @Child(name="text", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Text representation of the address", formalDefinition="Specifies the entire address as it should be displayed e.g. on a postal label. This may be provided instead of or as well as the specific parts.")
    protected StringType text;
    @Child(name="line", type={StringType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Street name, number, direction & P.O. Box etc.", formalDefinition="This component contains the house number, apartment number, street name, street direction,  P.O. Box number, delivery hints, and similar address information.")
    protected List<StringType> line;
    @Child(name="city", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of city, town etc.", formalDefinition="The name of the city, town, suburb, village or other community or delivery center.")
    protected StringType city;
    @Child(name="district", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="District name (aka county)", formalDefinition="The name of the administrative area (county).")
    protected StringType district;
    @Child(name="state", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Sub-unit of country (abbreviations ok)", formalDefinition="Sub-unit of a country with limited sovereignty in a federally organized country. A code may be used if codes are in common use (e.g. US 2 letter state codes).")
    protected StringType state;
    @Child(name="postalCode", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Postal code for area", formalDefinition="A postal code designating a region defined by the postal service.")
    protected StringType postalCode;
    @Child(name="country", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Country (e.g. can be ISO 3166 2 or 3 letter code)", formalDefinition="Country - a nation as commonly understood or generally accepted.")
    protected StringType country;
    @Child(name="period", type={Period.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time period when address was/is in use", formalDefinition="Time period when address was/is in use.")
    protected Period period;
    private static final long serialVersionUID = 561490318L;

    public Enumeration<AddressUse> getUseElement() {
        if (this.use == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Address.use");
            }
            if (Configuration.doAutoCreate()) {
                this.use = new Enumeration<AddressUse>(new AddressUseEnumFactory());
            }
        }
        return this.use;
    }

    public boolean hasUseElement() {
        return this.use != null && !this.use.isEmpty();
    }

    public boolean hasUse() {
        return this.use != null && !this.use.isEmpty();
    }

    public Address setUseElement(Enumeration<AddressUse> value) {
        this.use = value;
        return this;
    }

    public AddressUse getUse() {
        return this.use == null ? null : (AddressUse)((Object)this.use.getValue());
    }

    public Address setUse(AddressUse value) {
        if (value == null) {
            this.use = null;
        } else {
            if (this.use == null) {
                this.use = new Enumeration<AddressUse>(new AddressUseEnumFactory());
            }
            this.use.setValue((Object)value);
        }
        return this;
    }

    public Enumeration<AddressType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Address.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<AddressType>(new AddressTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Address setTypeElement(Enumeration<AddressType> value) {
        this.type = value;
        return this;
    }

    public AddressType getType() {
        return this.type == null ? null : (AddressType)((Object)this.type.getValue());
    }

    public Address setType(AddressType value) {
        if (value == null) {
            this.type = null;
        } else {
            if (this.type == null) {
                this.type = new Enumeration<AddressType>(new AddressTypeEnumFactory());
            }
            this.type.setValue((Object)value);
        }
        return this;
    }

    public StringType getTextElement() {
        if (this.text == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Address.text");
            }
            if (Configuration.doAutoCreate()) {
                this.text = new StringType();
            }
        }
        return this.text;
    }

    public boolean hasTextElement() {
        return this.text != null && !this.text.isEmpty();
    }

    public boolean hasText() {
        return this.text != null && !this.text.isEmpty();
    }

    public Address setTextElement(StringType value) {
        this.text = value;
        return this;
    }

    public String getText() {
        return this.text == null ? null : (String)this.text.getValue();
    }

    public Address setText(String value) {
        if (Utilities.noString((String)value)) {
            this.text = null;
        } else {
            if (this.text == null) {
                this.text = new StringType();
            }
            this.text.setValue(value);
        }
        return this;
    }

    public List<StringType> getLine() {
        if (this.line == null) {
            this.line = new ArrayList<StringType>();
        }
        return this.line;
    }

    public Address setLine(List<StringType> theLine) {
        this.line = theLine;
        return this;
    }

    public boolean hasLine() {
        if (this.line == null) {
            return false;
        }
        for (StringType item : this.line) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addLineElement() {
        StringType t = new StringType();
        if (this.line == null) {
            this.line = new ArrayList<StringType>();
        }
        this.line.add(t);
        return t;
    }

    public Address addLine(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.line == null) {
            this.line = new ArrayList<StringType>();
        }
        this.line.add(t);
        return this;
    }

    public boolean hasLine(String value) {
        if (this.line == null) {
            return false;
        }
        for (StringType v : this.line) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public StringType getCityElement() {
        if (this.city == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Address.city");
            }
            if (Configuration.doAutoCreate()) {
                this.city = new StringType();
            }
        }
        return this.city;
    }

    public boolean hasCityElement() {
        return this.city != null && !this.city.isEmpty();
    }

    public boolean hasCity() {
        return this.city != null && !this.city.isEmpty();
    }

    public Address setCityElement(StringType value) {
        this.city = value;
        return this;
    }

    public String getCity() {
        return this.city == null ? null : (String)this.city.getValue();
    }

    public Address setCity(String value) {
        if (Utilities.noString((String)value)) {
            this.city = null;
        } else {
            if (this.city == null) {
                this.city = new StringType();
            }
            this.city.setValue(value);
        }
        return this;
    }

    public StringType getDistrictElement() {
        if (this.district == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Address.district");
            }
            if (Configuration.doAutoCreate()) {
                this.district = new StringType();
            }
        }
        return this.district;
    }

    public boolean hasDistrictElement() {
        return this.district != null && !this.district.isEmpty();
    }

    public boolean hasDistrict() {
        return this.district != null && !this.district.isEmpty();
    }

    public Address setDistrictElement(StringType value) {
        this.district = value;
        return this;
    }

    public String getDistrict() {
        return this.district == null ? null : (String)this.district.getValue();
    }

    public Address setDistrict(String value) {
        if (Utilities.noString((String)value)) {
            this.district = null;
        } else {
            if (this.district == null) {
                this.district = new StringType();
            }
            this.district.setValue(value);
        }
        return this;
    }

    public StringType getStateElement() {
        if (this.state == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Address.state");
            }
            if (Configuration.doAutoCreate()) {
                this.state = new StringType();
            }
        }
        return this.state;
    }

    public boolean hasStateElement() {
        return this.state != null && !this.state.isEmpty();
    }

    public boolean hasState() {
        return this.state != null && !this.state.isEmpty();
    }

    public Address setStateElement(StringType value) {
        this.state = value;
        return this;
    }

    public String getState() {
        return this.state == null ? null : (String)this.state.getValue();
    }

    public Address setState(String value) {
        if (Utilities.noString((String)value)) {
            this.state = null;
        } else {
            if (this.state == null) {
                this.state = new StringType();
            }
            this.state.setValue(value);
        }
        return this;
    }

    public StringType getPostalCodeElement() {
        if (this.postalCode == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Address.postalCode");
            }
            if (Configuration.doAutoCreate()) {
                this.postalCode = new StringType();
            }
        }
        return this.postalCode;
    }

    public boolean hasPostalCodeElement() {
        return this.postalCode != null && !this.postalCode.isEmpty();
    }

    public boolean hasPostalCode() {
        return this.postalCode != null && !this.postalCode.isEmpty();
    }

    public Address setPostalCodeElement(StringType value) {
        this.postalCode = value;
        return this;
    }

    public String getPostalCode() {
        return this.postalCode == null ? null : (String)this.postalCode.getValue();
    }

    public Address setPostalCode(String value) {
        if (Utilities.noString((String)value)) {
            this.postalCode = null;
        } else {
            if (this.postalCode == null) {
                this.postalCode = new StringType();
            }
            this.postalCode.setValue(value);
        }
        return this;
    }

    public StringType getCountryElement() {
        if (this.country == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Address.country");
            }
            if (Configuration.doAutoCreate()) {
                this.country = new StringType();
            }
        }
        return this.country;
    }

    public boolean hasCountryElement() {
        return this.country != null && !this.country.isEmpty();
    }

    public boolean hasCountry() {
        return this.country != null && !this.country.isEmpty();
    }

    public Address setCountryElement(StringType value) {
        this.country = value;
        return this;
    }

    public String getCountry() {
        return this.country == null ? null : (String)this.country.getValue();
    }

    public Address setCountry(String value) {
        if (Utilities.noString((String)value)) {
            this.country = null;
        } else {
            if (this.country == null) {
                this.country = new StringType();
            }
            this.country.setValue(value);
        }
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Address.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Address setPeriod(Period value) {
        this.period = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("use", "code", "The purpose of this address.", 0, 1, this.use));
        children.add(new Property("type", "code", "Distinguishes between physical addresses (those you can visit) and mailing addresses (e.g. PO Boxes and care-of addresses). Most addresses are both.", 0, 1, this.type));
        children.add(new Property("text", "string", "Specifies the entire address as it should be displayed e.g. on a postal label. This may be provided instead of or as well as the specific parts.", 0, 1, this.text));
        children.add(new Property("line", "string", "This component contains the house number, apartment number, street name, street direction,  P.O. Box number, delivery hints, and similar address information.", 0, Integer.MAX_VALUE, this.line));
        children.add(new Property("city", "string", "The name of the city, town, suburb, village or other community or delivery center.", 0, 1, this.city));
        children.add(new Property("district", "string", "The name of the administrative area (county).", 0, 1, this.district));
        children.add(new Property("state", "string", "Sub-unit of a country with limited sovereignty in a federally organized country. A code may be used if codes are in common use (e.g. US 2 letter state codes).", 0, 1, this.state));
        children.add(new Property("postalCode", "string", "A postal code designating a region defined by the postal service.", 0, 1, this.postalCode));
        children.add(new Property("country", "string", "Country - a nation as commonly understood or generally accepted.", 0, 1, this.country));
        children.add(new Property("period", "Period", "Time period when address was/is in use.", 0, 1, this.period));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116103: {
                return new Property("use", "code", "The purpose of this address.", 0, 1, this.use);
            }
            case 3575610: {
                return new Property("type", "code", "Distinguishes between physical addresses (those you can visit) and mailing addresses (e.g. PO Boxes and care-of addresses). Most addresses are both.", 0, 1, this.type);
            }
            case 3556653: {
                return new Property("text", "string", "Specifies the entire address as it should be displayed e.g. on a postal label. This may be provided instead of or as well as the specific parts.", 0, 1, this.text);
            }
            case 3321844: {
                return new Property("line", "string", "This component contains the house number, apartment number, street name, street direction,  P.O. Box number, delivery hints, and similar address information.", 0, Integer.MAX_VALUE, this.line);
            }
            case 3053931: {
                return new Property("city", "string", "The name of the city, town, suburb, village or other community or delivery center.", 0, 1, this.city);
            }
            case 288961422: {
                return new Property("district", "string", "The name of the administrative area (county).", 0, 1, this.district);
            }
            case 109757585: {
                return new Property("state", "string", "Sub-unit of a country with limited sovereignty in a federally organized country. A code may be used if codes are in common use (e.g. US 2 letter state codes).", 0, 1, this.state);
            }
            case 2011152728: {
                return new Property("postalCode", "string", "A postal code designating a region defined by the postal service.", 0, 1, this.postalCode);
            }
            case 957831062: {
                return new Property("country", "string", "Country - a nation as commonly understood or generally accepted.", 0, 1, this.country);
            }
            case -991726143: {
                return new Property("period", "Period", "Time period when address was/is in use.", 0, 1, this.period);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116103: {
                Base[] baseArray;
                if (this.use == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.use;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case 3556653: {
                Base[] baseArray;
                if (this.text == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.text;
                }
                return baseArray;
            }
            case 3321844: {
                return this.line == null ? new Base[]{} : this.line.toArray(new Base[this.line.size()]);
            }
            case 3053931: {
                Base[] baseArray;
                if (this.city == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.city;
                }
                return baseArray;
            }
            case 288961422: {
                Base[] baseArray;
                if (this.district == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.district;
                }
                return baseArray;
            }
            case 109757585: {
                Base[] baseArray;
                if (this.state == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.state;
                }
                return baseArray;
            }
            case 2011152728: {
                Base[] baseArray;
                if (this.postalCode == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.postalCode;
                }
                return baseArray;
            }
            case 957831062: {
                Base[] baseArray;
                if (this.country == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.country;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.period;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116103: {
                value = new AddressUseEnumFactory().fromType(this.castToCode(value));
                this.use = value;
                return value;
            }
            case 3575610: {
                value = new AddressTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
                return value;
            }
            case 3556653: {
                this.text = this.castToString(value);
                return value;
            }
            case 3321844: {
                this.getLine().add(this.castToString(value));
                return value;
            }
            case 3053931: {
                this.city = this.castToString(value);
                return value;
            }
            case 288961422: {
                this.district = this.castToString(value);
                return value;
            }
            case 109757585: {
                this.state = this.castToString(value);
                return value;
            }
            case 2011152728: {
                this.postalCode = this.castToString(value);
                return value;
            }
            case 957831062: {
                this.country = this.castToString(value);
                return value;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("use")) {
            value = new AddressUseEnumFactory().fromType(this.castToCode(value));
            this.use = value;
        } else if (name.equals("type")) {
            value = new AddressTypeEnumFactory().fromType(this.castToCode(value));
            this.type = value;
        } else if (name.equals("text")) {
            this.text = this.castToString(value);
        } else if (name.equals("line")) {
            this.getLine().add(this.castToString(value));
        } else if (name.equals("city")) {
            this.city = this.castToString(value);
        } else if (name.equals("district")) {
            this.district = this.castToString(value);
        } else if (name.equals("state")) {
            this.state = this.castToString(value);
        } else if (name.equals("postalCode")) {
            this.postalCode = this.castToString(value);
        } else if (name.equals("country")) {
            this.country = this.castToString(value);
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116103: {
                return this.getUseElement();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case 3556653: {
                return this.getTextElement();
            }
            case 3321844: {
                return this.addLineElement();
            }
            case 3053931: {
                return this.getCityElement();
            }
            case 288961422: {
                return this.getDistrictElement();
            }
            case 109757585: {
                return this.getStateElement();
            }
            case 2011152728: {
                return this.getPostalCodeElement();
            }
            case 957831062: {
                return this.getCountryElement();
            }
            case -991726143: {
                return this.getPeriod();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116103: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"code"};
            }
            case 3556653: {
                return new String[]{"string"};
            }
            case 3321844: {
                return new String[]{"string"};
            }
            case 3053931: {
                return new String[]{"string"};
            }
            case 288961422: {
                return new String[]{"string"};
            }
            case 109757585: {
                return new String[]{"string"};
            }
            case 2011152728: {
                return new String[]{"string"};
            }
            case 957831062: {
                return new String[]{"string"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("use")) {
            throw new FHIRException("Cannot call addChild on a primitive type Address.use");
        }
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a primitive type Address.type");
        }
        if (name.equals("text")) {
            throw new FHIRException("Cannot call addChild on a primitive type Address.text");
        }
        if (name.equals("line")) {
            throw new FHIRException("Cannot call addChild on a primitive type Address.line");
        }
        if (name.equals("city")) {
            throw new FHIRException("Cannot call addChild on a primitive type Address.city");
        }
        if (name.equals("district")) {
            throw new FHIRException("Cannot call addChild on a primitive type Address.district");
        }
        if (name.equals("state")) {
            throw new FHIRException("Cannot call addChild on a primitive type Address.state");
        }
        if (name.equals("postalCode")) {
            throw new FHIRException("Cannot call addChild on a primitive type Address.postalCode");
        }
        if (name.equals("country")) {
            throw new FHIRException("Cannot call addChild on a primitive type Address.country");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Address";
    }

    @Override
    public Address copy() {
        Address dst = new Address();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Address dst) {
        super.copyValues(dst);
        dst.use = this.use == null ? null : this.use.copy();
        dst.type = this.type == null ? null : this.type.copy();
        StringType stringType = dst.text = this.text == null ? null : this.text.copy();
        if (this.line != null) {
            dst.line = new ArrayList<StringType>();
            for (StringType i : this.line) {
                dst.line.add(i.copy());
            }
        }
        dst.city = this.city == null ? null : this.city.copy();
        dst.district = this.district == null ? null : this.district.copy();
        dst.state = this.state == null ? null : this.state.copy();
        dst.postalCode = this.postalCode == null ? null : this.postalCode.copy();
        dst.country = this.country == null ? null : this.country.copy();
        dst.period = this.period == null ? null : this.period.copy();
    }

    @Override
    protected Address typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Address)) {
            return false;
        }
        Address o = (Address)other_;
        return Address.compareDeep(this.use, o.use, true) && Address.compareDeep(this.type, o.type, true) && Address.compareDeep(this.text, o.text, true) && Address.compareDeep(this.line, o.line, true) && Address.compareDeep(this.city, o.city, true) && Address.compareDeep(this.district, o.district, true) && Address.compareDeep(this.state, o.state, true) && Address.compareDeep(this.postalCode, o.postalCode, true) && Address.compareDeep(this.country, o.country, true) && Address.compareDeep(this.period, o.period, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Address)) {
            return false;
        }
        Address o = (Address)other_;
        return Address.compareValues(this.use, o.use, true) && Address.compareValues(this.type, o.type, true) && Address.compareValues(this.text, o.text, true) && Address.compareValues(this.line, o.line, true) && Address.compareValues(this.city, o.city, true) && Address.compareValues(this.district, o.district, true) && Address.compareValues(this.state, o.state, true) && Address.compareValues(this.postalCode, o.postalCode, true) && Address.compareValues(this.country, o.country, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.use, this.type, this.text, this.line, this.city, this.district, this.state, this.postalCode, this.country, this.period});
    }

    public static class AddressTypeEnumFactory
    implements EnumFactory<AddressType> {
        @Override
        public AddressType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("postal".equals(codeString)) {
                return AddressType.POSTAL;
            }
            if ("physical".equals(codeString)) {
                return AddressType.PHYSICAL;
            }
            if ("both".equals(codeString)) {
                return AddressType.BOTH;
            }
            throw new IllegalArgumentException("Unknown AddressType code '" + codeString + "'");
        }

        public Enumeration<AddressType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AddressType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("postal".equals(codeString)) {
                return new Enumeration<AddressType>(this, AddressType.POSTAL);
            }
            if ("physical".equals(codeString)) {
                return new Enumeration<AddressType>(this, AddressType.PHYSICAL);
            }
            if ("both".equals(codeString)) {
                return new Enumeration<AddressType>(this, AddressType.BOTH);
            }
            throw new FHIRException("Unknown AddressType code '" + codeString + "'");
        }

        @Override
        public String toCode(AddressType code) {
            if (code == AddressType.POSTAL) {
                return "postal";
            }
            if (code == AddressType.PHYSICAL) {
                return "physical";
            }
            if (code == AddressType.BOTH) {
                return "both";
            }
            return "?";
        }

        @Override
        public String toSystem(AddressType code) {
            return code.getSystem();
        }
    }

    public static enum AddressType {
        POSTAL,
        PHYSICAL,
        BOTH,
        NULL;


        public static AddressType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("postal".equals(codeString)) {
                return POSTAL;
            }
            if ("physical".equals(codeString)) {
                return PHYSICAL;
            }
            if ("both".equals(codeString)) {
                return BOTH;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AddressType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case POSTAL: {
                    return "postal";
                }
                case PHYSICAL: {
                    return "physical";
                }
                case BOTH: {
                    return "both";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case POSTAL: {
                    return "http://hl7.org/fhir/address-type";
                }
                case PHYSICAL: {
                    return "http://hl7.org/fhir/address-type";
                }
                case BOTH: {
                    return "http://hl7.org/fhir/address-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case POSTAL: {
                    return "Mailing addresses - PO Boxes and care-of addresses.";
                }
                case PHYSICAL: {
                    return "A physical address that can be visited.";
                }
                case BOTH: {
                    return "An address that is both physical and postal.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case POSTAL: {
                    return "Postal";
                }
                case PHYSICAL: {
                    return "Physical";
                }
                case BOTH: {
                    return "Postal & Physical";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AddressUseEnumFactory
    implements EnumFactory<AddressUse> {
        @Override
        public AddressUse fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("home".equals(codeString)) {
                return AddressUse.HOME;
            }
            if ("work".equals(codeString)) {
                return AddressUse.WORK;
            }
            if ("temp".equals(codeString)) {
                return AddressUse.TEMP;
            }
            if ("old".equals(codeString)) {
                return AddressUse.OLD;
            }
            if ("billing".equals(codeString)) {
                return AddressUse.BILLING;
            }
            throw new IllegalArgumentException("Unknown AddressUse code '" + codeString + "'");
        }

        public Enumeration<AddressUse> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AddressUse>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("home".equals(codeString)) {
                return new Enumeration<AddressUse>(this, AddressUse.HOME);
            }
            if ("work".equals(codeString)) {
                return new Enumeration<AddressUse>(this, AddressUse.WORK);
            }
            if ("temp".equals(codeString)) {
                return new Enumeration<AddressUse>(this, AddressUse.TEMP);
            }
            if ("old".equals(codeString)) {
                return new Enumeration<AddressUse>(this, AddressUse.OLD);
            }
            if ("billing".equals(codeString)) {
                return new Enumeration<AddressUse>(this, AddressUse.BILLING);
            }
            throw new FHIRException("Unknown AddressUse code '" + codeString + "'");
        }

        @Override
        public String toCode(AddressUse code) {
            if (code == AddressUse.HOME) {
                return "home";
            }
            if (code == AddressUse.WORK) {
                return "work";
            }
            if (code == AddressUse.TEMP) {
                return "temp";
            }
            if (code == AddressUse.OLD) {
                return "old";
            }
            if (code == AddressUse.BILLING) {
                return "billing";
            }
            return "?";
        }

        @Override
        public String toSystem(AddressUse code) {
            return code.getSystem();
        }
    }

    public static enum AddressUse {
        HOME,
        WORK,
        TEMP,
        OLD,
        BILLING,
        NULL;


        public static AddressUse fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("home".equals(codeString)) {
                return HOME;
            }
            if ("work".equals(codeString)) {
                return WORK;
            }
            if ("temp".equals(codeString)) {
                return TEMP;
            }
            if ("old".equals(codeString)) {
                return OLD;
            }
            if ("billing".equals(codeString)) {
                return BILLING;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AddressUse code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case HOME: {
                    return "home";
                }
                case WORK: {
                    return "work";
                }
                case TEMP: {
                    return "temp";
                }
                case OLD: {
                    return "old";
                }
                case BILLING: {
                    return "billing";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case HOME: {
                    return "http://hl7.org/fhir/address-use";
                }
                case WORK: {
                    return "http://hl7.org/fhir/address-use";
                }
                case TEMP: {
                    return "http://hl7.org/fhir/address-use";
                }
                case OLD: {
                    return "http://hl7.org/fhir/address-use";
                }
                case BILLING: {
                    return "http://hl7.org/fhir/address-use";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case HOME: {
                    return "A communication address at a home.";
                }
                case WORK: {
                    return "An office address. First choice for business related contacts during business hours.";
                }
                case TEMP: {
                    return "A temporary address. The period can provide more detailed information.";
                }
                case OLD: {
                    return "This address is no longer in use (or was never correct but retained for records).";
                }
                case BILLING: {
                    return "An address to be used to send bills, invoices, receipts etc.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case HOME: {
                    return "Home";
                }
                case WORK: {
                    return "Work";
                }
                case TEMP: {
                    return "Temporary";
                }
                case OLD: {
                    return "Old / Incorrect";
                }
                case BILLING: {
                    return "Billing";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

