/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum VerificationresultPrimarySourceType {
    LICBOARD,
    PRIM,
    CONTED,
    POSTSERV,
    RELOWN,
    REGAUTH,
    LEGAL,
    ISSUER,
    AUTHSOURCE,
    NULL;


    public static VerificationresultPrimarySourceType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("lic-board".equals(codeString)) {
            return LICBOARD;
        }
        if ("prim".equals(codeString)) {
            return PRIM;
        }
        if ("cont-ed".equals(codeString)) {
            return CONTED;
        }
        if ("post-serv".equals(codeString)) {
            return POSTSERV;
        }
        if ("rel-own".equals(codeString)) {
            return RELOWN;
        }
        if ("reg-auth".equals(codeString)) {
            return REGAUTH;
        }
        if ("legal".equals(codeString)) {
            return LEGAL;
        }
        if ("issuer".equals(codeString)) {
            return ISSUER;
        }
        if ("auth-source".equals(codeString)) {
            return AUTHSOURCE;
        }
        throw new FHIRException("Unknown VerificationresultPrimarySourceType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case LICBOARD: {
                return "lic-board";
            }
            case PRIM: {
                return "prim";
            }
            case CONTED: {
                return "cont-ed";
            }
            case POSTSERV: {
                return "post-serv";
            }
            case RELOWN: {
                return "rel-own";
            }
            case REGAUTH: {
                return "reg-auth";
            }
            case LEGAL: {
                return "legal";
            }
            case ISSUER: {
                return "issuer";
            }
            case AUTHSOURCE: {
                return "auth-source";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/primary-source-type";
    }

    public String getDefinition() {
        switch (this) {
            case LICBOARD: {
                return "";
            }
            case PRIM: {
                return "";
            }
            case CONTED: {
                return "";
            }
            case POSTSERV: {
                return "";
            }
            case RELOWN: {
                return "";
            }
            case REGAUTH: {
                return "";
            }
            case LEGAL: {
                return "";
            }
            case ISSUER: {
                return "";
            }
            case AUTHSOURCE: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case LICBOARD: {
                return "License Board";
            }
            case PRIM: {
                return "Primary Education";
            }
            case CONTED: {
                return "Continuing Education";
            }
            case POSTSERV: {
                return "Postal Service";
            }
            case RELOWN: {
                return "Relationship owner";
            }
            case REGAUTH: {
                return "Registration Authority";
            }
            case LEGAL: {
                return "Legal source";
            }
            case ISSUER: {
                return "Issuing source";
            }
            case AUTHSOURCE: {
                return "Authoritative source";
            }
        }
        return "?";
    }
}

