/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ExPaymenttype {
    COMPLETE,
    PARTIAL,
    NULL;


    public static ExPaymenttype fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("complete".equals(codeString)) {
            return COMPLETE;
        }
        if ("partial".equals(codeString)) {
            return PARTIAL;
        }
        throw new FHIRException("Unknown ExPaymenttype code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case COMPLETE: {
                return "complete";
            }
            case PARTIAL: {
                return "partial";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/ex-paymenttype";
    }

    public String getDefinition() {
        switch (this) {
            case COMPLETE: {
                return "Complete (final) payment of the benefit under the Claim less any adjustments.";
            }
            case PARTIAL: {
                return "Partial payment of the benefit under the Claim less any adjustments.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case COMPLETE: {
                return "Complete";
            }
            case PARTIAL: {
                return "Partial";
            }
        }
        return "?";
    }
}

