/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.utils.client.network;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.internal.http2.Header;
import org.hl7.fhir.exceptions.FHIRException;

public class ClientHeaders {
    private final ArrayList<Header> headers;

    public ClientHeaders() {
        this.headers = new ArrayList();
    }

    public ClientHeaders(ArrayList<Header> headers) {
        this.headers = headers;
    }

    public ArrayList<Header> headers() {
        return this.headers;
    }

    public ClientHeaders addHeader(Header header) throws FHIRException {
        if (this.headers.contains(header)) {
            throw new FHIRException("Attempting to add duplicate header, <" + header.name + ", " + header.value + ">.");
        }
        this.headers.add(header);
        return this;
    }

    public ClientHeaders addHeaders(List<Header> headerList) throws FHIRException {
        headerList.forEach(this::addHeader);
        return this;
    }

    public ClientHeaders removeHeader(Header header) throws FHIRException {
        if (!this.headers.remove(header)) {
            throw new FHIRException("Attempting to remove header, <" + header.name + ", " + header.value + ">, from GenericClientHeaders that is not currently stored.");
        }
        return this;
    }

    public ClientHeaders removeHeaders(List<Header> headerList) throws FHIRException {
        headerList.forEach(this::removeHeader);
        return this;
    }

    public ClientHeaders clearHeaders() {
        this.headers.clear();
        return this;
    }

    public String toString() {
        return this.headers.stream().map(header -> "\t" + header.name + ":" + header.value).collect(Collectors.joining(",\n", "{\n", "\n}"));
    }
}

