/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ServiceProvisionConditions {
    FREE,
    DISC,
    COST,
    NULL;


    public static ServiceProvisionConditions fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("free".equals(codeString)) {
            return FREE;
        }
        if ("disc".equals(codeString)) {
            return DISC;
        }
        if ("cost".equals(codeString)) {
            return COST;
        }
        throw new FHIRException("Unknown ServiceProvisionConditions code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case FREE: {
                return "free";
            }
            case DISC: {
                return "disc";
            }
            case COST: {
                return "cost";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/service-provision-conditions";
    }

    public String getDefinition() {
        switch (this) {
            case FREE: {
                return "This service is available for no patient cost.";
            }
            case DISC: {
                return "There are discounts available on this service for qualifying patients.";
            }
            case COST: {
                return "Fees apply for this service.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case FREE: {
                return "Free";
            }
            case DISC: {
                return "Discounts Available";
            }
            case COST: {
                return "Fees apply";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

