/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum OccurrenceSpanCodes {
    _1001,
    _1002,
    NULL;


    public static OccurrenceSpanCodes fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("1001".equals(codeString)) {
            return _1001;
        }
        if ("1002".equals(codeString)) {
            return _1002;
        }
        throw new FHIRException("Unknown OccurrenceSpanCodes code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _1001: {
                return "1001";
            }
            case _1002: {
                return "1002";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-claimoccurrancespan";
    }

    public String getDefinition() {
        switch (this) {
            case _1001: {
                return "Occurrance Span 1001 description.";
            }
            case _1002: {
                return "Occurrance Span 1002 description.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _1001: {
                return "Occurrance Span 1001";
            }
            case _1002: {
                return "Occurrance Span 1002";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

