/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MedicationRequestCategory {
    INPATIENT,
    OUTPATIENT,
    COMMUNITY,
    NULL;


    public static MedicationRequestCategory fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("inpatient".equals(codeString)) {
            return INPATIENT;
        }
        if ("outpatient".equals(codeString)) {
            return OUTPATIENT;
        }
        if ("community".equals(codeString)) {
            return COMMUNITY;
        }
        throw new FHIRException("Unknown MedicationRequestCategory code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INPATIENT: {
                return "inpatient";
            }
            case OUTPATIENT: {
                return "outpatient";
            }
            case COMMUNITY: {
                return "community";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/medication-request-category";
    }

    public String getDefinition() {
        switch (this) {
            case INPATIENT: {
                return "Includes orders for medications to be administered or consumed in an inpatient or acute care setting";
            }
            case OUTPATIENT: {
                return "Includes orders for medications to be administered or consumed in an outpatient setting (for example, Emergency Department, Outpatient Clinic, Outpatient Surgery, Doctor's office)";
            }
            case COMMUNITY: {
                return "Includes orders for medications to be administered or consumed by the patient in their home (this would include long term care or nursing homes, hospices, etc)";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INPATIENT: {
                return "Inpatient";
            }
            case OUTPATIENT: {
                return "Outpatient";
            }
            case COMMUNITY: {
                return "Community";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

